/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.webdav;

import com.sas.contentserver.j2ee.SASSessionProviderImpl;
import com.sas.contentserver.security.SASCredentialsProvider;
import com.sas.contentserver.webdav.SASDavSessionProviderImpl;
import com.sas.contentserver.webdav.SASLocatorFactoryImplEx;
import com.sas.contentserver.webdav.SASResourceFactoryImpl;
import com.sas.contentserver.webdav.SearchInfoHelper;
import com.sas.framework.webapp.servlet.sanitizers.DefaultCrossSiteScriptingSanitizer;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import javax.servlet.ServletOutputStream;
import org.apache.jackrabbit.j2ee.SimpleWebdavServlet;
import org.apache.jackrabbit.server.CredentialsProvider;
import org.apache.jackrabbit.server.SessionProvider;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.search.SearchInfo;
import org.apache.jackrabbit.webdav.search.SearchResource;
import org.w3c.dom.Document;

public class SASWebdavServlet
extends SimpleWebdavServlet {
    private static final long serialVersionUID = -1976187345755784258L;
    private DavLocatorFactory locatorFactory;
    private SessionProvider sessionProvider;

    public DavResourceFactory getResourceFactory() {
        if (!(super.getResourceFactory() instanceof SASResourceFactoryImpl)) {
            super.setResourceFactory((DavResourceFactory)new SASResourceFactoryImpl(this.getLockManager(), this.getResourceConfig()));
        }
        return super.getResourceFactory();
    }

    public DavLocatorFactory getLocatorFactory() {
        if (this.locatorFactory == null) {
            this.locatorFactory = new SASLocatorFactoryImplEx(super.getPathPrefix());
        }
        return this.locatorFactory;
    }

    protected CredentialsProvider getCredentialsProvider() {
        return new SASCredentialsProvider(this.getInitParameter("missing-auth-mapping"));
    }

    public synchronized SessionProvider getSessionProvider() {
        if (this.sessionProvider == null) {
            this.sessionProvider = new SASSessionProviderImpl(this.getCredentialsProvider());
            super.setSessionProvider(this.sessionProvider);
        }
        return this.sessionProvider;
    }

    public synchronized DavSessionProvider getDavSessionProvider() {
        if (this.davSessionProvider == null) {
            this.davSessionProvider = new SASDavSessionProviderImpl(this.getRepository(), this.getSessionProvider());
        }
        return this.davSessionProvider;
    }

    @SuppressWarnings(value={"NP_NULL_PARAM_DEREF"}, justification="Correct and expected behavior")
    protected void doSearch(WebdavRequest request, WebdavResponse response, DavResource resource) throws DavException, IOException {
        if (!(resource instanceof SearchResource)) {
            response.sendError(405);
            return;
        }
        Document doc = request.getRequestDocument();
        if (doc != null) {
            SearchInfo sR = SearchInfoHelper.createFromXml(doc.getDocumentElement());
            response.sendMultiStatus(((SearchResource)resource).search(sR));
        } else {
            response.sendMultiStatus(((SearchResource)resource).search(null));
        }
    }

    protected void doOptions(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        super.doOptions(request, response, resource);
        if (resource instanceof SearchResource) {
            response.addHeader("DASL", "<DAV:basicsearch>");
        }
    }

    protected void doPut(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        DefaultCrossSiteScriptingSanitizer sanitizer = new DefaultCrossSiteScriptingSanitizer();
        if (sanitizer.matches(request.getPathInfo())) {
            response.sendError(400);
        } else {
            super.doPut(request, response, resource);
        }
    }

    protected void doDelete(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        DavResource parent = resource.getCollection();
        if (!parent.exists() && resource.exists()) {
            response.sendError(403);
            return;
        }
        super.doDelete(request, response, resource);
    }

    protected void doCheckin(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        if (resource.getLocks().length > 0) {
            response.sendError(423);
            return;
        }
        super.doCheckin(request, response, resource);
    }

    protected void doPropPatch(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        if (URLDecoder.decode(resource.getHref(), Charset.defaultCharset().name()).contains("/rep:security/rep:authorizables/rep:users/")) {
            response.sendError(403);
            return;
        }
        super.doPropPatch(request, response, resource);
    }

    protected void doGet(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        if (resource.isCollection()) {
            ServletOutputStream out = response.getOutputStream();
            resource.spool(this.getOutputContext((DavServletResponse)response, (OutputStream)out));
            response.flushBuffer();
        } else {
            super.doGet(request, response, resource);
        }
    }
}

