/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.webdav;

import com.sas.contentserver.commons.SpecialNameChars;
import com.sas.contentserver.core.session.SASSessionImpl;
import com.sas.contentserver.security.SASDefaultAccessManager;
import com.sas.framework.commons.TenantIdentifier;
import com.sas.framework.commons.holders.TenantHolder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.Privilege;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.server.SessionProvider;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.simple.DavSessionImpl;
import org.apache.jackrabbit.webdav.simple.DavSessionProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASDavSessionProviderImpl
extends DavSessionProviderImpl {
    private static Logger log = LoggerFactory.getLogger(SASDavSessionProviderImpl.class);
    private Repository rep;
    private SessionProvider sesProvider;

    public SASDavSessionProviderImpl(Repository rep, SessionProvider sesProvider) {
        super(rep, sesProvider);
        this.rep = rep;
        this.sesProvider = sesProvider;
    }

    public boolean attachSession(WebdavRequest request) throws DavException {
        try {
            String workspaceName = request.getRequestLocator().getWorkspaceName();
            if (workspaceName != null && "".equals(workspaceName)) {
                workspaceName = null;
            }
            HttpSession httpSession = request.getSession();
            DavSessionImpl ds = null;
            Session jcrSession = null;
            boolean bCreatedJcrSession = true;
            if (httpSession.isNew()) {
                jcrSession = this.sesProvider.getSession((HttpServletRequest)request, this.rep, workspaceName);
                if (jcrSession == null) {
                    log.debug("Could not to retrieve a repository session.");
                    return false;
                }
                httpSession.setAttribute("JCR-SESSION", (Object)jcrSession);
                httpSession.setAttribute("tenantId", (Object)TenantHolder.get().getId());
                ds = new DavSessionImpl(jcrSession);
            } else {
                log.debug("Using an existing http session '" + httpSession.getId() + "', created at '" + httpSession.getCreationTime() + "' and last accessed at '" + httpSession.getLastAccessedTime() + "'");
                jcrSession = (Session)httpSession.getAttribute("JCR-SESSION");
                Integer tenantId = (Integer)httpSession.getAttribute("tenantId");
                if (jcrSession == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("No existing session on http session. Creating new one");
                    }
                    if ((jcrSession = this.sesProvider.getSession((HttpServletRequest)request, this.rep, workspaceName)) == null) {
                        log.debug("Could not to retrieve a repository session.");
                        return false;
                    }
                    httpSession.setAttribute("JCR-SESSION", (Object)jcrSession);
                    tenantId = TenantHolder.get().getId();
                    httpSession.setAttribute("tenantId", (Object)tenantId);
                } else {
                    bCreatedJcrSession = false;
                }
                ds = new DavSessionImpl(jcrSession);
                TenantHolder.set((TenantIdentifier)new TenantIdentifier(tenantId.intValue(), "Server"));
            }
            log.debug("Attaching session '" + ds + "' to HttpSession '" + httpSession.getId() + "' for '" + request.getMethod() + "' request by user '" + jcrSession.getUserID() + "'");
            request.setDavSession((DavSession)ds);
            if (bCreatedJcrSession) {
                Set<Principal> principals = ((SessionImpl)jcrSession).getSubject().getPrincipals();
                for (Principal principal : principals) {
                    if (!(principal instanceof PrincipalImpl) || principal instanceof GroupPrincipal) continue;
                    this.createUserFolder(jcrSession, principal.getName());
                    break;
                }
            }
            jcrSession.refresh(false);
            return true;
        }
        catch (NoSuchWorkspaceException e) {
            throw new JcrDavException((Throwable)e, 404);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
        catch (ServletException e) {
            throw new DavException(500, e.getMessage());
        }
        catch (Exception e) {
            throw new DavException(500, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createUserFolder(Session jcrSession, String username) throws RepositoryException {
        block10: {
            SASSessionImpl session = (SASSessionImpl)jcrSession;
            try {
                session.doAdmin();
                String userNodeName = SpecialNameChars.encode(username);
                String userWorkspace = "/sasdav/Users/" + userNodeName;
                if (session.itemExists(userWorkspace)) break block10;
                try {
                    String ownerID = jcrSession.getUserID();
                    Node usersNode = (Node)session.getItem("/sasdav/Users/");
                    Node pNode = usersNode.addNode(userNodeName, "nt:davcollection");
                    pNode.setProperty("jcr:owner", ownerID);
                    String prefix = null;
                    try {
                        prefix = session.getNamespacePrefix("http://www.sas.com/rnd/itech/WebDAV");
                    }
                    catch (NamespaceException nse) {
                        NamespaceRegistry nsReg = session.getWorkspace().getNamespaceRegistry();
                        boolean found = false;
                        int index = 1;
                        while (!found) {
                            try {
                                session.getNamespaceURI("sas" + index);
                                ++index;
                            }
                            catch (NamespaceException nse2) {
                                found = true;
                                prefix = "sas" + index;
                                nsReg.registerNamespace(prefix, "http://www.sas.com/rnd/itech/WebDAV");
                            }
                        }
                    }
                    pNode.setProperty(prefix + ":type", "person");
                    SASDefaultAccessManager adminAcMan = (SASDefaultAccessManager)session.getAccessControlManager();
                    ArrayList<Privilege> privs = new ArrayList<Privilege>();
                    privs.add(adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}read"));
                    privs.add(adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-read"));
                    privs.add(adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}write"));
                    privs.add(adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-write"));
                    privs.add(adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-delete"));
                    privs.add(adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}admin"));
                    privs.add(adminAcMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-admin"));
                    adminAcMan.grantPrivileges(session.getPrincipalManager().getPrincipal(username), pNode.getPath(), privs, null);
                    session.save();
                    adminAcMan.removeAceForPrincipal(pNode, session.getPrincipalManager().getPrincipal("jcr:authenticated"));
                    session.save();
                }
                catch (PathNotFoundException pathNotFoundException) {
                    // empty catch block
                }
            }
            finally {
                session.endAdmin();
            }
        }
    }

    public void releaseSession(WebdavRequest request) {
        DavSession ds;
        if (log.isDebugEnabled() && (ds = request.getDavSession()) != null && ds instanceof DavSessionImpl) {
            Session repSession = ((DavSessionImpl)ds).getRepositorySession();
            HttpSession httpSession = request.getSession(false);
            String sessionId = "unknown";
            if (httpSession != null) {
                sessionId = httpSession.getId();
            }
            log.debug("Releasing session '" + ds + "' from HttpSession '" + sessionId + "' for user '" + repSession.getUserID() + "'");
        }
        request.setDavSession(null);
    }
}

