/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.util;

import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DistributedLock {
    private static Lock repositoryStartupLock = null;
    private static Logger log = LoggerFactory.getLogger(DistributedLock.class);

    public static void lock() {
        if (repositoryStartupLock != null) {
            log.info("Instance id = " + System.getProperty("sas.appserver.instance.id") + " obtaining distributed lock...");
            repositoryStartupLock.lock();
        }
    }

    public static void unlock() {
        if (repositoryStartupLock != null) {
            log.info("Instance id = " + System.getProperty("sas.appserver.instance.id") + " releasing distributed lock...");
            repositoryStartupLock.unlock();
        }
    }

    @Autowired
    public void setRepositoryStartupLock(Lock repositoryStartupLock) {
        DistributedLock.repositoryStartupLock = repositoryStartupLock;
    }
}

