/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.springextensions.jcr;

import com.sas.contentserver.springextensions.jcr.JcrSystemException;
import com.sas.contentserver.springextensions.jcr.SessionFactory;
import com.sas.contentserver.springextensions.jcr.SessionHolder;
import java.io.IOException;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.MergeException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.version.VersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class SessionFactoryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SessionFactoryUtils.class);

    public static Session doGetSession(SessionFactory sessionFactory, boolean allowCreate) throws RepositoryException {
        Assert.notNull((Object)sessionFactory, (String)"No sessionFactory specified");
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null && sessionHolder.getSession() != null) {
            return sessionHolder.getSession();
        }
        if (!allowCreate && !TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("No session bound to thread, and configuration does not allow creation of non-transactional one here");
        }
        LOG.debug("Opening JCR Session");
        Session session = sessionFactory.getSession();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            LOG.debug("Registering transaction synchronization for JCR session");
            sessionHolder = sessionFactory.getSessionHolder(session);
            sessionHolder.setSynchronizedWithTransaction(true);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new JcrSessionSynchronization(sessionHolder, sessionFactory));
            TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
        }
        return session;
    }

    public static Session getSession(SessionFactory sessionFactory, boolean allowCreate) throws DataAccessException {
        try {
            return SessionFactoryUtils.doGetSession(sessionFactory, allowCreate);
        }
        catch (RepositoryException ex) {
            throw new DataAccessResourceFailureException("Could not open Jcr Session", (Throwable)ex);
        }
    }

    public static boolean isSessionThreadBound(Session session, SessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return false;
        }
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        return sessionHolder != null && session == sessionHolder.getSession();
    }

    public static void releaseSession(Session session, SessionFactory sessionFactory) {
        if (session == null) {
            return;
        }
        if (!SessionFactoryUtils.isSessionThreadBound(session, sessionFactory)) {
            LOG.debug("Closing JCR Session");
            session.logout();
        }
    }

    public static DataAccessException translateException(RepositoryException ex) {
        if (ex instanceof AccessDeniedException) {
            return new DataRetrievalFailureException("Access denied to this data", (Throwable)ex);
        }
        if (ex instanceof ConstraintViolationException) {
            return new DataIntegrityViolationException("Constraint has been violated", (Throwable)ex);
        }
        if (ex instanceof InvalidItemStateException) {
            return new ConcurrencyFailureException("Invalid item state", (Throwable)ex);
        }
        if (ex instanceof InvalidQueryException) {
            return new DataRetrievalFailureException("Invalid query", (Throwable)ex);
        }
        if (ex instanceof InvalidSerializedDataException) {
            return new DataRetrievalFailureException("Invalid serialized data", (Throwable)ex);
        }
        if (ex instanceof ItemExistsException) {
            return new DataIntegrityViolationException("An item already exists", (Throwable)ex);
        }
        if (ex instanceof ItemNotFoundException) {
            return new DataRetrievalFailureException("Item not found", (Throwable)ex);
        }
        if (ex instanceof LoginException) {
            return new DataAccessResourceFailureException("Bad login", (Throwable)ex);
        }
        if (ex instanceof LockException) {
            return new ConcurrencyFailureException("Item is locked", (Throwable)ex);
        }
        if (ex instanceof MergeException) {
            return new DataIntegrityViolationException("Merge failed", (Throwable)ex);
        }
        if (ex instanceof NamespaceException) {
            return new InvalidDataAccessApiUsageException("Namespace not registred", (Throwable)ex);
        }
        if (ex instanceof NoSuchNodeTypeException) {
            return new InvalidDataAccessApiUsageException("No such node type", (Throwable)ex);
        }
        if (ex instanceof NoSuchWorkspaceException) {
            return new DataAccessResourceFailureException("Workspace not found", (Throwable)ex);
        }
        if (ex instanceof PathNotFoundException) {
            return new DataRetrievalFailureException("Path not found", (Throwable)ex);
        }
        if (ex instanceof ReferentialIntegrityException) {
            return new DataIntegrityViolationException("Referential integrity violated", (Throwable)ex);
        }
        if (ex instanceof UnsupportedRepositoryOperationException) {
            return new InvalidDataAccessApiUsageException("Unsupported operation", (Throwable)ex);
        }
        if (ex instanceof ValueFormatException) {
            return new InvalidDataAccessApiUsageException("Incorrect value format", (Throwable)ex);
        }
        if (ex instanceof VersionException) {
            return new DataIntegrityViolationException("Invalid version graph operation", (Throwable)ex);
        }
        return new JcrSystemException(ex);
    }

    public static DataAccessException translateException(IOException ex) {
        return new DataAccessResourceFailureException("I/O failure", (Throwable)ex);
    }

    private static class JcrSessionSynchronization
    extends TransactionSynchronizationAdapter {
        private final SessionHolder sessionHolder;
        private final SessionFactory sessionFactory;
        private boolean holderActive = true;

        public JcrSessionSynchronization(SessionHolder holder, SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
            this.sessionHolder = holder;
        }

        public void suspend() {
            if (this.holderActive) {
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            }
        }

        public void resume() {
            if (this.holderActive) {
                TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
            }
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            this.holderActive = false;
            SessionFactoryUtils.releaseSession(this.sessionHolder.getSession(), this.sessionFactory);
        }
    }
}

