/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.security;

import com.sas.contentserver.commons.SpecialNameChars;
import java.security.Principal;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.user.MembershipCache;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASUserManagerImpl
extends UserManagerImpl {
    static Logger log = LoggerFactory.getLogger(SASUserManagerImpl.class);
    private String adminId;

    public SASUserManagerImpl(SessionImpl session, String adminId) throws RepositoryException {
        super(session, adminId);
        this.adminId = adminId;
    }

    public SASUserManagerImpl(SessionImpl session, String adminId, Properties config) throws RepositoryException {
        super(session, adminId, config);
        this.adminId = adminId;
    }

    public SASUserManagerImpl(SessionImpl session, String adminId, Properties config, MembershipCache mCache) throws RepositoryException {
        super(session, adminId, config, mCache);
        this.adminId = adminId;
    }

    public String getAdminId() {
        return this.adminId;
    }

    public Authorizable getAuthorizable(String id) throws RepositoryException {
        return super.getAuthorizable(SpecialNameChars.encode(id));
    }

    public Authorizable getAuthorizable(Principal principal) throws RepositoryException {
        Authorizable ret = null;
        ret = this.getAuthorizable(SpecialNameChars.encode(principal.getName()));
        return ret;
    }

    public User createUser(String userID, String password, Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        String encodedId = SpecialNameChars.encode(userID);
        if (encodedId.equals(userID)) {
            return super.createUser(userID, password, principal, intermediatePath);
        }
        return super.createUser(encodedId, password, (Principal)new UserPrincipal(encodedId), intermediatePath);
    }

    public Group createGroup(String groupID, Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        String encodedId = SpecialNameChars.encode(groupID);
        if (encodedId.equals(groupID)) {
            return super.createGroup(groupID, principal, intermediatePath);
        }
        return super.createGroup(encodedId, (Principal)new PrincipalImpl(encodedId), intermediatePath);
    }
}

