/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.security;

import com.sas.contentserver.core.TenantRepositoryImpl;
import com.sas.contentserver.core.config.PrincipalProviderConfig;
import com.sas.contentserver.core.config.SASSecurityManagerConfig;
import java.lang.reflect.Field;
import java.util.Properties;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.DefaultSecurityManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.apache.jackrabbit.core.security.principal.PrincipalProviderRegistry;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASDefaultSecurityManager
extends DefaultSecurityManager {
    private Logger log = LoggerFactory.getLogger(SASDefaultSecurityManager.class);
    Session systemSession;

    public synchronized void init(Repository repository, Session systemSession) throws RepositoryException {
        super.init(repository, systemSession);
        this.systemSession = systemSession;
        this.createDefaultGroups();
    }

    private void createDefaultGroups() throws RepositoryException {
        UserManager userMgr = super.getSystemUserManager(null);
        if (userMgr.getAuthorizable("jcr:all") == null) {
            userMgr.createGroup("jcr:all");
        }
        if (userMgr.getAuthorizable("jcr:authenticated") == null) {
            userMgr.createGroup("jcr:authenticated");
        }
        if (userMgr.getAuthorizable("jcr:unauthenticated") == null) {
            userMgr.createGroup("jcr:unauthenticated");
        }
        if (userMgr.getAuthorizable("jcr:owner") == null) {
            userMgr.createGroup("jcr:owner");
        }
        if (userMgr.getAuthorizable("SASUSERS") == null) {
            userMgr.createGroup("SASUSERS");
        }
        if (!userMgr.isAutoSave() && this.systemSession.hasPendingChanges()) {
            this.systemSession.save();
        }
    }

    protected PrincipalProvider createDefaultPrincipalProvider(Properties[] moduleConfig) throws RepositoryException {
        try {
            Field systemUserManagerField = DefaultSecurityManager.class.getDeclaredField("systemUserManager");
            systemUserManagerField.setAccessible(true);
            UserManagerImpl systemUserManager = (UserManagerImpl)systemUserManagerField.get((Object)this);
            PrincipalProviderConfig ppConfig = ((SASSecurityManagerConfig)this.getConfig()).getPrincipalProviderConfig();
            Class[] paramTypes = new Class[]{Session.class, UserManagerImpl.class, Properties.class};
            Properties params = ppConfig.getParameters();
            PrincipalProvider principalProvider = ppConfig.getPrincipalProvider(PrincipalProvider.class, paramTypes, this.getSystemSession(), systemUserManager, params);
            principalProvider.init(new Properties());
            return principalProvider;
        }
        catch (Exception e) {
            this.log.error("Error creating SASDefaultSecurityManager", (Throwable)e);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public PrincipalProvider createUserPrincipalProvider(Session systemSession) throws RepositoryException {
        try {
            PrincipalProviderConfig ppConfig = ((SASSecurityManagerConfig)this.getConfig()).getPrincipalProviderConfig();
            Class[] paramTypes = new Class[]{Session.class, UserManagerImpl.class, Properties.class};
            Properties params = ppConfig.getParameters();
            PrincipalProvider principalProvider = ppConfig.getPrincipalProvider(PrincipalProvider.class, paramTypes, systemSession, ((SessionImpl)systemSession).getUserManager(), params);
            principalProvider.init(new Properties());
            return principalProvider;
        }
        catch (Exception e) {
            this.log.error("Error creating SASDefaultSecurityManager", (Throwable)e);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    protected UserManager getSystemUserManager(String workspaceName) throws RepositoryException {
        return ((TenantRepositoryImpl)this.getRepository()).getSystemSession(workspaceName).getUserManager();
    }

    public PrincipalProviderRegistry getPrincipalProviderRegistry() {
        return super.getPrincipalProviderRegistry();
    }

    protected Session getSystemSession() {
        try {
            return ((TenantRepositoryImpl)this.getRepository()).getSystemSession(((RepositoryImpl)this.getRepository()).getConfig().getDefaultWorkspaceName());
        }
        catch (NoSuchWorkspaceException e) {
            return null;
        }
        catch (RepositoryException e) {
            return null;
        }
    }
}

