/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.security;

import com.sas.contentserver.security.NonInheritingAclProvider;
import com.sas.framework.commons.holders.TenantHolder;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.AccessControlUtils;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.PrivilegeManagerImpl;
import org.apache.jackrabbit.core.security.authorization.acl.CompiledPermissionsImpl;
import org.apache.jackrabbit.core.security.authorization.acl.EntryCollector;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASACLProvider
extends NonInheritingAclProvider {
    private static final Logger log = LoggerFactory.getLogger(SASACLProvider.class);
    private static final Path VERSION_STORAGE_PATH = PathFactoryImpl.getInstance().create("{}\t{http://www.jcp.org/jcr/1.0}system\t{http://www.jcp.org/jcr/1.0}versionStorage");
    private Principal jcrAll;
    private Principal jcrAuthenticated;
    private Principal groupSASUsers;
    private static final Map<Integer, Boolean> INITIALIZED = new HashMap<Integer, Boolean>();

    @Override
    public void init(Session systemSession, Map configuration) throws RepositoryException {
        super.init(systemSession, configuration);
        this.jcrAll = this.session.getUserManager().getAuthorizable("jcr:all").getPrincipal();
        this.jcrAuthenticated = this.session.getUserManager().getAuthorizable("jcr:authenticated").getPrincipal();
        this.groupSASUsers = this.session.getUserManager().getAuthorizable("SASUSERS").getPrincipal();
        this.installDefaultPermissions();
    }

    public CompiledPermissions compilePermissions(Set<Principal> principals) throws RepositoryException {
        Set<Principal> jcrPrincipals = this.convertToJCRPrincipals(principals);
        this.checkInitialized();
        if (this.isAdminOrSystem(jcrPrincipals)) {
            return this.getAdminPermissions();
        }
        return new SASCompiledPermissions(jcrPrincipals, this.session, this.entryCollector, (AccessControlUtils)this, true);
    }

    public Set<Principal> convertToJCRPrincipals(Set<Principal> principals) throws RepositoryException {
        HashSet<Principal> jcrPrincipals = new HashSet<Principal>();
        if (!principals.contains(new AdminPrincipal("admin"))) {
            jcrPrincipals.add(this.jcrAll);
            jcrPrincipals.add(this.jcrAuthenticated);
            jcrPrincipals.add(this.groupSASUsers);
        }
        for (Principal principal : principals) {
            if (!(principal instanceof AdminPrincipal) && !(principal instanceof SystemPrincipal) && !(principal instanceof EveryonePrincipal) && !(principal instanceof ItemBasedPrincipal)) continue;
            jcrPrincipals.add(principal);
        }
        return jcrPrincipals;
    }

    private void installPermissions(String path, Principal principal, Privilege[] privs, AccessControlEditor editor, Map<String, Value> restrictions) throws AccessDeniedException, AccessControlException, RepositoryException {
        AccessControlPolicy[] acls = editor.editAccessControlPolicies(path);
        if (acls.length == 0) {
            acls = editor.getPolicies(path);
        }
        if (acls.length > 0) {
            JackrabbitAccessControlList acl = (JackrabbitAccessControlList)acls[0];
            for (AccessControlEntry entry : acl.getAccessControlEntries()) {
                if (!entry.getPrincipal().getName().equals(principal.getName()) || privs.length != entry.getPrivileges().length) continue;
                List<Privilege> existing = Arrays.asList(entry.getPrivileges());
                boolean matches = true;
                for (Privilege priv : privs) {
                    if (existing.contains(priv)) continue;
                    matches = false;
                }
                if (!matches) continue;
                return;
            }
            acl.addEntry(principal, privs, true, restrictions);
            log.info("setting initial policy for " + principal.getName());
            editor.setPolicy(acl.getPath(), (AccessControlPolicy)acl);
        }
    }

    public boolean canAccessRoot(Set<Principal> principals) throws RepositoryException {
        return super.canAccessRoot(this.convertToJCRPrincipals(principals));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installDefaultPermissions() throws RepositoryException {
        Map<Integer, Boolean> map = INITIALIZED;
        synchronized (map) {
            Boolean init = INITIALIZED.get(TenantHolder.get().getId());
            if (init == null || !init.booleanValue()) {
                ValueFactory vf = this.session.getValueFactory();
                HashMap<String, Value> restrictions = new HashMap<String, Value>();
                restrictions.put(this.session.getJCRName(NameConstants.REP_NODE_PATH), vf.createValue(this.session.getRootNode().getPath(), 8));
                restrictions.put(this.session.getJCRName(NameConstants.REP_GLOB), this.session.getValueFactory().createValue("", 1));
                this.installPermissions(null, (Principal)EveryonePrincipal.getInstance(), new Privilege[]{this.session.getAccessControlManager().privilegeFromName(NameConstants.JCR_NAMESPACE_MANAGEMENT.toString())}, this.getEditor((Session)this.session), null);
                this.installPermissions(this.session.getRootNode().getPath(), (Principal)EveryonePrincipal.getInstance(), new Privilege[]{this.session.getAccessControlManager().privilegeFromName("{http://www.jcp.org/jcr/1.0}read")}, this.getEditor((Session)this.session), restrictions);
                this.session.save();
                INITIALIZED.put(TenantHolder.get().getId(), true);
            }
        }
    }

    private class SASCompiledPermissions
    extends CompiledPermissionsImpl {
        SASCompiledPermissions(Set<Principal> principals, SessionImpl session, EntryCollector entryCollector, AccessControlUtils util, boolean listenToEvents) throws RepositoryException {
            super(principals, session, entryCollector, util, listenToEvents);
        }

        public boolean canRead(Path itemPath, ItemId itemId) throws RepositoryException {
            Path absPath = itemPath;
            ItemId id = itemId;
            if (absPath == null && id != null) {
                absPath = SASACLProvider.this.session.getHierarchyManager().getPath(id);
            } else if (absPath != null && id == null) {
                id = SASACLProvider.this.session.getHierarchyManager().resolvePath(absPath);
            }
            if (absPath != null && id != null) {
                if (!absPath.isDescendantOf(VERSION_STORAGE_PATH)) {
                    if (!id.denotesNode()) {
                        if (absPath.getString().contains("{http://www.jcp.org/jcr/1.0}content")) {
                            return super.canRead(absPath.getAncestor(2), null);
                        }
                        if (absPath.getString().contains("{internal}policy")) {
                            return this.canRead(absPath.getAncestor(2), null);
                        }
                        return super.canRead(null, (ItemId)((PropertyId)id).getParentId());
                    }
                    if (absPath.getString().contains("{http://www.jcp.org/jcr/1.0}content")) {
                        return super.canRead(absPath.getAncestor(1), null);
                    }
                    if (absPath.getString().contains("{internal}policy")) {
                        if (absPath.getString().endsWith("{internal}policy")) {
                            return super.canRead(absPath.getAncestor(1), null);
                        }
                        return super.canRead(absPath.getAncestor(2), null);
                    }
                    return super.canRead(itemPath, itemId);
                }
                ItemManager itemMgr = SASACLProvider.this.session.getItemManager();
                NodeId nodeId = id.denotesNode() ? (NodeId)id : ((PropertyId)id).getParentId();
                NodeImpl node = (NodeImpl)itemMgr.getItem((ItemId)nodeId);
                String nodeIdString = null;
                if (node instanceof Version) {
                    NodeImpl frozenNode = (NodeImpl)node.getNode("jcr:frozenNode");
                    nodeIdString = frozenNode.getProperty("jcr:frozenUuid").getString();
                } else if (node instanceof VersionHistory) {
                    nodeIdString = ((VersionHistory)node).getVersionableIdentifier();
                } else if (node.isNodeType("nt:frozenNode")) {
                    nodeIdString = node.getProperty("jcr:frozenUuid").getString();
                    if (node.getName().equals("jcr:content")) {
                        nodeIdString = node.getParent().getProperty("jcr:frozenUuid").getString();
                    }
                }
                if (nodeId != null) {
                    return super.canRead(null, (ItemId)new NodeId(nodeIdString));
                }
                log.error("Invalid nodetype in version storage " + node.getPath() + ", node type " + node.getPrimaryNodeType().getName());
            }
            return super.canRead(itemPath, itemId);
        }

        protected AbstractCompiledPermissions.Result buildResult(Path absPath) throws RepositoryException {
            ItemId itemId = SASACLProvider.this.session.getHierarchyManager().resolvePath(absPath);
            String path = SASACLProvider.this.session.getJCRPath(absPath);
            if (itemId != null) {
                if (!absPath.isDescendantOf(VERSION_STORAGE_PATH)) {
                    if (!itemId.denotesNode()) {
                        if (path.contains("jcr:content")) {
                            return super.buildResult(absPath.getAncestor(2));
                        }
                        return super.buildResult(absPath.getAncestor(1));
                    }
                    if (path.contains("jcr:content")) {
                        return super.buildResult(absPath.getAncestor(1));
                    }
                } else {
                    NodeImpl node = SASACLProvider.this.session.getNodeById((NodeId)itemId);
                    String nodeId = null;
                    if (node instanceof Version) {
                        NodeImpl frozenNode = (NodeImpl)node.getNode("jcr:frozenNode");
                        nodeId = frozenNode.getProperty("jcr:frozenUuid").getString();
                    } else if (node instanceof VersionHistory) {
                        nodeId = ((VersionHistory)node).getVersionableIdentifier();
                    } else if (node.isNodeType("nt:frozenNode")) {
                        nodeId = node.getProperty("jcr:frozenUuid").getString();
                        if (node.getName().equals("jcr:content")) {
                            nodeId = node.getParent().getProperty("jcr:frozenUuid").getString();
                        }
                    }
                    if (nodeId != null) {
                        return super.buildResult(SASACLProvider.this.session.getHierarchyManager().getPath((ItemId)new NodeId(nodeId)));
                    }
                    log.error("Invalid nodetype in version storage " + node.getPrimaryNodeType());
                }
            } else {
                if (path.contains("jcr:content") && !path.substring(path.lastIndexOf(47) + 1, path.length()).equals("jcr:content")) {
                    return this.buildResult(absPath.getAncestor(2));
                }
                return this.buildResult(absPath.getAncestor(1));
            }
            return super.buildResult(absPath);
        }

        protected PrivilegeManagerImpl getPrivilegeManagerImpl() throws RepositoryException {
            return SASACLProvider.this.getPrivilegeManagerImpl();
        }
    }
}

