/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.security;

import com.sas.contentserver.commons.SpecialNameChars;
import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.core.security.principal.DefaultPrincipalProvider;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRPrincipalProvider
extends DefaultPrincipalProvider {
    Logger log = LoggerFactory.getLogger(OMRPrincipalProvider.class);
    private String repositoryId = null;
    private MdFactory jomaMdFact = null;
    private Properties params = null;
    private Session session = null;
    private UserManagerImpl userMgr = null;
    private boolean initialized = false;
    private Set<String> defaultPrincipalNames;
    private Map<String, Long> principalsCache;

    public OMRPrincipalProvider(Session systemSession, UserManagerImpl systemUserManager, Properties params) throws RepositoryException {
        super(systemSession, systemUserManager);
        this.session = systemSession;
        this.userMgr = systemUserManager;
        this.params = params;
        this.defaultPrincipalNames = new HashSet<String>();
        this.defaultPrincipalNames.add("jcr:all");
        this.defaultPrincipalNames.add("jcr:authenticated");
        this.defaultPrincipalNames.add("jcr:unauthenticated");
        this.defaultPrincipalNames.add("jcr:owner");
        this.defaultPrincipalNames.add("SASUSERS");
        this.defaultPrincipalNames.add(EveryonePrincipal.getInstance().getName());
        this.principalsCache = new HashMap<String, Long>();
    }

    public synchronized void init(Properties options) {
        if (this.initialized) {
            return;
        }
        super.init(options);
        this.initialized = true;
    }

    public synchronized Principal getPrincipal(String principalName) {
        Principal ret = super.getPrincipal(SpecialNameChars.encode(principalName));
        try {
            if (!this.defaultPrincipalNames.contains(principalName) && !this.isCached(principalName)) {
                PrincipalType type = this.existsInOMR(principalName);
                if (ret != null || type != null) {
                    Authorizable auth;
                    if (ret == null && type != null) {
                        if (type == PrincipalType.USER) {
                            this.userMgr.createUser(SpecialNameChars.encode(principalName), "");
                        } else {
                            this.userMgr.createGroup(SpecialNameChars.encode(principalName));
                        }
                        if (!this.userMgr.isAutoSave() && this.session.hasPendingChanges()) {
                            this.session.save();
                        }
                        ret = super.getPrincipal(SpecialNameChars.encode(principalName));
                    } else if (ret != null && type == null && (auth = this.userMgr.getAuthorizable(ret)) != null) {
                        auth.remove();
                        if (!this.userMgr.isAutoSave() && this.session.hasPendingChanges()) {
                            this.session.save();
                        }
                        ret = null;
                    }
                }
            }
        }
        catch (RepositoryException e) {
            this.log.error("RepositoryException", (Throwable)e);
        }
        return ret;
    }

    private synchronized void checkOMRInitialized() throws MdException, RemoteException {
        if (this.jomaMdFact == null) {
            String omrPort;
            String omrHost;
            this.log.info("Metadata connection unavailable. Creating...");
            if (this.params.containsKey("omrHost")) {
                omrHost = this.params.getProperty("omrHost");
            } else {
                this.log.warn("omrHost property not specified in configuration file. Using default = localhost");
                omrHost = "localhost";
            }
            if (this.params.containsKey("omrPort")) {
                omrPort = this.params.getProperty("omrPort");
            } else {
                this.log.warn("omrPort not specified in configuration file. Using default=8561");
                omrPort = "8561";
            }
            if (!this.params.containsKey("adminName")) {
                this.log.error("adminUser not specified in configuration file. This parameter must be set to continue.");
                throw new RemoteException("adminName not specified in configuration file. This parameter must be set to continue.");
            }
            String adminUser = this.params.getProperty("adminName");
            if (!this.params.containsKey("adminPass")) {
                this.log.error("adminPass not specified in configuration file. This parameter must be set to continue.");
                throw new RemoteException("adminPass not specified in configuration file. This parameter must be set to continue.");
            }
            String adminPass = this.params.getProperty("adminPass");
            this.jomaMdFact = new MdFactoryImpl(false);
            this.jomaMdFact.getConnection().makeOMRConnection(omrHost, omrPort, adminUser, adminPass);
            this.repositoryId = this.jomaMdFact.getOMIUtil().getFoundationReposID();
        }
    }

    private List<Principal> findOMRUsers(String simpleFilter) {
        return this.findOMRPrincipals(simpleFilter, "Person");
    }

    private List<Principal> findOMRGroups(String simpleFilter) {
        return this.findOMRPrincipals(simpleFilter, "IdentityGroup");
    }

    private List<Principal> findOMRPrincipals(String simpleFilter, String principalType) {
        return this.findOMRPrincipals(simpleFilter, principalType, true);
    }

    private List<Principal> findOMRPrincipals(String simpleFilter, String principalType, boolean retry) {
        block7: {
            try {
                this.checkInitialized();
                this.checkOMRInitialized();
                String nameSelect = simpleFilter == null ? "<XMLSelect search=\"*\"/>" : "<XMLSelect search=\"*[@Name='" + simpleFilter + "']\"/>";
                int flags = 384;
                List fastObjects = this.jomaMdFact.getOMIUtil().getFastMetadataObjects(principalType, this.repositoryId, nameSelect, flags);
                if (fastObjects != null && fastObjects.size() > 0) {
                    ArrayList<Principal> principals = new ArrayList<Principal>(fastObjects.size());
                    for (FastMetadata object : fastObjects) {
                        principals.add((Principal)new PrincipalImpl(object.getAttribute("Name")));
                    }
                    return principals;
                }
            }
            catch (Exception e) {
                if (this.jomaMdFact != null) {
                    try {
                        this.jomaMdFact.dispose();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.jomaMdFact = null;
                }
                this.log.error("Exception while checking for OMR principals", (Throwable)e);
                if (!retry) break block7;
                return this.findOMRPrincipals(simpleFilter, principalType, false);
            }
        }
        return null;
    }

    private boolean isCached(String name) {
        boolean ret = false;
        Long time = this.principalsCache.get(name);
        long current = System.currentTimeMillis();
        if (time != null && current - time < 1000L) {
            ret = true;
        }
        this.principalsCache.put(name, current);
        return ret;
    }

    private PrincipalType existsInOMR(String name) {
        List<Principal> users = this.findOMRUsers(SpecialNameChars.decode(name));
        if (users != null && users.size() > 0) {
            return PrincipalType.USER;
        }
        List<Principal> groups = this.findOMRGroups(SpecialNameChars.decode(name));
        if (groups != null && groups.size() > 0) {
            return PrincipalType.GROUP;
        }
        return null;
    }

    public PrincipalIterator findPrincipals(String simpleFilter, int searchType) {
        OMRPrincipalIterator ret = null;
        switch (searchType) {
            case 3: {
                List<Principal> principals = this.findOMRUsers(simpleFilter);
                principals.addAll(this.findOMRGroups(simpleFilter));
                ret = new OMRPrincipalIterator(principals);
                break;
            }
            case 2: {
                ret = new OMRPrincipalIterator(this.findOMRGroups(simpleFilter));
                break;
            }
            case 1: {
                ret = new OMRPrincipalIterator(this.findOMRUsers(simpleFilter));
                break;
            }
            default: {
                ret = new OMRPrincipalIterator(Collections.emptyList());
            }
        }
        return ret;
    }

    public synchronized void close() {
        super.close();
        this.defaultPrincipalNames.clear();
        this.defaultPrincipalNames = null;
        this.principalsCache.clear();
        this.principalsCache = null;
        try {
            this.jomaMdFact.dispose();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.jomaMdFact = null;
    }

    private class OMRPrincipalIterator
    implements PrincipalIterator {
        private List<Principal> principals;
        private int pos = -1;

        public OMRPrincipalIterator(List<Principal> principals) {
            this.principals = principals;
            if (this.principals != null && this.principals.size() > 0) {
                this.pos = 0;
            }
        }

        public long getPosition() {
            return this.pos;
        }

        public long getSize() {
            return this.principals.size();
        }

        public void skip(long arg0) {
            ++this.pos;
        }

        public boolean hasNext() {
            return this.pos > -1 && this.pos < this.principals.size();
        }

        public Object next() {
            return this.principals.get(this.pos++);
        }

        public void remove() {
            this.principals.remove(this.pos);
        }

        public Principal nextPrincipal() {
            return this.principals.get(this.pos++);
        }
    }

    private static enum PrincipalType {
        USER,
        GROUP;

    }
}

