/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.security;

import com.sas.contentserver.commons.SpecialNameChars;
import com.sas.contentserver.security.SASACLProvider;
import com.sas.services.security.login.OMIServerPrincipal;
import com.sas.services.security.login.PFSGroupPrincipal;
import com.sas.services.security.login.PFSRolePrincipal;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.Authorizable;

public class OMRACLProvider
extends SASACLProvider {
    private Map<Principal, Principal> jcrPrincipalsCache;

    @Override
    public void init(Session systemSession, Map configuration) throws RepositoryException {
        super.init(systemSession, configuration);
        this.jcrPrincipalsCache = new HashMap<Principal, Principal>();
    }

    @Override
    public Set<Principal> convertToJCRPrincipals(Set<Principal> omrPrincipals) throws RepositoryException {
        Set<Principal> jcrPrincipals = super.convertToJCRPrincipals(omrPrincipals);
        for (Principal principal : omrPrincipals) {
            if (principal.getName() == null || principal.getName().equals("") || !(principal instanceof OMIServerPrincipal) && !(principal instanceof PFSGroupPrincipal) && !(principal instanceof PFSRolePrincipal)) continue;
            Principal jcrPrincipal = this.jcrPrincipalsCache.get(principal);
            if (jcrPrincipal != null) {
                jcrPrincipals.add(jcrPrincipal);
                continue;
            }
            Authorizable auth = this.session.getUserManager().getAuthorizable(SpecialNameChars.encode(principal.getName()));
            if (auth == null) continue;
            jcrPrincipals.add(auth.getPrincipal());
            this.jcrPrincipalsCache.put(principal, auth.getPrincipal());
        }
        return jcrPrincipals;
    }
}

