/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector;
import org.apache.jackrabbit.core.security.authorization.acl.Entry;
import org.apache.jackrabbit.core.security.authorization.acl.EntryCollector;
import org.apache.jackrabbit.core.security.authorization.acl.EntryFilter;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonInheritingCachingEntryCollector
extends CachingEntryCollector {
    static final Logger log = LoggerFactory.getLogger(NonInheritingCachingEntryCollector.class);
    static Map<Session, Long> adminSessions;
    private static Thread sessionJanitor;
    private static Object monitor;

    NonInheritingCachingEntryCollector(SessionImpl systemSession, NodeId rootNodeId) throws RepositoryException {
        super(systemSession, rootNodeId);
    }

    protected List<Entry> collectEntries(NodeImpl node, EntryFilter filter) throws RepositoryException {
        LinkedList userAces = new LinkedList();
        LinkedList groupAces = new LinkedList();
        if (node == null) {
            NodeImpl root = (NodeImpl)this.systemSession.getRootNode();
            if (ACLProvider.isRepoAccessControlled((NodeImpl)root)) {
                NodeImpl aclNode = root.getNode(N_REPO_POLICY);
                String path = aclNode != null ? aclNode.getParent().getPath() : null;
                NonInheritingCachingEntryCollector.filterEntries((EntryFilter)filter, (List)Entry.readEntries((NodeImpl)aclNode, (String)path), userAces, groupAces);
            }
        } else {
            NonInheritingCachingEntryCollector.filterEntries((EntryFilter)filter, (List)this.getEntries(node).getACEs(), userAces, groupAces);
            NodeId parent = node.getParentId();
            if (parent != null) {
                EntryCollector.Entries entries = this.getEntries(parent);
                NonInheritingCachingEntryCollector.filterEntries((EntryFilter)filter, (List)entries.getACEs(), userAces, groupAces);
            }
        }
        ArrayList<Entry> entries = new ArrayList<Entry>(userAces.size() + groupAces.size());
        entries.addAll(userAces);
        entries.addAll(groupAces);
        return entries;
    }

    public void onEvent(EventIterator events) {
        try {
            Session session = this.getAdminSession();
            EntryCollector.ACLEventSieve sieve = new EntryCollector.ACLEventSieve(session, (NameResolver)session);
            sieve.siftEvents(events);
            AccessControlModifications mods = sieve.getModifications();
            if (!mods.getNodeIdentifiers().isEmpty()) {
                this.notifyListeners(mods);
            }
            this.putAdminSession(session);
        }
        catch (RepositoryException e) {
            log.error("Failed to process access control modifications", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getAdminSession() throws AccessDeniedException, NoSuchWorkspaceException, RepositoryException {
        Object object = monitor;
        synchronized (object) {
            if (adminSessions.isEmpty()) {
                String workspaceName = this.systemSession.getWorkspace().getName();
                Session session = this.systemSession.createSession(workspaceName);
                if (log.isDebugEnabled()) {
                    log.debug("Creating new admin session for the pool = " + session.toString());
                }
                return session;
            }
            Session ret = adminSessions.keySet().iterator().next();
            if (log.isDebugEnabled()) {
                log.debug("Getting existing admin session from the pool = " + ret.toString());
            }
            adminSessions.remove(ret);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAdminSession(Session session) {
        Object object = monitor;
        synchronized (object) {
            long current = System.currentTimeMillis();
            adminSessions.put(session, current);
            if (log.isDebugEnabled()) {
                log.debug("Putting admin session = " + session.toString() + " in the pool at time = " + current + ". Pool size = " + adminSessions.size());
            }
        }
    }

    static {
        monitor = new Object();
        adminSessions = new HashMap<Session, Long>();
        sessionJanitor = new SessionJanitor();
        sessionJanitor.setDaemon(true);
        sessionJanitor.start();
    }

    private static class SessionJanitor
    extends Thread {
        private static final long WAIT_TIME_SECONDS = 600L;
        private static final long TIMEOUT_SECONDS = 600L;

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    Thread.sleep(600000L);
                    for (Session session : adminSessions.keySet()) {
                        long lastUsed = adminSessions.get(session);
                        if (System.currentTimeMillis() - lastUsed <= 600L) continue;
                        adminSessions.remove(session);
                        if (log.isDebugEnabled()) {
                            log.debug("Removing admin session = " + session.toString() + " from pool due to timeout. Pool size = " + adminSessions.size());
                        }
                        session.logout();
                    }
                }
            }
            catch (InterruptedException e) {
                log.error("InterruptedException", (Throwable)e);
            }
        }
    }
}

