/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.persistence.pool;

import com.sas.contentserver.db.util.TenantConnectionHelper;
import com.sas.contentserver.persistence.pool.util.TenantDbNameIndex;
import com.sas.framework.commons.holders.TenantHolder;
import java.io.File;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.cache.Cache;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.check.ConsistencyCheckListener;
import org.apache.jackrabbit.core.persistence.check.ConsistencyReport;
import org.apache.jackrabbit.core.persistence.pool.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.DbNameIndex;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.util.StringIndex;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantBundleDbPersistenceManager
extends BundleDbPersistenceManager {
    private static Logger log = LoggerFactory.getLogger(TenantBundleDbPersistenceManager.class);
    private Map<Integer, BundleDbPersistenceManager> tenantPersistMgrs = new HashMap<Integer, BundleDbPersistenceManager>();
    private PMContext context;

    public TenantBundleDbPersistenceManager() {
        this.tenantPersistMgrs.put(TenantHolder.get().getId(), this);
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        return new TenantConnectionHelper(dataSrc, false);
    }

    protected DbNameIndex createDbNameIndex() throws SQLException {
        return new TenantDbNameIndex(this.conHelper, this.schemaObjectPrefix);
    }

    protected BundleDbPersistenceManager.CloseableBLOBStore createDBBlobStore(PMContext context) throws Exception {
        return new TenantDbBlobStore();
    }

    protected BundleDbPersistenceManager.CloseableBLOBStore createLocalFSBlobStore(PMContext context) throws Exception {
        LocalFileSystem blobFS = new LocalFileSystem();
        blobFS.setRoot(new File(context.getHomeDir(), "blobs"));
        blobFS.init();
        return new TenantFSBlobStore((FileSystem)blobFS);
    }

    protected CheckSchemaOperation createCheckSchemaOperation() {
        InputStream in = TenantBundleDbPersistenceManager.class.getResourceAsStream(this.databaseType + ".ddl");
        return new CheckSchemaOperation(this.conHelper, in, this.schemaObjectPrefix + "BUNDLE").addVariableReplacement("${schemaObjectPrefix}", this.schemaObjectPrefix);
    }

    protected void buildSQLStatements() {
        if (this.getStorageModel() == 1) {
            this.bundleInsertSQL = "insert into " + this.schemaObjectPrefix + "BUNDLE (BUNDLE_DATA, NODE_ID, TENANT_ID) values (?, ?, ?)";
            this.bundleUpdateSQL = "update " + this.schemaObjectPrefix + "BUNDLE set BUNDLE_DATA = ? where NODE_ID = ? and TENANT_ID = ?";
            this.bundleSelectSQL = "select BUNDLE_DATA from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID = ? and TENANT_ID = ?";
            this.bundleDeleteSQL = "delete from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID = ? and TENANT_ID = ?";
            this.nodeReferenceInsertSQL = "insert into " + this.schemaObjectPrefix + "REFS (REFS_DATA, NODE_ID, TENANT_ID) values (?, ?, ?)";
            this.nodeReferenceUpdateSQL = "update " + this.schemaObjectPrefix + "REFS set REFS_DATA = ? where NODE_ID = ? and TENANT_ID = ?";
            this.nodeReferenceSelectSQL = "select REFS_DATA from " + this.schemaObjectPrefix + "REFS where NODE_ID = ? and TENANT_ID = ?";
            this.nodeReferenceDeleteSQL = "delete from " + this.schemaObjectPrefix + "REFS where NODE_ID = ? and TENANT_ID = ?";
            this.bundleSelectAllIdsSQL = "select NODE_ID from " + this.schemaObjectPrefix + "BUNDLE where TENANT_ID = ? ORDER BY NODE_ID";
            this.bundleSelectAllIdsFromSQL = "select NODE_ID from " + this.schemaObjectPrefix + "BUNDLE WHERE NODE_ID > ? and TENANT_ID = ? ORDER BY NODE_ID";
        } else {
            this.bundleInsertSQL = "insert into " + this.schemaObjectPrefix + "BUNDLE (BUNDLE_DATA, NODE_ID_HI, NODE_ID_LO, TENANT_ID) values (?, ?, ?, ?)";
            this.bundleUpdateSQL = "update " + this.schemaObjectPrefix + "BUNDLE set BUNDLE_DATA = ? where NODE_ID_HI = ? and NODE_ID_LO = ? and TENANT_ID = ?";
            this.bundleSelectSQL = "select BUNDLE_DATA from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID_HI = ? and NODE_ID_LO = ? and TENANT_ID = ?";
            this.bundleDeleteSQL = "delete from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID_HI = ? and NODE_ID_LO = ? and TENANT_ID = ?";
            this.nodeReferenceInsertSQL = "insert into " + this.schemaObjectPrefix + "REFS (REFS_DATA, NODE_ID_HI, NODE_ID_LO, TENANT_ID) values (?, ?, ?, ?)";
            this.nodeReferenceUpdateSQL = "update " + this.schemaObjectPrefix + "REFS set REFS_DATA = ? where NODE_ID_HI = ? and NODE_ID_LO = ? and TENANT_ID = ?";
            this.nodeReferenceSelectSQL = "select REFS_DATA from " + this.schemaObjectPrefix + "REFS where NODE_ID_HI = ? and NODE_ID_LO = ? and TENANT_ID = ?";
            this.nodeReferenceDeleteSQL = "delete from " + this.schemaObjectPrefix + "REFS where NODE_ID_HI = ? and NODE_ID_LO = ? and TENANT_ID = ?";
            this.bundleSelectAllIdsSQL = "select NODE_ID_HI, NODE_ID_LO from " + this.schemaObjectPrefix + "BUNDLE where TENANT_ID = ? ORDER BY NODE_ID_HI, NODE_ID_LO";
            this.bundleSelectAllIdsFromSQL = "select NODE_ID_HI, NODE_ID_LO from " + this.schemaObjectPrefix + "BUNDLE WHERE (NODE_ID_HI >= ?) AND (? IS NOT NULL) and TENANT_ID = ? ORDER BY NODE_ID_HI, NODE_ID_LO";
        }
    }

    protected BundleDbPersistenceManager createPersistenceManager() {
        return new BundleDbPersistenceManager();
    }

    private BundleDbPersistenceManager getTenantPersistenceManager() {
        BundleDbPersistenceManager ret = this.tenantPersistMgrs.get(TenantHolder.get().getId());
        if (ret == null) {
            try {
                ret = this.createPersistenceManager();
                ret.setBlockOnConnectionLoss("" + this.blockOnConnectionLoss);
                ret.setConsistencyCheck("" + this.consistencyCheck);
                ret.setBundleCacheSize(this.getBundleCacheSize());
                ret.setConsistencyFix("" + this.consistencyFix);
                ret.setMinBlobSize("" + this.minBlobSize);
                ret.setDriver(this.driver);
                ret.setUrl(this.url);
                ret.setUser(this.user);
                ret.setPassword(this.password);
                ret.setDatabaseType(this.databaseType);
                ret.setSchemaObjectPrefix(this.schemaObjectPrefix);
                ret.setErrorHandling(this.errorHandling.toString());
                ret.setSchemaCheckEnabled(this.schemaCheckEnabled);
                ret.setConnectionFactory(this.connectionFactory);
                ret.setExternalBLOBs(this.externalBLOBs);
                ret.init(this.context);
                DbNameIndex nameIndex = this.createDbNameIndex();
                ret.setBinding(new BundleBinding(this.errorHandling, (BLOBStore)this.blobStore, (StringIndex)this.context.getNamespaceRegistry(), (StringIndex)nameIndex, this.context.getDataStore()));
                ret.setNameIndex((StringIndex)nameIndex);
                ret.conHelper = this.conHelper;
                ret.bundleInsertSQL = this.bundleInsertSQL;
                ret.bundleUpdateSQL = this.bundleUpdateSQL;
                ret.bundleSelectSQL = this.bundleSelectSQL;
                ret.bundleDeleteSQL = this.bundleDeleteSQL;
                ret.bundleSelectAllIdsFromSQL = this.bundleSelectAllIdsFromSQL;
                ret.bundleSelectAllIdsSQL = this.bundleSelectAllIdsSQL;
                ret.nodeReferenceInsertSQL = this.nodeReferenceInsertSQL;
                ret.nodeReferenceUpdateSQL = this.nodeReferenceUpdateSQL;
                ret.nodeReferenceSelectSQL = this.nodeReferenceSelectSQL;
                ret.nodeReferenceDeleteSQL = this.nodeReferenceDeleteSQL;
                this.tenantPersistMgrs.put(TenantHolder.get().getId(), ret);
            }
            catch (Exception e) {
                log.error("Error creating new tenant persistence manager", (Throwable)e);
            }
        }
        return ret;
    }

    public synchronized void close() throws Exception {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.close();
        } else {
            persistMgr.close();
        }
    }

    public Object[] createParams(NodeId id, Object p, boolean before) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.createParams(id, p, before);
        }
        return persistMgr.createParams(id, p, before);
    }

    public synchronized void destroy(NodeReferences refs) throws ItemStateException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.destroy(refs);
        } else {
            persistMgr.destroy(refs);
        }
    }

    public synchronized void destroyBundle(NodePropBundle bundle) throws ItemStateException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.destroyBundle(bundle);
        } else {
            persistMgr.destroyBundle(bundle);
        }
    }

    public synchronized boolean existsReferencesTo(NodeId targetId) throws ItemStateException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.existsReferencesTo(targetId);
        }
        return persistMgr.existsReferencesTo(targetId);
    }

    public synchronized List<NodeId> getAllNodeIds(NodeId bigger, int maxCount) throws ItemStateException, RepositoryException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getAllNodeIds(bigger, maxCount);
        }
        return persistMgr.getAllNodeIds(bigger, maxCount);
    }

    public String getBlockOnConnectionLoss() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getBlockOnConnectionLoss();
        }
        return persistMgr.getBlockOnConnectionLoss();
    }

    public String getConsistencyCheck() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getConsistencyCheck();
        }
        return persistMgr.getConsistencyCheck();
    }

    public String getConsistencyFix() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getConsistencyFix();
        }
        return persistMgr.getConsistencyFix();
    }

    public String getDatabaseType() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getDatabaseType();
        }
        return persistMgr.getDatabaseType();
    }

    public String getDataSourceName() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getDataSourceName();
        }
        return persistMgr.getDataSourceName();
    }

    public String getDriver() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getDriver();
        }
        return persistMgr.getDriver();
    }

    public String getErrorHandling() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getErrorHandling();
        }
        return persistMgr.getErrorHandling();
    }

    public String getMinBlobSize() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getMinBlobSize();
        }
        return persistMgr.getMinBlobSize();
    }

    public StringIndex getNameIndex() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getNameIndex();
        }
        return persistMgr.getNameIndex();
    }

    public String getPassword() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getPassword();
        }
        return persistMgr.getPassword();
    }

    public String getSchema() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getSchema();
        }
        return persistMgr.getSchema();
    }

    public String getSchemaObjectPrefix() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getSchemaObjectPrefix();
        }
        return persistMgr.getSchemaObjectPrefix();
    }

    public int getStorageModel() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getStorageModel();
        }
        return persistMgr.getStorageModel();
    }

    public String getUrl() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getUrl();
        }
        return persistMgr.getUrl();
    }

    public String getUser() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getUser();
        }
        return persistMgr.getUser();
    }

    public void init(PMContext context) throws Exception {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.init(context);
        } else {
            persistMgr.init(context);
        }
        this.context = context;
    }

    public boolean isExternalBLOBs() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.isExternalBLOBs();
        }
        return persistMgr.isExternalBLOBs();
    }

    public NodePropBundle loadBundle(NodeId id) throws ItemStateException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.loadBundle(id);
        }
        return persistMgr.loadBundle(id);
    }

    public synchronized NodeReferences loadReferencesTo(NodeId targetId) throws NoSuchItemStateException, ItemStateException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.loadReferencesTo(targetId);
        }
        return persistMgr.loadReferencesTo(targetId);
    }

    public NodePropBundle readBundle(NodeId id, ResultSet rs, int column) throws SQLException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.readBundle(id, rs, column);
        }
        return persistMgr.readBundle(id, rs, column);
    }

    public void setBlockOnConnectionLoss(String block) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setBlockOnConnectionLoss(block);
        } else {
            persistMgr.setBlockOnConnectionLoss(block);
        }
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setConnectionFactory(connectionFactory);
        } else {
            persistMgr.setConnectionFactory(connectionFactory);
        }
    }

    public void setConsistencyCheck(String consistencyCheck) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setConsistencyCheck(consistencyCheck);
        } else {
            persistMgr.setConsistencyCheck(consistencyCheck);
        }
    }

    public void setConsistencyFix(String consistencyFix) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setConsistencyFix(consistencyFix);
        } else {
            persistMgr.setConsistencyFix(consistencyFix);
        }
    }

    public void setDatabaseType(String databaseType) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setDatabaseType(databaseType);
        } else {
            persistMgr.setDatabaseType(databaseType);
        }
    }

    public void setDataSourceName(String dataSourceName) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setDataSourceName(dataSourceName);
        } else {
            persistMgr.setDataSourceName(dataSourceName);
        }
    }

    public void setDriver(String driver) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setDriver(driver);
        } else {
            persistMgr.setDriver(driver);
        }
    }

    public void setErrorHandling(String errorHandling) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setErrorHandling(errorHandling);
        } else {
            persistMgr.setErrorHandling(errorHandling);
        }
    }

    public void setExternalBLOBs(boolean externalBLOBs) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setExternalBLOBs(externalBLOBs);
        } else {
            persistMgr.setExternalBLOBs(externalBLOBs);
        }
    }

    public void setMinBlobSize(String minBlobSize) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setMinBlobSize(minBlobSize);
        } else {
            persistMgr.setMinBlobSize(minBlobSize);
        }
    }

    public void setPassword(String password) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setPassword(password);
        } else {
            persistMgr.setPassword(password);
        }
    }

    public void setSchema(String databaseType) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setSchema(databaseType);
        } else {
            persistMgr.setSchema(databaseType);
        }
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setSchemaObjectPrefix(schemaObjectPrefix);
        } else {
            persistMgr.setSchemaObjectPrefix(schemaObjectPrefix);
        }
    }

    public void setUrl(String url) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setUrl(url);
        } else {
            persistMgr.setUrl(url);
        }
    }

    public void setUser(String user) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setUser(user);
        } else {
            persistMgr.setUser(user);
        }
    }

    public synchronized void store(ChangeLog changeLog) throws ItemStateException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.store(changeLog);
        } else {
            persistMgr.store(changeLog);
        }
    }

    public synchronized void store(NodeReferences refs) throws ItemStateException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.store(refs);
        } else {
            persistMgr.store(refs);
        }
    }

    public synchronized void storeBundle(NodePropBundle bundle) throws ItemStateException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.storeBundle(bundle);
        } else {
            persistMgr.storeBundle(bundle);
        }
    }

    public String toString() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.toString();
        }
        return persistMgr.toString();
    }

    public boolean useDbBlobStore() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.useDbBlobStore();
        }
        return persistMgr.useDbBlobStore();
    }

    public boolean useLocalFsBlobStore() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.useLocalFsBlobStore();
        }
        return persistMgr.useLocalFsBlobStore();
    }

    public NodeState createNew(NodeId id) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.createNew(id);
        }
        return persistMgr.createNew(id);
    }

    public PropertyState createNew(PropertyId id) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.createNew(id);
        }
        return persistMgr.createNew(id);
    }

    public void evictBundle(NodeId id) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.evictBundle(id);
        } else {
            persistMgr.evictBundle(id);
        }
    }

    public boolean exists(NodeId id) throws ItemStateException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.exists(id);
        }
        return persistMgr.exists(id);
    }

    public boolean exists(PropertyId id) throws ItemStateException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.exists(id);
        }
        return persistMgr.exists(id);
    }

    public String getBundleCacheSize() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getBundleCacheSize();
        }
        return persistMgr.getBundleCacheSize();
    }

    public StringIndex getNsIndex() {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.getNsIndex();
        }
        return persistMgr.getNsIndex();
    }

    public NodeState load(NodeId id) throws NoSuchItemStateException, ItemStateException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.load(id);
        }
        return persistMgr.load(id);
    }

    public PropertyState load(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.load(id);
        }
        return persistMgr.load(id);
    }

    public synchronized void onExternalUpdate(ChangeLog changes) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.onExternalUpdate(changes);
        } else {
            persistMgr.onExternalUpdate(changes);
        }
    }

    public void setBundleCacheSize(String bundleCacheSize) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.setBundleCacheSize(bundleCacheSize);
        } else {
            persistMgr.setBundleCacheSize(bundleCacheSize);
        }
    }

    public void checkConsistency(String[] uuids, boolean recursive, boolean fix) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.checkConsistency(uuids, recursive, fix);
        } else {
            persistMgr.checkConsistency(uuids, recursive, fix);
        }
    }

    public void cacheAccessed(long accessCount) {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            super.cacheAccessed(accessCount);
        } else {
            persistMgr.cacheAccessed(accessCount);
        }
    }

    @Deprecated
    public ConsistencyReport check(String[] uuids, boolean recursive, boolean fix, String lostNFoundId) throws RepositoryException {
        return this.check(uuids, recursive, fix, lostNFoundId, null);
    }

    public ConsistencyReport check(String[] uuids, boolean recursive, boolean fix, String lostNFoundId, ConsistencyCheckListener listener) throws RepositoryException {
        BundleDbPersistenceManager persistMgr = this.getTenantPersistenceManager();
        if (persistMgr instanceof TenantBundleDbPersistenceManager) {
            return super.check(uuids, recursive, fix, lostNFoundId, listener);
        }
        return persistMgr.check(uuids, recursive, fix, lostNFoundId, listener);
    }

    public void disposeCache(Cache cache) {
    }

    protected class TenantFSBlobStore
    extends BundleDbPersistenceManager.FSBlobStore {
        public TenantFSBlobStore(FileSystem fs) {
            super((BundleDbPersistenceManager)TenantBundleDbPersistenceManager.this, fs);
        }

        public String createId(PropertyId id, int index) {
            return TenantHolder.get().getId() + "/" + super.createId(id, index);
        }
    }

    protected class TenantDbBlobStore
    extends BundleDbPersistenceManager.DbBlobStore {
        public TenantDbBlobStore() throws SQLException {
            super((BundleDbPersistenceManager)TenantBundleDbPersistenceManager.this);
            this.blobInsertSQL = "insert into " + TenantBundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL (BINVAL_DATA, BINVAL_ID, TENANT_ID) values (?, ?, ?)";
            this.blobUpdateSQL = "update " + TenantBundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL set BINVAL_DATA = ? where BINVAL_ID = ? and TENANT_ID = ?";
            this.blobSelectSQL = "select BINVAL_DATA from " + TenantBundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ? and TENANT_ID = ?";
            this.blobSelectExistSQL = "select 1 from " + TenantBundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ? and TENANT_ID = ?";
            this.blobDeleteSQL = "delete from " + TenantBundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ? and TENANT_ID = ?";
        }
    }
}

