/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.fs.db;

import com.sas.contentserver.fs.db.TenantOracleFileSystem;
import com.sas.framework.commons.holders.TenantHolder;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.core.fs.FileSystemException;

public class TenantExtendedOracleFileSystem
extends TenantOracleFileSystem {
    private Map<Integer, Boolean> tenantsInitialized = new HashMap<Integer, Boolean>();

    @Override
    public void init() throws FileSystemException {
        int tenantId = TenantHolder.get().getId();
        Boolean tenantInitialized = this.tenantsInitialized.get(tenantId);
        this.initialized = tenantInitialized == null ? false : tenantInitialized;
        try {
            super.init();
            this.tenantsInitialized.put(tenantId, Boolean.TRUE);
        }
        catch (FileSystemException e) {
            this.tenantsInitialized.put(tenantId, Boolean.FALSE);
            throw e;
        }
        catch (Exception e) {
            this.tenantsInitialized.put(tenantId, Boolean.FALSE);
            throw new FileSystemException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setTablespace(String tablespace) {
        this.tablespace = tablespace != null ? tablespace.trim() : null;
    }

    @Override
    protected void buildSQLStatements() {
        this.insertFileSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID) values (?, ?, ?, ?, ?, ?)";
        this.insertFolderSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID) values (?, nvl(?, ' '), ?, null, ?)";
        this.updateDataSQL = "update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_DATA = ?, FSENTRY_LASTMOD = ?, FSENTRY_LENGTH = ? where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.updateLastModifiedSQL = "update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_LASTMOD = ? where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.selectExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = nvl(?, ' ') and TENANT_ID = ?";
        this.selectFileExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.selectFolderExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = nvl(?, ' ') and TENANT_ID = ? and FSENTRY_LENGTH is null";
        this.selectFileNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.selectFolderNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME != ' ' and TENANT_ID = ? and FSENTRY_LENGTH is null";
        this.selectFileAndFolderNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME != ' ' and TENANT_ID = ?";
        this.selectChildCountSQL = "select count(FSENTRY_NAME) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?  and FSENTRY_NAME != ' ' and TENANT_ID = ?";
        this.selectDataSQL = "select nvl(FSENTRY_DATA, empty_blob()) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.selectLastModifiedSQL = "select FSENTRY_LASTMOD from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = nvl(?, ' ') and TENANT_ID = ?";
        this.selectLengthSQL = "select nvl(FSENTRY_LENGTH, 0) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.deleteFileSQL = "delete from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.deleteFolderSQL = "delete from " + this.schemaObjectPrefix + "FSENTRY where (FSENTRY_PATH = ? and FSENTRY_NAME = nvl(?, ' ') and FSENTRY_LENGTH is null) or (FSENTRY_PATH = ?) or (FSENTRY_PATH like ?) and TENANT_ID = ?";
        this.copyFileSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID) select ?, ?, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
        this.copyFilesSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID) select ?, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH, TENANT_ID from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and TENANT_ID = ? and FSENTRY_LENGTH is not null";
    }
}

