/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.db.util;

import com.sas.contentserver.db.util.TenantUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.ResultSetWrapper;
import org.springframework.util.StringUtils;

public class TenantConnectionHelper
extends ConnectionHelper {
    public TenantConnectionHelper(DataSource dataSrc, boolean block) {
        super(dataSrc, block);
    }

    protected TenantConnectionHelper(DataSource dataSrc, boolean checkWithUserName, boolean block) {
        super(dataSrc, checkWithUserName, block);
    }

    protected PreparedStatement execute(PreparedStatement stmt, Object[] params) throws SQLException {
        Object[] tenantParams = TenantUtils.addTenant(params);
        return super.execute(stmt, tenantParams);
    }

    protected PreparedStatement executeNoTenant(PreparedStatement stmt, Object[] params) throws SQLException {
        return super.execute(stmt, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reallyExec(String sql, Object ... params) throws SQLException {
        Statement stmt;
        Connection con;
        block4: {
            con = null;
            stmt = null;
            try {
                con = this.getConnection(this.inBatchMode());
                if (!sql.contains("?")) {
                    stmt = con.createStatement();
                    stmt.execute(sql);
                    break block4;
                }
                if (StringUtils.countOccurrencesOf((String)sql, (String)"?") == (params == null ? 0 : params.length) + 1) {
                    PreparedStatement p = con.prepareStatement(sql);
                    stmt = p;
                    this.execute(p, params);
                    break block4;
                }
                PreparedStatement p = con.prepareStatement(sql);
                stmt = p;
                this.executeNoTenant(p, params);
            }
            catch (Throwable throwable) {
                this.closeResources(con, stmt, null, this.inBatchMode());
                throw throwable;
            }
        }
        this.closeResources(con, stmt, null, this.inBatchMode());
    }

    protected ResultSet reallyExec(String sql, Object[] params, boolean returnGeneratedKeys, int maxRows) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(this.inBatchMode());
            stmt = returnGeneratedKeys ? con.prepareStatement(sql, 1) : con.prepareStatement(sql);
            stmt.setMaxRows(maxRows);
            int currentFetchSize = this.fetchSize;
            if (0 < maxRows && maxRows < currentFetchSize) {
                currentFetchSize = maxRows;
            }
            stmt.setFetchSize(currentFetchSize);
            if (StringUtils.countOccurrencesOf((String)sql, (String)"?") == (params == null ? 0 : params.length) + 1) {
                this.execute(stmt, params);
            } else {
                this.executeNoTenant(stmt, params);
            }
            rs = returnGeneratedKeys ? stmt.getGeneratedKeys() : stmt.getResultSet();
            if (rs == null) {
                return null;
            }
            if (this.inBatchMode()) {
                return ResultSetWrapper.newInstance(null, (Statement)stmt, (ResultSet)rs);
            }
            return ResultSetWrapper.newInstance((Connection)con, (Statement)stmt, (ResultSet)rs);
        }
        catch (SQLException e) {
            this.closeResources(con, stmt, rs, this.inBatchMode());
            throw e;
        }
    }
}

