/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.query.lucene;

import com.sas.contentserver.core.query.lucene.TenantLuceneQueryBuilder;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.lucene.QueryImpl;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.SingleColumnQueryResult;
import org.apache.jackrabbit.core.query.lucene.SpellSuggestion;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.query.OrderQueryNode;
import org.apache.jackrabbit.spi.commons.query.QueryNodeFactory;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantQueryImpl
extends QueryImpl {
    private static final Logger log = LoggerFactory.getLogger(TenantQueryImpl.class);

    public TenantQueryImpl(SessionContext sessionContext, SearchIndex index, PropertyTypeRegistry propReg, String statement, String language, QueryNodeFactory factory) throws InvalidQueryException {
        super(sessionContext, index, propReg, statement, language, factory);
    }

    public QueryResult execute(long offset, long limit) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug("Executing query: \n" + this.root.dump());
        }
        Query query = TenantLuceneQueryBuilder.createQuery(this.root, this.sessionContext.getSessionImpl(), this.index.getContext().getItemStateManager(), this.index.getNamespaceMappings(), this.index.getTextAnalyzer(), this.propReg, this.index.getSynonymProvider(), this.index.getIndexFormatVersion(), this.cache);
        OrderQueryNode orderNode = this.root.getOrderNode();
        OrderQueryNode.OrderSpec[] orderSpecs = orderNode != null ? orderNode.getOrderSpecs() : new OrderQueryNode.OrderSpec[]{};
        Path[] orderProperties = new Path[orderSpecs.length];
        boolean[] ascSpecs = new boolean[orderSpecs.length];
        String[] orderFuncs = new String[orderSpecs.length];
        for (int i = 0; i < orderSpecs.length; ++i) {
            orderProperties[i] = orderSpecs[i].getPropertyPath();
            ascSpecs[i] = orderSpecs[i].isAscending();
            orderFuncs[i] = orderSpecs[i].getFunction();
        }
        return new SingleColumnQueryResult(this.index, this.sessionContext, (AbstractQueryImpl)this, query, new SpellSuggestion(this.index.getSpellChecker(), this.root), this.getColumns(), orderProperties, ascSpecs, orderFuncs, orderProperties.length == 0 && this.getRespectDocumentOrder(), offset, limit);
    }
}

