/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.query.lucene;

import com.sas.framework.commons.holders.TenantHolder;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryBuilder;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.PerQueryCache;
import org.apache.jackrabbit.core.query.lucene.SynonymProvider;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.spi.commons.query.QueryNodeVisitor;
import org.apache.jackrabbit.spi.commons.query.QueryRootNode;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;

public class TenantLuceneQueryBuilder
extends LuceneQueryBuilder {
    protected TenantLuceneQueryBuilder(QueryRootNode root, SessionImpl session, ItemStateManager sharedItemMgr, HierarchyManager hmgr, NamespaceMappings nsMappings, Analyzer analyzer, PropertyTypeRegistry propReg, SynonymProvider synonymProvider, IndexFormatVersion indexFormatVersion, PerQueryCache cache) {
        super(root, session, sharedItemMgr, hmgr, nsMappings, analyzer, propReg, synonymProvider, indexFormatVersion, cache);
    }

    public static Query createQuery(QueryRootNode root, SessionImpl session, ItemStateManager sharedItemMgr, NamespaceMappings nsMappings, Analyzer analyzer, PropertyTypeRegistry propReg, SynonymProvider synonymProvider, IndexFormatVersion indexFormatVersion, PerQueryCache cache) throws RepositoryException {
        HierarchyManagerImpl hmgr = new HierarchyManagerImpl(RepositoryImpl.ROOT_NODE_ID, sharedItemMgr);
        TenantLuceneQueryBuilder builder = new TenantLuceneQueryBuilder(root, session, sharedItemMgr, (HierarchyManager)hmgr, nsMappings, analyzer, propReg, synonymProvider, indexFormatVersion, cache);
        Query q = builder.createLuceneQuery();
        if (builder.getExceptions().size() > 0) {
            StringBuffer msg = new StringBuffer();
            for (Exception exception : builder.getExceptions()) {
                msg.append(exception.toString()).append('\n');
            }
            throw new RepositoryException("Exception building query: " + msg.toString());
        }
        return q;
    }

    public Object visit(QueryRootNode node, Object data) throws RepositoryException {
        BooleanQuery root = new BooleanQuery();
        int tenant = TenantHolder.get().getId();
        NumericRangeQuery query = NumericRangeQuery.newIntRange((String)"TENANT_ID", (Integer)tenant, (Integer)tenant, (boolean)true, (boolean)true);
        root.add((Query)query, BooleanClause.Occur.MUST);
        BooleanQuery wrapped = root;
        if (node.getLocationNode() != null) {
            wrapped = (Query)node.getLocationNode().accept((QueryNodeVisitor)this, (Object)root);
        }
        return wrapped;
    }
}

