/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.nodetype;

import com.sas.framework.commons.holders.TenantHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.core.cluster.NodeTypeEventChannel;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDefStore;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;

public class TenantNodeTypeRegistry
extends NodeTypeRegistry {
    private NamespaceRegistry nsReg;
    private FileSystem fs;
    private Map<Integer, NodeTypeRegistry> tenantRegistries;
    private boolean firstInit = false;

    public TenantNodeTypeRegistry(NamespaceRegistry nsReg, FileSystem fs) throws RepositoryException {
        super(nsReg, fs);
        this.nsReg = nsReg;
        this.fs = fs;
        this.tenantRegistries = new HashMap<Integer, NodeTypeRegistry>();
        this.tenantRegistries.put(TenantHolder.get().getId(), this);
        this.firstInit = true;
    }

    private NodeTypeRegistry getTenantRegistry() {
        NodeTypeRegistry ret = this.tenantRegistries.get(TenantHolder.get().getId());
        if (ret == null) {
            try {
                ret = new NodeTypeRegistry(this.nsReg, this.fs);
                this.tenantRegistries.put(TenantHolder.get().getId(), ret);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return ret;
    }

    public Name[] getRegisteredNodeTypes() {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            return super.getRegisteredNodeTypes();
        }
        return registry.getRegisteredNodeTypes();
    }

    public EffectiveNodeType registerNodeType(QNodeTypeDefinition ntd) throws InvalidNodeTypeDefException, RepositoryException {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            return super.registerNodeType(ntd);
        }
        return registry.registerNodeType(ntd);
    }

    public void registerNodeTypes(Collection<QNodeTypeDefinition> ntDefs) throws InvalidNodeTypeDefException, RepositoryException {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            super.registerNodeTypes(ntDefs);
        } else {
            registry.registerNodeTypes(ntDefs);
        }
    }

    public void unregisterNodeTypes(Set<Name> ntNames) throws NoSuchNodeTypeException, RepositoryException {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            super.unregisterNodeTypes(ntNames);
        } else {
            registry.unregisterNodeTypes(ntNames);
        }
    }

    public void unregisterNodeType(Name ntName) throws NoSuchNodeTypeException, RepositoryException {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            super.unregisterNodeType(ntName);
        } else {
            registry.unregisterNodeType(ntName);
        }
    }

    public EffectiveNodeType reregisterNodeType(QNodeTypeDefinition ntd) throws NoSuchNodeTypeException, InvalidNodeTypeDefException, RepositoryException {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            return super.reregisterNodeType(ntd);
        }
        return registry.reregisterNodeType(ntd);
    }

    public EffectiveNodeType getEffectiveNodeType(Name ntName) throws NoSuchNodeTypeException {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            return super.getEffectiveNodeType(ntName);
        }
        return registry.getEffectiveNodeType(ntName);
    }

    public EffectiveNodeType getEffectiveNodeType(Name primary, Set<Name> mixins) throws NodeTypeConflictException, NoSuchNodeTypeException {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            return super.getEffectiveNodeType(primary, mixins);
        }
        return registry.getEffectiveNodeType(primary, mixins);
    }

    public EffectiveNodeType getEffectiveNodeType(Set<Name> mixins) throws NodeTypeConflictException, NoSuchNodeTypeException {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            return super.getEffectiveNodeType(mixins);
        }
        return registry.getEffectiveNodeType(mixins);
    }

    public Set<Name> getDependentNodeTypes(Name nodeTypeName) throws NoSuchNodeTypeException {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            return super.getDependentNodeTypes(nodeTypeName);
        }
        return registry.getDependentNodeTypes(nodeTypeName);
    }

    public QNodeTypeDefinition getNodeTypeDef(Name nodeTypeName) throws NoSuchNodeTypeException {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            return super.getNodeTypeDef(nodeTypeName);
        }
        return registry.getNodeTypeDef(nodeTypeName);
    }

    public boolean isRegistered(Name nodeTypeName) {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            return super.isRegistered(nodeTypeName);
        }
        return registry.isRegistered(nodeTypeName);
    }

    public boolean isBuiltIn(Name nodeTypeName) {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            return super.isBuiltIn(nodeTypeName);
        }
        return registry.isBuiltIn(nodeTypeName);
    }

    public void addListener(NodeTypeRegistryListener listener) {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            super.addListener(listener);
        } else {
            registry.addListener(listener);
        }
    }

    public void removeListener(NodeTypeRegistryListener listener) {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            super.removeListener(listener);
        } else {
            registry.removeListener(listener);
        }
    }

    public String toString() {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            return super.toString();
        }
        return registry.toString();
    }

    public void externalRegistered(Collection<QNodeTypeDefinition> ntDefs) throws RepositoryException, InvalidNodeTypeDefException {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            super.externalRegistered(ntDefs);
        } else {
            registry.externalRegistered(ntDefs);
        }
    }

    public void externalReregistered(QNodeTypeDefinition ntDef) throws NoSuchNodeTypeException, InvalidNodeTypeDefException, RepositoryException {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            super.externalReregistered(ntDef);
        } else {
            registry.externalReregistered(ntDef);
        }
    }

    public void externalUnregistered(Collection<Name> ntNames) throws RepositoryException, NoSuchNodeTypeException {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            super.externalUnregistered(ntNames);
        } else {
            registry.externalUnregistered(ntNames);
        }
    }

    public void loadBuiltInNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        if (!this.firstInit) {
            super.loadBuiltInNodeTypeDefs(store);
            return;
        }
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            super.loadBuiltInNodeTypeDefs(store);
        } else {
            registry.loadBuiltInNodeTypeDefs(store);
        }
    }

    public void loadCustomNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        if (!this.firstInit) {
            super.loadCustomNodeTypeDefs(store);
            return;
        }
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            super.loadCustomNodeTypeDefs(store);
        } else {
            registry.loadCustomNodeTypeDefs(store);
        }
    }

    public void persistCustomNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            super.persistCustomNodeTypeDefs(store);
        } else {
            registry.persistCustomNodeTypeDefs(store);
        }
    }

    public QNodeDefinition getRootNodeDef() {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            return super.getRootNodeDef();
        }
        return registry.getRootNodeDef();
    }

    public void setEventChannel(NodeTypeEventChannel eventChannel) {
        NodeTypeRegistry registry = this.getTenantRegistry();
        if (registry instanceof TenantNodeTypeRegistry) {
            super.setEventChannel(eventChannel);
        } else {
            registry.setEventChannel(eventChannel);
        }
    }
}

