/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.data;

import com.sas.contentserver.core.data.TenantDataStore;
import com.sas.framework.commons.holders.TenantHolder;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantFileDataStore
implements TenantDataStore {
    private static Logger log = LoggerFactory.getLogger(TenantFileDataStore.class);
    private Map<Integer, FileDataStore> initializedStores = null;
    private String baseHomeDir = null;
    private int minRecordLength = 100;

    private FileDataStore getTenantDataStore() {
        FileDataStore ret;
        if (this.initializedStores == null) {
            this.initializedStores = new HashMap<Integer, FileDataStore>();
        }
        if ((ret = this.initializedStores.get(TenantHolder.get().getId())) == null) {
            ret = this.initNewDataStore();
        }
        return ret;
    }

    private FileDataStore initNewDataStore() {
        log.info("Initializing FileDataStore for tenant id = " + TenantHolder.get().getId() + " at " + this.baseHomeDir + "_" + TenantHolder.get().getId());
        FileDataStore ret = new FileDataStore();
        ret.setMinRecordLength(this.minRecordLength);
        ret.setPath(this.baseHomeDir + "_" + TenantHolder.get().getId());
        ret.init(this.baseHomeDir + "_" + TenantHolder.get().getId());
        this.initializedStores.put(TenantHolder.get().getId(), ret);
        return ret;
    }

    public void init(String homeDir) {
        if (this.baseHomeDir == null) {
            StringBuilder sb = new StringBuilder(homeDir);
            if (!homeDir.endsWith(File.separator)) {
                sb.append(File.separator);
            }
            sb.append("repository").append(File.separator).append("data").append(File.separator).append("datastore");
            this.baseHomeDir = sb.toString();
        }
        log.info("Initializing TenantFileDataStore at " + this.baseHomeDir);
        this.getTenantDataStore();
    }

    public DataRecord getRecordIfStored(DataIdentifier identifier) throws DataStoreException {
        FileDataStore store = this.getTenantDataStore();
        return store.getRecordIfStored(identifier);
    }

    public DataRecord getRecordFromReference(String reference) throws DataStoreException {
        FileDataStore store = this.getTenantDataStore();
        return store.getRecordFromReference(reference);
    }

    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        FileDataStore store = this.getTenantDataStore();
        return store.getRecord(identifier);
    }

    public DataRecord addRecord(InputStream input) throws DataStoreException {
        FileDataStore store = this.getTenantDataStore();
        return store.addRecord(input);
    }

    public void updateModifiedDateOnAccess(long before) {
        FileDataStore store = this.getTenantDataStore();
        store.updateModifiedDateOnAccess(before);
    }

    public int deleteAllOlderThan(long min) {
        FileDataStore store = this.getTenantDataStore();
        return store.deleteAllOlderThan(min);
    }

    public Iterator<DataIdentifier> getAllIdentifiers() {
        FileDataStore store = this.getTenantDataStore();
        return store.getAllIdentifiers();
    }

    public void clearInUse() {
        FileDataStore store = this.getTenantDataStore();
        store.clearInUse();
    }

    public String getPath() {
        return this.baseHomeDir;
    }

    public void setPath(String directoryName) {
        this.baseHomeDir = directoryName;
    }

    public int getMinRecordLength() {
        return this.minRecordLength;
    }

    public void setMinRecordLength(int minRecordLength) {
        this.minRecordLength = minRecordLength;
    }

    public void close() {
        FileDataStore store = this.getTenantDataStore();
        store.close();
    }

    @Override
    public Set<Integer> getInitializedTenantIds() {
        File home = new File(this.baseHomeDir);
        File parent = home.getParentFile();
        String[] children = parent.list();
        HashSet<Integer> ret = new HashSet<Integer>();
        for (String child : children) {
            try {
                if (child.endsWith("_")) continue;
                ret.add(Integer.parseInt(child.substring(child.lastIndexOf(95) + 1)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }
}

