/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.config;

import com.sas.contentserver.core.config.PrincipalProviderConfig;
import com.sas.contentserver.core.config.SASSecurityManagerConfig;
import java.io.File;
import java.util.Properties;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfigurationParser;
import org.apache.jackrabbit.core.config.SecurityManagerConfig;
import org.apache.jackrabbit.core.config.UserManagerConfig;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.w3c.dom.Element;

public class SASRepositoryConfigurationParser
extends RepositoryConfigurationParser {
    private static final String SYSTEM_PROPERTY_ISCLUSTERED = "com.sas.server.isclustered";
    private static final String PRINCIPAL_PROVIDER_ELEMENT = "PrincipalProvider";

    public SASRepositoryConfigurationParser(Properties variables, ConnectionFactory connectionFactory) {
        super(variables, connectionFactory);
    }

    public SASRepositoryConfigurationParser(Properties variables) {
        super(variables);
    }

    protected ClusterConfig parseClusterConfig(Element parent, File home) throws ConfigurationException {
        String isClustered = System.getProperty(SYSTEM_PROPERTY_ISCLUSTERED);
        if (isClustered != null && isClustered.equals("true")) {
            return super.parseClusterConfig(parent, home);
        }
        return null;
    }

    public SecurityManagerConfig parseSecurityManagerConfig(Element security) throws ConfigurationException {
        SecurityManagerConfig secManConfig = super.parseSecurityManagerConfig(security);
        if (secManConfig != null) {
            Element element;
            Element smElement;
            PrincipalProviderConfig ppConfig = null;
            UserManagerConfig umConfig = secManConfig.getUserManagerConfig();
            if (secManConfig.getUserManagerConfig() != null && (ppConfig = this.parseLegacyUserManager(secManConfig)) != null) {
                umConfig = null;
            }
            if ((smElement = this.getElement(security, "SecurityManager", false)) != null && ((element = this.getElement(smElement, PRINCIPAL_PROVIDER_ELEMENT, false)) != null || ppConfig != null)) {
                if (ppConfig == null) {
                    ppConfig = new PrincipalProviderConfig(this.parseBeanConfig(element));
                }
                Properties props = secManConfig.getParameters();
                props.remove("adminName");
                props.remove("adminPass");
                BeanConfig smBeanConfig = new BeanConfig(secManConfig.getClassName(), props);
                return new SASSecurityManagerConfig(smBeanConfig, secManConfig.getWorkspaceName(), secManConfig.getWorkspaceAccessConfig(), umConfig, null, ppConfig);
            }
        }
        return null;
    }

    private PrincipalProviderConfig parseLegacyUserManager(SecurityManagerConfig secManConfig) {
        if (secManConfig.getUserManagerConfig().getClassName().equals("com.sas.contentserver.security.OMRUserManager")) {
            UserManagerConfig umConfig = secManConfig.getUserManagerConfig();
            Properties props = new Properties();
            props.put("adminName", secManConfig.getParameters().getProperty("adminName"));
            props.put("adminPass", secManConfig.getParameters().getProperty("adminPass"));
            props.put("omrHost", umConfig.getParameters().getProperty("omrHost"));
            props.put("omrPort", umConfig.getParameters().getProperty("omrPort"));
            return new PrincipalProviderConfig(new BeanConfig("com.sas.contentserver.security.OMRPrincipalProvider", props));
        }
        return null;
    }
}

