/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core;

import com.sas.contentserver.commons.SASDavConstants;
import com.sas.contentserver.core.TenantInternalVersionManagerImpl;
import com.sas.contentserver.core.TenantManagedMLRUItemStateCacheFactory;
import com.sas.contentserver.core.TenantSharedItemStateManager;
import com.sas.contentserver.core.data.TenantGarbageCollector;
import com.sas.contentserver.core.lock.SASLockManagerImpl;
import com.sas.contentserver.core.nodetype.TenantNodeTypeRegistry;
import com.sas.contentserver.core.nodetype.TenantVirtualNodeTypeStateManager;
import com.sas.contentserver.core.observation.TenantObservationDispatcher;
import com.sas.contentserver.core.query.lucene.TenantSearchIndex;
import com.sas.contentserver.core.session.SASSessionImpl;
import com.sas.contentserver.core.session.SASSystemSession;
import com.sas.contentserver.security.SASCredentials;
import com.sas.contentserver.security.TenantPrivilegeRegistry;
import com.sas.contentserver.security.TenantSecurityManager;
import com.sas.contentserver.util.DistributedLock;
import com.sas.framework.commons.TenantIdentifier;
import com.sas.framework.commons.holders.TenantHolder;
import com.sas.services.security.login.OMIServerPrincipal;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.security.Privilege;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SearchManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SystemSession;
import org.apache.jackrabbit.core.cluster.PrivilegeEventChannel;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.gc.GarbageCollector;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.virtual.VirtualNodeTypeStateManager;
import org.apache.jackrabbit.core.observation.DelegatingObservationDispatcher;
import org.apache.jackrabbit.core.observation.ObservationDispatcher;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.util.SpecialNameChars;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantRepositoryImpl
extends RepositoryImpl {
    private static Logger log = LoggerFactory.getLogger(TenantRepositoryImpl.class);
    private Map<Integer, Boolean> tenantInitialized = new HashMap<Integer, Boolean>();
    private Map<Integer, PrincipalProvider> createUserPrincipalProviders = new HashMap<Integer, PrincipalProvider>();

    protected TenantRepositoryImpl(RepositoryConfig repConfig) throws RepositoryException {
        super(repConfig);
        TenantManagedMLRUItemStateCacheFactory cacheFactory = new TenantManagedMLRUItemStateCacheFactory(this.getCacheManager());
        this.context.setItemStateCacheFactory((ItemStateCacheFactory)cacheFactory);
    }

    public static TenantRepositoryImpl create(RepositoryConfig config) throws RepositoryException {
        TenantHolder.set((TenantIdentifier)new TenantIdentifier(TenantHolder.get().getId(), "Server"));
        return new TenantRepositoryImpl(config);
    }

    protected void initStartupWorkspaces() throws RepositoryException {
        TenantPrivilegeRegistry tenantPrivilegeRegistry = new TenantPrivilegeRegistry((NamespaceRegistry)this.context.getNamespaceRegistry(), this.context.getFileSystem());
        if (this.context.getClusterNode() != null) {
            tenantPrivilegeRegistry.setEventChannel((PrivilegeEventChannel)this.context.getClusterNode());
        }
        this.context.setPrivilegeRegistry((PrivilegeRegistry)tenantPrivilegeRegistry);
        super.initStartupWorkspaces();
    }

    protected RepositoryImpl.WorkspaceInfo getWorkspaceInfo(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        return super.getWorkspaceInfo(workspaceName);
    }

    protected SharedItemStateManager createItemStateManager(PersistenceManager persistMgr, boolean usesReferences, ISMLocking locking) throws ItemStateException {
        return new TenantSharedItemStateManager(persistMgr, this.context.getRootNodeId(), this.context.getNodeTypeRegistry(), true, this.context.getItemStateCacheFactory(), locking, this.context.getNodeIdFactory());
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        Credentials creds = credentials;
        if (credentials instanceof SASCredentials) {
            SASCredentials sasCreds = (SASCredentials)credentials;
            TenantHolder.set((TenantIdentifier)new TenantIdentifier(sasCreds.getTenant(), "Server"));
            creds = sasCreds.getSimpleCredentials();
        } else {
            TenantHolder.set((TenantIdentifier)new TenantIdentifier(TenantHolder.get().getId(), "Server"));
        }
        this.init(workspaceName);
        SessionImpl session = (SessionImpl)super.login(creds, workspaceName);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init(String wsName) throws NoSuchWorkspaceException, RepositoryException {
        Boolean initialized;
        String workspaceName = wsName;
        if (workspaceName == null) {
            workspaceName = this.repConfig.getDefaultWorkspaceName();
        }
        if (this.tenantInitialized == null) {
            this.tenantInitialized = new HashMap<Integer, Boolean>();
        }
        if ((initialized = this.tenantInitialized.get(TenantHolder.get().getId())) == null || !initialized.booleanValue()) {
            try {
                PropertyDefinitionTemplate customProperty;
                NodeTypeTemplate nodeType;
                DistributedLock.lock();
                log.info("Initializing new tenant id = " + TenantHolder.get().getId());
                TenantWorkspaceInfo wsInfo = (TenantWorkspaceInfo)this.getWorkspaceInfo(workspaceName);
                boolean fullInit = false;
                try {
                    wsInfo.getFileSystem().init();
                    fullInit = true;
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (FileSystemException e) {
                    throw new RepositoryException("Failed to initialize file system", (Throwable)e);
                }
                wsInfo.getItemStateProvider().addVirtualItemStateProvider(this.context.getInternalVersionManager().getVirtualItemStateProvider());
                wsInfo.getItemStateProvider().addVirtualItemStateProvider(this.virtNTMgr.getVirtualItemStateProvider());
                SearchManager searchMgr = super.getSystemSearchManager(super.getWorkspaceNames()[0]);
                SearchManager workspaceSearchMgr = wsInfo.getSearchManager();
                try {
                    if (fullInit) {
                        ((TenantSearchIndex)searchMgr.getQueryHandler()).initNewTenant();
                        ((TenantSearchIndex)workspaceSearchMgr.getQueryHandler()).initNewTenant();
                    }
                    ObservationManager obsMgr = this.getSystemSession(workspaceName).getWorkspace().getObservationManager();
                    obsMgr.addEventListener((EventListener)searchMgr, 31, "/" + this.getSystemSession(workspaceName).getJCRName(NameConstants.JCR_SYSTEM), true, null, null, false);
                    obsMgr.addEventListener((EventListener)workspaceSearchMgr, 31, "/", true, null, null, false);
                }
                catch (IOException e) {
                    log.error("failed to index new tenant", (Throwable)e);
                }
                SystemSession systemSession = this.getSystemSession(workspaceName);
                systemSession.refresh(false);
                this.registerSASPrivileges((SessionImpl)systemSession);
                NodeTypeManager ntMan = systemSession.getWorkspace().getNodeTypeManager();
                if (!ntMan.hasNodeType("enforce-versionable")) {
                    nodeType = ntMan.createNodeTypeTemplate();
                    nodeType.setName("enforce-versionable");
                    nodeType.setMixin(true);
                    customProperty = ntMan.createPropertyDefinitionTemplate();
                    customProperty.setName("jcr:enforce-versionable");
                    customProperty.setRequiredType(6);
                    customProperty.setDefaultValues(new Value[]{systemSession.getValueFactory().createValue(false)});
                    nodeType.getPropertyDefinitionTemplates().add(customProperty);
                    ntMan.registerNodeType((NodeTypeDefinition)nodeType, false);
                }
                if (!ntMan.hasNodeType("owner")) {
                    nodeType = ntMan.createNodeTypeTemplate();
                    nodeType.setName("owner");
                    nodeType.setMixin(true);
                    customProperty = ntMan.createPropertyDefinitionTemplate();
                    customProperty.setName("jcr:owner");
                    customProperty.setRequiredType(1);
                    nodeType.getPropertyDefinitionTemplates().add(customProperty);
                    ntMan.registerNodeType((NodeTypeDefinition)nodeType, false);
                }
                if (!ntMan.hasNodeType("auto-version")) {
                    nodeType = ntMan.createNodeTypeTemplate();
                    nodeType.setName("auto-version");
                    nodeType.setMixin(true);
                    customProperty = ntMan.createPropertyDefinitionTemplate();
                    customProperty.setName("jcr:auto-version");
                    customProperty.setRequiredType(1);
                    nodeType.getPropertyDefinitionTemplates().add(customProperty);
                    ntMan.registerNodeType((NodeTypeDefinition)nodeType, false);
                }
                initialized = Boolean.TRUE;
                this.tenantInitialized.put(TenantHolder.get().getId(), initialized);
            }
            finally {
                DistributedLock.unlock();
            }
        }
    }

    private void registerSASPrivileges(SessionImpl adminSession) throws RepositoryException {
        NamespaceRegistry nsReg = adminSession.getWorkspace().getNamespaceRegistry();
        String[] prefixes = nsReg.getPrefixes();
        boolean sasPrefixExists = false;
        for (int i = 0; i < prefixes.length; ++i) {
            if (!prefixes[i].equals(SASDavConstants.NAMESPACE.getPrefix())) continue;
            sasPrefixExists = true;
        }
        if (!sasPrefixExists) {
            nsReg.registerNamespace(SASDavConstants.NAMESPACE.getPrefix(), SASDavConstants.NAMESPACE.getURI());
        }
        PrivilegeManager pm = ((JackrabbitWorkspace)adminSession.getWorkspace()).getPrivilegeManager();
        Privilege[] registeredPrivs = pm.getRegisteredPrivileges();
        ArrayList<String> registeredPrivNames = new ArrayList<String>();
        for (int i = 0; i < registeredPrivs.length; ++i) {
            registeredPrivNames.add(registeredPrivs[i].getName());
        }
        if (!registeredPrivNames.contains("SASDAV:read")) {
            String[] aggPrivs = new String[]{"{http://www.jcp.org/jcr/1.0}read", "{http://www.jcp.org/jcr/1.0}readAccessControl"};
            pm.registerPrivilege("{http://sas.com/XmlNamespaces/DAV}read", false, aggPrivs);
        }
        if (!registeredPrivNames.contains("SASDAV:write")) {
            String[] aggPrivs = new String[]{"{http://www.jcp.org/jcr/1.0}versionManagement", "{http://www.jcp.org/jcr/1.0}lockManagement", "{http://www.jcp.org/jcr/1.0}nodeTypeManagement", "{http://www.jcp.org/jcr/1.0}addChildNodes", "{http://www.jcp.org/jcr/1.0}modifyProperties"};
            pm.registerPrivilege("{http://sas.com/XmlNamespaces/DAV}write", false, aggPrivs);
        }
        if (!registeredPrivNames.contains("SASDAV:delete")) {
            String[] aggPrivs = new String[]{"{http://www.jcp.org/jcr/1.0}removeNode", "{http://www.jcp.org/jcr/1.0}removeChildNodes"};
            pm.registerPrivilege("{http://sas.com/XmlNamespaces/DAV}delete", false, aggPrivs);
        }
        if (!registeredPrivNames.contains("SASDAV:admin")) {
            String[] aggPrivs = new String[]{"{http://www.jcp.org/jcr/1.0}readAccessControl", "{http://www.jcp.org/jcr/1.0}modifyAccessControl"};
            pm.registerPrivilege("{http://sas.com/XmlNamespaces/DAV}admin", false, aggPrivs);
        }
        if (!registeredPrivNames.contains("SASDAV:inherit-read")) {
            pm.registerPrivilege("{http://sas.com/XmlNamespaces/DAV}inherit-read", false, null);
        }
        if (!registeredPrivNames.contains("SASDAV:inherit-write")) {
            pm.registerPrivilege("{http://sas.com/XmlNamespaces/DAV}inherit-write", false, null);
        }
        if (!registeredPrivNames.contains("SASDAV:inherit-delete")) {
            pm.registerPrivilege("{http://sas.com/XmlNamespaces/DAV}inherit-delete", false, null);
        }
        if (!registeredPrivNames.contains("SASDAV:inherit-admin")) {
            pm.registerPrivilege("{http://sas.com/XmlNamespaces/DAV}inherit-admin", false, null);
        }
    }

    protected RepositoryImpl.WorkspaceInfo createWorkspaceInfo(WorkspaceConfig wspConfig) {
        return new TenantWorkspaceInfo(wspConfig);
    }

    public SystemSession getSystemSession(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        return super.getSystemSession(workspaceName);
    }

    private void checkExists(Subject subject, String workspaceName) throws NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        Set<Principal> principals = subject.getPrincipals();
        String username = "";
        for (Principal principal : principals) {
            if (principal instanceof OMIServerPrincipal && !(username = principal.getName()).equals("")) break;
        }
        if (!username.equals("")) {
            this.getCreateUserPrincipalProvider(workspaceName).getPrincipal(SpecialNameChars.encode((String)username));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrincipalProvider getCreateUserPrincipalProvider(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        Map<Integer, PrincipalProvider> map = this.createUserPrincipalProviders;
        synchronized (map) {
            PrincipalProvider pp = this.createUserPrincipalProviders.get(TenantHolder.get().getId());
            if (pp == null) {
                SystemSession systemSession = ((TenantWorkspaceInfo)this.getWorkspaceInfo(workspaceName)).getCreateUserSystemSession();
                pp = ((TenantSecurityManager)this.context.getSecurityManager()).createUserPrincipalProvider((Session)systemSession);
                this.createUserPrincipalProviders.put(TenantHolder.get().getId(), pp);
            }
            return pp;
        }
    }

    protected SessionImpl createSessionInstance(AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        this.checkExists(loginContext.getSubject(), wspConfig.getName());
        return new SASSessionImpl(this.context, loginContext, wspConfig);
    }

    protected SessionImpl createSessionInstance(Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        this.checkExists(subject, wspConfig.getName());
        return new SASSessionImpl(this.context, subject, wspConfig);
    }

    protected InternalVersionManagerImpl createVersionManager(VersioningConfig vConfig, DelegatingObservationDispatcher delegatingDispatcher) throws RepositoryException {
        FileSystem fs = vConfig.getFileSystem();
        ISMLocking ismLocking = vConfig.getISMLocking();
        return new TenantInternalVersionManagerImpl(vConfig, fs, this.context.getNodeTypeRegistry(), delegatingDispatcher, SYSTEM_ROOT_NODE_ID, VERSION_STORAGE_NODE_ID, ACTIVITIES_NODE_ID, this.context.getItemStateCacheFactory(), ismLocking, this.context.getNodeIdFactory(), this);
    }

    protected VirtualNodeTypeStateManager createVirtualNodeTypeStateManager(NodeTypeRegistry ntReg, DelegatingObservationDispatcher dispatcher, NodeId nodeTypesId, NodeId systemRootId) {
        return new TenantVirtualNodeTypeStateManager(ntReg, dispatcher, nodeTypesId, systemRootId);
    }

    protected PersistenceManager createPersistenceManager(File homeDir, FileSystem fs, PersistenceManagerConfig pmConfig) throws RepositoryException {
        return super.createPersistenceManager(homeDir, fs, pmConfig);
    }

    protected NodeTypeRegistry createNodeTypeRegistry() throws RepositoryException {
        return new TenantNodeTypeRegistry((NamespaceRegistry)this.context.getNamespaceRegistry(), this.context.getFileSystem());
    }

    public LockManagerImpl getLockManager(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        return super.getLockManager(workspaceName);
    }

    public GarbageCollector createDataStoreGarbageCollector() throws RepositoryException {
        ArrayList<PersistenceManager> pmList = new ArrayList<PersistenceManager>();
        InternalVersionManagerImpl vm = this.context.getInternalVersionManager();
        PersistenceManager pm = vm.getPersistenceManager();
        pmList.add(pm);
        String[] wspNames = this.getWorkspaceNames();
        SessionImpl[] sessions = new SessionImpl[wspNames.length];
        for (int i = 0; i < wspNames.length; ++i) {
            String wspName = wspNames[i];
            TenantWorkspaceInfo wspInfo = (TenantWorkspaceInfo)this.getWorkspaceInfo(wspName);
            SystemSession systemSession = SystemSession.create((RepositoryContext)this.context, (WorkspaceConfig)wspInfo.getConfig());
            wspInfo.setActive(true);
            wspInfo.doInitialize();
            sessions[i] = systemSession;
            pm = wspInfo.getPersistenceManager();
            pmList.add(pm);
        }
        IterablePersistenceManager[] ipmList = new IterablePersistenceManager[pmList.size()];
        for (int i = 0; i < pmList.size(); ++i) {
            pm = (PersistenceManager)pmList.get(i);
            if (!(pm instanceof IterablePersistenceManager)) {
                ipmList = null;
                break;
            }
            ipmList[i] = (IterablePersistenceManager)pm;
        }
        return new TenantGarbageCollector(this.context, this.context.getDataStore(), ipmList, sessions);
    }

    protected class TenantWorkspaceInfo
    extends RepositoryImpl.WorkspaceInfo {
        private Map<Integer, SystemSession> initializedSystemSessions;
        private Map<Integer, SystemSession> createUserSystemSessions;

        protected TenantWorkspaceInfo(WorkspaceConfig config) {
            super((RepositoryImpl)TenantRepositoryImpl.this, config);
            this.initializedSystemSessions = new HashMap<Integer, SystemSession>();
            this.createUserSystemSessions = new HashMap<Integer, SystemSession>();
        }

        protected FileSystem getFileSystem() {
            return super.getFileSystem();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SystemSession getSystemSession() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            TenantWorkspaceInfo tenantWorkspaceInfo = this;
            synchronized (tenantWorkspaceInfo) {
                SystemSession ret = null;
                ret = this.initializedSystemSessions.get(TenantHolder.get().getId());
                if (ret == null) {
                    ret = SASSystemSession.create(TenantRepositoryImpl.this.context, this.getConfig());
                    this.initializedSystemSessions.put(TenantHolder.get().getId(), ret);
                }
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SystemSession getCreateUserSystemSession() throws RepositoryException {
            Map<Integer, SystemSession> map = this.createUserSystemSessions;
            synchronized (map) {
                SystemSession ret = null;
                ret = this.createUserSystemSessions.get(TenantHolder.get().getId());
                if (ret == null) {
                    ret = SASSystemSession.create(TenantRepositoryImpl.this.context, this.getConfig());
                    this.createUserSystemSessions.put(TenantHolder.get().getId(), ret);
                }
                return ret;
            }
        }

        protected ObservationDispatcher createObservationDispatcher() {
            return new TenantObservationDispatcher();
        }

        protected SearchManager getSearchManager() throws RepositoryException {
            return super.getSearchManager();
        }

        protected SharedItemStateManager getItemStateProvider() throws RepositoryException {
            return super.getItemStateProvider();
        }

        protected LockManagerImpl createLockManager() throws RepositoryException {
            return new SASLockManagerImpl((SessionImpl)this.getSystemSession(), this.getFileSystem(), TenantRepositoryImpl.this.context.getExecutor());
        }

        public PersistenceManager getPersistenceManager() throws RepositoryException {
            return super.getPersistenceManager();
        }

        protected final void doInitialize() throws RepositoryException {
            super.doInitialize();
        }
    }
}

