/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core;

import com.sas.framework.commons.holders.TenantHolder;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.core.cache.CacheManager;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCache;
import org.apache.jackrabbit.core.state.MLRUItemStateCache;

public class TenantMLRUItemStateCache
implements ItemStateCache {
    private CacheManager cacheMgr;
    private Map<Integer, MLRUItemStateCache> tenantCaches;

    public TenantMLRUItemStateCache(CacheManager cacheMgr) {
        this.cacheMgr = cacheMgr;
        this.tenantCaches = new HashMap<Integer, MLRUItemStateCache>();
    }

    public void cache(ItemState state) {
        this.getTenantCache().cache(state);
    }

    public void dispose() {
        this.getTenantCache().dispose();
    }

    public void evict(ItemId id) {
        this.getTenantCache().evict(id);
    }

    public void evictAll() {
        this.getTenantCache().evictAll();
    }

    public boolean isCached(ItemId id) {
        return this.getTenantCache().isCached(id);
    }

    public boolean isEmpty() {
        return this.getTenantCache().isEmpty();
    }

    public ItemState retrieve(ItemId id) {
        return this.getTenantCache().retrieve(id);
    }

    public ItemState[] retrieveAll() {
        return this.getTenantCache().retrieveAll();
    }

    private MLRUItemStateCache getTenantCache() {
        MLRUItemStateCache cache = this.tenantCaches.get(TenantHolder.get().getId());
        if (cache == null) {
            cache = new MLRUItemStateCache(this.cacheMgr);
            this.tenantCaches.put(TenantHolder.get().getId(), cache);
        }
        return cache;
    }
}

