/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core;

import com.sas.contentserver.core.SASBatchedItemOperations;
import com.sas.contentserver.core.TenantRepositoryImpl;
import com.sas.contentserver.core.lock.SASXALockManager;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.WorkspaceManager;
import org.apache.jackrabbit.core.XASessionImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASWorkspaceImpl
extends WorkspaceImpl {
    private Logger log = LoggerFactory.getLogger(SASWorkspaceImpl.class);

    public SASWorkspaceImpl(SessionContext context, WorkspaceConfig wspConfig) throws RepositoryException {
        super(context, wspConfig);
    }

    public synchronized LockManager getInternalLockManager() throws RepositoryException {
        this.sanityCheck();
        if (this.lockMgr == null) {
            this.lockMgr = ((TenantRepositoryImpl)this.context.getRepository()).getLockManager(this.wspConfig.getName());
            if (this.context.getSessionImpl() instanceof XASessionImpl) {
                this.lockMgr = new SASXALockManager((LockManagerImpl)this.lockMgr);
            }
        }
        return this.lockMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        Path destPath;
        Path srcPath;
        this.sanityCheck();
        try {
            srcPath = this.context.getQPath(srcAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + srcAbsPath;
            this.log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        if (!srcPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + srcAbsPath);
        }
        try {
            destPath = this.context.getQPath(destAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + destAbsPath;
            this.log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        if (!destPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + destAbsPath);
        }
        SASBatchedItemOperations ops = new SASBatchedItemOperations((UpdatableItemStateManager)this.stateMgr, this.context);
        try {
            ops.edit();
        }
        catch (IllegalStateException e) {
            String msg = "unable to start edit operation";
            this.log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        boolean succeeded = false;
        try {
            ops.move(srcPath, destPath);
            ops.update();
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                ops.cancel();
            }
        }
    }

    public void copy(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.sanityCheck();
        this.internalCopy(srcAbsPath, this, destAbsPath, SASBatchedItemOperations.getCopyFlag());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(String srcWorkspace, String srcAbsPath, String destAbsPath) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.sanityCheck();
        if (this.getName().equals(srcWorkspace)) {
            this.copy(srcAbsPath, destAbsPath);
            return;
        }
        if (!this.context.getAccessManager().canAccess(srcWorkspace)) {
            throw new AccessDeniedException("not authorized to access " + srcWorkspace);
        }
        SessionImpl srcSession = null;
        try {
            WorkspaceManager manager = this.context.getRepositoryContext().getWorkspaceManager();
            srcSession = manager.createSession(this.session.getSubject(), srcWorkspace);
            WorkspaceImpl srcWsp = (WorkspaceImpl)srcSession.getWorkspace();
            this.internalCopy(srcAbsPath, srcWsp, destAbsPath, SASBatchedItemOperations.getCopyFlag());
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String internalCopy(String srcAbsPath, WorkspaceImpl srcWsp, String destAbsPath, int flag) throws ConstraintViolationException, AccessDeniedException, VersionException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        Path destPath;
        Path srcPath;
        try {
            srcPath = this.context.getQPath(srcAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + srcAbsPath;
            this.log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        if (!srcPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + srcAbsPath);
        }
        try {
            destPath = this.context.getQPath(destAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + destAbsPath;
            this.log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        if (!destPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + destAbsPath);
        }
        SASBatchedItemOperations ops = new SASBatchedItemOperations((UpdatableItemStateManager)this.stateMgr, this.context);
        try {
            ops.edit();
        }
        catch (IllegalStateException e) {
            String msg = "unable to start edit operation";
            this.log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        boolean succeeded = false;
        try {
            NodeId id = ops.copy(srcPath, (ItemStateManager)srcWsp.getItemStateManager(), srcWsp.getHierarchyManager(), this.context.getAccessManager(), destPath, flag);
            ops.update();
            succeeded = true;
            String string = this.context.getJCRPath(this.hierMgr.getPath((ItemId)id));
            return string;
        }
        finally {
            if (!succeeded) {
                ops.cancel();
            }
        }
    }
}

