/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core;

import com.sas.contentserver.security.SASDefaultAccessManager;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.core.AbstractNodeData;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SystemSession;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASNodeImpl
extends NodeImpl {
    static Logger log = LoggerFactory.getLogger(SASNodeImpl.class);

    protected SASNodeImpl(ItemManager itemMgr, SessionContext sessionContext, AbstractNodeData data) {
        super(itemMgr, sessionContext, data);
    }

    public void save() throws RepositoryException {
        if (!(this.getSession() instanceof SystemSession)) {
            ArrayList<ItemState> newStates = new ArrayList<ItemState>();
            SessionItemStateManager sism = this.sessionContext.getItemStateManager();
            if (this.getItemState().isTransient() && this.getItemState().getStatus() == 4) {
                newStates.add(this.getItemState());
            }
            for (ItemState transientState : sism.getDescendantTransientItemStates(this.getItemState().getId())) {
                if (!transientState.isNode() || transientState.getStatus() != 4) continue;
                newStates.add(transientState);
            }
            if (newStates.size() > 0) {
                Session session = this.getSession();
                SASDefaultAccessManager acMan = (SASDefaultAccessManager)session.getAccessControlManager();
                for (ItemState state : newStates) {
                    try {
                        acMan.propagateSASInheritedPrivileges(session, sism, (NodeState)state);
                    }
                    catch (ItemStateException e) {
                        throw new RepositoryException("Failed to propagate inherited permissions", (Throwable)e);
                    }
                }
            }
        }
        super.save();
    }
}

