/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core;

import com.sas.contentserver.core.TenantRepositoryImpl;
import com.sas.contentserver.core.config.SASRepositoryConfig;
import com.sas.contentserver.core.jndi.SASRegistryHelper;
import com.sas.contentserver.security.SASDefaultAccessManager;
import java.io.File;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import javax.jcr.security.Privilege;
import javax.jcr.version.VersionException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclConverter {
    private static Logger log = LoggerFactory.getLogger(AclConverter.class);
    private static List<Node> versionedNodes = new ArrayList<Node>();
    private static PrincipalManager principalManager;

    public static void main(String[] args) {
        if (args.length != 3) {
            log.info("Usage:");
            log.info("  AclConverter tgtRepoDir adminUser adminPass");
            System.exit(8);
        }
        SASRegistryHelper.registerJNDIDataSources();
        File target = new File(args[0]);
        String adminUser = args[1];
        String adminPass = args[2];
        if (!target.exists()) {
            log.error("Target file '" + target + "' does not exist");
            System.exit(8);
        } else {
            TenantRepositoryImpl targetRepository = null;
            File repoDir = new File(target, "repository");
            FileUtils.deleteQuietly((File)new File(repoDir, "index"));
            File[] workspaces = new File(target, "workspaces").listFiles();
            if (workspaces != null) {
                for (File workspace : workspaces) {
                    FileUtils.deleteQuietly((File)new File(workspace, "index"));
                }
            }
            try {
                RepositoryConfig configTarget = SASRepositoryConfig.create(new File(target, "repository.xml").getAbsolutePath(), target.getAbsolutePath());
                targetRepository = TenantRepositoryImpl.create(configTarget);
                SessionImpl session = (SessionImpl)targetRepository.login((Credentials)new SimpleCredentials(adminUser, adminPass.toCharArray()), configTarget.getDefaultWorkspaceName());
                principalManager = session.getPrincipalManager();
                AclConverter.fixAcls(session);
                TenantRepositoryImpl.TenantWorkspaceInfo wsInfo = (TenantRepositoryImpl.TenantWorkspaceInfo)targetRepository.getWorkspaceInfo(configTarget.getDefaultWorkspaceName());
                PersistenceManager pMgr = wsInfo.getPersistenceManager();
                log.debug("Converting and removing " + versionedNodes.size() + " versioned nodes that failed initial attempt");
                for (Node node : versionedNodes) {
                    ChangeLog changes = new ChangeLog();
                    NodeId nodeId = new NodeId(node.getIdentifier());
                    NodeState nodeState = pMgr.load(nodeId);
                    NodeState parent = pMgr.load(nodeState.getParentId());
                    Set mixins = parent.getMixinTypeNames();
                    mixins.add(AccessControlConstants.NT_REP_ACCESS_CONTROLLABLE);
                    parent.setMixinTypeNames(mixins);
                    NodeState policyNodeState = new NodeState(NodeId.randomId(), AccessControlConstants.NT_REP_ACL, parent.getNodeId(), 4, true);
                    changes.added((ItemState)policyNodeState);
                    parent.addChildNodeEntry(AccessControlConstants.N_POLICY, policyNodeState.getNodeId());
                    changes.modified((ItemState)parent);
                    SASDefaultAccessManager acMan = (SASDefaultAccessManager)node.getSession().getAccessControlManager();
                    NodeIterator iter = node.getNodes("jcr:ace");
                    HashMap aces = new HashMap();
                    while (iter.hasNext()) {
                        Node ace = iter.nextNode();
                        String principal = ace.getProperty("jcr:principal").getString();
                        if (principal.startsWith("person/") || principal.startsWith("group/")) {
                            principal = principal.substring(principal.indexOf("/") + 1);
                        }
                        Value[] values = ace.getProperty("jcr:grant").getValues();
                        ArrayList<Privilege> privs = new ArrayList<Privilege>();
                        for (Value v : values) {
                            if (v.getString().equals("jcr:READ")) {
                                privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}read"));
                                continue;
                            }
                            if (v.getString().equals("jcr:WRITE")) {
                                privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}write"));
                                continue;
                            }
                            if (v.getString().equals("rep:REMOVE")) {
                                privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}delete"));
                                continue;
                            }
                            if (v.getString().equals("rep:ADMIN")) {
                                privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}admin"));
                                continue;
                            }
                            if (v.getString().equals("rep:INHERIT-READ")) {
                                privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-read"));
                                continue;
                            }
                            if (v.getString().equals("rep:INHERIT-WRITE")) {
                                privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-write"));
                                continue;
                            }
                            if (v.getString().equals("rep:INHERIT-REMOVE")) {
                                privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-delete"));
                                continue;
                            }
                            if (!v.getString().equals("rep:INHERIT-ADMIN")) continue;
                            privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-admin"));
                        }
                        aces.put(principal, privs);
                        NodeId aceId = new NodeId(ace.getIdentifier());
                        nodeState.removeChildNodeEntry(aceId);
                        changes.modified((ItemState)nodeState);
                        changes.deleted((ItemId)aceId);
                    }
                    NameFactory NF = NameFactoryImpl.getInstance();
                    int aceCount = -1;
                    for (String principal : aces.keySet()) {
                        List privs = (List)aces.get(principal);
                        NodeState ace = new NodeState(NodeId.randomId(), AccessControlConstants.NT_REP_GRANT_ACE, policyNodeState.getNodeId(), 4, true);
                        changes.added((ItemState)ace);
                        if (aceCount == -1) {
                            policyNodeState.addChildNodeEntry(NF.create("{}allow"), ace.getNodeId());
                        } else {
                            policyNodeState.addChildNodeEntry(NF.create("{}allow" + aceCount), ace.getNodeId());
                        }
                        PropertyState primaryType = new PropertyState(new PropertyId(ace.getNodeId(), NameConstants.JCR_PRIMARYTYPE), 4, true);
                        changes.added((ItemState)primaryType);
                        primaryType.setType(7);
                        primaryType.setValues(new InternalValue[]{InternalValue.create((Name)AccessControlConstants.NT_REP_GRANT_ACE)});
                        ace.addPropertyName(NameConstants.JCR_PRIMARYTYPE);
                        PropertyState principalProperty = new PropertyState(new PropertyId(ace.getNodeId(), AccessControlConstants.P_PRINCIPAL_NAME), 4, true);
                        changes.added((ItemState)principalProperty);
                        principalProperty.setType(1);
                        principalProperty.setValues(new InternalValue[]{InternalValue.create((String)principal)});
                        ace.addPropertyName(AccessControlConstants.P_PRINCIPAL_NAME);
                        PropertyState globProperty = new PropertyState(new PropertyId(ace.getNodeId(), AccessControlConstants.P_GLOB), 4, true);
                        changes.added((ItemState)globProperty);
                        globProperty.setType(1);
                        globProperty.setValues(new InternalValue[]{InternalValue.create((String)"")});
                        ace.addPropertyName(AccessControlConstants.P_GLOB);
                        PropertyState privProperty = new PropertyState(new PropertyId(ace.getNodeId(), AccessControlConstants.P_PRIVILEGES), 4, true);
                        changes.added((ItemState)privProperty);
                        privProperty.setType(7);
                        privProperty.setMultiValued(true);
                        InternalValue[] privValues = new InternalValue[privs.size()];
                        int privCount = 0;
                        for (Privilege priv : privs) {
                            String stringPriv = priv.getName();
                            String namespaceUri = node.getSession().getNamespaceURI(stringPriv.substring(0, stringPriv.indexOf(58)));
                            privValues[privCount] = InternalValue.create((Name)NF.create(namespaceUri, stringPriv.substring(stringPriv.indexOf(58) + 1)));
                            ++privCount;
                        }
                        privProperty.setValues(privValues);
                        ace.addPropertyName(AccessControlConstants.P_PRIVILEGES);
                        ++aceCount;
                        changes.modified((ItemState)ace);
                    }
                    changes.modified((ItemState)policyNodeState);
                    pMgr.store(changes);
                    changes.reset();
                    parent.removeChildNodeEntry(nodeId);
                    changes.modified((ItemState)parent);
                    changes.deleted((ItemId)nodeId);
                    pMgr.store(changes);
                }
                log.info("Finished converting ACLs. Shutting down repository...");
                targetRepository.shutdown();
            }
            catch (ItemStateException e) {
                log.error("ItemStateException", (Throwable)e);
                System.exit(8);
            }
            catch (LoginException e) {
                log.error("LoginException", (Throwable)e);
                System.exit(8);
            }
            catch (NoSuchWorkspaceException e) {
                log.error("NoSuchWorkspaceException", (Throwable)e);
                System.exit(8);
            }
            catch (RepositoryException e) {
                log.error("RepositoryException", (Throwable)e);
                System.exit(8);
            }
        }
        System.exit(0);
    }

    private static void fixAcls(SessionImpl session) throws RepositoryException {
        session.refresh(true);
        NodeTypeManager ntMan = session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate ntAclTemplate = ntMan.createNodeTypeTemplate();
        NodeTypeTemplate ntAceTemplate = ntMan.createNodeTypeTemplate();
        ntAclTemplate.setName("nt:acl");
        ntAceTemplate.setName("nt:ace");
        PropertyDefinitionTemplate grantProperty = ntMan.createPropertyDefinitionTemplate();
        grantProperty.setName("jcr:grant");
        grantProperty.setRequiredType(1);
        grantProperty.setMultiple(true);
        ntAceTemplate.getPropertyDefinitionTemplates().add(grantProperty);
        try {
            if (ntMan.hasNodeType("nt:acl")) {
                ntMan.unregisterNodeType("nt:acl");
            }
            ntMan.registerNodeType((NodeTypeDefinition)ntAclTemplate, false);
            session.save();
        }
        catch (NodeTypeExistsException e) {
            log.warn("NodeTypeExistsException", (Throwable)e);
        }
        try {
            if (ntMan.hasNodeType("nt:ace")) {
                ntMan.unregisterNodeType("nt:ace");
            }
            ntMan.registerNodeType((NodeTypeDefinition)ntAceTemplate, false);
            session.save();
        }
        catch (NodeTypeExistsException e) {
            log.warn("NodeTypeExistsException", (Throwable)e);
        }
        Node root = session.getRootNode();
        AclConverter.convertAcls(root);
        try {
            ntMan.unregisterNodeType("nt:acl");
            ntMan.unregisterNodeType("nt:ace");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    private static void convertAcls(Node node) throws RepositoryException {
        log.debug("processing node = " + node.getPath());
        if (!node.hasNodes()) {
            log.debug("\tno child nodes, returning");
            return;
        }
        if (node.hasNode("jcr:acl") && !node.getPath().contains("jcr:frozenNode")) {
            log.debug("\tfound jcr:acl");
            Node acl = node.getNode("jcr:acl");
            NodeIterator iter = acl.getNodes();
            while (iter.hasNext()) {
                int i;
                Node ace = iter.nextNode();
                if (!ace.getName().equals("jcr:ace")) continue;
                String principal = "";
                String[] stringPrivs = null;
                PropertyIterator propIter = ace.getProperties();
                while (propIter.hasNext()) {
                    Property prop = propIter.nextProperty();
                    if (prop.getName().equals("jcr:principal") && ((principal = prop.getString()).startsWith("person/") || principal.startsWith("group/"))) {
                        principal = principal.substring(principal.indexOf("/") + 1);
                    }
                    if (!prop.getName().equals("jcr:grant")) continue;
                    Value[] values = prop.getValues();
                    stringPrivs = new String[values.length];
                    for (i = 0; i < values.length; ++i) {
                        stringPrivs[i] = values[i].getString();
                    }
                }
                if (stringPrivs == null) continue;
                SASDefaultAccessManager acMan = (SASDefaultAccessManager)node.getSession().getAccessControlManager();
                String printString = "";
                for (i = 0; i < stringPrivs.length; ++i) {
                    printString = printString + stringPrivs[i] + "/";
                }
                log.debug("\t\tconverting ace for principal = " + principal + " with privs = " + printString);
                ArrayList<Privilege> privs = new ArrayList<Privilege>();
                for (int i2 = 0; i2 < stringPrivs.length; ++i2) {
                    if (stringPrivs[i2].equals("jcr:READ")) {
                        privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}read"));
                        continue;
                    }
                    if (stringPrivs[i2].equals("jcr:WRITE")) {
                        privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}write"));
                        continue;
                    }
                    if (stringPrivs[i2].equals("rep:REMOVE")) {
                        privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}delete"));
                        continue;
                    }
                    if (stringPrivs[i2].equals("rep:ADMIN")) {
                        privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}admin"));
                        continue;
                    }
                    if (stringPrivs[i2].equals("rep:INHERIT-READ")) {
                        privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-read"));
                        continue;
                    }
                    if (stringPrivs[i2].equals("rep:INHERIT-WRITE")) {
                        privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-write"));
                        continue;
                    }
                    if (stringPrivs[i2].equals("rep:INHERIT-REMOVE")) {
                        privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-delete"));
                        continue;
                    }
                    if (!stringPrivs[i2].equals("rep:INHERIT-ADMIN")) continue;
                    privs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-admin"));
                }
                if (!principalManager.hasPrincipal(principal)) {
                    log.debug("*** Principal '" + principal + "' does not exist for '" + node.getPath() + "' privileges = " + ((Object)privs).toString());
                    continue;
                }
                log.debug("\t\tsetting sas privs for principal = " + principal + " with privs = " + ((Object)privs).toString());
                if (principal.equals("jcr:owner")) {
                    ArrayList<Privilege> ownerPrivs = new ArrayList<Privilege>();
                    ownerPrivs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}read"));
                    ownerPrivs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-read"));
                    ownerPrivs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}admin"));
                    ownerPrivs.add(acMan.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-admin"));
                    for (Privilege priv : ownerPrivs) {
                        if (privs.contains(priv)) continue;
                        log.debug("owner principal missing default priv = " + priv.getName() + ". Adding...");
                        privs.add(priv);
                    }
                }
                acMan.setSASPermissions((Principal)new PrincipalImpl(principal), node, privs);
            }
            try {
                acl.remove();
            }
            catch (VersionException e) {
                versionedNodes.add(acl);
            }
        }
        node.getSession().save();
        NodeIterator children = node.getNodes();
        while (children.hasNext()) {
            AclConverter.convertAcls(children.nextNode());
        }
    }
}

