/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.regions;

import com.sas.MissingValues;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RPFUtil;
import com.sas.graphics.applets.statgraph.sgchart.entry.AutoLegendInterface;
import com.sas.graphics.applets.statgraph.sgchart.legend.SizeLegendInterface;
import com.sas.graphics.applets.statgraph.sgchart.regions.RB;
import com.sas.graphics.applets.statgraph.sgchart.regions.Region;
import com.sas.graphics.applets.statgraph.sgchart.ui.CHTagLoader;
import com.sas.graphics.common.attrmap.ContinuousRangeColorMapper;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.FrequencyVariable;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.LineStyle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeResponseNode;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.graphics.util.gtk.render.tile.TileChartRenderer;
import com.sas.graphics.util.gtk.render.tile.TileChartRendererModel;
import com.sas.graphics.util.gtk.render.tile.TileSelectDetail;
import com.sas.graphics.util.legend.ContinuousLegendInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.text.Format;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class TileRegion
extends Region
implements ContinuousLegendInterface,
SizeLegendInterface,
AutoLegendInterface {
    protected TileChartRenderer tile = new TileChartRenderer();
    protected TileChartRendererModel model = this.tile.getRendererModel();
    protected String[] tileByVars;
    protected String sizeVar;
    protected String colorResponseVar;
    protected String colorGroupVar;
    protected String urlVar;
    protected Channel ch;
    private Color sizeLegendItemFillColor = null;
    private Color sizeLegendItemOutlineColor = null;

    public TileRegion() {
        this.setDefaultValues();
    }

    protected void setDefaultValues() {
        this.model.setLayout(RendererUtil.TileChartLayout.LAYOUT_STANDARD);
        this.model.setOutlineLineStyle(new LineStyle(), 1);
        this.model.setDataLabelTextStyle(new TextStyle());
        this.model.setDataLabelLevel(1);
        this.model.setDataLabelVisible(true);
        this.model.setStatusLineTextStyle(new TextStyle());
        this.model.setStatusLineVisible(true);
        this.model.setShowCHMargin(true);
    }

    public TileChartRendererModel getTileModel() {
        return this.model;
    }

    public String[] getTileByVars() {
        return this.tileByVars;
    }

    public void setTileByVars(String[] tileBy) {
        this.tileByVars = tileBy;
    }

    public String getSizeVar() {
        return this.sizeVar;
    }

    public void setSizeVariable(String size) {
        this.sizeVar = size;
    }

    public String getColorResponseVar() {
        return this.colorResponseVar;
    }

    public void setColorResponseVariable(String clr) {
        this.colorResponseVar = clr;
    }

    public String getColorGroupVar() {
        return this.colorGroupVar;
    }

    public void setColorGroupVariable(String clr) {
        this.colorGroupVar = clr;
    }

    public String getURLVar() {
        return this.urlVar;
    }

    public void setURLVar(String urlVar) {
        this.urlVar = urlVar;
    }

    protected void connectVars() {
        ColumnMetadata cmd;
        if (this.dataModel.getOLAPData() != null) {
            this.connectOLAPVars();
            return;
        }
        StringVectorVariable[] tv = null;
        if (this.tileByVars != null && this.tileByVars.length > 0) {
            tv = new StringVectorVariable[this.tileByVars.length];
            for (int i = 0; i < this.tileByVars.length; ++i) {
                int tvIDX = this.dataModel.getColumn(this.tileByVars[i]);
                tv[i] = new StringVectorVariable();
                tv[i].setBlankMissing(true);
                tv[i].connectFrom(this.dataModel.getColumnAsClassColumn(tvIDX, !this.filterMissing()));
                cmd = (ColumnMetadata)this.dataModel.getColumnLabel(tvIDX);
                tv[i].setLabel(cmd.getLabel());
                tv[i].setFormat(new GTKFormat((Format)cmd.getFormat()));
            }
        }
        NumericVectorVariable sv = null;
        if (this.sizeVar != null) {
            sv = new NumericVectorVariable();
            int svIDX = this.dataModel.getColumn(this.sizeVar);
            sv.connectFrom(this.dataModel.getDoubleColumn(svIDX));
            cmd = (ColumnMetadata)this.dataModel.getColumnLabel(svIDX);
            sv.setLabel(cmd.getLabel());
            sv.setFormat(new GTKFormat((Format)cmd.getFormat()));
        }
        NumericVectorVariable clrv = null;
        if (this.colorResponseVar != null) {
            clrv = new NumericVectorVariable();
            int clrvIDX = this.dataModel.getColumn(this.colorResponseVar);
            clrv.connectFrom(this.dataModel.getDoubleColumn(clrvIDX));
            ColumnMetadata cmd2 = (ColumnMetadata)this.dataModel.getColumnLabel(clrvIDX);
            clrv.setLabel(cmd2.getLabel());
            clrv.setFormat(new GTKFormat((Format)cmd2.getFormat()));
        }
        StringVectorVariable clrgr = null;
        if (this.colorGroupVar != null) {
            clrgr = new StringVectorVariable();
            int clrgrIDX = this.dataModel.getColumn(this.colorGroupVar);
            clrgr.connectFrom(this.dataModel.getColumnAsClassColumn(clrgrIDX));
            ColumnMetadata cmd3 = (ColumnMetadata)this.dataModel.getColumnLabel(clrgrIDX);
            clrgr.setLabel(cmd3.getLabel());
            clrgr.setFormat(new GTKFormat((Format)cmd3.getFormat()));
        }
        this.model.setTileVariable((Variable[])tv);
        Variable[] tileVarArr = this.model.getTileVariable();
        int rowCount = this.dataModel.getRowCount();
        int missingRowCount = 0;
        if (tileVarArr != null && !StatGraph.includeMissingDiscrete) {
            block1: for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < tileVarArr.length; ++j) {
                    if (!tileVarArr[j].isMissing(i)) continue;
                    ++missingRowCount;
                    continue block1;
                }
            }
        }
        if (rowCount == missingRowCount) {
            this.model.setIsAllMissingRows(true);
        }
        if (sv == null || !this.isValidSizeVariable((NumericVariable)sv)) {
            this.model.setSizeRoleIsFrequencyRole(true);
            FrequencyVariable freq = new FrequencyVariable();
            freq.setLabel(RB.getStringResource("TileRegion.frequency.txt"));
            this.model.setSizeVariable((NumericVariable)freq);
        } else {
            this.model.setSizeVariable((NumericVariable)sv);
        }
        if (clrv != null) {
            this.model.setColorVariable((Variable)clrv);
        } else if (clrgr != null) {
            this.model.setColorVariable((Variable)clrgr);
            this.model.setColorVariableDiscrete(true);
        }
        if (this.dataTipVars != null) {
            this.model.setDataTipVariableArray(this.dataTipVars);
        } else {
            int len = tv.length;
            if (this.sizeVar != null) {
                ++len;
            }
            if (this.colorResponseVar != null) {
                ++len;
            }
            if (this.colorGroupVar != null) {
                ++len;
            }
            Variable[] defaultVars = new Variable[len];
            for (int i = 0; i < tv.length; ++i) {
                defaultVars[i] = tv[i];
            }
            int cnt = tv.length;
            if (this.sizeVar != null) {
                defaultVars[cnt++] = sv;
            }
            if (this.colorResponseVar != null) {
                defaultVars[cnt++] = clrv;
            }
            if (this.colorGroupVar != null) {
                defaultVars[cnt++] = clrgr;
            }
            this.model.setDataTipVariableArray(defaultVars);
        }
        this.initConditionalHiliting();
        this.model.setIncludeMissingDiscreteValue(StatGraph.includeMissingDiscrete);
        this.model.setDataTree(this.tile.createDataTree());
    }

    private boolean filterMissing() {
        boolean allMissing = false;
        boolean useFreqForSize = false;
        Variable[] tileVarArr = this.model.getTileVariable();
        int rowCount = this.dataModel.getRowCount();
        int missingRowCount = 0;
        if (tileVarArr != null) {
            block0: for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < tileVarArr.length; ++j) {
                    if (!tileVarArr[j].isMissing(i)) continue;
                    ++missingRowCount;
                    continue block0;
                }
            }
        }
        if (rowCount == missingRowCount) {
            allMissing = true;
        }
        NumericVectorVariable sv = null;
        if (this.sizeVar != null) {
            sv = new NumericVectorVariable();
            int svIDX = this.dataModel.getColumn(this.sizeVar);
            sv.connectFrom(this.dataModel.getDoubleColumn(svIDX));
            ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(svIDX);
            sv.setLabel(cmd.getLabel());
            sv.setFormat(new GTKFormat((Format)cmd.getFormat()));
        }
        if (sv == null || !this.isValidSizeVariable((NumericVariable)sv)) {
            useFreqForSize = true;
        }
        return !StatGraph.includeMissingDiscrete && !allMissing && !useFreqForSize;
    }

    protected void connectOLAPVars() {
        OLAPDataSetInterface olapData = this.dataModel.getOLAPData();
        OLAPVariableFactory fac = null;
        try {
            fac = new OLAPVariableFactory((ResultSetInterface)olapData);
        }
        catch (OLAPException ex) {
            ex.printStackTrace();
            return;
        }
        Variable[] tv = null;
        if (this.tileByVars != null && this.tileByVars.length > 0) {
            tv = new Variable[this.tileByVars.length];
            for (int i = 0; i < this.tileByVars.length; ++i) {
                tv[i] = StatGraph.getOLAPLevelVar(fac, this.tileByVars[i]);
            }
        }
        NumericVariable sv = null;
        if (this.sizeVar == null) {
            VariableProcessor vp = new VariableProcessor();
            for (int i = 0; i < tv.length; ++i) {
                vp.addGroupVariable(tv[i]);
            }
            FrequencyVariable sizeVariable = new FrequencyVariable();
            sizeVariable.setLabel(RB.getStringResource("TileRegion.frequency.txt"));
            vp.addVariable((Variable)sizeVariable);
            vp.init();
            this.model.setSizeVariable((NumericVariable)sizeVariable);
        } else {
            sv = StatGraph.getOLAPMeasureVar(this.crd, (short)7);
        }
        NumericVariable clrv = null;
        if (this.colorResponseVar != null) {
            clrv = StatGraph.getOLAPMeasureVar(this.crd, (short)108);
        }
        StringVariable clrgr = null;
        if (this.colorGroupVar != null) {
            clrgr = StatGraph.getOLAPLevelVar(fac, this.colorGroupVar);
        }
        this.model.setTileVariable(tv);
        this.model.setSizeVariable(sv);
        if (clrv != null) {
            this.model.setColorVariable((Variable)clrv);
        } else if (clrgr != null) {
            this.model.setColorVariable((Variable)clrgr);
            this.model.setColorVariableDiscrete(true);
        }
        if (this.dataTipVars != null) {
            this.model.setDataTipVariableArray(this.dataTipVars);
        } else {
            int len = tv.length;
            if (this.sizeVar != null) {
                ++len;
            }
            if (this.colorResponseVar != null) {
                ++len;
            }
            if (this.colorGroupVar != null) {
                ++len;
            }
            Variable[] defaultVars = new Variable[len];
            for (int i = 0; i < tv.length; ++i) {
                defaultVars[i] = tv[i];
            }
            int cnt = tv.length;
            if (this.sizeVar != null) {
                defaultVars[cnt++] = sv;
            }
            if (this.colorResponseVar != null) {
                defaultVars[cnt++] = clrv;
            }
            if (this.colorGroupVar != null) {
                defaultVars[cnt++] = clrgr;
            }
            this.model.setDataTipVariableArray(defaultVars);
        }
        this.initConditionalHiliting();
        this.model.setDataTree((DefaultMutableTreeNode)this.createTreeOLAP(fac));
    }

    private void initConditionalHiliting() {
        this.setCHPipe(RPFUtil.applyConditionalHiliting(this.dataModel, null, 12));
        if (this.isConditionalHilited()) {
            Image tag = CHTagLoader.get(1, true, this);
            this.model.setCHImage(tag);
            NumericVectorVariable nv = new NumericVectorVariable();
            nv.connectFrom((BooleanPipe)this.getCHPipe());
            this.model.setCHPipe((NumericVariable)nv);
        }
    }

    private DataTreeGroupNode createTreeOLAP(OLAPVariableFactory ovf) {
        Variable[] tileByVars = this.model.getTileVariable();
        ArrayList<String> hierarchyNames = new ArrayList<String>();
        if (tileByVars != null) {
            for (int i = 0; i < tileByVars.length; ++i) {
                String hName;
                if (!(tileByVars[i] instanceof OLAPLevelVariable) || hierarchyNames.indexOf(hName = ((OLAPLevelVariable)tileByVars[i]).getHierachyName()) >= 0) continue;
                hierarchyNames.add(hName);
            }
        }
        DataTreeGroupNode root = ovf.createSubTree(hierarchyNames);
        Enumeration en = root.depthFirstEnumeration();
        Variable colorVar = this.model.getColorVariable();
        NumericVariable sizeVar = this.model.getSizeVariable();
        int obs = 0;
        double colorVal = 0.0;
        double sizeVal = 0.0;
        boolean colorMissing = false;
        while (en.hasMoreElements()) {
            DataTreeGroupNode curNode = (DataTreeGroupNode)en.nextElement();
            if (!curNode.isLeaf()) continue;
            obs = (Integer)curNode.getValueIndexIterator().next();
            if (colorVar != null) {
                try {
                    colorVal = ((NumericVariable)colorVar).value.getValue(obs);
                }
                catch (MissingValueException e1) {
                    colorMissing = true;
                    colorVal = -1.0;
                }
            }
            try {
                sizeVal = sizeVar.value.getValue(obs);
            }
            catch (MissingValueException e1) {
                sizeVal = -1.0;
            }
            DataTreeResponseNode respNode = new DataTreeResponseNode(2);
            respNode.setValue(colorMissing ? MissingValues.Dot : Double.valueOf(colorVal), 0);
            colorMissing = false;
            respNode.setValue((Object)sizeVal, 1);
            curNode.add((MutableTreeNode)respNode);
        }
        return root;
    }

    public void setDataModel(DataModel dm) {
        this.dataModel = dm;
        this.connectVars();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        this.rebuild |= w != this.getWidth() || h != this.getHeight();
        super.setBounds(x, y, w, h);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        TileChartRendererModel model = this.tile.getRendererModel();
        if (!model.getSizeRoleIsFrequencyRole() && model.getISAllMissingRows()) {
            return;
        }
        Insets in = this.getInsets();
        Rectangle drawSpace = new Rectangle(in.left, in.top, this.getWidth() - in.left - in.right, this.getHeight() - in.top - in.bottom);
        if (this.rebuild) {
            this.ch = new Channel((Component)this, 2);
            this.ch.glViewport(0, 0, drawSpace.width, drawSpace.height);
            this.ch.glOrtho(0.0, (double)drawSpace.width, 0.0, (double)drawSpace.height, -1.0, 1.0);
            if (model.getRootTile() != null) {
                model.getRootTile().rect = null;
                model.setTreeToBeReattached(true);
                model.setTreeToBeRecreated(true);
            }
            this.rebuild = false;
        }
        if (this.antialiased) {
            this.ch.glEnable(14);
            this.ch.glEnable(13);
        } else {
            this.ch.glDisable(14);
            this.ch.glDisable(13);
        }
        this.tile.renderTileChart((Graphics2D)g, this.ch, drawSpace);
    }

    @Override
    protected Vector computeSelectableShapes() {
        return this.tile.computeSelectableShapes();
    }

    @Override
    protected String getTipText(SelectDetail sd) {
        TileSelectDetail ts;
        if (sd instanceof TileSelectDetail && (ts = (TileSelectDetail)sd).getType() == 0) {
            if (ts.getTile() == null) {
                System.out.println("null tile");
                return null;
            }
            if (ts.getTile().formattedDataTip == null) {
                System.out.println("null formatted data tip");
                return null;
            }
            String[] tips = ts.getTile().formattedDataTip;
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < tips.length; ++j) {
                sb = j < tips.length - 1 ? sb.append(tips[j] + " \n") : sb.append(tips[j]);
            }
            return sb.toString();
        }
        return null;
    }

    public double[] getMinMaxColorResponse() {
        return this.tile.getMinMaxColorResponse();
    }

    public Range[] getColorModelRanges(int type) {
        if (this.colorResponseVar == null) {
            return null;
        }
        if (this.model.getColorMapper() == null || !(this.model.getColorMapper() instanceof ContinuousRangeToColorMapper)) {
            return null;
        }
        if (this.model.getColorMapper() instanceof ContinuousRangeColorMapper) {
            return ((ContinuousRangeColorMapper)this.model.getColorMapper()).rangeMapper.getRangeColorMapper().getFullRanges(this.dataTransparency);
        }
        ContinuousRangeToColorMapper colorMapper = (ContinuousRangeToColorMapper)this.model.getColorMapper();
        double[] minmax = this.tile.getMinMaxColorResponse();
        Color[] colors = null;
        try {
            colors = colorMapper.getColorSpectrumColors();
        }
        catch (MissingValueException mve) {
            return null;
        }
        RangeBound low = new RangeBound(minmax[0], true);
        RangeBound high = new RangeBound(minmax[1], true);
        ColorModel colorModel = new ColorModel(colors);
        Range[] colorModelRanges = new Range[]{new Range(low, high, colorModel)};
        return colorModelRanges;
    }

    public SASFormat getContinuousLegendFormat() {
        if (this.colorResponseVar == null) {
            return null;
        }
        if (this.dataModel.getOLAPData() == null) {
            int clrvIDX = this.dataModel.getColumn(this.colorResponseVar);
            ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(clrvIDX);
            return cmd.getFormat();
        }
        return SASFormat.getInstance((String)StatGraph.getOLAPFormat(this.crd, (short)108));
    }

    public boolean hasMissingValue() {
        return this.tile != null && this.tile.containsMissingValue();
    }

    public Color getMissingColor() {
        if (this.model != null) {
            return this.model.getMissingColor();
        }
        return null;
    }

    public void setMissingColor(Color missingColor) {
        if (this.model != null) {
            this.model.setMissingColor(missingColor);
        }
    }

    @Override
    public Color getItemFillColor() {
        return this.sizeLegendItemFillColor;
    }

    @Override
    public Color getItemOutlineColor() {
        return this.sizeLegendItemOutlineColor;
    }

    public void setSizeLegendItemFillColor(Color sizeLegendItemFillColor) {
        this.sizeLegendItemFillColor = sizeLegendItemFillColor;
    }

    public void setSizeLegendItemOutlineColor(Color sizeLegendItemOutlineColor) {
        this.sizeLegendItemOutlineColor = sizeLegendItemOutlineColor;
    }

    @Override
    public String getDefaultContinuousLegendTitle() {
        String title = null;
        if (this.colorResponseVar != null) {
            if (StatGraph.isOLAP()) {
                NumericVariable clrv = StatGraph.getOLAPMeasureVar(this.crd, (short)108);
                return clrv.getColumnName();
            }
            int clrvIDX = this.dataModel.getColumn(this.colorResponseVar);
            ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(clrvIDX);
            return cmd.getLabel();
        }
        return title;
    }

    public boolean isValidSizeVariable(NumericVariable v) {
        double min = v.getMin();
        double max = v.getMax();
        if (min < 0.0) {
            StatGraph.printWarning(RB.getStringResource("TileRegion.size.negative.txt"));
            return false;
        }
        if (max > 0.0) {
            return true;
        }
        StatGraph.printWarning(RB.getStringResource("TileRegion.size.zero.txt"));
        return false;
    }

    @Override
    public String getDefaultSizeLegendTitle() {
        String title = null;
        if (this.sizeVar != null) {
            if (StatGraph.isOLAP()) {
                NumericVariable clrv = StatGraph.getOLAPMeasureVar(this.crd, (short)7);
                return clrv.getColumnName();
            }
            int sizeIDX = this.dataModel.getColumn(this.sizeVar);
            ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(sizeIDX);
            return cmd.getLabel();
        }
        return title;
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return this.colorGroupVar == null;
    }

    @Override
    public String getDefaultLegendTitle() {
        if (this.isDegeneratedLegendContributor()) {
            return null;
        }
        int clrgrIDX = this.dataModel.getColumn(this.colorGroupVar);
        ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(clrgrIDX);
        return cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
    }
}

