/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.regions;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RPFUtil;
import com.sas.graphics.applets.statgraph.sgchart.entry.AutoLegendInterface;
import com.sas.graphics.applets.statgraph.sgchart.regions.RB;
import com.sas.graphics.applets.statgraph.sgchart.regions.Region;
import com.sas.graphics.applets.statgraph.sgchart.ui.CHTagLoader;
import com.sas.graphics.common.pie.Pie;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.GTKPieSelectDetail;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.GTKLogEvent;
import com.sas.graphics.util.gtk.gl.GTKLogEventListener;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.graphics.util.legend.DiscreteLegendInterface;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;

public class PieRegion
extends Region
implements DiscreteLegendInterface,
GTKLogEventListener,
AutoLegendInterface {
    public static final String RB_KEY = "PieRegion.";
    protected Pie pie;
    protected String categoryVar;
    protected String[] responseVars;
    protected String groupVar;
    protected String indexVar;
    protected String freqVar;
    protected int statistic = 6;
    protected ArrayList<Color> cList = new ArrayList();
    protected boolean rebuild = true;
    private String groupLabel = null;
    private boolean includeMissingGroup = true;
    protected boolean useFillTransparency = false;

    public PieRegion() {
        this.pie = new Pie((JComponent)this);
        this.pie.addLogEventListener((GTKLogEventListener)this);
        this.setDefaultValues();
    }

    public void setColorList(Color[] list) {
        this.cList.clear();
        for (int i = 0; i < list.length; ++i) {
            this.cList.add(list[i]);
        }
    }

    protected void setDefaultValues() {
        this.pie.setShowOtherSlice(true);
        this.pie.setOtherThresholdType(Pie.OtherSliceType.PERCENT);
        this.pie.setOtherPercent(4.0);
    }

    public Pie getPieObj() {
        return this.pie;
    }

    public String getCategoryVar() {
        return this.categoryVar;
    }

    public void setCategoryVariable(String category) {
        this.categoryVar = category;
    }

    public String[] getResponseVars() {
        return this.responseVars;
    }

    public void setResponseVariables(String[] responseVars) {
        this.responseVars = responseVars;
    }

    public String getGroupVar() {
        return this.groupVar;
    }

    public void setGroupVariable(String group) {
        this.groupVar = group;
    }

    public String getIndexVar() {
        return this.indexVar;
    }

    public void setIndexVariable(String index) {
        this.indexVar = index;
    }

    public String getFreqVar() {
        return this.freqVar;
    }

    public void setFreqVariable(String freq) {
        this.freqVar = freq;
    }

    public int getStatistic() {
        return this.statistic;
    }

    public void setStatistic(int stat) {
        this.statistic = stat;
    }

    @Override
    public void setDataTransparency(double transparency) {
        super.setDataTransparency(transparency);
        this.pie.setDataTransparency(transparency);
    }

    protected void connectVars() {
        ColumnMetadata cmd;
        if (this.dataModel.getOLAPData() != null) {
            this.connectOLAPVars();
            return;
        }
        NumericVectorVariable cv = null;
        if (this.categoryVar != null) {
            NumericVectorVariable v;
            int cvIDX = this.dataModel.getColumn(this.categoryVar);
            if (this.crd.getColumnClass(1) == Double.class) {
                v = new NumericVectorVariable();
                v.connectFrom(this.dataModel.getDoubleColumn(cvIDX));
                cv = v;
            } else {
                v = new StringVectorVariable();
                v.connectFrom(this.dataModel.getColumnAsClassColumn(cvIDX, StatGraph.includeMissingDiscrete));
                cv = v;
            }
            ColumnMetadata cmd2 = (ColumnMetadata)this.dataModel.getColumnLabel(cvIDX);
            cv.setName(cmd2.getName());
            cv.setLabel(cmd2.getLabel());
            cv.setFormat(new GTKFormat((Format)cmd2.getFormat()));
        }
        GTKFormat valueGTKFormat = new GTKFormat((Format)SASFormat.getInstance((String)"BEST6."));
        NumericVectorVariable[] rvs = null;
        if (this.responseVars != null && this.responseVars.length > 0) {
            rvs = new NumericVectorVariable[this.responseVars.length];
            for (int i = 0; i < this.responseVars.length; ++i) {
                rvs[i] = new NumericVectorVariable();
                int rvIDX = this.dataModel.getColumn(this.responseVars[i]);
                rvs[i].connectFrom(this.dataModel.getDoubleColumn(rvIDX));
                cmd = (ColumnMetadata)this.dataModel.getColumnLabel(rvIDX);
                rvs[i].setName(cmd.getName());
                rvs[i].setLabel(cmd.getLabel());
                if (cmd.getFormat() != null) {
                    valueGTKFormat = new GTKFormat((Format)cmd.getFormat());
                }
                rvs[i].setFormat(valueGTKFormat);
            }
        }
        NumericVectorVariable gv = null;
        if (this.groupVar != null) {
            NumericVectorVariable v;
            int gvIDX = this.dataModel.getColumn(this.groupVar);
            if (this.crd.getColumnClass(3) == Double.class) {
                v = new NumericVectorVariable();
                v.connectFrom(this.dataModel.getDoubleColumn(gvIDX));
                gv = v;
            } else {
                v = new StringVectorVariable();
                v.connectFrom(this.dataModel.getColumnAsClassColumn(gvIDX));
                gv = v;
            }
            cmd = (ColumnMetadata)this.dataModel.getColumnLabel(gvIDX);
            gv.setName(cmd.getName());
            if (this.groupLabel == null) {
                gv.setLabel(cmd.getLabel());
            } else {
                gv.setLabel(this.groupLabel);
            }
            gv.setFormat(new GTKFormat((Format)cmd.getFormat()));
        }
        NumericVectorVariable iv = null;
        if (this.indexVar != null) {
            iv = new NumericVectorVariable();
            int ivIDX = this.dataModel.getColumn(this.indexVar);
            iv.connectFrom(this.dataModel.getDoubleColumn(ivIDX));
            ColumnMetadata cmd3 = (ColumnMetadata)this.dataModel.getColumnLabel(ivIDX);
            iv.setName(cmd3.getName());
            iv.setLabel(cmd3.getLabel());
            iv.setFormat(new GTKFormat((Format)cmd3.getFormat()));
        }
        NumericVectorVariable fv = null;
        if (this.freqVar != null) {
            fv = new NumericVectorVariable();
            int fvIDX = this.dataModel.getColumn(this.freqVar);
            fv.connectFrom(this.dataModel.getDoubleColumn(fvIDX));
            ColumnMetadata cmd4 = (ColumnMetadata)this.dataModel.getColumnLabel(fvIDX);
            fv.setName(cmd4.getName());
            fv.setLabel(cmd4.getLabel());
            fv.setFormat(new GTKFormat((Format)cmd4.getFormat()));
        }
        this.pie.setStatistic(this.statistic);
        this.pie.setOtherVariableArr(this.getWhereClauseVars());
        this.pie.setWhereClause(this.getWhereExpression());
        this.pie.setIncludeMissingCategory(StatGraph.includeMissingDiscrete);
        this.pie.setCategoryVar((Variable)cv);
        if (this.categoryOrder == 1) {
            this.pie.setCategorySortOrder(Pie.SortOrderType.CATEGORY_ASC);
        }
        if (rvs != null && rvs.length > 0) {
            this.pie.setResponseVar((NumericVariable[])rvs);
        }
        if (gv != null) {
            this.pie.setIncludeMissingGroup(this.includeMissingGroup);
            if (this.groupOrder == 1) {
                this.pie.setGroupSortOrder(Pie.SortOrderType.CATEGORY_ASC);
            }
            this.pie.setGroupVariable((Variable)gv);
        }
        if (iv != null) {
            this.pie.setColorIndex((NumericVariable)iv);
        }
        if (fv != null) {
            this.pie.setFreqVar(fv);
        }
        this.pie.setColorList(this.cList);
        if (this.dataTipVars != null) {
            this.pie.setToolTipVars(this.dataTipVars);
        } else if (this.responseVars != null && this.responseVars.length == 1) {
            this.pie.setToolTipVars(this.buildDefaultDataTipVars());
        }
        Variable urlVar = this.connectCategory((short)52, false);
        if (urlVar != null) {
            this.pie.setURLVariable(urlVar);
        }
        this.initConditionalHighlighting();
        this.setVariableStrings();
    }

    private void setVariableStrings() {
        ArrayList<String> arr = this.getVariableStrings(this.categoryVar, (short)1);
        this.pie.setCategoriesArr(arr);
        if (this.groupVar != null) {
            arr = this.getVariableStrings(this.groupVar, (short)3);
            this.pie.setGroupsArr(arr);
        }
    }

    private ArrayList<String> getVariableStrings(String var, short role) {
        NumericVectorVariable v;
        int idx = this.dataModel.getColumn(var);
        if (this.crd.getColumnClass(role) == Double.class) {
            v = new NumericVectorVariable();
            v.connectFrom(this.dataModel.getDoubleColumn(idx));
        } else {
            v = new StringVectorVariable();
            ((StringVectorVariable)v).connectFrom(this.dataModel.getColumnAsClassColumn(idx, true));
        }
        ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(idx);
        v.setName(cmd.getName());
        v.setLabel(cmd.getLabel());
        v.setFormat(new GTKFormat((Format)cmd.getFormat()));
        if (role == 1 && this.categoryOrder == 1) {
            v.setUniqueValueSort(1);
            v.setSortByFormattedValues(v instanceof StringVectorVariable);
        } else if (role == 3 && this.groupOrder == 1) {
            v.setUniqueValueSort(1);
            v.setSortByFormattedValues(true);
        }
        ArrayList<String> arr = this.getVariableStrings((Variable)v);
        return arr;
    }

    private ArrayList<String> getVariableStrings(Variable v) {
        int uvCount = v.getUniqueValueCount();
        ArrayList<String> arr = new ArrayList<String>();
        v.setFormattedValueMissingValueExceptionsEnabled(false);
        for (int i = 0; i < uvCount; ++i) {
            try {
                arr.add(v.formattedUniqueValue.getValue(i));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return arr;
    }

    protected void connectOLAPVars() {
        ArrayList<String> arr;
        OLAPDataSetInterface olapData = this.dataModel.getOLAPData();
        OLAPVariableFactory fac = null;
        try {
            fac = new OLAPVariableFactory((ResultSetInterface)olapData);
        }
        catch (OLAPException ex) {
            return;
        }
        StringVariable cv = null;
        if (this.categoryVar != null) {
            cv = StatGraph.getOLAPLevelVar(fac, this.categoryVar);
        }
        GTKFormat valueGTKFormat = new GTKFormat((Format)SASFormat.getInstance((String)"BEST6."));
        NumericVariable[] rvs = null;
        if (this.responseVars != null && this.responseVars.length > 0) {
            rvs = new NumericVariable[this.responseVars.length];
            if (this.responseVars.length == 1) {
                rvs[0] = StatGraph.getOLAPMeasureVar(this.crd, (short)2);
                String fmt = StatGraph.getOLAPFormat(this.crd, (short)2);
                if (fmt != null) {
                    valueGTKFormat = new GTKFormat((Format)SASFormat.getInstance((String)fmt));
                }
                rvs[0].setFormat(valueGTKFormat);
            } else {
                for (int i = 0; i < this.responseVars.length; ++i) {
                    rvs[i] = StatGraph.getOLAPMeasureVar(this.crd, (short)(610 + i));
                    String fmt = StatGraph.getOLAPFormat(this.crd, (short)(610 + i));
                    if (fmt != null) {
                        valueGTKFormat = new GTKFormat((Format)SASFormat.getInstance((String)fmt));
                    }
                    rvs[i].setFormat(valueGTKFormat);
                }
            }
        }
        StringVariable gv = null;
        if (this.groupVar != null) {
            gv = StatGraph.getOLAPLevelVar(fac, this.groupVar);
        }
        NumericVariable iv = null;
        if (this.indexVar != null) {
            iv = StatGraph.getOLAPMeasureVar(this.crd, (short)41);
        }
        NumericVectorVariable fv = null;
        this.pie.setStatistic(this.statistic);
        this.pie.setOtherVariableArr(this.getWhereClauseVars());
        this.pie.setWhereClause(this.getWhereExpression());
        this.pie.setIncludeMissingCategory(StatGraph.includeMissingDiscrete);
        this.pie.setCategoryVar((Variable)cv);
        if (rvs != null && rvs.length > 0) {
            this.pie.setResponseVar(rvs);
        }
        if (gv != null) {
            this.pie.setIncludeMissingGroup(this.includeMissingGroup);
            this.pie.setGroupVariable((Variable)gv);
        }
        if (iv != null) {
            this.pie.setColorIndex(iv);
        }
        if (fv != null) {
            this.pie.setFreqVar(fv);
        }
        this.pie.setColorList(this.cList);
        if (this.dataTipVars != null) {
            this.pie.setToolTipVars(this.dataTipVars);
        } else if (this.responseVars != null && this.responseVars.length == 1) {
            this.pie.setToolTipVars(this.buildOLAPDefaultDataTipVars());
        }
        Variable urlVar = this.connectCategory((short)52, false);
        if (urlVar != null) {
            this.pie.setURLVariable(urlVar);
        }
        this.initConditionalHighlighting();
        if (cv != null) {
            arr = this.getVariableStrings((Variable)cv);
            this.pie.setCategoriesArr(arr);
        }
        if (gv != null) {
            arr = this.getVariableStrings((Variable)gv);
            this.pie.setGroupsArr(arr);
        }
    }

    private void initConditionalHighlighting() {
        this.setCHPipe(RPFUtil.applyConditionalHiliting(this.dataModel, null, this.statistic));
        if (this.isConditionalHilited()) {
            Image tag = CHTagLoader.get(1, false, this);
            BooleanVector bv = this.getCHPipe();
            this.pie.setCHImage(tag);
            this.pie.setCHPipe((BooleanPipe)bv);
        }
    }

    private Variable[] buildOLAPDefaultDataTipVars() {
        Variable cv = null;
        NumericVariable rv = null;
        if (this.categoryVar != null) {
            cv = this.pie.getCategoryVar().getConnection();
        }
        if (this.responseVars != null && this.responseVars.length == 1) {
            rv = this.pie.getResponseVars()[0];
        }
        return new Variable[]{cv, rv};
    }

    private Variable[] buildDefaultDataTipVars() {
        StringVectorVariable cv = new StringVectorVariable();
        if (this.categoryVar != null) {
            int cvIDX = this.dataModel.getColumn(this.categoryVar);
            cv.connectFrom(this.dataModel.getColumnAsClassColumn(cvIDX, StatGraph.includeMissingDiscrete));
            ColumnMetadata cmd = this.getRoleMetadata("CATEGORY");
            cv.setName(cmd.getName());
            cv.setLabel(cmd.getLabel());
            cv.setFormat(new GTKFormat((Format)cmd.getFormat()));
        }
        GTKFormat valueGTKFormat = new GTKFormat((Format)SASFormat.getInstance((String)"BEST6."));
        NumericVectorVariable rvs = null;
        if (this.responseVars != null && this.responseVars.length == 1) {
            rvs = new NumericVectorVariable();
            for (int i = 0; i < this.responseVars.length; ++i) {
                int rvIDX = this.dataModel.getColumn(this.responseVars[i]);
                rvs.connectFrom(this.dataModel.getDoubleColumn(rvIDX));
                ColumnMetadata cmd = this.getRoleMetadata("RESPONSE");
                if (cmd == null) continue;
                rvs.setName(cmd.getName());
                rvs.setLabel(cmd.getLabel());
                if (cmd.getFormat() != null) {
                    valueGTKFormat = new GTKFormat((Format)cmd.getFormat());
                }
                rvs.setFormat(valueGTKFormat);
            }
        }
        return new Variable[]{cv, rvs};
    }

    public void setDataModel(DataModel dm) {
        this.dataModel = dm;
        this.connectVars();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.rebuild = true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.rebuild) {
            this.pie.build();
            this.rebuild = false;
        }
        this.pie.paintComponent(g);
    }

    public static void testMethod() {
    }

    protected boolean isLegendEntryFromAttrMap() {
        if (this.pie == null || this.pie.getCategoryAttributeMap() == null) {
            return false;
        }
        return this.pie.getCategoryAttributeMap().getLegendEntryPolicy() == 1;
    }

    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        if (!this.pie.isFillOn()) {
            return 10;
        }
        return 7;
    }

    protected void applyDataSkin(LegendItem[] items) {
        if (!this.pie.isFillOn() || this.pie.getSkin() == RendererUtil.Skin.NONE) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            items[i].setSkinImage(this.pie.getLegendSkinImage());
            items[i].setSkinType(RendererUtil.getSkinType((RendererUtil.Skin)this.pie.getSkin()));
        }
    }

    public boolean isUseFillTransparency() {
        return this.useFillTransparency;
    }

    public void setUseFillTransparency(boolean useFillTransparency) {
        this.useFillTransparency = useFillTransparency;
    }

    protected void applyFillTransparency(LegendItem[] items) {
        if (!this.pie.isFillOn() || !this.useFillTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(items[i].getSymbolAttrs().getColor(), this.pie.getFillAttrs()));
            items[i].setSymbolAttrs((ColorAttr)fa);
        }
    }

    protected void applyLineTransparency(LegendItem[] items) {
        if (this.pie.isFillOn() || !this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            LineAttrs old = (LineAttrs)items[i].getSymbolAttrs();
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(old.getColor()));
            la.setLinePattern(old.getLinePattern());
            la.setWidth(old.getWidth());
            items[i].setSymbolAttrs((ColorAttr)la);
        }
    }

    protected LegendItem[] getLegendItemsFromAttrMap(int attrType) {
        LegendItem[] items = this.pie.getCategoryAttributeMap().getLegendItems(attrType, true);
        this.applyDataSkin(items);
        this.applyFillTransparency(items);
        this.applyLineTransparency(items);
        return items;
    }

    public LegendItem[] getLegendItems(int attrType) {
        if (this.isLegendEntryFromAttrMap()) {
            return this.getLegendItemsFromAttrMap(this.fixDefaultAttrType(attrType));
        }
        if (this.pie != null) {
            return this.pie.getLegendItems(attrType);
        }
        return null;
    }

    public boolean hasLegend(int attrType) {
        if (this.pie != null) {
            return this.pie.hasLegend(attrType);
        }
        return false;
    }

    @Override
    protected Vector computeSelectableShapes() {
        return this.pie.computeSelectableShapes();
    }

    @Override
    protected String getTipText(SelectDetail sd) {
        GTKPieSelectDetail psd;
        if (sd instanceof GTKPieSelectDetail && this.pie != null && (psd = (GTKPieSelectDetail)sd).getType() == 0) {
            return this.pie.getFormattedDataTip(psd);
        }
        return null;
    }

    @Override
    protected String getURL(SelectDetail sd) {
        GTKPieSelectDetail psd;
        if (sd instanceof GTKPieSelectDetail && this.pie != null && (psd = (GTKPieSelectDetail)sd).getType() == 0) {
            return this.pie.getURL(psd);
        }
        return null;
    }

    public void setGroupLabel(String groupLabel) {
        this.groupLabel = groupLabel;
    }

    public boolean isMissingGroupIncluded() {
        return this.includeMissingGroup;
    }

    public void setIncludeMissingGroup(boolean includeMissingGroup) {
        this.includeMissingGroup = includeMissingGroup;
    }

    public void logEventOccured(GTKLogEvent evt) {
        if (evt != null && GTKLogEvent.LOG_TYPE.NEGATIVE_RESPONSE == evt.getLogType()) {
            StatGraph.printNote(RB.getStringResource(RB_KEY, "NegativeResponse.txt"));
        }
    }

    @Override
    public String getDefaultLegendTitle() {
        String title = null;
        if (StatGraph.isOLAP()) {
            OLAPLevelVariable olv = (OLAPLevelVariable)this.pie.getCategoryVar().getConnection();
            OLAPVariableFactory fac = olv.getFactory();
            List list = fac.getLevelNamesForHeirarchy(olv.getHierachyName());
            String levelName = (String)list.get(0);
            title = fac.getLabel(levelName).trim();
        } else {
            title = ((ColumnMetadata)this.dataModel.getColumnLabel(1)).getLabel().trim();
        }
        return title;
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return false;
    }

    public int getNumSlices() {
        int slices = this.pie.getCategoryVar().getUniqueValueCount();
        if (this.groupVar != null) {
            slices *= this.pie.getGroupVariable().getUniqueValueCount();
        }
        return slices;
    }
}

