/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.regions;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.entry.AutoLegendInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginInterface;
import com.sas.graphics.applets.statgraph.sgchart.regions.Region;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDLinkLabel;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPathDiagramNode;
import com.sas.graphics.components.pfd.PFDPathDiagramView;
import com.sas.graphics.components.pfd.PFDPen;
import com.sas.graphics.components.util.layout.PathDiagramNeuralNetworkLayout;
import com.sas.graphics.interfaces.LayoutStrategyInterface;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.legend.ContinuousLegendInterface;
import com.sas.graphics.util.legend.DiscreteLegendInterface;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.util.LinkedHashMap;
import java.util.Vector;

public class PathDiagramRegion
extends Region
implements DiscreteLegendInterface,
ContinuousLegendInterface,
AutoLegendInterface,
MarginInterface {
    protected PFDPathDiagramView pfd;
    private ContinuousRangeToColorMapper linkColorMapper = null;
    private LinkedHashMap nodeColorMap = null;
    private ColumnMetadata linkColorCMD = null;
    private Insets outerMargin = new Insets(0, 0, 0, 0);
    private TextAttrs nodeLabelAttrs = new TextAttrs();
    private TextAttrs nodeTitleAttrs = new TextAttrs();
    private TextAttrs linkLabelAttrs = new TextAttrs();
    private LineAttrs nodeOutlineAttrs = new LineAttrs();
    private boolean scaleNodeLabel = false;
    private boolean scaleNodeTitle = false;
    private boolean scaleLinkLabel = false;
    private int textSizeMin = 7;

    public PathDiagramRegion() {
        this.pfd = new PFDPathDiagramView();
        this.setLayout(new BorderLayout());
        this.add((Component)this.pfd);
    }

    public PFDPathDiagramView getPFDView() {
        return this.pfd;
    }

    public void setTextSizeMin(int s) {
        this.textSizeMin = s;
    }

    public int getTextSizeMin() {
        return this.textSizeMin;
    }

    public void setLinkColorMapper(ContinuousRangeToColorMapper map) {
        this.linkColorMapper = map;
    }

    public void setLinkColorCMD(ColumnMetadata cmd) {
        this.linkColorCMD = cmd;
    }

    public void setNodeColorMap(LinkedHashMap map) {
        this.nodeColorMap = map;
    }

    public void setNodeLabelAttrs(TextAttrs attrs) {
        this.nodeLabelAttrs = attrs;
    }

    public void setNodeTitleAttrs(TextAttrs attrs) {
        this.nodeTitleAttrs = attrs;
    }

    public void setLinkLabelAttrs(TextAttrs attrs) {
        this.linkLabelAttrs = attrs;
    }

    public void setNodeOutlineAttrs(LineAttrs attrs) {
        this.nodeOutlineAttrs = attrs;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        super.setBounds(x, y, width, height);
        this.calculateOffsets();
        LayoutStrategyInterface layout = this.pfd.getPFDLayout();
        if (layout instanceof PathDiagramNeuralNetworkLayout) {
            ((PathDiagramNeuralNetworkLayout)layout).setGraphSize(width - this.outerMargin.left - this.outerMargin.right, height - this.outerMargin.top - this.outerMargin.bottom);
        }
        this.resetFontSize();
        this.pfd.doPFDLayout(true);
        this.pfd.setOuterMargin(this.outerMargin);
        this.pfd.setBounds(x, y, width, height);
        this.scaleFontSize();
    }

    public Insets getPreferredInnerMargin() {
        return null;
    }

    public Insets getPreferredOuterMargin() {
        return new Insets(0, 0, 0, 0);
    }

    public void setInnerMargin(Insets margin) {
    }

    public void setOuterMargin(Insets margin) {
    }

    public Insets getInnerMargin() {
        return null;
    }

    public Insets getOuterMargin() {
        return new Insets(0, 0, 0, 0);
    }

    public void enableMarginPrefCalc() {
    }

    public void disableMarginPrefCalc() {
    }

    @Override
    public String getLegendLabel() {
        return this.legendLabel != null ? this.legendLabel : this.name;
    }

    public boolean hasLegend(int attrType) {
        switch (attrType) {
            case 0: {
                return true;
            }
            case 7: 
            case 11: {
                return true;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public LegendItem[] getLegendItems(int attrType) {
        if (this.nodeColorMap == null) {
            return null;
        }
        Object[] keys = this.nodeColorMap.keySet().toArray();
        int n = keys.length;
        LegendItem[] items = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            String v = (String)keys[i];
            Color c = (Color)this.nodeColorMap.get(v);
            FillAttrs attr = new FillAttrs();
            attr.setColor(c);
            items[i] = new LegendItem((ColorAttr)attr, (ColorAttr)this.nodeOutlineAttrs, v, null);
        }
        return items;
    }

    public Range[] getColorModelRanges(int type) {
        if (this.linkColorMapper == null) {
            return null;
        }
        Color[] colors = null;
        double[] values = null;
        try {
            colors = this.linkColorMapper.getColorSpectrumColors();
            values = this.linkColorMapper.getColorSpectrumValues();
        }
        catch (MissingValueException mve) {
            return null;
        }
        RangeBound low = new RangeBound(values[0], true);
        RangeBound high = new RangeBound(values[values.length - 1], true);
        ColorModel colorModel = new ColorModel(colors);
        Range[] colorModelRanges = new Range[]{new Range(low, high, colorModel)};
        return colorModelRanges;
    }

    public SASFormat getContinuousLegendFormat() {
        if (this.linkColorMapper == null) {
            return null;
        }
        return this.linkColorCMD.getFormat();
    }

    public Color getMissingColor() {
        if (this.linkColorMapper == null) {
            return Color.black;
        }
        return this.linkColorMapper.getMissingReplacement();
    }

    public boolean hasMissingValue() {
        if (this.linkColorMapper == null) {
            return false;
        }
        return this.linkColorCMD.getMissings() > 0;
    }

    @Override
    public String getDefaultLegendTitle() {
        if (this.linkColorMapper == null) {
            return null;
        }
        return this.linkColorCMD.getLabel();
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return true;
    }

    public void calculateOffsets() {
        int top;
        PFDModel model = this.pfd.getModel();
        Vector links = model.getAllLinks();
        double maxWidth = 0.0;
        for (int i = 0; i < links.size(); ++i) {
            if (!(links.get(i) instanceof PFDLink)) continue;
            PFDLink link = (PFDLink)links.get(i);
            PFDPen linkPen = link.getPen();
            maxWidth = Math.max(maxWidth, (double)linkPen.getLineWidth());
        }
        int maxLinkWidth = (int)(maxWidth * 0.5);
        Vector nodes = model.getAllNodes();
        int maxLabelWidth = 0;
        int maxLabelHeight = 0;
        int labelOffsetOnRight = 0;
        Font minLabelFont = new Font(this.nodeLabelAttrs.getFont().getName(), this.nodeLabelAttrs.getFont().getStyle(), this.textSizeMin);
        FontMetrics fm = StatGraph.getFontMetrics(minLabelFont);
        for (int i = 0; i < nodes.size(); ++i) {
            PFDPathDiagramNode n;
            if (!(nodes.get(i) instanceof PFDPathDiagramNode) || (n = (PFDPathDiagramNode)nodes.get(i)).getOutsideLabel() == null) continue;
            maxLabelWidth = Math.max(maxLabelWidth, fm.stringWidth(n.getOutsideLabel().getText().trim()));
        }
        if (maxLabelWidth > 0) {
            maxLabelHeight = fm.getHeight();
            labelOffsetOnRight = fm.stringWidth("WW");
        }
        int bottom = top = maxLabelHeight + maxLinkWidth + StatGraph.getExtraPadding();
        int left = maxLabelWidth + maxLinkWidth + StatGraph.getExtraPadding();
        int right = labelOffsetOnRight + maxLinkWidth + StatGraph.getExtraPadding();
        this.outerMargin = new Insets(top, left, bottom, right);
    }

    private void scaleFontSize() {
        PFDModel model = this.pfd.getModel();
        Dimension ms = model.getSize();
        int w = ms.width + 1;
        int h = ms.height + 1;
        double sx = (double)this.pfd.getSize().width / (double)w;
        double sy = (double)this.pfd.getSize().height / (double)h;
        double scale = Math.min(sx, sy);
        int minSize = (int)((double)this.textSizeMin / scale + 0.5);
        Font newNodeLabelFont = this.nodeLabelAttrs.getFont();
        Font newNodeTitleFont = this.nodeTitleAttrs.getFont();
        Font newLinkLabelFont = this.linkLabelAttrs.getFont();
        this.scaleNodeLabel = false;
        this.scaleNodeTitle = false;
        this.scaleLinkLabel = false;
        if (newNodeLabelFont.getSize() < minSize) {
            newNodeLabelFont = new Font(newNodeLabelFont.getName(), newNodeLabelFont.getStyle(), minSize);
            this.scaleNodeLabel = true;
        }
        if (newNodeTitleFont.getSize() < minSize) {
            newNodeTitleFont = new Font(newNodeTitleFont.getName(), newNodeTitleFont.getStyle(), minSize);
            this.scaleNodeTitle = true;
        }
        if (newLinkLabelFont.getSize() < minSize) {
            newLinkLabelFont = new Font(newLinkLabelFont.getName(), newLinkLabelFont.getStyle(), minSize);
            this.scaleLinkLabel = true;
        }
        if (!(this.scaleNodeLabel || this.scaleNodeTitle || this.scaleLinkLabel)) {
            return;
        }
        Vector nodes = model.getAllNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            if (!(nodes.get(i) instanceof PFDPathDiagramNode)) continue;
            PFDPathDiagramNode n = (PFDPathDiagramNode)nodes.get(i);
            if (this.scaleNodeTitle && n.getLabel() != null) {
                n.getLabel().setFont(newNodeTitleFont);
            }
            if (!this.scaleNodeLabel || n.getOutsideLabel() == null) continue;
            n.getOutsideLabel().setFont(newNodeLabelFont);
        }
        if (this.scaleLinkLabel) {
            Vector links = model.getAllLinks();
            for (int i = 0; i < links.size(); ++i) {
                PFDLinkLabel middleLabel;
                if (!(links.get(i) instanceof PFDLink) || (middleLabel = ((PFDLink)links.get(i)).getMiddleLabelObject()) == null) continue;
                middleLabel.setFont(newLinkLabelFont);
            }
        }
    }

    private void scaleLinkWidth() {
        PFDModel model = this.pfd.getModel();
        Dimension ms = model.getSize();
        int w = ms.width + 1;
        int h = ms.height + 1;
        double sx = (double)this.pfd.getSize().width / (double)w;
        double sy = (double)this.pfd.getSize().height / (double)h;
        double scale = Math.min(sx, sy);
        Vector links = model.getAllLinks();
        for (int i = 0; i < links.size(); ++i) {
            if (!(links.get(i) instanceof PFDLink)) continue;
            PFDLink link = (PFDLink)links.get(i);
            PFDPen linkPen = link.getPen();
            linkPen.setLineWidth((float)((int)((double)linkPen.getLineWidth() / scale)));
            link.setFromElbowLineWidth((float)((int)((double)link.getFromElbowLineWidth() / scale)));
            link.setToElbowLineWidth((float)((int)((double)link.getToElbowLineWidth() / scale)));
        }
    }

    private void resetFontSize() {
        PFDModel model = this.pfd.getModel();
        if (!(this.scaleNodeLabel || this.scaleNodeTitle || this.scaleLinkLabel)) {
            return;
        }
        Vector nodes = model.getAllNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            if (!(nodes.get(i) instanceof PFDPathDiagramNode)) continue;
            PFDPathDiagramNode n = (PFDPathDiagramNode)nodes.get(i);
            if (this.scaleNodeTitle && n.getLabel() != null) {
                n.getLabel().setFont(this.nodeTitleAttrs.getFont());
            }
            if (!this.scaleNodeLabel || n.getOutsideLabel() == null) continue;
            n.getOutsideLabel().setFont(this.nodeLabelAttrs.getFont());
        }
        if (this.scaleLinkLabel) {
            Vector links = model.getAllLinks();
            for (int i = 0; i < links.size(); ++i) {
                PFDLinkLabel middleLabel;
                if (!(links.get(i) instanceof PFDLink) || (middleLabel = ((PFDLink)links.get(i)).getMiddleLabelObject()) == null) continue;
                middleLabel.setFont(this.linkLabelAttrs.getFont());
            }
        }
    }

    private void modifyOffsets(double scale) {
        int top;
        PFDModel model = this.pfd.getModel();
        Vector links = model.getAllLinks();
        double maxWidth = 0.0;
        for (int i = 0; i < links.size(); ++i) {
            if (!(links.get(i) instanceof PFDLink)) continue;
            PFDLink link = (PFDLink)links.get(i);
            PFDPen linkPen = link.getPen();
            maxWidth = Math.max(maxWidth, (double)linkPen.getLineWidth());
        }
        int maxLinkWidth = (int)(maxWidth * 0.5);
        int maxLabelWidth = 0;
        int maxLabelHeight = 0;
        int labelOffsetOnRight = 0;
        if (this.scaleNodeLabel) {
            Vector nodes = model.getAllNodes();
            Font minLabelFont = new Font(this.nodeLabelAttrs.getFont().getName(), this.nodeLabelAttrs.getFont().getStyle(), this.textSizeMin);
            FontMetrics fm = StatGraph.getFontMetrics(minLabelFont);
            Font pfdScaledFont = new Font(this.nodeLabelAttrs.getFont().getName(), this.nodeLabelAttrs.getFont().getStyle(), (int)((double)this.nodeLabelAttrs.getFont().getSize() * scale));
            FontMetrics fm2 = StatGraph.getFontMetrics(pfdScaledFont);
            for (int i = 0; i < nodes.size(); ++i) {
                PFDPathDiagramNode n;
                if (!(nodes.get(i) instanceof PFDPathDiagramNode) || (n = (PFDPathDiagramNode)nodes.get(i)).getOutsideLabel() == null) continue;
                int widthDiff = fm.stringWidth(n.getOutsideLabel().getText()) - fm2.stringWidth(n.getOutsideLabel().getText());
                maxLabelWidth = Math.max(maxLabelWidth, widthDiff);
            }
            if (maxLabelWidth > 0) {
                maxLabelHeight = fm.getHeight();
                labelOffsetOnRight = fm.stringWidth("WW");
            }
        }
        int bottom = top = maxLabelHeight + maxLinkWidth + StatGraph.getExtraPadding();
        int left = maxLabelWidth + maxLinkWidth + StatGraph.getExtraPadding();
        int right = labelOffsetOnRight + maxLinkWidth + StatGraph.getExtraPadding();
        this.outerMargin = new Insets(top, left, bottom, right);
    }
}

