/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.regions;

import com.sas.graphics.applets.statgraph.BaseStatGraphPanel;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.RegionContainer;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.DecisionTreeArrangement;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.ItemManager;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.LinkItem;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.NodeItem;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.NodeLinkDiagramItem;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.Port;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.TextObject;
import com.sas.graphics.applets.statgraph.sgchart.entry.AutoLegendInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginInterface;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.applets.statgraph.sgchart.regions.Region;
import com.sas.graphics.applets.statgraph.sgchart.ui.ImageMap;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.gl.Rectangle;
import com.sas.graphics.util.legend.ContinuousLegendInterface;
import com.sas.graphics.util.legend.DiscreteLegendInterface;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;

public class DecisionTreeRegion
extends Region
implements DiscreteLegendInterface,
AutoLegendInterface,
ContinuousLegendInterface,
MarginInterface {
    public static final String RB_KEY = "DesicionRegion.";
    public static final int DT_LINK_TYPE_ORTHOGONAL = 1;
    public static final int DT_LINK_TYPE_DIRECT = 0;
    public static final int DT_LINK_TYPE_CURVED = 2;
    public static final int DT_LINK_TYPE_SPLINE = 3;
    public static final int DT_LINK_WIDTH_MIN = 1;
    public static final int DT_LINK_WIDTH_MAX = 10;
    protected String type;
    protected String nodeID;
    protected String parentID;
    protected String nodeTitle;
    protected String nodeInputLabel;
    protected String[] nodeInputLabelList;
    protected String nodeOutputLabel;
    protected String[] nodeStatusTip;
    protected String nodeStatus;
    protected Object[] nodeDetails;
    protected Object[] nodeDetailsLabels;
    protected Object[] nodeDetailRoles;
    protected Object[] nodeTip;
    protected Object[] nodeTipRoles;
    protected Object[] linkTip;
    protected int linkType = 2;
    protected String linkWidthResponse;
    protected String nodeColorGroup;
    protected String nodeColorResponse;
    protected String[] overviewNodeColorGroup;
    protected String[] overviewNodeFillRatio;
    protected Object[] overviewNodeLabel;
    protected StringVectorVariable nodeColorGroupVar;
    protected NumericVectorVariable nodeColorResponseVar;
    protected StringVectorVariable[] overviewNodeColorGroupVars;
    protected NumericVectorVariable[] overviewNodeFillRatioVars;
    protected StringVectorVariable overviewGroupUniqueValues = null;
    protected StringVectorVariable[] nodeInputLabelVars = null;
    protected StringVectorVariable nodeOutputLabelVar = null;
    protected StringVectorVariable nodeTitleVar = null;
    protected StringVectorVariable[] overviewNodeLabelVars;
    protected StringVectorVariable[] nodeDetailVars;
    protected StringVectorVariable[] nodeDetailLabelVars;
    protected NumericVectorVariable linkWidthVar;
    protected StringVectorVariable[] nodeTipVars;
    protected StringVector nodeDetailsTipPipe;
    protected DiscreteAttrMapper colorDAM;
    protected RangeAttrMapper colorRAM;
    protected ColorMapper colorMapper;
    protected HashMap colorTable;
    protected DiscreteAttrMapper overviewColorDAM;
    protected RangeAttrMapper overviewColorRAM;
    protected HashMap overviewColorTable;
    protected ContinuousRangeToNumericMapper linkWidthResponseMapper = null;
    protected FillAttrs nodeFillStyle = new FillAttrs();
    protected FillAttrs linkFillStyle = new FillAttrs();
    protected LineAttrs linkLineStyle = new LineAttrs();
    protected LineAttrs nodeOutlineStyle = new LineAttrs();
    protected TextAttrs nodeTitleStyle = new TextAttrs();
    protected TextAttrs nodeInputLabelStyle = new TextAttrs();
    protected TextAttrs nodeOutputLabelStyle = new TextAttrs();
    protected TextAttrs nodeDetailsStyle = new TextAttrs();
    protected TextAttrs overviewNodeLabelStyle = new TextAttrs();
    protected int displayDepth;
    protected String displayRoot;
    protected boolean colorBranchNodes = true;
    protected String overviewNodeLabelDelimiter = "\n";
    protected double nodeDetailThreshold = -1.0;
    protected Color wallColor = null;
    protected java.awt.Rectangle wallRect;
    protected java.awt.Rectangle dataRect;
    protected Insets outerMargin = new Insets(0, 0, 0, 0);
    private boolean fillOn = true;
    private boolean outlineOn = true;
    private boolean useFillTransparency = false;
    private int skinType = 0;
    private Color missingFillColor = null;
    private Color missingEdgeColor = null;
    private Probe probe;
    private boolean rebuild = true;
    private boolean itemPropertiesInvalid = true;
    private Vector<Double> nodeLabelHeightByTreeDepth = null;
    private double rootLinkWidthResponse = Double.NaN;
    private HashMap<NodeItem, Point2D> overviewItemLocations;
    private ItemManager itemManager;
    private boolean invalidateArrangementFlag = false;
    private DecisionTreeArrangement arrangement;
    private boolean autoArrange = true;
    private boolean hasEmptyDataProvider = false;
    private NodeItem rootNode;
    private NodeItem visibleRootNode;
    private boolean treeStateInvalid = false;
    private boolean visibleRootInvalid = false;
    private int treeDepth = -1;
    private boolean parentNodeChanged = false;
    private int linkCount = 0;
    private double viewportScale = 1.0;
    private boolean overviewMode = false;
    private WeakReference<DecisionTreeRegion> masterDTree = null;
    private WeakReference<DecisionTreeRegion> overviewDTree = null;
    private Vector displayedNodes = new Vector();
    private Vector displayedLinks = new Vector();
    private double labelBacklight = 0.0;
    private boolean linkWidthByLevel = false;
    private boolean scaleToFit = true;
    private Dimension graphSize = new Dimension(0, 0);
    private int nodeDetailsJustify = 0;
    private boolean nodeOverviewPCT100 = true;
    private static final double OVERVIEW_BLEND_RATIO = 0.5;
    private final int fontSizeOffset = 2;
    private boolean scaleNodeDetails = false;
    private int nodeDetailsLineSeparator = -1;
    private double autoOverviewSizeScale = 1.0;
    public static final int AUTO_OVERVIEW_MAX_ASPECTED_AREA = 0;
    public static final int AUTO_OVERVIEW_MAX_TREE_AREA = 1;
    private int autoOverviewSizeStrategy = 0;
    private static final int AUTO_OVERVIEW_INTERMEDIATE_POINTS = 4;
    private double autoOverviewSizeMaxPercent = 1.0;
    private boolean sortIDValues = false;
    boolean includeMissing = true;
    boolean debugAutoOverview = false;
    ArrayList<Rectangle2D> overviewSizeControlPoints = null;

    public DecisionTreeRegion() {
        this.itemManager = new ItemManager(this);
        this.arrangement = new DecisionTreeArrangement(this);
        this.setDefaultValues();
    }

    public Dimension getGraphSize() {
        return this.graphSize;
    }

    public void setGraphSize(Dimension size) {
        this.graphSize.width = size.width;
        this.graphSize.height = size.height;
        this.arrangement.setGraphSize(size.width, size.height);
    }

    public boolean isScaleToFit() {
        return this.scaleToFit;
    }

    public void setScaleToFit(boolean fit) {
        this.scaleToFit = fit;
        this.arrangement.setScaleToFit(fit);
    }

    public void setLabelBacklight(double l) {
        this.labelBacklight = l;
    }

    public double getlabelBacklight() {
        return this.labelBacklight;
    }

    public boolean isOverviewMode() {
        return this.overviewMode;
    }

    public void setOverviewMode(boolean overviewMode) {
        this.overviewMode = overviewMode;
    }

    public Vector getDisplayedNodes() {
        return this.displayedNodes;
    }

    public Vector getDisplayedLinks() {
        return this.displayedLinks;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String nid) {
        this.nodeID = nid;
    }

    public String getParentID() {
        return this.parentID;
    }

    public void setParentID(String pid) {
        this.parentID = pid;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getNodeTitle() {
        return this.nodeTitle;
    }

    public void setNodeTitle(String nodeTitle) {
        this.nodeTitle = nodeTitle;
    }

    public String getNodeInputLabel() {
        return this.nodeInputLabel;
    }

    public void setNodeInputLabel(String nodeInputLabel) {
        this.nodeInputLabel = nodeInputLabel;
    }

    public String[] getNodeInputLabelList() {
        return this.nodeInputLabelList;
    }

    public void setNodeInputLabelList(String[] nodeInputLabels) {
        this.nodeInputLabelList = nodeInputLabels;
    }

    public String getNodeOutputLabel() {
        return this.nodeOutputLabel;
    }

    public void setNodeOutputLabel(String nodeOutputLabel) {
        this.nodeOutputLabel = nodeOutputLabel;
    }

    public String[] getNodeStatusTip() {
        return this.nodeStatusTip;
    }

    public void setNodeStatusTip(String[] nodeStatusTip) {
        this.nodeStatusTip = nodeStatusTip;
    }

    public String getNodeStatus() {
        return this.nodeStatus;
    }

    public void setNodeStatus(String nodeStatus) {
        this.nodeStatus = nodeStatus;
    }

    public Object[] getNodeDetails() {
        return this.nodeDetails;
    }

    public void setNodeDetails(Object[] nodeDetails) {
        this.nodeDetails = nodeDetails;
    }

    public Object[] getNodeDetailsLabels() {
        return this.nodeDetailsLabels;
    }

    public void setNodeDetailsLabels(Object[] nodeDetailsLabels) {
        this.nodeDetailsLabels = nodeDetailsLabels;
    }

    public Object[] getNodeTip() {
        return this.nodeTip;
    }

    public void setNodeTip(Object[] nodeTip) {
        this.nodeTip = nodeTip;
    }

    public Object[] getLinkTip() {
        return this.linkTip;
    }

    public void setLinkTip(Object[] linkTip) {
        this.linkTip = linkTip;
    }

    public void setLinkType(int type) {
        this.linkType = type;
    }

    public int getLinkType() {
        return this.linkType;
    }

    public String getLinkWidthResponse() {
        return this.linkWidthResponse;
    }

    public void setLinkWidthResponse(String linkWidthResponse) {
        this.linkWidthResponse = linkWidthResponse;
    }

    public String getNodeColorGroup() {
        return this.nodeColorGroup;
    }

    public void setNodeColorGroup(String nodeColorGroup) {
        this.nodeColorGroup = nodeColorGroup;
    }

    public StringVectorVariable getNodeColorGroupVar() {
        return this.nodeColorGroupVar;
    }

    public String getNodeColorResponse() {
        return this.nodeColorResponse;
    }

    public NumericVectorVariable getNodeColorResponseVar() {
        return this.nodeColorResponseVar;
    }

    public void setNodeColorResponse(String nodeColorResponse) {
        this.nodeColorResponse = nodeColorResponse;
    }

    public String[] getOverviewNodeColorGroup() {
        return this.overviewNodeColorGroup;
    }

    public void setOverviewNodeColorGroup(String[] overviewNodeColorGroup) {
        this.overviewNodeColorGroup = overviewNodeColorGroup;
    }

    public String[] getOverviewNodeFillRatio() {
        return this.overviewNodeFillRatio;
    }

    public void setOverviewNodeFillRatio(String[] overviewNodeFillRatio) {
        this.overviewNodeFillRatio = overviewNodeFillRatio;
    }

    public Object[] getOverviewNodeLabel() {
        return this.overviewNodeLabel;
    }

    public void setOverviewNodeLabel(Object[] overviewNodeLabel) {
        this.overviewNodeLabel = overviewNodeLabel;
    }

    public FillAttrs getNodeFillStyle() {
        return this.nodeFillStyle;
    }

    public void setNodeFillStyle(FillAttrs nodeFillStyle) {
        this.nodeFillStyle = nodeFillStyle;
    }

    public FillAttrs getLinkFillStyle() {
        return this.linkFillStyle;
    }

    public void setLinkFillStyle(FillAttrs linkFillStyle) {
        this.linkFillStyle = linkFillStyle;
    }

    public LineAttrs getNodeOutlineStyle() {
        return this.nodeOutlineStyle;
    }

    public void setNodeOutlineStyle(LineAttrs nodeOutlineStyle) {
        this.nodeOutlineStyle = nodeOutlineStyle;
    }

    public TextAttrs getNodeTitleStyle() {
        return this.nodeTitleStyle;
    }

    public void setNodeTitleStyle(TextAttrs nodeTitleStyle) {
        this.nodeTitleStyle = nodeTitleStyle;
    }

    public TextAttrs getNodeInputLabelStyle() {
        return this.nodeInputLabelStyle;
    }

    public void setNodeInputLabelStyle(TextAttrs nodeInputLabelStyle) {
        this.nodeInputLabelStyle = nodeInputLabelStyle;
    }

    public TextAttrs getNodeOutputLabelStyle() {
        return this.nodeOutputLabelStyle;
    }

    public void setNodeOutputLabelStyle(TextAttrs nodeOutputLabelStyle) {
        this.nodeOutputLabelStyle = nodeOutputLabelStyle;
    }

    public TextAttrs getNodeDetailsStyle() {
        return this.nodeDetailsStyle;
    }

    public void setNodeDetailsStyle(TextAttrs nodeDetailsLabelStyle) {
        this.nodeDetailsStyle = nodeDetailsLabelStyle;
    }

    public TextAttrs getOverviewNodeLabelStyle() {
        return this.overviewNodeLabelStyle;
    }

    public void setOverviewNodeLabelStyle(TextAttrs overviewNodeLabelStyle) {
        this.overviewNodeLabelStyle = overviewNodeLabelStyle;
    }

    public boolean isColorBranchNodes() {
        return this.colorBranchNodes;
    }

    public void setColorBranchNodes(boolean colorBranchNodes) {
        this.colorBranchNodes = colorBranchNodes;
    }

    public int getDisplayDepth() {
        return this.displayDepth;
    }

    public void setDisplayDepth(int displayDepth) {
        this.displayDepth = displayDepth;
    }

    public String getDisplayRoot() {
        return this.displayRoot;
    }

    public void setDisplayRoot(String displayRoot) {
        this.displayRoot = displayRoot;
    }

    public String getOverviewNodeLabelDelimiter() {
        return this.overviewNodeLabelDelimiter;
    }

    public void setOverviewNodeLabelDelimiter(String overviewNodeLabelDelimiter) {
        this.overviewNodeLabelDelimiter = overviewNodeLabelDelimiter;
    }

    public double getNodeDetailThreshold() {
        return this.nodeDetailThreshold;
    }

    public void setNodeDetailThreshold(double nodeDetailThreshold) {
        this.nodeDetailThreshold = nodeDetailThreshold;
    }

    public java.awt.Rectangle getWallRect() {
        return this.wallRect;
    }

    public void setWallRect(java.awt.Rectangle wallRect) {
        this.wallRect = wallRect;
    }

    public ColorMapper getColorMapper() {
        return this.colorMapper;
    }

    protected void setDefaultValues() {
    }

    public int getDimension() {
        return 2;
    }

    public RangeAttrMapper getColorRAM() {
        return this.colorRAM;
    }

    public void setColorRAM(RangeAttrMapper colorRAM) {
        this.colorRAM = colorRAM;
    }

    public DiscreteAttrMapper getColorDAM() {
        return this.colorDAM;
    }

    public void setColorDAM(DiscreteAttrMapper colorDAM) {
        this.colorDAM = colorDAM;
    }

    public RangeAttrMapper getOverviewColorRAM() {
        return this.overviewColorRAM;
    }

    public void setOverviewColorRAM(RangeAttrMapper colorRAM) {
        this.overviewColorRAM = colorRAM;
    }

    public DiscreteAttrMapper getOverviewColorDAM() {
        return this.overviewColorDAM;
    }

    public void setOverviewColorDAM(DiscreteAttrMapper colorDAM) {
        this.overviewColorDAM = colorDAM;
    }

    public Color getWallColor() {
        return this.wallColor;
    }

    public void setWallColor(Color wallColor) {
        this.wallColor = wallColor;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean fillOn) {
        this.fillOn = fillOn;
    }

    public boolean isOutlineOn() {
        return this.outlineOn;
    }

    public void setOutlineOn(boolean outlineOn) {
        this.outlineOn = outlineOn;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public void setSkinType(int skinType) {
        this.skinType = skinType;
    }

    public Color getMissingFillColor() {
        return this.missingFillColor;
    }

    public void setMissingFillColor(Color missingColor) {
        this.missingFillColor = missingColor;
    }

    public Color getMissingEdgeColor() {
        return this.missingEdgeColor;
    }

    public void setMissingEdgeColor(Color missingColor) {
        this.missingEdgeColor = missingColor;
    }

    protected void connectVars() {
        int i;
        if (this.sortIDValues) {
            this.crd.sortByRole((short)2001);
            this.dataModel = this.crd.getSrcModel();
        }
        if (this.crd.isAvailable(2080) && this.nodeInputLabelList != null) {
            this.nodeInputLabelVars = new StringVectorVariable[this.nodeInputLabelList.length];
            for (i = 0; i < this.nodeInputLabelVars.length; ++i) {
                this.nodeInputLabelVars[i] = i > 0 ? (StringVectorVariable)this.connectCategory((short)(2080 + i), true) : (StringVectorVariable)this.connectCategory((short)2080, true);
            }
        } else {
            this.nodeInputLabelVars = null;
        }
        this.nodeOutputLabelVar = this.crd.isAvailable(2005) ? (StringVectorVariable)this.connectCategory((short)2005, true) : null;
        this.nodeTitleVar = this.crd.isAvailable(2003) ? (StringVectorVariable)this.connectCategory((short)2003, true) : null;
        if (this.overviewNodeLabel != null && this.overviewNodeLabel.length > 0) {
            this.overviewNodeLabelVars = new StringVectorVariable[this.overviewNodeLabel.length];
            for (i = 0; i < this.overviewNodeLabel.length; ++i) {
                this.overviewNodeLabelVars[i] = (StringVectorVariable)this.connectCategory((short)(2070 + i), true);
            }
        }
        if (this.nodeDetails != null && this.nodeDetails.length > 0) {
            this.nodeDetailVars = new StringVectorVariable[this.nodeDetails.length];
            for (i = 0; i < this.nodeDetails.length; ++i) {
                this.nodeDetailVars[i] = (StringVectorVariable)this.connectCategory((short)(2020 + i), true);
            }
        }
        if (this.nodeDetailsLabels != null && this.nodeDetailsLabels.length > 0) {
            this.nodeDetailLabelVars = new StringVectorVariable[this.nodeDetailsLabels.length];
            for (i = 0; i < this.nodeDetailsLabels.length; ++i) {
                this.nodeDetailLabelVars[i] = (StringVectorVariable)this.connectCategory((short)(2090 + i), true);
            }
        }
        if (this.crd.isAvailable(2009)) {
            this.nodeColorResponseVar = new NumericVectorVariable();
            this.nodeColorResponseVar.connectFrom(this.crd.getDoubleColumn(2009));
            ColumnMetadata cmd = (ColumnMetadata)this.crd.getColumnLabel(2009);
            this.nodeColorResponseVar.setLabel(cmd.getLabel());
            this.nodeColorResponseVar.setFormat(new GTKFormat((Format)cmd.getFormat()));
        }
        if (this.crd.isAvailable(2008)) {
            ColumnMetadata cmd = (ColumnMetadata)this.crd.getColumnLabel(2008);
            this.nodeColorGroupVar = new StringVectorVariable();
            if (cmd.getType() == 1) {
                this.nodeColorGroupVar.connectFrom(this.crd.getDoubleAsClassColumn(2008, true));
            } else {
                this.nodeColorGroupVar.connectFrom(this.crd.getStringAsClassColumn(2008, true));
            }
            this.nodeColorGroupVar.setLabel(cmd.getLabel());
            this.nodeColorGroupVar.setFormat(new GTKFormat((Format)cmd.getFormat()));
        }
        if (this.overviewNodeColorGroup != null && this.overviewNodeColorGroup.length > 0) {
            this.overviewNodeColorGroupVars = new StringVectorVariable[this.overviewNodeColorGroup.length];
            ArrayList<String> uniqueValues = new ArrayList<String>();
            for (int i2 = 0; i2 < this.overviewNodeColorGroup.length; ++i2) {
                int tvIDX = this.dataModel.getColumn(this.overviewNodeColorGroup[i2]);
                this.overviewNodeColorGroupVars[i2] = new StringVectorVariable();
                this.overviewNodeColorGroupVars[i2].connectFrom(this.dataModel.getColumnAsClassColumn(tvIDX, true));
                this.overviewNodeColorGroupVars[i2].setBlankMissing(false);
                ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(tvIDX);
                this.overviewNodeColorGroupVars[i2].setLabel(cmd.getLabel());
                this.overviewNodeColorGroupVars[i2].setFormat(new GTKFormat((Format)cmd.getFormat()));
                boolean numeric = cmd.getType() == 1;
                for (int j = 0; j < this.overviewNodeColorGroupVars[i2].getUniqueValueCount(); ++j) {
                    try {
                        String cat = this.overviewNodeColorGroupVars[i2].uniqueValue.getValue(j);
                        if (uniqueValues.contains(cat)) continue;
                        uniqueValues.add(cat);
                        continue;
                    }
                    catch (MissingValueException cat) {
                        // empty catch block
                    }
                }
            }
            String[] usvals = new String[uniqueValues.size()];
            usvals = uniqueValues.toArray(usvals);
            this.overviewGroupUniqueValues = new StringVectorVariable();
            this.overviewGroupUniqueValues.connectFrom(usvals);
        }
        if (this.overviewNodeFillRatio != null && this.overviewNodeFillRatio.length > 0) {
            this.overviewNodeFillRatioVars = new NumericVectorVariable[this.overviewNodeFillRatio.length];
            for (int i3 = 0; i3 < this.overviewNodeFillRatio.length; ++i3) {
                int tvIDX = this.dataModel.getColumn(this.overviewNodeFillRatio[i3]);
                this.overviewNodeFillRatioVars[i3] = new NumericVectorVariable();
                this.overviewNodeFillRatioVars[i3].connectFrom(this.dataModel.getDoubleColumn(tvIDX));
                ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(tvIDX);
                this.overviewNodeFillRatioVars[i3].setLabel(cmd.getLabel());
                this.overviewNodeFillRatioVars[i3].setFormat(new GTKFormat((Format)cmd.getFormat()));
            }
        }
        this.linkWidthResponseMapper = null;
        if (this.crd.isAvailable(2007)) {
            this.linkWidthResponseMapper = new ContinuousRangeToNumericMapper();
            double[] linkValues = this.crd.getDoubleColumn(2007);
            this.linkWidthVar = new NumericVectorVariable();
            this.linkWidthVar.connectFrom(linkValues);
            double inMax = this.linkWidthVar.getMax();
            this.linkWidthResponseMapper.setInputMin(0.0);
            this.linkWidthResponseMapper.setInputMax(inMax);
            this.linkWidthResponseMapper.setOutputMin(0.0);
            this.linkWidthResponseMapper.setOutputMax(10.0);
        }
        if (!this.overviewMode) {
            if (this.nodeTip != null && this.nodeTip.length > 0) {
                this.nodeTipVars = new StringVectorVariable[this.nodeTip.length];
                for (int i4 = 0; i4 < this.nodeTip.length; ++i4) {
                    ColumnMetadata cmd = this.getRoleMetadata((String)this.nodeTipRoles[i4]);
                    this.nodeTipVars[i4] = this.getTipVar(cmd);
                }
            } else {
                int detailsCnt;
                int titleCnt = this.crd.isAvailable(2003) ? 1 : 0;
                int outputLabelCnt = this.crd.isAvailable(2005) ? 1 : 0;
                int n = detailsCnt = this.nodeDetails != null ? this.nodeDetails.length : 0;
                if (titleCnt + outputLabelCnt + detailsCnt > 0) {
                    this.nodeTipVars = new StringVectorVariable[titleCnt + outputLabelCnt + detailsCnt];
                    int cnt = 0;
                    if (titleCnt > 0) {
                        ColumnMetadata cmd = this.getRoleMetadata("NODETITLE");
                        this.nodeTipVars[cnt] = this.getTipVar(cmd);
                        this.nodeTipVars[cnt].setLabel(cmd.getLabel());
                        ++cnt;
                    }
                    if (detailsCnt > 0) {
                        if (this.nodeDetailRoles != null) {
                            for (int i5 = 0; i5 < detailsCnt; ++i5) {
                                ColumnMetadata cmd = this.getRoleMetadata((String)this.nodeDetailRoles[i5]);
                                this.nodeTipVars[cnt] = this.getTipVar(cmd);
                                this.nodeTipVars[cnt].setLabel(cmd.getLabel());
                                ++cnt;
                            }
                        } else {
                            this.nodeDetailsTipPipe = new StringVector();
                            for (int j = 0; j < this.crd.getRowCount(); ++j) {
                                String str = "";
                                for (int i6 = 0; i6 < detailsCnt; ++i6) {
                                    try {
                                        String n2 = this.nodeDetailLabelVars[i6].value.getValue(j);
                                        String v = this.nodeDetailVars[i6].value.getValue(j);
                                        str = str + n2 + " = " + v + "\n";
                                        continue;
                                    }
                                    catch (MissingValueException missingValueException) {
                                        // empty catch block
                                    }
                                }
                                this.nodeDetailsTipPipe.addValue(str);
                            }
                        }
                    }
                    if (outputLabelCnt > 0) {
                        ColumnMetadata cmd = this.getRoleMetadata("NODEOUTPUTLABEL");
                        this.nodeTipVars[cnt] = this.getTipVar(cmd);
                        this.nodeTipVars[cnt].setLabel(cmd.getLabel());
                        ++cnt;
                    }
                }
            }
        }
        this.itemManager.disposeAllItems();
        this.itemManager.getIndexedItems().clear();
        if (this.buildModel()) {
            this.buildTree();
        }
        this.rebuild = true;
    }

    @Override
    public void setCRD(CRD crd) {
        super.setCRD(crd);
        this.dataModel = crd.getSrcModel();
        this.connectVars();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (x == this.getX() && y == this.getY() && w == this.getWidth() && h == this.getHeight()) {
            return;
        }
        super.setBounds(x, y, w, h);
        if (this.overviewDTree != null) {
            Point origin = this.getAbsLocation();
            this.autoLayoutOverviewArea(this.getSize(), origin);
        }
        this.rebuild = true;
    }

    public void preInitializeItem(NodeLinkDiagramItem item) {
        if (!(item instanceof LinkItem)) {
            this.initializeItemParent(item);
        }
    }

    public void initializeItem(NodeLinkDiagramItem item) {
        int obsIndex = item.getObsIndex();
        if (item instanceof NodeItem) {
            if (obsIndex >= 0) {
                String pid;
                NodeItem node = (NodeItem)item;
                boolean numericPID = this.crd.getColumnClass(2002) == Double.class;
                String string = pid = numericPID ? this.crd.getDoubleAsClassColumn(2002)[obsIndex] : this.crd.getStringAsClassColumn(2002)[obsIndex];
                if (pid != null && pid.length() > 0) {
                    NodeLinkDiagramItem np = this.itemManager.getItem(pid);
                    if (np == null || !(np instanceof NodeItem)) {
                        // empty if block
                    }
                    NodeItem newParent = (NodeItem)np;
                    LinkItem link = null;
                    NodeItem oldParent = node.getParentNode();
                    if (newParent != oldParent) {
                        node.setParentNode(newParent);
                        this.parentNodeChanged = true;
                        if (oldParent != null) {
                            link = this.createLink(newParent, node);
                        } else if (newParent != null) {
                            Vector<LinkItem> inputLinks = node.getInputLinks();
                            if (inputLinks != null && !inputLinks.isEmpty()) {
                                link = inputLinks.elementAt(0);
                                this.redirectLinkFrom(link, newParent);
                            } else {
                                link = this.createLink(newParent, node);
                            }
                        } else {
                            Vector<LinkItem> inputLinks = node.getInputLinks();
                            if (inputLinks != null && !inputLinks.isEmpty()) {
                                this.itemManager.disposeItem(inputLinks.elementAt(0));
                            }
                        }
                    } else {
                        Vector<LinkItem> inputLinks = node.getInputLinks();
                        if (inputLinks != null && !inputLinks.isEmpty()) {
                            link = inputLinks.elementAt(0);
                        }
                    }
                    if (link != null) {
                        this.itemManager.addItem(link);
                    }
                }
            }
        } else if (item instanceof LinkItem) {
            this.initializeLinkParent((LinkItem)item);
        }
    }

    private void initializeItemParent(NodeLinkDiagramItem item) {
        this.setItemParent(item, this.itemManager.getItems());
    }

    private void setItemParent(NodeLinkDiagramItem item, Vector<NodeLinkDiagramItem> parent) {
        Vector<NodeLinkDiagramItem> oldParent = item.getParent();
        if (parent != oldParent) {
            if (oldParent != null) {
                oldParent.remove(item);
                this.itemManager.unloadItem(item, oldParent);
            }
            if (parent != null) {
                parent.add(item);
                this.itemManager.loadItem(item, parent);
            }
            item.setParent(parent);
        }
    }

    private void initializeLinkParent(LinkItem link) {
        this.setItemParent(link, this.itemManager.getItems());
    }

    private LinkItem createLink(Port fromPort, Port toPort) {
        LinkItem link = null;
        if (fromPort != null && toPort != null) {
            link = new LinkItem("Link" + this.linkCount);
            ++this.linkCount;
            link.setFromPort(fromPort);
            link.setToPort(toPort);
            link.setDecisionTree(this);
        }
        return link;
    }

    private LinkItem createLink(NodeItem fromNode, NodeItem toNode) {
        return this.createLink(fromNode.getOutputPort(), toNode.getInputPort());
    }

    private void redirectLinkFrom(LinkItem link, NodeItem newFromNode) {
        if (link != null && newFromNode != null) {
            link.setFromPort(newFromNode.getOutputPort());
        }
    }

    private void redirectLinkTo(LinkItem link, NodeItem newToNode) {
        if (link != null && newToNode != null) {
            link.setToPort(newToNode.getInputPort());
        }
    }

    private boolean buildModel() {
        int observationCount = this.crd.getRowCount();
        int addedItemCount = 0;
        this.itemManager.reset();
        Vector<NodeLinkDiagramItem> indexedItems = this.itemManager.getIndexedItems();
        boolean numericID = this.crd.getColumnClass(2001) == Double.class;
        String[] ids = numericID ? this.crd.getDoubleAsClassColumn(2001) : this.crd.getStringAsClassColumn(2001);
        ArrayList<String> uniqueNodes = new ArrayList<String>();
        for (int i = 0; i < observationCount; ++i) {
            if (ids[i] == null || LayoutOverlayParser.isMissing(ids[i], numericID) || uniqueNodes.contains(ids[i])) continue;
            uniqueNodes.add(ids[i]);
            NodeItem item = new NodeItem(this, i, ids[i]);
            this.itemManager.addItem(item, true);
            ++addedItemCount;
            indexedItems.add(item);
        }
        this.itemManager.initializeItems();
        this.itemManager.endAddItems(true);
        return addedItemCount > 0;
    }

    private void buildTree() {
        this.updateRoot();
        this.validateVisibleRoot();
        this.validateTreeState();
        this.doArrangement();
    }

    public void doArrangement() {
        this.arrangement.setSpaceLevelBySubtreeWidth(true);
        if (this.overviewMode) {
            Dimension d = this.getPreferredSize();
            this.arrangement.setGraphSize(d.width, d.height);
            this.arrangement.setScaleToFit(((DecisionTreeRegion)this.masterDTree.get()).isScaleToFit());
            this.arrangement.setRoot(this.rootNode);
            this.arrangement.setDisplayDepth(-1);
        } else {
            this.arrangement.setRoot(this.visibleRootNode);
            this.arrangement.setDisplayDepth(this.getDisplayDepth());
        }
        Vector<NodeLinkDiagramItem> items = this.itemManager.getItems();
        if (this.arrangement != null && items.size() > 0) {
            this.arrangement.initialize(items);
            this.arrangement.arrange(true);
        }
    }

    private void updateRoot() {
        NodeItem treeNode = null;
        if (this.itemManager.isValidItem(this.rootNode)) {
            treeNode = this.rootNode;
        } else {
            Vector<NodeLinkDiagramItem> indexedItems = this.getIndexedItems();
            for (int i = 0; i < indexedItems.size(); ++i) {
                NodeLinkDiagramItem item = indexedItems.elementAt(i);
                if (!(item instanceof NodeItem)) continue;
                treeNode = (NodeItem)item;
                break;
            }
        }
        this.rootNode = treeNode != null ? treeNode.getRootNode() : treeNode;
        this.rootLinkWidthResponse = Double.NaN;
        if (this.rootNode != null) {
            this.rootLinkWidthResponse = this.getLinkWidthResponse(this.rootNode);
        }
    }

    private void validateVisibleRoot() {
        if (this.visibleRootNode != null || !this.itemManager.isValidItem(this.visibleRootNode)) {
            NodeItem n;
            this.visibleRootNode = this.displayRoot == null ? this.rootNode : ((n = (NodeItem)this.itemManager.getItem(this.displayRoot)) == null ? this.rootNode : n);
        }
    }

    private void validateTreeState() {
        this.treeDepth = -1;
        this.updateTreeState(this.rootNode, true, 0, -1, this.getDisplayDepth());
    }

    private void updateTreeState(NodeItem item, boolean loadSubtree, int depth, int visibleDepth, int displayDepth) {
        if (item != null) {
            boolean loadNode;
            item.setDepth(depth);
            this.treeDepth = Math.max(depth, this.treeDepth);
            if (item == this.visibleRootNode) {
                visibleDepth = 0;
                loadSubtree = true;
            }
            boolean inDrilldownTree = visibleDepth >= 0;
            boolean bl = loadNode = (visibleDepth < displayDepth || displayDepth < 1) && loadSubtree && inDrilldownTree;
            if (loadNode) {
                this.itemManager.loadItem(item, item.getParent());
            } else {
                this.itemManager.unloadItem(item, item.getParent());
            }
            Vector<LinkItem> inputLinks = item.getInputLinks();
            for (int i = 0; i < inputLinks.size(); ++i) {
                LinkItem link = inputLinks.elementAt(i);
                if (!loadNode && visibleDepth > 0) {
                    this.itemManager.loadItem(link, link.getParent());
                    continue;
                }
                this.itemManager.unloadItem(link, link.getParent());
            }
            boolean loadChildren = loadSubtree;
            Vector<NodeItem> children = item.getChildNodes();
            int nextDepth = depth + 1;
            int nextVisibleDepth = visibleDepth < 0 ? -1 : visibleDepth + 1;
            for (int i = 0; i < children.size(); ++i) {
                this.updateTreeState(children.elementAt(i), loadChildren, nextDepth, nextVisibleDepth, displayDepth);
            }
        }
    }

    private void build(Graphics g) {
        Font f;
        Dimension d = this.getSize();
        if (d.width == 0 && d.height == 0) {
            return;
        }
        AffineTransform af = ((Graphics2D)g).getTransform();
        this.displayedNodes.clear();
        this.displayedLinks.clear();
        Iterator<NodeLinkDiagramItem> it = this.itemManager.getItems().iterator();
        Font detailsFont = f = this.nodeDetailsStyle.getFont();
        if (!this.overviewMode) {
            Font scaledFont;
            detailsFont = scaledFont = new Font(f.getName(), f.getStyle(), (int)((double)f.getSize() / this.viewportScale - 2.0));
            if (this.scaleNodeDetails) {
                int minFontSize = (int)((double)StatGraph.minimumFontSize / this.viewportScale - 2.0);
                detailsFont = this.getScaleToFitFontSize(scaledFont, minFontSize);
            }
        }
        while (it.hasNext()) {
            NodeLinkDiagramItem item = it.next();
            if (item instanceof NodeItem) {
                if (!this.itemManager.isItemRendered(item)) continue;
                this.setNodeProperties((NodeItem)item, detailsFont);
                if (this.overviewMode) continue;
                this.displayedNodes.add(item.getId());
                if (!this.tooltipEnabled || this.nodeTipVars == null || this.nodeTipVars.length <= 0) continue;
                Rectangle2D sb = af.createTransformedShape(((NodeItem)item).getBounds()).getBounds2D();
                ((NodeItem)item).setScreenBounds(sb);
                continue;
            }
            if (!this.itemManager.isItemRendered(((LinkItem)item).getFromNode()) || !this.itemManager.isItemRendered(((LinkItem)item).getToNode())) continue;
            this.setLinkProperties((LinkItem)item);
            if (this.overviewMode) continue;
            this.displayedLinks.add(item.getId());
        }
    }

    private Color getOverviewBlendColor() {
        Color bg = this.getOpaqueBackground();
        return bg == null ? Color.white : bg;
    }

    Color getOpaqueBackground() {
        JComponent parent = this;
        while (parent != null && !(parent instanceof BaseStatGraphPanel)) {
            if (!(parent = (JComponent)parent.getParent()).isOpaque()) continue;
            return parent.getBackground();
        }
        return parent.getBackground();
    }

    private void setNodeProperties(NodeItem node, Font insideFont) {
        TextObject text;
        Font scaledFont;
        Font f;
        if (this.overviewMode) {
            this.setOverviewNodeProperties(node);
            return;
        }
        int obs = node.getObsIndex();
        node.clearNodeContentColors();
        boolean needsGeometry = node.isLeaf() || this.colorBranchNodes && (this.crd.isAvailable(2008) || this.crd.isAvailable(2009) || this.crd.isAvailable(2050));
        node.setLODBackgroundVisible(needsGeometry);
        if (this.overviewNodeColorGroupVars != null && this.overviewColorTable != null) {
            for (int i = 0; i < this.overviewNodeColorGroupVars.length; ++i) {
                try {
                    String gval = this.overviewNodeColorGroupVars[i].value.getValue(obs);
                    Color c = (Color)this.overviewColorTable.get(gval);
                    double ratio = this.overviewNodeFillRatioVars[i].value.getValue(obs);
                    node.addNodeContentColor(c, ratio);
                    continue;
                }
                catch (MissingValueException gval) {
                    // empty catch block
                }
            }
            node.setBackgroundColor(this.applyDataTransparency(this.nodeFillStyle.getColor(), this.nodeFillStyle));
            Color bg = this.getOpaqueBackground();
            node.setNodeContentOutlineColor(this.applyDataTransparency(new Color(bg.getRed(), bg.getGreen(), bg.getBlue())));
        } else {
            node.setBackgroundColor(this.getNodeFillColor(node));
            node.setNodeContentOutlineColor(this.applyDataTransparency(this.nodeOutlineStyle.getColor()));
        }
        node.setNodeContentOutlineThickness(StatGraph.dataDPIScaleFactor / this.viewportScale);
        node.setBorderColor(this.applyDataTransparency(this.nodeOutlineStyle.getColor()));
        node.setBorderThickness((double)this.nodeOutlineStyle.getWidth() / this.viewportScale);
        node.setBorderStyle(this.nodeOutlineStyle.getLinePattern());
        node.setBorderFactorMultiplier(1.0 / this.viewportScale);
        node.setPCT100(this.nodeOverviewPCT100);
        if (this.nodeDetailThreshold >= 0.0) {
            node.setLODThreshold(StatGraph.dataDPIScaleFactor * this.nodeDetailThreshold / 150.0);
        }
        Point2D nodeLabelConstraints = this.getNodeOverviewLabelConstraints(node);
        String outputLabel = null;
        if (this.nodeOutputLabelVar != null) {
            String label;
            try {
                label = this.nodeOutputLabelVar.value.getValue(obs);
            }
            catch (MissingValueException e) {
                label = "";
            }
            node.setLabel((byte)3, label, 1);
            TextObject text2 = node.getLabelTextObject(3, 1);
            text2.setFitConstraint(nodeLabelConstraints.getX(), node.getBounds().getHeight());
            text2.setTextColor(this.applyDataTransparency(this.nodeOutputLabelStyle.getColor()));
            f = this.nodeOutputLabelStyle.getFont();
            scaledFont = new Font(f.getName(), f.getStyle(), (int)((double)f.getSize() / this.viewportScale) - 2);
            text2.setFont(scaledFont);
            text2.setTextBacklight(this.labelBacklight);
            outputLabel = label;
        }
        if (this.nodeInputLabelVars != null) {
            for (int i = 0; i < this.nodeInputLabelVars.length; ++i) {
                String label;
                try {
                    label = this.nodeInputLabelVars[i].value.getValue(obs);
                }
                catch (MissingValueException e) {
                    label = "";
                }
                node.setLabel((byte)2, label, i);
                TextObject text3 = node.getLabelTextObject(2, i);
                text3.setFitConstraint(nodeLabelConstraints.getX(), node.getBounds().getHeight());
                text3.setTextColor(this.applyDataTransparency(this.nodeInputLabelStyle.getColor()));
                Font f2 = this.nodeInputLabelStyle.getFont();
                Font scaledFont2 = new Font(f2.getName(), f2.getStyle(), (int)((double)f2.getSize() / this.viewportScale) - 2);
                text3.setFont(scaledFont2);
                text3.setTextBacklight(this.labelBacklight);
            }
        }
        if (this.nodeTitleVar != null) {
            String title;
            try {
                title = this.nodeTitleVar.value.getValue(obs);
            }
            catch (MissingValueException e) {
                title = "";
            }
            node.setLabel((byte)1, title, 1);
            TextObject text4 = node.getLabelTextObject(1, 1);
            text4.setTextColor(this.applyDataTransparency(this.nodeTitleStyle.getColor()));
            f = this.nodeTitleStyle.getFont();
            scaledFont = new Font(f.getName(), f.getStyle(), (int)((double)f.getSize() / this.viewportScale) - 2);
            text4.setFont(scaledFont);
            text4.setTextBacklight(0.0);
        }
        if (this.nodeDetailVars != null && this.nodeDetailVars.length > 0) {
            node.setInsideLabelLineSeparator(this.nodeDetailsLineSeparator);
            String details = this.nodeDetailLabelVars != null && this.nodeDetailLabelVars.length > 0 ? this.createDelimitedString((StringVariable[])this.nodeDetailLabelVars, (StringVariable[])this.nodeDetailVars, obs) : this.createDelimitedString((StringVariable[])this.nodeDetailVars, obs);
            node.setLabel((byte)0, details, 0);
            int num = node.getNumLinesForLabel(0);
            for (int i = 0; i < num; ++i) {
                text = node.getLabelTextObject(0, i);
                if (this.nodeDetailsJustify == 1) {
                    text.setFullyJustified(true);
                }
                text.setTextColor(this.applyDataTransparency(this.nodeDetailsStyle.getColor()));
                text.setFont(insideFont);
                text.setTextBacklight(0.0);
            }
        }
        String overviewLabel = null;
        if (this.overviewNodeLabelVars != null && this.overviewNodeLabelVars.length > 0) {
            overviewLabel = this.createDelimitedString((StringVariable[])this.overviewNodeLabelVars, this.overviewNodeLabelDelimiter, obs);
        } else if (this.nodeOutputLabelVar != null) {
            overviewLabel = outputLabel;
        }
        if (overviewLabel != null) {
            if (needsGeometry) {
                node.setOverviewLabelPosition((byte)1);
            } else {
                node.setOverviewLabelPosition((byte)2);
            }
            node.setLabel((byte)4, overviewLabel, 0);
            int num = node.getNumLinesForLabel(4);
            for (int i = 0; i < num; ++i) {
                text = node.getLabelTextObject(4, i);
                text.setFitConstraint(nodeLabelConstraints.getX(), nodeLabelConstraints.getY());
                text.setTextColor(this.applyDataTransparency(this.overviewNodeLabelStyle.getColor()));
                Font f3 = this.overviewNodeLabelStyle.getFont();
                Font scaledFont3 = new Font(f3.getName(), f3.getStyle(), (int)((double)f3.getSize() / this.viewportScale) - 2);
                text.setFont(scaledFont3);
                text.setDelimiter(this.overviewNodeLabelDelimiter);
                text.setFontReduced(true);
                text.setMinimumFontSize((int)(5.0 / this.viewportScale));
                text.setTextBacklight(this.labelBacklight);
            }
        }
    }

    private String createDelimitedString(StringVariable[] vars, String delimiter, int obs) {
        if (vars == null || vars.length < 1) {
            return null;
        }
        String label = "";
        for (int i = 0; i < vars.length; ++i) {
            String str;
            try {
                str = vars[i].value.getValue(obs);
            }
            catch (MissingValueException e) {
                str = "";
            }
            if (i == 0) {
                label = str;
                continue;
            }
            if (str.trim().length() <= 0) continue;
            label = label + delimiter + str;
        }
        return label;
    }

    private String createDelimitedString(StringVariable[] vars, int obs) {
        if (vars == null || vars.length < 1) {
            return null;
        }
        String label = "";
        for (int i = 0; i < vars.length; ++i) {
            String str;
            try {
                str = vars[i].value.getValue(obs);
            }
            catch (MissingValueException e) {
                str = "";
            }
            String line = vars[i].getLabel() + " : " + str;
            label = i == 0 ? line : label + "\n" + line;
        }
        return label;
    }

    private String createDelimitedString(StringVariable[] labels, StringVariable[] vars, int obs) {
        if (labels == null || labels.length < 1 || vars == null || vars.length < 1 || labels.length != vars.length) {
            return null;
        }
        String label = "";
        for (int i = 0; i < vars.length; ++i) {
            String str;
            String name;
            try {
                name = labels[i].value.getValue(obs);
            }
            catch (MissingValueException e) {
                name = "";
            }
            try {
                str = vars[i].value.getValue(obs);
            }
            catch (MissingValueException e) {
                str = "";
            }
            String line = name + " : " + str;
            label = i == 0 ? line : label + "\n" + line;
        }
        return label;
    }

    private void setOverviewNodeProperties(NodeItem node) {
        node.clearNodeContentColors();
        node.setLODBackgroundVisible(true);
        node.setLODThreshold(0.0);
        DecisionTreeRegion master = (DecisionTreeRegion)this.masterDTree.get();
        Vector displayedNodes = master.getDisplayedNodes();
        Color nfc = this.nodeFillStyle.getColor();
        if (!displayedNodes.contains(node.getId())) {
            Color blendColor = this.getOverviewBlendColor();
            nfc = this.applyDataTransparency(DecisionTreeRegion.blendColorForOverview(nfc, blendColor, 0.5), this.nodeFillStyle);
        } else {
            nfc = master.getNodeFillColor(node);
        }
        node.setBackgroundColor(nfc);
        node.setBorder(false);
    }

    private void setLinkProperties(LinkItem link) {
        if (this.overviewMode) {
            this.setOverviewLinkProperties(link);
            return;
        }
        link.setFillColor(this.applyDataTransparency(this.linkFillStyle.getColor(), this.linkFillStyle));
        link.setLineColor(this.applyDataTransparency(this.linkLineStyle.getColor()));
        if ((this.getLinkType() == 2 || this.getLinkType() == 3) && this.crd.isAvailable(2007)) {
            link.setLineThickness(Math.max(this.getLinkWidth(link), StatGraph.dataDPIScaleFactor / this.viewportScale));
            link.setDrawPolygon(true);
        } else {
            link.setLineThickness(this.getLinkWidth(link) / this.viewportScale);
            link.setFromOffset(0.0);
            link.setToOffset(0.0);
        }
        link.setLineStyle(this.linkLineStyle.getLinePattern());
        link.setLineFactorMultiplier(1.0 / this.viewportScale);
        link.setLinkType(this.getLinkType());
        link.setTransparency(0.0);
        switch (this.getLinkType()) {
            case 2: 
            case 3: {
                link.setOutlineVisible(false);
            }
            default: {
                break;
            }
            case 1: {
                link.setOutlineVisible(true);
                break;
            }
            case 0: {
                link.setOutlineVisible(true);
            }
        }
    }

    private void setOverviewLinkProperties(LinkItem link) {
        DecisionTreeRegion master = (DecisionTreeRegion)this.masterDTree.get();
        Vector displayedLinks = master.getDisplayedLinks();
        Color lfc = this.linkFillStyle.getColor();
        Color lc = this.linkLineStyle.getColor();
        if (!displayedLinks.contains(link.getId())) {
            Color blendColor = this.getOverviewBlendColor();
            lfc = DecisionTreeRegion.blendColorForOverview(lfc, blendColor, 0.5);
            lc = DecisionTreeRegion.blendColorForOverview(lc, blendColor, 0.5);
        }
        link.setFillColor(this.applyDataTransparency(lfc, this.linkFillStyle));
        link.setLineColor(this.applyDataTransparency(lc));
        if ((this.getLinkType() == 2 || this.getLinkType() == 3) && this.crd.isAvailable(2007)) {
            link.setLineThickness(Math.max(this.getLinkWidth(link), StatGraph.dataDPIScaleFactor / this.viewportScale));
            link.setDrawPolygon(true);
        } else {
            Dimension ps = this.getSize();
            Dimension ms = ((DecisionTreeRegion)this.masterDTree.get()).getSize();
            double scaleFactor = (double)Math.min(ps.width, ps.height) / (double)Math.min(ms.width, ms.height);
            link.setLineThickness(scaleFactor * this.getLinkWidth(link) / this.viewportScale);
            link.setFromOffset(0.0);
            link.setToOffset(0.0);
        }
        link.setLineStyle(this.linkLineStyle.getLinePattern());
        link.setLineFactorMultiplier(1.0 / this.viewportScale);
        link.setLinkType(this.getLinkType());
        link.setTransparency(0.0);
        switch (this.getLinkType()) {
            case 2: 
            case 3: {
                link.setOutlineVisible(false);
            }
            default: {
                break;
            }
            case 1: {
                link.setOutlineVisible(true);
                break;
            }
            case 0: {
                link.setOutlineVisible(true);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform af = g2.getTransform();
        this.setupViewport(this.getSize(), g);
        if (this.rebuild) {
            this.build(g);
            this.rebuild = false;
        }
        if (this.overviewSizeControlPoints != null) {
            for (int i = 0; i < this.overviewSizeControlPoints.size(); ++i) {
                g2.setColor(Color.red);
                g2.fillOval((int)this.overviewSizeControlPoints.get(i).getX(), (int)this.overviewSizeControlPoints.get(i).getY(), 10, 10);
            }
        }
        Object alias = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object alias_t = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        if (this.antialiased) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        this.itemManager.draw(g);
        g2.setTransform(af);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, alias);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, alias_t);
    }

    private void setupViewport(Dimension d, Graphics g) {
        Rectangle2D dataBounds = this.itemManager.getDiagramBounds(this.overviewMode);
        double graphWidth = d.width - this.outerMargin.left - this.outerMargin.right;
        double graphHeight = d.height - this.outerMargin.top - this.outerMargin.bottom;
        double yscale = graphHeight / dataBounds.getHeight();
        double xscale = graphWidth / dataBounds.getWidth();
        double scale = Math.min(yscale, xscale);
        this.viewportScale = scale = Math.min(1.0, scale);
        double top = (double)this.outerMargin.top / scale;
        double left = (double)this.outerMargin.left / scale;
        double centerShiftX = dataBounds.getWidth() / 2.0 - graphWidth / scale / 2.0;
        double centerShiftY = dataBounds.getHeight() / 2.0 - graphHeight / scale / 2.0;
        double translateX = dataBounds.getX() - left + centerShiftX;
        double translateY = dataBounds.getY() - top + centerShiftY;
        AffineTransform af = ((Graphics2D)g).getTransform();
        if (StatGraph.VGF && scale == 1.0) {
            scale = 0.99999;
        }
        af.scale(scale, scale);
        af.translate(-translateX, -translateY);
        ((Graphics2D)g).setTransform(af);
    }

    private Rectangle createWall() {
        Rectangle wall = new Rectangle();
        wall.set2D(true);
        wall.fillOn.setValue(true);
        wall.edgeOn.setValue(false);
        wall.color.setValue(this.wallColor);
        wall.transform.translateX.setValue((double)this.dataRect.x);
        wall.transform.translateY.setValue((double)this.dataRect.y);
        wall.sizeX.setValue((double)this.dataRect.width);
        wall.sizeY.setValue((double)this.dataRect.height);
        wall.origin.setValue(5);
        return wall;
    }

    private boolean isColumnAdded(String name, Probe p) {
        Probe.ProbeEntryEnumerator existed = p.enumerate();
        if (existed == null) {
            return false;
        }
        while (existed.hasMoreElements()) {
            Probe.ProbeEntry pe = (Probe.ProbeEntry)existed.nextElement();
            if (!pe.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private void preprocessData() {
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.dataTipVars != null) {
            for (int i = 0; i < this.dataTipVars.length; ++i) {
                if (this.isColumnAdded(this.dataTipVars[i].getLabel(), this.probe)) continue;
                if (this.dataTipVars[i] instanceof StringVariable) {
                    this.probe.addPipe(this.dataTipVars[i].getLabel(), (Pipe)((StringVariable)this.dataTipVars[i]).value);
                    continue;
                }
                this.probe.addPipe(this.dataTipVars[i].getLabel(), (Pipe)((NumericVariable)this.dataTipVars[i]).value);
            }
        }
    }

    public void setColorMapper(ColorMapper mapper) {
        this.colorMapper = mapper;
        if (this.nodeColorResponse != null) {
            ContinuousRangeToColorMapper crcm = (ContinuousRangeToColorMapper)mapper;
            double min = this.crd.getColumnMin((short)2009);
            double max = this.crd.getColumnMax((short)2009);
            double[] cr = new double[3];
            crcm.setInputMin(min);
            crcm.setInputMax(max);
            cr[0] = min;
            cr[1] = (min + max) / 2.0;
            cr[2] = max;
            crcm.setColorSpectrumValues(cr);
        }
    }

    public void setOverviewColorTable(HashMap table) {
        this.overviewColorTable = table;
    }

    protected boolean isLegendEntryFromAttrMap() {
        if (this.colorDAM == null) {
            return false;
        }
        return this.colorDAM.getAttrMap().getLegendEntryPolicy() == 1;
    }

    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        if (!this.fillOn) {
            return 10;
        }
        return this.outlineOn ? 11 : 7;
    }

    protected void applyFillTransparency(LegendItem[] items) {
        if (!this.fillOn || !this.useFillTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(items[i].getSymbolAttrs().getColor(), this.nodeFillStyle));
            items[i].setSymbolAttrs((ColorAttr)fa);
        }
    }

    protected void applyLineTransparency(LegendItem[] items) {
        if (!this.outlineOn || this.fillOn || !this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            LineAttrs old = (LineAttrs)items[i].getSymbolAttrs();
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(old.getColor()));
            la.setLinePattern(old.getLinePattern());
            la.setWidth(old.getWidth());
            items[i].setSymbolAttrs((ColorAttr)la);
        }
    }

    protected LegendItem[] getLegendItemsFromAttrMap(int attrType) {
        LegendItem[] items = this.colorDAM.getAttrMap().getLegendItems(attrType, true);
        this.applyFillTransparency(items);
        this.applyLineTransparency(items);
        return items;
    }

    public LegendItem[] getLegendItems(int attrType) {
        if (this.crd.isAvailable(2009)) {
            return null;
        }
        if (this.nodeColorGroup == null && this.overviewNodeColorGroup == null) {
            LegendItem[] li = new LegendItem[1];
            if (this.fillOn) {
                FillAttrs fa = new FillAttrs();
                fa.setColor(this.applyDataTransparency(this.nodeFillStyle.getColor(), this.nodeFillStyle));
                if (this.outlineOn) {
                    LineAttrs la = new LineAttrs();
                    la.setColor(this.applyDataTransparency(this.nodeOutlineStyle.getColor()));
                    li[0] = new LegendItem((ColorAttr)fa, (ColorAttr)la, this.getLegendLabel(), null);
                } else {
                    li[0] = new LegendItem((ColorAttr)fa, null, this.getLegendLabel(), null);
                }
            } else {
                LineAttrs la = new LineAttrs();
                la.setColor(this.applyDataTransparency(this.nodeOutlineStyle.getColor()));
                la.setLinePattern(this.nodeOutlineStyle.getLinePattern());
                la.setWidth(this.nodeOutlineStyle.getWidth());
                li[0] = new LegendItem((ColorAttr)la, null, this.getLegendLabel(), null);
            }
            return li;
        }
        Vector<LegendItem> items = new Vector<LegendItem>();
        if (this.colorTable != null) {
            double fillTransparency;
            double d = fillTransparency = this.nodeFillStyle.getTransparency() >= 0.0 ? this.nodeFillStyle.getTransparency() : this.dataTransparency;
            if (this.colorDAM != null) {
                this.colorDAM.setFillTransparency(fillTransparency);
                this.colorDAM.setUseFillTransparency(this.useFillTransparency);
                this.colorDAM.setLineTransparency(this.dataTransparency);
                this.colorDAM.variable = this.nodeColorGroupVar.value;
                this.colorDAM.fillColorMapper = this.colorMapper;
                this.colorDAM.init(new AInitAction(null));
            }
            StringPipe uvals = this.nodeColorGroupVar.uniqueValue;
            int cgNum = this.nodeColorGroupVar.getUniqueValueCount();
            for (int i = 0; i < cgNum; ++i) {
                try {
                    FillAttrs attr;
                    String cat = uvals.getValue(i);
                    if (this.fillOn) {
                        attr = new FillAttrs();
                        if (this.colorDAM != null) {
                            Color c = this.colorDAM.getFillColor(cat);
                            if (c == null) {
                                c = (Color)this.colorTable.get(cat);
                            }
                            if (this.useFillTransparency) {
                                attr.setColor(this.applyDataTransparency(c, this.nodeFillStyle));
                            } else {
                                attr.setColor(this.applyTransparency(c, this.colorDAM.getFillTransparency(cat)));
                            }
                        } else {
                            attr.setColor(this.applyDataTransparency((Color)this.colorTable.get(cat), this.nodeFillStyle));
                        }
                        if (this.outlineOn) {
                            LineAttrs la = new LineAttrs();
                            la.setColor(this.applyDataTransparency(this.nodeOutlineStyle.getColor()));
                            items.add(new LegendItem((ColorAttr)attr, (ColorAttr)la, cat, null));
                            continue;
                        }
                        items.add(new LegendItem((ColorAttr)attr, null, cat, null));
                        continue;
                    }
                    attr = new LineAttrs();
                    attr.setWidth(this.nodeOutlineStyle.getWidth());
                    attr.setLinePattern(this.nodeOutlineStyle.getLinePattern());
                    if (this.colorDAM != null) {
                        attr.setColor(this.applyDataTransparency(this.colorDAM.getLineColor(cat)));
                    } else {
                        attr.setColor(this.applyDataTransparency((Color)this.colorTable.get(cat)));
                    }
                    items.add(new LegendItem((ColorAttr)attr, null, cat, null));
                    continue;
                }
                catch (MissingValueException cat) {
                    // empty catch block
                }
            }
        } else if (this.overviewColorTable != null) {
            double fillTransparency;
            double d = fillTransparency = this.nodeFillStyle.getTransparency() >= 0.0 ? this.nodeFillStyle.getTransparency() : this.dataTransparency;
            if (this.overviewColorDAM != null) {
                this.overviewColorDAM.setFillTransparency(fillTransparency);
                this.overviewColorDAM.setUseFillTransparency(this.useFillTransparency);
                this.overviewColorDAM.setLineTransparency(this.dataTransparency);
                this.overviewColorDAM.variable = this.overviewGroupUniqueValues.value;
                this.overviewColorDAM.fillColorMapper = this.colorMapper;
                this.overviewColorDAM.init(new AInitAction(null));
            }
            if (this.sortIDValues) {
                this.overviewGroupUniqueValues.setUniqueValueSort(1);
            }
            StringPipe uvals = this.overviewGroupUniqueValues.uniqueValue;
            int cgNum = this.overviewGroupUniqueValues.getUniqueValueCount();
            for (int i = 0; i < cgNum; ++i) {
                try {
                    FillAttrs attr;
                    String cat = uvals.getValue(i);
                    if (this.fillOn) {
                        attr = new FillAttrs();
                        if (this.overviewColorDAM != null) {
                            Color c = this.overviewColorDAM.getFillColor(cat);
                            if (c == null) {
                                c = (Color)this.overviewColorTable.get(cat);
                            }
                            if (this.useFillTransparency) {
                                attr.setColor(this.applyDataTransparency(c, this.nodeFillStyle));
                            } else {
                                attr.setColor(this.applyTransparency(c, this.overviewColorDAM.getFillTransparency(cat)));
                            }
                        } else {
                            attr.setColor(this.applyDataTransparency((Color)this.overviewColorTable.get(cat), this.nodeFillStyle));
                        }
                        if (this.outlineOn) {
                            LineAttrs la = new LineAttrs();
                            la.setColor(this.applyDataTransparency(this.nodeOutlineStyle.getColor()));
                            items.add(new LegendItem((ColorAttr)attr, (ColorAttr)la, cat, null));
                            continue;
                        }
                        items.add(new LegendItem((ColorAttr)attr, null, cat, null));
                        continue;
                    }
                    attr = new LineAttrs();
                    attr.setWidth(this.nodeOutlineStyle.getWidth());
                    attr.setLinePattern(this.nodeOutlineStyle.getLinePattern());
                    if (this.overviewColorDAM != null) {
                        attr.setColor(this.applyDataTransparency(this.overviewColorDAM.getLineColor(cat)));
                    } else {
                        attr.setColor(this.applyDataTransparency((Color)this.overviewColorTable.get(cat)));
                    }
                    items.add(new LegendItem((ColorAttr)attr, null, cat, null));
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        } else if (this.fillOn) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(this.nodeFillStyle.getColor(), this.nodeFillStyle));
            if (this.outlineOn) {
                LineAttrs la = new LineAttrs();
                la.setColor(this.applyDataTransparency(this.nodeOutlineStyle.getColor()));
                items.add(new LegendItem((ColorAttr)fa, (ColorAttr)la, this.getLegendLabel(), null));
            } else {
                items.add(new LegendItem((ColorAttr)fa, null, this.getLegendLabel(), null));
            }
        } else {
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(this.nodeOutlineStyle.getColor()));
            la.setLinePattern(this.nodeOutlineStyle.getLinePattern());
            la.setWidth(this.nodeOutlineStyle.getWidth());
            items.add(new LegendItem((ColorAttr)la, null, this.getLegendLabel(), null));
        }
        LegendItem[] array = new LegendItem[items.size()];
        array = items.toArray(array);
        if (this.colorTable != null && this.isLegendEntryFromAttrMap()) {
            array = Overlay.margeAttrMapWithPlotLegendItems(this.colorDAM, array, this.nodeFillStyle, this.nodeOutlineStyle, false, this.useFillTransparency, this.fillOn, true, true, this.dataTransparency, this.useDataTransparency);
        }
        return array;
    }

    public boolean hasLegend(int attrType) {
        switch (attrType) {
            case 0: {
                return true;
            }
            case 7: 
            case 11: {
                return this.fillOn;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return this.outlineOn;
            }
        }
        return false;
    }

    @Override
    public String getLegendLabel() {
        return this.legendLabel != null ? this.legendLabel : this.name;
    }

    @Override
    public String getDefaultLegendTitle() {
        return (String)this.crd.getColumnLabel(2001);
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return true;
    }

    @Override
    public ImageMap getImageMap() {
        if (!this.tooltipEnabled || this.overviewMode) {
            return null;
        }
        if ((this.nodeTipVars == null || this.nodeTipVars.length < 1) && this.nodeDetailsTipPipe == null) {
            return null;
        }
        double xo = this.getBounds().x;
        double yo = this.getBounds().y;
        ImageMap imageMap = null;
        String alt = null;
        String href = null;
        ArrayList<ImageMap.Region> rs = new ArrayList<ImageMap.Region>(this.displayedNodes.size());
        for (int i = 0; i < this.displayedNodes.size(); ++i) {
            NodeItem nd = (NodeItem)this.itemManager.getItem((String)this.displayedNodes.get(i));
            int obs = nd.getObsIndex();
            StringBuffer sb = new StringBuffer();
            if (this.nodeTipVars != null) {
                for (int j = 0; j < this.nodeTipVars.length; ++j) {
                    String v;
                    if (this.nodeTipVars[j] == null) continue;
                    try {
                        v = this.nodeTipVars[j].value.getValue(obs);
                    }
                    catch (MissingValueException e) {
                        v = "";
                    }
                    sb = sb.append(this.nodeTipVars[j].getLabel() + " = " + v + " \n");
                }
            }
            if (this.nodeDetailsTipPipe != null) {
                try {
                    sb = sb.append(this.nodeDetailsTipPipe.getValue(obs));
                }
                catch (MissingValueException j) {
                    // empty catch block
                }
            }
            if ((alt = sb.toString()).lastIndexOf("\n") > 0) {
                alt = alt.substring(0, alt.lastIndexOf("\n") - 1);
            }
            Rectangle2D sBounds = nd.getScreenBounds();
            Rectangle2D.Double coords = new Rectangle2D.Double(sBounds.getX() + xo, sBounds.getY() + yo, sBounds.getWidth(), sBounds.getHeight());
            ImageMap.Region r = new ImageMap.Region(coords, href, alt);
            rs.add(r);
        }
        ImageMap.Region[] regions = new ImageMap.Region[rs.size()];
        for (int i = 0; i < rs.size(); ++i) {
            regions[i] = (ImageMap.Region)rs.get(i);
        }
        imageMap = new ImageMap(regions);
        return imageMap;
    }

    public Range[] getColorModelRanges(int type) {
        double max;
        double min;
        String error;
        double fillTransparency;
        if (this.nodeColorResponseVar == null) {
            return null;
        }
        double d = fillTransparency = this.nodeFillStyle.getTransparency() >= 0.0 ? this.nodeFillStyle.getTransparency() : this.dataTransparency;
        if (this.colorRAM != null && (error = this.colorRAM.createColorMapper(min = this.nodeColorResponseVar.getMin(), max = this.nodeColorResponseVar.getMax())) == null) {
            if (this.fillOn) {
                return this.colorRAM.getRangeColorMapper().getFullRanges(fillTransparency);
            }
            return this.colorRAM.getRangeColorMapper().getFullRanges(this.dataTransparency);
        }
        ContinuousRangeToColorMapper crcm = (ContinuousRangeToColorMapper)this.colorMapper;
        Color[] colors = null;
        try {
            colors = crcm.getColorSpectrumColors();
        }
        catch (MissingValueException mve) {
            return null;
        }
        RangeBound low = new RangeBound(this.nodeColorResponseVar.getMin(), true);
        RangeBound high = new RangeBound(this.nodeColorResponseVar.getMax(), true);
        ColorModel colorModel = new ColorModel(colors);
        Range[] colorModelRanges = new Range[]{new Range(low, high, colorModel)};
        return colorModelRanges;
    }

    public SASFormat getContinuousLegendFormat() {
        if (this.nodeColorResponseVar == null) {
            return null;
        }
        int clrvIDX = this.dataModel.getColumn(this.nodeColorResponse);
        ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(clrvIDX);
        return cmd.getFormat();
    }

    public Color getMissingColor() {
        if (this.fillOn) {
            return this.missingFillColor;
        }
        return this.missingEdgeColor;
    }

    public boolean hasMissingValue() {
        if (this.nodeColorResponseVar == null) {
            return false;
        }
        int clrvIDX = this.dataModel.getColumn(this.nodeColorResponse);
        ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(clrvIDX);
        return cmd.getMissings() > 0;
    }

    @Override
    public String getDefaultContinuousLegendTitle() {
        if (this.nodeColorResponseVar == null) {
            return null;
        }
        int clrvIDX = this.dataModel.getColumn(this.nodeColorResponse);
        ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(clrvIDX);
        return cmd.getLabel();
    }

    public Insets getPreferredInnerMargin() {
        return null;
    }

    public Insets getPreferredOuterMargin() {
        FontMetrics fm;
        if (this.overviewMode) {
            int pad = StatGraph.getExtraPadding();
            this.outerMargin = new Insets(pad, pad, pad, pad);
            return this.outerMargin;
        }
        double top = 0.0;
        double bottom = 0.0;
        if (this.nodeInputLabelVars != null) {
            fm = StatGraph.getFontMetrics(this.nodeInputLabelStyle.getFont());
            top = fm.getHeight() * this.nodeInputLabelVars.length;
            if (this.labelBacklight != 0.0) {
                top += (double)(ScatterOverlay.getLabelOutlineWidth(this.nodeInputLabelStyle.getFont().getSize()) + 1) * 0.5;
            }
        }
        top += StatGraph.gapScaleFactor;
        top = Math.max(top, (double)StatGraph.getExtraPadding());
        double b1 = 0.0;
        double b2 = 0.0;
        if (this.overviewNodeLabelVars != null && this.overviewNodeLabelVars.length > 0) {
            fm = StatGraph.getFontMetrics(this.overviewNodeLabelStyle.getFont());
            int lines = this.overviewNodeLabelDelimiter == "\n" ? this.overviewNodeLabelVars.length : 1;
            b1 = fm.getHeight() * lines;
            if (this.labelBacklight != 0.0) {
                b1 += (double)(ScatterOverlay.getLabelOutlineWidth(this.overviewNodeLabelStyle.getFont().getSize()) + 1) * 0.5;
            }
        }
        if (this.nodeOutputLabelVar != null) {
            fm = StatGraph.getFontMetrics(this.nodeOutputLabelStyle.getFont());
            b2 = fm.getHeight();
            if (this.labelBacklight != 0.0) {
                b2 += (double)(ScatterOverlay.getLabelOutlineWidth(this.nodeOutputLabelStyle.getFont().getSize()) + 1) * 0.5;
            }
        }
        bottom = Math.max(b1, b2) + StatGraph.gapScaleFactor;
        bottom = Math.max(bottom, (double)StatGraph.getExtraPadding());
        this.outerMargin = new Insets((int)top, StatGraph.getExtraPadding(), (int)bottom, StatGraph.getExtraPadding());
        return this.outerMargin;
    }

    public void setInnerMargin(Insets margin) {
    }

    public void setOuterMargin(Insets margin) {
    }

    public Insets getInnerMargin() {
        return null;
    }

    public Insets getOuterMargin() {
        if (this.wallRect != null) {
            return new Insets(this.getHeight() - this.wallRect.y - this.wallRect.height, this.wallRect.x, this.wallRect.y, this.getWidth() - this.wallRect.x - this.wallRect.width);
        }
        return this.outerMargin;
    }

    public void enableMarginPrefCalc() {
    }

    public void disableMarginPrefCalc() {
    }

    public boolean isUseFillTransparency() {
        return this.useFillTransparency;
    }

    public void setUseFillTransparency(boolean useFillTransparency) {
        this.useFillTransparency = useFillTransparency;
    }

    public double getNumericValue(short role, int obsindex) {
        double[] values = this.crd.getDoubleColumn(role);
        if (values == null || values.length < obsindex) {
            return Double.NaN;
        }
        return values[obsindex];
    }

    public String getStringValue(short role, int obsindex) {
        String[] values = this.crd.getStringColumn(role);
        if (values == null || values.length < obsindex) {
            return null;
        }
        return values[obsindex];
    }

    public String getFormattedValue(short role, int obsindex) {
        String[] values;
        Class c = this.crd.getColumnClass(role);
        String[] stringArray = values = c.isInstance(String.class) ? this.crd.getStringAsClassColumn(role, this.includeMissing) : this.crd.getDoubleAsClassColumn(role, this.includeMissing);
        if (values == null || values.length < obsindex) {
            return null;
        }
        return values[obsindex];
    }

    public String getLabelValue(short role) {
        return (String)this.crd.getColumnLabel(role);
    }

    public boolean isAutoArrange() {
        return this.autoArrange;
    }

    public void setAutoArrange(boolean autoArrange) {
        this.autoArrange = autoArrange;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public DecisionTreeArrangement getArrangement() {
        return this.arrangement;
    }

    public void setArrangement(DecisionTreeArrangement arrangment) {
        this.arrangement = arrangment;
    }

    public int getTreeDepth() {
        return this.treeDepth;
    }

    public Vector<NodeLinkDiagramItem> getItems() {
        return this.itemManager.getItems();
    }

    public Vector<NodeLinkDiagramItem> getIndexedItems() {
        return this.itemManager.getIndexedItems();
    }

    private boolean isTreeSubset() {
        if (this.visibleRootNode != null && this.visibleRootNode != this.rootNode) {
            return true;
        }
        int displayDepth = this.getDisplayDepth();
        return displayDepth > 0 && displayDepth <= this.treeDepth;
    }

    private boolean overviewRendersAllItems() {
        return this.isTreeSubset();
    }

    private boolean overviewRendersViewport() {
        return !this.isTreeSubset();
    }

    public void itemAdded(NodeLinkDiagramItem item) {
    }

    public void itemRemoved(NodeLinkDiagramItem item) {
    }

    public void disposingItem(NodeLinkDiagramItem item) {
    }

    private Insets getViewortInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public static Color blendColorForOverview(Color color, Color blendColor, double blendPct) {
        double r = (1.0 - blendPct) * (double)color.getRed() + blendPct * (double)blendColor.getRed();
        double g = (1.0 - blendPct) * (double)color.getGreen() + blendPct * (double)blendColor.getGreen();
        double b = (1.0 - blendPct) * (double)color.getBlue() + blendPct * (double)blendColor.getBlue();
        return new Color((int)r, (int)g, (int)b);
    }

    public double getLinkWidth(LinkItem link) {
        double childResponse;
        if (this.linkType != 2 && this.linkType != 3 && this.linkWidthResponseMapper != null) {
            try {
                double value = this.linkWidthVar.value.getValue(link.getToNode().getObsIndex());
                return Math.max(1.0, this.linkWidthResponseMapper.getValue(value));
            }
            catch (MissingValueException value) {}
        } else if (!Double.isNaN(this.rootLinkWidthResponse) && !Double.isNaN(childResponse = this.getLinkWidthResponse(link.getToNode()))) {
            return (double)(NodeItem.getScaledNodeSize() - 10) * childResponse / this.rootLinkWidthResponse;
        }
        if (this.linkWidthByLevel && !this.overviewMode) {
            return this.getLinkWidthByLevel(this.linkLineStyle.getWidth(), link.getFromNode().getDepth());
        }
        return this.linkLineStyle.getWidth();
    }

    private double getLinkWidthByLevel(double width, int level) {
        int rootDepth = this.visibleRootNode.getDepth();
        level -= rootDepth;
        int totalDepth = this.getDisplayDepth();
        if (totalDepth <= 0) {
            totalDepth = this.treeDepth - rootDepth;
        }
        Vector<Double> levelSpace = this.arrangement.getLevelSpacing();
        double[] newLevelSpace = new double[levelSpace.size()];
        for (int i = 0; i < levelSpace.size(); ++i) {
            newLevelSpace[i] = levelSpace.get(i);
            if (i <= 0) continue;
            newLevelSpace[i] = Math.min(newLevelSpace[i - 1], newLevelSpace[i]);
        }
        double rootSpace = levelSpace.get(0);
        return Math.max(1.0, this.getTopLinkWidth(width) * newLevelSpace[level] / rootSpace);
    }

    private double getTopLinkWidth(double width) {
        int rootDepth = this.visibleRootNode.getDepth();
        int totalDepth = this.getDisplayDepth();
        if (totalDepth <= 0) {
            totalDepth = this.treeDepth - rootDepth;
        }
        return Math.ceil(Math.sqrt(totalDepth) * width);
    }

    public double getLinkWidthResponse(NodeItem node) {
        if (this.crd.isAvailable(2007)) {
            try {
                return this.linkWidthVar.value.getValue(node.getObsIndex());
            }
            catch (MissingValueException ex) {
                return Double.NaN;
            }
        }
        return Double.NaN;
    }

    private void calculateNodeLabelHeights() {
        int maxTreeDepth = this.getTreeDepth();
        if (maxTreeDepth < 0) {
            return;
        }
        this.nodeLabelHeightByTreeDepth = new Vector();
        for (int i = 0; i < maxTreeDepth + 1; ++i) {
            this.nodeLabelHeightByTreeDepth.add((Double)Double.MAX_VALUE);
        }
        if (maxTreeDepth == 0) {
            this.nodeLabelHeightByTreeDepth.setElementAt(new Double(NodeItem.getScaledNodeSize()), 0);
            return;
        }
        Vector<NodeLinkDiagramItem> items = this.itemManager.getItems();
        Vector<Double> levelSpacing = this.arrangement.getLevelSpacing();
        boolean colorRole = false;
        if (this.nodeColorResponse != null) {
            colorRole = true;
        } else if (this.nodeColorGroup != null) {
            colorRole = true;
        } else if (this.crd.isAvailable(2050)) {
            colorRole = true;
        }
        boolean branchNodesNeedGeometry = this.colorBranchNodes && colorRole;
        for (NodeLinkDiagramItem item : this.itemManager.getItems()) {
            if (!(item instanceof NodeItem)) continue;
            NodeItem node = (NodeItem)item;
            int depth = node.getDepth();
            double nodeHeight = node.getBounds().getHeight();
            if (node.isLeaf() || branchNodesNeedGeometry) {
                double v = Math.min(levelSpacing.elementAt(depth) * 0.75, this.nodeLabelHeightByTreeDepth.elementAt(depth));
                this.nodeLabelHeightByTreeDepth.setElementAt(v, depth);
                continue;
            }
            double availibleHeight = depth == 0 ? nodeHeight + levelSpacing.elementAt(depth) : (depth == maxTreeDepth ? nodeHeight + levelSpacing.elementAt(depth - 1) : nodeHeight + Math.min(levelSpacing.elementAt(depth), levelSpacing.elementAt(depth - 1)));
            this.nodeLabelHeightByTreeDepth.setElementAt(Math.min(availibleHeight, this.nodeLabelHeightByTreeDepth.elementAt(depth)), depth);
        }
        Double labelSize = this.nodeLabelHeightByTreeDepth.elementAt(0);
        for (int i = 1; i < maxTreeDepth; ++i) {
            labelSize = Math.min(labelSize, this.nodeLabelHeightByTreeDepth.elementAt(i));
            this.nodeLabelHeightByTreeDepth.setElementAt(labelSize, i);
        }
        this.nodeLabelHeightByTreeDepth.setElementAt(labelSize, maxTreeDepth);
    }

    private Point2D getNodeOverviewLabelConstraints(NodeItem node) {
        if (this.nodeLabelHeightByTreeDepth == null) {
            this.calculateNodeLabelHeights();
        }
        Point2D.Double constraints = new Point2D.Double(this.getNodeAvailibleWidth(node), this.nodeLabelHeightByTreeDepth.elementAt(node.getDepth()));
        return constraints;
    }

    private double getNodeAvailibleWidth(NodeItem node) {
        if (node != null) {
            double nodeRight;
            double nodeLeft;
            NodeItem leftNode = this.arrangement.getLeftNeighbor(node);
            NodeItem rightNode = this.arrangement.getRightNeighbor(node);
            boolean includeUnrenderedItems = false;
            Rectangle2D diagramBounds = this.getItemManager().getDiagramBounds(includeUnrenderedItems);
            double boundsLeft = diagramBounds.getMinX();
            double boundsRight = diagramBounds.getMaxX();
            Rectangle2D nodeBounds = node.getBounds();
            double textSpace = 0.0;
            if (leftNode != null) {
                Rectangle2D leftNodeBounds = leftNode.getBounds();
                nodeLeft = nodeBounds.getMinX();
                nodeRight = leftNodeBounds.getMaxX();
                boundsLeft = Math.max(boundsLeft, (nodeLeft + nodeRight) / 2.0 + textSpace);
            }
            if (rightNode != null) {
                Rectangle2D rightNodeBounds = rightNode.getBounds();
                nodeLeft = rightNodeBounds.getMinX();
                nodeRight = nodeBounds.getMaxX();
                boundsRight = Math.min(boundsRight, (nodeLeft + nodeRight) / 2.0 - textSpace);
            }
            double nodeWidth = node.getWidth();
            double nodeMiddle = node.getBounds().getCenterX();
            int childVisibleDepth = node.getDepth() + 1;
            if (!this.visibleRootInvalid && this.visibleRootNode != null) {
                childVisibleDepth -= this.visibleRootNode.getDepth();
            }
            if (childVisibleDepth < this.displayDepth) {
                Vector<NodeItem> children = node.getChildNodes();
                int numChildren = children.size();
                if (numChildren < 2) {
                    boundsLeft = Math.max(boundsLeft, nodeMiddle - nodeWidth);
                    boundsRight = Math.min(boundsRight, nodeMiddle + nodeWidth);
                } else {
                    leftNode = children.elementAt(0);
                    rightNode = children.elementAt(numChildren - 1);
                    Rectangle2D leftNodeBounds = leftNode.getBounds();
                    Rectangle2D rightNodeBounds = rightNode.getBounds();
                    boundsLeft = Math.max(Math.max(boundsLeft, leftNodeBounds.getX()), nodeMiddle - 2.5 * nodeWidth);
                    boundsRight = Math.min(Math.min(boundsRight, rightNodeBounds.getMaxX()), nodeMiddle + 2.5 * nodeWidth);
                }
            }
            return Math.min(nodeMiddle - boundsLeft, boundsRight - nodeMiddle) * 2.0;
        }
        return 0.0;
    }

    public WeakReference<DecisionTreeRegion> getMasterDTree() {
        return this.masterDTree;
    }

    public void setMasterDTree(WeakReference<DecisionTreeRegion> masterDTree) {
        this.masterDTree = masterDTree;
    }

    public WeakReference<DecisionTreeRegion> getOverviewDTree() {
        return this.overviewDTree;
    }

    public void setOverviewDTree(WeakReference<DecisionTreeRegion> overviewDTree) {
        this.overviewDTree = overviewDTree;
    }

    @Override
    public Dimension getPreferredSize() {
        boolean hasHeight;
        Dimension regionSize;
        if (!this.overviewMode) {
            return super.getPreferredSize();
        }
        double preferredSize = StatGraph.scaleLegendLineLength(200);
        double maxPct = 0.5;
        RegionContainer parent = (RegionContainer)((DecisionTreeRegion)this.masterDTree.get()).getParent();
        Dimension dimension = regionSize = parent == null ? ((DecisionTreeRegion)this.masterDTree.get()).getGraphSize() : parent.getSize();
        if (regionSize.width == 0 || regionSize.height == 0) {
            return super.getPreferredSize();
        }
        double aspect = (double)regionSize.width / (double)regionSize.height;
        int w = this.getParent() == null ? -1 : ((AbstractSGComponent)this.getParent()).getUserWidth();
        int h = this.getParent() == null ? -1 : ((AbstractSGComponent)this.getParent()).getUserHeight();
        boolean hasWidth = w > 0;
        boolean bl = hasHeight = h > 0;
        if (hasWidth && w > regionSize.width) {
            w = regionSize.width;
        }
        if (hasHeight && h > regionSize.height) {
            h = regionSize.height;
        }
        if (!hasWidth) {
            if (!hasHeight) {
                if (aspect > 1.0) {
                    w = (int)Math.min(preferredSize, (double)regionSize.width * maxPct);
                    h = (int)((double)w / aspect);
                } else {
                    h = (int)Math.min(preferredSize, (double)regionSize.height * maxPct);
                    w = (int)((double)h * aspect);
                }
            } else {
                w = (int)((double)h * aspect);
            }
        } else if (!hasHeight) {
            h = (int)((double)w / aspect);
        }
        return new Dimension(w, h);
    }

    private Color getNodeFillColor(NodeItem node) {
        int obs = node.getObsIndex();
        if (this.nodeColorGroup != null) {
            try {
                String value = this.nodeColorGroupVar.value.getValue(obs);
                return (Color)this.colorTable.get(value);
            }
            catch (MissingValueException mve) {
                return this.missingFillColor;
            }
        }
        if (this.nodeColorResponse != null) {
            ContinuousRangeToColorMapper crtc = (ContinuousRangeToColorMapper)this.colorMapper;
            crtc.init(new AInitAction(null));
            try {
                double value = this.nodeColorResponseVar.value.getValue(obs);
                return crtc.getValue(value);
            }
            catch (MissingValueException mve) {
                return this.missingFillColor;
            }
        }
        if (this.overviewNodeColorGroupVars != null && this.overviewColorTable != null) {
            try {
                String value = this.overviewNodeColorGroupVars[0].value.getValue(obs);
                return (Color)this.overviewColorTable.get(value);
            }
            catch (MissingValueException mve) {
                return this.missingFillColor;
            }
        }
        return this.applyDataTransparency(this.nodeFillStyle.getColor(), this.nodeFillStyle);
    }

    public HashMap getColorTable() {
        return this.colorTable;
    }

    public void setColorTable(HashMap colorTable) {
        this.colorTable = colorTable;
    }

    public StringVectorVariable[] getOverviewNodeColorGroupVars() {
        return this.overviewNodeColorGroupVars;
    }

    public LineAttrs getLinkLineStyle() {
        return this.linkLineStyle;
    }

    public void setLinkLineStyle(LineAttrs linkLineStyle) {
        this.linkLineStyle = linkLineStyle;
    }

    public Object[] getNodeDetailRoles() {
        return this.nodeDetailRoles;
    }

    public void setNodeDetailRoles(Object[] nodeDetailRoles) {
        this.nodeDetailRoles = nodeDetailRoles;
    }

    public Object[] getNodeTipRoles() {
        return this.nodeTipRoles;
    }

    public void setNodeTipRoles(Object[] nodeTipRoles) {
        this.nodeTipRoles = nodeTipRoles;
    }

    private StringVectorVariable getTipVar(ColumnMetadata cmd) {
        StringVectorVariable tipVar = new StringVectorVariable();
        tipVar.setLabel(cmd.getLabel());
        int col = this.crd.getSrcModel().getColumn(cmd.getName());
        ColumnMetadata cmd2 = (ColumnMetadata)this.crd.getSrcModel().getColumnLabel(col);
        this.crd.getSrcModel().setColumnLabel(col, cmd);
        tipVar.connectFrom(this.crd.getSrcModel().getUpdatedColumnAsClassColumn(col));
        this.crd.getSrcModel().setColumnLabel(col, cmd2);
        this.crd.getSrcModel().getUpdatedColumnAsClassColumn(col);
        return tipVar;
    }

    public int getNodeDetailsJustify() {
        return this.nodeDetailsJustify;
    }

    public void setNodeDetailsJustify(int nodeDetailsJustify) {
        this.nodeDetailsJustify = nodeDetailsJustify;
    }

    public boolean isNodeOverviewPCT100() {
        return this.nodeOverviewPCT100;
    }

    public void setNodeOverviewPCT100(boolean nodeOverviewPCT100) {
        this.nodeOverviewPCT100 = nodeOverviewPCT100;
    }

    private Font getScaleToFitFontSize(Font startFont, int minFontSize) {
        FontMetrics fm;
        if (this.nodeDetailVars == null && (this.nodeDetailLabelVars == null || this.nodeDetailLabelVars.length == 0)) {
            return startFont;
        }
        String maxStr = "";
        for (NodeLinkDiagramItem item : this.itemManager.getItems()) {
            if (!(item instanceof NodeItem) || !this.itemManager.isItemRendered(item)) continue;
            int obs = ((NodeItem)item).getObsIndex();
            String details = this.nodeDetailLabelVars != null && this.nodeDetailLabelVars.length > 0 ? this.createDelimitedString((StringVariable[])this.nodeDetailLabelVars, (StringVariable[])this.nodeDetailVars, obs) : this.createDelimitedString((StringVariable[])this.nodeDetailVars, obs);
            StringTokenizer tokenizer = new StringTokenizer(details, "\n");
            while (tokenizer.hasMoreTokens()) {
                String str = tokenizer.nextToken();
                if (str.length() <= maxStr.length()) continue;
                maxStr = str;
            }
        }
        double constraintsWidth = (double)NodeItem.getScaledNodeSize() - 2.0 * NodeItem.getScaledLabelOffset().getX();
        Font font = startFont;
        while (font.getSize() > minFontSize && !((double)(fm = StatGraph.getFontMetrics(font)).stringWidth(maxStr) < constraintsWidth)) {
            font = new Font(font.getFamily(), font.getStyle(), font.getSize() - 1);
        }
        return font;
    }

    public boolean isScaleNodeDetails() {
        return this.scaleNodeDetails;
    }

    public void setScaleNodeDetails(boolean scaleNodeDetails) {
        this.scaleNodeDetails = scaleNodeDetails;
    }

    public int getNodeDetailsLineSeparator() {
        return this.nodeDetailsLineSeparator;
    }

    public void setNodeDetailsLineSeparator(int nodeDetailsLineSeparator) {
        this.nodeDetailsLineSeparator = nodeDetailsLineSeparator;
    }

    protected void autoLayoutOverviewArea(Dimension d, Point origin) {
        Rectangle2D dataBounds = this.itemManager.getDiagramBounds(this.overviewMode);
        this.outerMargin = this.getPreferredOuterMargin();
        double graphWidth = d.width - this.outerMargin.left - this.outerMargin.right;
        double graphHeight = d.height - this.outerMargin.top - this.outerMargin.bottom;
        double yscale = graphHeight / dataBounds.getHeight();
        double xscale = graphWidth / dataBounds.getWidth();
        double scale = Math.min(yscale, xscale);
        this.viewportScale = scale = Math.min(1.0, scale);
        double ox = (double)origin.x / scale;
        double oy = (double)origin.y / scale;
        double top = (double)this.outerMargin.top / scale;
        double left = (double)this.outerMargin.left / scale;
        double centerShiftX = dataBounds.getWidth() / 2.0 - graphWidth / scale / 2.0;
        double centerShiftY = dataBounds.getHeight() / 2.0 - graphHeight / scale / 2.0;
        double translateX = dataBounds.getX() - left + centerShiftX;
        double translateY = dataBounds.getY() - top + centerShiftY;
        AffineTransform af = new AffineTransform();
        af.scale(scale, scale);
        af.translate(ox - translateX, oy - translateY);
        DecisionTreeRegion overview = (DecisionTreeRegion)this.overviewDTree.get();
        java.awt.Rectangle b = this.getAutoOverviewSize(af, graphHeight / graphWidth, origin);
        if (b == null) {
            return;
        }
        JComponent p = (JComponent)overview.getParent();
        if (p.getBounds().width == b.width && p.getBounds().height == b.height) {
            return;
        }
        double pct = 1.0;
        if ((double)b.width > this.autoOverviewSizeMaxPercent * (double)d.width) {
            pct = this.autoOverviewSizeMaxPercent * (double)d.width / (double)b.width;
        }
        if ((double)b.height > this.autoOverviewSizeMaxPercent * (double)d.height) {
            pct = Math.min(pct, this.autoOverviewSizeMaxPercent * (double)d.height / (double)b.height);
        }
        int prefWidth = (int)((double)b.width * pct);
        int prefHeight = (int)((double)b.height * pct);
        ((AbstractSGComponent)p).setUserWidth(prefWidth);
        ((AbstractSGComponent)p).setUserHeight(prefHeight);
        overview.doArrangement();
        overview.getItemManager().invalidateDiagramBounds();
    }

    private NodeItem[] getSideNodes(boolean left) {
        int visibleDepth;
        int visibleRootDepth = this.visibleRootNode.getDepth();
        int n = visibleDepth = this.displayDepth > 0 ? this.displayDepth : this.treeDepth + 1;
        if (visibleRootDepth + visibleDepth > this.treeDepth) {
            visibleDepth = this.treeDepth + 1 - visibleRootDepth;
        }
        NodeItem[] sideNodes = new NodeItem[visibleDepth];
        for (NodeLinkDiagramItem item : this.itemManager.getItems()) {
            NodeItem ni;
            int i;
            if (!(item instanceof NodeItem) || !this.itemManager.isItemRendered(item) || sideNodes[i = (ni = (NodeItem)item).getDepth() - visibleRootDepth] != null) continue;
            if (left && this.arrangement.getLeftNeighbor(ni) == null) {
                sideNodes[i] = ni;
                continue;
            }
            if (left || this.arrangement.getRightNeighbor(ni) != null) continue;
            sideNodes[i] = ni;
        }
        int nMiss = 0;
        for (int i = 0; i < visibleDepth; ++i) {
            if (sideNodes[i] != null) continue;
            ++nMiss;
        }
        if (nMiss > 0) {
            NodeItem[] sideNodes2 = new NodeItem[sideNodes.length - nMiss];
            int cnt = 0;
            for (int i = 0; i < visibleDepth; ++i) {
                if (sideNodes[i] == null) continue;
                sideNodes2[cnt++] = sideNodes[i];
            }
            sideNodes = sideNodes2;
        }
        return sideNodes;
    }

    private Point2D[] getIntermediatePoints(double x1, double y1, double x2, double y2, int nIntPoints) {
        Point2D[] pts = new Point2D[nIntPoints];
        double intv = 1.0 / (double)(nIntPoints + 1);
        for (int i = 0; i < nIntPoints; ++i) {
            double t = (double)(i + 1) * intv;
            double x = x1 + (x2 - x1) * t;
            double y = y1 + (y2 - y1) * t;
            pts[i] = new Point2D.Double(x, y);
        }
        return pts;
    }

    public java.awt.Rectangle getAutoOverviewSize(AffineTransform af, double graphAspect, Point2D origin) {
        if (this.treeDepth <= 0) {
            return null;
        }
        if (this.debugAutoOverview) {
            this.overviewSizeControlPoints = new ArrayList();
        }
        NodeItem[] leftNodes = this.getSideNodes(true);
        ArrayList<Rectangle2D> rects = new ArrayList<Rectangle2D>();
        double hOffset = NodeItem.getScaledNodeSize() / 5;
        Rectangle2D b = leftNodes[0].getBounds();
        double minX = b.getX() - hOffset;
        double maxY = b.getY() + (double)NodeItem.getScaledNodeSize();
        Rectangle2D r = new Rectangle2D.Double(minX, maxY, 1.0, 1.0);
        if (this.debugAutoOverview) {
            this.overviewSizeControlPoints.add(r);
        }
        r = this.map2Screen(af, r);
        r.setRect(0.0, 0.0, r.getX() - origin.getX(), r.getY() - origin.getY());
        rects.add(r);
        for (int i = 1; i < leftNodes.length; ++i) {
            b = leftNodes[i - 1].getBounds();
            double x1 = b.getX() - hOffset;
            double y1 = b.getY() + (double)NodeItem.getScaledNodeSize();
            b = leftNodes[i].getBounds();
            double x2 = b.getX() - hOffset;
            double y2 = b.getY();
            Point2D[] intPoints = this.getIntermediatePoints(x1, y1, x2, y2, 4);
            for (int j = 0; j < intPoints.length; ++j) {
                if (intPoints[j].getX() < minX) {
                    minX = intPoints[j].getX();
                }
                if (intPoints[j].getY() > maxY) {
                    maxY = intPoints[j].getY();
                }
                r = new Rectangle2D.Double(minX, maxY, 1.0, 1.0);
                if (this.debugAutoOverview) {
                    this.overviewSizeControlPoints.add(r);
                }
                r = this.map2Screen(af, r);
                r.setRect(0.0, 0.0, r.getX() - origin.getX(), r.getY() - origin.getY());
                rects.add(r);
            }
            double x = b.getX() - hOffset;
            double y = b.getY() + (double)NodeItem.getScaledNodeSize();
            if (x < minX) {
                minX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            r = new Rectangle2D.Double(minX, maxY, 1.0, 1.0);
            if (this.debugAutoOverview) {
                this.overviewSizeControlPoints.add(r);
            }
            r = this.map2Screen(af, r);
            r.setRect(0.0, 0.0, r.getX() - origin.getX(), r.getY() - origin.getY());
            rects.add(r);
        }
        Rectangle2D dataBounds = this.itemManager.getDiagramBounds(true);
        int maxArea = -1;
        Rectangle2D theBounds = (Rectangle2D)rects.get(0);
        for (int i = 0; i < rects.size(); ++i) {
            double w;
            double h;
            double maxHeight;
            int area;
            r = (Rectangle2D)rects.get(i);
            if (this.autoOverviewSizeStrategy == 1) {
                area = this.getDataDisplayArea(dataBounds, (int)r.getWidth(), (int)r.getHeight());
                if (area <= maxArea) continue;
                maxArea = area;
                theBounds = r;
                continue;
            }
            double maxWidth = r.getWidth();
            if (graphAspect * maxWidth > (maxHeight = r.getHeight())) {
                h = maxHeight;
                w = maxHeight / graphAspect;
            } else {
                w = maxWidth;
                h = maxWidth * graphAspect;
            }
            area = (int)(w * h);
            if (area <= maxArea) continue;
            maxArea = area;
            theBounds = new Rectangle2D.Double(r.getX(), r.getY(), w, h);
        }
        return new java.awt.Rectangle((int)theBounds.getX(), (int)theBounds.getX(), (int)(this.autoOverviewSizeScale * theBounds.getWidth()), (int)(this.autoOverviewSizeScale * theBounds.getHeight()));
    }

    public Rectangle2D map2Screen(AffineTransform af, Rectangle2D data) {
        Rectangle2D.Double rec = new Rectangle2D.Double(data.getX(), data.getY(), 1.0, 1.0);
        Rectangle2D bounds = af.createTransformedShape(rec).getBounds2D();
        return bounds;
    }

    private int getDataDisplayArea(Rectangle2D dataBounds, int w, int h) {
        double yscale = (double)h / dataBounds.getHeight();
        double xscale = (double)w / dataBounds.getWidth();
        double scale = Math.min(yscale, xscale);
        scale = Math.min(1.0, scale);
        return (int)(dataBounds.getWidth() * dataBounds.getHeight() * scale * scale);
    }

    public double getAutoOverviewSizeScale() {
        return this.autoOverviewSizeScale;
    }

    public void setAutoOverviewSizeScale(double autoOverviewSizeScale) {
        this.autoOverviewSizeScale = autoOverviewSizeScale;
    }

    public boolean isSortIDValues() {
        return this.sortIDValues;
    }

    public void setSortIDValues(boolean sortIDValues) {
        this.sortIDValues = sortIDValues;
    }
}

