/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RPFUtil;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RB;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.common.waterfall.WaterfallChartObject;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class WaterfallChartOverlay
extends Overlay {
    public static final String RB_KEY = "WaterfallChartOverlay.";
    WaterfallChartObject waterfall = new WaterfallChartObject();
    Channel thisChannel;
    protected DataRange categoryRange = null;
    protected DataRange colorRange = null;
    protected PositionEncoder categoryEncoder;
    protected PositionEncoder responseEncoder;
    protected ColorEncoder colorEncoder;
    protected ColorEncoder outlineColorEncoder;
    private Variable categoryVar;
    private Variable responseVar;
    private Variable colorVar;
    private Variable urlVar;
    protected URL barSkinImageLocation;
    protected Probe initBarProbe;
    protected Probe finalBarProbe;
    private boolean includeMissingGroup = true;
    private boolean numericColor = false;
    private String initialBarCategoryValue = null;
    private String whereExpression = null;
    private VariableProcessor vp = null;
    private int categorySortOrder = 0;

    public WaterfallChartOverlay() {
        this.waterfall.setInitialBarTickmarkLabel(RB.getStringResource(RB_KEY, "Initial.txt"), true);
        this.waterfall.setFinalBarTickmarkLabel(RB.getStringResource(RB_KEY, "Final.txt"));
        this.waterfall.setBarIncreasingLegendLabel(RB.getStringResource(RB_KEY, "BarIncreasing.txt"));
        this.waterfall.setBarLabelFormat(DataModel.defaultFormat);
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
    }

    protected void connectVars() {
        NumericVector nv;
        StringVector sv;
        StringVectorVariable svv;
        ColumnMetadata cmd;
        if (StatGraph.isOLAP()) {
            this.connectOLAPVars();
            return;
        }
        CRD crd = this.model;
        this.vp = new VariableProcessor();
        boolean numericCategory = false;
        Variable numericCategoryVar = null;
        if (crd.isAvailable(1)) {
            this.categoryVar = this.connectCategory((short)1, StatGraph.includeMissingDiscrete);
            boolean bl = numericCategory = this.model.getColumnClass(1) == Double.class;
            if (numericCategory) {
                numericCategoryVar = this.connectRaw((short)1);
                SASFormat fmt = ((ColumnMetadata)crd.getColumnLabel(1)).getFormat();
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                }
                numericCategoryVar.setFormat(new GTKFormat((Format)fmt));
            }
        } else {
            this.categoryVar = null;
        }
        this.responseVar = crd.isAvailable(2) ? this.connectRaw((short)2) : null;
        this.numericColor = false;
        short colorRole = 3;
        if (crd.isAvailable(108)) {
            this.colorVar = this.connectRaw((short)108);
            colorRole = 108;
            this.numericColor = true;
        } else {
            this.colorVar = crd.isAvailable(107) ? this.connectCategory((short)107, this.includeMissingGroup) : null;
        }
        this.urlVar = this.connectCategory((short)52, false);
        if (this.urlVar != null) {
            this.vp.addVariable(this.urlVar);
        }
        if (this.waterfall.getResponseStatistic() != -1) {
            if (numericCategoryVar != null) {
                this.vp.addGroupVariable(numericCategoryVar);
                this.vp.addVariable(this.categoryVar);
                numericCategoryVar.setUniqueValueSort(1);
            } else {
                this.vp.addGroupVariable(this.categoryVar);
            }
            this.vp.addVariable(this.responseVar, this.waterfall.getResponseStatistic());
            if (this.colorVar != null) {
                if (this.numericColor) {
                    this.vp.addVariable(this.colorVar, this.waterfall.getColorResponseStatistic());
                } else {
                    this.vp.addVariable(this.colorVar, 12);
                }
            }
        } else {
            this.vp.addVariable(this.categoryVar);
            this.vp.addVariable(this.responseVar);
            if (this.colorVar != null) {
                this.vp.addVariable(this.colorVar);
            }
        }
        this.addCRDWhereClause(this.vp);
        if (!StatGraph.includeMissingDiscrete) {
            this.whereExpression = numericCategoryVar != null ? "^(" + numericCategoryVar.getName() + " IS MISSING)" : "^(" + this.categoryVar.getName() + " IS MISSING)";
            String curWhere = this.vp.getWhereExpression();
            if (curWhere != null) {
                this.whereExpression = "(" + curWhere + ") & (" + this.whereExpression + ")";
            }
            this.vp.setWhereExpression(this.whereExpression);
        }
        if (this.initialBarCategoryValue != null) {
            StringVariable cVar = (StringVariable)this.categoryVar;
            for (int i = 0; i < cVar.getUniqueValueCount(); ++i) {
                try {
                    String cval = cVar.uniqueValue.getValue(i);
                    String fval = cVar.getFormatter().format((Object)cval);
                    if (!this.initialBarCategoryValue.equals(fval)) continue;
                    int index = cVar.getFirstOccurringValueIndex(i);
                    double initValue = ((NumericVariable)this.responseVar).value.getValue(index);
                    this.waterfall.setInitialBarValue(initValue);
                    if (this.waterfall.isInitialTickmarkLabelOverriden()) break;
                    this.waterfall.setInitialBarTickmarkLabel(this.initialBarCategoryValue);
                    break;
                }
                catch (MissingValueException cval) {
                    // empty catch block
                }
            }
            this.whereExpression = this.categoryVar.getColumnName() + " NE \"" + this.initialBarCategoryValue + "\"";
            String curWhere = this.vp.getWhereExpression();
            if (curWhere != null) {
                this.whereExpression = "(" + curWhere + ") & (" + this.whereExpression + ")";
            }
            this.vp.setWhereExpression(this.whereExpression);
        } else {
            this.whereExpression = null;
        }
        if (this.categorySortOrder != 0) {
            this.vp.setSort(this.categoryVar, this.categorySortOrder);
        }
        this.addCHPipe(RPFUtil.applyConditionalHiliting(this.model.getSrcModel(), this.vp, this.waterfall.getResponseStatistic()));
        if (this.categoryVar != null) {
            this.computeCategoryRange((StringVariable)this.categoryVar, (NumericVariable)numericCategoryVar);
            this.waterfall.setCategoryVariable(this.categoryVar);
        }
        if (this.responseVar != null) {
            this.waterfall.setResponseVariable(this.responseVar);
        }
        this.setFormat(this.waterfall.getDataRange((byte)2), 2);
        if (this.colorVar != null) {
            this.waterfall.setColorVariable(this.colorVar);
        }
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.urlVar != null) {
            this.probe.addPipe("_URL_", (Pipe)((StringVariable)this.urlVar).value);
        }
        if (crd.isAvailable(300)) {
            this.addCustomTips(this.vp);
        } else {
            this.addTooltip(this.vp, "CATEGORY");
            if (this.waterfall.getResponseStatistic() != -1) {
                this.addTooltip(this.vp, "RESPONSE", this.probe, this.waterfall.getResponseStatistic());
            } else {
                this.addTooltip(this.vp, "RESPONSE");
            }
        }
        this.initBarProbe = new Probe();
        this.initBarProbe.setTrimOn(true);
        if (this.waterfall.isShowInitialBar()) {
            cmd = null;
            cmd = this.getRoleMetadata("CATEGORY");
            svv = new StringVectorVariable();
            sv = new StringVector();
            sv.addValue(this.waterfall.getInitialBarTickmarkLabel());
            svv.connectFrom((StringPipe)sv);
            this.initBarProbe.setMissingReplacement(StatGraph.missingCharacter);
            this.initBarProbe.addPipe(cmd.getLabel(), (Pipe)svv.formattedValue);
            nv = new NumericVector();
            nv.addValue(this.waterfall.getInitialBarValue());
            NumericVectorVariable nvv = new NumericVectorVariable();
            cmd = this.getRoleMetadata("RESPONSE");
            if (cmd.getFormat() != null) {
                nvv.setFormat(new GTKFormat((Format)cmd.getFormat()));
            } else {
                nvv.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            }
            nvv.connectFrom((NumericPipe)nv);
            this.initBarProbe.setMissingReplacement(StatGraph.missingOption);
            this.initBarProbe.addPipe(cmd.getLabel(), (Pipe)nvv.value);
        }
        this.finalBarProbe = new Probe();
        this.finalBarProbe.setTrimOn(true);
        if (this.waterfall.isShowFinalBar()) {
            cmd = null;
            cmd = this.getRoleMetadata("CATEGORY");
            svv = new StringVectorVariable();
            sv = new StringVector();
            sv.addValue(this.waterfall.getFinalBarTickmarkLabel());
            svv.connectFrom((StringPipe)sv);
            svv.init();
            this.finalBarProbe.setMissingReplacement(StatGraph.missingCharacter);
            this.finalBarProbe.addPipe(cmd.getLabel(), (Pipe)svv.formattedValue);
            nv = new NumericVector();
            nv.addValue(this.waterfall.getFinalBarValue());
            NumericVectorVariable nvv = new NumericVectorVariable();
            cmd = this.getRoleMetadata("RESPONSE");
            if (cmd.getFormat() != null) {
                nvv.setFormat(new GTKFormat((Format)cmd.getFormat()));
            } else {
                nvv.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            }
            nvv.connectFrom((NumericPipe)nv);
            nvv.init();
            this.finalBarProbe.setMissingReplacement(StatGraph.missingOption);
            this.finalBarProbe.addPipe(cmd.getLabel(), (Pipe)nvv.value);
        }
        this.colorRange = this.computeRange(this.colorVar, this.numericColor, colorRole, false, this.colorRange, (byte)4);
    }

    private void computeCategoryRange(StringVariable categoryVariable, NumericVariable rawCategoryVariable) {
        if (categoryVariable == null || categoryVariable.getValueCount() == 0) {
            this.categoryRange = null;
            return;
        }
        if (rawCategoryVariable != null) {
            rawCategoryVariable.getUniqueValueCount();
        }
        int numberOfCategories = categoryVariable.getUniqueValueCount();
        Vector<String> categories = new Vector<String>(numberOfCategories + 2);
        Vector<Double> rawCatVar = new Vector<Double>(numberOfCategories + 2);
        if (this.waterfall.isShowInitialBar()) {
            categories.add(this.waterfall.getInitialBarTickmarkLabel());
            if (rawCategoryVariable != null) {
                rawCatVar.add((Double)Double.MIN_VALUE);
            }
        }
        for (int i = 0; i < numberOfCategories; ++i) {
            String val = null;
            try {
                val = categoryVariable.formattedUniqueValue.getValue(i);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            categories.add(val);
            if (rawCategoryVariable == null) continue;
            double dval = Double.NaN;
            try {
                dval = rawCategoryVariable.uniqueValue.getValue(i);
            }
            catch (Exception mve) {
                dval = -1.7976931348623157E308;
            }
            rawCatVar.add(dval);
        }
        if (this.waterfall.isShowFinalBar()) {
            categories.add(this.waterfall.getFinalBarTickmarkLabel());
            if (rawCategoryVariable != null) {
                rawCatVar.add((Double)Double.MAX_VALUE);
            }
        }
        this.categoryRange = rawCategoryVariable != null ? new OrdinalRange((Object[])categories.toArray(new String[categories.size()]), (Object[])rawCatVar.toArray(new Double[rawCatVar.size()])) : new DiscreteRange((Object[])categories.toArray(new String[categories.size()]));
        if (this.categoryRange instanceof DiscreteRange) {
            DiscreteRange cdr = (DiscreteRange)this.categoryRange;
            if (this.waterfall.isShowInitialBar()) {
                cdr.setValuePosition(this.waterfall.getInitialBarTickmarkLabel(), 1);
            }
            if (this.waterfall.isShowFinalBar()) {
                cdr.setValuePosition(this.waterfall.getFinalBarTickmarkLabel(), 2);
            }
        }
        this.categoryRange.setLabel(categoryVariable.getLabel());
    }

    @Override
    protected boolean connectNetwork() {
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        this.applySkinImage();
        this.waterfall.setXLimits(this.categoryEncoder.getLowerLimit(), this.categoryEncoder.getUpperLimit());
        RangeAttrMapper rangeAttrMapper = null;
        DiscreteAttrMapper discreteAttrMapper = null;
        ColorMap colorMap = null;
        StringToColorMap outlineColorMap = null;
        if (this.colorEncoder != null) {
            if (this.numericColor) {
                colorMap = (ColorMap)this.colorEncoder.getValueMap();
                if (this.hasAttrVar("COLORRESPONSE")) {
                    double max;
                    ContinuousRangeToColorMap crtcmap;
                    double min;
                    rangeAttrMapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE");
                    String error = rangeAttrMapper.createColorMapper(min = (crtcmap = (ContinuousRangeToColorMap)colorMap).getInputMin(), max = crtcmap.getInputMax());
                    if (error != null) {
                        rangeAttrMapper = null;
                    } else if (this.waterfall.getTransactionBarFillAttrs().getTransparency() > -1.0) {
                        rangeAttrMapper.setTransparency(this.waterfall.getTransactionBarFillAttrs().getTransparency());
                    } else {
                        rangeAttrMapper.setTransparency(this.dataTransparency);
                    }
                }
            } else {
                double fillTrans = this.dataTransparency;
                if (this.getTransactionBarFillAttrs().getTransparency() != -1.0) {
                    fillTrans = this.getTransactionBarFillAttrs().getTransparency();
                }
                colorMap = this.getIndexedColorMap((short)107, this.colorEncoder.colorArray, this.colorEncoder.colorList, true, fillTrans);
                if (this.outlineColorEncoder != null) {
                    outlineColorMap = this.getIndexedColorMap((short)107, this.outlineColorEncoder.colorArray, this.outlineColorEncoder.colorList, false, this.dataTransparency);
                }
                if (this.hasAttrVar("COLORGROUP")) {
                    discreteAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("COLORGROUP");
                    discreteAttrMapper.setFillTransparency(fillTrans);
                    discreteAttrMapper.setUseFillTransparency(this.useFillTransparency);
                }
            }
        }
        boolean bl = this.needConnect = !this.waterfall.connectNetwork((StringToNumericMap)this.categoryEncoder.getValueMap(), (ContinuousRangeToNumericMap)this.responseEncoder.getValueMap(), colorMap, outlineColorMap, rangeAttrMapper, discreteAttrMapper, this.probe, this.initBarProbe, this.finalBarProbe);
        if (this.isConditionalHilited()) {
            IntegerVector chHAlign = new IntegerVector();
            IntegerVector chVAlign = new IntegerVector();
            this.buildCHAlignments(chHAlign, chVAlign);
            NetworkRoot nr = this.waterfall.getNetworkRoot();
            Bar bar = this.waterfall.getTransactionBarElement();
            for (int i = 0; i < this.getNumCHPipes(); ++i) {
                BooleanVector bv = this.getCHPipe(i);
                com.sas.graphics.util.gtk.gl.Image tag = RPFUtil.newTagElement(i, false, this.waterfall.getChannel().getComponent());
                nr.addElement((Element)tag);
                tag.transform.translateX.connectFrom((NumericPipe)bar.position);
                tag.transform.translateY.connectFrom((NumericPipe)bar.startValue);
                tag.horizontalJustification.connectFrom((IntegerPipe)chHAlign);
                tag.verticalJustification.connectFrom((IntegerPipe)chVAlign);
                tag.visibility.connectFrom((BooleanPipe)bv);
            }
        }
        return !this.needConnect;
    }

    private void buildCHAlignments(IntegerVector chHAlign, IntegerVector chVAlign) {
        int valueCount = this.responseVar.getValueCount();
        chHAlign.setSize(valueCount);
        chVAlign.setSize(valueCount);
        for (int i = 0; i < valueCount; ++i) {
            try {
                double respVal = ((NumericVariable)this.responseVar).value.getValue(i);
                if (respVal >= 0.0) {
                    chVAlign.setValueAt(3, i);
                } else {
                    chVAlign.setValueAt(0, i);
                }
                chHAlign.setValueAt(1, i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    @Override
    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        if (!this.waterfall.isShowBarFill()) {
            return 10;
        }
        return this.waterfall.isShowBarEdge() ? 11 : 7;
    }

    @Override
    protected void applyDataSkin(LegendItem[] items) {
        if (!this.waterfall.isShowBarFill() || this.skinType == 0) {
            return;
        }
        Image legendSkin = this.loadLegendSkinImage();
        Image[] legendPixelBender = this.loadLegendPixelBenderImages();
        for (int i = 0; i < items.length; ++i) {
            items[i].setPixelBenderImages(legendPixelBender);
            items[i].setSkinType(this.skinType);
            items[i].setSkinImage(legendSkin);
        }
    }

    @Override
    protected void applyFillTransparency(LegendItem[] items) {
        if (!this.waterfall.isShowBarFill() || !this.useFillTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(items[i].getSymbolAttrs().getColor(), this.getTransactionBarFillAttrs().getTransparency()));
            items[i].setSymbolAttrs((ColorAttr)fa);
        }
    }

    @Override
    protected void applyLineTransparency(LegendItem[] items) {
        if (!this.waterfall.isShowBarEdge() || !this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            LineAttrs old = (LineAttrs)items[i].getSymbolAttrs();
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(old.getColor()));
            la.setLinePattern(old.getLinePattern());
            la.setWidth(old.getWidth());
            items[i].setSymbolAttrs((ColorAttr)la);
        }
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.waterfall.getBarSkin() == null) {
            this.applySkinImage();
        }
        if (this.colorVar != null && this.colorVar instanceof StringVariable) {
            double fillTrans = this.dataTransparency;
            if (this.getTransactionBarFillAttrs().getTransparency() != -1.0) {
                fillTrans = this.getTransactionBarFillAttrs().getTransparency();
            }
            StringToColorMap colorMap = null;
            StringToColorMap outlineColorMap = null;
            if (this.colorEncoder != null) {
                colorMap = this.getIndexedColorMap((short)107, this.colorEncoder.colorArray, this.colorEncoder.colorList, true, fillTrans);
                colorMap.init(new AInitAction());
            }
            if (this.outlineColorEncoder != null) {
                outlineColorMap = this.getIndexedColorMap((short)107, this.outlineColorEncoder.colorArray, this.outlineColorEncoder.colorList, false, this.dataTransparency);
                outlineColorMap.init(new AInitAction());
            }
            DiscreteAttrMapper discreteAttrMapper = null;
            if (this.hasAttrVar("COLORGROUP")) {
                discreteAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("COLORGROUP");
                discreteAttrMapper.setFillTransparency(fillTrans);
                discreteAttrMapper.setUseFillTransparency(this.useFillTransparency);
            }
            StringVectorVariable colors = (StringVectorVariable)this.connectCategory((short)107, this.includeMissingGroup);
            VariableProcessor vp = new VariableProcessor();
            if (this.categoryVar != null || this.groupOrder == 1 || this.groupOrder == 2) {
                if (this.categoryVar != null) {
                    StringVectorVariable catVar = (StringVectorVariable)this.connectCategory((short)1, StatGraph.includeMissingDiscrete);
                    catVar.setName(this.categoryVar.getName());
                    vp.addGroupVariable((Variable)catVar);
                    vp.addVariable((Variable)colors, 12);
                }
                if (this.groupOrder == 1 || this.groupOrder == 2) {
                    boolean numericGroup;
                    int sort = this.groupOrder == 1 ? 1 : 2;
                    boolean bl = numericGroup = this.model.getColumnClass(107) == Double.class;
                    if (numericGroup) {
                        Variable rawColors = this.connectRaw((short)107);
                        vp.addVariable(rawColors);
                        vp.setSort(rawColors, sort);
                    } else {
                        vp.setSort((Variable)colors, sort);
                    }
                }
            }
            if (this.whereExpression != null) {
                vp.setWhereExpression(this.whereExpression);
            }
            LegendItem[] items = this.waterfall.getLegendItems(colors, attrType, discreteAttrMapper, colorMap, outlineColorMap);
            if (this.isLegendEntryFromAttrMap("COLORGROUP")) {
                items = WaterfallChartOverlay.margeAttrMapWithPlotLegendItems(discreteAttrMapper, items, this.waterfall.getTransactionBarFillAttrs(), this.waterfall.getBarOutlineAttrs(), this.waterfall.isFillColorOverride(), this.useFillTransparency, this.waterfall.isOutlineColorOverride(), true, true, this.dataTransparency, this.useDataTransparency);
            }
            return items;
        }
        if (this.isColorByResponseSign()) {
            return this.waterfall.getLegendItems(null, attrType, null, null, null);
        }
        String defaultLabel = this.responseVar.getLabel();
        if (defaultLabel == null) {
            defaultLabel = this.name;
        }
        return new LegendItem[]{this.waterfall.getOverlayLegendItem(this.legendLabel != null ? this.legendLabel : defaultLabel)};
    }

    @Override
    public boolean hasLegend(int attrType) {
        boolean hasLegend = false;
        switch (attrType) {
            case 0: 
            case 7: 
            case 11: {
                if (this.colorVar instanceof NumericVariable && !this.isColorByResponseSign()) break;
                hasLegend = true;
            }
        }
        return hasLegend;
    }

    @Override
    public Range[] getColorModelRanges(int type) {
        RangeAttrMapper rangeAttrMapper = null;
        if (this.numericColor && this.colorEncoder != null) {
            ColorMap colorMap = (ColorMap)this.colorEncoder.getValueMap();
            if (this.hasAttrVar("COLORRESPONSE")) {
                double max;
                ContinuousRangeToColorMap crtcmap;
                double min;
                rangeAttrMapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE");
                String error = rangeAttrMapper.createColorMapper(min = (crtcmap = (ContinuousRangeToColorMap)colorMap).getInputMin(), max = crtcmap.getInputMax());
                if (error != null) {
                    StatGraph.printWarning(error);
                    rangeAttrMapper = null;
                    return this.getDefaultColorModelRanges();
                }
                if (this.waterfall.getTransactionBarFillAttrs().getTransparency() > -1.0) {
                    return rangeAttrMapper.getRangeColorMapper().getFullRanges(this.waterfall.getTransactionBarFillAttrs().getTransparency());
                }
                return rangeAttrMapper.getRangeColorMapper().getFullRanges(this.dataTransparency);
            }
            return this.getDefaultColorModelRanges();
        }
        return null;
    }

    private Range[] getDefaultColorModelRanges() {
        Color[] colors = this.colorEncoder.rampColors;
        ContinuousRange range = (ContinuousRange)this.colorEncoder.getInput();
        Range[] colorModelRanges = new Range[1];
        RangeBound low = new RangeBound(range.getMin(), true);
        RangeBound high = new RangeBound(range.getMax(), true);
        ColorModel colorModel = new ColorModel(colors);
        colorModelRanges[0] = new Range(low, high, colorModel);
        return colorModelRanges;
    }

    @Override
    public SASFormat getContinuousLegendFormat() {
        if (this.numericColor && this.colorEncoder != null && this.colorEncoder.getInput() instanceof ContinuousRange) {
            SASFormat fmt = this.colorEncoder.getInput().getFormat();
            if (fmt == null) {
                fmt = DataModel.defaultFormat;
            } else if (fmt.getFormatDescription().isDecimalWidthSupported()) {
                int w = fmt.getFormatDescription().getMaxWidth();
                int d = fmt.getDecimalWidth();
                fmt = SASFormat.getInstance((String)(fmt.getBaseFormatName() + Integer.toString(w).trim() + "." + Integer.toString(d).trim()));
                fmt.setInsertBlanks(false);
            }
            return fmt;
        }
        return null;
    }

    @Override
    public void draw(Graphics g) {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.waterfall.draw();
    }

    @Override
    public void select() {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.waterfall.select();
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.categoryRange;
            }
            case 2: {
                return this.waterfall.getDataRange(dimension);
            }
            case 4: {
                return this.colorRange;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.waterfall.setChannel(channel);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (encoder != null && encoder.equals(this.categoryEncoder) || !(encoder instanceof PositionEncoder)) {
                return;
            }
            this.categoryEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (encoder != null && encoder.equals(this.responseEncoder) || !(encoder instanceof PositionEncoder)) {
                return;
            }
            this.responseEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4) {
            if (encoder != null && encoder.equals(this.colorEncoder) || !(encoder instanceof ColorEncoder)) {
                return;
            }
            this.colorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 17) {
            if (encoder != null && encoder.equals(this.outlineColorEncoder) || !(encoder instanceof ColorEncoder)) {
                return;
            }
            this.outlineColorEncoder = (ColorEncoder)encoder;
        }
        this.needConnect = true;
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        int n;
        double offset = 0.0;
        if (dimension == 1) {
            n = Math.max(StatGraph.MPC, this.categoryVar.getUniqueValueCount());
            offset = n > 1 ? (this.categoryEncoder.getUpperLimit() - this.categoryEncoder.getLowerLimit()) / (double)n : 0.25 * (this.categoryEncoder.getUpperLimit() - this.categoryEncoder.getLowerLimit()) / (double)n;
        }
        if (dimension == 2) {
            n = Math.max(StatGraph.MPC, this.responseVar.getUniqueValueCount());
            offset = n > 1 ? (this.responseEncoder.getUpperLimit() - this.responseEncoder.getLowerLimit()) / (double)n : 0.25 * (this.responseEncoder.getUpperLimit() - this.responseEncoder.getLowerLimit()) / (double)n;
        }
        return offset;
    }

    @Override
    public Insets getPreferredInnerMargin() {
        double wallWidth = this.categoryEncoder == null ? 0.0 : Math.abs(this.categoryEncoder.getUpperLimit() - this.categoryEncoder.getLowerLimit());
        double wallHeight = this.responseEncoder == null ? 0.0 : Math.abs(this.responseEncoder.getUpperLimit() - this.responseEncoder.getLowerLimit());
        return this.waterfall.getPreferredInnerMargin(wallWidth, wallHeight, this.responseEncoder == null ? null : (ContinuousRangeToNumericMap)this.responseEncoder.getValueMap());
    }

    public void setDisplayMode(String mode) {
        this.waterfall.setDisplayMode(mode);
    }

    @Override
    public void setSkinType(int type) {
        if (type == this.skinType) {
            return;
        }
        super.setSkinType(type);
        switch (this.skinType) {
            default: {
                this.barSkinImageLocation = null;
                break;
            }
            case 1: {
                this.barSkinImageLocation = StatGraph.class.getResource("sgchart/res/VBarEffects_modern.png");
                break;
            }
            case 2: {
                this.barSkinImageLocation = StatGraph.class.getResource("sgchart/res/VBarEffects_Satin.png");
                break;
            }
            case 5: {
                this.barSkinImageLocation = StatGraph.class.getResource("sgchart/res/VerticalBar_Crisp.png");
                break;
            }
            case 6: {
                this.barSkinImageLocation = StatGraph.class.getResource("sgchart/res/VerticalBar_Gloss.png");
                break;
            }
            case 7: {
                this.barSkinImageLocation = StatGraph.class.getResource("sgchart/res/VerticalBar_Matte.png");
                break;
            }
            case 3: {
                this.barSkinImageLocation = StatGraph.class.getResource("sgchart/res/VerticalBar_Pressed.png");
                break;
            }
            case 4: {
                this.barSkinImageLocation = StatGraph.class.getResource("sgchart/res/VerticalBar_Sheen.png");
            }
        }
    }

    public Color getBarOutlineColor() {
        return this.waterfall.getBarEdgeColor();
    }

    public void setBarOutlineColor(Color barOutlineColor) {
        this.waterfall.setBarEdgeColor(barOutlineColor);
    }

    public int getBarOutlineWidth() {
        return this.waterfall.getBarEdgeWidth();
    }

    public void setBarOutlineWidth(int barOutlineWidth) {
        this.waterfall.setBarEdgeWidth(barOutlineWidth);
    }

    public double getBarThicknessAsPercentage() {
        return this.waterfall.getBarThicknessAsPercentage();
    }

    public void setBarThicknessAsPercentage(double barThicknessAsPercentage) {
        this.waterfall.setBarThicknessAsPercentage(barThicknessAsPercentage);
    }

    public double getBarFillColorTransparency() {
        return this.waterfall.getTransactionBarTransparency();
    }

    public void setBarFillColorOpacity(double t) {
        this.waterfall.setTransactionBarTransparency(t);
    }

    public boolean isShowBarLabels() {
        return this.waterfall.isShowBarLabels();
    }

    public void setShowBarLabels(boolean showBarLabels) {
        this.waterfall.setShowBarLabels(showBarLabels);
    }

    public boolean isShowTrendLine() {
        return this.waterfall.isShowTrendLine();
    }

    public void setShowTrendLine(boolean showTrendLine) {
        this.waterfall.setShowTrendLine(showTrendLine);
    }

    public boolean isShowInitialBar() {
        return this.waterfall.isShowInitialBar();
    }

    public void setShowInitialBar(boolean showInitialBar) {
        this.waterfall.setShowInitialBar(showInitialBar);
    }

    public boolean isShowFinalBar() {
        return this.waterfall.isShowFinalBar();
    }

    public double getBaselineIntercept() {
        return this.waterfall.getBaselineIntercept();
    }

    public void setBaselineIntercept(double baselineIntercept) {
        this.waterfall.setBaselineIntercept(baselineIntercept);
    }

    public int getTrendlineType() {
        return this.waterfall.getTrendlineType();
    }

    public void setTrendlineType(int trendlineType) {
        this.waterfall.setTrendlineType(trendlineType);
    }

    public double getInitialBarValue() {
        return this.waterfall.getInitialBarValue();
    }

    public void setInitialBarValue(double initialBarValue) {
        this.waterfall.setInitialBarValue(initialBarValue);
    }

    public Color getInitialBarColor() {
        return this.waterfall.getInitialBarColor();
    }

    public void setInitialBarColor(Color initialBarColor) {
        this.waterfall.setInitialBarColor(initialBarColor);
    }

    public double getInitialBarTransparency() {
        return this.waterfall.getInitialBarTransparency();
    }

    public void setInitialBarTransparency(double initialBarTransparency) {
        this.waterfall.setInitialBarTransparency(initialBarTransparency);
    }

    public String getInitialBarTickmarkLabel() {
        return this.waterfall.getInitialBarTickmarkLabel();
    }

    public void setInitialBarTickmarkLabel(String initialBarTickmarkLabel) {
        this.waterfall.setInitialBarTickmarkLabel(initialBarTickmarkLabel);
    }

    public Color getFinalBarColor() {
        return this.waterfall.getFinalBarColor();
    }

    public void setFinalBarColor(Color finalBarColor) {
        this.waterfall.setFinalBarColor(finalBarColor);
    }

    public double getFinalBarTransparency() {
        return this.waterfall.getFinalBarTransparency();
    }

    public void setFinalBarTransparency(double finalBarTransparency) {
        this.waterfall.setFinalBarTransparency(finalBarTransparency);
    }

    public String getFinalBarTickmarkLabel() {
        return this.waterfall.getFinalBarTickmarkLabel();
    }

    public void setFinalBarTickmarkLabel(String finalBarTickmarkLabel) {
        this.waterfall.setFinalBarTickmarkLabel(finalBarTickmarkLabel);
    }

    public TextStyle getBarLabelStyle() {
        return this.waterfall.getBarLabelStyle();
    }

    public void setBarLabelStyle(TextStyle barLabelStyle) {
        this.waterfall.setBarLabelStyle(barLabelStyle);
    }

    public FillAttrs getTransactionBarFillAttrs() {
        return this.waterfall.getTransactionBarFillAttrs();
    }

    public void setTransactionBarFillAttrs(FillAttrs transactionBarFillAttrs) {
        this.waterfall.setTransactionBarFillAttrs(transactionBarFillAttrs);
    }

    public FillAttrs getInitialBarFillAttrs() {
        return this.waterfall.getInitialBarFillAttrs();
    }

    public void setInitialBarFillAttrs(FillAttrs initialBarFillAttrs) {
        this.waterfall.setInitialBarFillAttrs(initialBarFillAttrs);
    }

    public FillAttrs getFinalBarFillAttrs() {
        return this.waterfall.getFinalBarFillAttrs();
    }

    public double getTransactionBarTransparency() {
        return this.waterfall.getTransactionBarTransparency();
    }

    public void setTransactionBarTransparency(double transparency) {
        this.waterfall.setTransactionBarTransparency(transparency);
    }

    public void setFinalBarFillAttrs(FillAttrs finalBarFillAttrs) {
        this.waterfall.setFinalBarFillAttrs(finalBarFillAttrs);
    }

    public LineAttrs getBarOutlineAttrs() {
        return this.waterfall.getBarOutlineAttrs();
    }

    public void setBarOutlineAttrs(LineAttrs barOutlineAttrs) {
        this.waterfall.setBarOutlineAttrs(barOutlineAttrs);
    }

    public LineAttrs getTrendlineAttrs() {
        return this.waterfall.getTrendlineAttrs();
    }

    public void setTrendlineAttrs(LineAttrs trendlineAttrs) {
        this.waterfall.setTrendlineAttrs(trendlineAttrs);
    }

    public LineAttrs getTrendlineIncreasingAttrs() {
        return this.waterfall.getTrendlineIncreasingAttrs();
    }

    public void setTrendlineIncreasingAttrs(LineAttrs trendlineIncreasingAttrs) {
        this.waterfall.setTrendlineIncreasingAttrs(trendlineIncreasingAttrs);
    }

    public LineAttrs getTrendlineDecreasingAttrs() {
        return this.waterfall.getTrendlineDecreasingAttrs();
    }

    public void setTrendlineDecreasingAttrs(LineAttrs trendlineDecreasingAttrs) {
        this.waterfall.setTrendlineDecreasingAttrs(trendlineDecreasingAttrs);
    }

    private void applySkinImage() {
        if (this.dataTransparency == 1.0) {
            return;
        }
        if (this.barSkinImageLocation == null || this.waterfall.getChannel() == null) {
            return;
        }
        this.waterfall.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
        this.waterfall.setPixelBenderImages(this.loadPixelBenderImages(this.waterfall.getNetworkRoot(), this.skinType, 1));
        this.waterfall.setLegendPixelBenderImages(this.loadLegendPixelBenderImages(this.waterfall.getNetworkRoot(), this.skinType, 1));
        Component c = this.waterfall.getChannel().getComponent();
        if (c == null) {
            Image barSkinImage = Toolkit.getDefaultToolkit().getImage(this.barSkinImageLocation);
            if (this.skinType == 1 || this.skinType == 2 || this.skinType == 6 || this.skinType == 3) {
                this.waterfall.setBarSkin(barSkinImage);
            }
            if (this.skinType != 1 && this.skinType != 2) {
                this.waterfall.setSkinType(this.skinType);
                this.waterfall.setLegendSkin(this.getLegendSkinImage(this.waterfall.getNetworkRoot(), this.skinType));
            } else {
                this.waterfall.setLegendSkin(barSkinImage);
            }
            this.needConnect = true;
            return;
        }
        MediaTracker tracker = new MediaTracker(this.waterfall.getChannel().getComponent());
        try {
            Image barSkinImage = Toolkit.getDefaultToolkit().getImage(this.barSkinImageLocation);
            tracker.addImage(barSkinImage, 0);
            tracker.waitForAll();
            if (this.skinType == 1 || this.skinType == 2 || this.skinType == 6 || this.skinType == 3) {
                this.waterfall.setBarSkin(barSkinImage);
            }
            if (this.skinType != 1 && this.skinType != 2) {
                this.waterfall.setSkinType(this.skinType);
                this.waterfall.setLegendSkin(this.getLegendSkinImage(this.waterfall.getNetworkRoot(), this.skinType));
            } else {
                this.waterfall.setLegendSkin(barSkinImage);
            }
            this.needConnect = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getResponseStatistic() {
        return this.waterfall.getResponseStatistic();
    }

    public void setResponseStatistic(int responseStatistic) {
        this.waterfall.setResponseStatistic(responseStatistic);
    }

    public int getColorResponseStatistic() {
        return this.waterfall.getColorResponseStatistic();
    }

    public void setColorResponseStatistic(int colorResponseStatistic) {
        this.waterfall.setColorResponseStatistic(colorResponseStatistic);
    }

    protected StringToColorMap getIndexedColorMap(short role, Color[] cl, HashMap cTable, boolean fillColors, double transparency) {
        short indexRole = 41;
        indexRole = role == 107 ? (short)41 : 41;
        StringVectorVariable colors = (StringVectorVariable)this.connectCategory((short)107, true);
        NumericVectorVariable indices = null;
        if (this.model.isAvailable(indexRole)) {
            indices = (NumericVectorVariable)this.connectRaw(indexRole);
        }
        Variable[] vars = null;
        vars = indices != null ? new Variable[]{colors, indices} : new Variable[]{colors};
        this.applyWhereClause(vars);
        StringToColorMap colorMap = new StringToColorMap();
        Color[] lc = new Color[colors.getUniqueValueCount()];
        for (int i = 0; i < colors.getUniqueValueCount(); ++i) {
            try {
                DiscreteAttrMapper attrMapper = null;
                if (role == 107 && this.hasAttrVar("COLORGROUP")) {
                    attrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("COLORGROUP");
                }
                if (attrMapper != null) {
                    String g = colors.formattedUniqueValue.getValue(i);
                    Color c = null;
                    if (fillColors) {
                        c = attrMapper.getFillColor(g);
                        if (!this.useFillTransparency) {
                            c = WaterfallChartOverlay.applyTransparency(c, attrMapper.getFillTransparency(g));
                        }
                    } else {
                        c = attrMapper.getLineColor(g);
                    }
                    lc[i] = c != null ? WaterfallChartOverlay.applyTransparency(c, transparency) : WaterfallChartOverlay.applyTransparency(cl[i % cl.length], transparency);
                } else if (indices != null) {
                    int obs = colors.getFirstOccurringValueIndex(i);
                    int idx = (int)indices.value.getValue(obs) - 1;
                    lc[i] = WaterfallChartOverlay.applyTransparency(cl[idx % cl.length], transparency);
                } else {
                    lc[i] = cTable != null ? WaterfallChartOverlay.applyTransparency((Color)cTable.get(colors.formattedUniqueValue.getValue(i)), transparency) : WaterfallChartOverlay.applyTransparency(cl[i % cl.length], transparency);
                }
                colorMap.add(colors.formattedUniqueValue.getValue(i), lc[i]);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return colorMap;
    }

    private DataRange computeRange(Variable var, boolean numericVar, short role, boolean union, DataRange oldRange, byte dim) {
        Object newRange = null;
        if (var != null) {
            int num;
            int n = num = numericVar ? var.getValueCount() : var.getUniqueValueCount();
            if (num > 0) {
                newRange = numericVar ? new ContinuousRange(((NumericVariable)var).getMin(), ((NumericVariable)var).getMax()) : Overlay.makeDiscreteRange((StringVariable)var, num);
                newRange.setLabel(var.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, role);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        return newRange;
    }

    @Override
    public String[] getUniqueValues(short role) {
        Object[] vals;
        if ((role == 6 || role == 46) && this.colorRange instanceof DiscreteRange && (vals = ((DiscreteRange)this.colorRange).getValues().toArray()) != null) {
            String[] str = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                str[i] = vals[i].toString();
            }
            return str;
        }
        return super.getUniqueValues(role);
    }

    @Override
    public void setDataTransparency(double b) {
        super.setDataTransparency(b);
        this.waterfall.setDataTransparency(b);
    }

    @Override
    public int getFillType() {
        return this.waterfall.getFillType();
    }

    @Override
    public void setFillType(int fillType) {
        this.waterfall.setFillType(fillType);
    }

    public boolean isConnectSkipMiss() {
        return this.waterfall.isConnectSkipMiss();
    }

    public void setConnectSkipMiss(boolean b) {
        this.waterfall.setConnectSkipMiss(b);
    }

    public Color getNeutralColor() {
        return this.waterfall.getNeutralColor();
    }

    public void setNeutralColor(Color neutralColor) {
        this.waterfall.setNeutralColor(neutralColor);
    }

    public SASFormat getBarLabelFormat() {
        return this.waterfall.getBarLabelFormat();
    }

    public void setBarLabelFormat(SASFormat barLabelFormat) {
        this.waterfall.setBarLabelFormat(barLabelFormat);
    }

    public void setFillColorOverride(boolean override) {
        this.waterfall.setFillColorOverride(override);
    }

    public void setOutlineColorOverride(boolean override) {
        this.waterfall.setOutlineColorOverride(override);
    }

    public String getInitialBarCategoryValue() {
        return this.initialBarCategoryValue;
    }

    public void setInitialBarCategoryValue(String initialBarCategoryValue) {
        this.initialBarCategoryValue = initialBarCategoryValue;
    }

    public LineAttrs getBaseLineAttrs() {
        return this.waterfall.getBaseLineAttrs();
    }

    public void setBaseLineAttrs(LineAttrs baseLineAttrs) {
        this.waterfall.setBaseLineAttrs(baseLineAttrs);
    }

    public void setSort(byte dimension, int sortOrder) {
        if (dimension == 1) {
            int newSortOrder = 0;
            switch (sortOrder) {
                case 1: 
                case 4: {
                    newSortOrder = 1;
                    break;
                }
                case 2: 
                case 6: {
                    newSortOrder = 2;
                    break;
                }
                default: {
                    newSortOrder = 0;
                }
            }
            if (this.categorySortOrder != newSortOrder) {
                this.categorySortOrder = newSortOrder;
                this.connectVars();
            }
        }
    }

    protected void connectOLAPVars() {
        CRD crd = this.model;
        if (crd.isAvailable(1)) {
            this.categoryVar = StatGraph.getOLAPLevelVar(crd, (short)1);
            crd.getSrcModel().xCategoryVar = this.categoryVar.getColumnName();
        }
        if (crd.isAvailable(2)) {
            this.responseVar = StatGraph.getOLAPMeasureVar(crd, (short)2);
        }
        short colorRole = 3;
        if (crd.isAvailable(108)) {
            this.colorVar = StatGraph.getOLAPMeasureVar(crd, (short)2);
            colorRole = 108;
            this.numericColor = true;
        } else if (crd.isAvailable(6)) {
            this.colorVar = StatGraph.getOLAPLevelVar(crd, (short)6);
            this.numericColor = false;
        } else {
            this.colorVar = null;
        }
        VariableProcessor vp = new VariableProcessor();
        this.categoryVar.setUniqueValueSort(0);
        int statistic = this.getResponseStatistic();
        vp.addGroupVariable(this.categoryVar);
        vp.addVariable(this.responseVar, statistic);
        if (this.colorVar != null) {
            if (this.numericColor) {
                vp.addVariable(this.colorVar, statistic);
            } else {
                vp.addVariable(this.colorVar, 12);
            }
        }
        this.addCRDWhereClause(vp);
        if (this.initialBarCategoryValue != null) {
            StringVariable cVar = (StringVariable)this.categoryVar;
            for (int i = 0; i < cVar.getUniqueValueCount(); ++i) {
                try {
                    String cval = cVar.uniqueValue.getValue(i);
                    String fval = cVar.getFormatter().format((Object)cval);
                    if (!this.initialBarCategoryValue.equals(fval)) continue;
                    int index = cVar.getFirstOccurringValueIndex(i);
                    double initValue = ((NumericVariable)this.responseVar).value.getValue(index);
                    this.waterfall.setInitialBarValue(initValue);
                    if (this.waterfall.isInitialTickmarkLabelOverriden()) break;
                    this.waterfall.setInitialBarTickmarkLabel(this.initialBarCategoryValue);
                    break;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            this.whereExpression = this.categoryVar.getColumnName() + " NE \"" + this.initialBarCategoryValue + "\"";
            String curWhere = vp.getWhereExpression();
            if (curWhere != null) {
                this.whereExpression = "(" + curWhere + ") & (" + this.whereExpression + ")";
            }
            vp.setWhereExpression(this.whereExpression);
        } else {
            this.whereExpression = null;
        }
        if (this.categorySortOrder != 0) {
            vp.setSort(this.categoryVar, this.categorySortOrder);
        }
        this.addCHPipe(RPFUtil.applyConditionalHiliting(this.model.getSrcModel(), vp, this.waterfall.getResponseStatistic()));
        if (this.categoryVar != null) {
            this.computeCategoryRange((StringVariable)this.categoryVar, null);
            this.waterfall.setCategoryVariable(this.categoryVar);
        }
        if (this.responseVar != null) {
            this.waterfall.setResponseVariable(this.responseVar);
        }
        this.setFormat(this.waterfall.getDataRange((byte)2), 2);
        if (this.colorVar != null) {
            this.waterfall.setColorVariable(this.colorVar);
        }
        this.colorRange = this.computeRange(this.colorVar, this.numericColor, colorRole, false, this.colorRange, (byte)4);
    }

    public static void addFinalCategoryToTree(DataTreeGroupNode tree, DefaultMutableTreeNode[] headerLeafs, BaseOverlayContainer oc) {
        DataTreeGroupNode leaf;
        int i;
        ArrayList hLeafs;
        Simple2DOverlayComposite soc = oc.getComposite();
        if (soc == null) {
            return;
        }
        ArrayList overlays = soc.getOverlays();
        WaterfallChartOverlay waterfall = null;
        for (int i2 = 0; i2 < overlays.size(); ++i2) {
            if (!(overlays.get(i2) instanceof WaterfallChartOverlay)) continue;
            waterfall = (WaterfallChartOverlay)overlays.get(i2);
            break;
        }
        if (waterfall == null || !waterfall.isShowFinalBar() && !waterfall.isShowInitialBar()) {
            return;
        }
        ArrayList arrayList = hLeafs = headerLeafs != null ? TrellisLayout.getMatchedLeafs((DataTreeGroupNode)tree, (DefaultMutableTreeNode[])headerLeafs) : null;
        if (waterfall.isShowFinalBar()) {
            if (hLeafs != null) {
                for (i = 0; i < hLeafs.size(); ++i) {
                    leaf = (DataTreeGroupNode)hLeafs.get(i);
                    DataTreeGroupNode finalEntry = new DataTreeGroupNode();
                    finalEntry.setFormattedValue(waterfall.getFinalBarTickmarkLabel());
                    finalEntry.setAllowsChildren(false);
                    finalEntry.setTupleElementSpan(leaf.getDepth());
                    finalEntry.setLevelIndex(Integer.MAX_VALUE);
                    leaf.add((MutableTreeNode)finalEntry);
                }
            } else {
                DataTreeGroupNode finalEntry = new DataTreeGroupNode();
                finalEntry.setFormattedValue(waterfall.getFinalBarTickmarkLabel());
                finalEntry.setAllowsChildren(false);
                finalEntry.setTupleElementSpan(tree.getDepth());
                tree.add((MutableTreeNode)finalEntry);
            }
        }
        if (waterfall.isShowInitialBar()) {
            if (hLeafs != null) {
                for (i = 0; i < hLeafs.size(); ++i) {
                    leaf = (DataTreeGroupNode)hLeafs.get(i);
                    DataTreeGroupNode initialEntry = new DataTreeGroupNode();
                    initialEntry.setFormattedValue(waterfall.getInitialBarTickmarkLabel());
                    initialEntry.setAllowsChildren(false);
                    initialEntry.setTupleElementSpan(leaf.getDepth());
                    initialEntry.setLevelIndex(Integer.MAX_VALUE);
                    leaf.insert((MutableTreeNode)initialEntry, 0);
                }
            } else {
                DataTreeGroupNode initialEntry = new DataTreeGroupNode();
                initialEntry.setFormattedValue(waterfall.getInitialBarTickmarkLabel());
                initialEntry.setAllowsChildren(false);
                initialEntry.setTupleElementSpan(tree.getDepth());
                tree.insert((MutableTreeNode)initialEntry, 0);
            }
        }
    }

    public boolean isColorByResponseSign() {
        return this.waterfall.isColorByResponseSign();
    }

    public void setColorByResponseSign(boolean colorByResponseSign) {
        this.waterfall.setColorByResponseSign(colorByResponseSign);
    }

    public FillAttrs getBarIncreasingFillAttrs() {
        return this.waterfall.getBarIncreasingFillAttrs();
    }

    public FillAttrs getBarDecreasingFillAttrs() {
        return this.waterfall.getBarDecreasingFillAttrs();
    }

    public void setBarIncreasingLegendLabel(String barIncreasingLabel) {
        this.waterfall.setBarIncreasingLegendLabel(barIncreasingLabel);
    }

    public void setBarDecreasingLegendLabel(String barDecreasingLabel) {
        this.waterfall.setBarDecreasingLegendLabel(barDecreasingLabel);
    }

    public boolean isAutoRotateLabel() {
        return this.waterfall.isAutoRotateLabel();
    }

    public void setAutoRotateLabel(boolean rotate) {
        this.waterfall.setAutoRotateLabel(rotate);
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return !this.model.isAvailable(107) && !this.isColorByResponseSign();
    }

    @Override
    public String getDefaultLegendTitle() {
        ColumnMetadata cmd = null;
        if (this.model.isAvailable(107)) {
            cmd = (ColumnMetadata)this.model.getColumnLabel(107);
        } else if (this.isColorByResponseSign()) {
            cmd = (ColumnMetadata)this.model.getColumnLabel(2);
        }
        if (cmd != null) {
            return cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
        }
        return null;
    }

    @Override
    protected int getNumberOfDrawingElements() {
        return this.categoryVar.getUniqueValueCount();
    }

    @Override
    public int getRendererComplexity() {
        return this.getNumberOfDrawingElements();
    }

    @Override
    public int getNumOfTooltips() {
        return this.getNumberOfDrawingElements();
    }
}

