/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import java.awt.Color;

public abstract class SpecLimitsOverlay
extends Overlay {
    protected double lowerSpecLimit = Double.NaN;
    protected double upperSpecLimit = Double.NaN;
    protected NumericVariable lowerSpecLimitVar = null;
    protected NumericVariable upperSpecLimitVar = null;
    protected FillAttrs lowerFillStyle = new FillAttrs();
    protected FillAttrs upperFillStyle = new FillAttrs();
    protected String lowerLegendLabel = null;
    protected String upperLegendLabel = null;

    public double getLowerSpecLimit() {
        return this.lowerSpecLimit;
    }

    public void setLowerSpecLimit(double lowerSpecLimit) {
        this.lowerSpecLimit = lowerSpecLimit;
    }

    public double getUpperSpecLimit() {
        return this.upperSpecLimit;
    }

    public void setUpperSpecLimit(double upperSpecLimit) {
        this.upperSpecLimit = upperSpecLimit;
    }

    public void setLowerFillStyle(FillAttrs fs) {
        this.lowerFillStyle = fs;
    }

    public FillAttrs getLowerFillStyle() {
        return this.lowerFillStyle;
    }

    public void setUpperFillStyle(FillAttrs fs) {
        this.upperFillStyle = fs;
    }

    public FillAttrs getUpperFillStyle() {
        return this.upperFillStyle;
    }

    public String getLowerLegendLabel() {
        return this.lowerLegendLabel;
    }

    public void setLowerLegendLabel(String lowerLegendLabel) {
        this.lowerLegendLabel = lowerLegendLabel;
    }

    public String getUpperLegendLabel() {
        return this.upperLegendLabel;
    }

    public void setUpperLegendLabel(String upperLegendLabel) {
        this.upperLegendLabel = upperLegendLabel;
    }

    public boolean hasLowerSpecLimit() {
        return !Double.isNaN(this.findLowerSpecLimit());
    }

    public double findLowerSpecLimit() {
        if (!Double.isNaN(this.lowerSpecLimit)) {
            return this.lowerSpecLimit;
        }
        if (this.lowerSpecLimitVar == null || this.lowerSpecLimitVar.getValueCount() == 0) {
            return Double.NaN;
        }
        try {
            return this.lowerSpecLimitVar.value.getValue(0);
        }
        catch (MissingValueException e) {
            return Double.NaN;
        }
    }

    public boolean hasUpperSpecLimit() {
        return !Double.isNaN(this.findUpperSpecLimit());
    }

    public double findUpperSpecLimit() {
        if (!Double.isNaN(this.upperSpecLimit)) {
            return this.upperSpecLimit;
        }
        if (this.upperSpecLimitVar == null || this.upperSpecLimitVar.getValueCount() == 0) {
            return Double.NaN;
        }
        try {
            return this.upperSpecLimitVar.value.getValue(0);
        }
        catch (MissingValueException e) {
            return Double.NaN;
        }
    }

    public boolean hasSpecLimits() {
        return this.hasLowerSpecLimit() || this.hasUpperSpecLimit();
    }

    public String[] getLegendLabels() {
        String s1 = this.getLegendLabel();
        String s2 = this.getLowerLegendLabel();
        String s3 = this.getUpperLegendLabel();
        String[] values = s1 != null ? (s2 != null ? (s3 != null ? new String[]{s1, s2, s3} : new String[]{s1, s2}) : (s3 != null ? new String[]{s1, s3} : new String[]{s1})) : (s2 != null ? (s3 != null ? new String[]{s2, s3} : new String[]{s2}) : (s3 != null ? new String[]{s3} : new String[]{null}));
        return values;
    }

    public Color[] getFillColors(FillAttrs fillStyle) {
        Color[] colors;
        Color fillColor = fillStyle == null ? null : this.applyDataTransparency((ColorAttr)fillStyle);
        String s1 = this.getLegendLabel();
        String s2 = this.getLowerLegendLabel();
        String s3 = this.getUpperLegendLabel();
        if (s1 != null) {
            if (s2 != null) {
                colors = s3 != null ? new Color[]{fillColor, this.applyDataTransparency((ColorAttr)this.lowerFillStyle), this.applyDataTransparency((ColorAttr)this.upperFillStyle)} : new Color[]{fillColor, this.applyDataTransparency((ColorAttr)this.lowerFillStyle)};
            } else if (s3 != null) {
                colors = new Color[]{fillColor, this.applyDataTransparency((ColorAttr)this.upperFillStyle)};
            } else {
                Color[] colorArray;
                if (fillColor != null) {
                    Color[] colorArray2 = new Color[1];
                    colorArray = colorArray2;
                    colorArray2[0] = fillColor;
                } else {
                    colorArray = new Color[]{};
                }
                colors = colorArray;
            }
        } else {
            colors = s2 != null ? (s3 != null ? new Color[]{this.applyDataTransparency((ColorAttr)this.lowerFillStyle), this.applyDataTransparency((ColorAttr)this.upperFillStyle)} : new Color[]{this.applyDataTransparency((ColorAttr)this.lowerFillStyle)}) : (s3 != null ? new Color[]{this.applyDataTransparency((ColorAttr)this.upperFillStyle)} : new Color[]{});
        }
        return colors;
    }
}

