/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.attrmap.AttributeMapRange;
import com.sas.graphics.util.attrmap.RangeAttributeMap;
import com.sas.graphics.util.attrmap.RangeColorMapper;
import com.sas.graphics.util.attrmap.RangeColorMapperFactory;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ARangeAttrMap;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RangeAttrMap;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;

public class RangeAttrMapViewOverlay
extends Overlay {
    public static final String RB_KEY = "ReferenceLineOverlay.";
    private final int eMin = 0;
    private final int eMax = 1;
    protected Style style;
    protected RangeAttributeMap xRangeMap = null;
    protected RangeAttributeMap yRangeMap = null;
    protected RangeColorMapper xRangeColorMapper = null;
    protected RangeColorMapper yRangeColorMapper = null;
    private Vector<AttributeMapRange> sortedXRanges;
    private Vector<AttributeMapRange> sortedYRanges;
    private boolean fillOn = true;
    private boolean lineOn = false;
    private double baseline = 0.0;
    private LineAttrs lineStyle = new LineAttrs();
    private FillAttrs fillStyle = new FillAttrs();
    private byte primaryRangeMap = 1;
    private boolean allowClipping = false;
    private boolean extend = true;
    private NetworkRoot networkRoot;
    private DataRange xRange = null;
    private DataRange yRange = null;
    private Encoder xEncoder;
    private Encoder yEncoder;
    private boolean useFillColor = false;
    private boolean useLineColor = false;

    public void setXRangeAttributeMap(RangeAttributeMap m) {
        this.xRangeMap = m;
        this.sortedXRanges = this.orderRanges(this.xRangeMap.getRanges());
        this.updateXRange();
    }

    public RangeAttributeMap getXRangeAttributeMap() {
        return this.xRangeMap;
    }

    public void setYRangeAttributeMap(RangeAttributeMap m) {
        this.yRangeMap = m;
        this.sortedYRanges = this.orderRanges(this.yRangeMap.getRanges());
        this.updateYRange();
    }

    public RangeAttributeMap getYRangeAttributeMap() {
        return this.yRangeMap;
    }

    public void setPrimaryRangeAttributeMap(byte dim) {
        this.primaryRangeMap = dim;
    }

    public byte getPrimaryRangeAttributeMap() {
        return this.primaryRangeMap;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public void setFillOn(boolean on) {
        this.fillOn = on;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setLineOn(boolean on) {
        this.lineOn = on;
    }

    public boolean isLineOn() {
        return this.lineOn;
    }

    public void setLineStyle(LineAttrs s) {
        this.lineStyle = s;
    }

    public LineAttrs getLineStyle() {
        return this.lineStyle;
    }

    public void setFillStyle(FillAttrs s) {
        this.fillStyle = s;
    }

    public FillAttrs getFillStyle() {
        return this.fillStyle;
    }

    public boolean isClipping() {
        return this.allowClipping;
    }

    public void setClipping(boolean b) {
        this.allowClipping = b;
    }

    public void setExtend(boolean b) {
        this.extend = b;
    }

    public boolean isExtend() {
        return this.extend;
    }

    public void setUseFillColor(boolean b) {
        this.useFillColor = b;
    }

    public void setUseLineColor(boolean b) {
        this.useLineColor = b;
    }

    public NetworkRoot getNetworkRoot() {
        return this.networkRoot;
    }

    private Vector<AttributeMapRange> orderRanges(Vector<AttributeMapRange> ranges) {
        int numRanges = ranges.size();
        for (int i = 0; i < numRanges - 1; ++i) {
            for (int j = i + 1; j < numRanges; ++j) {
                AttributeMapRange r1 = ranges.get(i);
                AttributeMapRange r2 = ranges.get(j);
                if (!(r1.getMin().getValue() > r2.getMin().getValue())) continue;
                ranges.remove(j);
                ranges.remove(i);
                ranges.insertElementAt(r2, i);
                ranges.insertElementAt(r1, j);
            }
        }
        return ranges;
    }

    protected void updateXRange() {
        this.updateRange((byte)1, this.xRangeMap, this.xRange, this.sortedXRanges);
    }

    protected void updateYRange() {
        this.updateRange((byte)2, this.yRangeMap, this.yRange, this.sortedYRanges);
    }

    private void updateRange(byte dimension, RangeAttributeMap rangeMap, DataRange curDataRange, Vector<AttributeMapRange> sortedRanges) {
        if (rangeMap == null || this.allowClipping) {
            return;
        }
        double min = sortedRanges.firstElement().getMin().getValue();
        double max = sortedRanges.lastElement().getMax().getValue();
        if (Double.isNaN(min) || Double.isNaN(max)) {
            return;
        }
        ContinuousRange newRange = null;
        if (min != Double.MAX_VALUE && min != -1.7976931348623157E308 && (newRange = new ContinuousRange(min, max)).equals((Object)curDataRange)) {
            newRange = curDataRange;
        }
        this.setDataRange((DataRange)newRange, dimension);
        this.fireRangeEvent(dimension, curDataRange, (DataRange)newRange);
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (this.allowClipping) {
            return null;
        }
        return dimension == 1 ? this.xRange : (dimension == 2 ? this.yRange : null);
    }

    private void setDataRange(DataRange dRange, byte dimension) {
        if (dimension == 1) {
            this.xRange = dRange;
        } else if (dimension == 2) {
            this.yRange = dRange;
        }
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        return dimension == 1 ? this.xEncoder : (dimension == 2 ? this.yEncoder : null);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (encoder != null && !(encoder instanceof PositionEncoder)) {
            return;
        }
        if (dimension == 1) {
            if (encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = encoder;
        }
        if (dimension == 2) {
            if (encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = encoder;
        }
        this.needConnect = true;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    @Override
    protected boolean connectNetwork() {
        NumericVector lineHighs;
        NumericVector lineLows;
        double[] tmpYExtents;
        if (this.xRangeMap == null && this.yRangeMap == null) {
            return false;
        }
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        ARangeAttrMap.Direction direction = this.xRangeMap != null && this.yRangeMap != null ? ARangeAttrMap.Direction.BOTH : (this.yRangeMap == null ? ARangeAttrMap.Direction.VERTICAL : ARangeAttrMap.Direction.HORIZONTAL);
        ValueMap xmap = this.xEncoder.getValueMap();
        ValueMap ymap = this.yEncoder.getValueMap();
        if (this.xRangeMap != null && !(xmap instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        if (this.yRangeMap != null && !(ymap instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        double[] xExtents = new double[]{Double.NaN, Double.NaN};
        double[] xMappedExtents = new double[]{Double.NaN, Double.NaN};
        double[] xExtendedExtents = new double[]{Double.NaN, Double.NaN};
        this.getExtents(this.xRangeMap, this.xEncoder, xExtents, xExtendedExtents, xMappedExtents);
        double[] yExtents = new double[]{Double.NaN, Double.NaN};
        double[] yExtendedExtents = new double[]{Double.NaN, Double.NaN};
        double[] yMappedExtents = new double[]{Double.NaN, Double.NaN};
        this.getExtents(this.yRangeMap, this.yEncoder, yExtents, yExtendedExtents, yMappedExtents);
        if (this.yRangeMap != null && this.yRangeColorMapper == null) {
            this.yRangeColorMapper = RangeColorMapperFactory.getInstance((RangeAttributeMap)this.yRangeMap, (double)yExtents[0], (double)yExtents[1], (Style)this.style, (!this.fillOn ? 1 : 0) != 0, null);
            if (this.yRangeColorMapper == null) {
                return false;
            }
        }
        if (this.xRangeMap != null && this.xRangeColorMapper == null) {
            this.xRangeColorMapper = RangeColorMapperFactory.getInstance((RangeAttributeMap)this.xRangeMap, (double)xExtents[0], (double)xExtents[1], (Style)this.style, (!this.fillOn ? 1 : 0) != 0, null);
            if (this.xRangeColorMapper == null) {
                return false;
            }
        }
        int nRanges = direction == ARangeAttrMap.Direction.BOTH ? Math.min(this.sortedXRanges.size(), this.sortedYRanges.size()) : (direction == ARangeAttrMap.Direction.VERTICAL ? this.sortedXRanges.size() : this.sortedYRanges.size());
        NumericVector xFillL = null;
        NumericVector xFillU = null;
        if (this.xRangeMap != null) {
            xFillL = new NumericVector();
            xFillU = new NumericVector();
            this.initLowerUpperVectors(xExtents, xExtendedExtents, this.sortedXRanges, nRanges, xFillL, xFillU);
        }
        NumericVector yFillL = null;
        NumericVector yFillU = null;
        if (this.yRangeMap != null) {
            yFillL = new NumericVector();
            yFillU = new NumericVector();
            this.initLowerUpperVectors(yExtents, yExtendedExtents, this.sortedYRanges, nRanges, yFillL, yFillU);
        }
        Vector<AttributeMapRange> sortedRanges = null;
        RangeColorMapper rangeColorMapper = null;
        if (direction == ARangeAttrMap.Direction.VERTICAL || direction == ARangeAttrMap.Direction.BOTH && this.primaryRangeMap == 1) {
            sortedRanges = this.sortedXRanges;
            rangeColorMapper = this.xRangeColorMapper;
        } else {
            sortedRanges = this.sortedYRanges;
            rangeColorMapper = this.yRangeColorMapper;
        }
        if (direction == ARangeAttrMap.Direction.BOTH) {
            this.baseline = sortedRanges.firstElement().getMin().getValue();
        }
        Color[] rangeColors = new Color[nRanges];
        for (int i = 0; i < nRanges; ++i) {
            double rMin = sortedRanges.get(i).getMin().getValue();
            double rMax = sortedRanges.get(i).getMax().getValue();
            double rMidPoint = rMin + 0.5 * (rMax - rMin);
            rangeColors[i] = rangeColorMapper.getMappedColor(rMidPoint);
        }
        ColorProperty rvFillColor = new ColorProperty();
        if (this.useFillColor) {
            rvFillColor.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
        } else {
            ColorVector vec = new ColorVector();
            double fillStyleTransp = this.getAttrTransparency((ColorAttr)this.fillStyle);
            for (Color rColor : rangeColors) {
                vec.addValue(this.applyDataTransparency(rColor, fillStyleTransp));
            }
            rvFillColor.connectFrom((ColorPipe)vec);
        }
        ColorProperty rvLineColor = new ColorProperty();
        if (this.useLineColor || this.fillOn && !this.useFillColor) {
            rvLineColor.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
        } else {
            ColorVector vec = new ColorVector();
            for (Color rColor : rangeColors) {
                vec.addValue(this.applyDataTransparency(rColor));
            }
            rvLineColor.connectFrom((ColorPipe)vec);
        }
        rangeColors = null;
        ColorProperty rngColorProp = this.fillOn ? rvFillColor : rvLineColor;
        double styleTransp = this.fillOn ? this.getAttrTransparency((ColorAttr)this.fillStyle) : -1.0;
        double[] tmpXExtents = this.extend ? xExtendedExtents : xExtents;
        double[] dArray = tmpYExtents = this.extend ? yExtendedExtents : yExtents;
        if (this.xRangeMap != null && this.yRangeMap != null) {
            this.addBandsForGapsXY(xFillL, xFillU, yFillL, yFillU, rngColorProp, tmpXExtents, tmpYExtents, styleTransp);
        } else if (this.yRangeMap != null) {
            this.addBandsForGaps(yFillL, yFillU, this.yRangeColorMapper, rngColorProp, tmpYExtents, styleTransp);
        } else {
            this.addBandsForGaps(xFillL, xFillU, this.xRangeColorMapper, rngColorProp, tmpXExtents, styleTransp);
        }
        BooleanVector lineLowFlag = new BooleanVector();
        BooleanVector lineUppFlag = new BooleanVector();
        if (direction == ARangeAttrMap.Direction.VERTICAL || direction == ARangeAttrMap.Direction.BOTH && this.primaryRangeMap == 1) {
            lineLows = xFillL;
            lineHighs = xFillU;
        } else {
            lineLows = yFillL;
            lineHighs = yFillU;
        }
        this.setLineDrawFlags(lineLows, lineHighs, lineLowFlag, lineUppFlag);
        this.networkRoot.removeAllElements();
        if (this.fillOn) {
            RangeAttrMap gtkFillRMView = new RangeAttrMap();
            this.setupGTKRender(gtkFillRMView, xmap, ymap, xMappedExtents, yMappedExtents, xFillL, xFillU, yFillL, yFillU);
            gtkFillRMView.setUserData((Object)this.probe);
            gtkFillRMView.color.connectFrom((ColorPipe)rvFillColor);
            gtkFillRMView.fillOn.setValue(this.fillOn);
            gtkFillRMView.lineLowerOn.setValue(false);
            gtkFillRMView.lineUpperOn.setValue(false);
        }
        if (this.lineOn) {
            RangeAttrMap gtkLineRMView = new RangeAttrMap();
            this.setupGTKRender(gtkLineRMView, xmap, ymap, xMappedExtents, yMappedExtents, xFillL, xFillU, yFillL, yFillU);
            if (!this.fillOn) {
                gtkLineRMView.setUserData((Object)this.probe);
            }
            gtkLineRMView.color.connectFrom((ColorPipe)rvLineColor);
            gtkLineRMView.lineColor.connectFrom((ColorPipe)rvLineColor);
            gtkLineRMView.lineWidth.setValue(this.lineStyle.getWidth());
            gtkLineRMView.linePattern.setValue(this.lineStyle.getLinePattern());
            gtkLineRMView.fillOn.setValue(false);
            gtkLineRMView.lineLowerOn.connectFrom((BooleanPipe)lineLowFlag);
            gtkLineRMView.lineUpperOn.connectFrom((BooleanPipe)lineUppFlag);
        }
        this.needConnect = false;
        return true;
    }

    private void addBandsForGapsXY(NumericVector xLows, NumericVector xHighs, NumericVector yLows, NumericVector yHighs, ColorProperty rangeColors, double[] tmpXExtents, double[] tmpYExtents, double styleTransp) {
        ColorVector rngColorVec = rangeColors.isConnected() ? (ColorVector)rangeColors.getConnection() : null;
        int n = xLows.size();
        for (int i = 0; i <= n; ++i) {
            boolean xGap = false;
            boolean yGap = false;
            try {
                RangeColorMapper rcMapper;
                double cVal;
                double prevXUp = i == 0 ? tmpXExtents[0] : xHighs.getValue(i - 1);
                double curXLow = i == n ? tmpXExtents[1] : xLows.getValue(i);
                double prevYUp = i == 0 ? tmpYExtents[0] : yHighs.getValue(i - 1);
                double curYLow = i == n ? tmpYExtents[1] : yLows.getValue(i);
                xGap = prevXUp < curXLow;
                boolean bl = yGap = prevYUp < curYLow;
                if (!xGap && !yGap) continue;
                xLows.addValue(prevXUp);
                xHighs.addValue(curXLow);
                yLows.addValue(prevYUp);
                yHighs.addValue(curYLow);
                if (rngColorVec == null) continue;
                if (xGap && (!yGap || yGap && this.primaryRangeMap == 1)) {
                    cVal = i == 0 ? Double.NEGATIVE_INFINITY : (i == n ? Double.POSITIVE_INFINITY : (prevXUp + curXLow) * 0.5);
                    rcMapper = this.xRangeColorMapper;
                } else {
                    cVal = i == 0 ? Double.NEGATIVE_INFINITY : (i == n ? Double.POSITIVE_INFINITY : (prevYUp + curYLow) * 0.5);
                    rcMapper = this.yRangeColorMapper;
                }
                Color tColor = this.applyDataTransparency(rcMapper.getMappedColor(cVal), styleTransp);
                rngColorVec.addValue(tColor);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    private void addBandsForGaps(NumericVector lows, NumericVector highs, RangeColorMapper rngColorMapper, ColorProperty rangeColors, double[] extents, double styleTransp) {
        ColorVector rngColorVec = rangeColors.isConnected() ? (ColorVector)rangeColors.getConnection() : null;
        int n = lows.size();
        for (int i = 0; i <= n; ++i) {
            try {
                double curLower;
                double prevUpper = i == 0 ? extents[0] : highs.getValue(i - 1);
                double d = curLower = i == n ? extents[1] : lows.getValue(i);
                if (prevUpper >= curLower) continue;
                lows.addValue(prevUpper);
                highs.addValue(curLower);
                if (rngColorVec == null) continue;
                double colVal = i == 0 ? Double.NEGATIVE_INFINITY : (i == n ? Double.POSITIVE_INFINITY : (prevUpper + curLower) * 0.5);
                Color tColor = this.applyDataTransparency(rngColorMapper.getMappedColor(colVal), styleTransp);
                rngColorVec.addValue(tColor);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    private void setupGTKRender(RangeAttrMap gtkRMView, ValueMap xmap, ValueMap ymap, double[] xMappedExtents, double[] yMappedExtents, NumericVector xLow, NumericVector xUpp, NumericVector yLow, NumericVector yUpp) {
        ContinuousRangeToNumericMapper xlMapper = null;
        ContinuousRangeToNumericMapper xuMapper = null;
        ContinuousRangeToNumericMapper ylMapper = null;
        ContinuousRangeToNumericMapper yuMapper = null;
        if (this.xRangeMap != null) {
            xlMapper = new ContinuousRangeToNumericMapper();
            xuMapper = new ContinuousRangeToNumericMapper();
            xlMapper.setMap((ContinuousRangeToNumericMap)xmap);
            xlMapper.input.connectFrom((NumericPipe)xLow);
            xuMapper.setMap((ContinuousRangeToNumericMap)xmap);
            xuMapper.input.connectFrom((NumericPipe)xUpp);
        }
        if (this.yRangeMap != null) {
            ylMapper = new ContinuousRangeToNumericMapper();
            yuMapper = new ContinuousRangeToNumericMapper();
            ylMapper.setMap((ContinuousRangeToNumericMap)ymap);
            ylMapper.input.connectFrom((NumericPipe)yLow);
            yuMapper.setMap((ContinuousRangeToNumericMap)ymap);
            yuMapper.input.connectFrom((NumericPipe)yUpp);
        }
        this.networkRoot.addElement((Element)gtkRMView);
        if (this.xRangeMap != null && this.yRangeMap != null) {
            gtkRMView.setDirection(ARangeAttrMap.Direction.BOTH);
            if (this.yAxis.equalsIgnoreCase("Y")) {
                gtkRMView.horizontalLowerX.setValue(xMappedExtents[0]);
                gtkRMView.horizontalUpperX.setValue(xMappedExtents[0]);
            } else {
                gtkRMView.horizontalLowerX.setValue(xMappedExtents[1]);
                gtkRMView.horizontalUpperX.setValue(xMappedExtents[1]);
            }
            gtkRMView.horizontalLowerY.connectFrom((NumericPipe)ylMapper);
            gtkRMView.horizontalUpperY.connectFrom((NumericPipe)yuMapper);
            gtkRMView.verticalLowerX.connectFrom((NumericPipe)xlMapper);
            gtkRMView.verticalUpperX.connectFrom((NumericPipe)xuMapper);
            if (this.xAxis.equalsIgnoreCase("X")) {
                gtkRMView.verticalLowerY.setValue(yMappedExtents[0]);
                gtkRMView.verticalUpperY.setValue(yMappedExtents[0]);
            } else {
                gtkRMView.verticalLowerY.setValue(yMappedExtents[1]);
                gtkRMView.verticalUpperY.setValue(yMappedExtents[1]);
            }
        } else if (this.yRangeMap != null) {
            gtkRMView.setDirection(ARangeAttrMap.Direction.HORIZONTAL);
            gtkRMView.horizontalLowerX.setValue(xMappedExtents[0]);
            gtkRMView.horizontalLowerY.connectFrom((NumericPipe)ylMapper);
            gtkRMView.horizontalUpperX.setValue(xMappedExtents[0]);
            gtkRMView.horizontalUpperY.connectFrom((NumericPipe)yuMapper);
            gtkRMView.depth.setValue(xMappedExtents[1] - xMappedExtents[0]);
        } else {
            gtkRMView.setDirection(ARangeAttrMap.Direction.VERTICAL);
            gtkRMView.verticalLowerX.connectFrom((NumericPipe)xlMapper);
            gtkRMView.verticalLowerY.setValue(yMappedExtents[0]);
            gtkRMView.verticalUpperX.connectFrom((NumericPipe)xuMapper);
            gtkRMView.verticalUpperY.setValue(yMappedExtents[0]);
            gtkRMView.depth.setValue(yMappedExtents[1] - yMappedExtents[0]);
        }
    }

    private void initLowerUpperVectors(double[] extents, double[] extendedExtents, Vector<AttributeMapRange> sortedRanges, int nRanges, NumericVector bandLow, NumericVector bandUpp) {
        for (int i = 0; i < nRanges; ++i) {
            boolean inclusive;
            AttributeMapRange range = sortedRanges.get(i);
            double rMin = range.getMin().getValue();
            double rMax = range.getMax().getValue();
            double bandMin = Double.NaN;
            double bandMax = Double.NaN;
            if (Double.isNaN(rMin)) {
                rMin = extents[0];
            }
            if (Double.isNaN(rMax)) {
                rMax = extents[1];
            }
            bandMin = rMin;
            if (this.extend) {
                boolean bl = inclusive = this.containsExclusive(rMin, rMax, extents[0]) || rMin == extents[0] && range.getMin().isInclusive();
                if (inclusive && rMin > extendedExtents[0]) {
                    bandMin = extendedExtents[0];
                }
            }
            bandMax = rMax;
            if (this.extend) {
                boolean bl = inclusive = this.containsExclusive(rMin, rMax, extents[1]) || rMax == extents[1] && range.getMax().isInclusive();
                if (inclusive && rMax < extendedExtents[1]) {
                    bandMax = extendedExtents[1];
                }
            }
            bandLow.addValue(bandMin);
            bandUpp.addValue(bandMax);
        }
    }

    private final boolean containsExclusive(double min, double max, double value) {
        return min < value && max > value;
    }

    private void setLineDrawFlags(NumericVector lows, NumericVector highs, BooleanVector drawLow, BooleanVector drawHigh) {
        try {
            for (int idx = 0; idx < lows.size(); ++idx) {
                boolean lowFlag = false;
                boolean upFlag = false;
                double rangeLow = lows.getValue(idx);
                double rangeHigh = highs.getValue(idx);
                if (rangeLow < this.baseline && this.baseline < rangeHigh) {
                    upFlag = false;
                    lowFlag = false;
                } else if (rangeHigh < this.baseline) {
                    upFlag = true;
                } else if (this.baseline < rangeLow) {
                    lowFlag = true;
                }
                drawLow.addValue(lowFlag);
                drawHigh.addValue(upFlag);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    private void getExtents(RangeAttributeMap attrMap, Encoder encoder, double[] extents, double[] extendedExtents, double[] mappedExtents) {
        ValueMap valMap = encoder.getValueMap();
        PositionEncoder posEncoder = (PositionEncoder)encoder;
        ContinuousRangeToNumericMap crToNumMap = null;
        if (valMap instanceof ContinuousRangeToNumericMap) {
            crToNumMap = (ContinuousRangeToNumericMap)valMap;
        }
        if (attrMap != null) {
            extents[0] = crToNumMap.getInputMin();
            extents[1] = crToNumMap.getInputMax();
            if (posEncoder.isReversed()) {
                this.swapMinMax(extents);
            }
            if (this.extend) {
                extendedExtents[0] = crToNumMap.getInverseValue(posEncoder.getLowerLimit());
                extendedExtents[1] = crToNumMap.getInverseValue(posEncoder.getUpperLimit());
                if (posEncoder.isReversed()) {
                    this.swapMinMax(extendedExtents);
                }
            }
        }
        if (this.extend) {
            mappedExtents[0] = posEncoder.getLowerLimit();
            mappedExtents[1] = posEncoder.getUpperLimit();
        } else if (crToNumMap != null) {
            mappedExtents[0] = crToNumMap.getOutputMin();
            mappedExtents[1] = crToNumMap.getOutputMax();
        } else {
            DataRange dr = posEncoder.getInput();
            if (((DiscreteRange)dr).getValuesSize() > 0) {
                mappedExtents[0] = ((StringToNumericMap)valMap).getOutputMin();
                mappedExtents[1] = ((StringToNumericMap)valMap).getOutputMax();
            } else {
                mappedExtents[0] = posEncoder.getLowerLimit();
                mappedExtents[1] = posEncoder.getUpperLimit();
            }
        }
    }

    public void swapMinMax(double[] extents) {
        double tmpDbl = extents[0];
        extents[0] = extents[1];
        extents[1] = tmpDbl;
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        if (dimension == 1 ? this.xRangeMap != null : this.yRangeMap != null) {
            return 2 * this.lineStyle.getWidth();
        }
        return 0.0;
    }

    @Override
    public int[] getLineWidths() {
        int[] lw = new int[]{this.lineStyle.getWidth()};
        return lw;
    }

    @Override
    public Color[] getLineColors() {
        Color[] lc = new Color[]{this.applyDataTransparency((ColorAttr)this.lineStyle)};
        return lc;
    }

    @Override
    public int[] getLinePatterns() {
        int[] lp = new int[]{this.lineStyle.getLinePattern()};
        return lp;
    }

    @Override
    public String[] getGroupValues() {
        String[] gv = new String[]{this.legendLabel};
        return gv;
    }
}

