/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RB;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.GTKPie;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.HashMap;

public class PieOverlay
extends Overlay {
    protected DataRange categoryRange;
    protected DataRange responseRange;
    protected Encoder categoryEncoder;
    protected Encoder colorEncoder;
    protected Encoder lineColorEncoder;
    protected Encoder responseEncoder;
    private NetworkRoot networkRoot;
    private Variable categoryVar;
    private NumericVectorVariable responseVar;
    protected boolean fillOn = true;
    protected Color fillColor = null;
    protected boolean edgeOn = true;
    protected boolean useEdgeColor;
    protected LineAttrs edgeStyle = new LineAttrs();
    protected TextStyle labelStyle = new TextStyle();
    protected byte labelPosition = 0;
    protected String labelContent = "CATEGORY_PERCENT";
    protected double start = 0.0;
    protected String order = "DATA";
    protected String direction = "COUNTERCLOCKWISE";
    protected double otherThreshold = 0.0;
    protected Color otherColor = Color.black;
    protected String otherLabel = "Other";

    @Override
    public double getPreferredOffset(byte dimension) {
        return 0.0;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(TextStyle aLabelStyle) {
        this.labelStyle = aLabelStyle;
    }

    public String getLabelContent() {
        return this.labelContent;
    }

    public void setLabelContent(String content) {
        this.labelContent = content;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean b) {
        this.fillOn = b;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color aFillColor) {
        this.fillColor = aFillColor;
    }

    public boolean isEdgeOn() {
        return this.edgeOn;
    }

    public void setEdgeOn(boolean b) {
        this.edgeOn = b;
    }

    public boolean isUseEdgeColor() {
        return this.useEdgeColor;
    }

    public void setUseEdgeColor(boolean b) {
        this.useEdgeColor = b;
    }

    public Color getEdgeColor() {
        return this.edgeStyle.getColor();
    }

    public void setEdgeColor(Color c) {
        this.edgeStyle.setColor(c);
    }

    public LineAttrs getEdgeStyle() {
        return this.edgeStyle;
    }

    public void setEdgeStyle(LineAttrs s) {
        this.edgeStyle = s;
    }

    public int getEdgeThickness() {
        return this.edgeStyle.getWidth();
    }

    public void setEdgeThickness(int t) {
        this.edgeStyle.setWidth(t);
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double s) {
        this.start = s;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String o) {
        this.order = o;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String d) {
        this.direction = d;
    }

    public double getOtherThreshold() {
        return this.otherThreshold;
    }

    public void setOtherThreshold(double t) {
        this.otherThreshold = t;
    }

    public Color getOtherColor() {
        return this.otherColor;
    }

    public void setOtherColor(Color c) {
        this.otherColor = c;
    }

    public String getOtherLabel() {
        return this.otherLabel;
    }

    public void setOtherLabel(String s) {
        this.otherLabel = s;
    }

    protected DataRange getIndRange() {
        DiscreteRange range = null;
        if (this.categoryVar != null) {
            int num = this.categoryVar.getUniqueValueCount();
            if (num > 0) {
                Object[] vals = new Object[num];
                for (int i = 0; i < num; ++i) {
                    try {
                        vals[i] = ((StringVectorVariable)this.categoryVar).uniqueValue.getValue(i);
                        continue;
                    }
                    catch (Exception mve) {
                        vals[i] = "";
                    }
                }
                range = new DiscreteRange(vals);
                range.setLabel(this.categoryVar.getLabel());
            } else {
                range = null;
            }
        }
        return range;
    }

    protected DataRange getDepRange() {
        ContinuousRange range = null;
        if (this.responseVar != null) {
            int num = this.responseVar.getValueCount();
            double min = Double.MAX_VALUE;
            double max = -min;
            if (num > 0) {
                CRD crd = this.model;
                min = crd.getColumnMin((short)2);
                max = crd.getColumnMax((short)2);
            }
            range = new ContinuousRange(min, max);
            range.setLabel(this.responseVar.getLabel());
        } else {
            range = null;
        }
        return range;
    }

    protected void updateCategoryRange() {
        this.categoryRange = this.getIndRange();
        this.setFormat(this.categoryRange, 1);
        byte dim = 18;
        RangeChangedEvent rce = new RangeChangedEvent((Object)this, 1, this.categoryRange, dim);
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    protected void updateResponseRange() {
        this.responseRange = this.getDepRange();
        this.setFormat(this.responseRange, 2);
        byte dim = 5;
        RangeChangedEvent rce = new RangeChangedEvent((Object)this, 1, this.responseRange, dim);
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        Object cr = null;
        switch (dimension) {
            case 18: {
                return this.categoryRange;
            }
            case 4: {
                return this.categoryRange;
            }
            case 17: {
                return this.categoryRange;
            }
            case 5: {
                return this.responseRange;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        int w = channel.getWidth();
        int h = channel.getHeight();
        channel.glPushMatrix();
        channel.glLoadIdentity();
        channel.glTranslate((double)(w / 2), (double)(h / 2), 0.0);
        this.networkRoot.draw(channel, false);
        channel.glPopMatrix();
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        int w = channel.getWidth();
        int h = channel.getHeight();
        channel.glPushMatrix();
        channel.glLoadIdentity();
        channel.glTranslate((double)(w / 2), (double)(h / 2), 0.0);
        this.networkRoot.draw(channel, true);
        channel.glPopMatrix();
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 18) {
            this.categoryEncoder = encoder;
        } else if (dimension == 5) {
            this.responseEncoder = encoder;
        } else if (dimension == 4) {
            this.colorEncoder = encoder;
        } else if (dimension == 17) {
            this.lineColorEncoder = encoder;
        }
        this.needConnect = true;
    }

    @Override
    public void setModel(CRD model) {
        super.setModel(model);
        this.connectVars();
        this.updateCategoryRange();
        this.updateResponseRange();
    }

    protected void connectVars() {
        CRD crd = this.model;
        String name = "";
        if (crd.isAvailable(1)) {
            boolean numericCategory = crd.getColumnClass(1) == Double.class;
            this.categoryVar = this.connectCategory((short)1, this.missingCategoryOn);
            numericCategory = false;
        }
        if (crd.isAvailable(2)) {
            if (crd.getColumnClass(2) != Double.class) {
                StatGraph.printDebug("Pie: RESPONSE must be numeric");
            } else {
                name = this.getLabel((short)2);
                this.responseVar = new NumericVectorVariable();
                this.responseVar.connectFrom(crd.getDoubleColumn(2));
                this.responseVar.setLabel(name);
            }
        } else {
            name = RB.getStringResource("Overlay.", "frequency.txt");
            int n = this.categoryVar.getValueCount();
            double[] count = new double[n];
            for (int i = 0; i < n; ++i) {
                count[i] = 1.0;
            }
            this.responseVar = new NumericVectorVariable();
            this.responseVar.connectFrom(count);
            this.responseVar.setLabel(name);
        }
        VariableProcessor vp = new VariableProcessor();
        vp.addGroupVariable(this.categoryVar);
        vp.addVariable((Variable)this.responseVar, 6);
        this.addCRDWhereClause(vp);
    }

    @Override
    protected boolean connectNetwork() {
        StringToColorMap cm;
        Object o;
        Enumeration e;
        HashMap table;
        DiscreteRange dr;
        if (this.categoryVar == null || this.categoryRange == null) {
            return false;
        }
        if (this.responseVar == null || this.responseRange == null) {
            return false;
        }
        this.networkRoot.removeAllElements();
        GTKPie pie = new GTKPie();
        this.networkRoot.addElement((Element)pie);
        pie.category.connectFrom(((StringVectorVariable)this.categoryVar).value);
        pie.response.connectFrom(this.responseVar.value);
        int size = Math.min(this.networkRoot.getChannel().getWidth(), this.networkRoot.getChannel().getHeight());
        pie.setSize(new Dimension(size, size));
        pie.setOtherThresholdPct(this.getOtherThreshold());
        pie.setOtherColor(this.getOtherColor());
        pie.setOtherLabel(this.getOtherLabel());
        if (this.isFillOn()) {
            if (this.getFillColor() != null) {
                dr = (DiscreteRange)this.getDataRange((byte)4);
                table = new HashMap();
                e = dr.getEnumeration();
                while (e.hasMoreElements()) {
                    o = e.nextElement();
                    if (o == null) continue;
                    table.put(o, this.applyDataTransparency(this.getFillColor()));
                }
                this.colorEncoder = new ColorEncoder(dr, table);
            }
            ((ColorEncoder)this.colorEncoder).colorList.put(pie.getOtherLabel(), pie.getOtherColor());
            cm = (StringToColorMap)this.colorEncoder.getValueMap();
            cm.init((AInitAction)new InitAction(null));
            pie.setColorMap(cm);
        }
        pie.fillOn.setValue(this.isFillOn());
        if (this.isEdgeOn()) {
            if (!this.isFillOn()) {
                if (this.isUseEdgeColor()) {
                    dr = (DiscreteRange)this.getDataRange((byte)17);
                    table = new HashMap();
                    e = dr.getEnumeration();
                    while (e.hasMoreElements()) {
                        o = e.nextElement();
                        if (o == null) continue;
                        table.put(o, this.applyDataTransparency(this.getEdgeColor()));
                    }
                    this.lineColorEncoder = new ColorEncoder(dr, table);
                }
                ((ColorEncoder)this.lineColorEncoder).colorList.put(pie.getOtherLabel(), pie.getOtherColor());
                cm = (StringToColorMap)this.lineColorEncoder.getValueMap();
                cm.init((AInitAction)new InitAction(null));
                pie.setColorMap(cm);
            } else {
                pie.edgeColor.setValue(this.getEdgeColor());
            }
        }
        pie.edgeOn.setValue(this.isEdgeOn());
        pie.setEdgeWidth(this.isEdgeOn() ? this.getEdgeThickness() : 0);
        pie.setInsideLabelPlacement(5);
        if (this.labelContent.equalsIgnoreCase("NONE")) {
            pie.setInsideLabelContent(10601);
        } else if (this.labelContent.equalsIgnoreCase("CATEGORY")) {
            pie.setInsideLabelContent(10602);
        } else if (this.labelContent.equalsIgnoreCase("RESPONSE")) {
            pie.setInsideLabelContent(10603);
        } else if (this.labelContent.equalsIgnoreCase("PERCENT")) {
            pie.setInsideLabelContent(10608);
        } else if (this.labelContent.equalsIgnoreCase("CATEGORYRESPONSE")) {
            pie.setInsideLabelContent(10609);
        } else if (this.labelContent.equalsIgnoreCase("CATEGORYPERCENT")) {
            pie.setInsideLabelContent(10610);
        } else if (this.labelContent.equalsIgnoreCase("RESPONSEPERCENT")) {
            pie.setInsideLabelContent(10612);
        } else if (this.labelContent.equalsIgnoreCase("ALL")) {
            pie.setInsideLabelContent(10611);
        } else {
            pie.setInsideLabelContent(10609);
        }
        pie.setLabelStyle(this.getLabelStyle());
        pie.setResponseTitleStyle(this.getLabelStyle());
        pie.setStartAngle(this.getStart());
        if (this.order.equalsIgnoreCase("CATEGORYASCENDING")) {
            pie.setSliceOrder(1);
        } else if (this.order.equalsIgnoreCase("CATEGORYDESCENDING")) {
            pie.setSliceOrder(2);
        } else if (this.order.equalsIgnoreCase("RESPONSEASCENDING")) {
            pie.setSliceOrder(3);
        } else if (this.order.equalsIgnoreCase("RESPONSEDESCENDING")) {
            pie.setSliceOrder(4);
        } else {
            pie.setSliceOrder(0);
        }
        if (this.direction.equalsIgnoreCase("CLOCKWISE")) {
            pie.setSliceDirection(1);
        } else {
            pie.setSliceDirection(0);
        }
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.model.isAvailable(300)) {
            this.addCustomTips(null);
        } else {
            this.addTooltip(null, "CATEGORY");
            this.addTooltip(null, "RESPONSE");
        }
        pie.setUserData((Object)this.probe);
        this.needConnect = false;
        return true;
    }

    @Override
    public int[] getLinePatterns() {
        return new int[]{this.edgeStyle.getLinePattern()};
    }

    @Override
    public int[] getLineWidths() {
        return new int[]{this.edgeStyle.getWidth()};
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{this.isEdgeOn() ? this.getEdgeColor() : Color.white};
    }

    @Override
    public Color[] getFillColors() {
        Color[] colors = new Color[((StringVectorVariable)this.categoryVar).getUniqueValueCount()];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = ((ColorEncoder)this.colorEncoder).colorArray[i];
        }
        return colors;
    }

    @Override
    public String[] getGroupValues() {
        String[] values = new String[((StringVectorVariable)this.categoryVar).getUniqueValueCount()];
        for (int i = 0; i < values.length; ++i) {
            try {
                values[i] = ((StringVectorVariable)this.categoryVar).uniqueValue.getValue(i);
                continue;
            }
            catch (MissingValueException e) {
                values[i] = "";
            }
        }
        return values;
    }
}

