/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ContourOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.applets.statgraph.sgchart.ui.ProbeResult;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.ods.data.BaseData;
import com.sas.graphics.util.ods.data.DataVariableInterface;
import com.sas.graphics.util.ods.data.GriddedChartData;
import com.sas.graphics.util.ods.visual.ColorRamp;
import com.sas.graphics.util.ods.visual.IVIZColor;
import com.sas.graphics.util.ods.visual.jxd.JxdContours;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.DecimalFormat;

public class OContour
extends ContourOverlay {
    protected long list = -1L;
    protected DataVariableInterface xvalueVar;
    protected DataVariableInterface yvalueVar;
    protected DataVariableInterface zvalueVar;
    protected DataVariableInterface colorVar;
    protected BaseData rawData;
    protected GriddedChartData ctrData;
    protected MyJxdContours contour;
    protected DecimalFormat defaultFormat;
    protected boolean gridded = true;
    private boolean built = false;
    private boolean logXAxis = false;
    private boolean logYAxis = false;
    private double logBaseX = 10.0;
    private double logBaseY = 10.0;
    private int maxXGridCount = Integer.MAX_VALUE;
    private int maxYGridCount = Integer.MAX_VALUE;
    private double[] levels = null;

    @Override
    public void reconnect() {
        super.reconnect();
        this.built = false;
    }

    protected void updateXRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.xRange;
        if (this.ctrData != null) {
            double max;
            double min;
            if (!this.xUnionAllPages) {
                min = this.ctrData.GetXMin();
                max = this.ctrData.GetXMax();
                if (this.logXAxis) {
                    min = this.getInverseLogValue(min, this.logBaseX);
                    max = this.getInverseLogValue(max, this.logBaseX);
                }
            } else {
                min = this.model.getColumnMin((short)10);
                max = this.model.getColumnMax((short)10);
            }
            newRange = new ContinuousRange(min, max);
            newRange.setLabel(this.xvalueVar.GetName());
            if (min == Double.NaN || max == Double.NaN) {
                StatGraph.printDebug("bad contour X data?");
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 10);
        this.xRange = newRange;
        byte dim = 1;
        RangeChangedEvent rce = null;
        if (oldRange == null && newRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, (DataRange)newRange, dim);
        } else if (oldRange != null && newRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != newRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, (DataRange)newRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    protected void updateYRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.yRange;
        if (this.ctrData != null) {
            double max;
            double min;
            if (!this.yUnionAllPages) {
                min = this.ctrData.GetYMin();
                max = this.ctrData.GetYMax();
                if (this.logYAxis) {
                    min = this.getInverseLogValue(min, this.logBaseY);
                    max = this.getInverseLogValue(max, this.logBaseY);
                }
            } else {
                min = this.model.getColumnMin((short)11);
                max = this.model.getColumnMax((short)11);
            }
            newRange = new ContinuousRange(min, max);
            newRange.setLabel(this.yvalueVar.GetName());
            if (min == Double.NaN || max == Double.NaN) {
                StatGraph.printDebug("bad contour Y data?");
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 11);
        this.yRange = newRange;
        byte dim = 2;
        RangeChangedEvent rce = null;
        if (oldRange == null && newRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, (DataRange)newRange, dim);
        } else if (oldRange != null && newRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != newRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, (DataRange)newRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    protected void updateZRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.zRange;
        if (this.ctrData != null) {
            double min = this.model.getColumnMin((short)12);
            double max = this.model.getColumnMax((short)12);
            newRange = new ContinuousRange(min, max);
            newRange.setLabel(this.zvalueVar.GetName());
            if (min == Double.NaN || max == Double.NaN) {
                StatGraph.printDebug("bad contour Z data?");
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 12);
        this.zRange = newRange;
        byte dim = 3;
        RangeChangedEvent rce = null;
        if (oldRange == null && newRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, (DataRange)newRange, dim);
        } else if (oldRange != null && newRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != newRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, (DataRange)newRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    protected void updateColorRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.colorRange;
        if (this.ctrData != null) {
            double min = this.ctrData.GetResponseMin(0);
            double max = this.ctrData.GetResponseMax(0);
            newRange = new ContinuousRange(min, max);
            newRange.setLabel(this.zvalueVar.GetName());
            if (min == Double.NaN || max == Double.NaN) {
                StatGraph.printDebug("bad contour Color data?");
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 6);
        this.colorRange = newRange;
        byte dim = 4;
        RangeChangedEvent rce = null;
        if (oldRange == null && newRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, (DataRange)newRange, dim);
        } else if (oldRange != null && newRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != newRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, (DataRange)newRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (dimension == 1) {
            return this.xRange;
        }
        if (dimension == 2) {
            return this.yRange;
        }
        if (dimension == 3) {
            return this.zRange;
        }
        if (dimension == 4) {
            return this.colorRange;
        }
        return null;
    }

    public IVIZColor getColorRamp() {
        return this.contour.GetColorRamp();
    }

    public double[] getLevels() {
        return this.contour.GetLevels();
    }

    public boolean setLevels(double[] newLevels) {
        int i;
        double[] tempLevels = null;
        if (newLevels == null || newLevels.length == 0) {
            return false;
        }
        tempLevels = new double[newLevels.length + 2];
        if (tempLevels == null) {
            return false;
        }
        double curr = tempLevels[0] = this.ctrData.GetResponseMin(0);
        double max = this.ctrData.GetResponseMax(0);
        int count = 1;
        for (i = 0; i < newLevels.length && curr < max; ++i) {
            if (!(newLevels[i] > curr)) continue;
            curr = tempLevels[count] = Math.min(newLevels[i], max);
            ++count;
        }
        if (curr < max) {
            tempLevels[count] = max;
            ++count;
        }
        if ((this.levels = new double[count]) == null) {
            return false;
        }
        for (i = 0; i < count; ++i) {
            this.levels[i] = tempLevels[i];
        }
        return true;
    }

    public void setGridded(boolean b) {
        this.gridded = b;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
        this.contour.setLineStyle(lineStyle);
    }

    public void setLineThickness(int width) {
        this.lineThickness = width;
        this.contour.setLineWidth(width);
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
        if (this.hasAreaFill || this.hasSmoothFill) {
            this.contour.setLineOverlayColor(color);
        } else {
            Color[] tempColors = new Color[]{color, color};
            this.contour.SetColorRamp((IVIZColor)new ColorRamp((Object)tempColors, null));
        }
    }

    public void updateDisplay() {
        if (this.hasAreaFill || this.hasSmoothFill) {
            if (this.hasSmoothFill) {
                this.contour.SetStyle("Smooth");
                this.contour.SetSubdivideOn(true);
            } else {
                this.contour.SetStyle("Areas");
            }
            if (this.rampColors != null) {
                this.contour.SetColorRamp((IVIZColor)new ColorRamp((Object)this.rampColors, null));
            }
            if (this.hasLines) {
                this.contour.setShowLineOverlay(true);
                this.contour.setLineOverlayColor(this.lineColor);
            }
        } else {
            this.contour.SetStyle("Lines");
            Color[] tempColors = new Color[]{this.lineColor, this.lineColor};
            this.contour.SetColorRamp((IVIZColor)new ColorRamp((Object)tempColors, null));
        }
        if (this.hasLines) {
            this.contour.setLineStyle(this.lineStyle);
            this.contour.setLineStippleFactor(StatGraph.getStippleScaleFactor());
            this.contour.setLineWidth(this.lineThickness);
            if (this.hasLineLabels) {
                this.contour.setLabelStyle(this.labelStyle);
                this.contour.setLabelPosition(this.labelPosition);
                this.contour.setLabelOrientation(this.labelOrientation);
                if (this.labelFormat != null) {
                    this.contour.setLabelFormat(this.labelFormat);
                }
                if (this.labelTextStyle != null) {
                    this.contour.setFont(this.labelTextStyle.getFont());
                    this.contour.setLabelColor(this.labelTextStyle.getColor());
                }
            }
        }
        if (this.numLev != 0) {
            this.contour.SetNumberLevels(this.numLev, this.numLevHint);
        }
        this.contour.SetUseOpacity(this.useOpacity);
        this.contour.SetOpacityValue(this.opacityValue);
        this.contour.SetDrawMissing(true);
        this.contour.SetSmoothShadeMissing(false);
    }

    @Override
    public void setChannel(Channel channel) {
        this.contour = new MyJxdContours(channel);
        this.contour.Create();
        channel.glEdgeFlag(true);
        if (this.ctrData != null) {
            this.contour.SetDataSourceObject(this.ctrData);
        }
        if (this.hasAreaFill || this.hasSmoothFill) {
            if (this.hasSmoothFill) {
                this.contour.SetStyle("Smooth");
                this.contour.SetSubdivideOn(true);
            } else {
                this.contour.SetStyle("Areas");
            }
            if (this.rampColors != null) {
                this.contour.SetColorRamp((IVIZColor)new ColorRamp((Object)this.rampColors, null));
            }
            if (this.hasLines) {
                this.contour.setShowLineOverlay(true);
                this.contour.setLineOverlayColor(this.lineColor);
            }
        } else {
            this.contour.SetStyle("Lines");
            Color[] tempColors = new Color[]{this.lineColor, this.lineColor};
            this.contour.SetColorRamp((IVIZColor)new ColorRamp((Object)tempColors, null));
        }
        if (this.hasLines) {
            this.contour.setLineStyle(this.lineStyle);
            this.contour.setLineStippleFactor(StatGraph.getStippleScaleFactor());
            this.contour.setLineWidth(this.lineThickness);
            if (this.hasLineLabels) {
                this.contour.setLabelStyle(this.labelStyle);
                this.contour.setLabelPosition(this.labelPosition);
                this.contour.setLabelOrientation(this.labelOrientation);
                if (this.labelFormat != null) {
                    this.contour.setLabelFormat(this.labelFormat);
                }
                if (this.labelTextStyle != null) {
                    this.contour.setFont(this.labelTextStyle.getFont());
                    this.contour.setLabelColor(this.labelTextStyle.getColor());
                }
            }
        }
        boolean userLevels = false;
        if (this.levels != null) {
            userLevels = this.contour.DefineContourLevels(this.levels);
        }
        if (!userLevels && this.numLev != 0) {
            this.contour.SetNumberLevels(this.numLev, this.numLevHint);
        }
        this.contour.SetUseOpacity(this.useOpacity);
        this.contour.SetOpacityValue(this.opacityValue);
        this.contour.SetDrawMissing(true);
        this.contour.SetSmoothShadeMissing(false);
    }

    public ProbeResult probeValueAt(int x, int y, int xi, int yi) {
        if (!this.built) {
            return null;
        }
        ValueMap map = this.xEncoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            StatGraph.printDebug("xEncoder's map (" + map + ")is not a CTNM");
            return null;
        }
        ContinuousRangeToNumericMap xvalueMap = (ContinuousRangeToNumericMap)map;
        double x1in = xvalueMap.getInputMin();
        double x2in = xvalueMap.getInputMax();
        double x1out = xvalueMap.getOutputMin();
        double x2out = xvalueMap.getOutputMax();
        if (this.yEncoder == null) {
            StatGraph.printDebug("yEncoder = null");
            return null;
        }
        map = this.yEncoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            StatGraph.printDebug("yEncoder's map (" + map + ")is not a CTNM");
            return null;
        }
        ContinuousRangeToNumericMap yvalueMap = (ContinuousRangeToNumericMap)map;
        double y1in = yvalueMap.getInputMin();
        double y2in = yvalueMap.getInputMax();
        double y1out = yvalueMap.getOutputMin();
        double y2out = yvalueMap.getOutputMax();
        double win = x2in - x1in;
        double hin = y2in - y1in;
        double wout = x2out - x1out - 1.0;
        double hout = y2out - y1out - 1.0;
        if (this.hasAreaFill) {
            wout += 1.0;
        }
        Channel channel = this.contour.getChannel();
        channel.glPushMatrix();
        channel.glTranslate(x1out + (double)xi, y1out + (double)yi, 0.0);
        channel.glScale(wout / win, hout / hin, 1.0);
        channel.glTranslate(-x1in, -y1in, 0.0);
        double[] scr = new double[3];
        double[] out = new double[3];
        scr[0] = x;
        scr[1] = y;
        scr[2] = 1.0;
        channel.gluUnProject(scr, out);
        Double o = this.contour.GetValueAtLocation(x, y);
        if (o == null || !(o instanceof Double)) {
            channel.glPopMatrix();
            return null;
        }
        Double pVal = o;
        channel.glPopMatrix();
        if (this.probe == null) {
            this.probe = new Probe();
        } else {
            this.probe.removeAll();
        }
        this.probe.setTrimOn(true);
        if (this.defaultFormat == null) {
            this.defaultFormat = new DecimalFormat();
        }
        this.probe.addString(this.xvalueVar.GetName(), this.defaultFormat.format(out[0]));
        this.probe.addString(this.yvalueVar.GetName(), this.defaultFormat.format(out[1]));
        this.probe.addString(this.zvalueVar.GetName(), this.defaultFormat.format(pVal));
        ProbeResult pr = new ProbeResult();
        pr.setElement(this);
        pr.setRow(0);
        pr.setProbe(this.probe);
        return pr;
    }

    public boolean draw() {
        if (this.contour == null) {
            return false;
        }
        if (this.xEncoder == null) {
            StatGraph.printDebug("xEncoder = null");
            return false;
        }
        ValueMap map = this.xEncoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            StatGraph.printDebug("xEncoder's map (" + map + ")is not a CTNM");
            return false;
        }
        ContinuousRangeToNumericMap xvalueMap = (ContinuousRangeToNumericMap)map;
        double x1in = xvalueMap.getInputMin();
        double x2in = xvalueMap.getInputMax();
        double x1out = xvalueMap.getOutputMin();
        double x2out = xvalueMap.getOutputMax();
        if (this.logXAxis) {
            x1in = this.getLogValue(x1in, this.logBaseX);
            x2in = this.getLogValue(x2in, this.logBaseX);
        }
        if (this.yEncoder == null) {
            StatGraph.printDebug("yEncoder = null");
            return false;
        }
        map = this.yEncoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            StatGraph.printDebug("yEncoder's map (" + map + ")is not a CTNM");
            return false;
        }
        ContinuousRangeToNumericMap yvalueMap = (ContinuousRangeToNumericMap)map;
        double y1in = yvalueMap.getInputMin();
        double y2in = yvalueMap.getInputMax();
        double y1out = yvalueMap.getOutputMin();
        double y2out = yvalueMap.getOutputMax();
        if (this.logYAxis) {
            y1in = this.getLogValue(y1in, this.logBaseY);
            y2in = this.getLogValue(y2in, this.logBaseY);
        }
        double win = x2in - x1in;
        double hin = y2in - y1in;
        double wout = x2out - x1out - 1.0;
        double hout = y2out - y1out - 1.0;
        if (this.hasAreaFill) {
            wout += 1.0;
        }
        Channel channel = this.contour.getChannel();
        channel.glPushAttrib(0);
        channel.glEdgeFlag(true);
        channel.glPushMatrix();
        channel.glTranslate(x1out, y1out, 0.0);
        channel.glScale(wout / win, hout / hin, 1.0);
        channel.glTranslate(-x1in, -y1in, 0.0);
        if (!this.built) {
            this.contour.Build(null);
            this.built = true;
        }
        this.contour.Draw(null, false);
        channel.glPopMatrix();
        channel.glPopAttrib();
        return true;
    }

    @Override
    public void draw(Graphics g) {
        if (this.contour == null) {
            return;
        }
        Channel channel = this.contour.getChannel();
        Graphics2D g2d = (Graphics2D)g;
        boolean antiAliased = false;
        if (g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON && !this.hasLines) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            channel.glDisable(13);
            channel.glDisable(14);
            antiAliased = true;
        }
        this.draw();
        if (antiAliased) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            channel.glEnable(13);
            channel.glEnable(14);
        }
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 3) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            this.zEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.colorEncoder = (ColorEncoder)encoder;
        }
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.updateXRange();
        this.updateYRange();
        this.updateZRange();
        this.updateColorRange();
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        return 0.0;
    }

    protected void connectVars() {
        int i;
        Double[] list2;
        int num;
        double[] list1;
        CRD crd = this.model;
        if (this.isPresortData()) {
            short[] sortRoles = new short[]{10, 11};
            int[] sortTypes = new int[]{1, 1};
            crd.sortByRoles(sortRoles, sortTypes);
        }
        this.rawData = new BaseData(null);
        String name = "";
        this.xvalueVar = null;
        if (crd.isAvailable(10)) {
            boolean numericX;
            name = this.getLabel((short)10);
            boolean bl = numericX = crd.getColumnClass(10) == Double.class;
            if (!numericX) {
                StatGraph.printDebug("XVALUE must be numeric");
            } else {
                list1 = this.getSubsettedDoubleColumn((short)10);
                num = list1.length;
                list2 = new Double[num];
                for (i = 0; i < num; ++i) {
                    list2[i] = this.logXAxis ? new Double(this.getLogValue(list1[i], this.logBaseX)) : new Double(list1[i]);
                }
                this.xvalueVar = this.rawData.AddVariable(Double.class, name, name, (Object)list2);
            }
        }
        this.yvalueVar = null;
        if (crd.isAvailable(11)) {
            boolean numericY;
            name = this.getLabel((short)11);
            boolean bl = numericY = crd.getColumnClass(11) == Double.class;
            if (!numericY) {
                StatGraph.printDebug("YVALUE must be numeric");
            } else {
                list1 = this.getSubsettedDoubleColumn((short)11);
                num = list1.length;
                list2 = new Double[num];
                for (i = 0; i < num; ++i) {
                    list2[i] = this.logYAxis ? new Double(this.getLogValue(list1[i], this.logBaseY)) : new Double(list1[i]);
                }
                this.yvalueVar = this.rawData.AddVariable(Double.class, name, name, (Object)list2);
            }
        }
        this.zvalueVar = null;
        if (crd.isAvailable(12)) {
            boolean numericZ;
            name = this.getLabel((short)12);
            boolean bl = numericZ = crd.getColumnClass(12) == Double.class;
            if (!numericZ) {
                StatGraph.printDebug("ZVALUE must be numeric");
            } else {
                list1 = this.getSubsettedDoubleColumn((short)12);
                num = list1.length;
                list2 = new Double[num];
                for (i = 0; i < num; ++i) {
                    list2[i] = new Double(list1[i]);
                }
                this.zvalueVar = this.rawData.AddVariable(Double.class, name, name, (Object)list2);
            }
        }
        this.colorVar = null;
        if (crd.isAvailable(6)) {
            boolean numericColor;
            name = this.getLabel((short)6);
            boolean bl = numericColor = crd.getColumnClass(6) == Double.class;
            if (!numericColor) {
                StatGraph.printDebug("COLOR must be numeric");
            } else {
                list1 = crd.getDoubleColumn(6);
                num = list1.length;
                list2 = new Double[num];
                for (i = 0; i < num; ++i) {
                    list2[i] = new Double(list1[i]);
                }
                this.xvalueVar = this.rawData.AddVariable(Double.class, name, name, (Object)list2);
            }
        }
        if (this.xvalueVar != null && this.yvalueVar != null && this.zvalueVar != null) {
            this.ctrData = new GriddedChartData();
            this.ctrData.setXMaxUniqueValueCount(this.maxXGridCount);
            this.ctrData.setYMaxUniqueValueCount(this.maxYGridCount);
            this.ctrData.SetDataSource((Object)this.rawData);
            if (!this.gridded) {
                this.ctrData.setInterpolationScheme(0);
            }
            this.ctrData.BuildGriddedData((Object)this.xvalueVar, (Object)this.yvalueVar, (Object)this.zvalueVar);
        }
        if (this.contour != null && this.ctrData != null) {
            this.contour.SetDataSourceObject(this.ctrData);
        }
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        if (dimension == 1) {
            return this.xEncoder;
        }
        if (dimension == 2) {
            return this.yEncoder;
        }
        return null;
    }

    public void setLogXAxis(boolean b) {
        this.logXAxis = b;
    }

    public void setLogYAxis(boolean b) {
        this.logYAxis = b;
    }

    public void setLogBaseX(double base) {
        this.logBaseX = base;
    }

    public void setLogBaseY(double base) {
        this.logBaseY = base;
    }

    private double getLogValue(double value, double base) {
        if (value <= 0.0) {
            return Double.NaN;
        }
        return Math.log(value) / Math.log(base);
    }

    private double getInverseLogValue(double value, double base) {
        return Math.pow(base, value);
    }

    public int getMaxXGridCount() {
        return this.maxXGridCount;
    }

    public void setMaxXGridCount(int maxXGridCount) {
        this.maxXGridCount = maxXGridCount;
    }

    public int getMaxYGridCount() {
        return this.maxYGridCount;
    }

    public void setMaxYGridCount(int maxYGridCount) {
        this.maxYGridCount = maxYGridCount;
    }

    @Override
    public String getLegendLabel() {
        if (this.legendLabel != null) {
            return this.legendLabel;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(12);
        if (cmd.getLabel() != null) {
            return cmd.getLabel();
        }
        return cmd.getName();
    }

    @Override
    public Range[] getColorModelRanges(int type) {
        if (type == 1) {
            return null;
        }
        Range[] colorModelRanges = null;
        if (this.hasSmoothFill) {
            ContinuousRange range = (ContinuousRange)this.zRange;
            colorModelRanges = new Range[1];
            RangeBound low = new RangeBound(range.getMin(), true);
            RangeBound high = new RangeBound(range.getMax(), true);
            ColorModel colorModel = new ColorModel(this.rampColors);
            colorModelRanges[0] = new Range(low, high, colorModel);
        } else if (this.hasAreaFill) {
            double[] levels = this.getLevels();
            if (levels.length == 1) {
                colorModelRanges = new Range[1];
                RangeBound low = new RangeBound(levels[0], true);
                RangeBound high = new RangeBound(levels[0], true);
                ColorModel colorModel = new ColorModel(new Color[]{this.rampColors[this.rampColors.length - 1]});
                colorModelRanges[0] = new Range(low, high, colorModel);
            } else {
                colorModelRanges = new Range[levels.length - 1];
                for (int i = 0; i < colorModelRanges.length; ++i) {
                    RangeBound low = new RangeBound(levels[i], true);
                    RangeBound high = new RangeBound(levels[i + 1], true);
                    Color c = this.getColorRamp().Query(levels[i + 1], levels[0], levels[levels.length - 1], false);
                    ColorModel colorModel = new ColorModel(new Color[]{c});
                    colorModelRanges[i] = new Range(low, high, colorModel);
                }
            }
        }
        return colorModelRanges;
    }

    @Override
    public SASFormat getContinuousLegendFormat() {
        if (this.zRange != null) {
            return this.zRange.getFormat();
        }
        return null;
    }

    @Override
    public int getNumOfTooltips() {
        return 0;
    }

    protected class MyJxdContours
    extends JxdContours {
        public MyJxdContours(Object c, Object t) {
            super(c, t);
        }

        public MyJxdContours(Object c) {
            super(c, null);
        }

        public long getRootList() {
            return this.rootId;
        }

        public long getCtrList() {
            return this.ctrId;
        }

        public Channel getChannel() {
            return this.ch;
        }

        protected void OnColor(double r, double g, double b) {
            if (this.useOpacity) {
                Color c = new Color((float)r, (float)g, (float)b, (float)this.opacity);
                this.OnColor(c);
            } else {
                Color c = new Color((float)r, (float)g, (float)b);
                this.OnColor(c);
            }
        }

        protected void OnColor(double r, double g, double b, double o) {
            if (this.useOpacity) {
                Color c = new Color((float)r, (float)g, (float)b, (float)o);
                this.OnColor(c);
            } else {
                this.OnColor(r, g, b);
            }
        }
    }
}

