/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.FillPatternEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.LineEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BarOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RB;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.FrequencyVariable;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.HighLowBar;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class HighLowOverlay
extends Overlay {
    public static final String RB_KEY = "HighLowOverlay.";
    protected DataRange xRange;
    protected DataRange yRange;
    protected DataRange highRange;
    protected DataRange lowRange;
    protected DataRange openRange;
    protected DataRange closeRange;
    protected DataRange colorRange;
    protected DataRange lineColorRange;
    protected DataRange lineRange;
    protected DataRange fillPatternRange;
    protected DataRange fillPatternColorRange;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder colorEncoder;
    protected ColorEncoder lineColorEncoder;
    protected LineEncoder lineEncoder;
    protected FillPatternEncoder fillPatternEncoder;
    protected ColorEncoder fillPatternColorEncoder;
    private NetworkRoot networkRoot;
    protected NumericMapper xvalueMapper;
    protected NumericMapper yvalueMapper;
    protected NumericMapper highMapper;
    protected NumericMapper lowMapper;
    protected NumericMapper openMapper;
    protected NumericMapper closeMapper;
    private Probe openProbe;
    private Probe closeProbe;
    private Probe highProbe;
    private Probe lowProbe;
    private Variable xvalueVar;
    private Variable yvalueVar;
    private Variable highVar;
    private Variable lowVar;
    private Variable openVar;
    private Variable closeVar;
    protected Variable groupVar;
    protected Variable gIndexVar;
    protected Variable colorVar;
    protected Variable lineColorVar;
    protected Variable lineVar;
    private Variable highCapVar;
    private Variable lowCapVar;
    private Variable highLabelVar;
    private Variable lowLabelVar;
    private Variable fillPatternVar;
    private Variable fillPatternColorVar;
    private NumericVectorVariable numericXVar;
    private NumericVectorVariable numericYVar;
    private StringVariable stringGroupVar;
    public static final int CAP_NONE = 0;
    public static final int CAP_SERIF = 1;
    public static final int CAP_ARROW = 2;
    public static final int CAP_BARBED_ARROW = 3;
    public static final int CAP_OPEN_ARROW = 4;
    public static final int CAP_CLIP = 5;
    private int highCap = 0;
    private int lowCap = 0;
    private boolean numericX = true;
    private boolean numericY = true;
    private boolean numericGroup = true;
    private boolean numericHighLabel = true;
    private boolean numericLowLabel = true;
    public static int BAR = 0;
    public static int LINE = 1;
    private int type = LINE;
    private boolean vertical = true;
    private boolean fillPatternOn = false;
    private boolean fillOn = true;
    private boolean edgeOn = true;
    private FillPatternAttrs fillPatternStyle = new FillPatternAttrs();
    private FillAttrs fillStyle = new FillAttrs();
    private LineAttrs lineStyle = new LineAttrs();
    private boolean useLineColor = false;
    private int extraPadding;
    private TextAttrs labelStyle = new TextAttrs();
    private boolean useLabelColor = false;
    public static final double DEFAULT_BARWIDTH = 0.85;
    private double barWidth = 0.85;
    private double clusterWidth = 0.85;
    private double intervalBarWidth = -1.0;
    private double maximumStride = -1.0;
    public static final byte CLUSTER = 0;
    public static final byte OVERLAY = 1;
    private int groupDisplay = 1;
    private int[] groupsPerCategory;
    private String overlayID;
    private ArrayList[] groupCategoryLists;
    private int[] subToColumnGroupCategory;
    private Image skinImage = null;
    protected double discreteOffset = 0.0;
    public static int CAP_DISPLAY_AUTO = HighLowBar.CAP_DISPLAY_AUTO;
    public static int CAP_DISPLAY_ALWAYS = HighLowBar.CAP_DISPLAY_ALWAYS;
    private int capDisplayPolicy = CAP_DISPLAY_AUTO;
    private boolean clipCap = false;
    private int clipCapShape = 5;
    private boolean gradientColor = false;
    private Color missingColorResponseColor = Color.black;
    private static double ZERO_VALUE = 1.0E-6;

    public void setClipCap(boolean b) {
        this.clipCap = b;
    }

    public boolean isClipCap() {
        return this.clipCap;
    }

    public void setClipCapShape(int shape) {
        this.clipCapShape = shape;
    }

    public int getClipCapShape() {
        return this.clipCapShape;
    }

    public static int getCapType(String cap) {
        if ((cap = cap.trim()).equalsIgnoreCase("NONE")) {
            return 0;
        }
        if (cap.equalsIgnoreCase("SERIF")) {
            return 1;
        }
        if (cap.equalsIgnoreCase("ARROW")) {
            return 2;
        }
        if (cap.equalsIgnoreCase("BARBEDARROW")) {
            return 3;
        }
        if (cap.equalsIgnoreCase("OPENARROW")) {
            return 4;
        }
        if (cap.equalsIgnoreCase("FILLEDARROW") || cap.equalsIgnoreCase("CLOSEDARROW")) {
            return 2;
        }
        if (cap.equalsIgnoreCase("CLIPPEDARROW")) {
            return 5;
        }
        return -1;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    public void setType(int t) {
        this.type = t;
    }

    public int getType() {
        return this.type;
    }

    public void setHighCap(int cap) {
        if (this.isValidCapType(cap)) {
            this.highCap = cap;
        }
    }

    public int getHighCap() {
        return this.highCap;
    }

    public void setLowCap(int cap) {
        if (this.isValidCapType(cap)) {
            this.lowCap = cap;
        }
    }

    public int getLowCap() {
        return this.lowCap;
    }

    public void setCapDisplayPolicy(int policy) {
        this.capDisplayPolicy = policy;
    }

    public int getCapDisplayPolicy() {
        return this.capDisplayPolicy;
    }

    public boolean isFillPatternOn() {
        return this.fillPatternOn;
    }

    public void setFillPatternOn(boolean b) {
        this.fillPatternOn = b;
    }

    public void setFillPatternStyle(FillPatternAttrs fps) {
        this.fillPatternStyle = fps;
    }

    public FillPatternAttrs getFillPatternStyle() {
        return this.fillPatternStyle;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean b) {
        this.fillOn = b;
    }

    public void setFillStyle(FillAttrs fs) {
        this.fillStyle = fs;
    }

    public FillAttrs getFillStyle() {
        return this.fillStyle;
    }

    public boolean isEdgeOn() {
        return this.edgeOn;
    }

    public void setEdgeOn(boolean b) {
        this.edgeOn = b;
    }

    public void setLineStyle(LineAttrs ls) {
        this.lineStyle = ls;
    }

    public LineAttrs getLineStyle() {
        return this.lineStyle;
    }

    public void setLabelStyle(TextAttrs ts) {
        this.labelStyle = ts;
    }

    public TextAttrs getLabelStyle() {
        return this.labelStyle;
    }

    public void setUseLabelColor(boolean b) {
        this.useLabelColor = b;
    }

    public boolean isUseLabelColor() {
        return this.useLabelColor;
    }

    public void setUseLineColor(boolean b) {
        this.useLineColor = b;
    }

    public boolean isUseLineColor() {
        return this.useLineColor;
    }

    public void setBarWidth(double width) {
        this.barWidth = width;
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    public void setIntervalBarWidth(double width) {
        this.intervalBarWidth = width * StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor;
    }

    public double getIntervalBarWidth() {
        return this.intervalBarWidth;
    }

    public void setClusterWidth(double width) {
        this.clusterWidth = width;
    }

    public double getClusterWidth() {
        return this.clusterWidth;
    }

    public void setGroupDisplay(int display) {
        this.groupDisplay = display;
    }

    public int getGroupDisplay() {
        return this.groupDisplay;
    }

    public void setDiscreteOffset(double offset) {
        this.discreteOffset = offset;
    }

    public double getDiscreteOffset() {
        return this.discreteOffset;
    }

    private double getMinimumOpenCloseWidth() {
        return (int)(2.0 * StatGraph.dataDPIScaleFactor);
    }

    private double getDefaultOpenCloseWidth() {
        double size = 5.0 * StatGraph.dataDPIScaleFactor;
        return (int)size;
    }

    private double getOpenCloseSize() {
        double size;
        int lw = this.lineStyle.getWidth();
        if (!this.useLineThickness && this.hasAttrVar("GROUP")) {
            DiscreteAttrMapper dam = (DiscreteAttrMapper)this.getAttrVarMapper("Group");
            lw = Math.max(dam.getMaxLineThickness(), lw);
        }
        if (this.type == LINE) {
            size = lw <= 3 ? this.getDefaultOpenCloseWidth() : this.getMinimumOpenCloseWidth() + (double)lw;
            size += Math.floor((double)(lw - 1) * 0.5);
            if (this.maximumStride > 0.0) {
                double maxSize = Math.floor(this.maximumStride - (double)(lw - 1) * 0.5 - 1.0);
                size = Math.max(this.getMinimumOpenCloseWidth(), Math.min(size, maxSize));
            }
        } else {
            size = this.getDefaultOpenCloseWidth();
            if (this.edgeOn) {
                size += Math.floor((double)(lw - 1) * 0.5);
            }
            if (this.maximumStride > 0.0 && this.maximumStride > this.intervalBarWidth) {
                double maxSize = this.maximumStride - this.intervalBarWidth;
                if (this.edgeOn) {
                    maxSize -= (double)(lw - 1) * 0.5;
                }
                maxSize = Math.floor(maxSize - 1.0);
                size = Math.max(this.getMinimumOpenCloseWidth(), Math.min(size, maxSize));
            }
        }
        return size;
    }

    private double getHighLowCapSize() {
        double size = this.type == BAR && this.intervalBarWidth >= 0.0 ? this.intervalBarWidth + this.getOpenCloseSize() * 2.0 : (double)this.lineStyle.getWidth() + this.getOpenCloseSize() * 2.0;
        return size;
    }

    private boolean isClipCapOn() {
        ValueMap map;
        if (!this.clipCap) {
            return false;
        }
        ValueMap valueMap = map = this.vertical ? this.yEncoder.getValueMap() : this.xEncoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        double mi = ((ContinuousRangeToNumericMap)map).getInputMin();
        double ma = ((ContinuousRangeToNumericMap)map).getInputMax();
        double inMin = Math.min(mi, ma);
        double inMax = Math.max(mi, ma);
        if (((NumericVariable)this.highVar).getMin() > inMax || ((NumericVariable)this.highVar).getMax() < inMin) {
            return true;
        }
        if (((NumericVariable)this.highVar).getMax() > inMax || ((NumericVariable)this.highVar).getMin() < inMin) {
            return true;
        }
        if (((NumericVariable)this.lowVar).getMin() > inMax || ((NumericVariable)this.lowVar).getMax() < inMin) {
            return true;
        }
        return ((NumericVariable)this.lowVar).getMax() > inMax || ((NumericVariable)this.lowVar).getMin() < inMin;
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.colorEncoder)) {
                return;
            }
            this.colorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 17) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.lineColorEncoder)) {
                return;
            }
            this.lineColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 15) {
            if (!(encoder instanceof LineEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.lineEncoder)) {
                return;
            }
            this.lineEncoder = (LineEncoder)encoder;
        } else if (dimension == 21) {
            if (!(encoder instanceof FillPatternEncoder)) {
                return;
            }
            this.fillPatternEncoder = (FillPatternEncoder)encoder;
        } else if (dimension == 22) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.fillPatternColorEncoder = (ColorEncoder)encoder;
        }
        this.needConnect = true;
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                if (this.vertical) {
                    return this.xRange;
                }
                return this.getDepRange();
            }
            case 2: {
                if (!this.vertical) {
                    return this.yRange;
                }
                return this.getDepRange();
            }
            case 4: {
                return this.colorRange;
            }
            case 17: {
                return this.lineColorRange;
            }
        }
        return null;
    }

    private DataRange getDepRange() {
        if (this.highRange == null || this.lowRange == null) {
            return null;
        }
        double min = ((ContinuousRange)this.highRange).getMin();
        double max = ((ContinuousRange)this.highRange).getMax();
        ContinuousRange cr = new ContinuousRange(min, max);
        cr.setLabel(this.highRange.getLabel());
        cr.setFormat(this.highRange.getFormat());
        cr.union(this.lowRange);
        if (this.openRange != null) {
            cr.union(this.openRange);
        }
        if (this.closeRange != null) {
            cr.union(this.closeRange);
        }
        return cr;
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.updateNumberOfGroupPerCategory();
        this.updateXRange();
        this.updateYRange();
        this.updateHighRange();
        this.updateLowRange();
        this.updateOpenRange();
        this.updateCloseRange();
        this.updateColorRange();
        this.updateLineColorRange();
        this.updateFillPatternRange();
        this.updateFillPatternColorRange();
    }

    private void updateNumberOfGroupPerCategory() {
        int numCats;
        NumericVariable catvar;
        Variable valueVar;
        if (this.groupVar == null || this.groupDisplay == 1) {
            return;
        }
        Variable variable = valueVar = this.vertical ? this.xvalueVar : this.yvalueVar;
        if (valueVar instanceof NumericVariable) {
            catvar = new NumericVariable();
            catvar.connectFrom((NumericVariable)valueVar);
            catvar.setFormat(((NumericVariable)valueVar).getFormat());
        } else {
            catvar = new StringVariable();
            ((StringVariable)catvar).connectFrom((StringVariable)valueVar);
            ((StringVariable)catvar).setFormat(((StringVariable)valueVar).getFormat());
        }
        StringVariable gvar = new StringVariable();
        if (this.groupVar instanceof NumericVariable) {
            gvar.connectFrom((NumericVariable)this.groupVar);
        } else {
            gvar.connectFrom((StringVariable)this.groupVar);
        }
        VariableProcessor vp = new VariableProcessor();
        this.addVarToVP(vp, (Variable)catvar);
        vp.addVariable((Variable)gvar, 0);
        vp.addGroupVariable((Variable)catvar);
        vp.addGroupVariable((Variable)gvar);
        if (this.model.getSrcModel().maxGroupsPerCategory == null) {
            this.model.getSrcModel().maxGroupsPerCategory = new HashMap();
        }
        short role = this.vertical ? (short)10 : 11;
        this.overlayID = this.model.getColumnName(role) + "." + this.model.getColumnName((short)3);
        if (this.isMissingGroupOn()) {
            this.overlayID = this.overlayID + ".MissingGroup";
        }
        int maxGroups = -1;
        if (this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID) != null) {
            maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
        }
        if ((numCats = catvar.getUniqueValueCount()) == 0) {
            return;
        }
        this.groupsPerCategory = new int[numCats];
        int gCount = 1;
        int gIdx = 0;
        String catV = null;
        for (int i = 0; i < catvar.getValueCount(); ++i) {
            try {
                String xv;
                String string = xv = catvar instanceof StringVariable ? ((StringVariable)catvar).value.getValue(i) : catvar.formattedValue.getValue(i);
                if (catV == null && i == 0) {
                    catV = xv;
                    continue;
                }
                if (xv.equals(catV)) {
                    ++gCount;
                    continue;
                }
                this.groupsPerCategory[gIdx] = gCount;
                if (gCount > maxGroups) {
                    maxGroups = gCount;
                }
                ++gIdx;
                gCount = 1;
                catV = xv;
                continue;
            }
            catch (MissingValueException e) {
                if (catV == null) continue;
                this.groupsPerCategory[gIdx] = gCount;
                if (gCount > maxGroups) {
                    maxGroups = gCount;
                }
                ++gIdx;
                gCount = 1;
                catV = null;
            }
        }
        this.groupsPerCategory[gIdx] = gCount;
        if (gCount > maxGroups) {
            maxGroups = gCount;
        }
        this.model.getSrcModel().maxGroupsPerCategory.put(this.overlayID, new Integer(maxGroups));
        this.groupCategoryLists = this.getGroupCategoryLists();
    }

    private ArrayList[] getGroupCategoryLists() {
        ArrayList[] list;
        block13: {
            int i;
            int nCat;
            block12: {
                String[] gvalues = this.getGroupValues();
                Variable catVar = this.vertical ? this.xvalueVar : this.yvalueVar;
                nCat = catVar.getUniqueValueCount();
                list = new ArrayList[nCat];
                for (int i2 = 0; i2 < nCat; ++i2) {
                    list[i2] = new ArrayList();
                }
                int nGrp = this.groupVar.getUniqueValueCount();
                this.subToColumnGroupCategory = new int[nGrp];
                this.stringGroupVar.getUniqueValueCount();
                HashMap<String, Integer> value2ColumnCategory = new HashMap<String, Integer>();
                for (int i3 = 0; i3 < nGrp; ++i3) {
                    try {
                        if (this.groupOrder == 0) {
                            String v = this.stringGroupVar.uniqueValue.getValue(i3);
                            int groupCategory_column = this.getGroupCategoryInDataColumn(v, gvalues);
                            value2ColumnCategory.put(v, new Integer(groupCategory_column));
                            this.subToColumnGroupCategory[i3] = groupCategory_column;
                            continue;
                        }
                        this.subToColumnGroupCategory[i3] = i3;
                        continue;
                    }
                    catch (MissingValueException v) {
                        // empty catch block
                    }
                }
                IntegerPipe groupCategory = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category : ((StringVariable)this.groupVar).category;
                IntegerPipe category = catVar instanceof StringVariable ? ((StringVariable)catVar).category : ((NumericVariable)catVar).category;
                int n = catVar.getValueCount();
                for (i = 0; i < n; ++i) {
                    try {
                        Integer IG;
                        int cat;
                        if (catVar instanceof NumericVariable) {
                            ((NumericVariable)catVar).value.getValue(i);
                        }
                        if (list[cat = category.getValue(i)].contains(IG = new Integer(groupCategory.getValue(i)))) continue;
                        list[cat].add(IG);
                        continue;
                    }
                    catch (MissingValueException cat) {
                        // empty catch block
                    }
                }
                if (this.groupOrder != 1 && this.groupOrder != 2) break block12;
                for (i = 0; i < nCat; ++i) {
                    Collections.sort(list[i]);
                }
                break block13;
            }
            if (this.groupOrder != 3) break block13;
            for (i = 0; i < nCat; ++i) {
                ArrayList ll = new ArrayList();
                for (int j = list[i].size() - 1; j >= 0; --j) {
                    ll.add(list[i].get(j));
                }
                list[i] = ll;
            }
        }
        return list;
    }

    private int getGroupCategoryInDataColumn(String gv, String[] gvalues) {
        for (int g = 0; g < gvalues.length; ++g) {
            if (!gvalues[g].equals(gv)) continue;
            return g;
        }
        return -1;
    }

    private void verifySummarizedData() {
        FrequencyVariable freq = new FrequencyVariable();
        CRD crd = this.model;
        Variable cat = crd.isAvailable(10) ? (this.discreteX ? this.connectCategory((short)10, this.missingCategoryOn) : this.connectRaw((short)10)) : (this.discreteY ? this.connectCategory((short)11, this.missingCategoryOn) : this.connectRaw((short)11));
        Variable grp = this.connectCategory((short)3, this.missingGroupOn);
        VariableProcessor vp = new VariableProcessor();
        vp.addGroupVariable(cat);
        if (this.groupVar != null) {
            vp.addGroupVariable(grp);
        }
        vp.addVariable((Variable)freq, 2);
        this.addCRDWhereClause(vp);
        if (freq.getMax() > 1.0) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "nonsummarized.txt"));
        }
    }

    protected void connectVars() {
        SASFormat fmt;
        CRD crd = this.model;
        if (crd.isAvailable(10)) {
            this.numericX = crd.getColumnClass(10) == Double.class;
            this.xvalueVar = this.discreteX ? this.connectCategory((short)10, this.missingCategoryOn) : this.connectRaw((short)10);
            if (this.numericX && this.discreteX) {
                this.numericXVar = new NumericVectorVariable();
                this.numericXVar.connectFrom(crd.getDoubleColumn(10));
                fmt = ((ColumnMetadata)crd.getColumnLabel(10)).getFormat();
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                }
                this.numericXVar.setFormat(new GTKFormat((Format)fmt));
            }
            if (this.discreteX) {
                this.numericDiscreteX = this.numericX;
                this.numericX = false;
            }
        } else {
            this.xvalueVar = null;
        }
        if (crd.isAvailable(11)) {
            this.numericY = crd.getColumnClass(11) == Double.class;
            this.yvalueVar = this.discreteY ? this.connectCategory((short)11, this.missingCategoryOn) : this.connectRaw((short)11);
            if (this.numericY && this.discreteY) {
                this.numericYVar = new NumericVectorVariable();
                this.numericYVar.connectFrom(crd.getDoubleColumn(11));
                fmt = ((ColumnMetadata)crd.getColumnLabel(11)).getFormat();
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                }
                this.numericYVar.setFormat(new GTKFormat((Format)fmt));
            }
            if (this.discreteY) {
                this.numericDiscreteY = this.numericY;
                this.numericY = false;
            }
        } else {
            this.yvalueVar = null;
        }
        this.highVar = crd.isAvailable(60) ? this.connectRaw((short)60) : null;
        this.lowVar = crd.isAvailable(61) ? this.connectRaw((short)61) : null;
        this.openVar = crd.isAvailable(62) ? this.connectRaw((short)62) : null;
        this.closeVar = crd.isAvailable(63) ? this.connectRaw((short)63) : null;
        if (this.gradientColor) {
            if (this.type == BAR && this.isFillOn()) {
                this.colorVar = this.connectRaw((short)6);
            } else {
                this.lineColorVar = this.connectRaw((short)46);
            }
        } else {
            this.colorVar = crd.isAvailable(6) ? this.connectCategory((short)6, true) : null;
            this.lineColorVar = crd.isAvailable(46) ? this.connectCategory((short)46, true) : null;
        }
        this.lineVar = crd.isAvailable(36) ? this.connectCategory((short)36, true) : null;
        this.fillPatternVar = crd.isAvailable(111) ? this.connectCategory((short)111, true) : null;
        this.fillPatternColorVar = crd.isAvailable(112) ? this.connectCategory((short)112, true) : null;
        if (crd.isAvailable(3)) {
            this.numericGroup = crd.getColumnClass(3) == Double.class;
            this.groupVar = this.connectRaw((short)3);
            this.groupVar.setFormattedValueMissingValueExceptionsEnabled(false);
            this.stringGroupVar = (StringVariable)this.connectCategory((short)3, true);
        } else {
            this.groupVar = null;
        }
        this.gIndexVar = crd.isAvailable(44) ? this.connectRaw((short)44) : null;
        this.highCapVar = crd.isAvailable(64) ? this.connectCategory((short)64, true) : null;
        this.lowCapVar = crd.isAvailable(65) ? this.connectCategory((short)65, true) : null;
        if (crd.isAvailable(66)) {
            this.numericHighLabel = crd.getColumnClass(66) == Double.class;
            this.highLabelVar = this.connectRaw((short)66);
        } else {
            this.highLabelVar = null;
        }
        if (crd.isAvailable(67)) {
            this.numericLowLabel = crd.getColumnClass(67) == Double.class;
            this.lowLabelVar = this.connectRaw((short)67);
        } else {
            this.lowLabelVar = null;
        }
        Variable urlVar = this.connectCategory((short)52, false);
        VariableProcessor vp = null;
        if (this.groupVar != null && (!this.missingGroupOn || this.groupOrder != 0 && this.groupOrder != 3) || crd.whereExpression != null) {
            vp = new VariableProcessor();
            this.addVarToVP(vp, this.xvalueVar);
            this.addVarToVP(vp, this.yvalueVar);
            this.addVarToVP(vp, this.highVar);
            this.addVarToVP(vp, this.lowVar);
            this.addVarToVP(vp, this.openVar);
            this.addVarToVP(vp, this.closeVar);
            this.addVarToVP(vp, this.colorVar);
            this.addVarToVP(vp, this.lineColorVar);
            this.addVarToVP(vp, this.lineVar);
            this.addVarToVP(vp, this.fillPatternVar);
            this.addVarToVP(vp, this.fillPatternColorVar);
            this.addVarToVP(vp, this.groupVar);
            this.addVarToVP(vp, (Variable)this.stringGroupVar);
            this.addVarToVP(vp, this.gIndexVar);
            this.addVarToVP(vp, this.highCapVar);
            this.addVarToVP(vp, this.lowCapVar);
            this.addVarToVP(vp, this.highLabelVar);
            this.addVarToVP(vp, this.lowLabelVar);
            this.addVarToVP(vp, (Variable)this.numericXVar);
            this.addVarToVP(vp, (Variable)this.numericYVar);
            this.addVarToVP(vp, urlVar);
            if (this.groupVar != null && !this.missingGroupOn) {
                vp.setWhereExpression("^(" + this.groupVar.getName() + " IS MISSING)");
                this.whereRoles = new int[]{3};
            }
            if (this.groupVar != null) {
                if (this.getGroupOrder() == 1) {
                    this.groupVar.setUniqueValueSort(1);
                    if (this.isDrawByGroupOrder()) {
                        vp.setSort(this.groupVar, 1);
                    }
                } else if (this.getGroupOrder() == 2) {
                    this.groupVar.setUniqueValueSort(2);
                    if (this.isDrawByGroupOrder()) {
                        vp.setSort(this.groupVar, 2);
                    }
                }
                this.groupVar.setSortByFormattedValues(!this.numericGroup);
            }
            if (urlVar != null) {
                vp.addVariable(urlVar);
            }
            this.addCRDWhereClause(vp);
        }
        this.vertical = this.xvalueVar != null;
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.groupVar != null && this.missingGroupOn) {
            this.probe.setMissingReplacement(this.groupVar instanceof NumericVariable ? StatGraph.missingOption : StatGraph.missingCharacter);
        }
        if (urlVar != null) {
            this.probe.addPipe("_URL_", (Pipe)((StringVariable)urlVar).value);
        }
        if (crd.isAvailable(300)) {
            this.addCustomTips(vp);
        } else {
            if (this.vertical) {
                this.addTooltip(vp, "X");
            } else {
                this.addTooltip(vp, "Y");
            }
            this.addTooltip(vp, "HIGH");
            this.addTooltip(vp, "LOW");
            this.addTooltip(vp, "OPEN");
            this.addTooltip(vp, "CLOSE");
            this.addTooltip(vp, "GROUP");
        }
        if (this.openVar != null) {
            this.openProbe = new Probe();
            if (this.vertical) {
                this.addTooltip(vp, "X", this.openProbe);
            } else {
                this.addTooltip(vp, "Y", this.openProbe);
            }
            this.addTooltip(vp, "OPEN", this.openProbe);
            this.addTooltip(vp, "GROUP", this.openProbe);
        }
        if (this.closeVar != null) {
            this.closeProbe = new Probe();
            if (this.vertical) {
                this.addTooltip(vp, "X", this.closeProbe);
            } else {
                this.addTooltip(vp, "Y", this.closeProbe);
            }
            this.addTooltip(vp, "CLOSE", this.closeProbe);
            this.addTooltip(vp, "GROUP", this.closeProbe);
        }
        if (this.highCapVar != null || this.highCap > 0) {
            this.highProbe = new Probe();
            if (this.vertical) {
                this.addTooltip(vp, "X", this.highProbe);
            } else {
                this.addTooltip(vp, "Y", this.highProbe);
            }
            this.addTooltip(vp, "HIGH", this.highProbe);
            this.addTooltip(vp, "GROUP", this.highProbe);
        }
        if (this.lowCapVar != null || this.lowCap > 0) {
            this.lowProbe = new Probe();
            if (this.vertical) {
                this.addTooltip(vp, "X", this.lowProbe);
            } else {
                this.addTooltip(vp, "Y", this.lowProbe);
            }
            this.addTooltip(vp, "LOW", this.lowProbe);
            this.addTooltip(vp, "GROUP", this.lowProbe);
        }
        this.verifyHighLowData();
    }

    private void verifyHighLowData() {
        int n = this.highVar.getValueCount();
        for (int i = 0; i < n; ++i) {
            try {
                double high = ((NumericVariable)this.highVar).value.getValue(i);
                double low = ((NumericVariable)this.lowVar).value.getValue(i);
                if (!(low > high)) continue;
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "highlowflip.txt"));
                break;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    protected void updateXRange() {
        Object newRange = null;
        DataRange oldRange = this.xRange;
        if (this.xvalueVar != null) {
            int num;
            int n = num = this.numericX ? this.xvalueVar.getValueCount() : this.xvalueVar.getUniqueValueCount();
            if (num > 0) {
                newRange = this.numericX ? this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, !this.xUnionAllPages) : (this.numericDiscreteX ? this.makeOrdinalRange((StringVariable)this.xvalueVar, num, (NumericVariable)this.numericXVar, (short)10, !this.xUnionAllPages) : this.makeDiscreteRange((StringVariable)this.xvalueVar, num, (short)10, !this.xUnionAllPages));
                newRange.setLabel(this.xvalueVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 10);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    protected void updateYRange() {
        Object newRange = null;
        DataRange oldRange = this.yRange;
        if (this.yvalueVar != null) {
            int num;
            int n = num = this.numericY ? this.yvalueVar.getValueCount() : this.yvalueVar.getUniqueValueCount();
            if (num > 0) {
                newRange = this.numericY ? this.makeContinuousRange((NumericVariable)this.yvalueVar, (short)11, !this.yUnionAllPages) : (this.numericDiscreteY ? this.makeOrdinalRange((StringVariable)this.yvalueVar, num, (NumericVariable)this.numericYVar, (short)11, !this.yUnionAllPages) : this.makeDiscreteRange((StringVariable)this.yvalueVar, num, (short)11, !this.yUnionAllPages));
                newRange.setLabel(this.yvalueVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 11);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, (DataRange)newRange);
    }

    protected void updateHighRange() {
        DataRange newRange = null;
        DataRange oldRange = this.highRange;
        if (this.highVar != null) {
            int num = this.highVar.getValueCount();
            if (num > 0) {
                boolean unionAllPages = this.vertical ? this.yUnionAllPages : this.xUnionAllPages;
                newRange = this.makeContinuousRange((NumericVariable)this.highVar, (short)60, !unionAllPages);
                newRange.setLabel(this.highVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat(newRange, 60);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.highRange = newRange;
        byte dim = this.vertical ? (byte)2 : 1;
        this.fireRangeEvent(dim, oldRange, newRange);
    }

    protected void updateLowRange() {
        DataRange newRange = null;
        DataRange oldRange = this.lowRange;
        if (this.lowVar != null) {
            int num = this.lowVar.getValueCount();
            if (num > 0) {
                boolean unionAllPages = this.vertical ? this.yUnionAllPages : this.xUnionAllPages;
                newRange = this.makeContinuousRange((NumericVariable)this.lowVar, (short)61, !unionAllPages);
                newRange.setLabel(this.lowVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat(newRange, 61);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.lowRange = newRange;
        byte dim = this.vertical ? (byte)2 : 1;
        this.fireRangeEvent(dim, oldRange, newRange);
    }

    protected void updateOpenRange() {
        DataRange newRange = null;
        DataRange oldRange = this.openRange;
        if (this.openVar != null) {
            int num = this.openVar.getValueCount();
            if (num > 0) {
                boolean unionAllPages = this.vertical ? this.yUnionAllPages : this.xUnionAllPages;
                newRange = this.makeContinuousRange((NumericVariable)this.openVar, (short)62, !unionAllPages);
                newRange.setLabel(this.openVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat(newRange, 62);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.openRange = newRange;
        byte dim = this.vertical ? (byte)2 : 1;
        this.fireRangeEvent(dim, oldRange, newRange);
    }

    protected void updateCloseRange() {
        DataRange newRange = null;
        DataRange oldRange = this.closeRange;
        if (this.closeVar != null) {
            int num = this.closeVar.getValueCount();
            if (num > 0) {
                boolean unionAllPages = this.vertical ? this.yUnionAllPages : this.xUnionAllPages;
                newRange = this.makeContinuousRange((NumericVariable)this.closeVar, (short)63, !unionAllPages);
                newRange.setLabel(this.closeVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat(newRange, 63);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.closeRange = newRange;
        byte dim = this.vertical ? (byte)2 : 1;
        this.fireRangeEvent(dim, oldRange, newRange);
    }

    protected void updateColorRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.xRange;
        if (this.colorVar != null) {
            if (this.gradientColor) {
                double min = this.model.getColumnMin((short)6);
                double max = this.model.getColumnMax((short)6);
                newRange = new ContinuousRange(min, max);
                newRange.setLabel(this.colorVar.getLabel());
                this.setFormat((DataRange)newRange, 6);
            } else {
                int num = this.colorVar.getUniqueValueCount();
                if (num > 0) {
                    newRange = Overlay.makeDiscreteRange((StringVariable)this.colorVar, num);
                    newRange.setLabel(this.colorVar.getLabel());
                } else {
                    newRange = null;
                }
            }
        }
        this.colorRange = newRange;
        this.fireRangeEvent((byte)4, oldRange, (DataRange)newRange);
    }

    protected void updateLineColorRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.lineColorRange;
        if (this.lineColorVar != null) {
            if (this.gradientColor) {
                double min = this.model.getColumnMin((short)46);
                double max = this.model.getColumnMax((short)46);
                newRange = new ContinuousRange(min, max);
                newRange.setLabel(this.lineColorVar.getLabel());
                this.setFormat((DataRange)newRange, 46);
            } else {
                int num = this.lineColorVar.getUniqueValueCount();
                if (num > 0) {
                    newRange = Overlay.makeDiscreteRange((StringVariable)this.lineColorVar, num);
                    newRange.setLabel(this.lineColorVar.getLabel());
                } else {
                    newRange = null;
                }
            }
        }
        this.lineColorRange = newRange;
        this.fireRangeEvent((byte)17, oldRange, (DataRange)newRange);
    }

    protected void updateLineRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.lineRange;
        if (this.lineVar != null) {
            int num = this.lineVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.lineVar, num);
                newRange.setLabel(this.lineVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.lineRange = newRange;
        this.fireRangeEvent((byte)15, oldRange, (DataRange)newRange);
    }

    protected void updateFillPatternRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.fillPatternRange;
        if (this.fillPatternVar != null) {
            int num = this.fillPatternVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.fillPatternVar, num);
                newRange.setLabel(this.fillPatternVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.fillPatternRange = newRange;
        this.fireRangeEvent((byte)21, oldRange, (DataRange)newRange);
    }

    protected void updateFillPatternColorRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.fillPatternColorRange;
        if (this.fillPatternColorVar != null) {
            int num = this.fillPatternColorVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.fillPatternColorVar, num);
                newRange.setLabel(this.fillPatternColorVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.fillPatternColorRange = newRange;
        this.fireRangeEvent((byte)22, oldRange, (DataRange)newRange);
    }

    @Override
    public boolean connectNetwork() {
        int just;
        NumericProperty gap;
        Calculator respTrans;
        GTKFormat gtkFMT;
        SASFormat format;
        DiscreteAttrMapper groupAttrMapper;
        NumericPipe offsetPos;
        int i;
        double intvl;
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.xRange == null && this.yRange == null || this.highRange == null || this.lowRange == null) {
            return false;
        }
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        boolean reverseHighLow = this.vertical ? this.yEncoder.isReversed() : this.xEncoder.isReversed();
        ValueMap map = null;
        double maxBarSize = 0.0;
        double barSize = 0.0;
        double strideX = 0.0;
        double strideY = 0.0;
        double xCategoryOffsetValue = 0.0;
        double yCategoryOffsetValue = 0.0;
        if (this.vertical) {
            map = this.xEncoder.getValueMap();
            if (this.numericX) {
                if (!(map instanceof ContinuousRangeToNumericMap)) {
                    return false;
                }
                if (!(this.xvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                    this.xvalueMapper = new ContinuousRangeToNumericMapper();
                }
                ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)map);
                ((ContinuousRangeToNumericMapper)this.xvalueMapper).input.connectFrom(((NumericVariable)this.xvalueVar).value);
                intvl = this.getMinimumInterval((short)10);
                maxBarSize = intvl == 0.0 ? 0.25 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) : this.getDefaultIntervalBarSize(intvl, this.xEncoder, false);
                barSize = this.intervalBarWidth >= 0.0 ? this.intervalBarWidth : maxBarSize * this.getAdjustBarWidth();
                strideX = maxBarSize;
            } else {
                this.intervalBarWidth = -1.0;
                if (!(map instanceof StringToNumericMap)) {
                    return false;
                }
                if (!(this.xvalueMapper instanceof StringToNumericMapper)) {
                    this.xvalueMapper = new StringToNumericMapper();
                }
                ((StringToNumericMapper)this.xvalueMapper).setMap((StringToNumericMap)map);
                ((StringToNumericMapper)this.xvalueMapper).input.connectFrom(((StringVariable)this.xvalueVar).value);
                strideX = ((StringToNumericMap)map).getStrideValue();
                xCategoryOffsetValue = this.discreteOffset * strideX;
                if (this.xEncoder.isReversed()) {
                    xCategoryOffsetValue = -xCategoryOffsetValue;
                }
                barSize = strideX * this.getAdjustBarWidth();
                maxBarSize = strideX;
            }
            this.maximumStride = maxBarSize;
        } else {
            map = this.yEncoder.getValueMap();
            if (this.numericY) {
                if (!(map instanceof ContinuousRangeToNumericMap)) {
                    return false;
                }
                if (!(this.yvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                    this.yvalueMapper = new ContinuousRangeToNumericMapper();
                }
                ((ContinuousRangeToNumericMapper)this.yvalueMapper).setMap((ContinuousRangeToNumericMap)map);
                ((ContinuousRangeToNumericMapper)this.yvalueMapper).input.connectFrom(((NumericVariable)this.yvalueVar).value);
                intvl = this.getMinimumInterval((short)11);
                maxBarSize = intvl == 0.0 ? 0.25 * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) : this.getDefaultIntervalBarSize(intvl, this.yEncoder, false);
                barSize = this.intervalBarWidth >= 0.0 ? this.intervalBarWidth : maxBarSize * this.getAdjustBarWidth();
                strideY = maxBarSize;
            } else {
                this.intervalBarWidth = -1.0;
                if (!(map instanceof StringToNumericMap)) {
                    return false;
                }
                if (!(this.yvalueMapper instanceof StringToNumericMapper)) {
                    this.yvalueMapper = new StringToNumericMapper();
                }
                ((StringToNumericMapper)this.yvalueMapper).setMap((StringToNumericMap)map);
                ((StringToNumericMapper)this.yvalueMapper).input.connectFrom(((StringVariable)this.yvalueVar).value);
                strideY = ((StringToNumericMap)map).getStrideValue();
                yCategoryOffsetValue = this.discreteOffset * strideY;
                if (this.yEncoder.isReversed()) {
                    yCategoryOffsetValue = -yCategoryOffsetValue;
                }
                barSize = strideY * this.getAdjustBarWidth();
                maxBarSize = strideY;
            }
            this.maximumStride = maxBarSize;
        }
        if (this.groupVar != null && this.groupDisplay == 0) {
            double categoryOffsetValue;
            NumericMapper catMapper;
            Variable catVar;
            double stride;
            NumericVector groupPosition = new NumericVector();
            int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
            if (this.vertical) {
                stride = strideX;
                catVar = this.xvalueVar;
                catMapper = this.xvalueMapper;
                categoryOffsetValue = xCategoryOffsetValue;
            } else {
                stride = strideY;
                catVar = this.yvalueVar;
                catMapper = this.yvalueMapper;
                categoryOffsetValue = yCategoryOffsetValue;
            }
            double groupSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
            barSize = groupSize * this.getAdjustBarWidth();
            this.maximumStride = maxBarSize = groupSize;
            this.groupVar.getUniqueValueCount();
            for (i = 0; i < catVar.getValueCount(); ++i) {
                try {
                    if (catVar instanceof NumericVariable) {
                        ((NumericVariable)catVar).value.getValue(i);
                    }
                    int category = catVar instanceof StringVariable ? ((StringVariable)catVar).category.getValue(i) : ((NumericVariable)catVar).category.getValue(i);
                    double offset = catMapper.getValue(i);
                    int groupCategory = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category.getValue(i) : ((StringVariable)this.groupVar).category.getValue(i);
                    offset -= (double)((int)(((double)this.groupsPerCategory[category] / 2.0 - 0.5) * groupSize));
                    groupPosition.addValue(offset += groupSize * (double)this.groupCategoryLists[category].indexOf(groupCategory));
                    continue;
                }
                catch (MissingValueException e) {
                    groupPosition.addValue(Double.NaN);
                }
            }
            offsetPos = this.makeOffsetCalculator(categoryOffsetValue, (NumericPipe)groupPosition);
            if (catVar instanceof NumericVariable && this.intervalBarWidth >= 0.0) {
                barSize = this.intervalBarWidth;
            }
        } else {
            offsetPos = this.vertical ? this.makeOffsetCalculator(xCategoryOffsetValue, (NumericPipe)this.xvalueMapper) : this.makeOffsetCalculator(yCategoryOffsetValue, (NumericPipe)this.yvalueMapper);
        }
        ValueMap valueMap = map = this.vertical ? this.yEncoder.getValueMap() : this.xEncoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        double clipMin = ((ContinuousRangeToNumericMap)map).getOutputMin();
        double clipMax = ((ContinuousRangeToNumericMap)map).getOutputMax();
        this.highMapper = new ContinuousRangeToNumericMapper();
        ((ContinuousRangeToNumericMapper)this.highMapper).setMap((ContinuousRangeToNumericMap)map);
        ((ContinuousRangeToNumericMapper)this.highMapper).input.connectFrom(((NumericVariable)this.highVar).value);
        this.lowMapper = new ContinuousRangeToNumericMapper();
        ((ContinuousRangeToNumericMapper)this.lowMapper).setMap((ContinuousRangeToNumericMap)map);
        ((ContinuousRangeToNumericMapper)this.lowMapper).input.connectFrom(((NumericVariable)this.lowVar).value);
        if (this.openVar != null) {
            this.openMapper = new ContinuousRangeToNumericMapper();
            ((ContinuousRangeToNumericMapper)this.openMapper).setMap((ContinuousRangeToNumericMap)map);
            ((ContinuousRangeToNumericMapper)this.openMapper).input.connectFrom(((NumericVariable)this.openVar).value);
        }
        if (this.closeVar != null) {
            this.closeMapper = new ContinuousRangeToNumericMapper();
            ((ContinuousRangeToNumericMapper)this.closeMapper).setMap((ContinuousRangeToNumericMap)map);
            ((ContinuousRangeToNumericMapper)this.closeMapper).input.connectFrom(((NumericVariable)this.closeVar).value);
        }
        StringToColorMapper colorMapper = null;
        if (this.colorVar != null && this.colorEncoder != null) {
            if (this.gradientColor) {
                ContinuousRangeToColorMapper crtcm = new ContinuousRangeToColorMapper();
                crtcm.setMap((ContinuousRangeToColorMap)this.colorEncoder.getValueMap());
                crtcm.input.connectFrom(((NumericVectorVariable)this.colorVar).value);
                colorMapper = crtcm;
                colorMapper.setReplaceMissingValues(true);
                colorMapper.setMissingReplacement(this.missingColorResponseColor);
            } else {
                map = this.colorEncoder.getValueMap();
                if (map instanceof StringToColorMap) {
                    StringToColorMapper stcm;
                    colorMapper = stcm = new StringToColorMapper();
                    stcm.input.connectFrom(((StringVectorVariable)this.colorVar).value);
                    stcm.setReplaceMissingValues(true);
                    if (this.gIndexVar == null) {
                        stcm.setMap((StringToColorMap)map);
                    } else {
                        for (int i2 = 0; i2 < this.colorVar.getUniqueValueCount(); ++i2) {
                            Color c = this.getIndexColor(this.colorEncoder, this.colorVar, i2, (ColorAttr)this.fillStyle);
                            try {
                                String gval = ((StringVariable)this.colorVar).uniqueValue.getValue(i2);
                                stcm.add(gval, c);
                                continue;
                            }
                            catch (MissingValueException e) {
                                stcm.setMissingReplacement(c, e.getMissingValue());
                            }
                        }
                    }
                } else {
                    return false;
                }
            }
        }
        StringToColorMapper lineColorMapper = null;
        if (this.lineColorVar != null && this.lineColorEncoder != null) {
            if (this.gradientColor) {
                ContinuousRangeToColorMapper crtcm = new ContinuousRangeToColorMapper();
                crtcm.setMap((ContinuousRangeToColorMap)this.lineColorEncoder.getValueMap());
                crtcm.input.connectFrom(((NumericVectorVariable)this.lineColorVar).value);
                lineColorMapper = crtcm;
                lineColorMapper.setReplaceMissingValues(true);
                lineColorMapper.setMissingReplacement(this.missingColorResponseColor);
            } else {
                map = this.lineColorEncoder.getValueMap();
                if (map instanceof StringToColorMap) {
                    StringToColorMapper stcm;
                    lineColorMapper = stcm = new StringToColorMapper();
                    stcm.input.connectFrom(((StringVectorVariable)this.lineColorVar).value);
                    stcm.setReplaceMissingValues(true);
                    if (this.gIndexVar == null) {
                        stcm.setMap((StringToColorMap)map);
                    } else {
                        for (int i3 = 0; i3 < this.lineColorVar.getUniqueValueCount(); ++i3) {
                            Color c = this.getIndexColor(this.lineColorEncoder, this.lineColorVar, i3, (ColorAttr)this.lineStyle);
                            try {
                                String gval = ((StringVariable)this.lineColorVar).uniqueValue.getValue(i3);
                                stcm.add(gval, c);
                                continue;
                            }
                            catch (MissingValueException e) {
                                stcm.setMissingReplacement(c, e.getMissingValue());
                            }
                        }
                    }
                } else {
                    return false;
                }
            }
        }
        StringToNumberMapper lineWidthMapper = null;
        StringToNumberMapper linePatternMapper = null;
        if (this.lineVar != null && this.lineEncoder != null) {
            LineAttrs[] ll = this.lineEncoder.styleArray;
            HashMap ht = this.lineEncoder.styleList;
            lineWidthMapper = new StringToNumberMapper();
            linePatternMapper = new StringToNumberMapper();
            lineWidthMapper.input.connectFrom(((StringVariable)this.lineVar).value);
            linePatternMapper.input.connectFrom(((StringVariable)this.lineVar).value);
            lineWidthMapper.setReplaceMissingValues(true);
            lineWidthMapper.setLabelMissingValues(true);
            linePatternMapper.setReplaceMissingValues(true);
            linePatternMapper.setLabelMissingValues(true);
            for (i = 0; i < this.lineVar.getUniqueValueCount(); ++i) {
                LineAttrs ls;
                if (this.gIndexVar == null) {
                    try {
                        String lval = ((StringVariable)this.lineVar).uniqueValue.getValue(i);
                        ls = (LineAttrs)ht.get(lval);
                    }
                    catch (MissingValueException e) {
                        ls = this.lineStyle;
                    }
                } else {
                    int obs = ((StringVariable)this.lineVar).getFirstOccurringValueIndex(i);
                    try {
                        int idx = (int)((NumericVariable)this.gIndexVar).value.getValue(obs) - 1;
                        ls = ll[idx % ll.length];
                    }
                    catch (MissingValueException e) {
                        ls = this.lineStyle;
                    }
                }
                try {
                    String gval = ((StringVariable)this.lineVar).uniqueValue.getValue(i);
                    lineWidthMapper.add(gval, (Number)new Double(this.lineStyle.getWidth()));
                    linePatternMapper.add(gval, (Number)new Double(ls.getLinePattern()));
                    continue;
                }
                catch (MissingValueException e) {
                    lineWidthMapper.setMissingReplacement((double)this.lineStyle.getWidth(), e.getMissingValue());
                    linePatternMapper.setMissingReplacement((double)ls.getLinePattern(), e.getMissingValue());
                }
            }
        }
        StringToNumberMapper fillPatternMapper = null;
        StringToNumberMapper fillPatternWidthMapper = null;
        if (this.fillPatternVar != null && this.fillPatternEncoder != null) {
            int[] pat = this.fillPatternEncoder.patternArray;
            HashMap ht = this.fillPatternEncoder.patternList;
            fillPatternMapper = new StringToNumberMapper();
            fillPatternWidthMapper = new StringToNumberMapper();
            fillPatternMapper.input.connectFrom(((StringVariable)this.fillPatternVar).value);
            fillPatternWidthMapper.input.connectFrom(((StringVariable)this.fillPatternVar).value);
            fillPatternMapper.setReplaceMissingValues(true);
            fillPatternMapper.setLabelMissingValues(true);
            fillPatternWidthMapper.setReplaceMissingValues(true);
            fillPatternWidthMapper.setLabelMissingValues(true);
            for (int i4 = 0; i4 < this.fillPatternVar.getUniqueValueCount(); ++i4) {
                int p;
                if (this.gIndexVar == null) {
                    try {
                        String fpval = ((StringVariable)this.fillPatternVar).uniqueValue.getValue(i4);
                        p = (Integer)ht.get(fpval);
                    }
                    catch (MissingValueException e) {
                        p = this.fillPatternStyle.getPattern();
                    }
                } else {
                    int obs = ((StringVariable)this.fillPatternVar).getFirstOccurringValueIndex(i4);
                    try {
                        int idx = (int)((NumericVariable)this.gIndexVar).value.getValue(obs) - 1;
                        p = pat[idx % pat.length];
                    }
                    catch (MissingValueException e) {
                        p = this.fillPatternStyle.getPattern();
                    }
                }
                try {
                    String gval = ((StringVariable)this.fillPatternVar).uniqueValue.getValue(i4);
                    fillPatternWidthMapper.add(gval, (Number)new Double(FillPatternAttrs.getPatternWidth((int)p)));
                    fillPatternMapper.add(gval, (Number)new Double(BarOverlay.getGLFillPattern(p)));
                    continue;
                }
                catch (MissingValueException e) {
                    fillPatternWidthMapper.setMissingReplacement((double)FillPatternAttrs.getPatternWidth((int)p), e.getMissingValue());
                    fillPatternMapper.setMissingReplacement((double)BarOverlay.getGLFillPattern(p), e.getMissingValue());
                }
            }
        }
        StringToColorMapper fillPatternColorMapper = null;
        if (this.fillPatternColorVar != null && this.fillPatternColorEncoder != null) {
            StringToColorMapper stcm;
            map = this.fillPatternColorEncoder.getValueMap();
            fillPatternColorMapper = stcm = new StringToColorMapper();
            stcm.input.connectFrom(((StringVectorVariable)this.fillPatternColorVar).value);
            stcm.setReplaceMissingValues(true);
            if (this.gIndexVar == null) {
                stcm.setMap((StringToColorMap)map);
            } else {
                for (int i5 = 0; i5 < this.fillPatternColorVar.getUniqueValueCount(); ++i5) {
                    Color c = this.getIndexColor(this.fillPatternColorEncoder, this.fillPatternColorVar, i5, (ColorAttr)this.fillPatternStyle);
                    try {
                        String gval = ((StringVariable)this.fillPatternColorVar).uniqueValue.getValue(i5);
                        stcm.add(gval, c);
                        continue;
                    }
                    catch (MissingValueException e) {
                        stcm.setMissingReplacement(c, e.getMissingValue());
                    }
                }
            }
        }
        DiscreteAttrMapper discreteAttrMapper = groupAttrMapper = this.hasAttrVar("GROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("GROUP") : null;
        if (groupAttrMapper != null) {
            groupAttrMapper.setFillTransparency(this.getAttrTransparency((ColorAttr)this.fillStyle));
            groupAttrMapper.setUseFillTransparency(this.useFillTransparency);
            groupAttrMapper.setLineTransparency(this.dataTransparency);
            groupAttrMapper.variable = this.numericGroup ? ((NumericVectorVariable)this.groupVar).formattedValue : ((StringVectorVariable)this.groupVar).formattedValue;
            groupAttrMapper.fillColorMapper = colorMapper;
            groupAttrMapper.lineColorMapper = lineColorMapper != null ? lineColorMapper : fillPatternColorMapper;
            groupAttrMapper.linePatternMapper = linePatternMapper;
            groupAttrMapper.addLineThicknessPipe("line", this.lineStyle.getWidth());
        }
        ColorProperty color = new ColorProperty();
        if (this.colorVar != null && colorMapper != null) {
            if (this.hasAttrVar("COLORRESPONSE")) {
                double max;
                double min;
                RangeAttrMapper mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE");
                String error = mapper.createColorMapper(min = ((ContinuousRangeToColorMapper)colorMapper).getInputMin(), max = ((ContinuousRangeToColorMapper)colorMapper).getInputMax(), false);
                if (error != null) {
                    color.connectFrom((ColorPipe)colorMapper);
                    StatGraph.printWarning(error);
                } else {
                    mapper.setTransparency(this.dataTransparency);
                    mapper.variable = ((ContinuousRangeToColorMapper)colorMapper).input;
                    color.connectFrom(mapper.color);
                }
            } else if (groupAttrMapper != null && !this.gradientColor) {
                color.connectFrom(groupAttrMapper.fillColor);
            } else {
                color.connectFrom((ColorPipe)colorMapper);
            }
        } else {
            color.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
        }
        ColorProperty lineColor = new ColorProperty();
        if (this.lineColorVar != null && lineColorMapper != null && !this.useLineColor) {
            if (this.hasAttrVar("COLORRESPONSE")) {
                double max;
                double min;
                RangeAttrMapper mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE");
                String error = mapper.createColorMapper(min = ((ContinuousRangeToColorMapper)lineColorMapper).getInputMin(), max = ((ContinuousRangeToColorMapper)lineColorMapper).getInputMax(), true);
                if (error != null) {
                    lineColor.connectFrom((ColorPipe)lineColorMapper);
                    StatGraph.printWarning(error);
                } else {
                    mapper.setTransparency(this.dataTransparency);
                    mapper.variable = ((ContinuousRangeToColorMapper)lineColorMapper).input;
                    lineColor.connectFrom(mapper.color);
                }
            } else if (groupAttrMapper != null && !this.gradientColor) {
                lineColor.connectFrom((ColorPipe)groupAttrMapper.lineColor);
            } else {
                lineColor.connectFrom((ColorPipe)lineColorMapper);
            }
        } else {
            lineColor.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
        }
        NumericProperty linePattern = new NumericProperty();
        if (this.lineVar != null && linePatternMapper != null) {
            if (groupAttrMapper != null) {
                linePattern.connectFrom((IntegerPipe)groupAttrMapper.linePattern);
            } else {
                linePattern.connectFrom((NumericPipe)linePatternMapper);
            }
        } else {
            linePattern.setValue((double)this.lineStyle.getLinePattern());
        }
        NumericProperty lineWidth = new NumericProperty();
        if (!this.useLineThickness && this.hasAttrVar("GROUP")) {
            lineWidth.connectFrom((IntegerPipe)groupAttrMapper.lineThickness.get("line"));
        } else if (this.lineVar != null && lineWidthMapper != null) {
            lineWidth.connectFrom((NumericPipe)lineWidthMapper);
        } else {
            lineWidth.setValue((double)this.lineStyle.getWidth());
        }
        NumericProperty fillPatternWidth = new NumericProperty();
        IntegerProperty fillPattern = new IntegerProperty();
        if (this.fillPatternVar != null && fillPatternMapper != null) {
            fillPattern.connectFrom((NumericPipe)fillPatternMapper);
            fillPatternWidth.connectFrom((NumericPipe)fillPatternWidthMapper);
        } else {
            int p = this.fillPatternStyle.getPattern();
            fillPattern.setValue(BarOverlay.getGLFillPattern(p));
            fillPatternWidth.setValue((double)FillPatternAttrs.getPatternWidth((int)p));
        }
        ColorProperty fillPatternColor = new ColorProperty();
        if (this.fillPatternColorVar != null && fillPatternColorMapper != null) {
            if (groupAttrMapper != null) {
                fillPatternColor.connectFrom((ColorPipe)groupAttrMapper.lineColor);
            } else {
                fillPatternColor.connectFrom((ColorPipe)fillPatternColorMapper);
            }
        } else if (this.gradientColor && !this.isFillOn()) {
            fillPatternColor.connectFrom((ColorPipe)lineColorMapper);
        } else {
            fillPatternColor.setValue(this.applyDataTransparency(this.fillPatternStyle.getColor()));
        }
        ColorProperty labelColor = new ColorProperty();
        if (this.groupVar != null && !this.useLabelColor) {
            if (groupAttrMapper != null && !this.gradientColor) {
                labelColor.connectFrom((ColorPipe)groupAttrMapper.lineColor);
            } else if (lineColorMapper != null) {
                labelColor.connectFrom((ColorPipe)lineColorMapper);
            } else {
                labelColor.setValue(this.applyDataTransparency(this.labelStyle.getColor()));
            }
        } else {
            labelColor.setValue(this.applyDataTransparency(this.labelStyle.getColor()));
        }
        IntegerProperty highCapPipe = new IntegerProperty();
        if (this.isHighCapOn()) {
            this.createHighLowCapPipes(this.highCapVar, this.highCap, highCapPipe);
        }
        IntegerProperty lowCapPipe = new IntegerProperty();
        if (this.isLowCapOn()) {
            this.createHighLowCapPipes(this.lowCapVar, this.lowCap, lowCapPipe);
        }
        if ((format = this.xEncoder.getInput().getFormat()) != null) {
            gtkFMT = new GTKFormat((Format)format);
            if (this.xvalueVar != null) {
                this.xvalueVar.setFormat(gtkFMT);
            } else {
                this.highVar.setFormat(gtkFMT);
                this.lowVar.setFormat(gtkFMT);
                if (this.openVar != null) {
                    this.openVar.setFormat(gtkFMT);
                }
                if (this.closeVar != null) {
                    this.closeVar.setFormat(gtkFMT);
                }
            }
        }
        if ((format = this.yEncoder.getInput().getFormat()) != null) {
            gtkFMT = new GTKFormat((Format)format);
            if (this.yvalueVar != null) {
                this.yvalueVar.setFormat(gtkFMT);
            } else {
                this.highVar.setFormat(gtkFMT);
                this.lowVar.setFormat(gtkFMT);
                if (this.openVar != null) {
                    this.openVar.setFormat(gtkFMT);
                }
                if (this.closeVar != null) {
                    this.closeVar.setFormat(gtkFMT);
                }
            }
        }
        double capSize = 0.0;
        double openCloseSize = 0.0;
        if (this.type == BAR && this.intervalBarWidth < 0.0) {
            capSize = maxBarSize * this.barWidth;
            if (this.barWidth > 0.0 && this.adjustBarWidthRequired()) {
                barSize = Math.max(1.0, Math.min(capSize - 4.0, barSize));
            }
            openCloseSize = Math.max(this.getMinimumOpenCloseWidth(), (capSize - barSize) * 0.5);
            if (this.edgeOn) {
                openCloseSize += Math.floor((double)(this.lineStyle.getWidth() - 1) * 0.5);
            }
        } else {
            capSize = this.getHighLowCapSize();
            openCloseSize = this.getOpenCloseSize();
        }
        this.networkRoot.removeAllElements();
        this.loadSkinImage();
        HighLowBar bar = new HighLowBar();
        this.networkRoot.addElement((Element)bar);
        bar.setUserData((Object)this.probe);
        bar.setSubpixelRendering(this.subpixelRendering && this.type == BAR);
        bar.verticalOn.setValue(this.vertical);
        if (this.type == BAR) {
            bar.thickness.setValue(barSize);
        } else {
            bar.thickness.setValue(0.0);
        }
        bar.edgeOn.setValue(this.edgeOn || this.type == LINE);
        bar.fillOn.setValue(this.fillOn);
        bar.fillPatternOn.setValue(this.fillPatternOn);
        if (this.fillOn) {
            bar.color1.connectFrom((ColorPipe)color);
        } else {
            bar.color1.connectFrom((ColorPipe)lineColor);
        }
        if (this.edgeOn || this.type == LINE) {
            bar.edgeColor.connectFrom((ColorPipe)lineColor);
            bar.edgeWidth.connectFrom((NumericPipe)lineWidth);
            bar.edgePattern.connectFrom((NumericPipe)linePattern);
        }
        if (this.fillPatternOn) {
            bar.fillPatternType.connectFrom((IntegerPipe)fillPattern);
            bar.fillPatternWidth.connectFrom((NumericPipe)fillPatternWidth);
            bar.fillPatternColor.connectFrom((ColorPipe)fillPatternColor);
            bar.fillPatternScaleFactor.setValue(StatGraph.dataDPIScaleFactor);
        }
        bar.position.connectFrom(offsetPos);
        if (reverseHighLow) {
            bar.startValue.connectFrom((NumericPipe)this.highMapper);
            bar.endValue.connectFrom((NumericPipe)this.lowMapper);
        } else {
            bar.startValue.connectFrom((NumericPipe)this.lowMapper);
            bar.endValue.connectFrom((NumericPipe)this.highMapper);
        }
        if (this.openVar != null) {
            bar.openValue.connectFrom((NumericPipe)this.openMapper);
        }
        if (this.closeVar != null) {
            bar.closeValue.connectFrom((NumericPipe)this.closeMapper);
        }
        if (this.isHighCapOn()) {
            bar.highCap.connectFrom((IntegerPipe)highCapPipe);
        }
        if (this.isLowCapOn()) {
            bar.lowCap.connectFrom((IntegerPipe)lowCapPipe);
        }
        bar.openOn.setValue(this.openVar != null);
        bar.closeOn.setValue(this.closeVar != null);
        bar.highCapOn.setValue(this.isHighCapOn());
        bar.lowCapOn.setValue(this.isLowCapOn());
        if (this.edgeOn || this.type == LINE) {
            bar.openCloseWidth.connectFrom((NumericPipe)lineWidth);
            bar.openCloseColor.connectFrom((ColorPipe)lineColor);
        } else {
            bar.openCloseWidth.setValue(1.0);
            bar.openCloseColor.connectFrom((ColorPipe)color);
        }
        bar.openCloseThickness.setValue(openCloseSize);
        bar.capThickness.setValue(capSize);
        this.loadSkinImage();
        bar.setSkin(this.skinImage);
        bar.setPixelBenderImages(this.pixelBenderImages);
        bar.setSkinType(this.skinType);
        bar.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
        bar.setCapDisplayPolicy(this.getCapDisplayPolicy());
        bar.setClipCapOn(this.clipCap);
        bar.setClipCapShape(this.clipCapShape);
        bar.setClipMin(clipMin);
        bar.setClipMax(clipMax);
        if (this.highLabelVar != null) {
            RasterLabel highLabel = new RasterLabel();
            this.networkRoot.addElement((Element)highLabel);
            respTrans = new Calculator("inA + inB");
            gap = new NumericProperty();
            if (reverseHighLow) {
                gap.setValue((double)(-(this.extraPadding + this.getExtraSpace())));
            } else {
                gap.setValue((double)(this.extraPadding + this.getExtraSpace()));
            }
            respTrans.inA.connectFrom(this.getLabelResponsePipe(true, this.highMapper, this.lowMapper, clipMax, clipMin, reverseHighLow));
            respTrans.inB.connectFrom((NumericPipe)gap);
            if (this.vertical) {
                just = reverseHighLow ? 0 : 3;
                this.connectHighLowLabel(highLabel, this.highLabelVar, (NumericPipe)respTrans, offsetPos, labelColor, 1, just);
            } else {
                just = reverseHighLow ? 2 : 0;
                this.connectHighLowLabel(highLabel, this.highLabelVar, (NumericPipe)respTrans, offsetPos, labelColor, just, 1);
            }
        }
        if (this.lowLabelVar != null) {
            RasterLabel lowLabel = new RasterLabel();
            this.networkRoot.addElement((Element)lowLabel);
            respTrans = new Calculator("inA - inB");
            gap = new NumericProperty();
            if (reverseHighLow) {
                gap.setValue((double)(-(this.extraPadding + this.getExtraSpace())));
            } else {
                gap.setValue((double)(this.extraPadding + this.getExtraSpace()));
            }
            respTrans.inA.connectFrom(this.getLabelResponsePipe(false, this.highMapper, this.lowMapper, clipMax, clipMin, reverseHighLow));
            respTrans.inB.connectFrom((NumericPipe)gap);
            if (this.vertical) {
                just = reverseHighLow ? 3 : 0;
                this.connectHighLowLabel(lowLabel, this.lowLabelVar, (NumericPipe)respTrans, offsetPos, labelColor, 1, just);
            } else {
                just = reverseHighLow ? 0 : 2;
                this.connectHighLowLabel(lowLabel, this.lowLabelVar, (NumericPipe)respTrans, offsetPos, labelColor, just, 1);
            }
        }
        this.needConnect = false;
        return true;
    }

    private NumericPipe getLabelResponsePipe(boolean isHigh, NumericMapper highMapper, NumericMapper lowMapper, double clipMax, double clipMin, boolean reverse) {
        NumericVector nv = new NumericVector();
        int n = isHigh ? this.highVar.getValueCount() : this.lowVar.getValueCount();
        for (int i = 0; i < n; ++i) {
            try {
                double theValue;
                double high = highMapper.value.getValue(i);
                double low = lowMapper.value.getValue(i);
                double d = theValue = isHigh ? high : low;
                if (reverse) {
                    double temp = low;
                    low = high;
                    high = temp;
                }
                if (high < low) {
                    nv.addValue(Double.NaN);
                    continue;
                }
                if (this.clipCap) {
                    if (low >= clipMax || high <= clipMin) {
                        nv.addValue(Double.NaN);
                        continue;
                    }
                    if (theValue > clipMax) {
                        nv.addValue(clipMax);
                        continue;
                    }
                    if (theValue < clipMin) {
                        nv.addValue(clipMin);
                        continue;
                    }
                    nv.addValue(theValue);
                    continue;
                }
                nv.addValue(theValue);
                continue;
            }
            catch (MissingValueException e) {
                nv.addValue(Double.NaN);
            }
        }
        return nv;
    }

    private void createHighLowCapPipes(Variable capVar, int capType, IntegerProperty capTypePipe) {
        if (capVar != null) {
            IntegerVector capVec = new IntegerVector();
            for (int i = 0; i < capVar.getValueCount(); ++i) {
                int t;
                try {
                    t = HighLowOverlay.getCapType(((StringVariable)capVar).value.getValue(i));
                    if (!this.isValidCapType(t)) {
                        t = 0;
                    } else if (this.type == BAR && t != 0) {
                        t = 2;
                    }
                }
                catch (MissingValueException e) {
                    t = 0;
                }
                capVec.addValue(t);
            }
            capTypePipe.connectFrom((IntegerPipe)capVec);
        } else {
            if (!this.isValidCapType(capType)) {
                capType = 0;
            } else if (this.type == BAR && capType != 0) {
                capType = 2;
            }
            capTypePipe.setValue(capType);
        }
    }

    private boolean isValidCapType(int capType) {
        switch (capType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private boolean isHighCapOn() {
        return this.highCapVar != null || this.highCap > 0;
    }

    private boolean isLowCapOn() {
        return this.lowCapVar != null || this.lowCap > 0;
    }

    private double getAdjustBarWidth() {
        if (this.adjustBarWidthRequired()) {
            return this.barWidth * 0.6;
        }
        return this.barWidth;
    }

    private boolean adjustBarWidthRequired() {
        if (this.type != BAR || this.intervalBarWidth >= 0.0) {
            return false;
        }
        return this.openVar != null || this.closeVar != null || this.isHighCapOn() || this.isLowCapOn() || this.isClipCapOn();
    }

    private Color getIndexColor(ColorEncoder encoder, Variable colorVar, Variable indexVar, String val, ColorAttr defaultAttr) {
        Color c;
        int i;
        for (i = 0; i < colorVar.getUniqueValueCount(); ++i) {
            try {
                if (!((StringVariable)colorVar).uniqueValue.getValue(i).equals(val)) continue;
                break;
            }
            catch (MissingValueException mve) {
                return this.applyDataTransparency(defaultAttr);
            }
        }
        Color[] cl = encoder.colorArray;
        int obs = ((StringVariable)colorVar).getFirstOccurringValueIndex(i);
        try {
            int idx = (int)((NumericVariable)indexVar).value.getValue(obs) - 1;
            c = defaultAttr.getTransparency() < 0.0 ? this.applyDataTransparency(cl[idx % cl.length]) : Overlay.applyTransparency(cl[idx % cl.length], defaultAttr.getTransparency());
        }
        catch (MissingValueException e) {
            c = this.applyDataTransparency(defaultAttr);
        }
        return c;
    }

    private Color getIndexColor(ColorEncoder encoder, Variable colorvar, int i, ColorAttr defaultAttr) {
        Color c;
        Color[] cl = encoder.colorArray;
        int obs = ((StringVariable)colorvar).getFirstOccurringValueIndex(i);
        try {
            int idx = (int)((NumericVariable)this.gIndexVar).value.getValue(obs) - 1;
            c = defaultAttr.getTransparency() < 0.0 ? this.applyDataTransparency(cl[idx % cl.length]) : Overlay.applyTransparency(cl[idx % cl.length], defaultAttr.getTransparency());
        }
        catch (MissingValueException e) {
            c = this.applyDataTransparency(defaultAttr);
        }
        return c;
    }

    private void connectHighLowLabel(RasterLabel label, Variable labelVar, NumericPipe respTrans, NumericPipe position, ColorProperty labelColor, int justificationH, int justificationV) {
        label.string.connectFrom(labelVar.formattedValue);
        label.trimOn.setValue(true);
        if (this.vertical) {
            label.transform.translateX.connectFrom(position);
            label.transform.translateY.connectFrom(respTrans);
        } else {
            label.transform.translateY.connectFrom(position);
            label.transform.translateX.connectFrom(respTrans);
        }
        label.color.connectFrom((ColorPipe)labelColor);
        label.fontName.setValue(this.labelStyle.getFont().getName());
        label.fontSize.setValue(this.labelStyle.getFont().getSize());
        label.fontStyle.setValue(this.labelStyle.getFont().getStyle());
        label.horizontalJustification.setValue(justificationH);
        label.verticalJustification.setValue(justificationV);
    }

    private void loadSkinImage() {
        if (this.dataTransparency == 1.0) {
            this.skinImage = null;
            return;
        }
        if (!this.isFillOn() || this.isExtrudedOverlay()) {
            this.skinType = 0;
        }
        this.skinImage = this.getRectangularSkinImage(this.networkRoot, this.skinType, this.vertical);
        this.pixelBenderImages = this.loadPixelBenderImages(this.networkRoot, this.skinType, this.vertical ? 1 : 2);
    }

    @Override
    protected Image loadLegendSkinImage() {
        if (!this.isFillOn() || this.isExtrudedOverlay() || this.dataTransparency == 1.0) {
            return null;
        }
        return this.getLegendSkinImage(this.networkRoot, this.skinType);
    }

    @Override
    protected Image[] loadLegendPixelBenderImages() {
        if (!this.isFillOn() || this.isExtrudedOverlay() || this.dataTransparency == 1.0) {
            return null;
        }
        return this.loadLegendPixelBenderImages(this.networkRoot, this.skinType, 1);
    }

    @Override
    public Insets getPreferredInnerMargin() {
        int top;
        int left;
        int right = left = (int)Math.ceil(this.getPreferredOffset((byte)1) / 2.0);
        int bottom = top = (int)Math.ceil(this.getPreferredOffset((byte)2) / 2.0);
        if (this.highLabelVar != null || this.lowLabelVar != null) {
            Insets labelMargin = this.getPreferredInnerMarginWithLabels();
            left = Math.max(left, labelMargin.left);
            right = Math.max(right, labelMargin.right);
            top = Math.max(top, labelMargin.top);
            bottom = Math.max(bottom, labelMargin.bottom);
        }
        return new Insets(top, left, bottom, right);
    }

    private Insets getPreferredInnerMarginWithLabels() {
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
        this.extraPadding = (int)Math.ceil((double)fm.getHeight() * 0.15);
        if (!this.vertical) {
            this.extraPadding *= 2;
        }
        int fmHeight = fm.getHeight() + this.extraPadding * 2;
        double min = ((NumericVariable)this.lowVar).getMin();
        double max = ((NumericVariable)this.highVar).getMax();
        if (this.vertical) {
            double space;
            ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
            double ratio = Math.abs((map.getOutputMax() - map.getOutputMin()) / (map.getInputMax() - map.getInputMin()));
            if (this.yEncoder.isReversed()) {
                if (this.highLabelVar != null) {
                    space = (map.getInputMin() - max) * ratio;
                    if (space < -ZERO_VALUE) {
                        bottom = this.clipCap ? fmHeight : 0;
                    } else if (space < (double)fmHeight) {
                        bottom = (int)Math.ceil((double)fmHeight - space);
                    }
                }
                if (this.lowLabelVar != null) {
                    space = (min - map.getInputMax()) * ratio;
                    if (space < -ZERO_VALUE) {
                        top = this.clipCap ? fmHeight : 0;
                    } else if (space < (double)fmHeight) {
                        top = (int)Math.ceil((double)fmHeight - space);
                    }
                }
            } else {
                if (this.highLabelVar != null) {
                    space = (map.getInputMax() - max) * ratio;
                    if (space < -ZERO_VALUE) {
                        top = this.clipCap ? fmHeight : 0;
                    } else if (space < (double)fmHeight) {
                        top = (int)Math.ceil((double)fmHeight - space);
                    }
                }
                if (this.lowLabelVar != null) {
                    space = (min - map.getInputMin()) * ratio;
                    if (space < -ZERO_VALUE) {
                        bottom = this.clipCap ? fmHeight : 0;
                    } else if (space < (double)fmHeight) {
                        bottom = (int)Math.ceil((double)fmHeight - space);
                    }
                }
            }
            double[] offsetsH = new double[]{0.0, 0.0};
            double[] offsetsL = new double[]{0.0, 0.0};
            if (this.highLabelVar != null) {
                offsetsH = this.getLeftRightOffsets(this.highLabelVar, this.numericHighLabel, fm);
            }
            if (this.lowLabelVar != null) {
                offsetsL = this.getLeftRightOffsets(this.lowLabelVar, this.numericLowLabel, fm);
            }
            left = (int)Math.ceil(Math.max(offsetsH[0], offsetsL[0]));
            right = (int)Math.ceil(Math.max(offsetsH[1], offsetsL[1]));
            top += this.getExtraSpace();
            bottom += this.getExtraSpace();
        } else {
            double x;
            double xv2;
            double xv;
            double w;
            String s;
            int i;
            ContinuousRangeToNumericMap xmap = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
            double leftmost = this.xEncoder.getOutputMin();
            double rightmost = this.xEncoder.getOutputMax();
            double startOffset = 0.0;
            double endOffset = 0.0;
            if (this.highLabelVar != null) {
                for (i = 0; i < this.highLabelVar.getValueCount(); ++i) {
                    try {
                        s = this.numericHighLabel ? ((NumericVariable)this.highLabelVar).formattedValue.getValue(i).trim() : ((StringVariable)this.highLabelVar).formattedValue.getValue(i).trim();
                        w = fm.stringWidth(s) + this.extraPadding * 2;
                        xv = ((NumericVariable)this.highVar).value.getValue(i);
                        xv2 = ((NumericVariable)this.lowVar).value.getValue(i);
                        if (!this.isLabelShown(xv, xv2, xmap)) continue;
                        x = xmap.getValue(xv);
                        if (this.xEncoder.isReversed()) {
                            x = Math.max(leftmost, x);
                            startOffset = Math.max(startOffset, leftmost - (x - w));
                            continue;
                        }
                        x = Math.min(rightmost, x);
                        endOffset = Math.max(endOffset, x + w - rightmost);
                        continue;
                    }
                    catch (MissingValueException s2) {
                        // empty catch block
                    }
                }
            }
            if (this.lowLabelVar != null) {
                for (i = 0; i < this.lowLabelVar.getValueCount(); ++i) {
                    try {
                        s = this.numericLowLabel ? ((NumericVariable)this.lowLabelVar).formattedValue.getValue(i).trim() : ((StringVariable)this.lowLabelVar).formattedValue.getValue(i).trim();
                        w = fm.stringWidth(s) + this.extraPadding * 2;
                        xv = ((NumericVariable)this.lowVar).value.getValue(i);
                        xv2 = ((NumericVariable)this.highVar).value.getValue(i);
                        if (!this.isLabelShown(xv2, xv, xmap)) continue;
                        x = xmap.getValue(xv);
                        if (this.xEncoder.isReversed()) {
                            x = Math.min(rightmost, x);
                            endOffset = Math.max(endOffset, x + w - rightmost);
                            continue;
                        }
                        x = Math.max(leftmost, x);
                        startOffset = Math.max(startOffset, leftmost - (x - w));
                        continue;
                    }
                    catch (MissingValueException s3) {
                        // empty catch block
                    }
                }
            }
            left = (int)Math.ceil(startOffset);
            right = (int)Math.ceil(endOffset);
            double[] offsetsH = new double[]{0.0, 0.0};
            double[] offsetsL = new double[]{0.0, 0.0};
            if (this.highLabelVar != null) {
                offsetsH = this.getTopBottomOffsets(this.highLabelVar, this.numericHighLabel, fm);
            }
            if (this.lowLabelVar != null) {
                offsetsL = this.getTopBottomOffsets(this.lowLabelVar, this.numericLowLabel, fm);
            }
            bottom = (int)Math.ceil(Math.max(offsetsH[0], offsetsL[0]));
            top = (int)Math.ceil(Math.max(offsetsH[1], offsetsL[1]));
            left += this.getExtraSpace();
            right += this.getExtraSpace();
        }
        int pad = StatGraph.getExtraPadding();
        return new Insets(top + pad, left + pad, bottom + pad, right + pad);
    }

    private boolean isLabelShown(double high, double low, ContinuousRangeToNumericMap map) {
        double max = Math.max(map.getInputMin(), map.getInputMax());
        double min = Math.min(map.getInputMin(), map.getInputMax());
        if (high < low) {
            return false;
        }
        if (!this.clipCap && (high > max + ZERO_VALUE || low < min - ZERO_VALUE)) {
            return false;
        }
        return !this.clipCap || !(low > max + ZERO_VALUE) && !(high < min - ZERO_VALUE);
    }

    private int getExtraSpace() {
        if (this.type == LINE || this.type == BAR && !this.edgeOn) {
            return 0;
        }
        if (this.isOutlineInside()) {
            return 0;
        }
        return (int)Math.ceil((double)this.lineStyle.getWidth() * 0.5);
    }

    private boolean isOutlineInside() {
        return true;
    }

    private int getMaximumLabelWidth(Variable labVar, boolean numericLabel, FontMetrics fm) {
        int maxWidth = 0;
        for (int i = 0; i < labVar.getValueCount(); ++i) {
            try {
                String s = numericLabel ? ((NumericVariable)labVar).formattedValue.getValue(i).trim() : ((StringVariable)labVar).formattedValue.getValue(i).trim();
                int w = fm.stringWidth(s);
                if (w <= maxWidth) continue;
                maxWidth = w;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return maxWidth;
    }

    private double[] getLeftRightOffsets(Variable labVar, boolean numericLabel, FontMetrics fm) {
        int n;
        ValueMap xmap = this.xEncoder.getValueMap();
        double leftmost = this.xEncoder.getOutputMin();
        double rightmost = this.xEncoder.getOutputMax();
        double[] offsets = new double[]{0.0, 0.0};
        double discreteOffsetValue = 0.0;
        if (xmap instanceof StringToNumericMap && (n = ((StringToNumericMap)xmap).getUniqueValueCount()) > 1 && this.discreteOffset != 0.0) {
            discreteOffsetValue = this.discreteOffset * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) / (double)n;
            if (this.xEncoder.isReversed()) {
                discreteOffsetValue = -discreteOffsetValue;
            }
        }
        for (int i = 0; i < labVar.getValueCount(); ++i) {
            try {
                double x;
                double v = ((NumericVariable)this.highVar).value.getValue(i);
                double v2 = ((NumericVariable)this.lowVar).value.getValue(i);
                if (!this.isLabelShown(v, v2, (ContinuousRangeToNumericMap)this.yEncoder.getValueMap())) continue;
                String s = numericLabel ? ((NumericVariable)labVar).formattedValue.getValue(i).trim() : ((StringVariable)labVar).formattedValue.getValue(i).trim();
                double w2 = Math.ceil((double)fm.stringWidth(s) * 0.5);
                w2 += (double)this.extraPadding;
                if (this.numericX) {
                    double xv = ((NumericVariable)this.xvalueVar).value.getValue(i);
                    x = ((ContinuousRangeToNumericMap)xmap).getValue(xv);
                } else {
                    String xv = ((StringVariable)this.xvalueVar).value.getValue(i);
                    x = ((StringToNumericMap)xmap).getValue((Object)xv);
                }
                if (x < leftmost - ZERO_VALUE || x > rightmost + ZERO_VALUE) continue;
                if (this.groupVar != null && this.getGroupDisplay() == 0) {
                    double intvl;
                    double stride = this.numericX ? ((intvl = this.getMinimumInterval((short)10)) == 0.0 ? 0.25 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) : this.getDefaultIntervalBarSize(intvl, this.xEncoder, true)) : ((StringToNumericMap)xmap).getStrideValue();
                    int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                    double groupSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
                    int category = this.xvalueVar instanceof StringVariable ? ((StringVariable)this.xvalueVar).category.getValue(i) : ((NumericVariable)this.xvalueVar).category.getValue(i);
                    int groupCategory = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category.getValue(i) : ((StringVariable)this.groupVar).category.getValue(i);
                    x -= (double)((int)(((double)this.groupsPerCategory[category] / 2.0 - 0.5) * groupSize));
                    x += groupSize * (double)this.groupCategoryLists[category].indexOf(groupCategory);
                }
                offsets[0] = Math.max(offsets[0], leftmost - ((x += discreteOffsetValue) - w2));
                offsets[1] = Math.max(offsets[1], x + w2 - rightmost);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return offsets;
    }

    private double[] getTopBottomOffsets(Variable labVar, boolean numericLabel, FontMetrics fm) {
        int n;
        ValueMap ymap = this.yEncoder.getValueMap();
        double topmost = this.yEncoder.getOutputMax();
        double bottommost = this.yEncoder.getOutputMin();
        double[] offsets = new double[]{0.0, 0.0};
        double discreteOffsetValue = 0.0;
        if (ymap instanceof StringToNumericMap && (n = ((StringToNumericMap)ymap).getUniqueValueCount()) > 1 && this.discreteOffset != 0.0) {
            discreteOffsetValue = this.discreteOffset * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) / (double)n;
            if (this.yEncoder.isReversed()) {
                discreteOffsetValue = -discreteOffsetValue;
            }
        }
        int fmHeight2 = (int)Math.ceil(0.5 * (double)fm.getHeight()) + this.extraPadding;
        for (int i = 0; i < labVar.getValueCount(); ++i) {
            try {
                double y;
                String s;
                double v = ((NumericVariable)this.highVar).value.getValue(i);
                double v2 = ((NumericVariable)this.lowVar).value.getValue(i);
                if (!this.isLabelShown(v, v2, (ContinuousRangeToNumericMap)this.xEncoder.getValueMap()) || (s = numericLabel ? ((NumericVariable)labVar).formattedValue.getValue(i).trim() : ((StringVariable)labVar).formattedValue.getValue(i).trim()).trim().length() == 0) continue;
                if (this.numericY) {
                    double yv = ((NumericVariable)this.yvalueVar).value.getValue(i);
                    y = ((ContinuousRangeToNumericMap)ymap).getValue(yv);
                } else {
                    String yv = ((StringVariable)this.yvalueVar).value.getValue(i);
                    y = ((StringToNumericMap)ymap).getValue((Object)yv);
                }
                if (y < bottommost - ZERO_VALUE || y > topmost + ZERO_VALUE) continue;
                if (this.groupVar != null && this.getGroupDisplay() == 0) {
                    double intvl;
                    double stride = this.numericY ? ((intvl = this.getMinimumInterval((short)11)) == 0.0 ? 0.25 * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) : this.getDefaultIntervalBarSize(intvl, this.yEncoder, true)) : ((StringToNumericMap)ymap).getStrideValue();
                    int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                    double groupSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
                    int category = this.yvalueVar instanceof StringVariable ? ((StringVariable)this.yvalueVar).category.getValue(i) : ((NumericVariable)this.yvalueVar).category.getValue(i);
                    int groupCategory = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category.getValue(i) : ((StringVariable)this.groupVar).category.getValue(i);
                    y -= (double)((int)(((double)this.groupsPerCategory[category] / 2.0 - 0.5) * groupSize));
                    y += groupSize * (double)this.groupCategoryLists[category].indexOf(groupCategory);
                }
                offsets[0] = Math.max(offsets[0], bottommost - ((y += discreteOffsetValue) - (double)fmHeight2));
                offsets[1] = Math.max(offsets[1], y + (double)fmHeight2 - topmost);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return offsets;
    }

    private double getDefaultIntervalBarSize(double minInterval, PositionEncoder encoder, boolean estimate) {
        return this.getMaximumIntervalSize(minInterval, encoder, estimate);
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        ValueMap vm;
        this.maximumStride = -1.0;
        double offset = 0.0;
        int lw = this.lineStyle.getWidth();
        if (!this.useLineThickness && this.hasAttrVar("GROUP")) {
            DiscreteAttrMapper dam = (DiscreteAttrMapper)this.getAttrVarMapper("Group");
            lw = Math.max(dam.getMaxLineThickness(), lw);
        }
        if (this.vertical) {
            if (dimension == 1) {
                vm = this.xEncoder.getValueMap();
                if (vm instanceof StringToNumericMap) {
                    int n = ((StringToNumericMap)vm).getUniqueValueCount();
                    if (n == 0) {
                        return 0.0;
                    }
                    if (n > 1) {
                        offset = (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) / (double)n;
                        if (this.type == LINE) {
                            double dist = 0.0;
                            if (this.groupVar != null && this.getGroupDisplay() == 0) {
                                double stride = offset;
                                int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                                double groupSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
                                dist = ((double)maxGroups / 2.0 - 0.5) * groupSize;
                            }
                            double size = this.getHighLowCapSize();
                            offset = Math.max(offset, size + dist * 2.0);
                        }
                        if (this.discreteOffset != 0.0) {
                            double d = Math.abs(this.discreteOffset);
                            double L = this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit();
                            double offsetValue = d * L / ((double)(n - 1) + 2.0 * d);
                            offset += offsetValue;
                        }
                        offset += this.discreteOffsetPadding ? (double)(2 * StatGraph.getExtraPadding()) : 0.0;
                    } else {
                        offset = 0.25 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit());
                    }
                } else if (this.groupVar != null && this.getGroupDisplay() == 0) {
                    double intvl = this.getMinimumInterval((short)10);
                    if (intvl == 0.0) {
                        offset = 0.25 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit());
                    } else {
                        int maxGroups;
                        double groupSize;
                        double highlowSize = this.type == LINE ? this.getHighLowCapSize() : (this.type == BAR && this.intervalBarWidth >= 0.0 ? this.intervalBarWidth + 2.0 * this.getOpenCloseSize() : groupSize);
                        if (highlowSize > (groupSize = (offset = this.getDefaultIntervalBarSize(intvl, this.xEncoder, true)) / (double)(maxGroups = ((Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID)).intValue()))) {
                            offset += highlowSize - groupSize;
                        }
                        offset += (double)(2 * StatGraph.getExtraPadding());
                    }
                } else if (this.type == LINE) {
                    offset = this.getHighLowCapSize();
                    offset += (double)(2 * StatGraph.getExtraPadding());
                } else if (this.type == BAR && this.intervalBarWidth >= 0.0) {
                    offset = this.intervalBarWidth + 2.0 * (this.getOpenCloseSize() + (double)StatGraph.getExtraPadding());
                } else {
                    double intvl = this.getMinimumInterval((short)10);
                    if (intvl > 0.0) {
                        offset = this.getDefaultIntervalBarSize(intvl, this.xEncoder, true);
                        offset += (double)(2 * StatGraph.getExtraPadding());
                    } else {
                        offset = 0.25 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit());
                    }
                }
                offset += (double)lw;
            } else if (dimension == 2) {
                offset = 2 * (StatGraph.getExtraPadding() + this.getExtraSpace());
            }
        } else if (dimension == 1) {
            offset = 2 * (StatGraph.getExtraPadding() + this.getExtraSpace());
        } else if (dimension == 2) {
            vm = this.yEncoder.getValueMap();
            if (vm instanceof StringToNumericMap) {
                int n = ((StringToNumericMap)vm).getUniqueValueCount();
                if (n == 0) {
                    return 0.0;
                }
                if (n > 1) {
                    offset = (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) / (double)n;
                    if (this.type == LINE) {
                        double dist = 0.0;
                        if (this.groupVar != null && this.getGroupDisplay() == 0) {
                            double stride = offset;
                            int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                            double groupSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
                            dist = ((double)maxGroups / 2.0 - 0.5) * groupSize;
                        }
                        double size = this.getHighLowCapSize();
                        offset = Math.max(offset, size + dist * 2.0);
                    }
                    if (this.discreteOffset != 0.0) {
                        double d = Math.abs(this.discreteOffset);
                        double L = this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit();
                        double offsetValue = d * L / ((double)(n - 1) + 2.0 * d);
                        offset += offsetValue;
                    }
                    offset += this.discreteOffsetPadding ? (double)(2 * StatGraph.getExtraPadding()) : 0.0;
                } else {
                    offset = 0.25 * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit());
                }
            } else if (this.groupVar != null && this.getGroupDisplay() == 0) {
                double intvl = this.getMinimumInterval((short)11);
                if (intvl == 0.0) {
                    offset = 0.25 * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit());
                } else {
                    int maxGroups;
                    double groupSize;
                    double highlowSize = this.type == LINE ? this.getHighLowCapSize() : (this.type == BAR && this.intervalBarWidth >= 0.0 ? this.intervalBarWidth + 2.0 * this.getOpenCloseSize() : groupSize);
                    if (highlowSize > (groupSize = (offset = this.getDefaultIntervalBarSize(intvl, this.yEncoder, true)) / (double)(maxGroups = ((Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID)).intValue()))) {
                        offset += highlowSize - groupSize;
                    }
                    offset += (double)(2 * StatGraph.getExtraPadding());
                }
            } else if (this.type == LINE) {
                offset = this.getHighLowCapSize();
                offset += (double)(2 * StatGraph.getExtraPadding());
            } else if (this.type == BAR && this.intervalBarWidth >= 0.0) {
                offset = this.intervalBarWidth + 2.0 * (this.getOpenCloseSize() + (double)StatGraph.getExtraPadding());
            } else {
                double intvl = this.getMinimumInterval((short)11);
                if (intvl > 0.0) {
                    offset = this.getDefaultIntervalBarSize(intvl, this.yEncoder, true);
                    offset += (double)(2 * StatGraph.getExtraPadding());
                } else {
                    offset = 0.25 * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit());
                }
            }
            offset += (double)lw;
        }
        return offset;
    }

    @Override
    public String[] getUniqueValues(short role) {
        StringVectorVariable group = (StringVectorVariable)this.connectCategory(role, true);
        VariableProcessor vp = new VariableProcessor();
        vp.addVariable((Variable)group);
        if (this.groupVar != null) {
            Variable rawGroup = this.connectRaw((short)3);
            vp.addVariable(rawGroup);
            if (this.getGroupOrder() != 0 && this.getGroupOrder() != 3) {
                int sort;
                int n = sort = this.getGroupOrder() == 1 ? 1 : 2;
                if (this.groupVar instanceof NumericVariable) {
                    vp.setSort(rawGroup, sort);
                } else {
                    vp.setSort((Variable)group, sort);
                }
            }
            if (!this.missingGroupOn) {
                vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
            }
        }
        String[] gv = new String[group.getUniqueValueCount()];
        for (int i = 0; i < gv.length; ++i) {
            try {
                if (this.groupOrder == 3) {
                    gv[i] = group.uniqueValue.getValue(gv.length - 1 - i);
                    continue;
                }
                gv[i] = group.uniqueValue.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return gv;
    }

    @Override
    public int[] getLinePatterns() {
        if (this.lineVar != null && (this.type == BAR && !this.fillOn || this.type == LINE)) {
            return this.getGroupPatterns();
        }
        return new int[]{this.lineStyle.getLinePattern()};
    }

    @Override
    public int[] getLineWidths() {
        if (this.useLineThickness || !this.hasAttrVar("GROUP")) {
            return new int[]{this.lineStyle.getWidth()};
        }
        return this.getDAttrLineThickness("GROUP", this.getGroupValues(), this.lineStyle.getWidth());
    }

    @Override
    public Color[] getLineColors() {
        if (this.type == BAR && !this.isEdgeOn()) {
            return new Color[0];
        }
        if (this.isGradientColor() || this.lineColorVar == null || this.useLineColor) {
            return new Color[]{this.applyDataTransparency(this.lineStyle.getColor())};
        }
        return this.getGroupColors(false);
    }

    @Override
    public Color[] getFillColors() {
        if (this.type == LINE || !this.isFillOn()) {
            return new Color[0];
        }
        if (this.isGradientColor() || this.colorVar == null) {
            return new Color[]{this.applyDataTransparency((ColorAttr)this.fillStyle)};
        }
        return this.getGroupColors(true);
    }

    @Override
    public int[] getFillPatterns() {
        if (this.type == LINE || !this.isFillPatternOn()) {
            return new int[0];
        }
        if (this.fillPatternVar == null) {
            return new int[]{this.fillPatternStyle.getPattern()};
        }
        int[] pl = this.fillPatternEncoder.patternArray;
        HashMap ht = this.fillPatternEncoder.patternList;
        String[] values = this.getUniqueValues((short)111);
        StringVectorVariable fillPatternVar = null;
        NumericVectorVariable indexVar = null;
        if (this.gIndexVar != null) {
            indexVar = (NumericVectorVariable)this.connectRaw((short)44);
            fillPatternVar = (StringVectorVariable)this.connectCategory((short)111, true);
            if (!this.missingGroupOn || this.getGroupOrder() == 1 || this.getGroupOrder() == 2) {
                int sort;
                VariableProcessor vp = new VariableProcessor();
                Variable rawGroup = this.connectRaw((short)3);
                vp.addVariable((Variable)fillPatternVar);
                vp.addVariable((Variable)indexVar);
                vp.addVariable(rawGroup);
                int n = sort = this.getGroupOrder() == 1 ? 1 : 2;
                if (this.groupVar instanceof NumericVariable) {
                    vp.setSort(rawGroup, sort);
                } else {
                    vp.setSort((Variable)fillPatternVar, sort);
                }
                vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
            }
        }
        int[] pattern = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            String gval = values[i];
            if (this.gIndexVar == null) {
                pattern[i] = (Integer)ht.get(values[i]);
                continue;
            }
            int obs = this.groupOrder == 3 ? ((StringVariable)fillPatternVar).getFirstOccurringValueIndex(values.length - 1 - i) : ((StringVariable)fillPatternVar).getFirstOccurringValueIndex(i);
            try {
                int idx = (int)((NumericVariable)indexVar).value.getValue(obs) - 1;
                pattern[i] = pl[idx % pl.length];
                continue;
            }
            catch (MissingValueException e) {
                pattern[i] = this.fillPatternStyle.getPattern();
            }
        }
        return pattern;
    }

    @Override
    public Color[] getFillPatternColors() {
        if (this.type == LINE || !this.isFillPatternOn()) {
            return new Color[0];
        }
        if (this.isGradientColor() || this.fillPatternColorVar == null) {
            return new Color[]{this.applyDataTransparency((ColorAttr)this.fillPatternStyle)};
        }
        NumericVectorVariable indexVar = null;
        StringVectorVariable colorVar = null;
        Color[] colors = new Color[]{};
        HashMap ht = this.fillPatternColorEncoder.colorList;
        String[] values = this.getUniqueValues((short)112);
        if (this.gIndexVar != null) {
            indexVar = (NumericVectorVariable)this.connectRaw((short)44);
            colorVar = (StringVectorVariable)this.connectCategory((short)112, true);
            if (!this.missingGroupOn) {
                VariableProcessor vp = new VariableProcessor();
                Variable rawGroup = this.connectRaw((short)3);
                vp.addVariable((Variable)colorVar);
                vp.addVariable((Variable)indexVar);
                vp.addVariable(rawGroup);
                vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
            }
        }
        colors = new Color[values.length];
        for (int i = 0; i < values.length; ++i) {
            DiscreteAttrMapper groupAttrMapper;
            Color c;
            String gval = values[i];
            if (this.hasAttrVar("GROUP") && (c = (groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP")).getLineColor(gval)) != null) {
                colors[i] = this.applyDataTransparency(c);
            }
            if (colors[i] != null) continue;
            colors[i] = this.gIndexVar == null ? (Color)ht.get(gval) : this.getIndexColor(this.fillPatternColorEncoder, this.fillPatternColorVar, (Variable)indexVar, gval, (ColorAttr)this.fillPatternStyle);
        }
        return colors;
    }

    @Override
    public String[] getGroupValues() {
        if (this.groupVar != null) {
            if (this.groupOrder == 0 || this.groupOrder == 3) {
                return this.getUniqueGroupValues((short)3);
            }
            return this.getUniqueGroupValues((short)3, this.groupOrder == 1 ? 1 : 2);
        }
        return new String[0];
    }

    public Color[] getGroupColors(boolean fill) {
        NumericVectorVariable indexVar = null;
        StringVectorVariable colorVar = null;
        Color[] colors = new Color[]{};
        if (fill) {
            HashMap ht = this.colorEncoder.colorList;
            String[] values = this.getUniqueValues((short)6);
            if (this.gIndexVar != null) {
                indexVar = (NumericVectorVariable)this.connectRaw((short)44);
                colorVar = (StringVectorVariable)this.connectCategory((short)6, true);
                if (!this.missingGroupOn) {
                    VariableProcessor vp = new VariableProcessor();
                    Variable rawGroup = this.connectRaw((short)3);
                    vp.addVariable((Variable)colorVar);
                    vp.addVariable((Variable)indexVar);
                    vp.addVariable(rawGroup);
                    vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
                }
            }
            colors = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                DiscreteAttrMapper groupAttrMapper;
                Color c;
                String gval = values[i];
                if (this.hasAttrVar("GROUP") && (c = (groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP")).getFillColor(gval)) != null) {
                    colors[i] = this.useFillTransparency ? this.applyDataTransparency(c) : HighLowOverlay.applyTransparency(c, groupAttrMapper.getFillTransparency(gval));
                }
                if (colors[i] != null) continue;
                colors[i] = this.gIndexVar == null ? (Color)ht.get(gval) : this.getIndexColor(this.colorEncoder, (Variable)colorVar, (Variable)indexVar, gval, (ColorAttr)this.fillStyle);
            }
        } else {
            HashMap ht = this.lineColorEncoder.colorList;
            String[] values = this.getUniqueValues((short)46);
            if (this.gIndexVar != null) {
                indexVar = (NumericVectorVariable)this.connectRaw((short)44);
                colorVar = (StringVectorVariable)this.connectCategory((short)46, true);
                if (!this.missingGroupOn) {
                    VariableProcessor vp = new VariableProcessor();
                    Variable rawGroup = this.connectRaw((short)3);
                    vp.addVariable((Variable)colorVar);
                    vp.addVariable((Variable)indexVar);
                    vp.addVariable(rawGroup);
                    vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
                }
            }
            colors = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                DiscreteAttrMapper groupAttrMapper;
                Color c;
                String gval = values[i];
                if (this.hasAttrVar("GROUP") && (c = (groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP")).getLineColor(gval)) != null) {
                    colors[i] = this.applyDataTransparency(c);
                }
                if (colors[i] != null) continue;
                colors[i] = this.gIndexVar == null ? (Color)ht.get(gval) : this.getIndexColor(this.lineColorEncoder, (Variable)colorVar, (Variable)indexVar, gval, (ColorAttr)this.lineStyle);
            }
        }
        return colors;
    }

    private int[] getGroupPatterns() {
        LineAttrs[] ll = this.lineEncoder.styleArray;
        HashMap ht = this.lineEncoder.styleList;
        String[] values = this.getUniqueValues((short)36);
        StringVectorVariable lineVar = null;
        NumericVectorVariable indexVar = null;
        if (this.gIndexVar != null) {
            indexVar = (NumericVectorVariable)this.connectRaw((short)44);
            lineVar = (StringVectorVariable)this.connectCategory((short)36, true);
            if (!this.missingGroupOn || this.getGroupOrder() == 1 || this.getGroupOrder() == 2) {
                int sort;
                VariableProcessor vp = new VariableProcessor();
                Variable rawGroup = this.connectRaw((short)3);
                vp.addVariable((Variable)lineVar);
                vp.addVariable((Variable)indexVar);
                vp.addVariable(rawGroup);
                int n = sort = this.getGroupOrder() == 1 ? 1 : 2;
                if (this.groupVar instanceof NumericVariable) {
                    vp.setSort(rawGroup, sort);
                } else {
                    vp.setSort((Variable)lineVar, sort);
                }
                vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
            }
        }
        int[] pattern = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            pattern[i] = -1;
            String gval = values[i];
            if (this.hasAttrVar("GROUP")) {
                DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                pattern[i] = groupAttrMapper.getLinePattern(gval);
            }
            if (pattern[i] != -1) continue;
            if (this.gIndexVar == null) {
                pattern[i] = ((LineAttrs)ht.get(gval)).getLinePattern();
                continue;
            }
            int obs = this.groupOrder == 3 ? ((StringVariable)lineVar).getFirstOccurringValueIndex(values.length - 1 - i) : ((StringVariable)lineVar).getFirstOccurringValueIndex(i);
            try {
                int idx = (int)((NumericVariable)indexVar).value.getValue(obs) - 1;
                pattern[i] = ll[idx % ll.length].getLinePattern();
                continue;
            }
            catch (MissingValueException e) {
                pattern[i] = this.lineStyle.getLinePattern();
            }
        }
        return pattern;
    }

    @Override
    public boolean hasLegend(int attrType) {
        switch (attrType) {
            case 0: {
                return this.groupVar != null || !this.isGradientColor();
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return true;
            }
            case 7: 
            case 11: {
                return this.fillOn;
            }
        }
        return false;
    }

    @Override
    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        if (this.type == LINE || !this.fillOn) {
            return 10;
        }
        return this.edgeOn ? 11 : 7;
    }

    @Override
    protected void applyDataSkin(LegendItem[] items) {
        if (this.type == BAR && !this.fillOn || this.skinType == 0) {
            return;
        }
        Image legendSkin = this.loadLegendSkinImage();
        Image[] legendPixelBender = this.loadLegendPixelBenderImages();
        for (int i = 0; i < items.length; ++i) {
            items[i].setPixelBenderImages(legendPixelBender);
            items[i].setSkinType(this.skinType);
            items[i].setSkinImage(legendSkin);
        }
    }

    @Override
    protected void applyFillTransparency(LegendItem[] items) {
        if (this.type == LINE || !this.fillOn || !this.useFillTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(items[i].getSymbolAttrs().getColor(), this.fillStyle.getTransparency()));
            items[i].setSymbolAttrs((ColorAttr)fa);
        }
    }

    @Override
    protected void applyLineTransparency(LegendItem[] items) {
        if (this.type == BAR && this.fillOn || !this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            LineAttrs old = (LineAttrs)items[i].getSymbolAttrs();
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(old.getColor()));
            la.setLinePattern(old.getLinePattern());
            la.setWidth(old.getWidth());
            items[i].setSymbolAttrs((ColorAttr)la);
        }
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        if (this.isLegendEntryFromAttrMap("GROUP")) {
            return this.getLegendItemsWithAttrMap(this.fixDefaultAttrType(attrType));
        }
        return super.getLegendItems(attrType);
    }

    @Override
    protected boolean isMargeAttrMapRequired(int type) {
        switch (type) {
            case 12: {
                return this.getType() == BAR && this.fillOn && this.colorVar != null && !this.isGradientColor();
            }
            case 5: {
                return this.getType() == BAR && this.fillPatternOn && this.fillPatternVar != null && this.fillPatternEncoder != null;
            }
            case 14: {
                return this.getType() == BAR && this.fillPatternOn && this.fillPatternColorVar != null && this.fillPatternColorEncoder != null;
            }
            case 11: {
                return (this.getType() == LINE || this.getType() == BAR && this.edgeOn) && this.lineColorVar != null && !this.useLineColor && !this.isGradientColor();
            }
            case 3: {
                return (this.getType() == LINE || this.getType() == BAR && !this.fillOn) && this.lineVar != null;
            }
            case 4: {
                return !this.useLineThickness;
            }
        }
        return false;
    }

    @Override
    protected FillAttrs getAttrMapDefaultFillAttrs() {
        return this.fillStyle;
    }

    @Override
    protected LineAttrs getAttrMapDefaultLineAttrs() {
        return this.lineStyle;
    }

    @Override
    protected FillPatternAttrs getAttrMapDefaultFillPatternAttrs() {
        return this.fillPatternStyle;
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return !this.model.isAvailable(3);
    }

    @Override
    public String getDefaultLegendTitle() {
        if (this.isDegeneratedLegendContributor()) {
            return null;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(3);
        return cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
    }

    @Override
    protected int getNumberOfDrawingElements() {
        return this.highVar.getValueCount();
    }

    public boolean isGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(boolean gradientColor) {
        this.gradientColor = gradientColor;
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
            case 4: {
                return this.colorEncoder;
            }
            case 17: {
                return this.lineColorEncoder;
            }
            case 15: {
                return this.lineEncoder;
            }
            case 22: {
                return this.fillPatternColorEncoder;
            }
            case 21: {
                return this.fillPatternEncoder;
            }
        }
        return null;
    }

    @Override
    public Range[] getColorModelRanges(int type) {
        if (type == 1 || !this.gradientColor) {
            return null;
        }
        ColorEncoder ce = (ColorEncoder)this.getEncoder((byte)4);
        if (ce != null && ce.getInput() instanceof ContinuousRange) {
            double max;
            double min;
            RangeAttrMapper mapper;
            String error;
            ContinuousRange range = (ContinuousRange)ce.getInput();
            if (this.hasAttrVar("COLORRESPONSE") && (error = (mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE")).createColorMapper(min = ((NumericVariable)this.colorVar).getMin(), max = ((NumericVariable)this.colorVar).getMax())) == null) {
                return mapper.getRangeColorMapper().getFullRanges(this.dataTransparency);
            }
            Color[] colors = ce.rampColors;
            Range[] colorModelRanges = new Range[1];
            RangeBound low = new RangeBound(range.getMin(), true);
            RangeBound high = new RangeBound(range.getMax(), true);
            ColorModel colorModel = new ColorModel(colors);
            colorModelRanges[0] = new Range(low, high, colorModel);
            return colorModelRanges;
        }
        ColorEncoder le = (ColorEncoder)this.getEncoder((byte)17);
        if (le != null && le.getInput() instanceof ContinuousRange) {
            double max;
            double min;
            RangeAttrMapper mapper;
            String error;
            ContinuousRange range = (ContinuousRange)le.getInput();
            if (this.hasAttrVar("COLORRESPONSE") && (error = (mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE")).createColorMapper(min = ((NumericVariable)this.lineColorVar).getMin(), max = ((NumericVariable)this.lineColorVar).getMax(), true)) == null) {
                return mapper.getRangeColorMapper().getFullRanges(this.dataTransparency);
            }
            Color[] colors = le.rampColors;
            Range[] colorModelRanges = new Range[1];
            RangeBound low = new RangeBound(range.getMin(), true);
            RangeBound high = new RangeBound(range.getMax(), true);
            ColorModel colorModel = new ColorModel(colors);
            colorModelRanges[0] = new Range(low, high, colorModel);
            return colorModelRanges;
        }
        return null;
    }

    @Override
    public SASFormat getContinuousLegendFormat() {
        ColorEncoder ce = null;
        if (this.model.isAvailable(6)) {
            ce = (ColorEncoder)this.getEncoder((byte)4);
        } else if (this.model.isAvailable(46)) {
            ce = (ColorEncoder)this.getEncoder((byte)17);
        }
        if (ce != null && ce.getInput() instanceof ContinuousRange) {
            return ce.getInput().getFormat();
        }
        return null;
    }

    @Override
    public String getDefaultContinuousLegendTitle() {
        String title = null;
        if (!this.gradientColor) {
            return null;
        }
        if (this.model.isAvailable(6)) {
            ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(45);
            title = cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
        } else if (this.model.isAvailable(46)) {
            ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(46);
            title = cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
        }
        return title;
    }

    @Override
    public void resetToInitialValues() {
        this.useFillTransparency = false;
        this.useLineThickness = false;
        this.useMarkerSize = false;
        this.useMarkerTransparency = false;
        this.useMarkerWeight = false;
        this.useLineColor = false;
        this.useLabelColor = false;
        this.gradientColor = false;
        this.attrVarMap.clear();
        this.lineColorEncoder = null;
        this.colorEncoder = null;
        this.lineEncoder = null;
        this.colorRange = null;
        this.lineColorRange = null;
        this.lineRange = null;
        this.groupVar = null;
        this.gIndexVar = null;
        this.colorVar = null;
        this.lineColorVar = null;
        this.lineVar = null;
        this.stringGroupVar = null;
        this.fillStyle = new FillAttrs();
        this.lineStyle = new LineAttrs();
        this.labelStyle = new TextAttrs();
        this.type = LINE;
        this.fillOn = true;
        this.edgeOn = true;
        this.groupDisplay = 1;
        this.groupsPerCategory = null;
        this.groupCategoryLists = null;
        this.subToColumnGroupCategory = null;
    }

    public Color getMissingColorResponseColor() {
        return this.missingColorResponseColor;
    }

    public void setMissingColorResponseColor(Color missingColorResponseColor) {
        this.missingColorResponseColor = missingColorResponseColor;
    }

    @Override
    public boolean hasMissingValue() {
        int clrvIDX;
        if (!this.gradientColor) {
            return false;
        }
        CRD crd = this.model;
        if (this.type == BAR && this.isFillOn()) {
            if (!crd.isAvailable(6)) {
                return false;
            }
            clrvIDX = this.model.getSrcModel().getColumn(this.model.getColumnName((short)6));
        } else {
            if (!crd.isAvailable(46)) {
                return false;
            }
            clrvIDX = this.model.getSrcModel().getColumn(this.model.getColumnName((short)46));
        }
        ColumnMetadata cmd = (ColumnMetadata)this.model.getSrcModel().getColumnLabel(clrvIDX);
        return cmd.getMissings() > 0;
    }

    @Override
    public Color getMissingColor() {
        return this.missingColorResponseColor;
    }
}

