/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.MapIDCompositePipe;
import com.sas.graphics.applets.statgraph.sgchart.overlays.MapRegionLayerOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.render.map.MapObject;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;

public class EmbeddedMapRegionLayerOverlay
extends MapRegionLayerOverlay {
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    protected DataRange responseRange = null;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder colorEncoder;
    private NetworkRoot networkRoot;
    private MapObject mapObject = new MapObject();
    private Variable responseVar;
    private Variable colorGroupVar;
    protected DataModel mapData;
    private String[] mapIDVars;
    private String mapXVar;
    private String mapYVar;
    private String mapSegmentVar;

    public MapObject getMapObject() {
        return this.mapObject;
    }

    public DataModel getMapDataModel() {
        return this.mapData;
    }

    public void setMapDataModel(DataModel mapData) {
        this.mapData = mapData;
    }

    public String[] getMapIDVars() {
        return this.mapIDVars;
    }

    public void setMapIDVars(String[] mapIDVars) {
        this.mapIDVars = mapIDVars;
    }

    public String getMapXVar() {
        return this.mapXVar;
    }

    public void setMapXVar(String mapXVar) {
        this.mapXVar = mapXVar;
    }

    public String getMapYVar() {
        return this.mapYVar;
    }

    public void setMapYVar(String mapYVar) {
        this.mapYVar = mapYVar;
    }

    public String getMapSegmentVar() {
        return this.mapSegmentVar;
    }

    public void setMapSegmentVar(String mapSegmentVar) {
        this.mapSegmentVar = mapSegmentVar;
    }

    public double getMapXMin() {
        int xcol = this.mapData.getColumn(this.mapXVar);
        ColumnMetadata cmd = (ColumnMetadata)this.mapData.getColumnLabel(xcol);
        return cmd.getMin();
    }

    public double getMapXMax() {
        int xcol = this.mapData.getColumn(this.mapXVar);
        ColumnMetadata cmd = (ColumnMetadata)this.mapData.getColumnLabel(xcol);
        return cmd.getMax();
    }

    public double getMapYMin() {
        int ycol = this.mapData.getColumn(this.mapYVar);
        ColumnMetadata cmd = (ColumnMetadata)this.mapData.getColumnLabel(ycol);
        return cmd.getMin();
    }

    public double getMapYMax() {
        int ycol = this.mapData.getColumn(this.mapYVar);
        ColumnMetadata cmd = (ColumnMetadata)this.mapData.getColumnLabel(ycol);
        return cmd.getMax();
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                return this.yRange;
            }
            case 4: {
                this.updateResponseRange();
                return this.responseRange;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.mapObject.setChannel(channel);
        this.networkRoot = new NetworkRoot(channel);
        this.connectVars();
        this.updateXRange();
        this.updateYRange();
        this.updateResponseRange();
    }

    private ContinuousRange getResponseRange() {
        if (!this.model.isAvailable(2)) {
            return null;
        }
        double min = this.model.getColumnMin((short)2);
        double max = this.model.getColumnMax((short)2);
        return new ContinuousRange(min, max);
    }

    private DiscreteRange getColorGroupRange() {
        if (!this.model.isAvailable(107)) {
            return null;
        }
        DiscreteRange newRange = null;
        Variable colorVar = this.connectRaw((short)107);
        if (colorVar != null) {
            boolean numericVar = this.model.getColumnClass(107) == Double.class;
            int num = colorVar.getUniqueValueCount();
            Object[] vals = new Object[num];
            if (numericVar) {
                for (int i = 0; i < num; ++i) {
                    try {
                        vals[i] = ((NumericVectorVariable)colorVar).uniqueValue.getValue(i);
                        continue;
                    }
                    catch (Exception mve) {
                        vals[i] = "";
                    }
                }
            } else {
                for (int i = 0; i < num; ++i) {
                    try {
                        vals[i] = ((StringVectorVariable)colorVar).uniqueValue.getValue(i);
                        continue;
                    }
                    catch (Exception mve) {
                        vals[i] = "";
                    }
                }
            }
            newRange = new DiscreteRange(vals);
            newRange.setLabel(colorVar.getLabel());
        }
        return newRange;
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        }
        if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        }
        if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.colorEncoder)) {
                return;
            }
            this.colorEncoder = (ColorEncoder)encoder;
            if (this.model.isAvailable(2)) {
                Color[] ramp = new Color[]{this.colorEncoder.startColor, this.colorEncoder.mediumColor, this.colorEncoder.endColor};
                this.mapObject.setRampColors(ramp);
                ContinuousRange rRange = this.getResponseRange();
                double min = rRange.getMin();
                double max = rRange.getMax();
                double neutral = (min + max) / 2.0;
                double[] rampval = new double[]{min, neutral, max};
                this.mapObject.setRampValues(rampval);
                this.mapObject.setDiscrete(false);
            } else if (this.model.isAvailable(107)) {
                if (!(encoder instanceof ColorEncoder)) {
                    return;
                }
                this.colorEncoder = (ColorEncoder)encoder;
                this.mapObject.setRampColors(this.colorEncoder.colorArray);
                Variable colorVar = this.connectRaw((short)107);
                if (colorVar != null) {
                    boolean numericVar = this.model.getColumnClass(107) == Double.class;
                    int num = colorVar.getUniqueValueCount();
                    Object[] vals = new Object[num];
                    if (numericVar) {
                        for (int i = 0; i < num; ++i) {
                            try {
                                vals[i] = ((NumericVectorVariable)colorVar).formattedUniqueValue.getValue(i);
                                continue;
                            }
                            catch (Exception mve) {
                                vals[i] = "";
                            }
                        }
                    } else {
                        for (int i = 0; i < num; ++i) {
                            try {
                                vals[i] = ((StringVectorVariable)colorVar).uniqueValue.getValue(i);
                                continue;
                            }
                            catch (Exception mve) {
                                vals[i] = "";
                            }
                        }
                    }
                    this.mapObject.setDiscrete(true);
                    this.mapObject.setDiscreteColors(this.colorEncoder.colorArray);
                    this.mapObject.setDiscreteValues(vals);
                }
            }
        }
        this.needConnect = true;
    }

    @Override
    public void draw(Graphics g) {
        ContinuousRangeToNumericMap xmap = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
        double x1in = xmap.getInputMin();
        double x2in = xmap.getInputMax();
        double x1out = xmap.getOutputMin();
        double x2out = xmap.getOutputMax();
        ContinuousRangeToNumericMap ymap = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
        double y1in = ymap.getInputMin();
        double y2in = ymap.getInputMax();
        double y1out = ymap.getOutputMin();
        double y2out = ymap.getOutputMax();
        double win = x2in - x1in;
        double hin = y2in - y1in;
        double wout = x2out - x1out - 1.0;
        double hout = y2out - y1out - 1.0;
        Channel channel = this.networkRoot.getChannel();
        channel.glPushAttrib(0);
        channel.glEdgeFlag(true);
        channel.glPushMatrix();
        channel.glTranslate(x1out, y1out, 0.0);
        channel.glScale(wout / win, hout / hin, 0.0);
        channel.glTranslate(-x1in, -y1in, 0.0);
        channel.setClip(g.getClipBounds());
        this.mapObject.draw();
        channel.glPopMatrix();
        channel.glPopAttrib();
    }

    protected void connectVars() {
        int xcol = this.mapData.getColumn(this.mapXVar);
        NumericVectorVariable xVar = new NumericVectorVariable();
        xVar.connectFrom(this.mapData.getDoubleColumn(xcol));
        this.mapObject.setXVariable((NumericVariable)xVar);
        int ycol = this.mapData.getColumn(this.mapYVar);
        NumericVectorVariable yVar = new NumericVectorVariable();
        yVar.connectFrom(this.mapData.getDoubleColumn(ycol));
        this.mapObject.setYVariable((NumericVariable)yVar);
        if (this.mapSegmentVar != null) {
            int scol = this.mapData.getColumn(this.mapSegmentVar);
            NumericVectorVariable sVar = new NumericVectorVariable();
            sVar.connectFrom(this.mapData.getDoubleColumn(scol));
            this.mapObject.setSegmentVariable((NumericVariable)sVar);
        }
        MapIDCompositePipe cat = new MapIDCompositePipe();
        for (int i = 0; i < this.mapIDVars.length; ++i) {
            int idcol = this.mapData.getColumn(this.mapIDVars[i]);
            StringVectorVariable outVar = new StringVectorVariable();
            outVar.connectFrom(this.mapData.getColumnAsClassColumn(idcol, true));
            outVar.setBlankMissing(false);
            cat.addInput((Pipe)outVar.value);
        }
        StringVectorVariable sv = new StringVectorVariable();
        sv.connectFrom(cat.value);
        this.mapObject.setMapStringIDVariable((StringVariable)sv);
        CRD crd = this.model;
        if (crd.isAvailable(600)) {
            cat = new MapIDCompositePipe();
            int cnt = 0;
            while (crd.isAvailable(600 + cnt)) {
                int r = 600 + cnt;
                StringVectorVariable v = (StringVectorVariable)this.connectCategory((short)r, true);
                cat.addInput((Pipe)v.value);
                ++cnt;
            }
            sv = new StringVectorVariable();
            sv.connectFrom(cat.value);
            this.mapObject.setResponseStringIDVariable((StringVariable)sv);
        }
        if (crd.isAvailable(2)) {
            this.responseVar = this.connectRaw((short)2);
            this.mapObject.setColorVariable((NumericVariable)this.responseVar);
        } else {
            this.responseVar = null;
        }
        if (crd.isAvailable(107)) {
            boolean numericVar;
            this.colorGroupVar = this.connectRaw((short)107);
            boolean bl = numericVar = this.model.getColumnClass(107) == Double.class;
            if (numericVar) {
                this.mapObject.setColorVariable((NumericVariable)this.colorGroupVar);
            } else {
                this.mapObject.setColorStringVariable((StringVariable)this.colorGroupVar);
            }
        } else {
            this.colorGroupVar = null;
        }
    }

    protected void updateXRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.xRange;
        int xcol = this.mapData.getColumn(this.mapXVar);
        ColumnMetadata cmd = (ColumnMetadata)this.mapData.getColumnLabel(xcol);
        newRange = new ContinuousRange(this.getMapXMin(), this.getMapXMax());
        newRange.setFormat(cmd.getFormat());
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    protected void updateYRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.yRange;
        int ycol = this.mapData.getColumn(this.mapYVar);
        ColumnMetadata cmd = (ColumnMetadata)this.mapData.getColumnLabel(ycol);
        newRange = new ContinuousRange(cmd.getMin(), cmd.getMax());
        newRange.setFormat(cmd.getFormat());
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, (DataRange)newRange);
    }

    protected void updateResponseRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.responseRange;
        if (this.model.isAvailable(2)) {
            ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(2);
            newRange = this.getResponseRange();
            newRange.setFormat(cmd.getFormat());
        } else if (this.model.isAvailable(107)) {
            ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(107);
            newRange = this.getColorGroupRange();
            newRange.setFormat(cmd.getFormat());
        } else {
            return;
        }
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.responseRange = newRange;
    }

    @Override
    public Color[] getFillColors() {
        if (this.mapObject.getEmptyColor() != null) {
            return new Color[]{this.mapObject.getEmptyColor()};
        }
        return new Color[0];
    }

    @Override
    public Color[] getLineColors() {
        if (this.mapObject.isEmptyEdgesOn()) {
            return new Color[]{this.mapObject.getEmptyEdgeColor()};
        }
        return new Color[0];
    }

    @Override
    public int[] getLinePatterns() {
        if (this.mapObject.isEmptyEdgesOn()) {
            return new int[]{this.mapObject.getEmptyEdgePattern()};
        }
        return new int[0];
    }

    @Override
    public int[] getLineWidths() {
        if (this.mapObject.isEmptyEdgesOn()) {
            return new int[]{this.mapObject.getEmptyEdgeThickness()};
        }
        return new int[0];
    }

    public boolean hasColorResponse() {
        return this.model.isAvailable(2);
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
            case 4: {
                return this.colorEncoder;
            }
        }
        return null;
    }

    @Override
    public Range[] getColorModelRanges(int type) {
        RangeAttrMapper mapper;
        String error;
        if (type == 1) {
            return null;
        }
        ColorEncoder ce = (ColorEncoder)this.getEncoder((byte)4);
        if (ce == null || !(ce.getInput() instanceof ContinuousRange)) {
            return null;
        }
        ContinuousRange range = (ContinuousRange)ce.getInput();
        if (this.hasAttrVar("COLORRESPONSE") && (error = (mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE")).createColorMapper(range.getMin(), range.getMax())) == null) {
            return mapper.getRangeColorMapper().getFullRanges(this.dataTransparency);
        }
        Color[] colors = new Color[]{ce.startColor, ce.mediumColor, ce.endColor};
        Range[] colorModelRanges = new Range[1];
        RangeBound low = new RangeBound(range.getMin(), true);
        RangeBound high = new RangeBound(range.getMax(), true);
        ColorModel colorModel = new ColorModel(colors);
        colorModelRanges[0] = new Range(low, high, colorModel);
        return colorModelRanges;
    }

    @Override
    public SASFormat getContinuousLegendFormat() {
        ColorEncoder ce = (ColorEncoder)this.getEncoder((byte)4);
        if (ce != null && ce.getInput() instanceof ContinuousRange) {
            return ce.getInput().getFormat();
        }
        return null;
    }
}

