/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.labeling.LabelPlacementInterface;
import com.sas.graphics.applets.statgraph.sgchart.overlays.EllipseOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeMerger;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;

public class EllipseParmOverlay
extends Overlay {
    private int nGroups = 1;
    private int numEllipses = 1;
    protected EllipseOverlay[] ellipses = new EllipseOverlay[]{new EllipseOverlay()};
    protected int cCnt;
    protected Color[] lColors;
    protected int fCnt;
    protected Color[] fColors;
    protected int lCnt;
    protected LineAttrs[] lStyles;
    protected int fpcCnt;
    protected Color[] fpColors;
    protected int fpCnt;
    protected int[] fPatterns;
    public double[] colorIndex = null;
    public double[] fillColorIndex = null;
    public double[] styleIndex = null;
    public double[] fillPatternColorIndex = null;
    public double[] fillPatternIndex = null;
    private double constantXRadius = Double.NaN;
    private double constantYRadius = Double.NaN;
    private double constantXOrigin = Double.NaN;
    private double constantYOrigin = Double.NaN;
    private double constantSlope = Double.NaN;
    protected Color[] groupFillColors;
    protected Color[] groupLineColors;
    protected LineAttrs[] groupLineStyles;
    protected FillAttrs[] groupFillStyles;
    protected Color[] groupFillPatternColors;
    protected int[] groupFillPatterns;
    private boolean fillOn;
    private boolean edgeOn;
    private boolean fillPatternOn;
    private double fillTransparency = 0.0;
    private boolean labelProtected = false;
    private boolean fixedFillColor = false;
    private boolean fixedOutlineColor = false;
    private boolean fixedOutlinePattern = false;
    private boolean fixedFillPatternColor = false;
    private boolean fixedFillPattern = false;
    private LineAttrs missingLineAttrs = new LineAttrs();
    private FillAttrs missingFillAttrs = new FillAttrs();
    private FillPatternAttrs missingFillPatternAttrs = new FillPatternAttrs();
    private LineAttrs defaultLineAttrs = new LineAttrs();
    private FillAttrs defaultFillAttrs = new FillAttrs();
    private FillPatternAttrs defaultFillPatternAttrs = new FillPatternAttrs();
    private int styleColorCount = 1;
    private boolean colorPriority = false;

    public void setStyleColorCount(int count) {
        this.styleColorCount = count;
    }

    public int getStyleColorCount() {
        return this.styleColorCount;
    }

    public void setColorPriority(boolean b) {
        this.colorPriority = b;
    }

    public boolean isColorPriority() {
        return this.colorPriority;
    }

    public boolean isFixedFillColor() {
        return this.fixedFillColor;
    }

    public void setFixedFillColor(boolean fixedFillColor) {
        this.fixedFillColor = fixedFillColor;
    }

    public boolean isFixedOutlineColor() {
        return this.fixedOutlineColor;
    }

    public void setFixedOutlineColor(boolean fixedOutlineColor) {
        this.fixedOutlineColor = fixedOutlineColor;
    }

    public boolean isFixedOutlinePattern() {
        return this.fixedOutlinePattern;
    }

    public void setFixedOutlinePattern(boolean fixedOutlinePattern) {
        this.fixedOutlinePattern = fixedOutlinePattern;
    }

    public boolean isFixedFillPatternColor() {
        return this.fixedFillPatternColor;
    }

    public void setFixedFillPatternColor(boolean fixedFillPatternColor) {
        this.fixedFillPatternColor = fixedFillPatternColor;
    }

    public boolean isFixedFillPattern() {
        return this.fixedFillPattern;
    }

    public void setFixedFillPattern(boolean fixedFillPattern) {
        this.fixedFillPattern = fixedFillPattern;
    }

    public boolean isProtectedLine() {
        return this.labelProtected;
    }

    public void setProtectedLine(boolean b) {
        this.labelProtected = b;
    }

    public double getFillTransparency() {
        return this.fillTransparency;
    }

    public void setFillTransparency(double transparency) {
        this.fillTransparency = transparency;
    }

    private Color getIndexedColor(int i, int gi) {
        if (this.colorIndex != null) {
            gi = (int)this.colorIndex[i] - 1;
        }
        return this.lColors[(this.cCnt + gi) % this.lColors.length];
    }

    private Color getIndexedFillColor(int i, int gi) {
        if (this.fillColorIndex != null) {
            gi = (int)this.fillColorIndex[i] - 1;
        }
        return this.fColors[(this.fCnt + gi) % this.fColors.length];
    }

    private LineAttrs getIndexedStyle(int i, int gi) {
        if (this.styleIndex != null) {
            gi = (int)this.styleIndex[i] - 1;
        }
        if (this.colorPriority && this.styleColorCount > 0) {
            int colorCycle = this.lCnt + gi / this.styleColorCount;
            return this.lStyles[colorCycle % this.lStyles.length];
        }
        return this.lStyles[(this.lCnt + gi) % this.lStyles.length];
    }

    private Color getIndexedFillPatternColor(int i, int gi) {
        if (this.fillPatternColorIndex != null) {
            gi = (int)this.fillPatternColorIndex[i] - 1;
        }
        return this.fpColors[(this.fpcCnt + gi) % this.fpColors.length];
    }

    private int getIndexedFillPattern(int i, int gi) {
        if (this.fillPatternIndex != null) {
            gi = (int)this.fillPatternIndex[i] - 1;
        }
        if (this.colorPriority && this.styleColorCount > 0) {
            int colorCycle = this.fpCnt + gi / this.styleColorCount;
            return this.fPatterns[colorCycle % this.fPatterns.length];
        }
        return this.fPatterns[(this.fpCnt + gi) % this.fPatterns.length];
    }

    public void setFillColors(int cnt, Color[] colors) {
        this.fCnt = cnt;
        this.fColors = colors;
        if (this.ellipses == null) {
            return;
        }
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].needConnect = true;
        }
    }

    @Override
    public Color[] getFillColors() {
        if (this.isFillOn()) {
            if (this.groupFillColors == null) {
                return null;
            }
            Color[] cls = new Color[this.groupFillColors.length];
            for (int i = 0; i < cls.length; ++i) {
                cls[i] = this.useFillTransparency || !this.hasAttrVar("GROUP") ? this.applyDataTransparency(this.groupFillColors[i], this.fillTransparency) : EllipseParmOverlay.applyTransparency(this.groupFillColors[i], this.groupFillStyles[i].getTransparency());
            }
            return cls;
        }
        return new Color[0];
    }

    public void setLineColors(int cnt, Color[] colors) {
        this.cCnt = cnt;
        this.lColors = colors;
        if (this.ellipses == null) {
            return;
        }
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].needConnect = true;
        }
    }

    @Override
    public Color[] getLineColors() {
        if (this.isEdgeOn()) {
            if (this.groupLineColors == null) {
                return null;
            }
            Color[] cls = new Color[this.groupLineColors.length];
            for (int i = 0; i < cls.length; ++i) {
                cls[i] = this.applyDataTransparency(this.groupLineColors[i]);
            }
            return cls;
        }
        return new Color[0];
    }

    @Override
    public int[] getLinePatterns() {
        if (this.isEdgeOn()) {
            int[] lp = new int[this.nGroups];
            for (int i = 0; i < this.nGroups; ++i) {
                lp[i] = this.groupLineStyles[i].getLinePattern();
            }
            return lp;
        }
        return new int[0];
    }

    public void setFillPatternColors(int cnt, Color[] colors) {
        this.fpcCnt = cnt;
        this.fpColors = colors;
        if (this.ellipses == null) {
            return;
        }
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].needConnect = true;
        }
    }

    @Override
    public Color[] getFillPatternColors() {
        if (this.isFillPatternOn()) {
            if (this.groupFillPatternColors == null) {
                return null;
            }
            Color[] cls = new Color[this.groupFillPatternColors.length];
            for (int i = 0; i < cls.length; ++i) {
                cls[i] = this.applyDataTransparency(this.groupFillPatternColors[i]);
            }
            return cls;
        }
        return new Color[0];
    }

    public void setFillPatterns(int cnt, int[] patterns) {
        this.fpCnt = cnt;
        this.fPatterns = patterns;
        if (this.ellipses == null) {
            return;
        }
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].needConnect = true;
        }
    }

    @Override
    public int[] getFillPatterns() {
        if (this.isFillPatternOn()) {
            return this.groupFillPatterns;
        }
        return new int[0];
    }

    @Override
    public String[] getGroupValues() {
        if (this.model == null || this.model.getSrcMap().getColumn(3) < 0) {
            return new String[]{this.getLegendLabel()};
        }
        if (this.groupOrder == 1 || this.groupOrder == 2) {
            return this.getUniqueGroupValues((short)3, this.groupOrder == 1 ? 1 : 2);
        }
        return this.getUniqueGroupValues((short)3);
    }

    @Override
    public String[] getLineColorValues() {
        return this.getGroupValues();
    }

    @Override
    public String[] getLinePatternValues() {
        return this.getGroupValues();
    }

    public void setLineWidths(int width) {
        int i;
        for (i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].getLineStyle().setWidth(width);
            this.ellipses[i].needConnect = true;
        }
        if (this.groupLineStyles != null) {
            for (i = 0; i < this.nGroups; ++i) {
                this.groupLineStyles[i].setWidth(width);
            }
        }
    }

    @Override
    public int[] getLineWidths() {
        if (this.isEdgeOn()) {
            int[] lw = new int[this.nGroups];
            for (int i = 0; i < this.nGroups; ++i) {
                lw[i] = this.groupLineStyles[i].getWidth();
            }
            return lw;
        }
        return new int[0];
    }

    public void setLineStyles(int cnt, LineAttrs[] styles) {
        this.lCnt = cnt;
        this.lStyles = styles;
        if (this.ellipses == null) {
            return;
        }
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].needConnect = true;
        }
    }

    @Override
    public void addRangeChangeListener(RangeChangeListener l) {
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].addRangeChangeListener(l);
        }
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (this.numEllipses == 1) {
            return this.ellipses[0].getDataRange(dimension);
        }
        RangeMerger rm = new RangeMerger();
        for (int i = 0; i < this.numEllipses; ++i) {
            rm.addInputRange(this.ellipses[i].getDataRange(dimension));
        }
        return rm.getOutputRange();
    }

    @Override
    public void setChannel(Channel channel) {
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setChannel(channel);
        }
    }

    public boolean build() {
        return true;
    }

    @Override
    public void draw(Graphics g) {
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].draw(g);
        }
    }

    @Override
    public void select() {
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].select();
        }
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setEncoder(dimension, encoder);
        }
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        if (aModel != null && aModel.getSrcMap() != null) {
            double[] ngs;
            CRD crd = aModel;
            DataModel srcModel = crd.getSrcModel();
            RoleColumnMap map = crd.getSrcMap();
            int gcol = map.getColumn(3);
            int xcol = map.getColumn(37);
            int ycol = map.getColumn(38);
            int acol = map.getColumn(39);
            int bcol = map.getColumn(40);
            int scol = map.getColumn(30);
            String idLabel = null;
            Variable gVar = null;
            StringVectorVariable gcVar = null;
            int missingGroupIndex = -1;
            VariableProcessor vp = null;
            if (gcol >= 0) {
                boolean numeric = crd.getColumnClass(3) == Double.class;
                gVar = this.connectRaw((short)3);
                gcVar = (StringVectorVariable)this.connectCategory((short)3, true);
                if (this.groupOrder == 1 || this.groupOrder == 2) {
                    int sort;
                    vp = new VariableProcessor();
                    vp.addVariable(gVar);
                    vp.addVariable((Variable)gcVar);
                    int n = sort = this.groupOrder == 1 ? 1 : 2;
                    if (gVar instanceof NumericVariable) {
                        vp.setSort(gVar, sort);
                    } else {
                        vp.setSort((Variable)gcVar, sort);
                    }
                }
                gcVar.getUniqueValueCount();
                this.nGroups = gVar.getUniqueValueCount();
                ColumnMetadata gcmd = (ColumnMetadata)srcModel.getColumnLabel(gcol);
                idLabel = gcmd.getLabel();
                this.groupFillColors = new Color[this.nGroups];
                this.groupLineColors = new Color[this.nGroups];
                this.groupLineStyles = new LineAttrs[this.nGroups];
                this.groupFillStyles = new FillAttrs[this.nGroups];
                this.groupFillPatternColors = new Color[this.nGroups];
                this.groupFillPatterns = new int[this.nGroups];
                int n = 0;
                DiscreteAttrMapper groupAttrMapper = null;
                if (this.hasAttrVar("GROUP")) {
                    groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                }
                int gIdx = 0;
                for (int i = 0; i < this.nGroups; ++i) {
                    String gVal = null;
                    boolean missing = false;
                    try {
                        gVal = gcVar.uniqueValue.getValue(i);
                        if (gVar instanceof StringVariable) {
                            ((StringVariable)gVar).uniqueValue.getValue(i);
                        } else {
                            ((NumericVariable)gVar).uniqueValue.getValue(i);
                        }
                    }
                    catch (MissingValueException mve) {
                        if (!this.missingGroupOn) {
                            missingGroupIndex = i;
                            continue;
                        }
                        missing = true;
                    }
                    int idx = this.getFirstOccurringValueIndex(gVar, gIdx);
                    if (groupAttrMapper != null) {
                        int lt;
                        int p;
                        Color c;
                        this.groupFillColors[n] = this.fixedFillColor ? this.fColors[0] : ((c = groupAttrMapper.getFillColor(gVal)) != null ? c : (missing ? this.missingFillAttrs.getColor() : this.getIndexedFillColor(idx, gIdx)));
                        if (!this.useFillTransparency) {
                            this.groupFillStyles[n] = new FillAttrs();
                            double tr = groupAttrMapper.getFillTransparency(gVal);
                            this.groupFillStyles[n].setTransparency(tr);
                        }
                        this.groupLineColors[n] = this.fixedOutlineColor ? this.lColors[0] : ((c = groupAttrMapper.getLineColor(gVal)) != null ? c : (missing ? this.missingLineAttrs.getColor() : this.getIndexedColor(idx, gIdx)));
                        LineAttrs la = this.getIndexedStyle(idx, gIdx);
                        if (this.fixedOutlinePattern) {
                            p = this.lStyles[0].getLinePattern();
                        } else {
                            p = groupAttrMapper.getLinePattern(gVal);
                            if (p < 0) {
                                p = missing ? this.missingLineAttrs.getLinePattern() : la.getLinePattern();
                            }
                        }
                        int n2 = lt = this.useLineThickness ? this.getLineStyle().getWidth() : groupAttrMapper.getLineThickness(gVal);
                        if (lt < 0) {
                            lt = this.getLineStyle().getWidth();
                        }
                        this.groupLineStyles[n] = new LineAttrs();
                        this.groupLineStyles[n].setColor(this.groupLineColors[n]);
                        this.groupLineStyles[n].setLinePattern(p);
                        this.groupLineStyles[n].setWidth(lt);
                        this.groupFillPatternColors[n] = this.fixedFillPatternColor ? this.fpColors[0] : ((c = groupAttrMapper.getLineColor(gVal)) != null ? c : (missing ? this.missingFillPatternAttrs.getColor() : this.getIndexedFillPatternColor(idx, gIdx)));
                        this.groupFillPatterns[n] = this.fixedFillPattern ? this.fPatterns[0] : (missing ? this.missingFillPatternAttrs.getPattern() : this.getIndexedFillPattern(idx, gIdx));
                        if (!missing) {
                            ++gIdx;
                        }
                    } else if (LayoutOverlayParser.isMissing(gVal, gVar instanceof NumericVariable)) {
                        this.groupFillColors[n] = this.fixedFillColor ? this.fColors[0] : this.missingFillAttrs.getColor();
                        this.groupLineColors[n] = this.fixedOutlineColor ? this.lColors[0] : this.missingLineAttrs.getColor();
                        this.groupLineStyles[n] = new LineAttrs();
                        this.groupLineStyles[n].setColor(this.groupLineColors[n]);
                        if (this.fixedOutlinePattern) {
                            this.groupLineStyles[n].setLinePattern(this.lStyles[0].getLinePattern());
                        } else {
                            this.groupLineStyles[n].setLinePattern(this.missingLineAttrs.getLinePattern());
                        }
                        if (this.useLineThickness) {
                            this.groupLineStyles[n].setWidth(this.getLineStyle().getWidth());
                        } else {
                            this.groupLineStyles[n].setWidth(this.missingLineAttrs.getWidth());
                        }
                        this.groupFillPatternColors[n] = this.fixedFillPatternColor ? this.fpColors[0] : this.missingFillPatternAttrs.getColor();
                        this.groupFillPatterns[n] = this.fixedFillPattern ? this.fPatterns[0] : this.missingFillPatternAttrs.getPattern();
                    } else {
                        this.groupFillColors[n] = this.fixedFillColor ? this.fColors[0] : this.getIndexedFillColor(idx, gIdx);
                        this.groupLineColors[n] = this.fixedOutlineColor ? this.lColors[0] : this.getIndexedColor(idx, gIdx);
                        LineAttrs la = this.getIndexedStyle(idx, gIdx);
                        this.groupLineStyles[n] = new LineAttrs();
                        this.groupLineStyles[n].setColor(this.groupLineColors[n]);
                        this.groupLineStyles[n].setLinePattern(la.getLinePattern());
                        this.groupLineStyles[n].setWidth(la.getWidth());
                        if (this.fixedOutlinePattern) {
                            this.groupLineStyles[n].setLinePattern(this.lStyles[0].getLinePattern());
                        }
                        if (this.useLineThickness) {
                            this.groupLineStyles[n].setWidth(this.getLineStyle().getWidth());
                        }
                        this.groupFillPatternColors[n] = this.fixedFillPatternColor ? this.fpColors[0] : this.getIndexedFillPatternColor(idx, gIdx);
                        this.groupFillPatterns[n] = this.fixedFillPattern ? this.fPatterns[0] : this.getIndexedFillPattern(idx, gIdx);
                        ++gIdx;
                    }
                    ++n;
                }
                if (missingGroupIndex >= 0) {
                    --this.nGroups;
                }
            } else {
                this.groupFillColors = new Color[]{this.getIndexedFillColor(0, 0)};
                this.groupLineColors = new Color[]{this.getIndexedColor(0, 0)};
                this.groupLineStyles = new LineAttrs[]{this.getIndexedStyle(0, 0)};
                this.groupFillPatternColors = new Color[]{this.getIndexedFillPatternColor(0, 0)};
                this.groupFillPatterns = new int[]{this.getIndexedFillPattern(0, 0)};
            }
            boolean numericGroup = false;
            int sortOrder = -1;
            short sortRole = -1;
            if (gVar != null && (this.groupOrder == 1 || this.groupOrder == 2)) {
                sortRole = 3;
                sortOrder = this.groupOrder == 1 ? 1 : 2;
                numericGroup = gVar instanceof NumericVariable;
            }
            double[] as = acol >= 0 ? this.getSubsettedDoubleColumn((short)39, sortRole, numericGroup, sortOrder) : null;
            double[] bs = bcol >= 0 ? this.getSubsettedDoubleColumn((short)40, sortRole, numericGroup, sortOrder) : null;
            double[] xs = xcol >= 0 ? this.getSubsettedDoubleColumn((short)37, sortRole, numericGroup, sortOrder) : null;
            double[] ys = ycol >= 0 ? this.getSubsettedDoubleColumn((short)38, sortRole, numericGroup, sortOrder) : null;
            double[] slopes = scol >= 0 ? this.getSubsettedDoubleColumn((short)30, sortRole, numericGroup, sortOrder) : null;
            String[] sgs = gcol >= 0 && gVar instanceof StringVariable ? this.getSubsettedStringColumn((short)3, sortRole, numericGroup, sortOrder) : null;
            double[] dArray = ngs = gcol >= 0 && gVar instanceof NumericVariable ? this.getSubsettedDoubleColumn((short)3, sortRole, numericGroup, sortOrder) : null;
            int num = as != null ? as.length : (bs != null ? bs.length : (xs != null ? xs.length : (ys != null ? ys.length : slopes.length)));
            ArrayList<EllipseOverlay> al = new ArrayList<EllipseOverlay>(num);
            this.ellipses = new EllipseOverlay[1];
            Object g = null;
            this.numEllipses = 0;
            for (int i = 0; i < num; ++i) {
                double yo;
                if (gVar != null && (g = gVar instanceof StringVariable ? sgs[i] : (Double.isNaN(ngs[i]) ? null : new Double(ngs[i]))) == null && !this.missingGroupOn) continue;
                double s = scol >= 0 ? slopes[i] : this.constantSlope;
                double xr = acol >= 0 ? as[i] : this.constantXRadius;
                double yr = bcol >= 0 ? bs[i] : this.constantYRadius;
                double xo = xcol >= 0 ? xs[i] : this.constantXOrigin;
                double d = yo = ycol >= 0 ? ys[i] : this.constantYOrigin;
                if (Double.isNaN(xr) || Double.isNaN(yr) || xr < 0.0 || yr < 0.0) continue;
                ++this.numEllipses;
                EllipseOverlay ellipse = new EllipseOverlay();
                ellipse.setXRadius(xr);
                ellipse.setYRadius(yr);
                if (!Double.isNaN(xo)) {
                    ellipse.setXOrigin(xo);
                } else {
                    ellipse.setXOrigin(0.0);
                }
                if (!Double.isNaN(yo)) {
                    ellipse.setYOrigin(yo);
                } else {
                    ellipse.setYOrigin(0.0);
                }
                ellipse.setSlope(s);
                if (idLabel != null) {
                    ellipse.setProbeIDLabel(idLabel);
                    ellipse.setProbeID(this.getGroupLabel(g));
                    ellipse.setLegendLabel(this.getGroupLabel(g));
                }
                int gidx = this.getGroupIndex(gVar, g);
                if (missingGroupIndex >= 0 && missingGroupIndex < gidx) {
                    --gidx;
                }
                if (this.useFillTransparency || !this.hasAttrVar("GROUP")) {
                    ellipse.setFillStyle(new FillAttrs(this.groupFillColors[gidx], this.fillTransparency));
                } else {
                    ellipse.setFillStyle(new FillAttrs(this.groupFillColors[gidx], this.groupFillStyles[gidx].getTransparency()));
                }
                ellipse.getLineStyle().setColor(this.groupLineColors[gidx]);
                ellipse.getLineStyle().setLinePattern(this.groupLineStyles[gidx].getLinePattern());
                ellipse.getLineStyle().setWidth(this.groupLineStyles[gidx].getWidth());
                ellipse.getFillPatternStyle().setColor(this.groupFillPatternColors[gidx]);
                ellipse.getFillPatternStyle().setPattern(this.groupFillPatterns[gidx]);
                al.add(ellipse);
            }
            this.ellipses = al.toArray(this.ellipses);
        } else {
            this.groupFillColors = new Color[]{this.fColors[this.fCnt % this.fColors.length]};
            this.groupLineColors = new Color[]{this.lColors[this.cCnt % this.lColors.length]};
            this.groupLineStyles = new LineAttrs[]{this.lStyles[this.lCnt % this.lStyles.length]};
            this.groupFillPatternColors = new Color[]{this.fpColors[this.fpcCnt % this.fpColors.length]};
            this.groupFillPatterns = new int[]{this.fPatterns[this.fpCnt % this.fPatterns.length]};
            if (this.ellipses == null) {
                this.ellipses = new EllipseOverlay[1];
                this.ellipses[0] = new EllipseOverlay();
            }
            this.ellipses[0].setFillStyle(new FillAttrs(this.fColors[this.fCnt % this.fColors.length], this.fillTransparency));
            this.ellipses[0].getLineStyle().setColor(this.lColors[this.cCnt % this.lColors.length]);
            LineAttrs lstyle = this.lStyles[this.lCnt % this.lStyles.length];
            this.ellipses[0].getLineStyle().setLinePattern(lstyle.getLinePattern());
            this.ellipses[0].getLineStyle().setWidth(lstyle.width);
            this.ellipses[0].getFillPatternStyle().setColor(this.fpColors[this.fpcCnt % this.fpColors.length]);
            this.ellipses[0].getFillPatternStyle().setPattern(this.fPatterns[this.fpCnt % this.fPatterns.length]);
        }
        if (this.getDataTransparency() != 0.0) {
            for (int i = 0; i < this.ellipses.length; ++i) {
                if (this.ellipses[i] == null) continue;
                this.ellipses[i].setDataTransparency(this.getDataTransparency());
            }
        }
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        double offset = 0.0;
        for (int i = 0; i < this.numEllipses; ++i) {
            offset = Math.max(offset, this.ellipses[i].getPreferredOffset(dimension));
        }
        return offset;
    }

    public LineAttrs getLineStyle() {
        return this.ellipses[0].getLineStyle();
    }

    public void setLineStyle(LineAttrs style) {
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setLineStyle(style);
            this.ellipses[i].needConnect = true;
        }
    }

    public FillAttrs getFillStyle() {
        return this.ellipses[0].getFillStyle();
    }

    public void setFillStyle(FillAttrs style) {
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setFillStyle(style);
            this.ellipses[i].needConnect = true;
        }
    }

    public void setXOrigin(double origin) {
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setXOrigin(origin);
        }
    }

    public void setYOrigin(double origin) {
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setYOrigin(origin);
        }
    }

    public void setXRadius(double radius) {
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setXRadius(radius);
        }
    }

    public void setYRadius(double radius) {
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setYRadius(radius);
        }
    }

    public void setSlope(double slope) {
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setSlope(slope);
        }
    }

    @Override
    public void setDataTransparency(double d) {
        super.setDataTransparency(d);
        if (this.ellipses == null) {
            return;
        }
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setDataTransparency(d);
        }
    }

    public boolean isFillOn() {
        if (this.numEllipses == 0) {
            return this.fillOn;
        }
        return this.ellipses[0].isFillOn();
    }

    public void setFillOn(boolean b) {
        this.fillOn = b;
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setFillOn(b);
            this.ellipses[i].needConnect = true;
        }
    }

    public boolean isEdgeOn() {
        if (this.numEllipses == 0) {
            return this.edgeOn;
        }
        return this.ellipses[0].isEdgeOn();
    }

    public void setEdgeOn(boolean b) {
        this.edgeOn = b;
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setEdgeOn(b);
            this.ellipses[i].needConnect = true;
        }
    }

    public boolean isFillPatternOn() {
        if (this.numEllipses == 0) {
            return this.fillPatternOn;
        }
        return this.ellipses[0].isFillPatternOn();
    }

    public void setFillPatternOn(boolean b) {
        this.fillPatternOn = b;
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setFillPatternOn(b);
            this.ellipses[i].needConnect = true;
        }
    }

    @Override
    public void reconnect() {
        super.reconnect();
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].reconnect();
        }
    }

    public int getMaxPoints() {
        return this.ellipses[0].getMaxPoints();
    }

    public void setMaxPoints(int aInt) {
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setMaxPoints(aInt);
        }
    }

    public void setClipping(boolean b) {
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].setClipping(b);
        }
    }

    @Override
    public Insets getPreferredOuterMargin() {
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        for (int i = 0; i < this.numEllipses; ++i) {
            Insets ext = this.ellipses[i].getPreferredOuterMargin();
            left = Math.max(left, ext.left);
            right = Math.max(right, ext.right);
            top = Math.max(top, ext.top);
            bottom = Math.max(bottom, ext.bottom);
        }
        return new Insets(top, left, bottom, right);
    }

    public void setConstantXRadius(double r) {
        this.constantXRadius = r;
    }

    public void setConstantYRadius(double r) {
        this.constantYRadius = r;
    }

    public void setConstantXOrigin(double o) {
        this.constantXOrigin = o;
    }

    public void setConstantYOrigin(double o) {
        this.constantYOrigin = o;
    }

    public void setConstantSlope(double s) {
        this.constantSlope = s;
    }

    public int getNumberOfGroups() {
        return this.nGroups;
    }

    private int getGroupIndex(Variable gvar, Object value) {
        if (gvar == null) {
            return 0;
        }
        SASFormat format = this.getFormat(3);
        int num = gvar.getUniqueValueCount();
        int index = -1;
        for (int i = 0; i < num; ++i) {
            try {
                Object fmtValue;
                Object fmtObj;
                Object obj = gvar instanceof StringVariable ? ((StringVariable)gvar).uniqueValue.getValue(i) : new Double(((NumericVariable)gvar).uniqueValue.getValue(i));
                if (format != null) {
                    fmtObj = format.format(obj);
                    fmtValue = value == null ? null : format.format(value);
                } else {
                    fmtObj = obj;
                    fmtValue = value;
                }
                if (!fmtObj.equals(fmtValue)) continue;
                return i;
            }
            catch (MissingValueException e) {
                if (value != null && (!(value instanceof String) || !((String)value).trim().equals(""))) continue;
                return i;
            }
        }
        return index;
    }

    private int getFirstOccurringValueIndex(Variable var, int uniqueValueIndex) {
        if (var == null) {
            return 0;
        }
        int index = var instanceof StringVariable ? ((StringVariable)var).getFirstOccurringValueIndex(uniqueValueIndex) : ((NumericVariable)var).getFirstOccurringValueIndex(uniqueValueIndex);
        return index;
    }

    private String getGroupLabel(Object value) {
        if (value == null) {
            return this.model.getColumnClass(3) == Double.class ? StatGraph.missingOption : StatGraph.missingCharacter;
        }
        SASFormat format = this.getFormat(3);
        return format == null ? value.toString() : format.format(value);
    }

    @Override
    public void addObstacles(LabelPlacementInterface lp, PointLabelLayout l, int yOutputRange) {
        if (!this.labelProtected || !this.edgeOn) {
            return;
        }
        for (int i = 0; i < this.numEllipses; ++i) {
            this.ellipses[i].addObstacles(lp, l, yOutputRange);
        }
    }

    @Override
    public boolean hasLegend(int attrType) {
        switch (attrType) {
            case 0: {
                return true;
            }
            case 7: 
            case 11: {
                return this.fillOn;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return this.edgeOn;
            }
        }
        return false;
    }

    @Override
    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        if (!this.fillOn) {
            return 10;
        }
        return this.edgeOn ? 11 : 7;
    }

    @Override
    protected void applyFillTransparency(LegendItem[] items) {
        if (!this.fillOn || !this.useFillTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(items[i].getSymbolAttrs().getColor(), this.getFillStyle().getTransparency()));
            items[i].setSymbolAttrs((ColorAttr)fa);
        }
    }

    @Override
    protected void applyLineTransparency(LegendItem[] items) {
        if (!this.edgeOn || this.fillOn || !this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            LineAttrs old = (LineAttrs)items[i].getSymbolAttrs();
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(old.getColor()));
            la.setLinePattern(old.getLinePattern());
            la.setWidth(old.getWidth());
            items[i].setSymbolAttrs((ColorAttr)la);
        }
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        if (this.isLegendEntryFromAttrMap("GROUP")) {
            return this.getLegendItemsWithAttrMap(this.fixDefaultAttrType(attrType));
        }
        return super.getLegendItems(attrType);
    }

    @Override
    protected boolean isMargeAttrMapRequired(int type) {
        switch (type) {
            case 12: {
                return this.fillOn && this.groupFillColors != null && !this.fixedFillColor;
            }
            case 5: {
                return this.fillPatternOn && this.groupFillPatterns != null && !this.fixedFillPattern;
            }
            case 14: {
                return this.fillPatternOn && this.groupFillPatternColors != null && !this.fixedFillPatternColor;
            }
            case 11: {
                return this.edgeOn && this.groupLineColors != null && !this.fixedOutlineColor;
            }
            case 3: {
                return this.edgeOn && !this.fixedOutlinePattern;
            }
            case 4: {
                return this.edgeOn && !this.useLineThickness;
            }
        }
        return false;
    }

    @Override
    protected FillAttrs getAttrMapDefaultFillAttrs() {
        return this.defaultFillAttrs;
    }

    @Override
    protected LineAttrs getAttrMapDefaultLineAttrs() {
        return this.defaultLineAttrs;
    }

    @Override
    protected FillPatternAttrs getAttrMapDefaultFillPatternAttrs() {
        return this.defaultFillPatternAttrs;
    }

    public LineAttrs getMissingLineAttrs() {
        return this.missingLineAttrs;
    }

    public void setMissingLineAttrs(LineAttrs missingLineAttrs) {
        this.missingLineAttrs = missingLineAttrs;
    }

    public FillAttrs getMissingFillAttrs() {
        return this.missingFillAttrs;
    }

    public void setMissingFillAttrs(FillAttrs missingFillAttrs) {
        this.missingFillAttrs = missingFillAttrs;
    }

    public FillPatternAttrs getMissingFillPatternAttrs() {
        return this.missingFillPatternAttrs;
    }

    public void setMissingFillPatternAttrs(FillPatternAttrs missingFillPatternAttrs) {
        this.missingFillPatternAttrs = missingFillPatternAttrs;
    }

    public void setDefaultFillAttrs(FillAttrs defaultAttrs) {
        this.defaultFillAttrs = defaultAttrs;
    }

    public void setDefaultLineAttrs(LineAttrs defaultAttrs) {
        this.defaultLineAttrs = defaultAttrs;
    }

    public void setDefaultFillPatternAttrs(FillPatternAttrs defaultAttrs) {
        this.defaultFillPatternAttrs = defaultAttrs;
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return this.model == null || this.model.getSrcMap().getColumn(3) < 0;
    }

    @Override
    public String getDefaultLegendTitle() {
        if (this.isDegeneratedLegendContributor()) {
            return null;
        }
        int col = this.model.getSrcMap().getColumn(3);
        ColumnMetadata cmd = (ColumnMetadata)this.model.getSrcModel().getColumnLabel(col);
        return cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
    }
}

