/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.BrokenContinuousRangeToNumericMap;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.labeling.LabelPlacementInterface;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.text.Format;

public class DropLineOverlay
extends Overlay {
    public static final String RB_KEY = "DropLineOverlay.";
    public static final int DROP_TO_X = 0;
    public static final int DROP_TO_Y = 1;
    public static final int DROP_TO_BOTH = 2;
    protected int dropType = 2;
    protected Object xvalue = null;
    protected Object yvalue = null;
    protected String labelString = null;
    private Variable xvalueVar = null;
    private Variable yvalueVar = null;
    private Variable labelVar = null;
    private NumericVectorVariable numericXVar;
    private NumericVectorVariable numericYVar;
    protected FontMetrics fm;
    private NetworkRoot networkRoot;
    private DataRange xRange = null;
    private DataRange yRange = null;
    private Encoder xEncoder;
    private Encoder yEncoder;
    private LineAttrs lineStyle = new LineAttrs();
    private TextStyle labelStyle = new TextStyle();
    private SASFormat labelFormat = null;
    private LineSegment xLine;
    private LineSegment yLine;
    private RasterLabel label;
    private boolean makeLine = true;
    protected boolean clipping = false;
    protected double discreteOffset = 0.0;
    private boolean labelProtected = false;

    public boolean isProtectedLine() {
        return this.labelProtected;
    }

    public void setProtectedLine(boolean b) {
        this.labelProtected = b;
    }

    public boolean isClipping() {
        return this.clipping;
    }

    public void setClipping(boolean b) {
        this.clipping = b;
    }

    public Object getXValue() {
        return this.xvalue;
    }

    public void setXValue(Object obj) {
        this.xvalue = obj;
        this.updateXRange();
    }

    public Object getYValue() {
        return this.yvalue;
    }

    public void setYValue(Object obj) {
        this.yvalue = obj;
        this.updateYRange();
    }

    public NetworkRoot getNetworkRoot() {
        return this.networkRoot;
    }

    public SASFormat getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(SASFormat lf) {
        this.labelFormat = lf;
    }

    public LineAttrs getLineStyle() {
        return this.lineStyle;
    }

    public Color getLineColor() {
        return this.lineStyle.getColor();
    }

    public int getLinePattern() {
        return this.lineStyle.getLinePattern();
    }

    public void setLineStyle(LineAttrs style) {
        this.lineStyle = style;
    }

    public String getLabelString() {
        return this.labelString;
    }

    public void setLabelString(String aLabelString) {
        this.labelString = aLabelString;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(TextStyle aLabelStyle) {
        this.labelStyle = aLabelStyle;
    }

    protected void updateXRange() {
        if (this.clipping) {
            return;
        }
        DataRange oldRange = this.xRange;
        this.xRange = this.xvalueVar == null ? (this.xvalue instanceof String ? new DiscreteRange((Object[])new String[]{(String)this.xvalue}) : (this.discreteX ? new OrdinalRange(new Object[]{DataModel.defaultFormat.format(this.xvalue).trim()}, new Object[]{this.xvalue}, null) : new ContinuousRange(((Double)this.xvalue).doubleValue(), ((Double)this.xvalue).doubleValue()))) : (this.xvalueVar instanceof StringVariable ? (this.numericDiscreteX ? this.makeOrdinalRange((StringVariable)this.xvalueVar, this.xvalueVar.getUniqueValueCount(), (NumericVariable)this.numericXVar, (short)10, !this.xUnionAllPages) : this.makeDiscreteRange((StringVariable)this.xvalueVar, this.xvalueVar.getUniqueValueCount(), (short)10, !this.xUnionAllPages)) : this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, !this.xUnionAllPages));
        byte dim = 1;
        RangeChangedEvent rce = null;
        if (oldRange == null && this.xRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, this.xRange, dim);
        } else if (oldRange != null && this.xRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != this.xRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, this.xRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    protected void updateYRange() {
        if (this.clipping) {
            return;
        }
        DataRange oldRange = this.yRange;
        this.yRange = this.yvalueVar == null ? (this.yvalue instanceof String ? new DiscreteRange((Object[])new String[]{(String)this.yvalue}) : (this.discreteY ? new OrdinalRange(new Object[]{DataModel.defaultFormat.format(this.yvalue).trim()}, new Object[]{this.yvalue}, null) : new ContinuousRange(((Double)this.yvalue).doubleValue(), ((Double)this.yvalue).doubleValue()))) : (this.yvalueVar instanceof StringVariable ? (this.numericDiscreteY ? this.makeOrdinalRange((StringVariable)this.yvalueVar, this.yvalueVar.getUniqueValueCount(), (NumericVariable)this.numericYVar, (short)11, !this.yUnionAllPages) : this.makeDiscreteRange((StringVariable)this.yvalueVar, this.yvalueVar.getUniqueValueCount(), (short)11, !this.yUnionAllPages)) : this.makeContinuousRange((NumericVariable)this.yvalueVar, (short)11, !this.yUnionAllPages));
        byte dim = 2;
        RangeChangedEvent rce = null;
        if (oldRange == null && this.yRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, this.yRange, dim);
        } else if (oldRange != null && this.yRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != this.yRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, this.yRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (this.clipping) {
            return null;
        }
        if (dimension == 1) {
            return this.xRange;
        }
        if (dimension == 2) {
            return this.yRange;
        }
        return null;
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    private void makeLine() {
        if (!this.makeLine) {
            return;
        }
        this.connectVars();
        this.updateXRange();
        this.updateYRange();
        this.makeLine = false;
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            this.xEncoder = encoder;
        }
        if (dimension == 2) {
            this.yEncoder = encoder;
        }
        this.makeLine();
        this.needConnect = true;
    }

    @Override
    protected boolean connectNetwork() {
        BrokenContinuousRangeToNumericMap xmap2;
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.xEncoder == null) {
            return false;
        }
        ValueMap xmap = this.xEncoder.getValueMap();
        BrokenContinuousRangeToNumericMap brokenContinuousRangeToNumericMap = xmap2 = this.xEncoder instanceof BrokenPositionEncoder ? ((BrokenPositionEncoder)this.xEncoder).getBrokenValueMap() : null;
        if (this.yEncoder == null) {
            return false;
        }
        ValueMap ymap = this.yEncoder.getValueMap();
        BrokenContinuousRangeToNumericMap ymap2 = this.yEncoder instanceof BrokenPositionEncoder ? ((BrokenPositionEncoder)this.yEncoder).getBrokenValueMap() : null;
        this.networkRoot.removeAllElements();
        this.fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
        switch (this.dropType) {
            case 0: {
                this.xLine = new LineSegment();
                this.networkRoot.addElement((Element)this.xLine);
                this.xLine.setUserData((Object)this.probe);
                this.xLine.setSkinType(this.skinType);
                this.xLine.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
                break;
            }
            case 1: {
                this.yLine = new LineSegment();
                this.networkRoot.addElement((Element)this.yLine);
                this.yLine.setUserData((Object)this.probe);
                this.yLine.setSkinType(this.skinType);
                this.yLine.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
                break;
            }
            case 2: {
                this.xLine = new LineSegment();
                this.networkRoot.addElement((Element)this.xLine);
                this.xLine.setUserData((Object)this.probe);
                this.xLine.setSkinType(this.skinType);
                this.xLine.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
                this.yLine = new LineSegment();
                this.networkRoot.addElement((Element)this.yLine);
                this.yLine.setUserData((Object)this.probe);
                this.yLine.setSkinType(this.skinType);
                this.yLine.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
            }
        }
        double xDiscreteOffsetValue = this.getDiscreteOffsetValue((PositionEncoder)this.xEncoder);
        double yDiscreteOffsetValue = this.getDiscreteOffsetValue((PositionEncoder)this.yEncoder);
        if (this.xLine != null) {
            if (this.xvalueVar == null) {
                double xval;
                double d = xval = xmap2 == null ? this.getMappedValue(xmap, this.xvalue) : this.getMappedValue((ValueMap)xmap2, this.xvalue);
                if (xmap2 != null ? this.isValueOutOfRange(this.xEncoder, (Double)this.xvalue) : xval != xval) {
                    return false;
                }
                this.xLine.beginX.setValue(xval + xDiscreteOffsetValue);
                this.xLine.endX.setValue(xval + xDiscreteOffsetValue);
                if (this.yvalueVar == null) {
                    double yval = this.getMappedValue(ymap, this.yEncoder, this.yvalue);
                    this.xLine.endY.setValue(yval + yDiscreteOffsetValue);
                } else {
                    ContinuousRangeToNumericMapper yvalueMapper = null;
                    if (this.yvalueVar instanceof NumericVectorVariable) {
                        yvalueMapper = new ContinuousRangeToNumericMapper();
                        if (!(ymap instanceof ContinuousRangeToNumericMap)) {
                            return false;
                        }
                        yvalueMapper.setMap((ContinuousRangeToNumericMap)ymap);
                        yvalueMapper.input.connectFrom(((NumericVariable)this.yvalueVar).value);
                    } else {
                        yvalueMapper = new StringToNumericMapper();
                        ((StringToNumericMapper)yvalueMapper).setMap((StringToNumericMap)ymap);
                        ((StringToNumericMapper)yvalueMapper).input.connectFrom(((StringVariable)this.yvalueVar).value);
                    }
                    this.xLine.endY.connectFrom(this.makeOffsetCalculator(yDiscreteOffsetValue, (NumericPipe)yvalueMapper));
                }
                if (this.xAxis.equals("x")) {
                    this.xLine.beginY.setValue(((PositionEncoder)this.yEncoder).getLowerLimit());
                } else {
                    this.xLine.beginY.setValue(((PositionEncoder)this.yEncoder).getUpperLimit());
                }
            } else {
                ContinuousRangeToNumericMapper xvalueMapper = null;
                NumericPipe xvalueMapper2 = null;
                if (this.xvalueVar instanceof NumericVectorVariable) {
                    xvalueMapper = new ContinuousRangeToNumericMapper();
                    if (!(xmap instanceof ContinuousRangeToNumericMap)) {
                        return false;
                    }
                    xvalueMapper.setMap((ContinuousRangeToNumericMap)xmap);
                    xvalueMapper.input.connectFrom(((NumericVariable)this.xvalueVar).value);
                    if (xmap2 != null) {
                        xvalueMapper2 = new ContinuousRangeToNumericMapper();
                        ((ContinuousRangeToNumericMapper)xvalueMapper2).setMap((ContinuousRangeToNumericMap)xmap2);
                        ((ContinuousRangeToNumericMapper)xvalueMapper2).input.connectFrom(((NumericVariable)this.xvalueVar).value);
                    }
                } else {
                    xvalueMapper = new StringToNumericMapper();
                    ((StringToNumericMapper)xvalueMapper).setMap((StringToNumericMap)xmap);
                    ((StringToNumericMapper)xvalueMapper).input.connectFrom(((StringVariable)this.xvalueVar).value);
                }
                NumericPipe xOffsetPos = xvalueMapper2 == null ? this.makeOffsetCalculator(xDiscreteOffsetValue, (NumericPipe)xvalueMapper) : xvalueMapper2;
                this.xLine.beginX.connectFrom(xOffsetPos);
                this.xLine.endX.connectFrom(xOffsetPos);
                if (this.yvalueVar == null) {
                    double yval = this.getMappedValue(ymap, this.yEncoder, this.yvalue);
                    this.xLine.endY.setValue(yval + yDiscreteOffsetValue);
                } else {
                    ContinuousRangeToNumericMapper yvalueMapper = null;
                    if (this.yvalueVar instanceof NumericVectorVariable) {
                        yvalueMapper = new ContinuousRangeToNumericMapper();
                        if (!(ymap instanceof ContinuousRangeToNumericMap)) {
                            return false;
                        }
                        yvalueMapper.setMap((ContinuousRangeToNumericMap)ymap);
                        yvalueMapper.input.connectFrom(((NumericVariable)this.yvalueVar).value);
                    } else {
                        yvalueMapper = new StringToNumericMapper();
                        ((StringToNumericMapper)yvalueMapper).setMap((StringToNumericMap)ymap);
                        ((StringToNumericMapper)yvalueMapper).input.connectFrom(((StringVariable)this.yvalueVar).value);
                    }
                    this.xLine.endY.connectFrom(this.makeOffsetCalculator(yDiscreteOffsetValue, (NumericPipe)yvalueMapper));
                }
                if (this.xAxis.equals("x")) {
                    this.xLine.beginY.setValue(((PositionEncoder)this.yEncoder).getLowerLimit());
                } else {
                    this.xLine.beginY.setValue(((PositionEncoder)this.yEncoder).getUpperLimit());
                }
            }
            this.xLine.color.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
            this.xLine.lineWidth.setValue((double)this.lineStyle.getWidth());
            this.xLine.setStipple(this.lineStyle.getStipplePattern(), this.lineStyle.getStippleFactor());
            this.xLine.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
        }
        if (this.yLine != null) {
            if (this.yvalueVar == null) {
                double yval;
                double d = yval = ymap2 == null ? this.getMappedValue(ymap, this.yvalue) : this.getMappedValue((ValueMap)ymap2, this.yvalue);
                if (ymap2 != null ? this.isValueOutOfRange(this.yEncoder, (Double)this.yvalue) : yval != yval) {
                    return false;
                }
                this.yLine.beginY.setValue(yval + yDiscreteOffsetValue);
                this.yLine.endY.setValue(yval + yDiscreteOffsetValue);
                if (this.xvalueVar == null) {
                    double xval = this.getMappedValue(xmap, this.xEncoder, this.xvalue);
                    this.yLine.endX.setValue(xval + xDiscreteOffsetValue);
                } else {
                    ContinuousRangeToNumericMapper xvalueMapper = null;
                    if (this.xvalueVar instanceof NumericVectorVariable) {
                        xvalueMapper = new ContinuousRangeToNumericMapper();
                        if (!(xmap instanceof ContinuousRangeToNumericMap)) {
                            return false;
                        }
                        xvalueMapper.setMap((ContinuousRangeToNumericMap)xmap);
                        xvalueMapper.input.connectFrom(((NumericVariable)this.xvalueVar).value);
                    } else {
                        xvalueMapper = new StringToNumericMapper();
                        ((StringToNumericMapper)xvalueMapper).setMap((StringToNumericMap)xmap);
                        ((StringToNumericMapper)xvalueMapper).input.connectFrom(((StringVariable)this.xvalueVar).value);
                    }
                    this.yLine.endX.connectFrom(this.makeOffsetCalculator(xDiscreteOffsetValue, (NumericPipe)xvalueMapper));
                }
                if (this.yAxis.equals("y")) {
                    this.yLine.beginX.setValue(((PositionEncoder)this.xEncoder).getLowerLimit());
                } else {
                    this.yLine.beginX.setValue(((PositionEncoder)this.xEncoder).getUpperLimit());
                }
            } else {
                ContinuousRangeToNumericMapper yvalueMapper = null;
                NumericPipe yvalueMapper2 = null;
                if (this.yvalueVar instanceof NumericVectorVariable) {
                    yvalueMapper = new ContinuousRangeToNumericMapper();
                    if (!(ymap instanceof ContinuousRangeToNumericMap)) {
                        return false;
                    }
                    yvalueMapper.setMap((ContinuousRangeToNumericMap)ymap);
                    yvalueMapper.input.connectFrom(((NumericVariable)this.yvalueVar).value);
                    if (ymap2 != null) {
                        yvalueMapper2 = new ContinuousRangeToNumericMapper();
                        ((ContinuousRangeToNumericMapper)yvalueMapper2).setMap((ContinuousRangeToNumericMap)ymap2);
                        ((ContinuousRangeToNumericMapper)yvalueMapper2).input.connectFrom(((NumericVariable)this.yvalueVar).value);
                    }
                } else {
                    yvalueMapper = new StringToNumericMapper();
                    ((StringToNumericMapper)yvalueMapper).setMap((StringToNumericMap)ymap);
                    ((StringToNumericMapper)yvalueMapper).input.connectFrom(((StringVariable)this.yvalueVar).value);
                }
                NumericPipe yOffsetPos = yvalueMapper2 == null ? this.makeOffsetCalculator(yDiscreteOffsetValue, (NumericPipe)yvalueMapper) : yvalueMapper2;
                this.yLine.beginY.connectFrom(yOffsetPos);
                this.yLine.endY.connectFrom(yOffsetPos);
                if (this.xvalueVar == null) {
                    double xval = this.getMappedValue(xmap, this.xEncoder, this.xvalue);
                    this.yLine.endX.setValue(xval + xDiscreteOffsetValue);
                } else {
                    ContinuousRangeToNumericMapper xvalueMapper = null;
                    if (this.xvalueVar instanceof NumericVectorVariable) {
                        xvalueMapper = new ContinuousRangeToNumericMapper();
                        if (!(xmap instanceof ContinuousRangeToNumericMap)) {
                            return false;
                        }
                        xvalueMapper.setMap((ContinuousRangeToNumericMap)xmap);
                        xvalueMapper.input.connectFrom(((NumericVariable)this.xvalueVar).value);
                    } else {
                        xvalueMapper = new StringToNumericMapper();
                        ((StringToNumericMapper)xvalueMapper).setMap((StringToNumericMap)xmap);
                        ((StringToNumericMapper)xvalueMapper).input.connectFrom(((StringVariable)this.xvalueVar).value);
                    }
                    this.yLine.endX.connectFrom(this.makeOffsetCalculator(xDiscreteOffsetValue, (NumericPipe)xvalueMapper));
                }
                if (this.yAxis.equals("y")) {
                    this.yLine.beginX.setValue(((PositionEncoder)this.xEncoder).getLowerLimit());
                } else {
                    this.yLine.beginX.setValue(((PositionEncoder)this.xEncoder).getUpperLimit());
                }
            }
            this.yLine.color.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
            this.yLine.lineWidth.setValue((double)this.lineStyle.getWidth());
            this.yLine.setStipple(this.lineStyle.getStipplePattern(), this.lineStyle.getStippleFactor());
            this.yLine.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
        }
        if (this.labelString != null || this.labelVar != null) {
            this.label = new RasterLabel();
            this.networkRoot.addElement((Element)this.label);
            this.label.color.setValue(this.labelStyle.getColor());
            this.label.fontName.setValue(this.labelStyle.getFont().getName());
            this.label.fontSize.setValue(this.labelStyle.getFont().getSize());
            this.label.fontStyle.setValue(this.labelStyle.getFont().getStyle());
            this.adjustLabelAlignment();
            this.label.horizontalJustification.setValue(this.labelStyle.getHorizontalJustification());
            this.label.verticalJustification.setValue(this.labelStyle.getVerticalJustification());
            if (this.model == null) {
                if (this.labelFormat != null) {
                    if (this.labelFormat.isCharacterFormat()) {
                        this.label.string.setValue(this.labelFormat.format((Object)this.labelString));
                    } else {
                        this.label.string.setValue(this.labelFormat.format((Object)new Double(this.labelString)));
                    }
                } else {
                    this.label.string.setValue(this.labelString);
                }
                LineSegment line = this.xLine != null ? this.xLine : this.yLine;
                this.label.transform.translateX.setValue(line.endX.getValue());
                this.label.transform.translateY.setValue(line.endY.getValue());
            } else {
                if (this.labelVar instanceof StringVectorVariable) {
                    this.label.string.connectFrom(((StringVectorVariable)this.labelVar).formattedValue);
                } else {
                    this.label.string.connectFrom(((NumericVectorVariable)this.labelVar).formattedValue);
                }
                LineSegment line = this.xLine != null ? this.xLine : this.yLine;
                this.label.transform.translateX.connectFrom((NumericPipe)line.endX);
                this.label.transform.translateY.connectFrom((NumericPipe)line.endY);
            }
        }
        this.needConnect = false;
        return true;
    }

    @Override
    public Insets getPreferredInnerMargin() {
        Insets pim = super.getPreferredInnerMargin();
        if (this.labelString == null && this.labelVar == null) {
            return pim;
        }
        FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
        int labelHeight = fm.getHeight() + StatGraph.getExtraPadding();
        int maxLabelLen = 0;
        if (this.labelVar != null) {
            int nChars = ScatterOverlay.getMaxStringLength(this.model, 5, null);
            StringBuffer sb = new StringBuffer(nChars);
            for (int i = 0; i < nChars; ++i) {
                sb = sb.append("W");
            }
            maxLabelLen = fm.stringWidth(sb.toString());
        } else {
            maxLabelLen = fm.stringWidth(this.labelString);
        }
        maxLabelLen += StatGraph.getExtraPadding();
        if (this.yAxis.equals("y")) {
            pim.right = Math.max(pim.right, maxLabelLen);
        } else {
            pim.left = Math.max(pim.left, maxLabelLen);
        }
        if (this.xAxis.equals("x")) {
            pim.top = Math.max(pim.top, labelHeight);
        } else {
            pim.bottom = Math.max(pim.bottom, labelHeight);
        }
        return pim;
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        double scale = this.lineStyle.getWidth();
        return 2.0 * scale;
    }

    protected void connectVars() {
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.probeID != null) {
            this.probe.addString(this.probeIDLabel, "" + this.probeID);
        }
        if (this.model != null) {
            SASFormat fmt;
            if (this.model.isAvailable(10)) {
                boolean numericX = this.model.getColumnClass(10) == Double.class;
                this.xvalueVar = this.discreteX ? this.connectCategory((short)10, this.missingCategoryOn) : this.connectRaw((short)10);
                if (numericX && this.discreteX) {
                    this.numericXVar = new NumericVectorVariable();
                    this.numericXVar.connectFrom(this.model.getDoubleColumn(10));
                    fmt = ((ColumnMetadata)this.model.getColumnLabel(10)).getFormat();
                    if (fmt == null) {
                        fmt = DataModel.defaultFormat;
                    }
                    this.numericXVar.setFormat(new GTKFormat((Format)fmt));
                }
                if (this.discreteX) {
                    this.numericDiscreteX = numericX;
                    numericX = false;
                }
            } else {
                this.xvalueVar = null;
            }
            if (this.model.isAvailable(11)) {
                boolean numericY = this.model.getColumnClass(11) == Double.class;
                this.yvalueVar = this.discreteY ? this.connectCategory((short)11, this.missingCategoryOn) : this.connectRaw((short)11);
                if (numericY && this.discreteY) {
                    this.numericYVar = new NumericVectorVariable();
                    this.numericYVar.connectFrom(this.model.getDoubleColumn(11));
                    fmt = ((ColumnMetadata)this.model.getColumnLabel(11)).getFormat();
                    if (fmt == null) {
                        fmt = DataModel.defaultFormat;
                    }
                    this.numericYVar.setFormat(new GTKFormat((Format)fmt));
                }
                if (this.discreteY) {
                    this.numericDiscreteY = numericY;
                    numericY = false;
                }
            } else {
                this.yvalueVar = null;
            }
            if (this.model.isAvailable(5)) {
                boolean numericLabel = this.model.getColumnClass(5) == Double.class;
                this.labelVar = this.connectCategory((short)5, false);
            } else {
                this.labelVar = null;
            }
            VariableProcessor vp = null;
            if (this.model.whereExpression != null) {
                vp = new VariableProcessor();
                this.addVarToVP(vp, this.xvalueVar);
                this.addVarToVP(vp, this.yvalueVar);
                this.addVarToVP(vp, this.labelVar);
                this.addVarToVP(vp, (Variable)this.numericXVar);
                this.addVarToVP(vp, (Variable)this.numericYVar);
                this.addCRDWhereClause(vp);
            }
            this.addTooltip(vp, "X");
            this.addTooltip(vp, "Y");
            if (vp != null) {
                vp.init();
            }
        } else {
            if (this.xvalue instanceof String) {
                this.probe.addString("X", (String)this.xvalue);
            } else {
                this.probe.addString("X", DataModel.formatNumber((Double)this.xvalue));
            }
            if (this.yvalue instanceof String) {
                this.probe.addString("Y", (String)this.yvalue);
            } else {
                this.probe.addString("Y", DataModel.formatNumber((Double)this.yvalue));
            }
        }
    }

    public static double getMappedValueWithClipping(ContinuousRangeToNumericMap map, double value) {
        double min = Math.min(map.getInputMin(), map.getInputMax());
        double max = Math.max(map.getInputMin(), map.getInputMax());
        double mapped = value < min || value > max ? Double.NaN : map.getValue(value);
        return mapped;
    }

    public static double getMappedValueWithClipping(ContinuousRangeToNumericMap map, BrokenPositionEncoder encoder, double value) {
        double min = ((ContinuousRange)encoder.getInput()).getMin();
        double max = ((ContinuousRange)encoder.getInput()).getMax();
        double mapped = value < min || value > max ? Double.NaN : map.getValue(value);
        return mapped;
    }

    private double getMappedValue(ValueMap map, Object obj) {
        double val = 0.0;
        if (map instanceof StringToNumericMap) {
            try {
                val = ((StringToNumericMap)map).getValue(obj instanceof Double ? DataModel.defaultFormat.format(obj).trim() : obj);
            }
            catch (MissingValueException mve) {
                return Double.NaN;
            }
        } else {
            val = DropLineOverlay.getMappedValueWithClipping((ContinuousRangeToNumericMap)map, (Double)obj);
        }
        return val;
    }

    private double getMappedValue(ValueMap map, Encoder encoder, Object obj) {
        if (!(encoder instanceof BrokenPositionEncoder)) {
            return this.getMappedValue(map, obj);
        }
        return DropLineOverlay.getMappedValueWithClipping((ContinuousRangeToNumericMap)map, (BrokenPositionEncoder)encoder, (Double)obj);
    }

    private boolean isValueOutOfRange(Encoder encoder, double value) {
        if (encoder instanceof BrokenPositionEncoder) {
            double min = ((ContinuousRange)encoder.getInput()).getMin();
            double max = ((ContinuousRange)encoder.getInput()).getMax();
            if (value < min || value > max) {
                return true;
            }
        }
        return false;
    }

    private double getDiscreteOffsetValue(PositionEncoder pe) {
        if (this.discreteOffset == 0.0) {
            return 0.0;
        }
        if (pe.getValueMap() instanceof StringToNumericMap) {
            StringToNumericMap stnm = (StringToNumericMap)pe.getValueMap();
            double stride = stnm.getStrideValue();
            double val = this.discreteOffset * stride;
            return pe.isReversed() ? -val : val;
        }
        return 0.0;
    }

    private void adjustLabelAlignment() {
        if (this.yAxis.equals("y")) {
            this.labelStyle.setHorizontalJustification(0);
        } else {
            this.labelStyle.setHorizontalJustification(2);
        }
        if (this.xAxis.equals("x")) {
            this.labelStyle.setVerticalJustification(3);
        } else {
            this.labelStyle.setVerticalJustification(0);
        }
    }

    @Override
    public int[] getLineWidths() {
        int[] lw = new int[]{this.lineStyle.getWidth()};
        return lw;
    }

    @Override
    public Color[] getLineColors() {
        Color[] lc = new Color[]{this.applyDataTransparency((ColorAttr)this.lineStyle)};
        return lc;
    }

    @Override
    public int[] getLinePatterns() {
        int[] lp = new int[]{this.lineStyle.getLinePattern()};
        return lp;
    }

    @Override
    public String[] getGroupValues() {
        String[] gv = new String[]{this.legendLabel};
        return gv;
    }

    @Override
    public String[] getLineColorValues() {
        return this.getGroupValues();
    }

    @Override
    public String[] getLinePatternValues() {
        return this.getGroupValues();
    }

    public int getDropType() {
        return this.dropType;
    }

    public void setDropType(int dropType) {
        this.dropType = dropType;
    }

    @Override
    public boolean isComputedOverlay() {
        return true;
    }

    @Override
    public void updateNetworkElements() {
        double yval;
        double xval;
        ValueMap xmap = this.xEncoder.getValueMap();
        ValueMap ymap = this.yEncoder.getValueMap();
        if (this.xLine != null) {
            if (this.xvalueVar == null) {
                xval = this.getMappedValue(xmap, this.xvalue);
                this.xLine.beginX.setValue(xval);
                this.xLine.endX.setValue(xval);
                if (this.yvalueVar == null) {
                    double yval2 = this.getMappedValue(ymap, this.yvalue);
                    this.xLine.endY.setValue(yval2);
                }
            } else if (this.yvalueVar == null) {
                yval = this.getMappedValue(ymap, this.yvalue);
                this.xLine.endY.setValue(yval);
            }
        }
        if (this.yLine != null) {
            if (this.yvalueVar == null) {
                yval = this.getMappedValue(ymap, this.yvalue);
                this.yLine.beginY.setValue(yval);
                this.yLine.endY.setValue(yval);
                if (this.xvalueVar == null) {
                    double xval2 = this.getMappedValue(xmap, this.xvalue);
                    this.yLine.endX.setValue(xval2);
                }
            } else if (this.xvalueVar == null) {
                xval = this.getMappedValue(xmap, this.xvalue);
                this.yLine.endX.setValue(xval);
            }
        }
        if (this.labelString != null || this.labelVar != null) {
            LineSegment line = this.xLine != null ? this.xLine : this.yLine;
            this.label.transform.translateX.setValue(line.endX.getValue());
            this.label.transform.translateY.setValue(line.endY.getValue());
        }
    }

    public double getDiscreteOffset() {
        return this.discreteOffset;
    }

    public void setDiscreteOffset(double discreteOffset) {
        this.discreteOffset = discreteOffset;
    }

    @Override
    public void addObstacles(LabelPlacementInterface lp, PointLabelLayout l, int yOutputRange) {
        Rectangle obstacle;
        ValueMap ymap;
        if (!this.labelProtected) {
            return;
        }
        double xMin = 0.0;
        double yMin = 0.0;
        double xMax = 0.0;
        double yMax = 0.0;
        ValueMap xmap = this.xEncoder != null ? this.xEncoder.getValueMap() : null;
        ValueMap valueMap = ymap = this.yEncoder != null ? this.yEncoder.getValueMap() : null;
        if (this.yLine != null && this.yvalueVar == null) {
            double yval = this.getMappedValue(xmap, this.yvalue);
            if (this.xvalueVar == null) {
                double xval = this.getMappedValue(xmap, this.xvalue);
                xMin = ((PositionEncoder)this.xEncoder).getLowerLimit();
                xMax = xval;
                yMin = (double)yOutputRange - yval;
                obstacle = new Rectangle((int)xMin, (int)yMin - this.lineStyle.getWidth() / 2, (int)(xMax - xMin), this.lineStyle.getWidth());
                lp.addObstacle(obstacle);
            }
        }
        if (this.xLine != null && this.xvalueVar == null) {
            double xval = this.getMappedValue(xmap, this.xvalue);
            if (this.yvalueVar == null) {
                double yval = this.getMappedValue(xmap, this.yvalue);
                xMin = xval;
                yMin = (double)yOutputRange - yval;
                yMax = (double)yOutputRange - ((PositionEncoder)this.xEncoder).getLowerLimit();
                obstacle = new Rectangle((int)xMin - this.lineStyle.getWidth() / 2, (int)yMin, this.lineStyle.getWidth(), (int)(yMax - yMin));
                lp.addObstacle(obstacle);
            }
        }
    }

    @Override
    protected int getNumberOfDrawingElements() {
        int num;
        int n = num = this.model == null ? 1 : this.xvalueVar.getValueCount();
        if (this.dropType == 2) {
            num *= 2;
        }
        return num;
    }
}

