/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.common.dendrogram.DendrogramObject;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.legend.LegendItem;
import java.awt.Graphics;
import java.awt.Insets;

public class DendrogramOverlay
extends Overlay {
    private DendrogramObject dendrogram = new DendrogramObject();
    private Variable idVar;
    private Variable parentVar;
    private Variable heightVar;
    private Variable leafLabelVar;
    private Variable numClustersVar;
    private NetworkRoot networkRoot = null;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    private boolean sortNodeIDs = false;

    public DendrogramOverlay() {
        this.dendrogram.setOrientation(2);
        this.dendrogram.setConnectType(1);
    }

    public void setSortNodeIDs(boolean b) {
        this.sortNodeIDs = b;
    }

    public boolean isSortNodeIDs() {
        return this.sortNodeIDs;
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
    }

    protected void connectVars() {
        CRD crd = this.model;
        VariableProcessor vp = new VariableProcessor();
        if (crd.isAvailable(56)) {
            this.idVar = this.connectCategory((short)56, false);
            vp.addVariable(this.idVar);
            if (this.sortNodeIDs) {
                vp.setSort(this.idVar, 1);
            }
        } else {
            this.idVar = null;
        }
        if (crd.isAvailable(57)) {
            this.parentVar = this.connectCategory((short)57, false);
            vp.addVariable(this.parentVar);
        } else {
            this.parentVar = null;
        }
        if (crd.isAvailable(58)) {
            this.heightVar = this.connectRaw((short)58);
            vp.addVariable(this.heightVar);
        } else {
            this.heightVar = null;
        }
        if (crd.isAvailable(59)) {
            this.numClustersVar = this.connectRaw((short)59);
            vp.addVariable(this.numClustersVar);
        } else {
            this.numClustersVar = null;
        }
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (crd.isAvailable(300)) {
            this.addCustomTips(vp);
        } else {
            this.addTooltip(vp, "NODEID");
            this.addTooltip(vp, "PARENTID");
            this.addTooltip(vp, "HEIGHT");
            this.addTooltip(vp, "NUMCLUSTERS");
        }
        vp.setWhereExpression(this.idVar.getColumnName() + " NE \"\"");
        this.addCRDWhereClause(vp);
        if (this.numClustersVar instanceof NumericVariable) {
            this.dendrogram.setNumClustersVar((NumericVariable)this.numClustersVar);
        }
        this.dendrogram.setNodeVar(this.idVar);
        this.dendrogram.setParentVar(this.parentVar);
        if (this.heightVar instanceof NumericVariable) {
            this.dendrogram.setHeightVar((NumericVariable)this.heightVar);
        }
        this.fireRangeEvent((byte)1, null, this.getDataRange((byte)1));
        this.fireRangeEvent((byte)2, null, this.getDataRange((byte)2));
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.dendrogram.select(this.networkRoot);
    }

    @Override
    protected boolean connectNetwork() {
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        String err = this.dendrogram.validateData();
        if (err != null) {
            StatGraph.printWarning(err);
            this.needConnect = false;
            return false;
        }
        int offsetMin = 0;
        int offsetMax = 0;
        if (this.getOrientation() == 1) {
            offsetMin = (int)(this.yEncoder.getOutputMin() - this.yEncoder.getLowerLimit());
            offsetMax = (int)(this.yEncoder.getUpperLimit() - this.yEncoder.getOutputMax());
        } else {
            offsetMin = (int)(this.xEncoder.getOutputMin() - this.xEncoder.getLowerLimit());
            offsetMax = (int)(this.xEncoder.getUpperLimit() - this.xEncoder.getOutputMax());
        }
        this.dendrogram.setLeafAxisOffsetMin(offsetMin);
        this.dendrogram.setLeafAxisOffsetMax(offsetMax);
        boolean rc = this.dendrogram.connectNetwork(this.networkRoot, this.xEncoder.getValueMap(), this.yEncoder.getValueMap(), this.probe, this.xEncoder.isReversed(), this.yEncoder.isReversed());
        this.needConnect = false;
        return rc;
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (this.dendrogram == null) {
            return null;
        }
        return this.dendrogram.getDataRange(dimension);
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
            if (this.xEncoder != null && this.dendrogram != null) {
                this.dendrogram.setXReversed(this.xEncoder.isReversed());
            }
        }
        if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
            if (this.yEncoder != null && this.dendrogram != null) {
                this.dendrogram.setYReversed(this.yEncoder.isReversed());
            }
        }
        this.needConnect = true;
    }

    @Override
    public Insets getPreferredInnerMargin() {
        if (this.dendrogram != null) {
            return this.dendrogram.getPreferredInnerMargin();
        }
        return super.getPreferredInnerMargin();
    }

    public LineAttrs getLineAttrs() {
        return this.dendrogram.getLineAttrs();
    }

    public void setLineAttrs(LineAttrs lineAttrs) {
        this.dendrogram.setLineAttrs(lineAttrs);
    }

    public int getOrientation() {
        return this.dendrogram.getOrientation();
    }

    public void setOrientation(int orientation) {
        this.dendrogram.setOrientation(orientation);
    }

    public void setConnectType(int type) {
        this.dendrogram.setConnectType(type);
    }

    public int getConnectType() {
        return this.dendrogram.getConnectType();
    }

    public void setCutHeight(double height) {
        this.dendrogram.setCutHeight(height);
    }

    public void setCutClusters(int nClus) {
        this.dendrogram.setCutClusters(nClus);
    }

    @Override
    public boolean hasLegend(int attrType) {
        return true;
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        String defaultLabel = this.heightVar.getLabel();
        if (defaultLabel == null) {
            defaultLabel = this.name;
        }
        return new LegendItem[]{this.dendrogram.getOverlayLegendItem(this.legendLabel != null ? this.legendLabel : defaultLabel)};
    }

    public boolean areNodeIdsUnique() {
        if (this.idVar != null && this.idVar.isConnected()) {
            VariableProcessor vp = new VariableProcessor();
            Variable nodeVar = this.connectCategory((short)56, false);
            vp.addVariable(nodeVar);
            String whereExpression = nodeVar.getColumnName() + " NE \"\"";
            if (this.model.whereExpression != null) {
                for (int i = 0; i < this.model.whereVars.length; ++i) {
                    StringVectorVariable sv;
                    if (this.model.whereVars[i] == null) continue;
                    Object object = sv = this.model.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                    if (this.model.whereVarsOnSeparateModel) {
                        DataModel dm = this.model.getSrcModel();
                        int wcol = dm.getColumn(this.model.whereVars[i].getName());
                        sv.setName(this.model.whereVars[i].getName());
                        sv.connectFrom(dm.getColumnAsClassColumn(wcol, this.model.whereIncludeMissingClass));
                    } else {
                        sv.connectFrom(this.model.whereVars[i]);
                    }
                    vp.addVariable((Variable)sv);
                }
                whereExpression = "(" + whereExpression + ") & (" + this.model.whereExpression + ")";
            }
            vp.setWhereExpression(whereExpression);
            if (nodeVar.getValueCount() == nodeVar.getUniqueValueCount()) {
                return true;
            }
        }
        return false;
    }

    public boolean isSingleRootedTree() {
        if (this.idVar != null && this.idVar.isConnected()) {
            VariableProcessor vp = new VariableProcessor();
            Variable nodeVar = this.connectCategory((short)56, false);
            vp.addVariable(nodeVar);
            Variable parentIdVar = this.connectCategory((short)57, false);
            vp.addVariable(parentIdVar);
            String whereExpression = nodeVar.getColumnName() + " NE \"\"";
            if (this.model.whereExpression != null) {
                for (int i = 0; i < this.model.whereVars.length; ++i) {
                    StringVectorVariable sv;
                    if (this.model.whereVars[i] == null) continue;
                    Object object = sv = this.model.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                    if (this.model.whereVarsOnSeparateModel) {
                        DataModel dm = this.model.getSrcModel();
                        int wcol = dm.getColumn(this.model.whereVars[i].getName());
                        sv.setName(this.model.whereVars[i].getName());
                        sv.connectFrom(dm.getColumnAsClassColumn(wcol, this.model.whereIncludeMissingClass));
                    } else {
                        sv.connectFrom(this.model.whereVars[i]);
                    }
                    vp.addVariable((Variable)sv);
                }
                whereExpression = "(" + whereExpression + ") & (" + this.model.whereExpression + ")";
            }
            vp.setWhereExpression(whereExpression);
            int rootCount = 0;
            for (int i = 0; i < parentIdVar.getValueCount(); ++i) {
                if (!parentIdVar.isMissing(i)) continue;
                ++rootCount;
            }
            if (rootCount > 1) {
                return false;
            }
        }
        return true;
    }

    public Variable getNodeIdVar() {
        return this.idVar;
    }

    public LineAttrs getCutLineAttrs() {
        return this.dendrogram.getCutLineAttrs();
    }

    public void setCutLineAttrs(LineAttrs cutLineAttrs) {
        this.dendrogram.setCutLineAttrs(cutLineAttrs);
    }
}

