/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.RPFUtil;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.FillPatternEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.LineEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BarOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.common.bubble.BubbleObject;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.Ellipse;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class BubbleOverlay
extends Overlay {
    private BubbleObject bubble = new BubbleObject();
    private Variable xVar;
    private Variable yVar;
    private NumericVariable sizeVar;
    private Variable colorVar;
    private Variable dataLabelVar;
    private NumericVariable indexVar;
    private Variable fillPatternVar;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder fillColorEncoder;
    protected ColorEncoder outlineColorEncoder;
    protected LineEncoder lineEncoder;
    protected FillPatternEncoder fillPatternEncoder;
    protected ColorEncoder fillPatternColorEncoder;
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    protected DataRange colorRange = null;
    private boolean numericX = true;
    private boolean numericY = true;
    private boolean numericColor = true;
    private boolean includeMissingGroup = true;
    private Color missingColorResponseColor = Color.black;
    public static final int DRAW_ORDER_SIZE = 0;
    public static final int DRAW_ORDER_DATA = 1;
    private int drawingOrder = 0;

    public BubbleOverlay() {
        this.bubble.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
    }

    protected void connectVars() {
        if (StatGraph.isOLAP()) {
            this.connectOLAPVars();
            return;
        }
        CRD crd = this.model;
        Variable x = null;
        NumericVariable xRaw = null;
        Variable y = null;
        NumericVariable yRaw = null;
        VariableProcessor vp = null;
        boolean bl = this.numericX = crd.getColumnClass(10) == Double.class;
        if (crd.isAvailable(10)) {
            if (this.numericX && !this.discreteX) {
                this.xVar = this.connectRaw((short)10);
                x = this.connectRaw((short)10);
            } else {
                this.xVar = this.connectCategory((short)10, StatGraph.includeMissingDiscrete);
                x = this.connectCategory((short)10, StatGraph.includeMissingDiscrete);
                if (this.numericX && this.discreteX) {
                    xRaw = (NumericVariable)this.connectRaw((short)10);
                }
            }
        } else {
            this.xVar = null;
        }
        boolean bl2 = this.numericY = crd.getColumnClass(11) == Double.class;
        if (crd.isAvailable(11)) {
            if (this.numericY && !this.discreteY) {
                this.yVar = this.connectRaw((short)11);
                y = this.connectRaw((short)11);
            } else {
                this.yVar = this.connectCategory((short)11, false);
                y = this.connectCategory((short)11, false);
                if (this.numericY && this.discreteY) {
                    yRaw = (NumericVariable)this.connectRaw((short)11);
                }
            }
        } else {
            this.yVar = null;
        }
        if (this.discreteX || this.discreteY || !this.numericX || !this.numericY) {
            this.bubble.setRelativeScale(true);
        }
        this.sizeVar = crd.isAvailable(7) && crd.getColumnClass(7) == Double.class ? (NumericVariable)this.connectRaw((short)7) : null;
        StringVectorVariable unsortedColorVar = null;
        this.numericColor = false;
        short colorRole = 3;
        if (crd.isAvailable(108)) {
            this.colorVar = this.connectRaw((short)108);
            colorRole = 108;
            this.numericColor = true;
        } else if (crd.isAvailable(3)) {
            this.colorVar = this.connectCategory((short)3, this.includeMissingGroup);
            unsortedColorVar = (StringVectorVariable)this.connectCategory((short)3, this.includeMissingGroup);
            if (crd.isAvailable(41) && crd.getColumnClass(41) == Double.class) {
                this.indexVar = (NumericVariable)this.connectRaw((short)41);
            }
        } else {
            this.colorVar = null;
        }
        if (this.isFillPatterned() && crd.isAvailable(3) && colorRole == 108) {
            this.fillPatternVar = this.connectCategory((short)3, this.includeMissingGroup);
            unsortedColorVar = (StringVectorVariable)this.connectCategory((short)3, this.includeMissingGroup);
            if (crd.isAvailable(43) && crd.getColumnClass(43) == Double.class) {
                this.indexVar = (NumericVariable)this.connectRaw((short)43);
            }
        } else {
            this.fillPatternVar = null;
        }
        this.dataLabelVar = crd.isAvailable(5) ? this.connectRaw((short)5) : null;
        Variable urlVar = this.connectCategory((short)52, false);
        int groupSort = 0;
        StringVectorVariable sortVar = null;
        if (unsortedColorVar != null && this.isDrawByGroupOrder() && (this.groupOrder == 1 || this.groupOrder == 2)) {
            groupSort = this.groupOrder == 1 ? 1 : 2;
            sortVar = unsortedColorVar;
        }
        if (this.sizeVar != null) {
            vp = new VariableProcessor();
            if (sortVar != null && groupSort != 0) {
                this.sizeVar = (NumericVariable)this.addVarToVP(vp, (Variable)this.sizeVar, (Variable)sortVar, groupSort);
                this.xVar = this.addVarToVP(vp, this.xVar, (Variable)sortVar, groupSort);
                this.yVar = this.addVarToVP(vp, this.yVar, (Variable)sortVar, groupSort);
                this.colorVar = this.addVarToVP(vp, this.colorVar, (Variable)sortVar, groupSort);
                if (urlVar != null) {
                    urlVar = this.addVarToVP(vp, urlVar, (Variable)sortVar, groupSort);
                }
                if (this.dataLabelVar != null) {
                    this.dataLabelVar = this.addVarToVP(vp, this.dataLabelVar, (Variable)sortVar, groupSort);
                }
                if (this.fillPatternVar != null) {
                    this.fillPatternVar = this.addVarToVP(vp, this.fillPatternVar, (Variable)sortVar, groupSort);
                }
                if (this.drawingOrder == 0) {
                    vp.setSort((Variable)this.sizeVar, 2);
                }
            } else {
                vp.addVariable((Variable)this.sizeVar);
                vp.addVariable(this.xVar);
                vp.addVariable(this.yVar);
                if (urlVar != null) {
                    vp.addVariable(urlVar);
                }
                if (this.colorVar != null) {
                    vp.addVariable(this.colorVar);
                }
                if (this.dataLabelVar != null) {
                    vp.addVariable(this.dataLabelVar);
                }
                if (this.fillPatternVar != null) {
                    vp.addVariable(this.fillPatternVar);
                }
                if (this.drawingOrder == 0) {
                    vp.setSort((Variable)this.sizeVar, 2);
                }
            }
        }
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (urlVar != null) {
            this.probe.addPipe("_URL_", (Pipe)((StringVariable)urlVar).value);
        }
        if (crd.isAvailable(300)) {
            this.addCustomTips(vp, (Variable)sortVar, groupSort);
        } else {
            this.addTooltip(vp, "X", this.probe, (Variable)sortVar, groupSort);
            this.addTooltip(vp, "Y", this.probe, (Variable)sortVar, groupSort);
            this.addTooltip(vp, "SIZE", this.probe, (Variable)sortVar, groupSort);
            this.addTooltip(vp, "GROUP", this.probe, (Variable)sortVar, groupSort);
            this.addTooltip(vp, "COLORRESPONSE", this.probe, (Variable)sortVar, groupSort);
        }
        this.addCRDWhereClause(vp, (Variable)sortVar, groupSort);
        this.addCHPipe(RPFUtil.applyConditionalHiliting(this.model.getSrcModel(), vp, -1));
        this.bubble.setXVar(this.xVar);
        this.bubble.setYVar(this.yVar);
        this.bubble.setSizeVar(this.sizeVar);
        ContinuousRange sizeRange = (ContinuousRange)this.computeRange((Variable)this.sizeVar, null, true, false, (short)7, false, null, (byte)5);
        if (sizeRange != null) {
            this.bubble.setSizeMin(sizeRange.getMin());
            this.bubble.setSizeMax(sizeRange.getMax());
        }
        if (this.sizeVar != null) {
            VariableProcessor vp2 = new VariableProcessor();
            if (x != null) {
                vp2.addVariable(x);
            }
            if (xRaw != null) {
                vp2.addVariable((Variable)xRaw);
            }
            if (y != null) {
                vp2.addVariable(y);
            }
            if (yRaw != null) {
                vp2.addVariable((Variable)yRaw);
            }
            this.addCRDWhereClause(vp2);
        }
        this.xRange = this.computeRange(x, xRaw, this.numericX, this.discreteX, (short)10, !this.xUnionAllPages, this.xRange, (byte)1);
        this.yRange = this.computeRange(y, yRaw, this.numericY, this.discreteY, (short)11, !this.yUnionAllPages, this.yRange, (byte)2);
        this.fireRangeEvent((byte)1, null, this.xRange);
        this.fireRangeEvent((byte)2, null, this.yRange);
        Variable cvar = unsortedColorVar != null && this.fillPatternVar == null ? unsortedColorVar : this.colorVar;
        this.colorRange = this.computeRange(cvar, null, this.numericColor, false, colorRole, false, this.colorRange, (byte)4);
        this.bubble.setColorVar(this.colorVar);
        this.bubble.setIndexVar(this.indexVar);
        this.bubble.setDataLabelVar(this.dataLabelVar);
    }

    private DataRange computeRange(Variable var, NumericVariable rawVar, boolean numericVar, boolean discrete, short role, boolean subset, DataRange oldRange, byte dim) {
        DataRange newRange = null;
        if (var != null) {
            int num;
            int n = num = numericVar ? var.getValueCount() : var.getUniqueValueCount();
            if (num > 0) {
                if (numericVar) {
                    if (discrete) {
                        var.init();
                        newRange = this.makeOrdinalRange((StringVariable)var, num, rawVar, role, subset);
                    } else {
                        newRange = this.makeContinuousRange((NumericVariable)var, role, subset);
                        newRange = this.bubble.adjustRange(newRange, dim);
                    }
                } else {
                    newRange = Overlay.makeDiscreteRange((StringVariable)var, num);
                }
                newRange.setLabel(var.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat(newRange, role);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        return newRange;
    }

    @Override
    public void select() {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.bubble.select();
    }

    @Override
    protected boolean connectNetwork() {
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        if (this.dataTransparency != 1.0) {
            this.applySkinImage();
        }
        RangeAttrMapper rangeAttrMapper = null;
        DiscreteAttrMapper discreteAttrMapper = null;
        ColorMap fillColorMap = null;
        ColorMap outlineColorMap = null;
        ColorMap dataLabelColorMap = null;
        if (this.fillColorEncoder != null || this.outlineColorEncoder != null) {
            if (this.numericColor) {
                if (this.fillColorEncoder != null) {
                    fillColorMap = (ColorMap)this.fillColorEncoder.getValueMap();
                    fillColorMap.setReplaceMissingValues(true);
                    fillColorMap.setMissingReplacement(this.missingColorResponseColor);
                }
                if (this.outlineColorEncoder != null) {
                    outlineColorMap = (ColorMap)this.outlineColorEncoder.getValueMap();
                    outlineColorMap.setReplaceMissingValues(true);
                    outlineColorMap.setMissingReplacement(this.missingColorResponseColor);
                }
                dataLabelColorMap = this.isFilled() && fillColorMap != null ? fillColorMap : outlineColorMap;
                if (this.hasAttrVar("COLORRESPONSE")) {
                    double max;
                    rangeAttrMapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE");
                    ContinuousRangeToColorMap crtcmap = null;
                    crtcmap = fillColorMap != null ? (ContinuousRangeToColorMap)fillColorMap : (ContinuousRangeToColorMap)outlineColorMap;
                    double min = crtcmap.getInputMin();
                    String error = rangeAttrMapper.createColorMapper(min, max = crtcmap.getInputMax(), fillColorMap == null);
                    if (error != null) {
                        rangeAttrMapper = null;
                    } else if (this.bubble.getFillAttrs().getTransparency() > -1.0) {
                        rangeAttrMapper.setTransparency(this.bubble.getFillAttrs().getTransparency());
                    } else {
                        rangeAttrMapper.setTransparency(this.dataTransparency);
                    }
                }
            } else {
                if (this.isFilled() && this.fillColorEncoder != null) {
                    double transparency = 0.0;
                    transparency = this.getFillAttrs().getTransparency() != -1.0 ? this.getFillAttrs().getTransparency() : this.dataTransparency;
                    fillColorMap = this.getIndexedColorMap((short)3, this.fillColorEncoder.colorArray, this.fillColorEncoder.colorList, transparency);
                }
                if (this.outlineColorEncoder != null) {
                    outlineColorMap = this.getIndexedColorMap((short)3, this.outlineColorEncoder.colorArray, this.outlineColorEncoder.colorList, this.dataTransparency);
                }
                dataLabelColorMap = outlineColorMap;
                if (this.hasAttrVar("GROUP")) {
                    discreteAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                    double fillTrans = this.dataTransparency;
                    if (this.getFillAttrs().getTransparency() != -1.0) {
                        fillTrans = this.getFillAttrs().getTransparency();
                    }
                    discreteAttrMapper.setFillTransparency(fillTrans);
                    discreteAttrMapper.setUseFillTransparency(this.useFillTransparency);
                    discreteAttrMapper.setLineTransparency(this.dataTransparency);
                    if (!this.useLineThickness) {
                        discreteAttrMapper.addLineThicknessPipe("outline", this.getOutlineAttrs().getWidth());
                    }
                }
            }
        }
        HashMap hm = null;
        if (this.lineEncoder != null) {
            hm = this.getIndexedLinePatterns();
        }
        StringToNumberMapper fillPatternMapper = null;
        StringToNumberMapper fillPatternWidthMapper = null;
        ContinuousRangeToColorMapper fillPatternColorMapper = null;
        if (this.isFillPatterned()) {
            if (!this.bubble.isFillPatternOverride() && this.fillPatternEncoder != null) {
                fillPatternMapper = new StringToNumberMapper();
                fillPatternWidthMapper = new StringToNumberMapper();
                if (this.numericColor) {
                    fillPatternMapper.input.connectFrom(((StringVariable)this.fillPatternVar).formattedValue);
                    fillPatternWidthMapper.input.connectFrom(((StringVariable)this.fillPatternVar).formattedValue);
                } else {
                    fillPatternMapper.input.connectFrom(((StringVariable)this.colorVar).formattedValue);
                    fillPatternWidthMapper.input.connectFrom(((StringVariable)this.colorVar).formattedValue);
                }
                this.createIndexFillPatternMapper(fillPatternMapper, fillPatternWidthMapper);
                this.bubble.setFillPatternMapper(fillPatternMapper);
                this.bubble.setFillPatternWidthMapper(fillPatternWidthMapper);
                this.bubble.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
            }
            if (!this.bubble.isFillPatternColorOverride() && outlineColorMap instanceof ContinuousRangeToColorMap) {
                fillPatternColorMapper = new ContinuousRangeToColorMapper();
                fillPatternColorMapper.input.connectFrom(((NumericVariable)this.colorVar).value);
                fillPatternColorMapper.setMap((ContinuousRangeToColorMap)outlineColorMap);
                this.bubble.setFillPatternColorMapper((ColorMapper)fillPatternColorMapper);
            } else if (!this.bubble.isFillPatternColorOverride() && this.fillPatternColorEncoder != null) {
                fillPatternColorMapper = new StringToColorMapper();
                double transparency = this.getFillPatternAttrs().getTransparency() >= 0.0 ? this.getFillPatternAttrs().getTransparency() : this.dataTransparency;
                StringToColorMap fillPatternColorMap = this.getIndexedColorMap((short)3, this.fillPatternColorEncoder.colorArray, this.fillPatternColorEncoder.colorList, transparency);
                ((StringToColorMapper)fillPatternColorMapper).input.connectFrom(((StringVariable)this.colorVar).formattedValue);
                ((StringToColorMapper)fillPatternColorMapper).setMap(fillPatternColorMap);
                this.bubble.setFillPatternColorMapper((ColorMapper)fillPatternColorMapper);
            }
        }
        Object xmap = (NumericMap)this.xEncoder.getValueMap();
        Object ymap = (NumericMap)this.yEncoder.getValueMap();
        if (this.isRelativeScale()) {
            if (this.xEncoder instanceof BrokenPositionEncoder) {
                xmap = ((BrokenPositionEncoder)this.xEncoder).getBrokenValueMap();
            }
            if (this.yEncoder instanceof BrokenPositionEncoder) {
                ymap = ((BrokenPositionEncoder)this.yEncoder).getBrokenValueMap();
            }
        }
        boolean rc = this.bubble.connectNetwork(xmap, ymap, fillColorMap, outlineColorMap, dataLabelColorMap, rangeAttrMapper, discreteAttrMapper, hm, this.probe);
        if (this.isConditionalHilited()) {
            NetworkRoot nr = this.bubble.getNetworkRoot();
            Ellipse ellipse = this.bubble.getEllipseElement();
            for (int i = 0; i < this.getNumCHPipes(); ++i) {
                BooleanVector bv = this.getCHPipe(i);
                com.sas.graphics.util.gtk.gl.Image tag = RPFUtil.newTagElement(i, true, this.bubble.getChannel().getComponent());
                nr.addElement((Element)tag);
                tag.transform.translateX.connectFrom((NumericPipe)ellipse.transform.translateX);
                tag.transform.translateY.connectFrom((NumericPipe)ellipse.transform.translateY);
                tag.horizontalJustification.setValue(2);
                tag.verticalJustification.setValue(0);
                tag.visibility.connectFrom((BooleanPipe)bv);
            }
        }
        this.needConnect = false;
        return rc;
    }

    @Override
    public void draw(Graphics g) {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.bubble.draw();
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                return this.yRange;
            }
            case 4: 
            case 17: {
                return this.colorRange;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.bubble.setChannel(channel);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.fillColorEncoder)) {
                return;
            }
            this.fillColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 17) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.outlineColorEncoder)) {
                return;
            }
            this.outlineColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 15) {
            if (!(encoder instanceof LineEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.lineEncoder)) {
                return;
            }
            this.lineEncoder = (LineEncoder)encoder;
        } else if (dimension == 22) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.fillPatternColorEncoder)) {
                return;
            }
            this.fillPatternColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 21) {
            if (!(encoder instanceof FillPatternEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.fillPatternEncoder)) {
                return;
            }
            this.fillPatternEncoder = (FillPatternEncoder)encoder;
        }
        this.needConnect = true;
    }

    public FillAttrs getFillAttrs() {
        return this.bubble.getFillAttrs();
    }

    public void setFillAttrs(FillAttrs fillAttrs) {
        if (fillAttrs.getTransparency() == -1.0) {
            fillAttrs.setColor(this.applyDataTransparency(fillAttrs.getColor()));
        }
        this.bubble.setFillAttrs(fillAttrs);
    }

    public LineAttrs getOutlineAttrs() {
        return this.bubble.getOutlineAttrs();
    }

    public void setOutlineAttrs(LineAttrs outlineAttrs) {
        outlineAttrs.setColor(this.applyDataTransparency(outlineAttrs.getColor()));
        this.bubble.setOutlineAttrs(outlineAttrs);
    }

    public FillPatternAttrs getFillPatternAttrs() {
        return this.bubble.getFillPatternAttrs();
    }

    public void setFillPatternAttrs(FillPatternAttrs fillPatternAttrs) {
        fillPatternAttrs.setColor(this.applyDataTransparency(fillPatternAttrs.getColor()));
        this.bubble.setFillPatternAttrs(fillPatternAttrs);
    }

    public TextAttrs getDataLabelAttrs() {
        return this.bubble.getDataLabelAttrs();
    }

    public void setDataLabelAttrs(TextAttrs dataLabelAttrs) {
        this.bubble.setDataLabelAttrs(dataLabelAttrs);
    }

    public void setDisplayMode(String mode) {
        this.bubble.setDisplayMode(mode);
    }

    @Override
    public Insets getPreferredInnerMargin() {
        if (this.dataLabelVar != null && this.bubble.isDataLabelSplit()) {
            StringVector splitDataLabelPipe = new StringVector();
            NumericVector splitDataLabelWidth = new NumericVector();
            double maxHeight = this.splitDataLabels(splitDataLabelPipe, splitDataLabelWidth);
            this.bubble.setSplitDataLabel(splitDataLabelPipe);
            this.bubble.setSplitDataLabelWidth(splitDataLabelWidth);
            this.bubble.setSplitDataLabelMaximumHeight(maxHeight);
        }
        Insets pim = this.bubble.getPreferredInnerMargin();
        if (this.isConditionalHilited()) {
            pim.left = Math.max(pim.left, RPFUtil.getCalloutTagWidth());
            pim.bottom = Math.max(pim.bottom, RPFUtil.getCalloutTagHeight());
        }
        return pim;
    }

    private double splitDataLabels(StringVector splitDataLabel, NumericVector splitDataLabelWidth) {
        FontMetrics fm = StatGraph.getFontMetrics(this.bubble.getDataLabelAttrs().getFont());
        boolean splitAlways = true;
        double splitWidth = -1.0;
        double maxHeight = 0.0;
        for (int i = 0; i < this.dataLabelVar.getValueCount(); ++i) {
            String[] labs;
            String s = (String)Variable.getValue((Variable)this.dataLabelVar, (int)i, (boolean)true);
            double w = fm.stringWidth(s);
            double h = fm.getHeight();
            if (!(s.length() < 2 || !splitAlways && !(w > splitWidth) || (labs = BubbleOverlay.splitLabel(s, splitAlways, splitWidth, this.bubble.isDataLabelSplitCharDrop(), this.bubble.getDataLabelSplitChar(), fm)).length < 2 && labs[0].equals(s))) {
                s = labs[0];
                w = fm.stringWidth(s);
                for (int j = 1; j < labs.length; ++j) {
                    w = Math.max(w, (double)fm.stringWidth(labs[j]));
                    s = s + '\n';
                    s = s + labs[j];
                }
                h *= (double)labs.length;
            }
            splitDataLabel.addValue(s);
            splitDataLabelWidth.addValue(w);
            maxHeight = Math.max(maxHeight, h);
        }
        return maxHeight;
    }

    @Override
    public String[] getUniqueValues(short role) {
        if (role == 6 || role == 46) {
            Object[] vals;
            if (this.colorRange instanceof DiscreteRange && (vals = ((DiscreteRange)this.colorRange).getValues().toArray()) != null) {
                String[] str = new String[vals.length];
                for (int i = 0; i < vals.length; ++i) {
                    str[i] = vals[i].toString();
                }
                return str;
            }
        } else if (role == 36) {
            return super.getUniqueValues((short)3);
        }
        return super.getUniqueValues(role);
    }

    public boolean isFilled() {
        return this.bubble.isFilled();
    }

    public boolean isOutlined() {
        return this.bubble.isOutlined();
    }

    public boolean isFillPatterned() {
        return this.bubble.isFillPatterned();
    }

    public boolean isRelativeScale() {
        return this.bubble.isRelativeScale();
    }

    public void setRelativeScale(boolean relativeScale) {
        this.bubble.setRelativeScale(relativeScale);
    }

    public NumericVariable getIndexVar() {
        return this.bubble.getIndexVar();
    }

    public void setIndexVar(NumericVariable indexVar) {
        this.bubble.setIndexVar(indexVar);
    }

    protected StringToColorMap getIndexedColorMap(short role, Color[] cl, HashMap cTable, double transparency) {
        Object colors = StatGraph.isOLAP() ? StatGraph.getOLAPLevelVar(this.model, (short)3) : (StringVectorVariable)this.connectCategory(role, true);
        short indexRole = 41;
        NumericVectorVariable indices = null;
        if (this.model.isAvailable(indexRole)) {
            indices = (NumericVectorVariable)this.connectRaw(indexRole);
        }
        Variable[] vars = null;
        vars = indices != null ? new Variable[]{colors, indices} : new Variable[]{colors};
        this.applyWhereClause(vars);
        StringToColorMap colorMap = new StringToColorMap();
        Color[] lc = new Color[colors.getUniqueValueCount()];
        for (int i = 0; i < colors.getUniqueValueCount(); ++i) {
            try {
                if (indices != null) {
                    int obs = colors.getFirstOccurringValueIndex(i);
                    int idx = (int)indices.value.getValue(obs) - 1;
                    lc[i] = BubbleOverlay.applyTransparency(cl[idx % cl.length], transparency);
                } else {
                    lc[i] = cTable != null ? BubbleOverlay.applyTransparency((Color)cTable.get(colors.formattedUniqueValue.getValue(i)), transparency) : BubbleOverlay.applyTransparency(cl[i % cl.length], transparency);
                }
                colorMap.add(colors.formattedUniqueValue.getValue(i), lc[i]);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return colorMap;
    }

    private HashMap getIndexedLinePatterns() {
        LineAttrs[] ll = this.lineEncoder.styleArray;
        boolean numericLine = this.model.getColumnClass(3) == Double.class;
        StringVectorVariable lines = (StringVectorVariable)this.connectCategory((short)3, true);
        NumericVectorVariable indices = null;
        if (this.model.isAvailable(43)) {
            indices = (NumericVectorVariable)this.connectRaw((short)43);
        }
        this.applyWhereClause(new Variable[]{lines, indices});
        HashMap<String, Integer> linePatterns = new HashMap<String, Integer>();
        for (int i = 0; i < lines.getUniqueValueCount(); ++i) {
            try {
                int p;
                String g = lines.formattedUniqueValue.getValue(i);
                DiscreteAttrMapper attrMapper = null;
                if (this.hasAttrVar("GROUP")) {
                    attrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                }
                if (attrMapper != null && (p = attrMapper.getLinePattern(g)) >= 0) {
                    linePatterns.put(g, p);
                    continue;
                }
                int obs = lines.getFirstOccurringValueIndex(i);
                if (indices != null) {
                    int idx = (int)indices.value.getValue(obs) - 1;
                    linePatterns.put(g, ll[idx % ll.length].getLinePattern());
                    continue;
                }
                linePatterns.put(g, ((LineAttrs)this.lineEncoder.styleList.get(g)).getLinePattern());
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return linePatterns;
    }

    private HashMap getIndexedFillPatterns() {
        int[] pat = this.fillPatternEncoder.patternArray;
        HashMap ht = this.fillPatternEncoder.patternList;
        boolean numericLine = this.model.getColumnClass(3) == Double.class;
        StringVectorVariable fillPatternVar = (StringVectorVariable)this.connectCategory((short)3, true);
        Object indices = null;
        if (this.model.isAvailable(43)) {
            this.indexVar = (NumericVectorVariable)this.connectRaw((short)43);
        }
        this.applyWhereClause(new Variable[]{fillPatternVar, this.indexVar});
        HashMap<String, Integer> fillPatterns = new HashMap<String, Integer>();
        for (int i = 0; i < fillPatternVar.getUniqueValueCount(); ++i) {
            try {
                int p;
                String fpval = fillPatternVar.uniqueValue.getValue(i);
                if (this.indexVar == null) {
                    p = (Integer)ht.get(fpval);
                } else {
                    int obs = fillPatternVar.getFirstOccurringValueIndex(i);
                    try {
                        int idx = (int)this.indexVar.value.getValue(obs) - 1;
                        p = pat[idx % pat.length];
                    }
                    catch (MissingValueException e) {
                        p = this.getFillPatternAttrs().getPattern();
                    }
                }
                fillPatterns.put(fpval, p);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return fillPatterns;
    }

    private void createIndexFillPatternMapper(StringToNumberMapper fillPatternMapper, StringToNumberMapper fillPatternWidthMapper) {
        int[] pat = this.fillPatternEncoder.patternArray;
        HashMap ht = this.fillPatternEncoder.patternList;
        boolean numericLine = this.model.getColumnClass(3) == Double.class;
        StringVectorVariable fillPatternVar = (StringVectorVariable)this.connectCategory((short)3, true);
        Object indices = null;
        if (this.model.isAvailable(43)) {
            this.indexVar = (NumericVectorVariable)this.connectRaw((short)43);
        }
        this.applyWhereClause(new Variable[]{fillPatternVar, this.indexVar});
        for (int i = 0; i < fillPatternVar.getUniqueValueCount(); ++i) {
            int p;
            if (this.indexVar == null) {
                try {
                    String fpval = fillPatternVar.uniqueValue.getValue(i);
                    p = (Integer)ht.get(fpval);
                }
                catch (MissingValueException e) {
                    p = this.getFillPatternAttrs().getPattern();
                }
            } else {
                int obs = fillPatternVar.getFirstOccurringValueIndex(i);
                try {
                    int idx = (int)this.indexVar.value.getValue(obs) - 1;
                    p = pat[idx % pat.length];
                }
                catch (MissingValueException e) {
                    p = this.getFillPatternAttrs().getPattern();
                }
            }
            try {
                String gval = fillPatternVar.uniqueValue.getValue(i);
                fillPatternWidthMapper.add(gval, (Number)new Double(FillPatternAttrs.getPatternWidth((int)p)));
                fillPatternMapper.add(gval, (Number)new Double(BarOverlay.getGLFillPattern(p)));
                continue;
            }
            catch (MissingValueException e) {
                fillPatternWidthMapper.setMissingReplacement((double)FillPatternAttrs.getPatternWidth((int)p), e.getMissingValue());
                fillPatternMapper.setMissingReplacement((double)BarOverlay.getGLFillPattern(p), e.getMissingValue());
            }
        }
    }

    @Override
    public boolean isGroupAllMissings() {
        if (this.colorVar instanceof NumericVariable && this.fillPatternVar == null) {
            return false;
        }
        return super.isGroupAllMissings();
    }

    @Override
    public String[] getGroupValues() {
        if (this.colorVar instanceof StringVariable || this.fillPatternVar != null) {
            return this.getUniqueGroupValues((short)3);
        }
        return null;
    }

    public int getDataLabelPosition() {
        return this.bubble.getDataLabelPosition();
    }

    public void setDataLabelPosition(int dataLabelPosition) {
        this.bubble.setDataLabelPosition(dataLabelPosition);
    }

    @Override
    public void setDataLabelSplit(boolean split) {
        this.bubble.setDataLabelSplit(split);
    }

    @Override
    public boolean isDataLabelSplit() {
        return this.bubble.isDataLabelSplit();
    }

    @Override
    public void setDataLabelSplitChar(char[] schars) {
        this.bubble.setDataLabelSplitChar(schars);
    }

    @Override
    public char[] getDataLabelSplitChar() {
        return this.bubble.getDataLabelSplitChar();
    }

    @Override
    public void setDataLabelSplitCharDrop(boolean b) {
        this.bubble.setDataLabelSplitCharDrop(b);
    }

    @Override
    public boolean isDataLabelSplitCharDrop() {
        return this.bubble.isDataLabelSplitCharDrop();
    }

    @Override
    public void setDataLabelSplitJustify(int justify) {
        this.bubble.setDataLabelSplitJustify(justify);
    }

    @Override
    public int getDataLabelSplitJustify() {
        return this.bubble.getDataLabelSplitJustify();
    }

    @Override
    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        if (!this.isFilled()) {
            return 10;
        }
        return this.isOutlined() ? 11 : 7;
    }

    @Override
    protected void applyDataSkin(LegendItem[] items) {
        if (!this.isFilled() || this.skinType == 0) {
            return;
        }
        Image legendSkin = this.loadLegendSkinImage();
        Image[] legendPixelBender = this.loadLegendPixelBenderImages();
        for (int i = 0; i < items.length; ++i) {
            items[i].setPixelBenderImages(legendPixelBender);
            items[i].setSkinType(this.skinType);
            items[i].setSkinImage(legendSkin);
        }
    }

    @Override
    protected void applyFillTransparency(LegendItem[] items) {
        if (!this.isFilled() || !this.useFillTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(items[i].getSymbolAttrs().getColor(), this.getFillAttrs().getTransparency()));
            items[i].setSymbolAttrs((ColorAttr)fa);
        }
    }

    @Override
    protected void applyLineTransparency(LegendItem[] items) {
        if (this.isFilled() || !this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            LineAttrs old = (LineAttrs)items[i].getSymbolAttrs();
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(old.getColor()));
            la.setLinePattern(old.getLinePattern());
            la.setWidth(old.getWidth());
            items[i].setSymbolAttrs((ColorAttr)la);
        }
    }

    @Override
    protected LegendItem[] getLegendItemsFromAttrMap(String attrVarName, int attrType) {
        LegendItem[] items = super.getLegendItemsFromAttrMap(attrVarName, attrType);
        if (attrType != 10) {
            for (int i = 0; i < items.length; ++i) {
                items[i].setFillType(2);
            }
        }
        return items;
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.dataTransparency != 1.0) {
            this.applySkinImage();
        }
        if (this.colorVar != null && this.colorVar instanceof StringVariable) {
            double fillTrans = this.dataTransparency;
            if (this.getFillAttrs().getTransparency() != -1.0) {
                fillTrans = this.getFillAttrs().getTransparency();
            }
            DiscreteAttrMapper discreteAttrMapper = null;
            if (this.hasAttrVar("GROUP")) {
                discreteAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                discreteAttrMapper.setFillTransparency(fillTrans);
                discreteAttrMapper.setUseFillTransparency(this.useFillTransparency);
                discreteAttrMapper.setLineTransparency(this.dataTransparency);
                if (!this.useLineThickness) {
                    discreteAttrMapper.addLineThicknessPipe("outline", this.getOutlineAttrs().getWidth());
                }
            }
            HashMap lineStyles = null;
            if (this.lineEncoder != null) {
                lineStyles = this.getIndexedLinePatterns();
            }
            StringToColorMap fillColorMap = null;
            StringToColorMap outlineColorMap = null;
            StringToColorMap fillPatternColorMap = null;
            HashMap fillPatterns = null;
            if (this.isFilled()) {
                fillColorMap = this.getIndexedColorMap((short)3, this.fillColorEncoder.colorArray, this.fillColorEncoder.colorList, fillTrans);
                fillColorMap.init(new AInitAction());
            }
            if (this.outlineColorEncoder != null) {
                outlineColorMap = this.getIndexedColorMap((short)3, this.outlineColorEncoder.colorArray, this.outlineColorEncoder.colorList, this.dataTransparency);
                outlineColorMap.init(new AInitAction());
            }
            if (this.fillPatternColorEncoder != null) {
                fillPatternColorMap = this.getIndexedColorMap((short)3, this.fillPatternColorEncoder.colorArray, this.fillPatternColorEncoder.colorList, this.dataTransparency);
                fillPatternColorMap.init(new AInitAction());
            }
            if (this.fillPatternEncoder != null) {
                fillPatterns = this.getIndexedFillPatterns();
            }
            Object colors = StatGraph.isOLAP() ? StatGraph.getOLAPLevelVar(this.model, (short)3) : (StringVectorVariable)this.connectCategory((short)3, this.includeMissingGroup);
            if (this.groupOrder == 1 || this.groupOrder == 2) {
                boolean numericGroup;
                VariableProcessor vp = new VariableProcessor();
                vp.addVariable((Variable)colors);
                boolean bl = numericGroup = this.model.getColumnClass(3) == Double.class;
                if (numericGroup) {
                    Variable rawColors = this.connectRaw((short)3);
                    vp.addVariable(rawColors);
                    vp.setSort(rawColors, this.groupOrder == 1 ? 1 : 2);
                } else {
                    vp.setSort((Variable)colors, this.groupOrder == 1 ? 1 : 2);
                }
            }
            LegendItem[] items = this.isFilled() ? this.bubble.getLegendItems(colors, attrType, discreteAttrMapper, fillColorMap, outlineColorMap, lineStyles, fillPatternColorMap, fillPatterns, fillTrans, this.dataTransparency) : this.bubble.getLegendItems(colors, attrType, discreteAttrMapper, fillColorMap, outlineColorMap, lineStyles, fillPatternColorMap, fillPatterns, fillTrans, this.dataTransparency);
            if (this.isLegendEntryFromAttrMap("GROUP")) {
                items = BubbleOverlay.margeAttrMapWithPlotLegendItems((DiscreteAttrMapper)this.getAttrVarMapper("GROUP"), items, this.getFillAttrs(), this.getOutlineAttrs(), this.bubble.isFillColorOverride(), this.useFillTransparency, !this.bubble.isOutlined() || this.bubble.isOutlineColorOverride(), this.bubble.isFilled() ? true : this.bubble.isOutlinePatternOverride(), this.bubble.isFilled() ? true : !discreteAttrMapper.lineThickness.containsKey("outline"), this.dataTransparency, this.bubble.isOutlined() && this.useDataTransparency);
            }
            return items;
        }
        if (this.fillPatternVar != null) {
            return this.getFillPatternLegendItems();
        }
        String defaultLabel = this.sizeVar.getLabel();
        if (defaultLabel == null) {
            defaultLabel = this.name;
        }
        return new LegendItem[]{this.bubble.getOverlayLegendItem(this.legendLabel != null ? this.legendLabel : defaultLabel)};
    }

    private LegendItem[] getFillPatternLegendItems() {
        HashMap fillPatterns = null;
        if (this.fillPatternEncoder != null) {
            fillPatterns = this.getIndexedFillPatterns();
        }
        Vector<LegendItem> legendItems = new Vector<LegendItem>();
        Object colors = StatGraph.isOLAP() ? StatGraph.getOLAPLevelVar(this.model, (short)3) : (StringVectorVariable)this.connectCategory((short)3, this.includeMissingGroup);
        if (this.groupOrder == 1 || this.groupOrder == 2) {
            boolean numericGroup;
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable((Variable)colors);
            boolean bl = numericGroup = this.model.getColumnClass(3) == Double.class;
            if (numericGroup) {
                Variable rawColors = this.connectRaw((short)3);
                vp.addVariable(rawColors);
                vp.setSort(rawColors, this.groupOrder == 1 ? 1 : 2);
            } else {
                vp.setSort((Variable)colors, this.groupOrder == 1 ? 1 : 2);
            }
        }
        for (int i = 0; i < colors.getUniqueValueCount(); ++i) {
            try {
                String value = colors.formattedUniqueValue.getValue(i);
                FillAttrs fa = new FillAttrs();
                if (this.isFilled()) {
                    fa.setColor(this.applyDataTransparency((ColorAttr)this.bubble.getFillAttrs()));
                } else {
                    fa.setColor(null);
                }
                LineAttrs la = new LineAttrs();
                if (this.bubble.isOutlined()) {
                    la.setColor(this.applyDataTransparency((ColorAttr)this.bubble.getOutlineAttrs()));
                } else {
                    la.setColor(null);
                }
                la.setLinePattern(this.bubble.getOutlineAttrs().getLinePattern());
                la.setWidth(this.bubble.getOutlineAttrs().getWidth());
                LegendItem item = new LegendItem((ColorAttr)fa, (ColorAttr)la, value, null, this.bubble.getSkin(), this.skinType, this.bubble.getLegendPixelBenderImages());
                item.setFillType(2);
                int fp = this.bubble.isFillPatternOverride() ? this.bubble.getFillPatternAttrs().getPattern() : ((Integer)fillPatterns.get(value)).intValue();
                FillPatternAttrs fpAttrs = new FillPatternAttrs();
                fpAttrs.setPattern(fp);
                fpAttrs.setColor(this.applyDataTransparency((ColorAttr)this.bubble.getFillPatternAttrs()));
                item.setFillPatternAttrs(fpAttrs);
                legendItems.add(item);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if (legendItems.size() > 0) {
            return legendItems.toArray(new LegendItem[legendItems.size()]);
        }
        return null;
    }

    @Override
    public boolean hasLegend(int attrType) {
        boolean hasLegend = false;
        switch (attrType) {
            case 0: {
                if (this.colorVar instanceof NumericVariable && this.fillPatternVar == null) break;
                hasLegend = true;
                break;
            }
            case 7: 
            case 11: {
                if (!this.bubble.isFilled() || this.colorVar instanceof NumericVariable) break;
                hasLegend = true;
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                if (this.colorVar instanceof NumericVariable || this.bubble.isFilled() || !this.bubble.isOutlined()) break;
                hasLegend = true;
            }
        }
        return hasLegend;
    }

    @Override
    public boolean hasMissingValue() {
        CRD crd = this.model;
        if (!crd.isAvailable(108)) {
            return false;
        }
        int clrvIDX = this.model.getSrcModel().getColumn(this.model.getColumnName((short)108));
        ColumnMetadata cmd = (ColumnMetadata)this.model.getSrcModel().getColumnLabel(clrvIDX);
        return cmd.getMissings() > 0;
    }

    @Override
    public Color getMissingColor() {
        return this.missingColorResponseColor;
    }

    @Override
    public Range[] getColorModelRanges(int type) {
        RangeAttrMapper rangeAttrMapper = null;
        if (this.numericColor && (this.fillColorEncoder != null || this.outlineColorEncoder != null)) {
            ColorMap colorMap = null;
            ColorEncoder ce = null;
            boolean fillOn = true;
            if (this.fillColorEncoder != null) {
                colorMap = (ColorMap)this.fillColorEncoder.getValueMap();
                ce = this.fillColorEncoder;
            } else {
                colorMap = (ColorMap)this.outlineColorEncoder.getValueMap();
                ce = this.outlineColorEncoder;
                fillOn = false;
            }
            if (this.hasAttrVar("COLORRESPONSE")) {
                double max;
                ContinuousRangeToColorMap crtcmap;
                double min;
                rangeAttrMapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE");
                String error = rangeAttrMapper.createColorMapper(min = (crtcmap = (ContinuousRangeToColorMap)colorMap).getInputMin(), max = crtcmap.getInputMax(), !fillOn);
                if (error != null) {
                    StatGraph.printWarning(error);
                    rangeAttrMapper = null;
                    return this.getDefaultColorModelRanges(ce);
                }
                if (this.bubble.getFillAttrs().getTransparency() > -1.0) {
                    return rangeAttrMapper.getRangeColorMapper().getFullRanges(this.bubble.getFillAttrs().getTransparency());
                }
                return rangeAttrMapper.getRangeColorMapper().getFullRanges(this.dataTransparency);
            }
            return this.getDefaultColorModelRanges(ce);
        }
        return null;
    }

    private Range[] getDefaultColorModelRanges(ColorEncoder ce) {
        Color[] colors = ce.rampColors;
        ContinuousRange range = (ContinuousRange)ce.getInput();
        Range[] colorModelRanges = new Range[1];
        RangeBound low = new RangeBound(range.getMin(), true);
        RangeBound high = new RangeBound(range.getMax(), true);
        ColorModel colorModel = new ColorModel(colors);
        colorModelRanges[0] = new Range(low, high, colorModel);
        return colorModelRanges;
    }

    @Override
    public SASFormat getContinuousLegendFormat() {
        if (this.numericColor && this.fillColorEncoder != null) {
            return this.fillColorEncoder.getInput().getFormat();
        }
        if (this.numericColor && this.outlineColorEncoder != null) {
            return this.outlineColorEncoder.getInput().getFormat();
        }
        return null;
    }

    public double getMinBubbleSize() {
        return this.bubble.getMinBubbleSize();
    }

    public void setMinBubbleSize(double minBubbleSize) {
        this.bubble.setMinBubbleSize(minBubbleSize);
    }

    public double getMaxBubbleSize() {
        return this.bubble.getMaxBubbleSize();
    }

    public void setMaxBubbleSize(double maxBubbleSize) {
        this.bubble.setMaxBubbleSize(maxBubbleSize);
    }

    public void setFillColorOverride(boolean override) {
        this.bubble.setFillColorOverride(override);
    }

    public void setOutlineColorOverride(boolean override) {
        this.bubble.setOutlineColorOverride(override);
    }

    public void setOutlinePatternOverride(boolean override) {
        this.bubble.setOutlinePatternOverride(override);
    }

    public void setFillPatternOverride(boolean override) {
        this.bubble.setFillPatternOverride(override);
    }

    public void setFillPatternColorOverride(boolean override) {
        this.bubble.setFillPatternColorOverride(override);
    }

    public void setDataLabelColorOverride(boolean override) {
        this.bubble.setDataLabelColorOverrride(override);
    }

    public boolean isIncludeMissingGroup() {
        return this.includeMissingGroup;
    }

    public void setIncludeMissingGroup(boolean includeMissingGroup) {
        this.includeMissingGroup = includeMissingGroup;
    }

    private void applySkinImage() {
        if (!this.isFilled() && this.isFillPatterned()) {
            this.skinType = 0;
        }
        if (this.skinType == 0 || this.bubble.getChannel() == null) {
            return;
        }
        this.bubble.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
        this.bubble.setPixelBenderImages(this.loadPixelBenderImages(this.bubble.getNetworkRoot(), this.skinType, 5));
        this.bubble.setLegendPixelBenderImages(this.loadLegendPixelBenderImages(this.bubble.getNetworkRoot(), this.skinType, 5));
        Component c = this.bubble.getChannel().getComponent();
        if (c == null) {
            Image skinImage = Toolkit.getDefaultToolkit().getImage(this.getSkinImageLocation());
            if (this.bubble.isRelativeScale()) {
                if (this.skinType == 6 || this.skinType == 3) {
                    this.bubble.setSkin(skinImage);
                }
                this.bubble.setSkinType(this.skinType);
            } else {
                this.bubble.setSkin(skinImage);
                this.bubble.setSkinType(0);
            }
            this.needConnect = true;
            return;
        }
        MediaTracker tracker = new MediaTracker(this.bubble.getChannel().getComponent());
        try {
            Image skinImage = Toolkit.getDefaultToolkit().getImage(this.getSkinImageLocation());
            tracker.addImage(skinImage, 0);
            tracker.waitForAll();
            if (this.bubble.isRelativeScale()) {
                if (this.skinType == 6 || this.skinType == 3) {
                    this.bubble.setSkin(skinImage);
                }
                this.bubble.setSkinType(this.skinType);
            } else {
                this.bubble.setSkin(skinImage);
                this.bubble.setSkinType(0);
            }
            this.needConnect = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private URL getSkinImageLocation() {
        switch (this.skinType) {
            default: {
                return null;
            }
            case 5: {
                return StatGraph.class.getResource("sgchart/res/Bubble_Crisp.png");
            }
            case 6: {
                return StatGraph.class.getResource("sgchart/res/Bubble_Gloss.png");
            }
            case 7: {
                return StatGraph.class.getResource("sgchart/res/Bubble_Matte.png");
            }
            case 3: {
                return StatGraph.class.getResource("sgchart/res/Bubble_Pressed.png");
            }
            case 4: 
        }
        return StatGraph.class.getResource("sgchart/res/Bubble_Sheen.png");
    }

    public double getScale() {
        return this.bubble.getScale();
    }

    public void setScale(int scale) {
        this.bubble.setScale(scale);
    }

    private void connectOLAPVars() {
        CRD crd = this.model;
        this.numericX = true;
        this.xVar = crd.isAvailable(10) ? StatGraph.getOLAPMeasureVar(crd, (short)10) : null;
        this.numericY = true;
        this.yVar = crd.isAvailable(11) ? StatGraph.getOLAPMeasureVar(crd, (short)11) : null;
        this.sizeVar = crd.isAvailable(7) ? StatGraph.getOLAPMeasureVar(crd, (short)7) : null;
        StringVariable unsortedColorVar = null;
        if (crd.isAvailable(3)) {
            this.colorVar = StatGraph.getOLAPLevelVar(crd, (short)3);
            unsortedColorVar = StatGraph.getOLAPLevelVar(crd, (short)3);
        } else {
            this.colorVar = null;
        }
        VariableProcessor vp = null;
        if (this.sizeVar != null) {
            vp = new VariableProcessor();
            vp.addVariable((Variable)this.sizeVar);
            vp.addVariable(this.xVar);
            vp.addVariable(this.yVar);
            if (this.colorVar != null) {
                vp.addVariable(this.colorVar);
            }
            vp.setSort((Variable)this.sizeVar, 2);
        }
        this.addCRDWhereClause(vp);
        this.addCHPipe(RPFUtil.applyConditionalHiliting(this.model.getSrcModel(), vp, -1));
        this.bubble.setXVar(this.xVar);
        this.bubble.setYVar(this.yVar);
        this.bubble.setSizeVar(this.sizeVar);
        ContinuousRange sizeRange = (ContinuousRange)this.computeRange((Variable)this.sizeVar, null, true, false, (short)7, false, null, (byte)5);
        if (sizeRange != null) {
            this.bubble.setSizeMin(sizeRange.getMin());
            this.bubble.setSizeMax(sizeRange.getMax());
        }
        this.xRange = this.computeRange(this.xVar, null, true, false, (short)10, !this.xUnionAllPages, this.xRange, (byte)1);
        this.yRange = this.computeRange(this.yVar, null, true, false, (short)11, !this.yUnionAllPages, this.yRange, (byte)2);
        this.fireRangeEvent((byte)1, null, this.xRange);
        this.fireRangeEvent((byte)2, null, this.yRange);
        this.colorRange = this.computeRange((Variable)unsortedColorVar, null, false, true, (short)3, false, this.colorRange, (byte)4);
        this.bubble.setColorVar(this.colorVar);
        this.bubble.setIndexVar(this.indexVar);
        this.bubble.setDataLabelVar(this.dataLabelVar);
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return !this.model.isAvailable(3);
    }

    @Override
    public String getDefaultLegendTitle() {
        String title = null;
        if (this.model.isAvailable(3)) {
            if (StatGraph.isOLAP()) {
                OLAPLevelVariable olv = (OLAPLevelVariable)this.colorVar;
                OLAPVariableFactory fac = olv.getFactory();
                List list = fac.getLevelNamesForHeirarchy(olv.getHierachyName());
                String levelName = (String)list.get(0);
                title = fac.getLabel(levelName).trim();
            } else {
                ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(3);
                title = cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
            }
        }
        return title;
    }

    public void setRelativeScaleType(int relativeScaleType) {
        this.bubble.setRelativeScaleType(relativeScaleType);
    }

    public void setSizeThresholdMax(double sizeThresholdMax) {
        this.bubble.setSizeThresholdMax(sizeThresholdMax);
    }

    public Color getMissingColorResponseColor() {
        return this.missingColorResponseColor;
    }

    public void setMissingColorResponseColor(Color color) {
        this.missingColorResponseColor = color;
    }

    @Override
    protected int getNumberOfDrawingElements() {
        return this.xVar.getValueCount();
    }

    public void setDrawingOrder(int order) {
        this.drawingOrder = order;
    }

    public int getDrawingOrder() {
        return this.drawingOrder;
    }
}

