/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RPFUtil;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.FillPatternEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.LineEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.labeling.LabelPlacementInterface;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RB;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.util.ContinuousTickSpacer;
import com.sas.graphics.util.ZxAxis;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BidirectionalAccumulatorByCategory;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.Categorizer;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.DiscreteRangeToColorMap;
import com.sas.graphics.util.gtk.DiscreteRangeToColorMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.FrequencyVariable;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericToColorMap;
import com.sas.graphics.util.gtk.NumericToColorMapper;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StatisticByCategory;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.LineConnector;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class BarOverlay
extends Overlay {
    public static final String RB_KEY = "BarOverlay.";
    public static final byte VERTICAL = 0;
    public static final byte HORIZONTAL = 1;
    public static final byte NONE = 0;
    public static final byte BASE = 1;
    public static final byte MIDDLE = 2;
    public static final byte END = 3;
    public static final byte ALIGNED = 0;
    public static final byte STACKED = 1;
    public static final int XASCENDING = 4;
    public static final int XDESCENDING = 5;
    public static final int YASCENDING = 6;
    public static final int YDESCENDING = 7;
    protected boolean fillOn = true;
    protected FillAttrs fillStyle = new FillAttrs();
    protected boolean fillPatternOn = false;
    protected FillPatternAttrs fillPatternStyle = new FillPatternAttrs();
    protected LineAttrs referenceStyle = new LineAttrs();
    protected boolean edgeOn = true;
    protected LineAttrs edgeStyle = new LineAttrs();
    protected LineAttrs errorStyle = new LineAttrs();
    protected boolean connectOn = false;
    protected boolean connectSkipMiss = false;
    protected LineAttrs connectStyle = new LineAttrs();
    protected byte orientation = 0;
    protected byte groupDisplay = 0;
    protected byte labelPosition = (byte)3;
    protected DataRange xRange;
    protected DataRange yRange;
    protected DataRange colorRange;
    protected DataRange lineRange;
    protected DataRange lineColorRange;
    protected DataRange fillPatternRange;
    protected DataRange fillPatternColorRange;
    protected DataRange yUpperErrorRange;
    protected DataRange yLowerErrorRange;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder colorEncoder;
    protected ColorEncoder lineColorEncoder;
    protected LineEncoder lineEncoder;
    protected FillPatternEncoder fillPatternEncoder;
    protected ColorEncoder fillPatternColorEncoder;
    protected PositionEncoder yUpperErrorEncoder;
    protected PositionEncoder yLowerErrorEncoder;
    private boolean numericColor = true;
    private boolean numericLineColor = true;
    private boolean numericGroup = false;
    private boolean numericLabel = true;
    private NetworkRoot networkRoot;
    private NetworkRoot networkRoot2;
    private Variable categoryVar;
    private NumericVectorVariable numericCategoryVar;
    private NumericVariable responseVar;
    private Variable groupVar;
    private Variable indexVar;
    private Variable colorVar;
    private Variable lineVar;
    private Variable lineColorVar;
    private Variable fillPatternVar;
    private Variable fillPatternColorVar;
    private Variable labelVar;
    private NumericVectorVariable yUpperErrorVar;
    private NumericVectorVariable yLowerErrorVar;
    private NumericVectorVariable targetVar;
    private Variable rawGroupVar;
    private Variable categorySortVar;
    private NumericVariable[] multiResponseVars = null;
    private String[] multiResponseLabels = null;
    private int responseCount = 0;
    private Variable categoryVar_sav;
    public static final double DEFAULT_BARWIDTH = 0.85;
    private double barWidth = 0.85;
    private double clusterWidth = 0.85;
    private double intervalBarWidth = -1.0;
    private static final double INTERVAL_BAR_SCALE = 0.85;
    private Probe yueProbe;
    private Probe yleProbe;
    private int order = 0;
    private int[] groupsPerCategory;
    private String overlayID;
    private Bar bar;
    private Calculator offsetCalculator;
    private boolean subset;
    private int[] subsetObs;
    private int subsetObsCount;
    private int statistic = -1;
    private int colorStatistic = -1;
    public static int SEGMENTLABEL_FIT_NONE = 0;
    public static int SEGMENTLABEL_FIT_THIN = 1;
    public static int SEGMENTLABEL_FIT_NOCLIP = 2;
    private boolean showSegmentLabel = false;
    private int segmentLabelFitPolicy = SEGMENTLABEL_FIT_THIN;
    private TextStyle segmentLabelStyle = new TextStyle();
    private SASFormat segmentLabelFormat = null;
    private boolean useSegmentLabelColor = true;
    private boolean showBarValue = false;
    private ContinuousRange statRange;
    private double[] positiveAccumulation = null;
    private double[] negativeAccumulation = null;
    private String longestLabel = null;
    private SASFormat labelFormat = null;
    private TextStyle labelStyle = new TextStyle();
    private int extraPadding;
    private Variable labVar;
    private NumericVariable respVar;
    private Variable catVar;
    private boolean updateLabelVars = true;
    private boolean compact = true;
    private boolean useLabelColor = false;
    private boolean useEdgeColor = false;
    private boolean useEdgePattern = false;
    private boolean rotateLabelAsNeeded = false;
    private boolean labelInsidePreferred = false;
    private boolean autoRotateLabel = true;
    private boolean labelRotated = false;
    private boolean labelDropped = false;
    private boolean labelInside = false;
    private boolean[] labelInsideBar;
    private boolean insideLabelCenterJustification = false;
    private Image skinImage = null;
    protected double discreteOffset = 0.0;
    private Color targetColor = Color.black;
    private boolean baselineOn = true;
    private boolean autoBaseline = false;
    private double baseline = 0.0;
    protected LineAttrs baselineStyle = new LineAttrs();
    private boolean weightedByCategories = false;
    private int connectionOrder = 0;
    private boolean gradientColor = false;
    private Color missingColorResponseColor = Color.black;
    private boolean dataLabelSplit = false;
    private StringVector splitDataLabelPipe;
    private static double ZERO_VALUE = 1.0E-6;
    private boolean errorCapVisible = true;
    private boolean discreteCategory = true;
    private boolean binCategory = false;
    private double binStart = Double.NaN;
    private double binWidth = Double.NaN;
    private double nBins = Double.NaN;
    private int nBinsHint = 10;
    private boolean group100 = false;
    private boolean positiveGroupOnly = false;
    private NumericVector percentWeight = null;
    private SASFormat group100Format;
    private boolean displayZeroHeightBar = true;

    public void setGroup100(boolean b) {
        this.group100 = b;
        if (this.group100) {
            this.group100Format = SASFormat.getInstance((String)"NLPCT10.2");
        }
    }

    public boolean isGroup100() {
        return this.group100;
    }

    public void setDisplayZeroHeightBar(boolean b) {
        this.displayZeroHeightBar = b;
    }

    public boolean isDisplayZeroHeightBar() {
        return this.displayZeroHeightBar;
    }

    public void setPositiveGroupOnly(boolean b) {
        this.positiveGroupOnly = b;
    }

    public boolean isPositiveGroupOnly() {
        return this.positiveGroupOnly;
    }

    public boolean isAutoBaseline() {
        return this.autoBaseline;
    }

    public void setAutoBaseline(boolean auto) {
        this.autoBaseline = auto;
    }

    public boolean isBaselineOn() {
        return this.baselineOn;
    }

    public void setBaselineOn(boolean on) {
        this.baselineOn = on;
        this.autoBaseline = false;
    }

    public double getBaseline() {
        return this.baseline;
    }

    public void setBaseline(double baseline) {
        this.baseline = baseline;
    }

    public LineAttrs getBaselineStyle() {
        return this.baselineStyle;
    }

    public void setBaselineStyle(LineAttrs baselineStyle) {
        this.baselineStyle = baselineStyle;
    }

    public boolean isDataLabeled() {
        return this.labelVar != null;
    }

    @Override
    public void addObstacles(LabelPlacementInterface lp, PointLabelLayout l, int yOutputRange) {
        FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
        int fmHeight = fm.getHeight();
        if (this.getOrientation() == 0) {
            ValueMap xmap = this.xEncoder.getValueMap();
            ContinuousRangeToNumericMap ymap = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
            boolean reverse = this.yEncoder.isReversed();
            for (int i = 0; i < this.labVar.getValueCount(); ++i) {
                try {
                    double xpos;
                    String s = this.numericLabel ? ((NumericVariable)this.labVar).formattedValue.getValue(i).trim() : ((StringVariable)this.labVar).formattedValue.getValue(i).trim();
                    double w = Math.ceil(fm.stringWidth(s)) + (double)(this.extraPadding * 2);
                    if (this.discreteCategory) {
                        String xv = ((StringVariable)this.catVar).value.getValue(i);
                        xpos = ((StringToNumericMap)xmap).getValue((Object)xv) - w / 2.0;
                    } else {
                        double xv = ((NumericVariable)this.catVar).value.getValue(i);
                        xpos = ((ContinuousRangeToNumericMap)xmap).getValue(xv) - w / 2.0;
                    }
                    double yv = this.respVar.value.getValue(i);
                    double ypos = ymap.getValue(yv);
                    ypos = yv >= 0.0 && !reverse || yv < 0.0 && reverse ? (ypos += (double)(this.extraPadding + fmHeight)) : (ypos -= (double)this.extraPadding);
                    ypos = (double)yOutputRange - ypos;
                    Rectangle textBBox = new Rectangle((int)xpos, (int)ypos, (int)w, fmHeight);
                    lp.addObstacle(textBBox);
                    continue;
                }
                catch (MissingValueException s) {
                    // empty catch block
                }
            }
        } else {
            ContinuousRangeToNumericMap xmap = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
            ValueMap ymap = this.yEncoder.getValueMap();
            boolean reverse = this.xEncoder.isReversed();
            for (int i = 0; i < this.labVar.getValueCount(); ++i) {
                try {
                    double ypos;
                    String s = this.numericLabel ? ((NumericVariable)this.labVar).formattedValue.getValue(i).trim() : ((StringVariable)this.labVar).formattedValue.getValue(i).trim();
                    double w = Math.ceil(fm.stringWidth(s)) + (double)(this.extraPadding * 2);
                    if (this.discreteCategory) {
                        String yv = ((StringVariable)this.catVar).value.getValue(i);
                        ypos = ((StringToNumericMap)ymap).getValue((Object)yv) + (double)(fmHeight / 2);
                    } else {
                        double yv = ((NumericVariable)this.catVar).value.getValue(i);
                        ypos = ((ContinuousRangeToNumericMap)ymap).getValue(yv) + (double)(fmHeight / 2);
                    }
                    ypos = (double)yOutputRange - ypos;
                    double xv = this.respVar.value.getValue(i);
                    double xpos = xmap.getValue(xv);
                    xpos = xv >= 0.0 && !reverse || xv < 0.0 && reverse ? (xpos += (double)this.extraPadding) : (xpos -= (double)this.extraPadding + w);
                    Rectangle textBBox = new Rectangle((int)xpos, (int)ypos, (int)w, fmHeight);
                    lp.addObstacle(textBBox);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
            case 4: {
                return this.colorEncoder;
            }
            case 17: {
                return this.lineColorEncoder;
            }
            case 15: {
                return this.lineEncoder;
            }
            case 21: {
                return this.fillPatternEncoder;
            }
            case 13: {
                return this.yUpperErrorEncoder;
            }
            case 14: {
                return this.yLowerErrorEncoder;
            }
        }
        return null;
    }

    public int getStatistic() {
        return this.statistic;
    }

    public void setStatistic(int stat) {
        this.statistic = stat;
    }

    public void setTargetColor(Color c) {
        this.targetColor = c;
    }

    public Color getTargetColor() {
        return this.targetColor;
    }

    public boolean isMultiResponse() {
        return this.responseCount > 0;
    }

    public void setResponseCount(int n) {
        this.responseCount = n;
    }

    private void loadSkinImage() {
        if (!this.isFillOn() || this.isExtrudedOverlay()) {
            this.skinType = 0;
        }
        if (!this.isFillOn() || this.isExtrudedOverlay() || this.dataTransparency == 1.0) {
            this.skinImage = null;
            return;
        }
        this.pixelBenderImages = this.loadPixelBenderImages(this.networkRoot, this.skinType, this.getOrientation() == 0 ? 1 : 2);
        this.skinImage = this.getRectangularSkinImage(this.networkRoot, this.skinType, this.orientation == 0);
    }

    public byte getOrientation() {
        return this.orientation;
    }

    public void setOrientation(byte aOrientation) {
        this.orientation = aOrientation;
    }

    public byte getGroupDisplay() {
        return this.groupDisplay;
    }

    public void setGroupDisplay(byte display) {
        this.groupDisplay = display;
    }

    public void setShowBarValue(boolean b) {
        this.showBarValue = b;
    }

    public boolean isShowBarValue() {
        return this.showBarValue;
    }

    public void setShowSegmentLabel(boolean b) {
        this.showSegmentLabel = b;
    }

    public boolean isShowSegmentLabel() {
        return this.showSegmentLabel;
    }

    public void setSegmentLabelFitPolicy(int fit) {
        this.segmentLabelFitPolicy = fit;
    }

    public int getSegmentLabelFitPolocy() {
        return this.segmentLabelFitPolicy;
    }

    public void setSegmentLabelStyle(TextStyle ts) {
        this.segmentLabelStyle = ts;
    }

    public TextStyle getSegmentLabelStyle() {
        return this.segmentLabelStyle;
    }

    public void setSegmentLabelFormat(SASFormat f) {
        this.segmentLabelFormat = f;
    }

    public SASFormat getSegmentLabelFormat() {
        return this.segmentLabelFormat;
    }

    public void setUseEdgeColor(boolean b) {
        this.useEdgeColor = b;
    }

    public void setUseEdgePattern(boolean b) {
        this.useEdgePattern = b;
    }

    public void setUseLabelColor(boolean b) {
        this.useLabelColor = b;
    }

    public boolean isUseLabelColor() {
        return this.useLabelColor;
    }

    public void setLabelFormat(SASFormat fmt) {
        this.labelFormat = fmt;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(TextStyle aLabelStyle) {
        this.labelStyle = aLabelStyle;
    }

    public byte getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(byte aLabelPosition) {
        this.labelPosition = aLabelPosition;
    }

    public boolean isAutoRotateLabel() {
        return this.autoRotateLabel;
    }

    public void setAutoRotateLabel(boolean rotate) {
        this.autoRotateLabel = rotate;
    }

    public boolean isRotateLabelAsNeeded() {
        return this.rotateLabelAsNeeded;
    }

    public void setRotateLabelAsNeeded(boolean rotate) {
        this.rotateLabelAsNeeded = rotate;
    }

    public boolean isLabelInsidePreferred() {
        return this.labelInsidePreferred;
    }

    public void setLabelInsidePreferred(boolean b) {
        this.labelInsidePreferred = b;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean b) {
        this.fillOn = b;
    }

    public void setFillStyle(FillAttrs fs) {
        this.fillStyle = fs;
    }

    public FillAttrs getFillStyle() {
        return this.fillStyle;
    }

    public boolean isEdgeOn() {
        return this.edgeOn;
    }

    public void setEdgeOn(boolean b) {
        this.edgeOn = b;
    }

    public LineAttrs getEdgeStyle() {
        return this.edgeStyle;
    }

    public void setEdgeStyle(LineAttrs s) {
        this.edgeStyle = s;
    }

    public void setFillPatternOn(boolean b) {
        this.fillPatternOn = b;
    }

    public boolean isFillPatternOn() {
        return this.fillPatternOn;
    }

    public void setFillPatternStyle(FillPatternAttrs s) {
        this.fillPatternStyle = s;
    }

    public FillPatternAttrs getFillPatternStyle() {
        return this.fillPatternStyle;
    }

    public LineAttrs getReferenceStyle() {
        return this.referenceStyle;
    }

    public void setReferenceStyle(LineAttrs s) {
        this.referenceStyle = s;
    }

    public LineAttrs getErrorStyle() {
        return this.errorStyle;
    }

    public void setErrorStyle(LineAttrs s) {
        this.errorStyle = s;
    }

    public boolean isConnectOn() {
        return this.connectOn;
    }

    public void setConnectOn(boolean b) {
        this.connectOn = b;
    }

    public LineAttrs getConnectStyle() {
        return this.connectStyle;
    }

    public void setConnectStyle(LineAttrs s) {
        this.connectStyle = s;
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(double width) {
        this.barWidth = width;
    }

    public void setClusterWidth(double width) {
        this.clusterWidth = width;
    }

    public double getClusterWidth() {
        return this.clusterWidth;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int o) {
        this.order = o;
        if (this.orientation == 0) {
            this.updateXRange();
        } else {
            this.updateYRange();
        }
    }

    public boolean isCategorySortVarDefined() {
        return this.categorySortVar != null;
    }

    public Color[] getGroupColors(String type) {
        Color[] colors = new Color[]{};
        if (type.equalsIgnoreCase("fill")) {
            if (!this.isGradientColor() && this.colorVar != null && this.colorEncoder != null) {
                if (this.indexVar != null) {
                    return this.getIndexedGroupColors((short)6);
                }
                HashMap ht = this.colorEncoder.colorList;
                String[] values = this.getUniqueValues((short)6);
                if (StatGraph.isOLAP()) {
                    colors = new Color[this.getGroupValues().length];
                    ArrayList<String> gValues = new ArrayList<String>();
                    int cnt = 0;
                    for (int i = 0; i < values.length; ++i) {
                        String str = Overlay.getTopLevelValue(values[i]);
                        if (gValues.contains(str)) continue;
                        colors[cnt++] = (Color)ht.get(values[i]);
                        gValues.add(str);
                    }
                } else {
                    colors = new Color[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        if (this.hasAttrVar("GROUP")) {
                            DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                            Color c = groupAttrMapper.getFillColor(values[i]);
                            if (c != null) {
                                if (this.useFillTransparency) {
                                    colors[i] = this.applyDataTransparency(c, this.fillStyle.getTransparency());
                                    continue;
                                }
                                colors[i] = BarOverlay.applyTransparency(c, groupAttrMapper.getFillTransparency(values[i]));
                                continue;
                            }
                            colors[i] = (Color)ht.get(values[i]);
                            continue;
                        }
                        colors[i] = (Color)ht.get(values[i]);
                    }
                }
            } else {
                colors = new Color[]{this.applyDataTransparency((ColorAttr)this.fillStyle)};
            }
        } else if (type.equalsIgnoreCase("line")) {
            if (!this.isGradientColor() && this.lineColorVar != null && this.lineColorEncoder != null && !this.useEdgeColor) {
                if (this.indexVar != null) {
                    return this.getIndexedGroupColors((short)46);
                }
                HashMap ht = this.lineColorEncoder.colorList;
                String[] values = this.getLineColorValues();
                colors = new Color[values.length];
                for (int i = 0; i < values.length; ++i) {
                    if (this.hasAttrVar("GROUP")) {
                        DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                        Color c = groupAttrMapper.getLineColor(values[i]);
                        if (c != null) {
                            colors[i] = this.applyDataTransparency(c);
                            continue;
                        }
                        colors[i] = (Color)ht.get(values[i]);
                        continue;
                    }
                    colors[i] = (Color)ht.get(values[i]);
                }
            } else {
                colors = new Color[]{this.applyDataTransparency(this.getEdgeStyle().getColor())};
            }
        } else if (type.equalsIgnoreCase("fillPattern")) {
            if (!this.isGradientColor() && this.fillPatternColorVar != null && this.fillPatternColorEncoder != null) {
                if (this.indexVar != null) {
                    return this.getIndexedGroupColors((short)112);
                }
                HashMap ht = this.fillPatternColorEncoder.colorList;
                String[] values = this.getLineColorValues();
                colors = new Color[values.length];
                for (int i = 0; i < values.length; ++i) {
                    if (this.hasAttrVar("GROUP")) {
                        DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                        Color c = groupAttrMapper.getLineColor(values[i]);
                        if (c != null) {
                            colors[i] = this.applyDataTransparency(c);
                            continue;
                        }
                        colors[i] = (Color)ht.get(values[i]);
                        continue;
                    }
                    colors[i] = (Color)ht.get(values[i]);
                }
            } else {
                colors = new Color[]{this.applyDataTransparency((ColorAttr)this.getFillPatternStyle())};
            }
        }
        return colors;
    }

    @Override
    public String[] getGroupValues() {
        String[] values = new String[]{};
        if (this.groupVar != null) {
            if (this.groupVar instanceof OLAPLevelVariable) {
                OLAPVariableFactory fac = this.model.getOLAPVarFactory();
                ArrayList<String> list = new ArrayList<String>();
                list.add(this.groupVar.getColumnName());
                DataTreeGroupNode n = fac.createSubTree(list);
                values = new String[n.getChildCount()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = n.getChildAt(i).toString();
                }
            } else {
                values = this.getUniqueValues((short)3);
            }
        }
        return values;
    }

    public String[] getOLAPGroupAllValues() {
        String[] values = new String[]{};
        if (this.groupVar == null) {
            return values;
        }
        if (this.groupVar instanceof StringVectorVariable) {
            return this.getUniqueValues((short)3);
        }
        StringVariable allGroupVar = StatGraph.getOLAPLevelVar(this.model, (short)3);
        values = new String[allGroupVar.getUniqueValueCount()];
        for (int i = 0; i < values.length; ++i) {
            try {
                values[i] = allGroupVar.uniqueValue.getValue(i);
                continue;
            }
            catch (MissingValueException mve) {
                values[i] = "";
            }
        }
        return values;
    }

    private Color[] getIndexedGroupColors(short role) {
        Color[] cl = role == 6 ? this.colorEncoder.colorArray : (role == 112 ? this.fillPatternColorEncoder.colorArray : this.lineColorEncoder.colorArray);
        boolean numericColor = this.model.getColumnClass(role) == Double.class;
        StringVectorVariable colors = (StringVectorVariable)this.connectCategory(role, this.missingGroupOn);
        NumericVectorVariable indices = (NumericVectorVariable)this.connectRaw((short)44);
        VariableProcessor vp = new VariableProcessor();
        vp.addVariable((Variable)colors);
        vp.addVariable((Variable)indices);
        if (this.groupVar != null) {
            vp.addVariable(this.rawGroupVar);
            if (this.getGroupOrder() == 1) {
                vp.setSort(this.rawGroupVar, 1);
            } else if (this.getGroupOrder() == 2) {
                vp.setSort(this.rawGroupVar, 2);
            }
            if (!this.missingGroupOn) {
                vp.setWhereExpression("^(" + this.rawGroupVar.getName() + " IS MISSING)");
            }
        }
        Color[] lc = new Color[colors.getUniqueValueCount()];
        for (int i = 0; i < colors.getUniqueValueCount(); ++i) {
            try {
                if (this.hasAttrVar("GROUP")) {
                    Color c;
                    DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                    String g = colors.uniqueValue.getValue(i);
                    if (role == 6) {
                        c = groupAttrMapper.getFillColor(g);
                        if (c != null) {
                            lc[i] = this.applyDataTransparency(c);
                            continue;
                        }
                    } else if (role == 46 && (c = groupAttrMapper.getLineColor(g)) != null) {
                        lc[i] = this.applyDataTransparency(c);
                        continue;
                    }
                }
                int obs = this.groupOrder == 3 ? colors.getFirstOccurringValueIndex(lc.length - 1 - i) : colors.getFirstOccurringValueIndex(i);
                int idx = (int)indices.value.getValue(obs) - 1;
                if (role == 6) {
                    lc[i] = this.applyDataTransparency(cl[idx % cl.length], this.fillStyle.getTransparency());
                    continue;
                }
                if (role == 112) {
                    lc[i] = this.applyDataTransparency(cl[idx % cl.length], this.fillPatternStyle.getTransparency());
                    continue;
                }
                lc[i] = this.applyDataTransparency(cl[idx % cl.length]);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return lc;
    }

    @Override
    public String[] getRawUniqueValues(short role) {
        if (this.isMultiResponse()) {
            return this.multiResponseLabels;
        }
        return super.getRawUniqueValues(role);
    }

    @Override
    public String[] getUniqueValues(short role) {
        if (this.isMultiResponse()) {
            return this.multiResponseLabels;
        }
        StringVariable group = (StringVariable)this.connectCategory(role, this.missingGroupOn);
        VariableProcessor vp = new VariableProcessor();
        vp.addVariable((Variable)group);
        if (this.groupVar != null) {
            vp.addVariable(this.rawGroupVar);
            if (this.getGroupOrder() == 1) {
                vp.setSort(this.rawGroupVar, 1);
            } else if (this.getGroupOrder() == 2) {
                vp.setSort(this.rawGroupVar, 2);
            }
            if (!this.missingGroupOn) {
                vp.setWhereExpression("^(" + this.rawGroupVar.getName() + " IS MISSING)");
            }
        }
        String[] gv = new String[group.getUniqueValueCount()];
        for (int i = 0; i < gv.length; ++i) {
            try {
                if (this.groupOrder == 3) {
                    gv[i] = group.uniqueValue.getValue(gv.length - 1 - i);
                    continue;
                }
                gv[i] = group.uniqueValue.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return gv;
    }

    protected void updateXRange() {
        DataRange newRange = null;
        DataRange oldRange = this.xRange;
        if (this.orientation == 0) {
            newRange = this.getIndRange();
            this.setFormat(newRange, 1);
        } else {
            newRange = this.getDepRange();
            if (this.group100) {
                newRange.setFormat(this.group100Format);
            } else if (this.isMultiResponse()) {
                this.setFormat(newRange, 610);
            } else {
                this.setFormat(newRange, 2);
            }
        }
        this.xRange = newRange;
        byte dim = 1;
        RangeChangedEvent rce = null;
        if (oldRange == null && newRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, newRange, dim);
        } else if (oldRange != null && newRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != newRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, newRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    protected void updateYRange() {
        DataRange newRange = null;
        DataRange oldRange = this.yRange;
        if (this.orientation == 0) {
            newRange = this.getDepRange();
            if (this.group100) {
                newRange.setFormat(this.group100Format);
            } else if (this.isMultiResponse()) {
                this.setFormat(newRange, 610);
            } else {
                this.setFormat(newRange, 2);
            }
        } else {
            newRange = this.getIndRange();
            this.setFormat(newRange, 1);
        }
        this.yRange = newRange;
        byte dim = 2;
        RangeChangedEvent rce = null;
        if (oldRange == null && newRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, newRange, dim);
        } else if (oldRange != null && newRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != newRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, newRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    protected void updateYUpperErrorRange() {
        DataRange newRange = null;
        DataRange oldRange = this.yUpperErrorRange;
        if (this.yUpperErrorVar != null) {
            int num = this.yUpperErrorVar.getValueCount();
            if (num == 1 && this.yUpperErrorVar.isMissing(0)) {
                num = 0;
            }
            if (num > 0) {
                boolean subset = this.orientation == 0 ? !this.yUnionAllPages : !this.xUnionAllPages;
                newRange = this.makeContinuousRange((NumericVariable)this.yUpperErrorVar, (short)28, subset);
                newRange.setLabel(this.yUpperErrorVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat(newRange, 2);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.yUpperErrorRange = newRange;
        this.fireRangeEvent((byte)9, oldRange, newRange);
    }

    protected void updateYLowerErrorRange() {
        DataRange newRange = null;
        DataRange oldRange = this.yLowerErrorRange;
        if (this.yLowerErrorVar != null) {
            int num = this.yLowerErrorVar.getValueCount();
            if (num == 1 && this.yLowerErrorVar.isMissing(0)) {
                num = 0;
            }
            if (num > 0) {
                boolean subset = this.orientation == 0 ? !this.yUnionAllPages : !this.xUnionAllPages;
                newRange = this.makeContinuousRange((NumericVariable)this.yLowerErrorVar, (short)29, subset);
                newRange.setLabel(this.yLowerErrorVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat(newRange, 2);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.yLowerErrorRange = newRange;
        this.fireRangeEvent((byte)10, oldRange, newRange);
    }

    protected void updateNumberOfGroupPerCategory() {
        int numCats;
        if (this.groupVar == null) {
            return;
        }
        VariableProcessor vp = new VariableProcessor();
        if (this.subset && !this.isMultiResponse()) {
            vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
        }
        if (this.statistic != -1) {
            vp.addGroupVariable(this.categoryVar);
            vp.addVariable(this.groupVar, 0);
            vp.addGroupVariable(this.rawGroupVar);
        } else {
            vp.addVariable(this.categoryVar);
            vp.addVariable(this.groupVar, 0);
            vp.addGroupVariable(this.categoryVar);
            vp.addGroupVariable(this.rawGroupVar);
        }
        if (!this.isMultiResponse()) {
            this.addCRDWhereClause(vp);
        }
        if (this.model.getSrcModel().maxGroupsPerCategory == null) {
            this.model.getSrcModel().maxGroupsPerCategory = new HashMap();
        }
        this.overlayID = this.model.getColumnName((short)1) + "." + this.model.getColumnName((short)3);
        if (this.isMissingGroupOn()) {
            this.overlayID = this.overlayID + ".MissingGroup";
        }
        int maxGroups = -1;
        if (this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID) != null) {
            maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
        }
        if ((numCats = this.categoryVar.getUniqueValueCount()) == 0) {
            return;
        }
        this.groupsPerCategory = new int[numCats];
        int gCount = 1;
        int gIdx = 0;
        String catV = null;
        for (int i = 0; i < this.categoryVar.getValueCount(); ++i) {
            try {
                String xv;
                String string = xv = this.discreteCategory ? ((StringVariable)this.categoryVar).value.getValue(i) : ((NumericVariable)this.categoryVar).formattedValue.getValue(i);
                if (catV == null) {
                    catV = xv;
                    continue;
                }
                if (xv.equals(catV)) {
                    ++gCount;
                    continue;
                }
                this.groupsPerCategory[gIdx] = gCount;
                if (gCount > maxGroups) {
                    maxGroups = gCount;
                }
                ++gIdx;
                gCount = 1;
                catV = xv;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.groupsPerCategory[gIdx] = gCount;
        if (gCount > maxGroups) {
            maxGroups = gCount;
        }
        this.model.getSrcModel().maxGroupsPerCategory.put(this.overlayID, new Integer(maxGroups));
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        ContinuousRange cr = null;
        switch (dimension) {
            case 1: {
                if (this.orientation == 1 && this.xRange instanceof ContinuousRange) {
                    if (this.yUpperErrorRange == null && this.yLowerErrorRange == null) {
                        return this.xRange;
                    }
                    double min = ((ContinuousRange)this.xRange).getMin();
                    double max = ((ContinuousRange)this.xRange).getMax();
                    cr = new ContinuousRange(min, max);
                    cr.setLabel(this.xRange.getLabel());
                    cr.setFormat(this.xRange.getFormat());
                    if (this.yUpperErrorRange != null) {
                        cr.union(this.yUpperErrorRange);
                    }
                    if (this.yLowerErrorRange != null) {
                        cr.union(this.yLowerErrorRange);
                    }
                    return cr;
                }
                return this.xRange;
            }
            case 2: {
                if (this.orientation == 0 && this.yRange instanceof ContinuousRange) {
                    if (this.yUpperErrorRange == null && this.yLowerErrorRange == null) {
                        return this.yRange;
                    }
                    double min = ((ContinuousRange)this.yRange).getMin();
                    double max = ((ContinuousRange)this.yRange).getMax();
                    cr = new ContinuousRange(min, max);
                    cr.setLabel(this.yRange.getLabel());
                    cr.setFormat(this.yRange.getFormat());
                    if (this.yUpperErrorRange != null) {
                        cr.union(this.yUpperErrorRange);
                    }
                    if (this.yLowerErrorRange != null) {
                        cr.union(this.yLowerErrorRange);
                    }
                    return cr;
                }
                return this.yRange;
            }
            case 4: {
                return this.colorRange;
            }
            case 17: {
                return this.lineColorRange;
            }
            case 21: {
                return this.fillPatternRange;
            }
            case 9: {
                return this.yUpperErrorRange;
            }
            case 10: {
                return this.yLowerErrorRange;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void drawNoneClipped(Graphics g) {
        if (this.networkRoot2 == null) {
            return;
        }
        Channel channel = this.networkRoot2.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot2.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.colorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 15) {
            if (!(encoder instanceof LineEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.lineEncoder)) {
                return;
            }
            this.lineEncoder = (LineEncoder)encoder;
        } else if (dimension == 17) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.lineColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 21) {
            if (!(encoder instanceof FillPatternEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.fillPatternEncoder)) {
                return;
            }
            this.fillPatternEncoder = (FillPatternEncoder)encoder;
        } else if (dimension == 22) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.fillPatternColorEncoder)) {
                return;
            }
            this.fillPatternColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 9) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yUpperErrorEncoder)) {
                return;
            }
            this.yUpperErrorEncoder = (PositionEncoder)encoder;
        } else if (dimension == 10) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yLowerErrorEncoder)) {
                return;
            }
            this.yLowerErrorEncoder = (PositionEncoder)encoder;
        }
        this.needConnect = true;
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.updateNumberOfGroupPerCategory();
        this.updateXRange();
        this.updateYRange();
        this.updateColorRange();
        this.updateLineColorRange();
        this.updateFillPatternRange();
        this.updateYUpperErrorRange();
        this.updateYLowerErrorRange();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean connectNetwork() {
        DiscreteAttrMapper groupAttrMapper;
        SASFormat format;
        String gval;
        int i;
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.categoryVar == null || this.xRange == null) {
            return false;
        }
        if (this.responseVar == null || this.yRange == null) {
            return false;
        }
        if (this.xEncoder == null) {
            return false;
        }
        if (this.yEncoder == null) {
            return false;
        }
        PositionEncoder ve = this.orientation == 0 ? this.xEncoder : this.yEncoder;
        ValueMap map = ve.getValueMap();
        if (this.discreteCategory && !(map instanceof StringToNumericMap)) {
            return false;
        }
        StringToNumericMapper catMapper = null;
        if (this.discreteCategory) {
            catMapper = new StringToNumericMapper();
            catMapper.setMap((StringToNumericMap)map);
            catMapper.input.connectFrom(((StringVariable)this.categoryVar).value);
        } else {
            catMapper = new ContinuousRangeToNumericMapper();
            ((ContinuousRangeToNumericMapper)catMapper).setMap((ContinuousRangeToNumericMap)map);
            ((ContinuousRangeToNumericMapper)catMapper).input.connectFrom(((NumericVariable)this.categoryVar).value);
        }
        double stride = this.getStride();
        double barSize = this.clusterWidth * stride;
        double discreteOffsetValue = this.discreteOffset * stride;
        if (ve.isReversed()) {
            discreteOffsetValue = -discreteOffsetValue;
        }
        if (!((map = (ve = this.orientation == 0 ? this.yEncoder : this.xEncoder).getValueMap()) instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        ContinuousRangeToNumericMapper responseMapper = new ContinuousRangeToNumericMapper();
        responseMapper.setMap((ContinuousRangeToNumericMap)map);
        responseMapper.input.connectFrom(this.responseVar.value);
        ContinuousRangeToNumericMapper baseMapper = new ContinuousRangeToNumericMapper();
        baseMapper.setMap((ContinuousRangeToNumericMap)map);
        baseMapper.input.setValue(this.baseline);
        StringProperty groupPipe = new StringProperty();
        Probe probe = this.probe;
        StringToColorMapper colorMapper = null;
        if (this.colorVar != null && this.colorEncoder != null) {
            map = this.colorEncoder.getValueMap();
            if (this.numericColor) {
                if (map instanceof ContinuousRangeToColorMap) {
                    ContinuousRangeToColorMapper crtcm = new ContinuousRangeToColorMapper();
                    crtcm.setMap((ContinuousRangeToColorMap)map);
                    crtcm.input.connectFrom(((NumericVectorVariable)this.colorVar).value);
                    colorMapper = crtcm;
                    colorMapper.setReplaceMissingValues(true);
                    colorMapper.setMissingReplacement(this.missingColorResponseColor);
                } else if (map instanceof NumericToColorMap) {
                    NumericToColorMapper ntcm = new NumericToColorMapper();
                    ntcm.setMap((NumericToColorMap)map);
                    ntcm.input.connectFrom(((NumericVectorVariable)this.colorVar).value);
                    colorMapper = ntcm;
                } else {
                    if (!(map instanceof DiscreteRangeToColorMap)) return false;
                    DiscreteRangeToColorMapper drtcm = new DiscreteRangeToColorMapper();
                    drtcm.setMap((DiscreteRangeToColorMap)map);
                    drtcm.input.connectFrom(((NumericVectorVariable)this.colorVar).value);
                    colorMapper = drtcm;
                }
            } else {
                if (!(map instanceof StringToColorMap)) return false;
                StringToColorMapper stcm = new StringToColorMapper();
                if (this.indexVar == null) {
                    stcm.setMap((StringToColorMap)map);
                } else {
                    Color[] cl = this.colorEncoder.colorArray;
                    for (int i2 = 0; i2 < this.colorVar.getUniqueValueCount(); ++i2) {
                        Color c;
                        int obs = ((StringVariable)this.colorVar).getFirstOccurringValueIndex(i2);
                        try {
                            int idx = (int)((NumericVariable)this.indexVar).value.getValue(obs) - 1;
                            c = this.fillStyle.getTransparency() < 0.0 ? this.applyDataTransparency(cl[idx % cl.length]) : Overlay.applyTransparency(cl[idx % cl.length], this.fillStyle.getTransparency());
                        }
                        catch (MissingValueException e) {
                            c = this.applyDataTransparency((ColorAttr)this.fillStyle);
                        }
                        try {
                            String gval2 = ((StringVariable)this.colorVar).uniqueValue.getValue(i2);
                            stcm.add(gval2, c);
                            continue;
                        }
                        catch (MissingValueException e) {
                            stcm.setMissingReplacement(c, e.getMissingValue());
                        }
                    }
                }
                colorMapper = stcm;
                stcm.input.connectFrom((StringPipe)groupPipe);
            }
        }
        StringToColorMapper lineColorMapper = null;
        if (this.lineColorVar != null && this.lineColorEncoder != null) {
            map = this.lineColorEncoder.getValueMap();
            if (this.numericLineColor) {
                if (map instanceof ContinuousRangeToColorMap) {
                    ContinuousRangeToColorMapper crtcm = new ContinuousRangeToColorMapper();
                    crtcm.setMap((ContinuousRangeToColorMap)map);
                    crtcm.input.connectFrom(((NumericVectorVariable)this.lineColorVar).value);
                    lineColorMapper = crtcm;
                    lineColorMapper.setReplaceMissingValues(true);
                    lineColorMapper.setMissingReplacement(this.missingColorResponseColor);
                } else if (map instanceof NumericToColorMap) {
                    NumericToColorMapper ntcm = new NumericToColorMapper();
                    ntcm.setMap((NumericToColorMap)map);
                    ntcm.input.connectFrom(((NumericVectorVariable)this.lineColorVar).value);
                    lineColorMapper = ntcm;
                } else {
                    if (!(map instanceof DiscreteRangeToColorMap)) return false;
                    DiscreteRangeToColorMapper drtcm = new DiscreteRangeToColorMapper();
                    drtcm.setMap((DiscreteRangeToColorMap)map);
                    drtcm.input.connectFrom(((NumericVectorVariable)this.lineColorVar).value);
                    lineColorMapper = drtcm;
                }
            } else {
                if (!(map instanceof StringToColorMap)) return false;
                StringToColorMapper stcm = new StringToColorMapper();
                if (this.indexVar == null) {
                    stcm.setMap((StringToColorMap)map);
                } else {
                    Color[] lcl = this.lineColorEncoder.colorArray;
                    for (i = 0; i < this.lineColorVar.getUniqueValueCount(); ++i) {
                        Color c;
                        int obs = ((StringVariable)this.lineColorVar).getFirstOccurringValueIndex(i);
                        try {
                            int idx = (int)((NumericVariable)this.indexVar).value.getValue(obs) - 1;
                            c = this.applyDataTransparency(lcl[idx % lcl.length]);
                        }
                        catch (MissingValueException e) {
                            c = this.applyDataTransparency(this.getEdgeStyle().getColor());
                        }
                        try {
                            gval = ((StringVariable)this.lineColorVar).uniqueValue.getValue(i);
                            stcm.add(gval, c);
                            continue;
                        }
                        catch (MissingValueException e) {
                            stcm.setMissingReplacement(c, e.getMissingValue());
                        }
                    }
                }
                lineColorMapper = stcm;
                stcm.input.connectFrom((StringPipe)groupPipe);
            }
        }
        StringToNumberMapper linePatternMapper = null;
        if (this.lineVar != null && this.lineEncoder != null) {
            linePatternMapper = new StringToNumberMapper();
            LineAttrs[] ll = this.lineEncoder.styleArray;
            HashMap ht = this.lineEncoder.styleList;
            linePatternMapper.setReplaceMissingValues(true);
            linePatternMapper.setLabelMissingValues(true);
            linePatternMapper.input.connectFrom((StringPipe)groupPipe);
            for (i = 0; i < this.lineVar.getUniqueValueCount(); ++i) {
                LineAttrs ls;
                block367: {
                    if (this.indexVar == null) {
                        try {
                            String lval = ((StringVariable)this.lineVar).uniqueValue.getValue(i);
                            if (ht.get(lval) == null) {
                                ls = this.edgeStyle;
                                break block367;
                            }
                            ls = (LineAttrs)ht.get(lval);
                        }
                        catch (MissingValueException e) {
                            ls = this.edgeStyle;
                        }
                    } else {
                        int obs = ((StringVariable)this.lineVar).getFirstOccurringValueIndex(i);
                        try {
                            int idx = (int)((NumericVariable)this.indexVar).value.getValue(obs) - 1;
                            ls = ll[idx % ll.length];
                        }
                        catch (MissingValueException e) {
                            ls = this.edgeStyle;
                        }
                    }
                }
                try {
                    gval = ((StringVariable)this.lineVar).uniqueValue.getValue(i);
                    linePatternMapper.add(gval, (Number)new Double(ls.getLinePattern()));
                    continue;
                }
                catch (MissingValueException e) {
                    linePatternMapper.setMissingReplacement((double)ls.getLinePattern(), e.getMissingValue());
                }
            }
        }
        StringToColorMapper fillPatternColorMapper = null;
        if (this.fillPatternColorVar != null && this.fillPatternColorEncoder != null) {
            map = this.fillPatternColorEncoder.getValueMap();
            StringToColorMapper stcm = new StringToColorMapper();
            if (this.indexVar == null) {
                stcm.setMap((StringToColorMap)map);
            } else {
                Color[] fpcl = this.fillPatternColorEncoder.colorArray;
                for (int i3 = 0; i3 < this.fillPatternColorVar.getUniqueValueCount(); ++i3) {
                    Color c;
                    int obs = ((StringVariable)this.fillPatternColorVar).getFirstOccurringValueIndex(i3);
                    try {
                        int idx = (int)((NumericVariable)this.indexVar).value.getValue(obs) - 1;
                        c = this.fillPatternStyle.getTransparency() < 0.0 ? this.applyDataTransparency(fpcl[idx % fpcl.length]) : Overlay.applyTransparency(fpcl[idx % fpcl.length], this.fillPatternStyle.getTransparency());
                    }
                    catch (MissingValueException e) {
                        c = this.applyDataTransparency((ColorAttr)this.fillPatternStyle);
                    }
                    try {
                        String gval3 = ((StringVariable)this.fillPatternColorVar).uniqueValue.getValue(i3);
                        stcm.add(gval3, c);
                        continue;
                    }
                    catch (MissingValueException e) {
                        stcm.setMissingReplacement(c, e.getMissingValue());
                    }
                }
            }
            fillPatternColorMapper = stcm;
            stcm.input.connectFrom((StringPipe)groupPipe);
        }
        NumericProperty fillPatternWidth = new NumericProperty();
        IntegerProperty fillPatternType = new IntegerProperty();
        if (this.fillPatternVar != null && this.fillPatternEncoder != null) {
            int[] pat = this.fillPatternEncoder.patternArray;
            HashMap ht = this.fillPatternEncoder.patternList;
            StringToNumberMapper fillPatternTypeMapper = new StringToNumberMapper();
            StringToNumberMapper fillPatternWidthMapper = new StringToNumberMapper();
            fillPatternWidthMapper.setReplaceMissingValues(true);
            fillPatternWidthMapper.setLabelMissingValues(true);
            fillPatternTypeMapper.setReplaceMissingValues(true);
            fillPatternTypeMapper.setLabelMissingValues(true);
            fillPatternWidthMapper.input.connectFrom((StringPipe)groupPipe);
            fillPatternTypeMapper.input.connectFrom((StringPipe)groupPipe);
            for (int i4 = 0; i4 < this.fillPatternVar.getUniqueValueCount(); ++i4) {
                int p;
                block368: {
                    if (this.indexVar == null) {
                        try {
                            String fpval = ((StringVariable)this.fillPatternVar).uniqueValue.getValue(i4);
                            if (ht.get(fpval) == null) {
                                p = -1;
                                break block368;
                            }
                            p = (Integer)ht.get(fpval);
                        }
                        catch (MissingValueException e) {
                            p = -1;
                        }
                    } else {
                        int obs = ((StringVariable)this.fillPatternVar).getFirstOccurringValueIndex(i4);
                        try {
                            int idx = (int)((NumericVariable)this.indexVar).value.getValue(obs) - 1;
                            p = pat[idx % pat.length];
                        }
                        catch (MissingValueException e) {
                            p = -1;
                        }
                    }
                }
                try {
                    String gval4 = ((StringVariable)this.fillPatternVar).uniqueValue.getValue(i4);
                    fillPatternWidthMapper.add(gval4, (Number)new Double(FillPatternAttrs.getPatternWidth((int)p)));
                    fillPatternTypeMapper.add(gval4, (Number)new Double(BarOverlay.getGLFillPattern(p)));
                    continue;
                }
                catch (MissingValueException e) {
                    fillPatternWidthMapper.setMissingReplacement((double)FillPatternAttrs.getPatternWidth((int)p), e.getMissingValue());
                    fillPatternTypeMapper.setMissingReplacement((double)BarOverlay.getGLFillPattern(p), e.getMissingValue());
                }
            }
            fillPatternWidth.connectFrom((NumericPipe)fillPatternWidthMapper);
            fillPatternType.connectFrom((NumericPipe)fillPatternTypeMapper);
        } else {
            int p = this.fillPatternStyle.getPattern();
            fillPatternWidth.setValue((double)FillPatternAttrs.getPatternWidth((int)p));
            fillPatternType.setValue(BarOverlay.getGLFillPattern(p));
        }
        ContinuousRangeToNumericMapper yUpperErrorMapper = null;
        if (this.yUpperErrorVar != null && ve != null) {
            map = ve.getValueMap();
            if (!(map instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            yUpperErrorMapper = new ContinuousRangeToNumericMapper();
            yUpperErrorMapper.setMap((ContinuousRangeToNumericMap)map);
        }
        ContinuousRangeToNumericMapper yLowerErrorMapper = null;
        if (this.yLowerErrorVar != null && ve != null) {
            map = ve.getValueMap();
            if (!(map instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            yLowerErrorMapper = new ContinuousRangeToNumericMapper();
            yLowerErrorMapper.setMap((ContinuousRangeToNumericMap)map);
        }
        ContinuousRangeToNumericMapper targetMapper = null;
        if (this.targetVar != null && ve != null) {
            map = ve.getValueMap();
            if (!(map instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            targetMapper = new ContinuousRangeToNumericMapper();
            targetMapper.setMap((ContinuousRangeToNumericMap)map);
        }
        SASFormat sASFormat = format = this.orientation == 0 ? this.xEncoder.getInput().getFormat() : this.yEncoder.getInput().getFormat();
        if (format != null && this.discreteCategory) {
            this.categoryVar.setFormat(new GTKFormat((Format)format));
        }
        SASFormat sASFormat2 = format = this.orientation == 0 ? this.yEncoder.getInput().getFormat() : this.xEncoder.getInput().getFormat();
        if (format != null && !this.group100) {
            this.responseVar.setFormat(new GTKFormat((Format)format));
        }
        VariableProcessor vp = new VariableProcessor();
        if (this.subset && !this.isMultiResponse()) {
            vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
        }
        this.categoryVar.setUniqueValueSort(0);
        if (this.statistic != -1) {
            vp.addGroupVariable(this.categoryVar);
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar, 0);
                vp.addGroupVariable(this.rawGroupVar);
                if (this.getGroupOrder() == 1) {
                    this.rawGroupVar.setUniqueValueSort(1);
                } else if (this.getGroupOrder() == 2) {
                    this.rawGroupVar.setUniqueValueSort(2);
                }
            }
            vp.addVariable((Variable)this.responseVar, this.statistic);
            if (this.categorySortVar != null) {
                vp.addVariable(this.categorySortVar, this.statistic);
            }
            if (this.yLowerErrorVar != null) {
                vp.addVariable((Variable)this.yLowerErrorVar, this.statistic);
            }
            if (this.yUpperErrorVar != null) {
                vp.addVariable((Variable)this.yUpperErrorVar, this.statistic);
            }
            if (this.targetVar != null) {
                vp.addVariable((Variable)this.targetVar, this.statistic);
            }
        } else {
            vp.addVariable(this.categoryVar);
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar, 0);
                vp.addGroupVariable(this.categoryVar);
                vp.addGroupVariable(this.rawGroupVar);
                if (this.getGroupOrder() == 1) {
                    this.rawGroupVar.setUniqueValueSort(1);
                } else if (this.getGroupOrder() == 2) {
                    this.rawGroupVar.setUniqueValueSort(2);
                }
            }
            vp.addVariable((Variable)this.responseVar);
            if (this.categorySortVar != null) {
                vp.addVariable(this.categorySortVar);
            }
            if (this.yLowerErrorVar != null) {
                vp.addVariable((Variable)this.yLowerErrorVar);
            }
            if (this.yUpperErrorVar != null) {
                vp.addVariable((Variable)this.yUpperErrorVar);
            }
            if (this.targetVar != null) {
                vp.addVariable((Variable)this.targetVar);
            }
        }
        if (this.gradientColor) {
            if (this.colorVar != null) {
                vp.addVariable(this.colorVar, this.colorStatistic);
            }
            if (this.lineColorVar != null) {
                vp.addVariable(this.lineColorVar, this.colorStatistic);
            }
        }
        if (!this.isMultiResponse()) {
            this.addCRDWhereClause(vp);
        }
        BidirectionalAccumulatorByCategory accumStart = null;
        BidirectionalAccumulatorByCategory accumEnd = null;
        ContinuousRangeToNumericMapper accumStartMapper = null;
        ContinuousRangeToNumericMapper accumEndMapper = null;
        BidirectionalAccumulatorByCategory lineAccumulator = null;
        this.offsetCalculator = null;
        StringToNumericMapper categoryMapper = catMapper;
        if (this.groupVar != null) {
            String[] gvalues = StatGraph.isOLAP() ? this.getOLAPGroupAllValues() : this.getGroupValues();
            HashMap<String, Integer> value2ColumnCategory = new HashMap<String, Integer>();
            for (int i5 = 0; i5 < this.groupVar.getUniqueValueCount(); ++i5) {
                try {
                    String v = ((StringVariable)this.groupVar).uniqueValue.getValue(i5);
                    int groupCategory_column = this.getGroupCategoryInDataColumn(v, gvalues);
                    value2ColumnCategory.put(v, new Integer(groupCategory_column));
                    continue;
                }
                catch (MissingValueException v) {
                    // empty catch block
                }
            }
            if (this.groupDisplay == 0) {
                NumericVector barPosition = new NumericVector();
                int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                barSize = Math.round(barSize / (double)maxGroups);
                this.groupVar.getUniqueValueCount();
                int offset = 0;
                for (int i6 = 0; i6 < this.categoryVar.getUniqueValueCount(); ++i6) {
                    ArrayList groupCategory = this.getSortedGroupCategory(offset, this.groupsPerCategory[i6]);
                    for (int j = 0; j < this.groupsPerCategory[i6]; ++j) {
                        try {
                            int pos;
                            if (this.groupOrder == 1 || this.groupOrder == 2) {
                                pos = j;
                            } else {
                                int currGroup = ((StringVariable)this.groupVar).category.getValue(offset + j);
                                pos = groupCategory.indexOf(new Integer(currGroup));
                            }
                            double x = this.discreteCategory ? catMapper.getValue((Object)((StringVariable)this.categoryVar).uniqueValue.getValue(i6)) : ((ContinuousRangeToNumericMapper)catMapper).getValue(((NumericVariable)this.categoryVar).uniqueValue.getValue(i6));
                            x -= (double)((int)(((double)this.groupsPerCategory[i6] / 2.0 - 0.5) * barSize));
                            barPosition.addValue(x += barSize * (double)pos);
                            continue;
                        }
                        catch (MissingValueException e) {
                            barPosition.addValue(Double.NaN);
                        }
                    }
                    offset += this.groupsPerCategory[i6];
                }
                categoryMapper = barPosition;
                groupPipe.connectFrom(((StringVariable)this.groupVar).value);
                if (this.group100) {
                    Calculator percent = new Calculator("inA*inB");
                    percent.inA.connectFrom(this.responseVar.value);
                    percent.inB.connectFrom((NumericPipe)this.percentWeight);
                    responseMapper.input.connectFrom((NumericPipe)percent);
                }
            } else {
                NumericProperty catNoPipe = new NumericProperty();
                NumericProperty respPipe = new NumericProperty();
                double[] pctWeight = null;
                if (this.isMultiResponse() || this.groupOrder != 3) {
                    if (this.discreteCategory) {
                        catNoPipe.connectFrom(((StringVariable)this.categoryVar).category);
                    } else {
                        catNoPipe.connectFrom(((NumericVariable)this.categoryVar).category);
                    }
                    respPipe.connectFrom(this.responseVar.value);
                    groupPipe.connectFrom(((StringVariable)this.groupVar).value);
                } else {
                    int n = this.categoryVar.getValueCount();
                    int[] catNo = new int[n];
                    double[] resp = new double[n];
                    String[] grp = new String[n];
                    pctWeight = new double[n];
                    int[] indexLookup = new int[n];
                    this.groupVar.getUniqueValueCount();
                    this.responseVar.getValueCount();
                    int offset = 0;
                    for (int i7 = 0; i7 < this.categoryVar.getUniqueValueCount(); ++i7) {
                        ArrayList groupCategory = this.getSortedGroupCategory(offset, this.groupsPerCategory[i7]);
                        for (int j = 0; j < this.groupsPerCategory[i7]; ++j) {
                            int old_obs = 0;
                            int new_obs = 0;
                            try {
                                int pos;
                                if (this.groupOrder == 1 || this.groupOrder == 2) {
                                    pos = j;
                                } else {
                                    int currGroup = ((StringVariable)this.groupVar).category.getValue(offset + j);
                                    pos = groupCategory.indexOf(new Integer(currGroup));
                                }
                                old_obs = offset + j;
                                new_obs = offset + pos;
                                indexLookup[new_obs] = old_obs;
                                grp[new_obs] = ((StringVariable)this.groupVar).value.getValue(old_obs);
                                catNo[new_obs] = this.discreteCategory ? ((StringVariable)this.categoryVar).category.getValue(old_obs) : ((NumericVariable)this.categoryVar).category.getValue(old_obs);
                                resp[new_obs] = this.responseVar.value.getValue(old_obs);
                                if (!this.group100) continue;
                                if (!this.percentWeight.isMissing(old_obs)) {
                                    pctWeight[new_obs] = this.percentWeight.getValue(old_obs);
                                    continue;
                                }
                                pctWeight[new_obs] = Double.NaN;
                                continue;
                            }
                            catch (MissingValueException e) {
                                resp[new_obs] = Double.NaN;
                            }
                        }
                        offset += this.groupsPerCategory[i7];
                    }
                    NumericVector catNoVector = new NumericVector();
                    NumericVector respVector = new NumericVector();
                    for (int i8 = 0; i8 < n; ++i8) {
                        catNoVector.addValue((double)catNo[i8]);
                        respVector.addValue(resp[i8]);
                    }
                    catNoPipe.connectFrom((NumericPipe)catNoVector);
                    respPipe.connectFrom((NumericPipe)respVector);
                    StringVectorVariable svv = new StringVectorVariable();
                    svv.setBlankMissing(false);
                    svv.connectFrom(grp);
                    groupPipe.connectFrom(svv.value);
                    probe = this.rearrangeProbePipes(indexLookup);
                }
                Calculator percent = null;
                if (this.group100) {
                    percent = new Calculator("inA*inB");
                    percent.inA.connectFrom((NumericPipe)respPipe);
                    if (this.groupOrder == 3 && pctWeight != null) {
                        NumericVector percentWeight2 = new NumericVector();
                        for (int i9 = 0; i9 < pctWeight.length; ++i9) {
                            percentWeight2.addValue(pctWeight[i9]);
                        }
                        percent.inB.connectFrom((NumericPipe)percentWeight2);
                    } else {
                        percent.inB.connectFrom((NumericPipe)this.percentWeight);
                    }
                }
                accumStart = new BidirectionalAccumulatorByCategory();
                accumStart.category.connectFrom((NumericPipe)catNoPipe);
                if (this.group100) {
                    accumStart.input.connectFrom((NumericPipe)percent);
                } else {
                    accumStart.input.connectFrom((NumericPipe)respPipe);
                }
                accumStart.setPostAccumulate(true);
                accumEnd = new BidirectionalAccumulatorByCategory();
                accumEnd.category.connectFrom((NumericPipe)catNoPipe);
                if (this.group100) {
                    accumEnd.input.connectFrom((NumericPipe)percent);
                } else {
                    accumEnd.input.connectFrom((NumericPipe)respPipe);
                }
                accumEnd.setPostAccumulate(false);
                ve = this.orientation == 0 ? this.yEncoder : this.xEncoder;
                map = ve.getValueMap();
                accumStartMapper = new ContinuousRangeToNumericMapper();
                accumStartMapper.setMap((ContinuousRangeToNumericMap)map);
                accumStartMapper.input.connectFrom(accumStart.value);
                accumEndMapper = new ContinuousRangeToNumericMapper();
                accumEndMapper.setMap((ContinuousRangeToNumericMap)map);
                accumEndMapper.input.connectFrom(accumEnd.value);
            }
            if (this.isConnectOn()) {
                lineAccumulator = new BidirectionalAccumulatorByCategory();
                lineAccumulator.setStartValue(this.baseline);
                if (this.discreteCategory) {
                    lineAccumulator.category.connectFrom(((StringVariable)this.categoryVar).category);
                } else {
                    lineAccumulator.category.connectFrom(((NumericVariable)this.categoryVar).category);
                }
                lineAccumulator.input.connectFrom((NumericPipe)responseMapper);
                lineAccumulator.setPostAccumulate(false);
            }
        }
        Calculator middle = new Calculator("(inA+inB)/2");
        middle.inA.connectFrom((NumericPipe)baseMapper);
        if (this.groupVar != null && this.groupDisplay == 1) {
            middle.inA.connectFrom(accumStart);
        }
        middle.inB.connectFrom((NumericPipe)responseMapper);
        if (yUpperErrorMapper != null) {
            yUpperErrorMapper.input.connectFrom(this.yUpperErrorVar.value);
        }
        if (yLowerErrorMapper != null) {
            yLowerErrorMapper.input.connectFrom(this.yLowerErrorVar.value);
        }
        if (targetMapper != null) {
            targetMapper.input.connectFrom(this.targetVar.value);
        }
        this.loadSkinImage();
        StringToNumericMapper categoryPipe = this.discreteCategory ? this.makeOffsetCalculator(discreteOffsetValue, (NumericPipe)categoryMapper) : categoryMapper;
        this.networkRoot.removeAllElements();
        this.bar = new Bar();
        this.networkRoot.addElement((Element)this.bar);
        this.bar.VGFRenderModeOn.setValue(StatGraph.VGF);
        this.bar.setSubpixelRendering(this.subpixelRendering);
        if (this.groupVar == null || this.groupVar != null && this.groupDisplay == 0) {
            this.bar.setDisplayZeroHeightBar(this.displayZeroHeightBar);
        }
        this.bar.edgeOn.setValue(this.edgeOn);
        if (colorMapper == null && lineColorMapper == null && linePatternMapper == null) {
            this.removeAttrVar("GROUP");
        }
        DiscreteAttrMapper discreteAttrMapper = groupAttrMapper = this.hasAttrVar("GROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("GROUP") : null;
        if (groupAttrMapper != null) {
            groupAttrMapper.setFillTransparency(this.getAttrTransparency((ColorAttr)this.fillStyle));
            groupAttrMapper.setUseFillTransparency(this.useFillTransparency);
            groupAttrMapper.setLineTransparency(this.dataTransparency);
            groupAttrMapper.variable = groupPipe;
            groupAttrMapper.fillColorMapper = colorMapper;
            groupAttrMapper.lineColorMapper = lineColorMapper != null ? lineColorMapper : fillPatternColorMapper;
            groupAttrMapper.linePatternMapper = linePatternMapper;
            groupAttrMapper.addLineThicknessPipe("outline", this.getEdgeStyle().getWidth());
        }
        NumericProperty outlinePattern = new NumericProperty();
        if (!(linePatternMapper == null || this.useEdgePattern || this.fillOn || this.fillPatternOn)) {
            if (groupAttrMapper != null) {
                outlinePattern.connectFrom((IntegerPipe)groupAttrMapper.linePattern);
            } else {
                outlinePattern.connectFrom((NumericPipe)linePatternMapper);
            }
        } else {
            outlinePattern.setValue((double)this.getEdgeStyle().getLinePattern());
        }
        if (this.edgeOn) {
            if (lineColorMapper != null && !this.useEdgeColor) {
                if (this.hasAttrVar("COLORRESPONSE")) {
                    double max;
                    ContinuousRange cr;
                    double min;
                    RangeAttrMapper mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE");
                    String error = mapper.createColorMapper(min = (cr = this.getUnionAllColorRange()).getMin(), max = cr.getMax(), true);
                    if (error != null) {
                        StatGraph.printWarning(error);
                        this.bar.edgeColor.connectFrom((ColorPipe)lineColorMapper);
                    } else {
                        mapper.setTransparency(this.dataTransparency);
                        mapper.variable = ((ContinuousRangeToColorMapper)lineColorMapper).input;
                        this.bar.edgeColor.connectFrom(mapper.color);
                    }
                } else if (groupAttrMapper != null && !this.gradientColor) {
                    this.bar.edgeColor.connectFrom((ColorPipe)groupAttrMapper.lineColor);
                } else {
                    this.bar.edgeColor.connectFrom((ColorPipe)lineColorMapper);
                }
            } else {
                this.bar.edgeColor.setValue(this.applyDataTransparency(this.getEdgeStyle().getColor()));
            }
        }
        this.bar.fillOn.setValue(this.fillOn);
        if (this.fillPatternOn && !this.isExtrudedOverlay()) {
            this.bar.fillPatternOn.setValue(this.fillPatternOn);
            this.bar.fillPatternType.connectFrom((IntegerPipe)fillPatternType);
            this.bar.fillPatternWidth.connectFrom((NumericPipe)fillPatternWidth);
            if (fillPatternColorMapper != null && this.fillPatternStyle.getColor() == null) {
                if (groupAttrMapper != null) {
                    this.bar.fillPatternColor.connectFrom((ColorPipe)groupAttrMapper.lineColor);
                } else {
                    this.bar.fillPatternColor.connectFrom((ColorPipe)fillPatternColorMapper);
                }
            } else if (this.gradientColor && !this.isFillOn()) {
                this.bar.fillPatternColor.connectFrom((ColorPipe)lineColorMapper);
            } else {
                this.bar.fillPatternColor.setValue(this.applyDataTransparency((ColorAttr)this.fillPatternStyle));
            }
            this.bar.fillPatternScaleFactor.setValue(StatGraph.dataDPIScaleFactor);
        }
        this.bar.setSkin(this.skinImage);
        this.bar.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
        this.bar.setPixelBenderImages(this.pixelBenderImages);
        if (this.skinType != 1 && this.skinType != 2) {
            this.bar.setSkinType(this.skinType);
        }
        if (this.fillOn) {
            boolean showGradient = this.isExtrudedOverlay();
            this.bar.gradientOn.setValue(showGradient || this.fillType == FILL_ALPHAGRADIENT || this.fillType == FILL_GRADIENT);
            this.bar.gradientDirection.setValue(1);
            if (colorMapper != null) {
                int count;
                if (this.hasAttrVar("COLORRESPONSE")) {
                    double max;
                    ContinuousRange cr;
                    double min;
                    RangeAttrMapper mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE");
                    String error = mapper.createColorMapper(min = (cr = this.getUnionAllColorRange()).getMin(), max = cr.getMax());
                    if (error != null) {
                        StatGraph.printWarning(error);
                        this.bar.color1.connectFrom((ColorPipe)colorMapper);
                        if (this.fillType == FILL_SOLID) {
                            this.bar.color2.connectFrom((ColorPipe)colorMapper);
                        } else if (this.fillType == FILL_GRADIENT) {
                            this.bar.color2.setValue(this.applyDataTransparency(this.gradientEndColor));
                        } else {
                            this.bar.color2.connectFrom(BarOverlay.alphaColor((ColorPipe)colorMapper, this.colorVar.getValueCount(), this.endAlpha));
                        }
                    } else {
                        mapper.setTransparency(this.fillStyle.getTransparency() >= 0.0 ? this.fillStyle.getTransparency() : this.dataTransparency);
                        mapper.variable = ((ContinuousRangeToColorMapper)colorMapper).input;
                        this.bar.color1.connectFrom(mapper.color);
                        if (this.fillType == FILL_SOLID) {
                            this.bar.color2.connectFrom(mapper.color);
                        } else if (this.fillType == FILL_GRADIENT) {
                            this.bar.color2.setValue(this.applyDataTransparency(this.gradientEndColor));
                        } else {
                            this.bar.color2.connectFrom(BarOverlay.alphaColor(mapper.color, this.colorVar.getValueCount(), this.endAlpha));
                        }
                    }
                } else if (showGradient) {
                    count = this.groupVar.getValueCount();
                    if (groupAttrMapper != null && !this.gradientColor) {
                        this.bar.color1.connectFrom(this.brighterColor(groupAttrMapper.fillColor, count));
                        this.bar.color2.connectFrom(groupAttrMapper.fillColor);
                    } else {
                        this.bar.color1.connectFrom(this.brighterColor((ColorPipe)colorMapper, count));
                        this.bar.color2.connectFrom((ColorPipe)colorMapper);
                    }
                } else {
                    if (groupAttrMapper != null && !this.gradientColor) {
                        this.bar.color1.connectFrom(groupAttrMapper.fillColor);
                    } else {
                        this.bar.color1.connectFrom((ColorPipe)colorMapper);
                    }
                    if (this.fillType == FILL_ALPHAGRADIENT) {
                        int n = count = this.gradientColor ? this.colorVar.getValueCount() : this.groupVar.getValueCount();
                        if (groupAttrMapper != null && !this.gradientColor) {
                            this.bar.color2.connectFrom(BarOverlay.alphaColor(groupAttrMapper.fillColor, count, this.endAlpha));
                        } else {
                            this.bar.color2.connectFrom(BarOverlay.alphaColor((ColorPipe)colorMapper, count, this.endAlpha));
                        }
                    } else if (this.fillType == FILL_GRADIENT) {
                        this.bar.color2.setValue(this.applyDataTransparency(this.gradientEndColor));
                    }
                }
            } else if (showGradient) {
                this.bar.color1.setValue(this.brighterColor(this.applyDataTransparency((ColorAttr)this.fillStyle)));
                this.bar.color2.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
            } else {
                this.bar.color1.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
                if (this.fillType == FILL_ALPHAGRADIENT) {
                    this.bar.color2.setValue(BarOverlay.alphaColor(this.applyDataTransparency((ColorAttr)this.fillStyle), this.endAlpha));
                } else if (this.fillType == FILL_GRADIENT) {
                    this.bar.color2.setValue(this.applyDataTransparency(this.gradientEndColor));
                }
            }
        } else if (lineColorMapper != null && !this.useEdgeColor) {
            if (groupAttrMapper != null && !this.gradientColor) {
                this.bar.color1.connectFrom((ColorPipe)groupAttrMapper.lineColor);
            } else {
                this.bar.color1.connectFrom((ColorPipe)lineColorMapper);
            }
        } else {
            this.bar.color1.setValue(this.applyDataTransparency(this.getEdgeStyle().getColor()));
        }
        if (this.useLineThickness || !this.hasAttrVar("GROUP")) {
            this.bar.edgeWidth.setValue((double)this.getEdgeStyle().getWidth());
        } else {
            this.bar.edgeWidth.connectFrom((IntegerPipe)groupAttrMapper.lineThickness.get("outline"));
        }
        this.bar.edgePattern.connectFrom((NumericPipe)outlinePattern);
        this.bar.setUserData((Object)probe);
        barSize = this.discreteCategory || this.intervalBarWidth < 0.0 ? this.barWidth * barSize : this.intervalBarWidth;
        this.bar.verticalOn.setValue(this.orientation == 0);
        this.bar.position.connectFrom((NumericPipe)categoryPipe);
        this.bar.thickness.setValue(barSize);
        this.bar.startValue.connectFrom((NumericPipe)baseMapper);
        this.bar.endValue.connectFrom((NumericPipe)responseMapper);
        if (this.groupVar != null && this.groupDisplay == 1) {
            this.bar.startValue.connectFrom((NumericPipe)accumStartMapper);
            this.bar.endValue.connectFrom((NumericPipe)accumEndMapper);
        }
        if (this.isExtrudedOverlay()) {
            this.bar.setTwoD(false);
            this.bar.transform.translateZ.setValue(this.extrusionDepth * 0.5);
            this.bar.transform.scaleZ.setValue(this.extrusionDepth / barSize);
        }
        if (targetMapper != null) {
            Bar bar2 = new Bar();
            this.networkRoot.addElement((Element)bar2);
            bar2.verticalOn.setValue(this.orientation == 0);
            bar2.position.connectFrom((NumericPipe)categoryPipe);
            bar2.thickness.setValue(barSize);
            bar2.startValue.connectFrom((NumericPipe)baseMapper);
            bar2.endValue.connectFrom((NumericPipe)baseMapper);
            bar2.fillOn.setValue(false);
            bar2.edgeOn.setValue(false);
            bar2.targetOn.setValue(true);
            bar2.targetValue.connectFrom((NumericPipe)targetMapper);
            bar2.targetColor.setValue(this.applyDataTransparency(this.getTargetColor()));
            bar2.targetThickness.setValue(10.0 * StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor);
            bar2.targetLineThickness.setValue(1.0 * StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor);
        }
        if (this.isConnectOn() && this.groupVar == null) {
            LineConnector lineConnector = new LineConnector();
            lineConnector.setMultipleGroup(true);
            lineConnector.setPresortRequired(true);
            this.networkRoot.addElement((Element)lineConnector);
            if (this.orientation == 0) {
                lineConnector.pointX.connectFrom((NumericPipe)categoryPipe);
                lineConnector.pointY.connectFrom((NumericPipe)responseMapper);
            } else {
                lineConnector.pointY.connectFrom((NumericPipe)categoryPipe);
                lineConnector.pointX.connectFrom((NumericPipe)responseMapper);
                lineConnector.setSkipMissingOnXAxis(true);
            }
            lineConnector.color.setValue(this.applyDataTransparency(this.getConnectStyle().getColor()));
            lineConnector.setStipple(this.getConnectStyle().getStipplePattern(), this.getConnectStyle().getStippleFactor());
            lineConnector.linePattern.setValue(this.getConnectStyle().getLinePattern());
            lineConnector.lineWidth.setValue((double)this.getConnectStyle().getWidth());
            lineConnector.setUserData((Object)probe);
            lineConnector.setConnectionOrder(this.connectionOrder);
            lineConnector.setSkipMissingOn(this.connectSkipMiss);
        }
        if (this.baselineOn) {
            LineSegment barBaseline = new LineSegment();
            this.networkRoot.addElement((Element)barBaseline);
            if (this.orientation == 0) {
                barBaseline.beginX.setValue(this.xEncoder.getLowerLimit());
                barBaseline.beginY.connectFrom((NumericPipe)baseMapper);
                barBaseline.endX.setValue(this.xEncoder.getUpperLimit());
                barBaseline.endY.connectFrom((NumericPipe)baseMapper);
            } else {
                barBaseline.beginY.setValue(this.yEncoder.getLowerLimit());
                barBaseline.beginX.connectFrom((NumericPipe)baseMapper);
                barBaseline.endY.setValue(this.yEncoder.getUpperLimit());
                barBaseline.endX.connectFrom((NumericPipe)baseMapper);
            }
            barBaseline.color.setValue(this.applyDataTransparency((ColorAttr)this.baselineStyle));
            barBaseline.lineWidth.setValue((double)this.baselineStyle.getWidth());
            barBaseline.setStipple(this.baselineStyle.getStipplePattern(), this.baselineStyle.getStippleFactor());
        }
        if (this.showSegmentLabel) {
            StringToNumericMapper cMapper;
            SASFormat fmt;
            if (this.segmentLabelFitPolicy == SEGMENTLABEL_FIT_NOCLIP) {
                if (this.networkRoot2 == null) {
                    this.networkRoot2 = new NetworkRoot(this.networkRoot.getChannel());
                } else {
                    this.networkRoot2.removeAllElements();
                }
            }
            if (this.groupVar != null && this.groupDisplay == 1) {
                accumStart.init(new AInitAction(null));
                accumEnd.init(new AInitAction(null));
                accumStartMapper.init(new AInitAction(null));
                accumEndMapper.init(new AInitAction(null));
            } else {
                responseMapper.init(new AInitAction(null));
                baseMapper.init(new AInitAction(null));
            }
            if (this.group100) {
                fmt = this.group100Format;
            } else if (this.segmentLabelFormat != null) {
                fmt = this.segmentLabelFormat;
            } else {
                fmt = this.isMultiResponse() ? this.getFormat(610) : this.getFormat(2);
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                } else if (fmt.getFormatDescription().isDecimalWidthSupported()) {
                    int w = fmt.getFormatDescription().getMaxWidth();
                    int d = fmt.getDecimalWidth();
                    fmt = SASFormat.getInstance((String)(fmt.getBaseFormatName() + Integer.toString(w).trim() + "." + Integer.toString(d).trim()));
                    fmt.setInsertBlanks(false);
                }
            }
            int n = this.categoryVar.getValueCount();
            StringVector lab = new StringVector();
            NumericVector midResp = new NumericVector();
            for (int i10 = 0; i10 < n; ++i10) {
                try {
                    double mid;
                    double rVal;
                    if (this.groupVar != null && this.groupDisplay == 1) {
                        rVal = accumEnd.input.getValue(i10);
                        double d1 = accumStart.value.getValue(i10);
                        double d2 = accumEnd.value.getValue(i10);
                        mid = (d1 + d2) * 0.5;
                    } else {
                        rVal = this.responseVar.value.getValue(i10);
                        if (this.group100) {
                            rVal *= this.percentWeight.getValue(i10);
                        }
                        mid = (rVal + this.baseline) * 0.5;
                    }
                    midResp.addValue(mid);
                    if (this.segmentLabelFitPolicy != SEGMENTLABEL_FIT_THIN) {
                        lab.addValue(fmt.format((Object)new Double(rVal)).trim());
                        continue;
                    }
                    double w = barSize;
                    double h = this.groupVar != null && this.groupDisplay == 1 ? Math.abs(accumEndMapper.getValue(i10) - accumStartMapper.getValue(i10)) : Math.abs(responseMapper.getValue(i10) - baseMapper.getValue(i10));
                    if (this.orientation == 1) {
                        double temp = h;
                        h = w;
                        w = temp;
                    }
                    lab.addValue(this.thinSegmentLabel(fmt.format((Object)new Double(rVal)).trim(), w, h, this.segmentLabelStyle.getFont()));
                    continue;
                }
                catch (MissingValueException e) {
                    midResp.addValue(Double.NaN);
                    lab.addValue("");
                }
            }
            PositionEncoder positionEncoder = ve = this.orientation == 0 ? this.xEncoder : this.yEncoder;
            if (this.groupVar != null && this.groupDisplay == 0) {
                cMapper = categoryMapper;
            } else if (this.discreteCategory) {
                cMapper = new StringToNumericMapper();
                cMapper.setMap((StringToNumericMap)ve.getValueMap());
                cMapper.input.connectFrom(((StringVariable)this.categoryVar).value);
            } else {
                cMapper = new ContinuousRangeToNumericMapper();
                ((ContinuousRangeToNumericMapper)cMapper).setMap((ContinuousRangeToNumericMap)ve.getValueMap());
                ((ContinuousRangeToNumericMapper)cMapper).input.connectFrom(((NumericVariable)this.categoryVar).value);
            }
            StringToNumericMapper cPipe = this.discreteCategory ? this.makeOffsetCalculator(discreteOffsetValue, (NumericPipe)cMapper) : cMapper;
            ve = this.orientation == 0 ? this.yEncoder : this.xEncoder;
            ContinuousRangeToNumericMapper rMapper = new ContinuousRangeToNumericMapper();
            if (ve instanceof BrokenPositionEncoder) {
                rMapper.setMap((ContinuousRangeToNumericMap)((BrokenPositionEncoder)ve).getBrokenValueMap());
            } else {
                rMapper.setMap((ContinuousRangeToNumericMap)ve.getValueMap());
            }
            rMapper.input.connectFrom((NumericPipe)midResp);
            ColorProperty color = new ColorProperty();
            if (!this.useSegmentLabelColor) {
                color.connectFrom((ColorPipe)colorMapper);
            } else {
                color.setValue(this.applyDataTransparency(this.segmentLabelStyle.getColor()));
            }
            RasterLabel label = new RasterLabel();
            label.string.connectFrom((StringPipe)lab);
            label.trimOn.setValue(true);
            label.color.connectFrom((ColorPipe)color);
            label.fontName.setValue(this.segmentLabelStyle.getFont().getName());
            label.fontSize.setValue(this.segmentLabelStyle.getFont().getSize());
            label.fontStyle.setValue(this.segmentLabelStyle.getFont().getStyle());
            label.angle.setValue(0.0);
            if (this.orientation == 0) {
                label.transform.translateX.connectFrom((NumericPipe)cPipe);
                label.transform.translateY.connectFrom((NumericPipe)rMapper);
                label.horizontalJustification.setValue(1);
                label.verticalJustification.setValue(1);
            } else {
                label.transform.translateX.connectFrom((NumericPipe)rMapper);
                label.transform.translateY.connectFrom((NumericPipe)cPipe);
                label.horizontalJustification.setValue(1);
                label.verticalJustification.setValue(1);
            }
            if (this.segmentLabelFitPolicy == SEGMENTLABEL_FIT_NOCLIP) {
                this.networkRoot2.addElement((Element)label);
            } else {
                this.networkRoot.addElement((Element)label);
            }
        }
        if (this.showBarValue && !this.labelDropped) {
            NumericVector cMapper;
            StringVector lVals;
            NumericVector rVals;
            StringVector cVals;
            SASFormat fmt;
            if (this.group100) {
                fmt = this.group100Format;
            } else if (this.labelFormat != null) {
                fmt = this.labelFormat;
            } else {
                fmt = this.isMultiResponse() ? this.getFormat(610) : this.getFormat(2);
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                } else if (fmt.getFormatDescription().isDecimalWidthSupported()) {
                    int w = fmt.getFormatDescription().getMaxWidth();
                    int d = fmt.getDecimalWidth();
                    fmt = SASFormat.getInstance((String)(fmt.getBaseFormatName() + Integer.toString(w).trim() + "." + Integer.toString(d).trim()));
                    fmt.setInsertBlanks(false);
                }
            }
            StringProperty cat = this.discreteCategory ? new StringProperty() : new NumericProperty();
            NumericProperty resp = new NumericProperty();
            StringProperty lab = new StringProperty();
            NumericVector catPos = new NumericVector();
            ColorVector colVec = new ColorVector();
            int labelCount = 0;
            if (this.positiveAccumulation != null && this.negativeAccumulation != null) {
                cVals = this.discreteCategory ? new StringVector() : new NumericVector();
                rVals = new NumericVector();
                lVals = new StringVector();
                int n = this.categoryVar.getUniqueValueCount();
                for (int i11 = 0; i11 < n; ++i11) {
                    double sum = this.positiveGroupOnly ? this.positiveAccumulation[i11] : this.positiveAccumulation[i11] + Math.abs(this.negativeAccumulation[i11]);
                    try {
                        if (this.positiveAccumulation[i11] > 0.0) {
                            if (this.discreteCategory) {
                                cVals.addValue(((StringVariable)this.categoryVar).uniqueValue.getValue(i11));
                            } else {
                                ((NumericVector)cVals).addValue(((NumericVariable)this.categoryVar).uniqueValue.getValue(i11));
                            }
                            if (this.group100) {
                                double posV = this.positiveAccumulation[i11] / sum;
                                rVals.addValue(posV);
                                lVals.addValue(fmt.format((Object)new Double(posV)));
                            } else {
                                rVals.addValue(this.positiveAccumulation[i11]);
                                lVals.addValue(fmt.format((Object)new Double(this.positiveAccumulation[i11])));
                            }
                            ++labelCount;
                        }
                        if (!(!(this.negativeAccumulation[i11] < 0.0) || this.group100 && this.positiveGroupOnly)) {
                            if (this.discreteCategory) {
                                cVals.addValue(((StringVariable)this.categoryVar).uniqueValue.getValue(i11));
                            } else {
                                ((NumericVector)cVals).addValue(((NumericVariable)this.categoryVar).uniqueValue.getValue(i11));
                            }
                            if (this.group100) {
                                double negV = this.negativeAccumulation[i11] / sum;
                                rVals.addValue(negV);
                                lVals.addValue(fmt.format((Object)new Double(negV)));
                            } else {
                                rVals.addValue(this.negativeAccumulation[i11]);
                                lVals.addValue(fmt.format((Object)new Double(this.negativeAccumulation[i11])));
                            }
                            ++labelCount;
                        }
                        if (this.positiveAccumulation[i11] != 0.0 || this.negativeAccumulation[i11] != 0.0 || this.group100) continue;
                        boolean missing = this.isResponseAllMissing(this.categoryVar, this.responseVar, i11);
                        if (this.discreteCategory) {
                            cVals.addValue(((StringVariable)this.categoryVar).uniqueValue.getValue(i11));
                        } else {
                            ((NumericVector)cVals).addValue(((NumericVariable)this.categoryVar).uniqueValue.getValue(i11));
                        }
                        rVals.addValue(this.positiveAccumulation[i11]);
                        if (missing) {
                            lVals.addValue("");
                        } else {
                            lVals.addValue(fmt.format((Object)new Double(this.positiveAccumulation[i11])));
                        }
                        ++labelCount;
                        continue;
                    }
                    catch (MissingValueException missing) {
                        // empty catch block
                    }
                }
                if (this.discreteCategory) {
                    cat.connectFrom((StringPipe)cVals);
                } else {
                    ((NumericProperty)cat).connectFrom((NumericPipe)((NumericVector)cVals));
                }
                resp.connectFrom((NumericPipe)rVals);
                lab.connectFrom((StringPipe)lVals);
            } else {
                cVals = this.discreteCategory ? new StringVector() : new NumericVector();
                rVals = new NumericVector();
                lVals = new StringVector();
                if (colorMapper != null) {
                    colorMapper.init(new AInitAction(null));
                }
                if (lineColorMapper != null) {
                    lineColorMapper.init(new AInitAction(null));
                }
                for (int i12 = 0; i12 < this.responseVar.getValueCount(); ++i12) {
                    try {
                        double respV = this.responseVar.value.getValue(i12);
                        if (this.group100) {
                            respV *= this.percentWeight.getValue(i12);
                        }
                        rVals.addValue(respV);
                        if (this.discreteCategory) {
                            cVals.addValue(((StringVariable)this.categoryVar).value.getValue(i12));
                        } else {
                            ((NumericVector)cVals).addValue(((NumericVariable)this.categoryVar).value.getValue(i12));
                        }
                        lVals.addValue(fmt.format((Object)new Double(respV)));
                        ++labelCount;
                        try {
                            catPos.addValue(categoryMapper.getValue(i12));
                        }
                        catch (MissingValueException e) {
                            catPos.addValue(Double.NaN);
                        }
                        if (this.fillOn) {
                            if (colorMapper != null) {
                                if (groupAttrMapper != null && !this.gradientColor) {
                                    colVec.addValue(groupAttrMapper.fillColor.getValue(i12));
                                    continue;
                                }
                                colVec.addValue(colorMapper.getValue(i12));
                                continue;
                            }
                            colVec.addValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
                            continue;
                        }
                        if (lineColorMapper != null && !this.useEdgeColor) {
                            if (groupAttrMapper != null && !this.gradientColor) {
                                colVec.addValue(groupAttrMapper.lineColor.getValue(i12));
                                continue;
                            }
                            colVec.addValue(lineColorMapper.getValue(i12));
                            continue;
                        }
                        colVec.addValue(this.applyDataTransparency(this.getEdgeStyle().getColor()));
                        continue;
                    }
                    catch (MissingValueException respV) {
                        // empty catch block
                    }
                }
                if (this.discreteCategory) {
                    cat.connectFrom((StringPipe)cVals);
                } else {
                    ((NumericProperty)cat).connectFrom((NumericPipe)((NumericVector)cVals));
                }
                resp.connectFrom((NumericPipe)rVals);
                lab.connectFrom((StringPipe)lVals);
            }
            PositionEncoder positionEncoder = ve = this.orientation == 0 ? this.xEncoder : this.yEncoder;
            if (this.groupVar != null && this.groupDisplay == 0) {
                cMapper = catPos;
            } else if (this.discreteCategory) {
                cMapper = new StringToNumericMapper();
                ((StringToNumericMapper)cMapper).setMap((StringToNumericMap)ve.getValueMap());
                ((StringToNumericMapper)cMapper).input.connectFrom((StringPipe)cat);
            } else {
                cMapper = new ContinuousRangeToNumericMapper();
                ((ContinuousRangeToNumericMapper)cMapper).setMap((ContinuousRangeToNumericMap)ve.getValueMap());
                ((ContinuousRangeToNumericMapper)cMapper).input.connectFrom((NumericPipe)((NumericProperty)cat));
            }
            NumericVector cPipe = this.discreteCategory ? this.makeOffsetCalculator(discreteOffsetValue, (NumericPipe)cMapper) : cMapper;
            ve = this.orientation == 0 ? this.yEncoder : this.xEncoder;
            ContinuousRangeToNumericMapper rMapper = new ContinuousRangeToNumericMapper();
            if (ve instanceof BrokenPositionEncoder) {
                rMapper.setMap((ContinuousRangeToNumericMap)((BrokenPositionEncoder)ve).getBrokenValueMap());
            } else {
                rMapper.setMap((ContinuousRangeToNumericMap)ve.getValueMap());
            }
            rMapper.input.connectFrom((NumericPipe)resp);
            int scaledValueFontSize = -1;
            ColorProperty color = new ColorProperty();
            if (this.groupVar != null && this.groupDisplay == 0 && !this.useLabelColor) {
                color.connectFrom((ColorPipe)colVec);
            } else {
                color.setValue(this.applyDataTransparency(this.labelStyle.getColor()));
            }
            RasterLabel label = new RasterLabel();
            label.string.connectFrom((StringPipe)lab);
            label.trimOn.setValue(true);
            label.color.connectFrom((ColorPipe)color);
            label.fontName.setValue(this.labelStyle.getFont().getName());
            if (scaledValueFontSize > 0) {
                label.fontSize.setValue(scaledValueFontSize);
            } else {
                label.fontSize.setValue(this.labelStyle.getFont().getSize());
            }
            label.fontStyle.setValue(this.labelStyle.getFont().getStyle());
            label.angle.setValue(this.labelRotated ? 90.0 : 0.0);
            Calculator trans = new Calculator("inA + inB");
            NumericVector offset = new NumericVector();
            trans.inA.connectFrom((NumericPipe)rMapper);
            trans.inB.connectFrom((NumericPipe)offset);
            NumericVector labelXPos = null;
            if (this.labelInside && this.insideLabelCenterJustification) {
                labelXPos = new NumericVector();
                rMapper.input.connectFrom((NumericPipe)labelXPos);
            }
            IntegerVector just = new IntegerVector();
            boolean reverse = this.orientation == 0 ? this.yEncoder.isReversed() : this.xEncoder.isReversed();
            boolean labelAboveBaseline = this.statRange.getMax() == this.baseline && this.statRange.getMin() == this.baseline;
            for (int i13 = 0; i13 < labelCount; ++i13) {
                try {
                    if (labelAboveBaseline || resp.getValue(i13) >= this.baseline && this.statRange.getMax() > this.baseline && !reverse || (resp.getValue(i13) < this.baseline || this.statRange.getMax() <= this.baseline) && reverse) {
                        if (this.labelInside && this.labelInsideBar[i13]) {
                            if (this.insideLabelCenterJustification) {
                                offset.addValue(0.0);
                                just.addValue(1);
                                labelXPos.addValue((resp.getValue(i13) + this.baseline) * 0.5);
                                continue;
                            }
                            offset.addValue((double)(-(this.getExtraSpace() + this.extraPadding)));
                            just.addValue(2);
                            continue;
                        }
                        offset.addValue((double)(this.getExtraSpace() + this.extraPadding));
                        if (this.orientation == 0) {
                            just.addValue(3);
                        } else {
                            just.addValue(0);
                        }
                        if (labelXPos == null) continue;
                        labelXPos.addValue(resp.getValue(i13));
                        continue;
                    }
                    if (this.labelInside && this.labelInsideBar[i13]) {
                        if (this.insideLabelCenterJustification) {
                            offset.addValue(0.0);
                            just.addValue(1);
                            labelXPos.addValue((resp.getValue(i13) + this.baseline) * 0.5);
                            continue;
                        }
                        offset.addValue((double)(this.getExtraSpace() + this.extraPadding));
                        just.addValue(0);
                        continue;
                    }
                    offset.addValue((double)(-(this.getExtraSpace() + this.extraPadding)));
                    if (this.orientation == 0) {
                        just.addValue(0);
                    } else {
                        just.addValue(2);
                    }
                    if (labelXPos == null) continue;
                    labelXPos.addValue(resp.getValue(i13));
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            if (this.orientation == 0) {
                label.transform.translateX.connectFrom((NumericPipe)cPipe);
                label.transform.translateY.connectFrom((NumericPipe)trans);
                label.horizontalJustification.setValue(1);
                label.verticalJustification.connectFrom((IntegerPipe)just);
            } else {
                label.transform.translateY.connectFrom((NumericPipe)cPipe);
                label.transform.translateX.connectFrom((NumericPipe)trans);
                label.horizontalJustification.connectFrom((IntegerPipe)just);
                label.verticalJustification.setValue(1);
            }
            this.networkRoot.addElement((Element)label);
        }
        if (this.labelVar != null && !this.labelDropped) {
            StringToNumericMapper cMapper;
            PositionEncoder positionEncoder = ve = this.orientation == 0 ? this.xEncoder : this.yEncoder;
            if (this.groupVar != null && this.groupDisplay == 0) {
                cMapper = categoryMapper;
            } else if (this.discreteCategory) {
                cMapper = new StringToNumericMapper();
                cMapper.setMap((StringToNumericMap)ve.getValueMap());
                cMapper.input.connectFrom(((StringVariable)this.catVar).value);
            } else {
                cMapper = new ContinuousRangeToNumericMapper();
                ((ContinuousRangeToNumericMapper)cMapper).setMap((ContinuousRangeToNumericMap)ve.getValueMap());
                ((ContinuousRangeToNumericMapper)cMapper).input.connectFrom(((NumericVariable)this.catVar).value);
            }
            NumericPipe cPipe = this.makeOffsetCalculator(discreteOffsetValue, (NumericPipe)cMapper);
            ve = this.orientation == 0 ? this.yEncoder : this.xEncoder;
            ContinuousRangeToNumericMapper rMapper = new ContinuousRangeToNumericMapper();
            if (ve instanceof BrokenPositionEncoder) {
                rMapper.setMap((ContinuousRangeToNumericMap)((BrokenPositionEncoder)ve).getBrokenValueMap());
            } else {
                rMapper.setMap((ContinuousRangeToNumericMap)ve.getValueMap());
            }
            rMapper.input.connectFrom(this.respVar.value);
            ColorProperty color = new ColorProperty();
            if (this.groupVar != null && this.groupDisplay == 0 && !this.useLabelColor) {
                if (this.fillOn) {
                    if (colorMapper != null) {
                        if (groupAttrMapper != null && !this.gradientColor) {
                            color.connectFrom(groupAttrMapper.fillColor);
                        } else {
                            color.connectFrom((ColorPipe)colorMapper);
                        }
                    } else {
                        color.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
                    }
                } else if (lineColorMapper != null && !this.useEdgeColor) {
                    if (groupAttrMapper != null && !this.gradientColor) {
                        color.connectFrom((ColorPipe)groupAttrMapper.lineColor);
                    } else {
                        color.connectFrom((ColorPipe)lineColorMapper);
                    }
                } else {
                    color.setValue(this.applyDataTransparency(this.getEdgeStyle().getColor()));
                }
            } else {
                color.setValue(this.applyDataTransparency(this.labelStyle.getColor()));
            }
            RasterLabel label = new RasterLabel();
            if (this.dataLabelSplit) {
                label.string.connectFrom((StringPipe)this.splitDataLabelPipe);
            } else if (this.numericLabel) {
                label.string.connectFrom(((NumericVariable)this.labVar).formattedValue);
            } else {
                label.string.connectFrom(((StringVariable)this.labVar).formattedValue);
            }
            label.trimOn.setValue(true);
            label.color.connectFrom((ColorPipe)color);
            label.fontName.setValue(this.labelStyle.getFont().getName());
            label.fontSize.setValue(this.labelStyle.getFont().getSize());
            label.fontStyle.setValue(this.labelStyle.getFont().getStyle());
            label.angle.setValue(this.labelRotated ? 90.0 : 0.0);
            Calculator trans = new Calculator("inA + inB");
            NumericVector offset = new NumericVector();
            trans.inA.connectFrom((NumericPipe)rMapper);
            trans.inB.connectFrom((NumericPipe)offset);
            NumericVector labelXPos = null;
            if (this.labelInside && this.insideLabelCenterJustification) {
                labelXPos = new NumericVector();
                rMapper.input.connectFrom((NumericPipe)labelXPos);
            }
            IntegerVector just = new IntegerVector();
            boolean reverse = this.orientation == 0 ? this.yEncoder.isReversed() : this.xEncoder.isReversed();
            boolean labelAboveBaseline = this.respVar.getMax() == this.baseline && this.respVar.getMin() == this.baseline;
            for (int i14 = 0; i14 < this.labVar.getValueCount(); ++i14) {
                try {
                    if (labelAboveBaseline || this.respVar.value.getValue(i14) >= this.baseline && this.respVar.getMax() > this.baseline && !reverse || (this.respVar.value.getValue(i14) < this.baseline || this.respVar.getMax() <= this.baseline) && reverse) {
                        if (this.labelInside && this.labelInsideBar[i14]) {
                            if (this.insideLabelCenterJustification) {
                                offset.addValue(0.0);
                                just.addValue(1);
                                labelXPos.addValue((this.respVar.value.getValue(i14) + this.baseline) * 0.5);
                                continue;
                            }
                            offset.addValue((double)(-(this.getExtraSpace() + this.extraPadding)));
                            just.addValue(2);
                            continue;
                        }
                        offset.addValue((double)(this.getExtraSpace() + this.extraPadding));
                        if (this.orientation == 0) {
                            just.addValue(3);
                        } else {
                            just.addValue(0);
                        }
                        if (labelXPos == null) continue;
                        labelXPos.addValue(this.respVar.value.getValue(i14));
                        continue;
                    }
                    if (this.labelInside && this.labelInsideBar[i14]) {
                        if (this.insideLabelCenterJustification) {
                            offset.addValue(0.0);
                            just.addValue(1);
                            labelXPos.addValue((this.respVar.value.getValue(i14) + this.baseline) * 0.5);
                            continue;
                        }
                        offset.addValue((double)(this.getExtraSpace() + this.extraPadding));
                        just.addValue(0);
                        continue;
                    }
                    offset.addValue((double)(-(this.getExtraSpace() + this.extraPadding)));
                    if (this.orientation == 0) {
                        just.addValue(0);
                    } else {
                        just.addValue(2);
                    }
                    if (labelXPos == null) continue;
                    labelXPos.addValue(this.respVar.value.getValue(i14));
                    continue;
                }
                catch (MissingValueException e) {
                    offset.addValue(Double.NaN);
                    just.addValue(3);
                }
            }
            if (this.orientation == 0) {
                label.transform.translateX.connectFrom(cPipe);
                label.transform.translateY.connectFrom((NumericPipe)trans);
                label.horizontalJustification.setValue(1);
                label.verticalJustification.connectFrom((IntegerPipe)just);
            } else {
                label.transform.translateY.connectFrom(cPipe);
                label.transform.translateX.connectFrom((NumericPipe)trans);
                label.horizontalJustification.connectFrom((IntegerPipe)just);
                label.verticalJustification.setValue(1);
            }
            this.networkRoot.addElement((Element)label);
        }
        int halfEB = 5 * this.errorStyle.getWidth();
        if (this.capScale != 1.0) {
            halfEB = (int)(this.capScale * (double)halfEB);
        }
        if (this.yUpperErrorVar != null && this.yEncoder != null) {
            Calculator ce;
            Calculator cs;
            LineSegment yUpperError = new LineSegment();
            this.networkRoot.addElement((Element)yUpperError);
            LineSegment yueEnd = new LineSegment();
            if (this.errorCapVisible) {
                this.networkRoot.addElement((Element)yueEnd);
            }
            yUpperError.setUserData((Object)this.yueProbe);
            yueEnd.setUserData((Object)this.yueProbe);
            if (this.orientation == 0) {
                yUpperError.beginX.connectFrom((NumericPipe)categoryPipe);
                yUpperError.beginY.connectFrom((NumericPipe)responseMapper);
                yUpperError.endX.connectFrom((NumericPipe)categoryPipe);
                yUpperError.endY.connectFrom((NumericPipe)yUpperErrorMapper);
                yueEnd.beginY.connectFrom((NumericPipe)yUpperErrorMapper);
                yueEnd.endY.connectFrom((NumericPipe)yUpperErrorMapper);
                cs = new Calculator("inA - inB");
                cs.inA.connectFrom((NumericPipe)categoryPipe);
                cs.inB.setValue((double)halfEB);
                yueEnd.beginX.connectFrom((NumericPipe)cs);
                ce = new Calculator("inA + inB");
                ce.inA.connectFrom((NumericPipe)categoryPipe);
                ce.inB.setValue((double)halfEB);
                yueEnd.endX.connectFrom((NumericPipe)ce);
            } else {
                yUpperError.beginX.connectFrom((NumericPipe)responseMapper);
                yUpperError.beginY.connectFrom((NumericPipe)categoryPipe);
                yUpperError.endX.connectFrom((NumericPipe)yUpperErrorMapper);
                yUpperError.endY.connectFrom((NumericPipe)categoryPipe);
                yueEnd.beginX.connectFrom((NumericPipe)yUpperErrorMapper);
                yueEnd.endX.connectFrom((NumericPipe)yUpperErrorMapper);
                cs = new Calculator("inA - inB");
                cs.inA.connectFrom((NumericPipe)categoryPipe);
                cs.inB.setValue((double)halfEB);
                yueEnd.beginY.connectFrom((NumericPipe)cs);
                ce = new Calculator("inA + inB");
                ce.inA.connectFrom((NumericPipe)categoryPipe);
                ce.inB.setValue((double)halfEB);
                yueEnd.endY.connectFrom((NumericPipe)ce);
            }
            yUpperError.color.setValue(this.applyDataTransparency(this.getErrorStyle().getColor()));
            yUpperError.lineWidth.setValue((double)this.getErrorStyle().getWidth());
            yUpperError.setStipple(this.getErrorStyle().getStipplePattern(), this.getErrorStyle().getStippleFactor());
            yueEnd.color.connectFrom((ColorPipe)yUpperError.color);
            yueEnd.lineWidth.connectFrom((NumericPipe)yUpperError.lineWidth);
        }
        if (this.yLowerErrorVar != null && this.yEncoder != null) {
            Calculator ce;
            Calculator cs;
            LineSegment yLowerError = new LineSegment();
            this.networkRoot.addElement((Element)yLowerError);
            LineSegment yleEnd = new LineSegment();
            if (this.errorCapVisible) {
                this.networkRoot.addElement((Element)yleEnd);
            }
            yLowerError.setUserData((Object)this.yleProbe);
            yleEnd.setUserData((Object)this.yleProbe);
            if (this.orientation == 0) {
                yLowerError.beginX.connectFrom((NumericPipe)categoryPipe);
                yLowerError.beginY.connectFrom((NumericPipe)responseMapper);
                yLowerError.endX.connectFrom((NumericPipe)categoryPipe);
                yLowerError.endY.connectFrom((NumericPipe)yLowerErrorMapper);
                yleEnd.beginY.connectFrom((NumericPipe)yLowerErrorMapper);
                yleEnd.endY.connectFrom((NumericPipe)yLowerErrorMapper);
                cs = new Calculator("inA - inB");
                cs.inA.connectFrom((NumericPipe)categoryPipe);
                cs.inB.setValue((double)halfEB);
                yleEnd.beginX.connectFrom((NumericPipe)cs);
                ce = new Calculator("inA + inB");
                ce.inA.connectFrom((NumericPipe)categoryPipe);
                ce.inB.setValue((double)halfEB);
                yleEnd.endX.connectFrom((NumericPipe)ce);
            } else {
                yLowerError.beginX.connectFrom((NumericPipe)yLowerErrorMapper);
                yLowerError.beginY.connectFrom((NumericPipe)categoryPipe);
                yLowerError.endX.connectFrom((NumericPipe)responseMapper);
                yLowerError.endY.connectFrom((NumericPipe)categoryPipe);
                yleEnd.beginX.connectFrom((NumericPipe)yLowerErrorMapper);
                yleEnd.endX.connectFrom((NumericPipe)yLowerErrorMapper);
                cs = new Calculator("inA - inB");
                cs.inA.connectFrom((NumericPipe)categoryPipe);
                cs.inB.setValue((double)halfEB);
                yleEnd.beginY.connectFrom((NumericPipe)cs);
                ce = new Calculator("inA + inB");
                ce.inA.connectFrom((NumericPipe)categoryPipe);
                ce.inB.setValue((double)halfEB);
                yleEnd.endY.connectFrom((NumericPipe)ce);
            }
            yLowerError.color.setValue(this.applyDataTransparency(this.getErrorStyle().getColor()));
            yLowerError.lineWidth.setValue((double)this.getErrorStyle().getWidth());
            yLowerError.setStipple(this.getErrorStyle().getStipplePattern(), this.getErrorStyle().getStippleFactor());
            yleEnd.color.connectFrom((ColorPipe)yLowerError.color);
            yleEnd.lineWidth.connectFrom((NumericPipe)yLowerError.lineWidth);
        }
        if (this.isConditionalHilited()) {
            IntegerVector chHAlign = new IntegerVector();
            IntegerVector chVAlign = new IntegerVector();
            this.buildCHAlignments(chHAlign, chVAlign);
            for (int i15 = 0; i15 < this.getNumCHPipes(); ++i15) {
                BooleanVector bv = this.getCHPipe(i15);
                com.sas.graphics.util.gtk.gl.Image tag = RPFUtil.newTagElement(i15, false, this.networkRoot.getChannel().getComponent());
                this.networkRoot.addElement((Element)tag);
                if (this.orientation == 1) {
                    tag.transform.translateY.connectFrom((NumericPipe)categoryPipe);
                    tag.transform.translateX.connectFrom((NumericPipe)this.bar.startValue);
                } else {
                    tag.transform.translateX.connectFrom((NumericPipe)categoryPipe);
                    tag.transform.translateY.connectFrom((NumericPipe)this.bar.startValue);
                }
                tag.horizontalJustification.connectFrom((IntegerPipe)chHAlign);
                tag.verticalJustification.connectFrom((IntegerPipe)chVAlign);
                tag.visibility.connectFrom((BooleanPipe)bv);
            }
        }
        if (this.labelDropped) {
            this.printLabelDroppedMessage();
        }
        this.needConnect = false;
        return true;
    }

    private String thinSegmentLabel(String label, double width, double height, Font font) {
        String thinnedLabel = label;
        if (label.length() > 0) {
            FontRenderContext frc = new FontRenderContext(null, true, false);
            TextLayout tl = new TextLayout(label, font, frc);
            double w = tl.getVisibleAdvance();
            double h = tl.getAscent() + tl.getDescent();
            if (w > width || h > height) {
                thinnedLabel = "";
            }
        }
        return thinnedLabel;
    }

    private boolean isResponseAllMissing(Variable cVar, NumericVariable rVar, int catNo) {
        StringVariable catvar;
        Object object = catvar = this.discreteCategory ? new StringVariable() : new NumericVariable();
        if (this.discreteCategory) {
            catvar.connectFrom((StringVariable)cVar);
        } else {
            ((NumericVariable)catvar).connectFrom((NumericVariable)cVar);
        }
        NumericVariable respvar = new NumericVariable();
        respvar.connectFrom(rVar);
        VariableProcessor vp = new VariableProcessor();
        vp.addGroupVariable((Variable)catvar);
        vp.addVariable((Variable)respvar, 6);
        int n = respvar.getValueCount();
        if (catNo < n) {
            try {
                respvar.value.getValue(catNo);
            }
            catch (MissingValueException e) {
                return true;
            }
        }
        return false;
    }

    private void buildCHAlignments(IntegerVector chHAlign, IntegerVector chVAlign) {
        int valueCount = this.responseVar.getValueCount();
        chHAlign.setSize(valueCount);
        chVAlign.setSize(valueCount);
        for (int i = 0; i < valueCount; ++i) {
            try {
                double respVal = this.responseVar.value.getValue(i);
                if (this.orientation == 1) {
                    if (respVal >= 0.0) {
                        chHAlign.setValueAt(0, i);
                    } else {
                        chHAlign.setValueAt(2, i);
                    }
                    chVAlign.setValueAt(1, i);
                    continue;
                }
                if (respVal >= 0.0) {
                    chVAlign.setValueAt(3, i);
                } else {
                    chVAlign.setValueAt(0, i);
                }
                chHAlign.setValueAt(1, i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    private Color brighterColor(Color c) {
        if (c == null) {
            return null;
        }
        float[] vals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float hue = vals[0];
        float saturation = vals[1];
        float brightness = vals[2];
        float S_PERCENTAGE = 0.3f;
        float B_PERCENTAGE = 0.5f;
        float newSaturation = saturation - saturation * S_PERCENTAGE;
        float newBrightness = brightness + brightness * B_PERCENTAGE;
        newSaturation = (float)Math.min(1.0, (double)newSaturation);
        newBrightness = (float)Math.min(1.0, (double)newBrightness);
        return Color.getHSBColor(hue, newSaturation, newBrightness);
    }

    private ColorPipe brighterColor(ColorPipe pipe, int count) {
        ColorVector vec = new ColorVector();
        pipe.init(new AInitAction(null));
        for (int i = 0; i < count; ++i) {
            try {
                Color c = pipe.getValue(i);
                vec.addValue(this.brighterColor(c));
                continue;
            }
            catch (MissingValueException e) {
                vec.addValue((Color)null);
            }
        }
        return vec;
    }

    static int getGLFillPattern(int pattern) {
        int type = FillPatternAttrs.getPatternType((int)pattern);
        switch (type) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 0: {
                return -1;
            }
        }
        return -1;
    }

    private ArrayList getSortedGroupCategory(int offset, int numGroups) {
        if (this.groupOrder == 1 || this.groupOrder == 2) {
            return null;
        }
        ArrayList<Integer> category = new ArrayList<Integer>();
        for (int i = offset; i < offset + numGroups; ++i) {
            try {
                category.add(new Integer(((StringVariable)this.groupVar).category.getValue(i)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.groupOrder == 3) {
            ArrayList ll = new ArrayList();
            for (int j = category.size() - 1; j >= 0; --j) {
                ll.add(category.get(j));
            }
            category = ll;
        }
        return category;
    }

    private ArrayList getSortedGroupCategory(int offset, int numGroups, HashMap value2ColumnCategory) {
        if (this.groupOrder != 0) {
            return null;
        }
        ArrayList<Integer> category = new ArrayList<Integer>();
        for (int i = offset; i < offset + numGroups; ++i) {
            try {
                String v = ((StringVariable)this.groupVar).value.getValue(i);
                int gcat = (Integer)value2ColumnCategory.get(v);
                if (gcat < 0) continue;
                category.add(new Integer(gcat));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Collections.sort(category);
        return category;
    }

    private int getGroupCategoryInDataColumn(String gv, String[] gvalues) {
        for (int g = 0; g < gvalues.length; ++g) {
            if (!gvalues[g].equals(gv)) continue;
            return g;
        }
        return -1;
    }

    private void verifySummarizedData() {
        NumericVectorVariable cat;
        if (this.statistic != -1) {
            return;
        }
        FrequencyVariable freq = new FrequencyVariable();
        if (this.discreteCategory) {
            cat = this.connectCategory((short)1, this.missingCategoryOn);
        } else {
            cat = new NumericVectorVariable();
            cat.connectFrom(this.model.getDoubleColumn(1));
        }
        Variable grp = this.connectCategory((short)3, this.missingGroupOn);
        VariableProcessor vp = new VariableProcessor();
        if (this.subset) {
            vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
        }
        vp.addGroupVariable((Variable)cat);
        if (this.groupVar != null) {
            vp.addGroupVariable(grp);
        }
        vp.addVariable((Variable)freq, 2);
        this.addCRDWhereClause(vp);
        if (freq.getMax() > 1.0) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "nonsummarized.txt"));
        }
    }

    @Override
    protected void addTooltip(VariableProcessor vp, String role, Probe currProbe) {
        String roleName = role.toUpperCase();
        if (!this.roleMap.containsKey(roleName)) {
            return;
        }
        ColumnMetadata cmd = this.getRoleMetadata(roleName);
        int col = this.model.getSrcModel().getColumn(cmd.getName());
        if (cmd.getType() == 1) {
            NumericVectorVariable nvv = new NumericVectorVariable();
            nvv.connectFrom(this.model.getSrcModel().getDoubleColumn(col));
            if (vp != null) {
                if (roleName.equals("GROUP") || roleName.equals("X") || roleName.equals("INDEX")) {
                    vp.addVariable((Variable)nvv, 12);
                } else if (roleName.equals("COLORRESPONSE")) {
                    vp.addVariable((Variable)nvv, this.colorStatistic);
                } else {
                    vp.addVariable((Variable)nvv, this.statistic);
                }
            }
            if (cmd.getFormat() != null) {
                nvv.setFormat(new GTKFormat((Format)cmd.getFormat()));
            } else {
                nvv.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            }
            currProbe.addPipe(cmd.getLabel(), (Pipe)nvv.formattedValue);
        } else {
            StringVectorVariable svv = new StringVectorVariable();
            svv.connectFrom(this.model.getSrcModel().getStringColumn(col));
            if (vp != null) {
                vp.addVariable((Variable)svv);
            }
            if (cmd.getFormat() != null) {
                svv.setFormat(new GTKFormat((Format)cmd.getFormat()));
            }
            currProbe.addPipe(cmd.getLabel(), (Pipe)svv.formattedValue);
        }
    }

    protected void connectVars() {
        int i;
        double[] count;
        if (StatGraph.isOLAP()) {
            this.connectOLAPVars();
            return;
        }
        Variable xMissingControlVar = null;
        CRD crd = this.model;
        if (crd.isAvailable(1)) {
            boolean numericCategory;
            boolean bl = numericCategory = crd.getColumnClass(1) == Double.class;
            if (this.discreteCategory) {
                this.categoryVar = this.connectCategory((short)1, this.missingCategoryOn);
                if (numericCategory) {
                    this.numericCategoryVar = new NumericVectorVariable();
                    this.numericCategoryVar.connectFrom(crd.getDoubleColumn(1));
                    SASFormat fmt = ((ColumnMetadata)crd.getColumnLabel(1)).getFormat();
                    if (fmt == null) {
                        fmt = DataModel.defaultFormat;
                    }
                    this.numericCategoryVar.setFormat(new GTKFormat((Format)fmt));
                }
            } else {
                this.categoryVar = new NumericVectorVariable();
                ((NumericVectorVariable)this.categoryVar).connectFrom(crd.getDoubleColumn(1));
                this.categoryVar.setLabel(this.getLabel((short)1));
                if (this.binCategory) {
                    this.calculateBins((short)1);
                    this.categoryVar = this.binIntervalVar((NumericVariable)this.categoryVar);
                }
            }
            if (!this.discreteCategory || !this.missingCategoryOn) {
                xMissingControlVar = this.connectRaw((short)1);
            }
            this.connectionOrder = this.orientation == 0 ? 1 : 2;
            if (this.orientation == 1) {
                crd.getSrcModel().yCategoryVar = crd.getColumnName((short)1);
            } else {
                crd.getSrcModel().xCategoryVar = crd.getColumnName((short)1);
            }
        }
        if (crd.isAvailable(3)) {
            this.numericGroup = crd.getColumnClass(3) == Double.class;
            this.groupVar = this.connectCategory((short)3, this.missingGroupOn);
            this.rawGroupVar = this.connectRaw((short)3);
            this.rawGroupVar.setFormattedValueMissingValueExceptionsEnabled(false);
        } else {
            this.groupVar = null;
        }
        this.indexVar = crd.isAvailable(44) ? this.connectRaw((short)44) : null;
        if (this.gradientColor) {
            if (this.isFillOn()) {
                this.colorVar = this.connectRaw((short)6);
            } else {
                this.lineColorVar = this.connectRaw((short)46);
            }
            if (this.colorVar == null && this.lineColorVar == null) {
                String colName = this.colorStatistic == 2 ? RB.getStringResource("Overlay.", "frequency.txt") : (this.colorStatistic == 13 ? RB.getStringResource("Overlay.", "percent.txt") : RB.getStringResource("Overlay.", "proportion.txt"));
                int n = this.categoryVar.getValueCount();
                count = new double[n];
                for (i = 0; i < n; ++i) {
                    count[i] = 1.0;
                }
                if (this.isFillOn()) {
                    this.colorVar = new NumericVectorVariable();
                    ((NumericVectorVariable)this.colorVar).connectFrom(count);
                    this.colorVar.setLabel(colName);
                } else {
                    this.lineColorVar = new NumericVectorVariable();
                    ((NumericVectorVariable)this.lineColorVar).connectFrom(count);
                    this.lineColorVar.setLabel(colName);
                }
            }
        } else {
            this.colorVar = this.connectCategory((short)6, true);
            if (crd.isAvailable(6)) {
                this.numericColor = false;
            }
            this.lineColorVar = this.connectCategory((short)46, true);
            if (crd.isAvailable(46)) {
                this.numericLineColor = false;
            }
        }
        this.lineVar = crd.isAvailable(36) ? this.connectCategory((short)36, true) : null;
        this.fillPatternVar = crd.isAvailable(111) ? this.connectCategory((short)111, true) : null;
        this.fillPatternColorVar = crd.isAvailable(112) ? this.connectCategory((short)112, true) : null;
        if (crd.isAvailable(5)) {
            this.numericLabel = crd.getColumnClass(5) == Double.class;
            this.labelVar = this.connectRaw((short)5);
            this.showBarValue = false;
        } else {
            this.labelVar = null;
        }
        Variable urlVar = this.connectCategory((short)52, false);
        if (this.isMultiResponse()) {
            this.multiResponseVars = new NumericVariable[this.responseCount];
            this.multiResponseLabels = new String[this.responseCount];
            for (int i2 = 0; i2 < this.responseCount; ++i2) {
                if (!crd.isAvailable(610 + i2)) continue;
                this.multiResponseVars[i2] = (NumericVectorVariable)this.connectRaw((short)(610 + i2));
                this.multiResponseLabels[i2] = this.multiResponseVars[i2].getLabel();
            }
        } else if (crd.isAvailable(2)) {
            if (crd.getColumnClass(2) != Double.class) {
                StatGraph.printDebug("VBar: RESPONSE must be numeric");
            } else {
                this.responseVar = new NumericVectorVariable();
                ((NumericVectorVariable)this.responseVar).connectFrom(crd.getDoubleColumn(2));
                this.responseVar.setLabel(this.getLabel((short)2));
            }
        } else {
            String name = this.statistic == 2 ? RB.getStringResource("Overlay.", "frequency.txt") : (this.statistic == 13 ? RB.getStringResource("Overlay.", "percent.txt") : RB.getStringResource("Overlay.", "proportion.txt"));
            int n = this.categoryVar.getValueCount();
            count = new double[n];
            for (i = 0; i < n; ++i) {
                count[i] = 1.0;
            }
            this.responseVar = new NumericVectorVariable();
            ((NumericVectorVariable)this.responseVar).connectFrom(count);
            this.responseVar.setLabel(name);
        }
        if (crd.isAvailable(28)) {
            this.yUpperErrorVar = new NumericVectorVariable();
            this.yUpperErrorVar.connectFrom(crd.getDoubleColumn(28));
            this.yUpperErrorVar.setLabel(this.getLabel((short)28));
        } else {
            this.yUpperErrorVar = null;
        }
        if (crd.isAvailable(29)) {
            this.yLowerErrorVar = new NumericVectorVariable();
            this.yLowerErrorVar.connectFrom(crd.getDoubleColumn(29));
            this.yLowerErrorVar.setLabel(this.getLabel((short)29));
        } else {
            this.yLowerErrorVar = null;
        }
        if (crd.isAvailable(55)) {
            this.targetVar = new NumericVectorVariable();
            this.targetVar.connectFrom(crd.getDoubleColumn(55));
            this.targetVar.setLabel(this.getLabel((short)55));
        } else {
            this.targetVar = null;
        }
        if (crd.isAvailable(99)) {
            this.categorySortVar = new NumericVectorVariable();
            ((NumericVectorVariable)this.categorySortVar).connectFrom(crd.getDoubleColumn(99));
            this.categorySortVar.setLabel(this.getLabel((short)99));
        } else {
            this.categorySortVar = null;
        }
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        this.subset = false;
        if (xMissingControlVar != null || this.rawGroupVar != null && !this.missingGroupOn) {
            int count2 = xMissingControlVar != null ? xMissingControlVar.getValueCount() : this.rawGroupVar.getValueCount();
            this.subsetObs = new int[count2];
            this.subsetObsCount = 0;
            for (int i3 = 0; i3 < count2; ++i3) {
                if (xMissingControlVar != null && this.rawGroupVar != null && !this.missingGroupOn) {
                    if (xMissingControlVar.isMissing(i3) || this.rawGroupVar.isMissing(i3)) continue;
                    this.subsetObs[this.subsetObsCount++] = i3;
                    continue;
                }
                if (xMissingControlVar != null) {
                    if (xMissingControlVar.isMissing(i3)) continue;
                    this.subsetObs[this.subsetObsCount++] = i3;
                    continue;
                }
                if (this.rawGroupVar == null || this.missingGroupOn || this.rawGroupVar.isMissing(i3)) continue;
                this.subsetObs[this.subsetObsCount++] = i3;
            }
            if (this.subsetObsCount < count2) {
                this.subset = true;
            } else {
                this.subsetObs = null;
            }
        }
        VariableProcessor vp = new VariableProcessor();
        if (this.subset) {
            vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
        }
        this.categoryVar.setUniqueValueSort(0);
        if (this.statistic != -1) {
            vp.addGroupVariable(this.categoryVar);
            if (this.numericCategoryVar != null) {
                vp.addGroupVariable((Variable)this.numericCategoryVar);
            }
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar, 0);
                vp.addGroupVariable(this.rawGroupVar);
                if (this.getGroupOrder() == 1) {
                    this.rawGroupVar.setUniqueValueSort(1);
                } else if (this.getGroupOrder() == 2) {
                    this.rawGroupVar.setUniqueValueSort(2);
                }
                this.rawGroupVar.setSortByFormattedValues(!this.numericGroup);
            }
            if (this.isMultiResponse()) {
                for (int i4 = 0; i4 < this.multiResponseVars.length; ++i4) {
                    vp.addVariable((Variable)this.multiResponseVars[i4], this.statistic);
                }
            }
        } else {
            vp.addVariable(this.categoryVar);
            if (this.numericCategoryVar != null) {
                vp.addVariable((Variable)this.numericCategoryVar);
            }
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar, 0);
                vp.addGroupVariable(this.categoryVar);
                if (this.numericCategoryVar != null) {
                    vp.addGroupVariable((Variable)this.numericCategoryVar);
                }
                vp.addGroupVariable(this.rawGroupVar);
                if (this.getGroupOrder() == 1) {
                    this.rawGroupVar.setUniqueValueSort(1);
                } else if (this.getGroupOrder() == 2) {
                    this.rawGroupVar.setUniqueValueSort(2);
                }
                this.rawGroupVar.setSortByFormattedValues(!this.numericGroup);
            }
            if (this.isMultiResponse()) {
                for (int i5 = 0; i5 < this.multiResponseVars.length; ++i5) {
                    vp.addVariable((Variable)this.multiResponseVars[i5]);
                }
            }
        }
        if (this.gradientColor) {
            if (this.colorVar != null) {
                vp.addVariable(this.colorVar, this.colorStatistic);
            }
            if (this.lineColorVar != null) {
                vp.addVariable(this.lineColorVar, this.colorStatistic);
            }
        }
        if (this.labelVar != null) {
            vp.addVariable(this.labelVar);
        }
        if (urlVar != null) {
            vp.addVariable(urlVar);
        }
        this.addCRDWhereClause(vp);
        this.addCHPipe(RPFUtil.applyConditionalHiliting(this.model.getSrcModel(), vp, this.statistic));
        if (this.isMultiResponse()) {
            this.preProcessVars();
        }
        if (urlVar != null) {
            this.probe.addPipe("_URL_", (Pipe)((StringVariable)urlVar).value);
        }
        if (crd.isAvailable(300)) {
            this.addCustomTips(vp);
        } else {
            if (this.categoryVar != null) {
                if (this.categoryVar instanceof StringVariable) {
                    this.probe.addPipe(this.categoryVar.getLabel(), (Pipe)((StringVariable)this.categoryVar).value);
                } else {
                    this.probe.addPipe(this.categoryVar.getLabel(), (Pipe)((NumericVariable)this.categoryVar).formattedValue);
                }
            }
            if (crd.isAvailable(2)) {
                this.addTooltip(vp, "Y");
                this.addTooltip(vp, "RESPONSE");
            } else if (this.isMultiResponse()) {
                this.probe.addPipe(this.responseVar.getLabel(), (Pipe)this.responseVar.value);
            } else if (this.statistic == 2) {
                this.probe.addPipe(RB.getStringResource("Overlay.", "frequency.txt"), (Pipe)this.responseVar.value);
            } else if (this.statistic == 13) {
                this.probe.addPipe(RB.getStringResource("Overlay.", "percent.txt"), (Pipe)this.responseVar.value);
            } else {
                this.probe.addPipe(RB.getStringResource("Overlay.", "proportion.txt"), (Pipe)this.responseVar.value);
            }
            if (this.groupVar != null) {
                this.probe.addPipe(this.groupVar.getLabel(), (Pipe)((StringVariable)this.groupVar).value);
            }
            if (this.gradientColor) {
                if (this.colorVar != null) {
                    this.probe.addPipe(this.colorVar.getLabel(), (Pipe)((NumericVariable)this.colorVar).value);
                } else if (this.lineColorVar != null) {
                    this.probe.addPipe(this.lineColorVar.getLabel(), (Pipe)((NumericVariable)this.lineColorVar).value);
                }
            }
            if (this.targetVar != null) {
                this.probe.addPipe(this.targetVar.getLabel(), (Pipe)this.targetVar.value);
            }
            if (this.yUpperErrorVar != null) {
                this.yueProbe = new Probe();
                this.addTooltip(vp, "X", this.yueProbe);
                this.addTooltip(vp, "ERRORUPPER", this.yueProbe);
            }
            if (this.yLowerErrorVar != null) {
                this.yleProbe = new Probe();
                this.addTooltip(vp, "X", this.yleProbe);
                this.addTooltip(vp, "ERRORLOWER", this.yleProbe);
            }
        }
        this.verifySummarizedData();
        this.updateLabelVars = true;
    }

    private void preProcessVars() {
        this.categoryVar_sav = this.categoryVar;
        int n = ((StringVariable)this.categoryVar).getValueCount();
        int nResp = this.multiResponseVars.length;
        int rows = n * nResp;
        String[] cat = new String[rows];
        double[] resp = new double[rows];
        String[] grp = new String[rows];
        StringVector probeInfoCat = new StringVector();
        StringVector probeInfoResp = new StringVector();
        for (int i = 0; i < nResp; ++i) {
            String g = this.multiResponseVars[i].getLabel();
            int offset = i * n;
            String cLabel = this.categoryVar_sav.getLabel();
            String rLabel = g;
            for (int j = 0; j < n; ++j) {
                try {
                    cat[offset + j] = ((StringVariable)this.categoryVar).value.getValue(j);
                }
                catch (MissingValueException e) {
                    cat[offset + j] = null;
                }
                try {
                    resp[offset + j] = this.multiResponseVars[i].value.getValue(j);
                }
                catch (MissingValueException e) {
                    resp[offset + j] = Double.NaN;
                }
                grp[offset + j] = g;
                probeInfoCat.addValue(cLabel + " = " + cat[offset + j]);
                probeInfoResp.addValue(rLabel + " = " + Double.toString(resp[offset + j]));
            }
        }
        this.categoryVar = new StringVectorVariable();
        ((StringVectorVariable)this.categoryVar).connectFrom(cat);
        ((StringVectorVariable)this.categoryVar).setBlankMissing(false);
        this.categoryVar.setLabel(this.categoryVar_sav.getLabel());
        ((StringVectorVariable)this.categoryVar).setBlankMissing(false);
        this.responseVar = new NumericVectorVariable();
        ((NumericVectorVariable)this.responseVar).connectFrom(resp);
        String label = this.multiResponseLabels[0];
        for (int i = 1; i < this.multiResponseLabels.length; ++i) {
            label = label + " / " + this.multiResponseLabels[i];
        }
        this.responseVar.setLabel(label);
        this.groupVar = new StringVectorVariable();
        ((StringVectorVariable)this.groupVar).connectFrom(grp);
        this.groupVar.setLabel("Group");
        this.rawGroupVar = new StringVectorVariable();
        ((StringVectorVariable)this.rawGroupVar).connectFrom(grp);
        this.colorVar = this.groupVar;
        this.lineColorVar = this.groupVar;
        this.lineVar = this.groupVar;
        this.fillPatternVar = this.groupVar;
        this.fillPatternColorVar = this.groupVar;
        this.numericColor = false;
        this.numericLineColor = false;
    }

    private void postProcessVars() {
        this.categoryVar = this.categoryVar_sav;
        this.groupVar = null;
        this.rawGroupVar = null;
        this.colorVar = null;
        this.lineColorVar = null;
        this.lineVar = null;
        this.fillPatternVar = null;
        this.fillPatternColorVar = null;
    }

    public void resetVars() {
        this.categoryVar = null;
        this.groupVar = null;
        this.indexVar = null;
        this.rawGroupVar = null;
        this.colorVar = null;
        this.lineColorVar = null;
        this.lineVar = null;
        this.fillPatternVar = null;
        this.fillPatternColorVar = null;
    }

    protected void updateColorRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.xRange;
        if (this.colorVar != null) {
            int num;
            int n = num = this.numericColor ? this.colorVar.getValueCount() : this.colorVar.getUniqueValueCount();
            if (num > 0) {
                if (this.numericColor) {
                    newRange = this.getUnionAllColorRange();
                    this.setFormat((DataRange)newRange, 6);
                } else {
                    Object[] vals = new Object[num];
                    for (int i = 0; i < num; ++i) {
                        try {
                            vals[i] = ((StringVectorVariable)this.colorVar).uniqueValue.getValue(i);
                            continue;
                        }
                        catch (Exception mve) {
                            vals[i] = "";
                        }
                    }
                    newRange = new DiscreteRange(vals);
                }
                newRange.setLabel(this.colorVar.getLabel());
            } else if (this.colorVar != null && this.numericColor) {
                newRange = this.getUnionAllColorRange();
                this.setFormat((DataRange)newRange, 6);
            } else {
                newRange = null;
            }
        }
        this.colorRange = newRange;
        byte dim = 4;
        RangeChangedEvent rce = null;
        if (oldRange == null && newRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, (DataRange)newRange, dim);
        } else if (oldRange != null && newRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != newRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, (DataRange)newRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    protected void updateLineRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.lineRange;
        if (this.lineVar != null) {
            int num = this.lineVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.lineVar, num);
                newRange.setLabel(this.lineVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.lineRange = newRange;
        this.fireRangeEvent((byte)15, oldRange, (DataRange)newRange);
    }

    protected void updateLineColorRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.lineColorRange;
        if (this.lineColorVar != null) {
            int num;
            int n = num = this.numericLineColor ? this.lineColorVar.getValueCount() : this.lineColorVar.getUniqueValueCount();
            if (num > 0) {
                if (this.numericLineColor) {
                    newRange = this.getUnionAllColorRange();
                    this.setFormat((DataRange)newRange, 46);
                } else {
                    newRange = Overlay.makeDiscreteRange((StringVariable)this.lineColorVar, num);
                }
                newRange.setLabel(this.lineColorVar.getLabel());
            } else if (this.lineColorVar != null && this.numericLineColor) {
                newRange = this.getUnionAllColorRange();
                this.setFormat((DataRange)newRange, 46);
            } else {
                newRange = null;
            }
        }
        this.lineColorRange = newRange;
        this.fireRangeEvent((byte)17, oldRange, (DataRange)newRange);
    }

    protected void updateFillPatternRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.fillPatternRange;
        if (this.fillPatternVar != null) {
            int num = this.fillPatternVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.fillPatternVar, num);
                newRange.setLabel(this.fillPatternVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.fillPatternRange = newRange;
        this.fireRangeEvent((byte)21, oldRange, (DataRange)newRange);
    }

    protected void updateFillPatternColorRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.fillPatternColorRange;
        if (this.fillPatternColorVar != null) {
            int num = this.fillPatternColorVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.fillPatternColorVar, num);
                newRange.setLabel(this.fillPatternColorVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.fillPatternColorRange = newRange;
        this.fireRangeEvent((byte)22, oldRange, (DataRange)newRange);
    }

    protected DataRange getIndRange() {
        Object range = null;
        if (!this.discreteCategory && this.categoryVar instanceof NumericVariable) {
            boolean subset;
            boolean bl = this.orientation == 0 ? !this.xUnionAllPages : (subset = !this.yUnionAllPages);
            if (this.binCategory) {
                double min = ((NumericVariable)this.categoryVar).getMin() - this.binWidth / 2.0;
                double max = ((NumericVariable)this.categoryVar).getMax() + this.binWidth / 2.0;
                range = new ContinuousRange(min, max);
            } else {
                range = this.makeContinuousRange((NumericVariable)this.categoryVar, (short)1, subset);
            }
            range.setLabel(this.categoryVar.getLabel());
        } else if (this.categoryVar != null) {
            if (this.getOrder() != 0) {
                return this.getIndRangeByCategorySortVar();
            }
            int num = this.categoryVar.getUniqueValueCount();
            if (num > 0) {
                boolean subset = this.orientation == 0 ? !this.xUnionAllPages : !this.yUnionAllPages;
                range = this.numericCategoryVar == null ? this.makeDiscreteRange((StringVariable)this.categoryVar, num, (short)1, subset) : this.makeOrdinalRange((StringVariable)this.categoryVar, num, (NumericVariable)this.numericCategoryVar, (short)1, subset);
                range.setLabel(this.categoryVar.getLabel());
            } else {
                range = null;
            }
        }
        return range;
    }

    private DataRange getIndRangeByCategorySortVar() {
        StringVariable cat = new StringVariable();
        NumericVariable numCat = new NumericVariable();
        VariableProcessor vp = new VariableProcessor();
        if (this.subset) {
            vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
        }
        this.categoryVar.setUniqueValueSort(0);
        if (this.statistic != -1) {
            vp.addGroupVariable(this.categoryVar);
            if (this.numericCategoryVar != null) {
                vp.addGroupVariable((Variable)this.numericCategoryVar);
            }
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar, 0);
                vp.addGroupVariable(this.rawGroupVar);
            }
            vp.addVariable(this.categorySortVar, this.statistic);
        } else {
            vp.addVariable(this.categoryVar);
            if (this.numericCategoryVar != null) {
                vp.addVariable((Variable)this.numericCategoryVar);
            }
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar, 0);
                vp.addGroupVariable(this.categoryVar);
                if (this.numericCategoryVar != null) {
                    vp.addGroupVariable((Variable)this.numericCategoryVar);
                }
                vp.addGroupVariable(this.rawGroupVar);
            }
            vp.addVariable(this.categorySortVar);
        }
        this.addCRDWhereClause(vp);
        if (this.groupVar == null) {
            vp.setSort(this.categorySortVar, this.getOrder() == 6 ? 1 : 2);
            cat.connectFrom((StringVariable)this.categoryVar);
            if (this.numericCategoryVar != null) {
                numCat.connectFrom((NumericVariable)this.numericCategoryVar);
            }
        } else {
            StringVariable cat2 = new StringVariable();
            cat2.connectFrom((StringVariable)this.categoryVar);
            NumericVariable numCat2 = null;
            if (this.numericCategoryVar != null) {
                numCat2 = new NumericVariable();
                numCat2.connectFrom((NumericVariable)this.numericCategoryVar);
            }
            NumericVariable sort2 = new NumericVariable();
            sort2.connectFrom((NumericVariable)this.categorySortVar);
            VariableProcessor categorySummingProcessor = new VariableProcessor();
            if (this.subset) {
                categorySummingProcessor.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
            }
            categorySummingProcessor.addGroupVariable((Variable)cat2);
            if (this.numericCategoryVar != null) {
                categorySummingProcessor.addGroupVariable((Variable)numCat2);
            }
            categorySummingProcessor.addVariable((Variable)sort2);
            categorySummingProcessor.setSort((Variable)sort2, this.getOrder() == 6 ? 1 : 2);
            cat.connectFrom(cat2);
            if (this.numericCategoryVar != null) {
                numCat.connectFrom(numCat2);
            }
        }
        Object range = null;
        int num = cat.getUniqueValueCount();
        if (num > 0) {
            boolean subset = this.orientation == 0 ? !this.xUnionAllPages : !this.yUnionAllPages;
            range = this.numericCategoryVar == null ? this.makeDiscreteRange(cat, num, (short)1, subset) : this.makeOrdinalRange(cat, num, numCat, (short)1, subset);
            range.setLabel(this.categoryVar.getLabel());
        }
        return range;
    }

    protected DataRange getDepRange() {
        DataRange range = null;
        if (this.responseVar != null) {
            int num = this.responseVar.getValueCount();
            if (num > 0) {
                boolean unionAll;
                boolean bl = unionAll = this.orientation == 0 ? this.yUnionAllPages : this.xUnionAllPages;
                range = unionAll && !this.group100 ? (this.isMultiResponse() ? this.getMultiResponseRange() : this.getUnionAllDepRange()) : this.getSubsettedDepRange();
            } else {
                range = null;
            }
        }
        return range;
    }

    protected DataRange getSubsettedDepRange() {
        double baseLine;
        ContinuousRange range = null;
        double min = baseLine = this.baseline;
        double max = baseLine;
        VariableProcessor vp = new VariableProcessor();
        if (this.subset && !this.isMultiResponse()) {
            vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
        }
        if (this.statistic != -1) {
            vp.addGroupVariable(this.categoryVar);
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar, 0);
                vp.addGroupVariable(this.rawGroupVar);
            }
            if (this.gradientColor) {
                if (this.colorVar != null) {
                    vp.addVariable(this.colorVar, this.statistic);
                }
                if (this.lineColorVar != null) {
                    vp.addVariable(this.lineColorVar, this.statistic);
                }
                if (this.lineVar != null) {
                    vp.addVariable(this.lineVar, this.statistic);
                }
            }
            vp.addVariable((Variable)this.responseVar, this.statistic);
            if (this.yLowerErrorVar != null) {
                vp.addVariable((Variable)this.yLowerErrorVar, this.statistic);
            }
            if (this.yUpperErrorVar != null) {
                vp.addVariable((Variable)this.yUpperErrorVar, this.statistic);
            }
            if (this.targetVar != null) {
                vp.addVariable((Variable)this.targetVar, this.statistic);
            }
        } else {
            vp.addVariable(this.categoryVar);
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar);
                vp.addVariable(this.groupVar, 0);
                vp.addGroupVariable(this.categoryVar);
                vp.addGroupVariable(this.rawGroupVar);
            }
            vp.addVariable((Variable)this.responseVar);
            if (this.yLowerErrorVar != null) {
                vp.addVariable((Variable)this.yLowerErrorVar);
            }
            if (this.yUpperErrorVar != null) {
                vp.addVariable((Variable)this.yUpperErrorVar);
            }
            if (this.targetVar != null) {
                vp.addVariable((Variable)this.targetVar);
            }
        }
        if (!this.isMultiResponse()) {
            this.addCRDWhereClause(vp);
        }
        if (this.groupVar == null) {
            min = this.responseVar.getMin();
            max = this.responseVar.getMax();
            if (this.targetVar != null) {
                min = Math.min(min, this.targetVar.getMin());
                max = Math.max(max, this.targetVar.getMax());
            }
        } else {
            int i;
            BidirectionalAccumulatorByCategory accumEnd = null;
            if (this.group100 || this.getGroupDisplay() == 1) {
                accumEnd = new BidirectionalAccumulatorByCategory();
                if (this.discreteCategory) {
                    accumEnd.category.connectFrom(((StringVariable)this.categoryVar).category);
                } else {
                    accumEnd.category.connectFrom(((NumericVariable)this.categoryVar).category);
                }
                accumEnd.input.connectFrom(this.responseVar.value);
                accumEnd.setPostAccumulate(false);
                this.positiveAccumulation = accumEnd.getAcccumAccumulationInfo().getPositiveTotalsByCategory();
                this.negativeAccumulation = accumEnd.getAcccumAccumulationInfo().getNegativeTotalsByCategory();
                this.percentWeight = new NumericVector();
                int idx = 0;
                for (i = 0; i < this.categoryVar.getUniqueValueCount(); ++i) {
                    for (int j = 0; j < this.groupsPerCategory[i]; ++j) {
                        if (this.positiveGroupOnly) {
                            try {
                                double v = this.responseVar.value.getValue(idx++);
                                if (v <= 0.0 || this.positiveAccumulation[i] == 0.0) {
                                    this.percentWeight.addValue(Double.NaN);
                                    continue;
                                }
                                this.percentWeight.addValue(1.0 / this.positiveAccumulation[i]);
                            }
                            catch (MissingValueException e) {
                                this.percentWeight.addValue(Double.NaN);
                            }
                            continue;
                        }
                        if (this.positiveAccumulation[i] > 0.0 || this.negativeAccumulation[i] < 0.0) {
                            this.percentWeight.addValue(1.0 / (this.positiveAccumulation[i] + Math.abs(this.negativeAccumulation[i])));
                            continue;
                        }
                        this.percentWeight.addValue(Double.NaN);
                    }
                }
            }
            if (this.getGroupDisplay() == 0) {
                if (this.group100) {
                    max = 0.0;
                    min = 0.0;
                    for (int i2 = 0; i2 < this.responseVar.getValueCount(); ++i2) {
                        try {
                            double v = this.responseVar.value.getValue(i2);
                            max = Math.max(max, v * this.percentWeight.getValue(i2));
                            min = Math.min(min, v * this.percentWeight.getValue(i2));
                            continue;
                        }
                        catch (MissingValueException v) {
                            // empty catch block
                        }
                    }
                } else {
                    StatisticByCategory stat = new StatisticByCategory();
                    stat.setStatistic(6);
                    Categorizer cat = new Categorizer();
                    cat.addVariable(this.categoryVar);
                    cat.addVariable(this.groupVar);
                    stat.category.connectFrom(cat.category);
                    stat.input.connectFrom(this.responseVar.value);
                    min = stat.getMin();
                    max = stat.getMax();
                    if (this.targetVar != null) {
                        StatisticByCategory stat1 = new StatisticByCategory();
                        stat1.setStatistic(6);
                        stat1.category.connectFrom(cat.category);
                        stat1.input.connectFrom(this.targetVar.value);
                        min = Math.min(min, stat1.getMin());
                        max = Math.max(max, stat1.getMax());
                    }
                }
                this.positiveAccumulation = null;
                this.negativeAccumulation = null;
            } else {
                double[] minMax = accumEnd.getAccumulation();
                min = minMax[0];
                max = minMax[1];
                if (this.group100) {
                    max = 0.0;
                    min = 0.0;
                    for (i = 0; i < this.positiveAccumulation.length; ++i) {
                        double total;
                        double d = total = this.positiveGroupOnly ? this.positiveAccumulation[i] : this.positiveAccumulation[i] + Math.abs(this.negativeAccumulation[i]);
                        if (!(total > 0.0)) continue;
                        max = Math.max(max, this.positiveAccumulation[i] / total);
                        min = this.positiveGroupOnly ? 0.0 : Math.min(min, this.negativeAccumulation[i] / total);
                    }
                }
            }
        }
        range = this.responseVar.getValueCount() == 0 ? new ContinuousRange(Double.MAX_VALUE, -1.7976931348623157E308) : new ContinuousRange(Math.min(baseLine, min), Math.max(baseLine, max));
        range.setLabel(this.responseVar.getLabel());
        return range;
    }

    protected DataRange getUnionAllDepRange() {
        double baseLine;
        int i;
        double[] count;
        int n;
        boolean Y2;
        ContinuousRange range = null;
        boolean bl = Y2 = !this.getYAxis().equalsIgnoreCase("Y");
        if (!Y2 && !Double.isNaN(this.model.getSrcModel().computedYMin) && !Double.isNaN(this.model.getSrcModel().computedYMax) && this.model.getSrcModel().minMaxComputed) {
            range = new ContinuousRange(this.model.getSrcModel().computedYMin, this.model.getSrcModel().computedYMax);
            range.setLabel(this.responseVar.getLabel());
            return range;
        }
        if (Y2 && !Double.isNaN(this.model.getSrcModel().computedY2Min) && !Double.isNaN(this.model.getSrcModel().computedY2Max) && this.model.getSrcModel().minMaxComputed) {
            range = new ContinuousRange(this.model.getSrcModel().computedY2Min, this.model.getSrcModel().computedY2Max);
            range.setLabel(this.responseVar.getLabel());
            return range;
        }
        StringVariable tempCategoryVar = null;
        NumericVectorVariable tempResponseVar = null;
        NumericVectorVariable tempTargetVar = null;
        StringVariable tempGroupVar = null;
        if (StatGraph.isOLAP()) {
            tempCategoryVar = StatGraph.getOLAPLevelVar(this.model, (short)1);
            if (this.model.isAvailable(2)) {
                tempResponseVar = StatGraph.getOLAPMeasureVar(this.model, (short)2);
            } else {
                n = tempCategoryVar.getValueCount();
                count = new double[n];
                for (i = 0; i < n; ++i) {
                    count[i] = 1.0;
                }
                tempResponseVar = new NumericVectorVariable();
                tempResponseVar.connectFrom(count);
            }
            if (this.groupVar != null) {
                tempGroupVar = StatGraph.getOLAPLevelVar(this.model, (short)3);
            }
        } else {
            if (this.discreteCategory) {
                tempCategoryVar = this.connectCategory((short)1, true);
            } else {
                tempCategoryVar = new NumericVectorVariable();
                ((NumericVectorVariable)tempCategoryVar).connectFrom(this.model.getDoubleColumn(1));
                tempCategoryVar.setLabel(this.getLabel((short)1));
            }
            tempResponseVar = new NumericVectorVariable();
            if (this.model.isAvailable(2)) {
                tempResponseVar.connectFrom(this.model.getDoubleColumn(2));
            } else {
                n = tempCategoryVar.getValueCount();
                count = new double[n];
                for (i = 0; i < n; ++i) {
                    count[i] = 1.0;
                }
                tempResponseVar.connectFrom(count);
            }
            if (this.model.isAvailable(55)) {
                tempTargetVar = new NumericVectorVariable();
                tempTargetVar.connectFrom(this.model.getDoubleColumn(55));
            }
            if (this.groupVar != null) {
                tempGroupVar = this.connectCategory((short)3, true);
            }
        }
        double min = baseLine = this.baseline;
        double max = baseLine;
        if (Y2) {
            if (!Double.isNaN(this.model.getSrcModel().computedY2Min)) {
                min = Math.min(min, this.model.getSrcModel().computedY2Min);
            }
            if (!Double.isNaN(this.model.getSrcModel().computedY2Max)) {
                max = Math.max(max, this.model.getSrcModel().computedY2Max);
            }
        } else {
            if (!Double.isNaN(this.model.getSrcModel().computedYMin)) {
                min = Math.min(min, this.model.getSrcModel().computedYMin);
            }
            if (!Double.isNaN(this.model.getSrcModel().computedYMax)) {
                max = Math.max(max, this.model.getSrcModel().computedYMax);
            }
        }
        for (int i2 = 0; i2 < this.model.allWhereExpressions.length; ++i2) {
            if (this.model.allWhereExpressions[i2] == null) continue;
            VariableProcessor vp = new VariableProcessor();
            if (this.subset) {
                vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
            }
            if (this.statistic != -1) {
                vp.addGroupVariable((Variable)tempCategoryVar);
                if (tempGroupVar != null) {
                    vp.addGroupVariable((Variable)tempGroupVar);
                }
                vp.addVariable((Variable)tempResponseVar, this.statistic);
                if (tempTargetVar != null) {
                    vp.addVariable((Variable)tempTargetVar, this.statistic);
                }
            } else {
                vp.addVariable((Variable)tempCategoryVar);
                if (tempGroupVar != null) {
                    vp.addVariable((Variable)tempGroupVar);
                }
                vp.addVariable((Variable)tempResponseVar);
                if (tempTargetVar != null) {
                    vp.addVariable((Variable)tempTargetVar);
                }
            }
            for (int j = 0; j < this.model.whereVars.length; ++j) {
                StringVectorVariable sv;
                if (this.model.whereVars[j] == null) continue;
                Object object = sv = this.model.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                if (this.model.whereVarsOnSeparateModel) {
                    DataModel dm = this.model.getSrcModel();
                    int wcol = dm.getColumn(this.model.whereVars[j].getName());
                    sv.setName(this.model.whereVars[j].getName());
                    sv.connectFrom(dm.getColumnAsClassColumn(wcol, this.model.whereIncludeMissingClass));
                } else {
                    sv.connectFrom(this.model.whereVars[j]);
                }
                vp.addVariable((Variable)sv);
            }
            String curWhere = vp.getWhereExpression();
            if (curWhere != null) {
                vp.setWhereExpression("(" + curWhere + ") & (" + this.model.allWhereExpressions[i2] + ")");
            } else {
                vp.setWhereExpression(this.model.allWhereExpressions[i2]);
            }
            if (!vp.isWhereExpressionValid()) {
                StatGraph.printDebug("Invalid where cluase: " + vp.getWhereExpression());
            }
            if (tempGroupVar == null) {
                min = Math.min(min, tempResponseVar.getMin());
                max = Math.max(max, tempResponseVar.getMax());
                if (tempTargetVar == null) continue;
                min = Math.min(min, tempTargetVar.getMin());
                max = Math.max(max, tempTargetVar.getMax());
                continue;
            }
            if (this.getGroupDisplay() == 0) {
                StatisticByCategory stat = new StatisticByCategory();
                stat.setStatistic(6);
                Categorizer cat = new Categorizer();
                cat.addVariable((Variable)tempCategoryVar);
                cat.addVariable((Variable)tempGroupVar);
                stat.category.connectFrom(cat.category);
                stat.input.connectFrom(tempResponseVar.value);
                min = Math.min(min, stat.getMin());
                max = Math.max(max, stat.getMax());
                if (tempTargetVar == null) continue;
                StatisticByCategory stat1 = new StatisticByCategory();
                stat1.setStatistic(6);
                stat1.category.connectFrom(cat.category);
                stat1.input.connectFrom(tempTargetVar.value);
                min = Math.min(min, stat1.getMin());
                max = Math.max(max, stat1.getMax());
                continue;
            }
            BidirectionalAccumulatorByCategory accumEnd = new BidirectionalAccumulatorByCategory();
            if (this.discreteCategory) {
                accumEnd.category.connectFrom(tempCategoryVar.category);
            } else {
                accumEnd.category.connectFrom(((NumericVariable)tempCategoryVar).category);
            }
            accumEnd.input.connectFrom(tempResponseVar.value);
            accumEnd.setPostAccumulate(false);
            double[] minMax = accumEnd.getAccumulation();
            min = Math.min(min, minMax[0]);
            max = Math.max(max, minMax[1]);
        }
        if (Y2) {
            this.model.getSrcModel().computedY2Min = min;
            this.model.getSrcModel().computedY2Max = max;
        } else {
            this.model.getSrcModel().computedYMin = min;
            this.model.getSrcModel().computedYMax = max;
        }
        range = new ContinuousRange(min, max);
        range.setLabel(this.responseVar.getLabel());
        return range;
    }

    private DataRange getMultiResponseRange() {
        double baseLine;
        boolean Y2;
        ContinuousRange range = null;
        boolean bl = Y2 = !this.getYAxis().equalsIgnoreCase("Y");
        if (!Y2 && !Double.isNaN(this.model.getSrcModel().computedYMin) && !Double.isNaN(this.model.getSrcModel().computedYMax) && this.model.getSrcModel().minMaxComputed) {
            range = new ContinuousRange(this.model.getSrcModel().computedYMin, this.model.getSrcModel().computedYMax);
            range.setLabel(this.responseVar.getLabel());
            return range;
        }
        if (Y2 && !Double.isNaN(this.model.getSrcModel().computedY2Min) && !Double.isNaN(this.model.getSrcModel().computedY2Max) && this.model.getSrcModel().minMaxComputed) {
            range = new ContinuousRange(this.model.getSrcModel().computedY2Min, this.model.getSrcModel().computedY2Max);
            range.setLabel(this.responseVar.getLabel());
            return range;
        }
        boolean numeric = this.model.getColumnClass(1) == Double.class;
        Variable tempCategoryVar_sav = this.connectCategory((short)1, true);
        NumericVariable[] tempMultiResponseVars = new NumericVariable[this.responseCount];
        for (int i = 0; i < this.responseCount; ++i) {
            tempMultiResponseVars[i] = new NumericVectorVariable();
            if (StatGraph.isOLAP()) {
                tempMultiResponseVars[i] = StatGraph.getOLAPMeasureVar(this.model, (short)(610 + i));
                continue;
            }
            ((NumericVectorVariable)tempMultiResponseVars[i]).connectFrom(this.model.getDoubleColumn(610 + i));
        }
        double min = baseLine = this.baseline;
        double max = baseLine;
        if (Y2) {
            if (!Double.isNaN(this.model.getSrcModel().computedY2Min)) {
                min = Math.min(min, this.model.getSrcModel().computedY2Min);
            }
            if (!Double.isNaN(this.model.getSrcModel().computedY2Max)) {
                max = Math.max(max, this.model.getSrcModel().computedY2Max);
            }
        } else {
            if (!Double.isNaN(this.model.getSrcModel().computedYMin)) {
                min = Math.min(min, this.model.getSrcModel().computedYMin);
            }
            if (!Double.isNaN(this.model.getSrcModel().computedYMax)) {
                max = Math.max(max, this.model.getSrcModel().computedYMax);
            }
        }
        for (int i = 0; i < this.model.allWhereExpressions.length; ++i) {
            int r;
            if (this.model.allWhereExpressions[i] == null) continue;
            VariableProcessor vp = new VariableProcessor();
            if (this.subset) {
                vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
            }
            if (this.statistic != -1) {
                vp.addGroupVariable(tempCategoryVar_sav);
                for (r = 0; r < this.responseCount; ++r) {
                    vp.addVariable((Variable)tempMultiResponseVars[r], this.statistic);
                }
            } else {
                vp.addVariable(tempCategoryVar_sav);
                for (r = 0; r < this.responseCount; ++r) {
                    vp.addVariable((Variable)tempMultiResponseVars[r]);
                }
            }
            for (int j = 0; j < this.model.whereVars.length; ++j) {
                StringVectorVariable sv;
                if (this.model.whereVars[j] == null) continue;
                Object object = sv = this.model.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                if (this.model.whereVarsOnSeparateModel) {
                    DataModel dm = this.model.getSrcModel();
                    int wcol = dm.getColumn(this.model.whereVars[j].getName());
                    sv.setName(this.model.whereVars[j].getName());
                    sv.connectFrom(dm.getColumnAsClassColumn(wcol, this.model.whereIncludeMissingClass));
                } else {
                    sv.connectFrom(this.model.whereVars[j]);
                }
                vp.addVariable((Variable)sv);
            }
            String curWhere = vp.getWhereExpression();
            if (curWhere != null) {
                vp.setWhereExpression("(" + curWhere + ") & (" + this.model.allWhereExpressions[i] + ")");
            } else {
                vp.setWhereExpression(this.model.allWhereExpressions[i]);
            }
            if (!vp.isWhereExpressionValid()) {
                StatGraph.printDebug("Invalid where cluase: " + vp.getWhereExpression());
            }
            int n = ((StringVariable)tempCategoryVar_sav).getValueCount();
            int nResp = this.multiResponseVars.length;
            int rows = n * nResp;
            String[] cats = new String[rows];
            double[] resps = new double[rows];
            String[] grps = new String[rows];
            for (int r2 = 0; r2 < nResp; ++r2) {
                int offset = r2 * n;
                for (int j = 0; j < n; ++j) {
                    try {
                        cats[offset + j] = ((StringVariable)tempCategoryVar_sav).value.getValue(j);
                    }
                    catch (MissingValueException e) {
                        cats[offset + j] = null;
                    }
                    try {
                        resps[offset + j] = tempMultiResponseVars[r2].value.getValue(j);
                    }
                    catch (MissingValueException e) {
                        resps[offset + j] = Double.NaN;
                    }
                    grps[offset + j] = this.multiResponseVars[r2].getLabel();
                }
            }
            StringVectorVariable tempCategoryVar = new StringVectorVariable();
            tempCategoryVar.connectFrom(cats);
            NumericVectorVariable tempResponseVar = new NumericVectorVariable();
            tempResponseVar.connectFrom(resps);
            StringVectorVariable tempGroupVar = new StringVectorVariable();
            tempGroupVar.connectFrom(grps);
            if (this.getGroupDisplay() == 0) {
                StatisticByCategory stat = new StatisticByCategory();
                stat.setStatistic(6);
                Categorizer cat = new Categorizer();
                cat.addVariable((Variable)tempCategoryVar);
                cat.addVariable((Variable)tempGroupVar);
                stat.category.connectFrom(cat.category);
                stat.input.connectFrom(tempResponseVar.value);
                min = Math.min(min, stat.getMin());
                max = Math.max(max, stat.getMax());
                continue;
            }
            BidirectionalAccumulatorByCategory accumEnd = new BidirectionalAccumulatorByCategory();
            accumEnd.category.connectFrom(tempCategoryVar.category);
            accumEnd.input.connectFrom(tempResponseVar.value);
            accumEnd.setPostAccumulate(false);
            double[] minMax = accumEnd.getAccumulation();
            min = Math.min(min, minMax[0]);
            max = Math.max(max, minMax[1]);
        }
        if (Y2) {
            this.model.getSrcModel().computedY2Min = min;
            this.model.getSrcModel().computedY2Max = max;
        } else {
            this.model.getSrcModel().computedYMin = min;
            this.model.getSrcModel().computedYMax = max;
        }
        range = new ContinuousRange(min, max);
        range.setLabel(this.responseVar.getLabel());
        return range;
    }

    private int getExtraSpace() {
        if (this.edgeOn && this.edgeStyle.getWidth() > 1) {
            return (int)Math.ceil((double)this.edgeStyle.getWidth() * 0.5);
        }
        return 0;
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        double offset = 0.0;
        if (this.orientation == 0) {
            if (dimension == 1) {
                ValueMap vm = this.xEncoder.getValueMap();
                if (vm instanceof StringToNumericMap) {
                    int mpc = Math.max(StatGraph.MPC, ((PositionEncoder)this.getEncoder(dimension)).getMPC());
                    int n = Math.max(mpc, ((StringToNumericMap)vm).getUniqueValueCount());
                    if (n == 0) {
                        return 0.0;
                    }
                    if (n > 1) {
                        offset = (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) / (double)n;
                        if (!this.weightedByCategories) {
                            offset += this.discreteOffsetPadding ? (double)(2 * StatGraph.getExtraPadding()) : 0.0;
                        }
                    } else {
                        offset = !this.weightedByCategories ? 0.25 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) / (double)n : 0.0;
                    }
                } else if (!this.discreteCategory) {
                    if (this.binCategory) {
                        offset = 2 * StatGraph.getExtraPadding();
                    } else if (this.intervalBarWidth < 0.0) {
                        double intvl = this.getMinimumInterval((short)1);
                        offset = this.getMaximumIntervalSize(intvl, this.xEncoder, true) + (double)(2 * StatGraph.getExtraPadding());
                    } else {
                        offset = this.intervalBarWidth + (double)(2 * StatGraph.getExtraPadding());
                    }
                }
            } else if (dimension == 2) {
                offset = 0.0;
            }
        } else if (dimension == 1) {
            offset = 0.0;
        } else if (dimension == 2) {
            ValueMap vm = this.yEncoder.getValueMap();
            if (vm instanceof StringToNumericMap) {
                int mpc = Math.max(StatGraph.MPC, ((PositionEncoder)this.getEncoder(dimension)).getMPC());
                int n = Math.max(mpc, ((StringToNumericMap)vm).getUniqueValueCount());
                if (n == 0) {
                    return 0.0;
                }
                if (n > 1) {
                    offset = (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) / (double)n;
                    if (!this.weightedByCategories) {
                        offset += this.discreteOffsetPadding ? (double)(2 * StatGraph.getExtraPadding()) : 0.0;
                    }
                } else {
                    offset = 0.25 * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) / (double)n;
                }
            } else if (!this.discreteCategory) {
                if (this.binCategory) {
                    offset = 2 * StatGraph.getExtraPadding();
                } else if (this.intervalBarWidth < 0.0) {
                    double intvl = this.getMinimumInterval((short)1);
                    offset = this.getMaximumIntervalSize(intvl, this.yEncoder, true) + (double)(2 * StatGraph.getExtraPadding());
                } else {
                    offset = this.intervalBarWidth + (double)(2 * StatGraph.getExtraPadding());
                }
            }
        }
        return this.weightedByCategories ? offset : offset + (double)(this.getExtraSpace() * 2);
    }

    @Override
    public Insets getPreferredInnerMargin() {
        int top;
        int left;
        if (this.getOrientation() == 0 && !(this.yEncoder.getValueMap() instanceof ContinuousRangeToNumericMap) || this.getOrientation() == 1 && !(this.xEncoder.getValueMap() instanceof ContinuousRangeToNumericMap)) {
            return new Insets(0, 0, 0, 0);
        }
        if (this.labelVar != null) {
            return this.getPreferredInnerMarginWithDataLabel();
        }
        int right = left = (int)Math.ceil(this.getPreferredOffset((byte)1) / 2.0);
        int bottom = top = (int)Math.ceil(this.getPreferredOffset((byte)2) / 2.0);
        Insets im = new Insets(top, left, bottom, right);
        if (this.showBarValue) {
            String s2;
            int i;
            SASFormat fmt;
            if (this.statRange == null) {
                this.statRange = (ContinuousRange)this.getSubsettedDepRange();
            }
            if (this.group100) {
                fmt = this.group100Format;
            } else if (this.labelFormat != null) {
                fmt = this.labelFormat;
            } else {
                fmt = this.isMultiResponse() ? this.getFormat(610) : this.getFormat(2);
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                } else if (fmt.getFormatDescription().isDecimalWidthSupported()) {
                    int w = fmt.getFormatDescription().getMaxWidth();
                    int d = fmt.getDecimalWidth();
                    fmt = SASFormat.getInstance((String)(fmt.getBaseFormatName() + Integer.toString(w).trim() + "." + Integer.toString(d).trim()));
                    fmt.setInsertBlanks(false);
                }
            }
            FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
            this.extraPadding = (int)Math.ceil((double)fm.getHeight() * 0.15);
            if (this.getOrientation() == 1) {
                this.extraPadding *= 2;
            }
            int fmHeight = fm.getHeight() + this.extraPadding * 2;
            int maxWidth = 0;
            int minWidth = 0;
            String maxLabel = "";
            String minLabel = "";
            if (this.group100) {
                maxLabel = fmt.format((Object)1.0).trim();
                maxWidth = fm.stringWidth(maxLabel);
                if (!this.positiveGroupOnly) {
                    minLabel = fmt.format((Object)-1.0).trim();
                    minWidth = fm.stringWidth(minLabel);
                }
            } else if (this.positiveAccumulation != null && this.negativeAccumulation != null) {
                int w;
                for (i = 0; i < this.positiveAccumulation.length; ++i) {
                    s2 = fmt.format((Object)new Double(this.positiveAccumulation[i])).trim();
                    w = fm.stringWidth(s2);
                    if (w <= maxWidth) continue;
                    maxWidth = w;
                    maxLabel = s2;
                }
                for (i = 0; i < this.negativeAccumulation.length; ++i) {
                    s2 = fmt.format((Object)new Double(this.negativeAccumulation[i])).trim();
                    w = fm.stringWidth(s2);
                    if (w <= minWidth) continue;
                    minWidth = w;
                    minLabel = s2;
                }
            } else {
                for (i = 0; i < this.responseVar.getValueCount(); ++i) {
                    try {
                        s2 = fmt.format((Object)new Double(this.responseVar.value.getValue(i))).trim();
                        int w = fm.stringWidth(s2);
                        if (this.responseVar.value.getValue(i) >= this.baseline) {
                            if (w <= maxWidth) continue;
                            maxWidth = w;
                            maxLabel = s2;
                            continue;
                        }
                        if (w <= minWidth) continue;
                        minWidth = w;
                        minLabel = s2;
                        continue;
                    }
                    catch (MissingValueException s2) {
                        // empty catch block
                    }
                }
            }
            this.longestLabel = maxWidth >= minWidth ? maxLabel : minLabel;
            int longestWidth = Math.max(maxWidth += this.extraPadding * 2, minWidth += this.extraPadding * 2);
            if (this.getOrientation() == 0) {
                double space;
                this.labelRotated = false;
                this.labelDropped = false;
                if ((this.autoRotateLabel || this.rotateLabelAsNeeded) && this.areLabelsColliding(longestWidth - this.extraPadding * 2, this.xEncoder)) {
                    if (this.autoRotateLabel) {
                        this.labelDropped = this.areLabelsColliding(fmHeight - this.extraPadding * 2, this.xEncoder);
                    }
                    if (this.labelDropped) {
                        return im;
                    }
                    this.labelRotated = true;
                    this.extraPadding *= 2;
                    Insets im2 = this.getInnerMarginWithRotatedLabels(minWidth += this.extraPadding * 2, maxWidth += this.extraPadding * 2, fmHeight += this.extraPadding * 2, im, false);
                    return im2;
                }
                double min = this.statRange.getMin();
                double max = this.statRange.getMax();
                ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
                double ratio = Math.abs((map.getOutputMax() - map.getOutputMin()) / (map.getInputMax() - map.getInputMin()));
                if (this.yEncoder.isReversed()) {
                    if (min >= this.baseline) {
                        space = Math.max((map.getInputMin() - max) * ratio, 0.0);
                        if (space < (double)fmHeight) {
                            bottom = (int)((double)bottom + ((double)fmHeight - space));
                        }
                    } else if (max <= this.baseline) {
                        space = Math.max((min - map.getInputMax()) * ratio, 0.0);
                        if (space < (double)fmHeight) {
                            top = (int)((double)top + ((double)fmHeight - space));
                        }
                    } else {
                        space = Math.max((map.getInputMin() - max) * ratio, 0.0);
                        if (space < (double)fmHeight) {
                            bottom = (int)((double)bottom + ((double)fmHeight - space));
                        }
                        if ((space = Math.max((min - map.getInputMax()) * ratio, 0.0)) < (double)fmHeight) {
                            top = (int)((double)top + ((double)fmHeight - space));
                        }
                    }
                } else if (min >= this.baseline) {
                    space = Math.max((map.getInputMax() - max) * ratio, 0.0);
                    if (space < (double)fmHeight) {
                        top = (int)((double)top + ((double)fmHeight - space));
                    }
                } else if (max <= this.baseline) {
                    space = Math.max((min - map.getInputMin()) * ratio, 0.0);
                    if (space < (double)fmHeight) {
                        bottom = (int)((double)bottom + ((double)fmHeight - space));
                    }
                } else {
                    space = Math.max((map.getInputMax() - max) * ratio, 0.0);
                    if (space < (double)fmHeight) {
                        top = (int)((double)top + ((double)fmHeight - space));
                    }
                    if ((space = Math.max((min - map.getInputMin()) * ratio, 0.0)) < (double)fmHeight) {
                        bottom = (int)((double)bottom + ((double)fmHeight - space));
                    }
                }
                int halfWidth = (int)Math.ceil((double)longestWidth * 0.5) + StatGraph.getExtraPadding();
                double space2 = this.getFirstBarOffset();
                if (space2 < (double)halfWidth) {
                    left = Math.max(left, halfWidth - (int)space2);
                }
                if ((space2 = this.getLastBarOffset()) < (double)halfWidth) {
                    right = Math.max(right, halfWidth - (int)space2);
                }
            } else {
                double space;
                this.labelRotated = false;
                this.labelDropped = false;
                this.labelInside = false;
                if (this.groupVar != null && (this.group100 || this.groupDisplay == 1) || this.showSegmentLabel) {
                    this.labelInsidePreferred = false;
                }
                if (this.labelInsidePreferred && !this.isLabelHeightExceedBarWidth(fmHeight - this.extraPadding * 2, this.yEncoder)) {
                    this.labelInside = true;
                    return this.getPreferredInnerMarginWithLabelInsidePreferred(im, fm, null, this.responseVar, fmt);
                }
                if (this.autoRotateLabel) {
                    this.labelDropped = this.areLabelsColliding(fmHeight - this.extraPadding * 2, this.yEncoder);
                }
                if (this.labelDropped) {
                    return im;
                }
                double min = this.statRange.getMin();
                double max = this.statRange.getMax();
                ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
                double ratio = Math.abs((map.getOutputMax() - map.getOutputMin()) / (map.getInputMax() - map.getInputMin()));
                if (this.xEncoder.isReversed()) {
                    if (min >= this.baseline) {
                        space = Math.max((map.getInputMin() - max) * ratio, 0.0);
                        if (space < (double)longestWidth) {
                            left = (int)((double)left + ((double)longestWidth - space));
                        }
                    } else if (max <= this.baseline) {
                        space = Math.max((min - map.getInputMax()) * ratio, 0.0);
                        if (space < (double)longestWidth) {
                            right = (int)((double)right + ((double)longestWidth - space));
                        }
                    } else {
                        space = Math.max((map.getInputMin() - max) * ratio, 0.0);
                        if (space < (double)maxWidth) {
                            left = (int)((double)left + ((double)maxWidth - space));
                        }
                        if ((space = Math.max((min - map.getInputMax()) * ratio, 0.0)) < (double)minWidth) {
                            right = (int)((double)right + ((double)minWidth - space));
                        }
                    }
                } else if (min >= this.baseline) {
                    space = Math.max((map.getInputMax() - max) * ratio, 0.0);
                    if (space < (double)longestWidth) {
                        right = (int)((double)right + ((double)longestWidth - space));
                    }
                } else if (max <= this.baseline) {
                    space = Math.max((min - map.getInputMin()) * ratio, 0.0);
                    if (space < (double)longestWidth) {
                        left = (int)((double)left + ((double)longestWidth - space));
                    }
                } else {
                    space = Math.max((map.getInputMax() - max) * ratio, 0.0);
                    if (space < (double)maxWidth) {
                        right = (int)((double)right + ((double)maxWidth - space));
                    }
                    if ((space = Math.max((min - map.getInputMin()) * ratio, 0.0)) < (double)minWidth) {
                        left = (int)((double)left + ((double)minWidth - space));
                    }
                }
                int halfHeight = (int)Math.ceil((double)fmHeight * 0.5) + StatGraph.getExtraPadding();
                double space3 = this.getLastBarOffset();
                if (space3 < (double)halfHeight) {
                    top = Math.max(top, halfHeight - (int)space3);
                }
                if ((space3 = this.getFirstBarOffset()) < (double)halfHeight) {
                    bottom = Math.max(bottom, halfHeight - (int)space3);
                }
            }
        }
        return new Insets(top, left, bottom, right);
    }

    private boolean areLabelsColliding(double labelWidth, PositionEncoder encoder) {
        double stride;
        double barSize = stride = this.getStride();
        if (this.groupVar != null && this.getGroupDisplay() == 0) {
            int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
            barSize = this.clusterWidth * stride / (double)maxGroups;
        }
        return barSize <= labelWidth;
    }

    private boolean isLabelHeightExceedBarWidth(double labelHeight, PositionEncoder encoder) {
        double stride;
        double barSize = stride = this.getStride();
        if (this.groupVar != null && this.getGroupDisplay() == 0) {
            int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
            barSize = this.clusterWidth * stride / (double)maxGroups;
        }
        return barSize * this.barWidth < labelHeight;
    }

    private Insets getInnerMarginWithRotatedLabels(int minWidth, int maxWidth, int fmHeight, Insets initialIM, boolean compact) {
        int top = initialIM.top;
        int left = initialIM.left;
        int bottom = initialIM.bottom;
        int right = initialIM.right;
        ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
        if (compact && this.labVar != null) {
            FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
            double bottommost = this.yEncoder.getOutputMin();
            double topmost = this.yEncoder.getOutputMax();
            double startOffset = 0.0;
            double endOffset = 0.0;
            for (int i = 0; i < this.labVar.getValueCount(); ++i) {
                try {
                    String s = this.numericLabel ? ((NumericVariable)this.labVar).formattedValue.getValue(i).trim() : ((StringVariable)this.labVar).formattedValue.getValue(i).trim();
                    double w = fm.stringWidth(s) + this.extraPadding * 2;
                    double yv = this.respVar.value.getValue(i);
                    double y = map.getValue(yv);
                    if (y < bottommost - ZERO_VALUE || y > topmost + ZERO_VALUE) continue;
                    if (this.yEncoder.isReversed()) {
                        if (yv >= this.baseline) {
                            startOffset = Math.max(startOffset, bottommost - (y - w));
                            continue;
                        }
                        endOffset = Math.max(endOffset, y + w - topmost);
                        continue;
                    }
                    if (yv >= this.baseline) {
                        endOffset = Math.max(endOffset, y + w - topmost);
                        continue;
                    }
                    startOffset = Math.max(startOffset, bottommost - (y - w));
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            bottom += (int)Math.ceil(startOffset);
            top += (int)Math.ceil(endOffset);
        } else {
            double ratio = Math.abs((map.getOutputMax() - map.getOutputMin()) / (map.getInputMax() - map.getInputMin()));
            if (this.statRange == null) {
                this.statRange = (ContinuousRange)this.getSubsettedDepRange();
            }
            double min = this.statRange.getMin();
            double max = this.statRange.getMax();
            int longestWidth = Math.max(minWidth, maxWidth);
            if (this.yEncoder.isReversed()) {
                if (min >= this.baseline) {
                    double space = Math.max((map.getInputMin() - max) * ratio, 0.0);
                    if (space < (double)longestWidth) {
                        bottom = (int)((double)bottom + ((double)longestWidth - space));
                    }
                } else if (max <= this.baseline) {
                    double space = Math.max((min - map.getInputMax()) * ratio, 0.0);
                    if (space < (double)longestWidth) {
                        top = (int)((double)top + ((double)longestWidth - space));
                    }
                } else {
                    double space = Math.max((map.getInputMin() - max) * ratio, 0.0);
                    if (space < (double)maxWidth) {
                        bottom = (int)((double)bottom + ((double)maxWidth - space));
                    }
                    if ((space = Math.max((min - map.getInputMax()) * ratio, 0.0)) < (double)minWidth) {
                        top = (int)((double)top + ((double)minWidth - space));
                    }
                }
            } else if (min >= this.baseline) {
                double space = Math.max((map.getInputMax() - max) * ratio, 0.0);
                if (space < (double)longestWidth) {
                    top = (int)((double)top + ((double)longestWidth - space));
                }
            } else if (max <= this.baseline) {
                double space = Math.max((min - map.getInputMin()) * ratio, 0.0);
                if (space < (double)longestWidth) {
                    bottom = (int)((double)bottom + ((double)longestWidth - space));
                }
            } else {
                double space = Math.max((map.getInputMax() - max) * ratio, 0.0);
                if (space < (double)maxWidth) {
                    top = (int)((double)top + ((double)maxWidth - space));
                }
                if ((space = Math.max((min - map.getInputMin()) * ratio, 0.0)) < (double)minWidth) {
                    bottom = (int)((double)bottom + ((double)minWidth - space));
                }
            }
        }
        int halfHeight = (int)Math.ceil((double)fmHeight * 0.5) + StatGraph.getExtraPadding();
        double space = this.getLastBarOffset();
        if (space < (double)halfHeight) {
            right = Math.max(right, halfHeight - (int)space);
        }
        if ((space = this.getFirstBarOffset()) < (double)halfHeight) {
            left = Math.max(left, halfHeight - (int)space);
        }
        return new Insets(top, left, bottom, right);
    }

    private Insets getInnerMarginWithSplittedLabels(Insets initialIM, boolean compact) {
        int top = initialIM.top;
        int left = initialIM.left;
        int bottom = initialIM.bottom;
        int right = initialIM.right;
        this.splitDataLabelPipe = new StringVector();
        double splitWidth = this.getStride();
        if (this.groupVar != null) {
            int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
            splitWidth = splitWidth * this.clusterWidth / (double)maxGroups;
        }
        boolean splitAlways = this.dataLabelFitPolicy == DATALABEL_FIT_SPLITALWAYS;
        FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
        ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
        double bottommost = this.yEncoder.getOutputMin();
        double topmost = this.yEncoder.getOutputMax();
        double startOffset = 0.0;
        double endOffset = 0.0;
        double[] labelW = new double[this.labVar.getValueCount()];
        double longestWidth = 0.0;
        for (int i = 0; i < this.labVar.getValueCount(); ++i) {
            double h;
            try {
                String[] labs;
                String s = this.numericLabel ? ((NumericVariable)this.labVar).formattedValue.getValue(i).trim() : ((StringVariable)this.labVar).formattedValue.getValue(i).trim();
                double w = fm.stringWidth(s);
                h = fm.getHeight();
                if (!(s.length() < 2 || !splitAlways && !(w > splitWidth) || (labs = BarOverlay.splitLabel(s, splitAlways, splitWidth, this.dataLabelSplitCharDrop, this.dataLabelSplitChar, fm)).length < 2 && labs[0].equals(s))) {
                    s = labs[0];
                    w = fm.stringWidth(s);
                    for (int j = 1; j < labs.length; ++j) {
                        w = Math.max(w, (double)fm.stringWidth(labs[j]));
                        s = s + '\n';
                        s = s + labs[j];
                    }
                    h *= (double)labs.length;
                }
                this.splitDataLabelPipe.addValue(s);
                labelW[i] = w;
                h += (double)(this.extraPadding * 2);
                longestWidth = Math.max(longestWidth, w);
            }
            catch (MissingValueException e) {
                this.splitDataLabelPipe.addValue("");
                labelW[i] = 0.0;
                h = 0.0;
            }
            try {
                double yv = this.respVar.value.getValue(i);
                double y = map.getValue(yv);
                if (y < bottommost - ZERO_VALUE || y > topmost + ZERO_VALUE) continue;
                if (this.yEncoder.isReversed()) {
                    if (yv >= this.baseline) {
                        startOffset = Math.max(startOffset, bottommost - (y - h));
                        continue;
                    }
                    endOffset = Math.max(endOffset, y + h - topmost);
                    continue;
                }
                if (yv >= this.baseline) {
                    endOffset = Math.max(endOffset, y + h - topmost);
                    continue;
                }
                startOffset = Math.max(startOffset, bottommost - (y - h));
                continue;
            }
            catch (MissingValueException yv) {
                // empty catch block
            }
        }
        bottom += (int)Math.ceil(startOffset);
        top += (int)Math.ceil(endOffset);
        if (compact) {
            ValueMap xmap = this.xEncoder.getValueMap();
            xmap.init(new AInitAction(null));
            double leftmost = this.xEncoder.getOutputMin();
            double rightmost = this.xEncoder.getOutputMax();
            startOffset = 0.0;
            endOffset = 0.0;
            this.catVar.init();
            for (int i = 0; i < this.labVar.getValueCount(); ++i) {
                try {
                    double x;
                    this.respVar.value.getValue(i);
                    double w2 = Math.ceil(labelW[i] * 0.5);
                    w2 += (double)this.extraPadding;
                    if (this.discreteCategory) {
                        String xv = ((StringVariable)this.catVar).value.getValue(i);
                        x = ((StringToNumericMap)xmap).getValue((Object)xv);
                    } else {
                        double xv = ((NumericVariable)this.catVar).value.getValue(i);
                        x = ((ContinuousRangeToNumericMap)xmap).getValue(xv);
                    }
                    if (this.groupVar != null) {
                        int catNo = this.discreteCategory ? ((StringVariable)this.catVar).category.getValue(i) : ((NumericVariable)this.catVar).category.getValue(i);
                        int nGroup = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                        int groupNo = this.getGroupNo(catNo, i);
                        double stride = this.getStride();
                        double barSize = this.clusterWidth * stride / (double)nGroup;
                        x -= (double)((int)(((double)this.groupsPerCategory[catNo] / 2.0 - 0.5) * barSize));
                        x += barSize * (double)groupNo;
                    }
                    startOffset = Math.max(startOffset, leftmost - (x - w2));
                    endOffset = Math.max(endOffset, x + w2 - rightmost);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            left = Math.max(left, (int)Math.ceil(startOffset) + StatGraph.getExtraPadding());
            right = Math.max(right, (int)Math.ceil(endOffset) + StatGraph.getExtraPadding());
        } else {
            int halfWidth = (int)Math.ceil((longestWidth += (double)(this.extraPadding * 2)) * 0.5) + StatGraph.getExtraPadding();
            double space = this.getFirstBarOffset();
            if (space < (double)halfWidth) {
                left = Math.max(left, halfWidth - (int)space);
            }
            if ((space = this.getLastBarOffset()) < (double)halfWidth) {
                right = Math.max(right, halfWidth - (int)space);
            }
        }
        return new Insets(top, left, bottom, right);
    }

    private void createLabelVariables() {
        if (this.groupVar != null && this.statRange == null) {
            this.statRange = (ContinuousRange)this.getSubsettedDepRange();
        }
        VariableProcessor vp = new VariableProcessor();
        if (this.subset) {
            vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
        }
        if (this.statistic != -1) {
            vp.addGroupVariable(this.categoryVar);
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar, 0);
                vp.addGroupVariable(this.rawGroupVar);
                if (this.getGroupOrder() == 1) {
                    this.rawGroupVar.setUniqueValueSort(1);
                } else if (this.getGroupOrder() == 2) {
                    this.rawGroupVar.setUniqueValueSort(2);
                }
            }
            vp.addVariable((Variable)this.responseVar, this.statistic);
            vp.addVariable(this.labelVar, 0);
        } else {
            vp.addVariable(this.categoryVar);
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar, 0);
                vp.addGroupVariable(this.categoryVar);
                vp.addGroupVariable(this.rawGroupVar);
                if (this.getGroupOrder() == 1) {
                    this.rawGroupVar.setUniqueValueSort(1);
                } else if (this.getGroupOrder() == 2) {
                    this.rawGroupVar.setUniqueValueSort(2);
                }
            }
            vp.addVariable((Variable)this.responseVar);
            vp.addVariable(this.labelVar);
        }
        this.addCRDWhereClause(vp);
        if (this.groupVar == null || this.getGroupDisplay() == 0) {
            if (this.numericLabel) {
                this.labVar = new NumericVariable();
                ((NumericVariable)this.labVar).connectFrom((NumericVariable)this.labelVar);
            } else {
                this.labVar = new StringVariable();
                ((StringVariable)this.labVar).connectFrom((StringVariable)this.labelVar);
            }
            if (this.discreteCategory) {
                this.catVar = new StringVectorVariable();
                ((StringVectorVariable)this.catVar).connectFrom(((StringVariable)this.categoryVar).value);
                ((StringVectorVariable)this.catVar).setBlankMissing(false);
            } else {
                this.catVar = new NumericVectorVariable();
                ((NumericVectorVariable)this.catVar).connectFrom(((NumericVariable)this.categoryVar).value);
            }
            if (this.group100) {
                int n = this.responseVar.getValueCount();
                double[] rv = new double[n];
                for (int i = 0; i < n; ++i) {
                    try {
                        rv[i] = this.responseVar.value.getValue(i) * this.percentWeight.getValue(i);
                        continue;
                    }
                    catch (MissingValueException e) {
                        rv[i] = Double.NaN;
                    }
                }
                this.respVar = new NumericVectorVariable();
                ((NumericVectorVariable)this.respVar).connectFrom(rv);
            } else {
                this.respVar = new NumericVariable();
                this.respVar.connectFrom(this.responseVar);
            }
        } else {
            int n = this.categoryVar.getUniqueValueCount();
            StringVector cVals = this.discreteCategory ? new StringVector() : new NumericVector();
            double[] rVals = new double[n];
            String[] lVals = null;
            double[] lVals_num = null;
            if (this.numericLabel) {
                lVals_num = new double[n];
            } else {
                lVals = new String[n];
            }
            for (int i = 0; i < n; ++i) {
                int obs = this.discreteCategory ? ((StringVariable)this.categoryVar).getFirstOccurringValueIndex(i) : ((NumericVariable)this.categoryVar).getFirstOccurringValueIndex(i);
                try {
                    if (this.discreteCategory) {
                        cVals.addValue(((StringVariable)this.categoryVar).uniqueValue.getValue(i));
                    } else {
                        ((NumericVector)cVals).addValue(((NumericVariable)this.categoryVar).uniqueValue.getValue(i));
                    }
                    if (this.numericLabel) {
                        lVals_num[i] = ((NumericVariable)this.labelVar).value.getValue(obs);
                    } else {
                        lVals[i] = ((StringVariable)this.labelVar).value.getValue(obs);
                    }
                }
                catch (MissingValueException e) {
                    if (this.numericLabel) {
                        lVals_num[i] = Double.NaN;
                    }
                    lVals[i] = "";
                }
                if (this.positiveAccumulation[i] > 0.0) {
                    rVals[i] = this.positiveAccumulation[i];
                    continue;
                }
                if (this.negativeAccumulation[i] < 0.0) {
                    rVals[i] = this.negativeAccumulation[i];
                    continue;
                }
                if (this.positiveAccumulation[i] != 0.0 || this.negativeAccumulation[i] != 0.0) continue;
                rVals[i] = this.positiveAccumulation[i];
            }
            if (this.numericLabel) {
                this.labVar = new NumericVectorVariable();
                ((NumericVectorVariable)this.labVar).connectFrom(lVals_num);
            } else {
                this.labVar = new StringVectorVariable();
                ((StringVectorVariable)this.labVar).connectFrom(lVals);
            }
            if (this.discreteCategory) {
                this.catVar = new StringVectorVariable();
                ((StringVectorVariable)this.catVar).connectFrom((StringPipe)cVals);
                ((StringVectorVariable)this.catVar).setBlankMissing(false);
            } else {
                this.catVar = new NumericVectorVariable();
                ((NumericVectorVariable)this.catVar).connectFrom((NumericPipe)((NumericVector)cVals));
            }
            this.respVar = new NumericVectorVariable();
            ((NumericVectorVariable)this.respVar).connectFrom(rVals);
        }
        this.labVar.setFormat(this.labelVar.getFormat());
        this.catVar.setFormat(this.categoryVar.getFormat());
        this.respVar.setFormat(this.responseVar.getFormat());
        this.updateLabelVars = false;
    }

    private Insets getPreferredInnerMarginWithDataLabel() {
        int top;
        int left;
        int right = left = (int)Math.ceil(this.getPreferredOffset((byte)1) / 2.0);
        int bottom = top = (int)Math.ceil(this.getPreferredOffset((byte)2) / 2.0);
        Insets im = new Insets(top, left, bottom, right);
        if (this.updateLabelVars) {
            this.createLabelVariables();
        }
        FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
        this.extraPadding = (int)Math.ceil((double)fm.getHeight() * 0.15);
        if (this.getOrientation() == 1) {
            this.extraPadding *= 2;
        }
        int fmHeight = fm.getHeight() + this.extraPadding * 2;
        int maxWidth = 0;
        int minWidth = 0;
        for (int i = 0; i < this.labVar.getValueCount(); ++i) {
            try {
                String s = this.numericLabel ? ((NumericVariable)this.labVar).formattedValue.getValue(i).trim() : ((StringVariable)this.labVar).formattedValue.getValue(i).trim();
                int w = fm.stringWidth(s);
                double d = this.respVar.value.getValue(i);
                if (d >= this.baseline) {
                    if (w <= maxWidth) continue;
                    maxWidth = w;
                    continue;
                }
                if (w <= minWidth) continue;
                minWidth = w;
                continue;
            }
            catch (MissingValueException s) {
                // empty catch block
            }
        }
        int longestWidth = Math.max(maxWidth += this.extraPadding * 2, minWidth += this.extraPadding * 2);
        double min = this.respVar.getMin();
        double max = this.respVar.getMax();
        if (this.getOrientation() == 0) {
            double space;
            this.labelRotated = false;
            this.labelDropped = false;
            this.dataLabelSplit = false;
            if (this.dataLabelFitPolicy == DATALABEL_FIT_AUTO && this.areLabelsColliding(longestWidth - this.extraPadding * 2, this.xEncoder)) {
                if (this.numericLabel) {
                    this.labelRotated = true;
                } else {
                    this.dataLabelSplit = true;
                }
            } else if (this.dataLabelFitPolicy == DATALABEL_FIT_ROTATE && this.areLabelsColliding(longestWidth - this.extraPadding * 2, this.xEncoder)) {
                this.labelRotated = true;
            } else if (this.dataLabelFitPolicy == DATALABEL_FIT_SPLIT || this.dataLabelFitPolicy == DATALABEL_FIT_SPLITALWAYS) {
                this.dataLabelSplit = true;
            }
            if (this.labelRotated) {
                boolean bl = this.labelDropped = this.dataLabelFitPolicy == DATALABEL_FIT_AUTO && this.areLabelsColliding(fmHeight - this.extraPadding * 2, this.xEncoder);
                if (this.labelDropped) {
                    return im;
                }
                maxWidth += this.extraPadding * 2;
                minWidth += this.extraPadding * 2;
                fmHeight += this.extraPadding * 2;
                this.extraPadding *= 2;
                if (this.initialFitting) {
                    Insets im1 = this.getInnerMarginWithRotatedLabels(minWidth, maxWidth, fmHeight, im, false);
                    Insets im2 = this.getInnerMarginWithRotatedLabels(minWidth, maxWidth, fmHeight, im, true);
                    double wt1 = 0.3;
                    double wt2 = 0.7;
                    return new Insets((int)((double)im1.top * wt1 + (double)im2.top * wt2), (int)((double)im1.left * wt1 + (double)im2.left * wt2), (int)((double)im1.bottom * wt1 + (double)im2.bottom * wt2), (int)((double)im1.right * wt1 + (double)im2.right * wt2));
                }
                Insets im2 = this.getInnerMarginWithRotatedLabels(minWidth, maxWidth, fmHeight, im, true);
                return im2;
            }
            if (this.dataLabelSplit) {
                return this.getInnerMarginWithSplittedLabels(im, !this.initialFitting);
            }
            ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
            double ratio = Math.abs((map.getOutputMax() - map.getOutputMin()) / (map.getInputMax() - map.getInputMin()));
            if (this.yEncoder.isReversed()) {
                if (min >= this.baseline) {
                    space = Math.max((map.getInputMin() - max) * ratio, 0.0);
                    if (space < (double)fmHeight) {
                        bottom = (int)((double)bottom + ((double)fmHeight - space));
                    }
                } else if (max <= this.baseline) {
                    space = Math.max((min - map.getInputMax()) * ratio, 0.0);
                    if (space < (double)fmHeight) {
                        top = (int)((double)top + ((double)fmHeight - space));
                    }
                } else {
                    space = Math.max((map.getInputMin() - max) * ratio, 0.0);
                    if (space < (double)fmHeight) {
                        bottom = (int)((double)bottom + ((double)fmHeight - space));
                    }
                    if ((space = Math.max((min - map.getInputMax()) * ratio, 0.0)) < (double)fmHeight) {
                        top = (int)((double)top + ((double)fmHeight - space));
                    }
                }
            } else if (min >= this.baseline) {
                space = Math.max((map.getInputMax() - max) * ratio, 0.0);
                if (space < (double)fmHeight) {
                    top = (int)((double)top + ((double)fmHeight - space));
                }
            } else if (max <= this.baseline) {
                space = Math.max((min - map.getInputMin()) * ratio, 0.0);
                if (space < (double)fmHeight) {
                    bottom = (int)((double)bottom + ((double)fmHeight - space));
                }
            } else {
                space = Math.max((map.getInputMax() - max) * ratio, 0.0);
                if (space < (double)fmHeight) {
                    top = (int)((double)top + ((double)fmHeight - space));
                }
                if ((space = Math.max((min - map.getInputMin()) * ratio, 0.0)) < (double)fmHeight) {
                    bottom = (int)((double)bottom + ((double)fmHeight - space));
                }
            }
            if (this.compact && !this.initialFitting) {
                ValueMap xmap = this.xEncoder.getValueMap();
                xmap.init(new AInitAction(null));
                double leftmost = this.xEncoder.getOutputMin();
                double rightmost = this.xEncoder.getOutputMax();
                double startOffset = 0.0;
                double endOffset = 0.0;
                this.catVar.init();
                for (int i = 0; i < this.labVar.getValueCount(); ++i) {
                    try {
                        double x;
                        this.respVar.value.getValue(i);
                        String s = this.numericLabel ? ((NumericVariable)this.labVar).formattedValue.getValue(i).trim() : ((StringVariable)this.labVar).formattedValue.getValue(i).trim();
                        double w2 = Math.ceil((double)fm.stringWidth(s) * 0.5);
                        w2 += (double)this.extraPadding;
                        if (this.discreteCategory) {
                            String xv = ((StringVariable)this.catVar).value.getValue(i);
                            x = ((StringToNumericMap)xmap).getValue((Object)xv);
                        } else {
                            double xv = ((NumericVariable)this.catVar).value.getValue(i);
                            x = ((ContinuousRangeToNumericMap)xmap).getValue(xv);
                        }
                        if (this.groupVar != null && this.getGroupDisplay() == 0) {
                            int catNo = this.discreteCategory ? ((StringVariable)this.catVar).category.getValue(i) : ((NumericVariable)this.catVar).category.getValue(i);
                            int nGroup = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                            int groupNo = this.getGroupNo(catNo, i);
                            double stride = this.getStride();
                            double barSize = this.clusterWidth * stride / (double)nGroup;
                            x -= (double)((int)(((double)this.groupsPerCategory[catNo] / 2.0 - 0.5) * barSize));
                            x += barSize * (double)groupNo;
                        }
                        startOffset = Math.max(startOffset, leftmost - (x - w2));
                        endOffset = Math.max(endOffset, x + w2 - rightmost);
                        continue;
                    }
                    catch (MissingValueException s) {
                        // empty catch block
                    }
                }
                left = Math.max(left, (int)Math.ceil(startOffset) + StatGraph.getExtraPadding());
                right = Math.max(right, (int)Math.ceil(endOffset) + StatGraph.getExtraPadding());
            } else {
                int halfWidth = (int)Math.ceil((double)longestWidth * 0.5) + StatGraph.getExtraPadding();
                double space2 = this.getFirstBarOffset();
                if (space2 < (double)halfWidth) {
                    left = Math.max(left, halfWidth - (int)space2);
                }
                if ((space2 = this.getLastBarOffset()) < (double)halfWidth) {
                    right = Math.max(right, halfWidth - (int)space2);
                }
            }
        } else {
            this.labelRotated = false;
            this.labelDropped = false;
            this.dataLabelSplit = false;
            this.labelInside = false;
            if (!this.showSegmentLabel && this.dataLabelFitPolicy == DATALABEL_FIT_INSIDEPREFERRED && !this.isLabelHeightExceedBarWidth(fmHeight - this.extraPadding * 2, this.yEncoder)) {
                this.labelInside = true;
                return this.getPreferredInnerMarginWithLabelInsidePreferred(im, fm, this.labVar, this.respVar, null);
            }
            if (this.dataLabelFitPolicy == DATALABEL_FIT_AUTO || this.dataLabelFitPolicy == DATALABEL_FIT_INSIDEPREFERRED) {
                this.labelDropped = this.areLabelsColliding(fmHeight - this.extraPadding * 2, this.yEncoder);
            }
            if (this.labelDropped) {
                return im;
            }
            ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
            if (this.compact && !this.initialFitting) {
                double leftmost = this.xEncoder.getOutputMin();
                double rightmost = this.xEncoder.getOutputMax();
                double startOffset = 0.0;
                double endOffset = 0.0;
                for (int i = 0; i < this.labVar.getValueCount(); ++i) {
                    try {
                        String s = this.numericLabel ? ((NumericVariable)this.labVar).formattedValue.getValue(i).trim() : ((StringVariable)this.labVar).formattedValue.getValue(i).trim();
                        double w = fm.stringWidth(s) + this.extraPadding * 2;
                        double xv = this.respVar.value.getValue(i);
                        double x = map.getValue(xv);
                        if (x < leftmost - ZERO_VALUE || x > rightmost + ZERO_VALUE) continue;
                        if (this.xEncoder.isReversed()) {
                            if (xv >= this.baseline) {
                                startOffset = Math.max(startOffset, leftmost - (x - w));
                                continue;
                            }
                            endOffset = Math.max(endOffset, x + w - rightmost);
                            continue;
                        }
                        if (xv >= this.baseline) {
                            endOffset = Math.max(endOffset, x + w - rightmost);
                            continue;
                        }
                        startOffset = Math.max(startOffset, leftmost - (x - w));
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                left += (int)Math.ceil(startOffset);
                right += (int)Math.ceil(endOffset);
            } else {
                double ratio = Math.abs((map.getOutputMax() - map.getOutputMin()) / (map.getInputMax() - map.getInputMin()));
                if (this.xEncoder.isReversed()) {
                    if (min >= this.baseline) {
                        double space = Math.max((map.getInputMin() - max) * ratio, 0.0);
                        if (space < (double)longestWidth) {
                            left = (int)((double)left + ((double)longestWidth - space));
                        }
                    } else if (max <= this.baseline) {
                        double space = Math.max((min - map.getInputMax()) * ratio, 0.0);
                        if (space < (double)longestWidth) {
                            right = (int)((double)right + ((double)longestWidth - space));
                        }
                    } else {
                        double space = Math.max((map.getInputMin() - max) * ratio, 0.0);
                        if (space < (double)maxWidth) {
                            left = (int)((double)left + ((double)maxWidth - space));
                        }
                        if ((space = Math.max((min - map.getInputMax()) * ratio, 0.0)) < (double)minWidth) {
                            right = (int)((double)right + ((double)minWidth - space));
                        }
                    }
                } else if (min >= this.baseline) {
                    double space = Math.max((map.getInputMax() - max) * ratio, 0.0);
                    if (space < (double)longestWidth) {
                        right = (int)((double)right + ((double)longestWidth - space));
                    }
                } else if (max <= this.baseline) {
                    double space = Math.max((min - map.getInputMin()) * ratio, 0.0);
                    if (space < (double)longestWidth) {
                        left = (int)((double)left + ((double)longestWidth - space));
                    }
                } else {
                    double space = Math.max((map.getInputMax() - max) * ratio, 0.0);
                    if (space < (double)maxWidth) {
                        right = (int)((double)right + ((double)maxWidth - space));
                    }
                    if ((space = Math.max((min - map.getInputMin()) * ratio, 0.0)) < (double)minWidth) {
                        left = (int)((double)left + ((double)minWidth - space));
                    }
                }
            }
            int halfHeight = (int)Math.ceil((double)fmHeight * 0.5) + StatGraph.getExtraPadding();
            double space = this.getLastBarOffset();
            if (space < (double)halfHeight) {
                top = Math.max(top, halfHeight - (int)space);
            }
            if ((space = this.getFirstBarOffset()) < (double)halfHeight) {
                bottom = Math.max(bottom, halfHeight - (int)space);
            }
        }
        return new Insets(top, left, bottom, right);
    }

    private Insets getPreferredInnerMarginWithLabelInsidePreferred(Insets initialIM, FontMetrics fm, Variable labVar, NumericVariable respVar, SASFormat fmt) {
        ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
        double leftmost = this.xEncoder.getOutputMin();
        double rightmost = this.xEncoder.getOutputMax();
        double startOffset = 0.0;
        double endOffset = 0.0;
        int n = respVar.getValueCount();
        if (this.labelInsideBar == null) {
            this.labelInsideBar = new boolean[n];
        }
        int left = initialIM.left;
        int right = initialIM.right;
        for (int i = 0; i < n; ++i) {
            try {
                String s = labVar != null ? (this.numericLabel ? ((NumericVariable)labVar).formattedValue.getValue(i).trim() : ((StringVariable)labVar).formattedValue.getValue(i).trim()) : fmt.format((Object)new Double(respVar.value.getValue(i))).trim();
                double w = fm.stringWidth(s) + (this.getExtraSpace() + this.extraPadding) * 2;
                double mappedBaseline = map.getValue(this.baseline);
                double xv = respVar.value.getValue(i);
                double x = map.getValue(xv);
                if (x < leftmost - ZERO_VALUE || x > rightmost + ZERO_VALUE) continue;
                if (this.xEncoder.isReversed()) {
                    if (xv <= this.baseline) {
                        if (x - mappedBaseline > w) {
                            this.labelInsideBar[i] = true;
                            continue;
                        }
                        this.labelInsideBar[i] = false;
                        endOffset = Math.max(endOffset, x + w - rightmost);
                        continue;
                    }
                    if (mappedBaseline - x > w) {
                        this.labelInsideBar[i] = true;
                        continue;
                    }
                    this.labelInsideBar[i] = false;
                    startOffset = Math.max(startOffset, leftmost - (x - w));
                    continue;
                }
                if (xv >= this.baseline) {
                    if (x - mappedBaseline > w) {
                        this.labelInsideBar[i] = true;
                        continue;
                    }
                    this.labelInsideBar[i] = false;
                    endOffset = Math.max(endOffset, x + w - rightmost);
                    continue;
                }
                if (mappedBaseline - x > w) {
                    this.labelInsideBar[i] = true;
                    continue;
                }
                this.labelInsideBar[i] = false;
                startOffset = Math.max(startOffset, leftmost - (x - w));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return new Insets(initialIM.top, left += (int)Math.ceil(startOffset), initialIM.bottom, right += (int)Math.ceil(endOffset));
    }

    private int getGroupNo(int catNo, int idx) {
        int offset = 0;
        for (int i = 0; i < catNo; ++i) {
            offset += this.groupsPerCategory[i];
        }
        return idx - offset;
    }

    private double getFirstBarOffset() {
        int i;
        Vector barValues;
        PositionEncoder encoder;
        if (!this.discreteCategory) {
            PositionEncoder ve = this.orientation == 0 ? this.xEncoder : this.yEncoder;
            ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)ve.getValueMap();
            double outMin = map.getValue(((NumericVariable)this.categoryVar).getMin());
            if (this.groupVar != null && this.getGroupDisplay() == 0) {
                int nGroup = this.overlayID == null ? 1 : (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                double stride = this.getStride();
                double barSize = this.clusterWidth * stride / (double)nGroup;
                return outMin - (double)((int)(((double)nGroup / 2.0 - 0.5) * barSize)) - map.getOutputMin();
            }
            return outMin - map.getOutputMin();
        }
        if (this.getOrientation() == 0) {
            if (this.xRange == null) {
                return 0.0;
            }
            encoder = this.xEncoder;
            if (this.compact) {
                barValues = new Vector();
                for (i = 0; i < this.categoryVar.getUniqueValueCount(); ++i) {
                    try {
                        barValues.addElement(((StringVariable)this.categoryVar).uniqueValue.getValue(i));
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
            } else {
                barValues = ((DiscreteRange)this.xRange).getValues();
            }
        } else {
            if (this.yRange == null) {
                return 0.0;
            }
            encoder = this.yEncoder;
            if (this.compact) {
                barValues = new Vector();
                for (i = 0; i < this.categoryVar.getUniqueValueCount(); ++i) {
                    try {
                        barValues.addElement(((StringVariable)this.categoryVar).uniqueValue.getValue(i));
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
            } else {
                barValues = ((DiscreteRange)this.yRange).getValues();
            }
        }
        for (i = 0; i < barValues.size(); ++i) {
            String v = (String)barValues.get(i);
            barValues.set(i, StringToNumericMap.trimTrailing((String)v));
        }
        StringToNumericMap map = (StringToNumericMap)encoder.getValueMap();
        int n = map.getUniqueValueCount();
        for (int i2 = 0; i2 < map.getUniqueValueCount(); ++i2) {
            try {
                String v = map.label.getValue(i2);
                double d = map.uniqueValue.getValue(i2);
                if (!barValues.contains(v)) continue;
                if (this.groupVar != null && this.getGroupDisplay() == 0) {
                    int nGroup = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                    double stride = this.getStride();
                    double barSize = this.clusterWidth * stride / (double)nGroup;
                    return d - (double)((int)(((double)nGroup / 2.0 - 0.5) * barSize)) - map.getOutputMin();
                }
                return d - map.getOutputMin();
            }
            catch (MissingValueException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    private double getLastBarOffset() {
        int i;
        Vector barValues;
        PositionEncoder encoder;
        if (!this.discreteCategory) {
            PositionEncoder ve = this.orientation == 0 ? this.xEncoder : this.yEncoder;
            ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)ve.getValueMap();
            double outMax = map.getValue(((NumericVariable)this.categoryVar).getMax());
            if (this.groupVar != null && this.getGroupDisplay() == 0) {
                int nGroup = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                double stride = this.getStride();
                double barSize = this.clusterWidth * stride / (double)nGroup;
                return map.getOutputMax() - (outMax + (double)((int)(((double)nGroup / 2.0 - 0.5) * barSize)));
            }
            return map.getOutputMax() - outMax;
        }
        if (this.getOrientation() == 0) {
            if (this.xRange == null) {
                return 0.0;
            }
            encoder = this.xEncoder;
            if (this.compact) {
                barValues = new Vector();
                for (i = 0; i < this.categoryVar.getUniqueValueCount(); ++i) {
                    try {
                        barValues.addElement(((StringVariable)this.categoryVar).uniqueValue.getValue(i));
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
            } else {
                barValues = ((DiscreteRange)this.xRange).getValues();
            }
        } else {
            if (this.yRange == null) {
                return 0.0;
            }
            encoder = this.yEncoder;
            if (this.compact) {
                barValues = new Vector();
                for (i = 0; i < this.categoryVar.getUniqueValueCount(); ++i) {
                    try {
                        barValues.addElement(((StringVariable)this.categoryVar).uniqueValue.getValue(i));
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
            } else {
                barValues = ((DiscreteRange)this.yRange).getValues();
            }
        }
        for (i = 0; i < barValues.size(); ++i) {
            String v = (String)barValues.get(i);
            barValues.set(i, StringToNumericMap.trimTrailing((String)v));
        }
        StringToNumericMap map = (StringToNumericMap)encoder.getValueMap();
        int n = map.getUniqueValueCount();
        for (int i2 = map.getUniqueValueCount() - 1; i2 >= 0; --i2) {
            try {
                String v = map.label.getValue(i2);
                double d = map.uniqueValue.getValue(i2);
                if (!barValues.contains(v)) continue;
                if (this.groupVar != null && this.getGroupDisplay() == 0) {
                    int nGroup = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                    double stride = this.getStride();
                    double barSize = this.clusterWidth * stride / (double)nGroup;
                    return map.getOutputMax() - (d + (double)((int)(((double)nGroup / 2.0 - 0.5) * barSize)));
                }
                return map.getOutputMax() - d;
            }
            catch (MissingValueException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    @Override
    public int[] getLinePatterns() {
        if (!this.isEdgeOn()) {
            return new int[]{1};
        }
        if (!(this.lineVar == null || this.lineEncoder == null || this.useEdgePattern || this.fillOn || this.fillPatternOn)) {
            LineAttrs[] ll = this.lineEncoder.styleArray;
            HashMap ht = this.lineEncoder.styleList;
            String[] values = this.getUniqueValues((short)36);
            int[] pattern = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                pattern[i] = -1;
                String gval = values[i];
                if (this.hasAttrVar("GROUP")) {
                    DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                    pattern[i] = groupAttrMapper.getLinePattern(gval);
                }
                if (pattern[i] != -1) continue;
                if (this.indexVar == null) {
                    pattern[i] = ((LineAttrs)ht.get(gval)).getLinePattern();
                    continue;
                }
                int obs = this.groupOrder == 3 ? ((StringVariable)this.lineVar).getFirstOccurringValueIndex(values.length - 1 - i) : ((StringVariable)this.lineVar).getFirstOccurringValueIndex(i);
                try {
                    int idx = (int)((NumericVariable)this.indexVar).value.getValue(obs) - 1;
                    pattern[i] = ll[idx % ll.length].getLinePattern();
                    continue;
                }
                catch (MissingValueException e) {
                    pattern[i] = this.edgeStyle.getLinePattern();
                }
            }
            return pattern;
        }
        return new int[]{this.getEdgeStyle().getLinePattern()};
    }

    @Override
    public int[] getLineWidths() {
        if (this.useLineThickness || !this.hasAttrVar("GROUP")) {
            return new int[]{this.isEdgeOn() ? this.getEdgeStyle().getWidth() : 1};
        }
        return this.getDAttrLineThickness("GROUP", this.getGroupValues(), this.getEdgeStyle().getWidth());
    }

    @Override
    public Color[] getLineColors() {
        return this.isEdgeOn() ? this.getGroupColors("line") : new Color[]{};
    }

    @Override
    public Color[] getFillColors() {
        return this.isFillOn() ? this.getGroupColors("fill") : new Color[]{};
    }

    @Override
    public int[] getFillPatterns() {
        int[] pat;
        if (!this.isFillPatternOn() || this.isExtrudedOverlay()) {
            return new int[0];
        }
        if (this.fillPatternVar != null && this.fillPatternEncoder != null) {
            if (this.indexVar != null) {
                return this.getIndexedFillPatterns();
            }
            HashMap ht = this.fillPatternEncoder.patternList;
            String[] values = this.getUniqueValues((short)111);
            pat = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                pat[i] = (Integer)ht.get(values[i]);
            }
        } else {
            pat = new int[]{this.fillPatternStyle.getPattern()};
        }
        return pat;
    }

    @Override
    public Color[] getFillPatternColors() {
        if (!this.isFillPatternOn()) {
            return new Color[]{null};
        }
        if (this.fillPatternStyle.getColor() == null) {
            Color[] c = this.getGroupColors("fillPattern");
            return c;
        }
        return new Color[]{this.applyDataTransparency((ColorAttr)this.fillPatternStyle)};
    }

    private int[] getIndexedFillPatterns() {
        int[] pl = this.fillPatternEncoder.patternArray;
        StringVectorVariable patterns = (StringVectorVariable)this.connectCategory((short)111, this.missingGroupOn);
        NumericVectorVariable indices = (NumericVectorVariable)this.connectRaw((short)44);
        VariableProcessor vp = new VariableProcessor();
        vp.addVariable((Variable)patterns);
        vp.addVariable((Variable)indices);
        if (this.groupVar != null) {
            vp.addVariable(this.rawGroupVar);
            if (this.getGroupOrder() == 1) {
                vp.setSort(this.rawGroupVar, 1);
            } else if (this.getGroupOrder() == 2) {
                vp.setSort(this.rawGroupVar, 2);
            }
            if (!this.missingGroupOn) {
                vp.setWhereExpression("^(" + this.rawGroupVar.getName() + " IS MISSING)");
            }
        }
        int[] pat = new int[patterns.getUniqueValueCount()];
        for (int i = 0; i < patterns.getUniqueValueCount(); ++i) {
            try {
                int obs = this.groupOrder == 3 ? patterns.getFirstOccurringValueIndex(pat.length - 1 - i) : patterns.getFirstOccurringValueIndex(i);
                int idx = (int)indices.value.getValue(obs) - 1;
                pat[i] = pl[idx % pl.length];
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return pat;
    }

    @Override
    public void updateNetworkElements() {
    }

    @Override
    public Insets getInitialInnerMargin() {
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        boolean showBaseline = false;
        if (this.getOrientation() == 0) {
            if (!(this.yEncoder.getValueMap() instanceof ContinuousRangeToNumericMap)) {
                return new Insets(0, 0, 0, 0);
            }
            double min = ((ContinuousRangeToNumericMap)this.yEncoder.getValueMap()).getInputMin();
            double max = ((ContinuousRangeToNumericMap)this.yEncoder.getValueMap()).getInputMax();
            if (min < this.baseline && max > this.baseline || min > this.baseline && max < this.baseline) {
                top = 5;
                bottom = 5;
                showBaseline = true;
            } else if (this.yEncoder.isReversed() && max >= this.baseline || !this.yEncoder.isReversed() && max <= this.baseline) {
                top = 0;
                bottom = 5;
            } else if (this.yEncoder.isReversed() && min <= this.baseline || !this.yEncoder.isReversed() && min >= this.baseline) {
                top = 5;
                bottom = 0;
            }
            left = 0;
            right = !this.weightedByCategories ? 5 : 0;
        } else {
            if (!(this.xEncoder.getValueMap() instanceof ContinuousRangeToNumericMap)) {
                return new Insets(0, 0, 0, 0);
            }
            double min = ((ContinuousRangeToNumericMap)this.xEncoder.getValueMap()).getInputMin();
            double max = ((ContinuousRangeToNumericMap)this.xEncoder.getValueMap()).getInputMax();
            if (min < this.baseline && max > this.baseline || min > this.baseline && max < this.baseline) {
                right = 5;
                left = 5;
                showBaseline = true;
            } else if (this.xEncoder.isReversed() && max >= this.baseline || !this.xEncoder.isReversed() && max <= this.baseline) {
                right = 0;
                left = 5;
            } else if (this.xEncoder.isReversed() && min <= this.baseline || !this.xEncoder.isReversed() && min >= this.baseline) {
                right = 5;
                left = 0;
            }
            top = !this.weightedByCategories ? 5 : 0;
            bottom = 0;
        }
        if (this.autoBaseline) {
            this.baselineOn = showBaseline;
        }
        return new Insets(top, left, bottom, right);
    }

    @Override
    public String getLegendLabel() {
        if (this.legendLabel != null) {
            return this.legendLabel;
        }
        if (StatGraph.isOLAP()) {
            String label = null;
            if (this.responseVar != null) {
                label = this.responseVar.getLabel();
                if (label == null) {
                    label = this.responseVar.getColumnName();
                }
            } else {
                label = this.categoryVar.getLabel();
                if (label == null) {
                    label = this.categoryVar.getColumnName();
                }
            }
            return label;
        }
        ColumnMetadata cmd = null;
        cmd = this.model.isAvailable(2) ? (ColumnMetadata)this.model.getColumnLabel(2) : (ColumnMetadata)this.model.getColumnLabel(1);
        if (cmd.getLabel() != null) {
            return cmd.getLabel();
        }
        return cmd.getName();
    }

    public double getDiscreteOffset() {
        return this.discreteOffset;
    }

    public void setDiscreteOffset(double discreteOffset) {
        this.discreteOffset = discreteOffset;
    }

    @Override
    public boolean hasLegend(int attrType) {
        switch (attrType) {
            case 0: {
                return this.groupVar != null || !this.isGradientColor();
            }
            case 7: 
            case 8: 
            case 11: {
                return this.fillOn;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return this.edgeOn;
            }
        }
        return false;
    }

    @Override
    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        if (!this.fillOn) {
            return 10;
        }
        return this.edgeOn ? 11 : 7;
    }

    @Override
    protected void applyDataSkin(LegendItem[] items) {
        if (!this.fillOn || this.skinType == 0) {
            return;
        }
        Image legendSkin = this.loadLegendSkinImage();
        Image[] legendPixelBender = this.loadLegendPixelBenderImages();
        for (int i = 0; i < items.length; ++i) {
            items[i].setPixelBenderImages(legendPixelBender);
            items[i].setSkinType(this.skinType);
            items[i].setSkinImage(legendSkin);
        }
    }

    @Override
    protected void applyFillTransparency(LegendItem[] items) {
        if (!this.fillOn || !this.useFillTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(items[i].getSymbolAttrs().getColor(), this.fillStyle.getTransparency()));
            items[i].setSymbolAttrs((ColorAttr)fa);
        }
    }

    @Override
    protected void applyLineTransparency(LegendItem[] items) {
        if (!this.edgeOn || this.fillOn || !this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            LineAttrs old = (LineAttrs)items[i].getSymbolAttrs();
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(old.getColor()));
            la.setLinePattern(old.getLinePattern());
            la.setWidth(old.getWidth());
            items[i].setSymbolAttrs((ColorAttr)la);
        }
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.isLegendEntryFromAttrMap("GROUP")) {
            return this.getLegendItemsWithAttrMap(this.fixDefaultAttrType(attrType));
        }
        String[] values = this.getGroupValues();
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            values = new String[]{this.getLegendLabel()};
        }
        Color[] fcolor = this.getFillColors();
        int[] fpattern = this.getFillPatterns();
        if (fcolor.length == 0 && fpattern.length == 0) {
            Color[] lcolor = this.getLineColors();
            int[] pattern = this.getLinePatterns();
            int[] width = this.getLineWidths();
            int n = values.length;
            LegendItem[] entries = new LegendItem[n];
            for (int i = 0; i < n; ++i) {
                LineAttrs attr = new LineAttrs();
                if (lcolor.length > 0) {
                    attr.setColor(lcolor[i % lcolor.length]);
                }
                if (pattern.length > 0) {
                    attr.setLinePattern(pattern[i % pattern.length]);
                }
                if (width.length > 0) {
                    attr.setWidth(width[i % width.length]);
                }
                entries[i] = new LegendItem((ColorAttr)attr, null, values[i], null);
            }
            return entries;
        }
        if (this.skinType != 0 && this.skinImage == null) {
            this.loadSkinImage();
        }
        Image legendSkin = this.loadLegendSkinImage();
        Image[] legendPixelBender = this.loadLegendPixelBenderImages();
        Color[] lcolor = this.getLineColors();
        int[] pattern = this.getLinePatterns();
        int[] width = this.getLineWidths();
        Color[] fpColor = this.getFillPatternColors();
        int n = values.length;
        LegendItem[] entries = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            FillAttrs attr = new FillAttrs();
            if (fcolor.length > 0) {
                attr.setColor(fcolor[i % fcolor.length]);
            } else {
                attr.setColor(null);
            }
            LineAttrs attr2 = null;
            if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                attr2 = new LineAttrs();
                attr2.setColor(lcolor[i % lcolor.length]);
                attr2.setLinePattern(pattern[i % pattern.length]);
                attr2.setWidth(width[i % width.length]);
            }
            entries[i] = this.skinType != 1 && this.skinType != 2 ? new LegendItem((ColorAttr)attr, (ColorAttr)attr2, values[i], null, legendSkin, this.skinType, legendPixelBender) : new LegendItem((ColorAttr)attr, (ColorAttr)attr2, values[i], null, this.skinImage);
            if (fpattern.length <= 0) continue;
            FillPatternAttrs attr3 = new FillPatternAttrs();
            attr3.setPattern(fpattern[i % fpattern.length]);
            attr3.setColor(fpColor[i % fpColor.length]);
            entries[i].setFillPatternAttrs(attr3);
        }
        return entries;
    }

    @Override
    public LegendItem[] getLegendItemsWithAttrMap(DiscreteAttrMapper attrMapper, int attrType) {
        if (attrMapper == null || attrMapper.getAttrMap().getAllSize() <= 0) {
            return null;
        }
        String[] values = this.getGroupValues();
        String[] attrMapValues = attrMapper.getAttrMap().getAllValues();
        int[] attrMapValueIndices = BarOverlay.getAttrMapValueIndexInGroup(attrMapValues, values);
        Color[] fcolor = this.getFillColors();
        if (this.fillOn && this.colorVar != null && this.colorEncoder != null) {
            fcolor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, fcolor, 12, this.fillStyle.getColor(), this.fillStyle.getTransparency(), this.useFillTransparency);
        }
        int[] fpattern = this.getFillPatterns();
        if (this.fillPatternOn && this.fillPatternVar != null && this.fillPatternEncoder != null) {
            fpattern = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, fpattern, 5, this.fillPatternStyle.getPattern());
        }
        Color[] lcolor = this.getLineColors();
        if (this.edgeOn && this.lineColorVar != null && this.lineColorEncoder != null && !this.useEdgeColor) {
            lcolor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, lcolor, 11, this.edgeStyle.getColor(), this.dataTransparency, this.useDataTransparency);
        }
        int[] pattern = this.getLinePatterns();
        if (this.edgeOn && this.lineVar != null && this.lineEncoder != null && !this.useEdgePattern && !this.fillOn && !this.fillPatternOn) {
            pattern = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, pattern, 3, this.edgeStyle.getLinePattern());
        }
        int[] width = this.getLineWidths();
        if (!this.useLineThickness) {
            width = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, width, 4, this.edgeStyle.getWidth());
        }
        if (fcolor.length == 0 && fpattern.length == 0) {
            int n = attrMapValues.length;
            LegendItem[] entries = new LegendItem[n];
            for (int i = 0; i < n; ++i) {
                LineAttrs attr = new LineAttrs();
                if (lcolor.length > 0) {
                    attr.setColor(lcolor[i % lcolor.length]);
                }
                if (pattern.length > 0) {
                    attr.setLinePattern(pattern[i % pattern.length]);
                }
                if (width.length > 0) {
                    attr.setWidth(width[i % width.length]);
                }
                entries[i] = new LegendItem((ColorAttr)attr, null, attrMapValues[i], null);
            }
            return entries;
        }
        if (this.skinType != 0 && this.skinImage == null) {
            this.loadSkinImage();
        }
        Image legendSkin = this.loadLegendSkinImage();
        Image[] legendPixelBender = this.loadLegendPixelBenderImages();
        Color[] fpColor = this.getFillPatternColors();
        if (this.fillPatternOn && this.fillPatternColorVar != null && this.fillPatternColorEncoder != null) {
            fpColor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, fpColor, 14, this.fillPatternStyle.getColor(), this.dataTransparency, this.useDataTransparency);
        }
        int n = attrMapValues.length;
        LegendItem[] entries = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            FillAttrs attr = new FillAttrs();
            if (fcolor.length > 0) {
                attr.setColor(fcolor[i % fcolor.length]);
            } else {
                attr.setColor(null);
            }
            LineAttrs attr2 = null;
            if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                attr2 = new LineAttrs();
                attr2.setColor(lcolor[i % lcolor.length]);
                attr2.setLinePattern(pattern[i % pattern.length]);
                attr2.setWidth(width[i % width.length]);
            }
            entries[i] = this.skinType != 1 && this.skinType != 2 ? new LegendItem((ColorAttr)attr, (ColorAttr)attr2, attrMapValues[i], null, legendSkin, this.skinType, legendPixelBender) : new LegendItem((ColorAttr)attr, (ColorAttr)attr2, attrMapValues[i], null, this.skinImage);
            if (fpattern.length <= 0) continue;
            FillPatternAttrs attr3 = new FillPatternAttrs();
            attr3.setPattern(fpattern[i % fpattern.length]);
            attr3.setColor(fpColor[i % fpColor.length]);
            entries[i].setFillPatternAttrs(attr3);
        }
        return entries;
    }

    @Override
    protected Image loadLegendSkinImage() {
        if (!this.isFillOn() || this.isExtrudedOverlay() || this.dataTransparency == 1.0) {
            return null;
        }
        return this.getLegendSkinImage(this.networkRoot, this.skinType);
    }

    @Override
    protected Image[] loadLegendPixelBenderImages() {
        if (!this.isFillOn() || this.isExtrudedOverlay() || this.dataTransparency == 1.0) {
            return null;
        }
        return this.loadLegendPixelBenderImages(this.networkRoot, this.skinType, 1);
    }

    public void resetSkinImage() {
        this.skinImage = null;
    }

    public boolean isWeightedByCategories() {
        return this.weightedByCategories;
    }

    public void setWeightedByCategories(boolean weightedByCategories) {
        this.weightedByCategories = weightedByCategories;
    }

    @Override
    public String getDefaultLegendTitle() {
        String title = null;
        if (this.model.isAvailable(3)) {
            if (StatGraph.isOLAP()) {
                OLAPLevelVariable olv = (OLAPLevelVariable)this.groupVar;
                OLAPVariableFactory fac = olv.getFactory();
                List list = fac.getLevelNamesForHeirarchy(olv.getHierachyName());
                String levelName = (String)list.get(0);
                title = fac.getLabel(levelName).trim();
            } else {
                ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(3);
                title = cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
            }
        }
        return title;
    }

    protected void connectOLAPVars() {
        CRD crd = this.model;
        if (crd.isAvailable(1)) {
            this.categoryVar = StatGraph.getOLAPLevelVar(crd, (short)1);
            if (this.orientation == 1) {
                crd.getSrcModel().yCategoryVar = this.categoryVar.getColumnName();
            } else {
                crd.getSrcModel().xCategoryVar = this.categoryVar.getColumnName();
            }
        }
        if (crd.isAvailable(3)) {
            this.rawGroupVar = this.groupVar = StatGraph.getOLAPLevelVar(crd, (short)3);
        } else {
            this.groupVar = null;
            this.rawGroupVar = null;
        }
        if (this.isMultiResponse()) {
            this.multiResponseVars = new NumericVariable[this.responseCount];
            this.multiResponseLabels = new String[this.responseCount];
            for (int i = 0; i < this.responseCount; ++i) {
                if (!crd.isAvailable(610 + i)) continue;
                this.multiResponseVars[i] = StatGraph.getOLAPMeasureVar(crd, (short)(610 + i));
                this.multiResponseLabels[i] = this.multiResponseVars[i].getLabel();
            }
        } else if (crd.isAvailable(2)) {
            this.responseVar = StatGraph.getOLAPMeasureVar(crd, (short)2);
        }
        if (crd.isAvailable(6)) {
            this.colorVar = StatGraph.getOLAPLevelVar(crd, (short)6);
            this.numericColor = false;
        } else {
            this.colorVar = null;
        }
        if (crd.isAvailable(46)) {
            this.lineColorVar = StatGraph.getOLAPLevelVar(crd, (short)46);
            this.numericLineColor = false;
        } else {
            this.lineColorVar = null;
        }
        this.lineVar = crd.isAvailable(36) ? StatGraph.getOLAPLevelVar(crd, (short)36) : null;
        this.fillPatternVar = crd.isAvailable(111) ? StatGraph.getOLAPLevelVar(crd, (short)111) : null;
        this.fillPatternColorVar = crd.isAvailable(112) ? StatGraph.getOLAPLevelVar(crd, (short)112) : null;
        VariableProcessor vp = new VariableProcessor();
        if (this.subset) {
            vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
        }
        this.categoryVar.setUniqueValueSort(0);
        if (this.statistic != -1) {
            vp.addGroupVariable(this.categoryVar);
            if (this.numericCategoryVar != null) {
                vp.addGroupVariable((Variable)this.numericCategoryVar);
            }
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar, 0);
                vp.addGroupVariable(this.rawGroupVar);
                if (this.getGroupOrder() == 1) {
                    this.rawGroupVar.setUniqueValueSort(1);
                } else if (this.getGroupOrder() == 2) {
                    this.rawGroupVar.setUniqueValueSort(2);
                }
                this.rawGroupVar.setSortByFormattedValues(!this.numericGroup);
            }
            if (this.isMultiResponse()) {
                for (int i = 0; i < this.multiResponseVars.length; ++i) {
                    vp.addVariable((Variable)this.multiResponseVars[i], this.statistic);
                }
            }
        } else {
            vp.addVariable(this.categoryVar);
            if (this.numericCategoryVar != null) {
                vp.addVariable((Variable)this.numericCategoryVar);
            }
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar, 0);
                vp.addGroupVariable(this.categoryVar);
                if (this.numericCategoryVar != null) {
                    vp.addGroupVariable((Variable)this.numericCategoryVar);
                }
                vp.addGroupVariable(this.rawGroupVar);
                if (this.getGroupOrder() == 1) {
                    this.rawGroupVar.setUniqueValueSort(1);
                } else if (this.getGroupOrder() == 2) {
                    this.rawGroupVar.setUniqueValueSort(2);
                }
                this.rawGroupVar.setSortByFormattedValues(!this.numericGroup);
            }
            if (this.isMultiResponse()) {
                for (int i = 0; i < this.multiResponseVars.length; ++i) {
                    vp.addVariable((Variable)this.multiResponseVars[i]);
                }
            }
        }
        this.addCRDWhereClause(vp);
        this.addCHPipe(RPFUtil.applyConditionalHiliting(this.model.getSrcModel(), vp, this.statistic));
        if (this.isMultiResponse()) {
            this.preProcessVars();
        }
        this.verifySummarizedData();
        this.updateLabelVars = true;
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return !this.isMultiResponse() && !this.model.isAvailable(3);
    }

    @Override
    public String[] getLabels(byte dim) {
        if (dim == 2 && this.isMultiResponse() && this.orientation == 0) {
            return this.multiResponseLabels;
        }
        return super.getLabels(dim);
    }

    public boolean isGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(boolean gradientColor) {
        this.gradientColor = gradientColor;
    }

    @Override
    public Range[] getColorModelRanges(int type) {
        double max;
        double min;
        RangeAttrMapper mapper;
        String error;
        if (type == 1 || !this.gradientColor) {
            return null;
        }
        ContinuousRange range = this.getUnionAllColorRange();
        if (this.hasAttrVar("COLORRESPONSE") && (error = (mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE")).createColorMapper(min = range.getMin(), max = range.getMax(), !this.isFillOn())) == null) {
            double tr = this.isFillOn() && this.fillStyle.getTransparency() >= 0.0 ? this.fillStyle.getTransparency() : this.dataTransparency;
            return mapper.getRangeColorMapper().getFullRanges(tr);
        }
        Color[] colors = this.isFillOn() ? this.colorEncoder.rampColors : this.lineColorEncoder.rampColors;
        Range[] colorModelRanges = new Range[1];
        RangeBound low = new RangeBound(range.getMin(), true);
        RangeBound high = new RangeBound(range.getMax(), true);
        ColorModel colorModel = new ColorModel(colors);
        colorModelRanges[0] = new Range(low, high, colorModel);
        return colorModelRanges;
    }

    @Override
    public SASFormat getContinuousLegendFormat() {
        ColorEncoder ce;
        ColorEncoder colorEncoder = ce = this.colorVar != null ? (ColorEncoder)this.getEncoder((byte)4) : (ColorEncoder)this.getEncoder((byte)17);
        if (ce != null && ce.getInput() instanceof ContinuousRange) {
            SASFormat fmt = ce.getInput().getFormat();
            if (fmt == null) {
                fmt = DataModel.defaultFormat;
            } else if (fmt.getFormatDescription().isDecimalWidthSupported()) {
                int w = fmt.getFormatDescription().getMaxWidth();
                int d = fmt.getDecimalWidth();
                fmt = SASFormat.getInstance((String)(fmt.getBaseFormatName() + Integer.toString(w).trim() + "." + Integer.toString(d).trim()));
                fmt.setInsertBlanks(false);
            }
            return fmt;
        }
        return null;
    }

    @Override
    public String getDefaultContinuousLegendTitle() {
        String title = null;
        if (!this.gradientColor) {
            return null;
        }
        if (this.model.isAvailable(6)) {
            ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(45);
            title = cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
        } else if (this.model.isAvailable(46)) {
            ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(46);
            title = cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
        }
        return title;
    }

    public boolean isErrorCapVisible() {
        return this.errorCapVisible;
    }

    public void setErrorCapVisible(boolean errorCapVisible) {
        this.errorCapVisible = errorCapVisible;
    }

    private void printLabelDroppedMessage() {
        if (this.labelVar != null || this.getStmt().equalsIgnoreCase("BarChartParm")) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "datalabeldropped.txt"));
        } else {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "barlabeldropped.txt"));
        }
    }

    public Bar getBarElement() {
        return this.bar;
    }

    @Override
    protected int getNumberOfDrawingElements() {
        if (this.statistic == -1) {
            return this.categoryVar.getValueCount();
        }
        int num = this.categoryVar.getUniqueValueCount();
        if (this.groupVar != null) {
            int count = 0;
            for (int i = 0; i < num; ++i) {
                count += this.groupsPerCategory[i];
            }
            num = count;
        }
        return num;
    }

    public boolean isDiscreteCategory() {
        return this.discreteCategory;
    }

    public void setDiscreteCategory(boolean discreteCategory) {
        this.discreteCategory = discreteCategory;
    }

    private double getStride() {
        double stride = 0.0;
        PositionEncoder ve = this.orientation == 0 ? this.xEncoder : this.yEncoder;
        ValueMap map = ve.getValueMap();
        if (this.discreteCategory) {
            stride = ((StringToNumericMap)map).getStrideValue();
        } else {
            double intvl = this.getMinimumInterval((short)1);
            stride = this.getMaximumIntervalSize(intvl, ve, false);
        }
        return stride;
    }

    public double getIntervalBarWidth() {
        return this.intervalBarWidth;
    }

    public void setIntervalBarWidth(double intervalBarWidth) {
        this.intervalBarWidth = intervalBarWidth;
    }

    private NumericVariable binIntervalVar(NumericVariable nv) {
        NumericVectorVariable bv = new NumericVectorVariable();
        double[] vec = new double[nv.getValueCount()];
        for (int i = 0; i < vec.length; ++i) {
            try {
                double v = nv.value.getValue(i);
                int binIdx = (int)((v - this.binStart) / (1.0001 * this.binWidth));
                vec[i] = this.binStart + ((double)binIdx + 0.5) * this.binWidth;
                continue;
            }
            catch (MissingValueException mve) {
                vec[i] = Double.NaN;
            }
        }
        bv.connectFrom(vec);
        bv.setFormat(nv.getFormat());
        bv.setLabel(nv.getLabel());
        bv.getUniqueValueCount();
        return bv;
    }

    @Override
    public double getMinimumInterval(short role) {
        NumericVariable var = (NumericVariable)this.connectRaw(role);
        var.setFormat(null);
        if (var == null) {
            return 0.0;
        }
        if (this.binCategory) {
            var = this.binIntervalVar(var);
        }
        VariableProcessor vp = new VariableProcessor();
        vp.addGroupVariable((Variable)var);
        vp.setSort((Variable)var, 1);
        int n = var.getValueCount();
        if (n <= 1) {
            return 0.0;
        }
        double interval = Double.MAX_VALUE;
        boolean firstValue = false;
        double v1 = Double.NaN;
        for (int i = 0; i < n; ++i) {
            try {
                if (!firstValue) {
                    v1 = var.value.getValue(i);
                    firstValue = true;
                    continue;
                }
                double v2 = var.value.getValue(i);
                double delta = v2 - v1;
                if (delta == 0.0) continue;
                if (delta < interval) {
                    interval = delta;
                }
                v1 = v2;
                continue;
            }
            catch (MissingValueException e) {
                // empty catch block
            }
        }
        if (interval < Double.MAX_VALUE) {
            return interval;
        }
        return 0.0;
    }

    private void calculateBins(short role) {
        double min = this.model.getColumnMin(role);
        double max = this.model.getColumnMax(role);
        if (this.binStart != this.binStart && this.binWidth != this.binWidth && this.nBins != this.nBins) {
            double[] val = ZxAxis.znaxis((double)min, (double)max, (boolean)true, (boolean)false, (int)this.nBinsHint, (double)0.2, (double)0.8);
            this.binStart = val[0];
            this.nBins = (int)val[2] - 1;
            this.binWidth = val[1];
        } else {
            ContinuousTickSpacer cts = new ContinuousTickSpacer();
            cts.setDataMin(min);
            cts.setDataMax(max);
            if (this.binWidth == this.binWidth) {
                cts.setInterval(this.binWidth);
                cts.getPreference().setAutoInterval(false);
            }
            if (this.nBins == this.nBins) {
                cts.setTickCount((int)this.nBins + 1);
                cts.getPreference().setAutoInterval(false);
            }
            if (this.binStart == this.binStart) {
                cts.setUserMin(this.binStart);
                cts.getPreference().setMinCalc(1);
            }
            cts.doTickSpacing();
            this.binStart = cts.getTickMin();
            this.nBins = cts.getNumTicks() - 1;
            this.binWidth = (cts.getTickMax() - cts.getTickMin()) / this.nBins;
            int nAdj = 0;
            if (this.binStart > min) {
                nAdj = (int)Math.ceil((this.binStart - min) / this.binWidth);
            }
            this.nBins += (double)nAdj;
            this.binStart -= this.binWidth * (double)nAdj;
        }
    }

    public double getBinStart() {
        return this.binStart;
    }

    public void setBinStart(double binStart) {
        this.binStart = binStart;
    }

    public double getBinWidth() {
        return this.binWidth;
    }

    public void setBinWidth(double binWidth) {
        this.binWidth = binWidth;
    }

    public double getNBins() {
        return this.nBins;
    }

    public void setNBins(double nBins) {
        this.nBins = nBins;
    }

    public boolean isBinCategory() {
        return this.binCategory;
    }

    public void setBinCategory(boolean binCategory) {
        this.binCategory = binCategory;
    }

    public int getNBinsHint() {
        return this.nBinsHint;
    }

    public void setNBinsHint(int nBinsHint) {
        this.nBinsHint = nBinsHint;
    }

    public int getColorStatistic() {
        return this.colorStatistic;
    }

    public void setColorStatistic(int colorStatistic) {
        this.colorStatistic = colorStatistic;
    }

    protected ContinuousRange getUnionAllColorRange() {
        ContinuousRange range = null;
        NumericVectorVariable tempCategoryVar = null;
        NumericVariable tempColorResponseVar = null;
        Variable tempGroupVar = null;
        if (this.discreteCategory) {
            tempCategoryVar = this.connectCategory((short)1, true);
        } else {
            tempCategoryVar = new NumericVectorVariable();
            tempCategoryVar.connectFrom(this.model.getDoubleColumn(1));
            tempCategoryVar.setLabel(this.getLabel((short)1));
            if (this.binCategory) {
                tempCategoryVar = this.binIntervalVar((NumericVariable)tempCategoryVar);
            }
        }
        tempColorResponseVar = null;
        if (this.model.isAvailable(6)) {
            tempColorResponseVar = (NumericVariable)this.connectRaw((short)6);
        } else if (this.model.isAvailable(46)) {
            tempColorResponseVar = (NumericVariable)this.connectRaw((short)46);
        }
        if (tempColorResponseVar == null) {
            int n = tempCategoryVar.getValueCount();
            double[] count = new double[n];
            for (int i = 0; i < n; ++i) {
                count[i] = 1.0;
            }
            tempColorResponseVar = new NumericVectorVariable();
            ((NumericVectorVariable)tempColorResponseVar).connectFrom(count);
        }
        if (this.groupVar != null) {
            tempGroupVar = this.connectCategory((short)3, true);
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        boolean paneling = this.model.allWhereExpressions != null;
        int cnt = paneling ? this.model.allWhereExpressions.length : 1;
        for (int i = 0; i < cnt; ++i) {
            if (paneling && this.model.allWhereExpressions[i] == null) continue;
            VariableProcessor vp = new VariableProcessor();
            if (this.subset) {
                vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
            }
            vp.addGroupVariable((Variable)tempCategoryVar);
            if (tempGroupVar != null) {
                vp.addGroupVariable(tempGroupVar);
            }
            vp.addVariable((Variable)tempColorResponseVar, this.colorStatistic);
            if (paneling) {
                for (int j = 0; j < this.model.whereVars.length; ++j) {
                    StringVectorVariable sv;
                    if (this.model.whereVars[j] == null) continue;
                    Object object = sv = this.model.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                    if (this.model.whereVarsOnSeparateModel) {
                        DataModel dm = this.model.getSrcModel();
                        int wcol = dm.getColumn(this.model.whereVars[j].getName());
                        sv.setName(this.model.whereVars[j].getName());
                        sv.connectFrom(dm.getColumnAsClassColumn(wcol, this.model.whereIncludeMissingClass));
                    } else {
                        sv.connectFrom(this.model.whereVars[j]);
                    }
                    vp.addVariable((Variable)sv);
                }
                String curWhere = vp.getWhereExpression();
                if (curWhere != null) {
                    vp.setWhereExpression("(" + curWhere + ") & (" + this.model.allWhereExpressions[i] + ")");
                } else {
                    vp.setWhereExpression(this.model.allWhereExpressions[i]);
                }
                if (!vp.isWhereExpressionValid()) {
                    StatGraph.printDebug("Invalid where cluase: " + vp.getWhereExpression());
                }
            }
            vp.init(new AInitAction(null));
            min = Math.min(min, tempColorResponseVar.getMin());
            max = Math.max(max, tempColorResponseVar.getMax());
        }
        range = new ContinuousRange(min, max);
        range.setLabel(this.responseVar.getLabel());
        return range;
    }

    @Override
    public int getRendererComplexity() {
        return this.getNumberOfDrawingElements();
    }

    @Override
    public int getNumOfTooltips() {
        return this.getNumberOfDrawingElements();
    }

    @Override
    public void resetToInitialValues() {
        this.useFillTransparency = false;
        this.useLineThickness = false;
        this.useMarkerSize = false;
        this.useMarkerTransparency = false;
        this.useMarkerWeight = false;
        this.attrVarMap.clear();
        this.fillOn = true;
        this.fillStyle = new FillAttrs();
        this.fillPatternOn = false;
        this.fillPatternStyle = new FillPatternAttrs();
        this.edgeOn = true;
        this.edgeStyle = new LineAttrs();
        this.connectOn = false;
        this.connectStyle = new LineAttrs();
        this.colorRange = null;
        this.lineRange = null;
        this.lineColorRange = null;
        this.fillPatternRange = null;
        this.fillPatternColorRange = null;
        this.lineColorEncoder = null;
        this.lineEncoder = null;
        this.colorEncoder = null;
        this.fillPatternEncoder = null;
        this.fillPatternColorEncoder = null;
        this.numericColor = true;
        this.numericLineColor = true;
        this.numericGroup = false;
        this.numericLabel = true;
        this.multiResponseLabels = null;
        this.responseCount = 0;
        this.categoryVar_sav = null;
        this.groupsPerCategory = null;
        this.bar = null;
        this.offsetCalculator = null;
        this.subset = false;
        this.subsetObs = null;
        this.subsetObsCount = 0;
        this.statistic = -1;
        this.colorStatistic = -1;
        this.useSegmentLabelColor = true;
        this.showBarValue = false;
        this.statRange = null;
        this.positiveAccumulation = null;
        this.negativeAccumulation = null;
        this.longestLabel = null;
        this.labelStyle = new TextStyle();
        this.updateLabelVars = true;
        this.useLabelColor = false;
        this.useEdgeColor = false;
        this.useEdgePattern = false;
        this.rotateLabelAsNeeded = false;
        this.labelInsidePreferred = false;
        this.autoRotateLabel = true;
        this.labelRotated = false;
        this.labelDropped = false;
        this.labelInside = false;
        this.displayZeroHeightBar = true;
        this.weightedByCategories = false;
        this.gradientColor = false;
        this.binCategory = false;
        this.binStart = Double.NaN;
        this.binWidth = Double.NaN;
        this.nBins = Double.NaN;
        this.nBinsHint = 10;
        this.resetVars();
    }

    public Color getMissingColorResponseColor() {
        return this.missingColorResponseColor;
    }

    public void setMissingColorResponseColor(Color missingColorResponseColor) {
        this.missingColorResponseColor = missingColorResponseColor;
    }

    @Override
    public boolean hasMissingValue() {
        int clrvIDX;
        if (!this.gradientColor) {
            return false;
        }
        CRD crd = this.model;
        if (this.isFillOn()) {
            if (!crd.isAvailable(6)) {
                return false;
            }
            clrvIDX = this.model.getSrcModel().getColumn(this.model.getColumnName((short)6));
        } else {
            if (!crd.isAvailable(46)) {
                return false;
            }
            clrvIDX = this.model.getSrcModel().getColumn(this.model.getColumnName((short)46));
        }
        ColumnMetadata cmd = (ColumnMetadata)this.model.getSrcModel().getColumnLabel(clrvIDX);
        return cmd.getMissings() > 0;
    }

    @Override
    public Color getMissingColor() {
        return this.missingColorResponseColor;
    }

    public boolean isConnectSkipMiss() {
        return this.connectSkipMiss;
    }

    public void setConnectSkipMiss(boolean connectSkipMiss) {
        this.connectSkipMiss = connectSkipMiss;
    }
}

