/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.util.attrmap.DiscreteAttributeMap;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.PipedFormat;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToNumberMap;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class AxisTable
extends Overlay {
    public static final int X_AXIS = 1;
    public static final int X2_AXIS = 2;
    public static final int Y_AXIS = 3;
    public static final int Y2_AXIS = 4;
    public static final int LABEL_POSITION_MIN = 1;
    public static final int LABEL_POSITION_MAX = 2;
    protected DataRange varRange = null;
    protected DataRange groupRange = null;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder groupColorEncoder;
    protected NumericMapper varMapper;
    private Variable var;
    private Variable column;
    private Variable classVar;
    private Variable rawClassVar;
    private Variable groupVar;
    private Variable textGroupVar;
    private NumericVariable indentWeightVar;
    private int axis = 1;
    private TextAttrs valueAttrs = new TextAttrs();
    private TextAttrs labelAttrs = new TextAttrs();
    private TextAttrs headerLabelAttrs = new TextAttrs();
    private LineAttrs gridAttrs = new LineAttrs();
    private boolean labelAttrsOverride = false;
    private boolean valueAttrsOverride = false;
    private Channel channel;
    private NetworkRoot root;
    private NetworkRoot root2;
    private RasterLabel values;
    private RasterLabel label;
    private RasterLabel[] classValues;
    private RasterLabel[] classLabels;
    private int numClasses;
    private RasterLabel header;
    private String fittedHeaderLabel = null;
    private String headerLabel = null;
    private boolean showHeader = true;
    private boolean showLabel = true;
    private boolean numericClass = false;
    private boolean numericVar = false;
    private boolean discreteVar;
    private int vGap = 0;
    private int gap = (int)(4.0 * StatGraph.getGapScaleFactor());
    private int labelPosition = 1;
    private boolean numericColumn;
    private StringVector valueText = null;
    private int scaledValueFontSize;
    private boolean showGridLines = false;
    private LineSegment gridLines;
    private double offsetPosition = Double.NaN;
    private boolean includeMissingGroup = true;
    private boolean valueAttrsColorOverride = false;
    private boolean valueAttrsWeightOverride = false;
    private boolean valueAttrsStyleOverride = false;
    private boolean valueAttrsFontFamilyOverride = false;
    private boolean valueAttrsSizeOverride = false;
    private int numValueTextLines = 1;
    private int numHeaderTextLines = 1;
    private String columnLabel = null;
    private int numLabelTextLines = 1;
    private Vector<String> classVals = null;
    private int maxLabelTextWidth = 0;
    private int maxValueTextWidth = 0;
    private int oneClassValueSize = 0;
    private int maxValueTextWidthN = -1;
    private boolean headerSplit = false;
    private int indentPixels = 0;
    private int maxIndentWeight = 0;
    private VariableProcessor vp = null;
    public static final int STAT_AUTO = -1;
    private int stat = -1;
    private double alignmentOffsetX = this.gap;
    private double alignmentOffsetX2 = this.gap;
    private double alignmentOffsetY = this.gap;
    private double alignmentOffsetY2 = this.gap;
    public static int ALIGN_H_AUTO = 0;
    public static int ALIGN_H_LEFT = 1;
    public static int ALIGN_H_CENTER = 2;
    public static int ALIGN_H_RIGHT = 3;
    private int headerHAlign = ALIGN_H_AUTO;
    private int labelHAlign = ALIGN_H_AUTO;
    private int valueHAlign = ALIGN_H_AUTO;
    private int headerJustify = ALIGN_H_LEFT;
    private int labelJustify = ALIGN_H_CENTER;
    private int valueJustify = ALIGN_H_AUTO;
    private boolean showMissing = true;
    private int classGutter = -1;
    private Variable rawColumnVar;
    private String labelString = null;
    private Insets pad = new Insets(0, 0, 0, 0);
    public static final int DATA = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    public static final int REVERSEDATA = 3;
    private int classOrder = 0;
    public static final byte STACK = 0;
    public static final byte CLUSTER = 1;
    private int classDisplay = 0;
    private double clusterWidth = 0.85;
    private boolean includeMissingClass = true;
    private boolean clustering = false;
    private int[] classPerCategory;
    private String overlayID;
    private ArrayList[] classCategoryLists;
    private SASFormat valueFormat = null;
    private int userValueTextWidth = -1;

    public void setUserValueTextWidth(int width) {
        this.userValueTextWidth = width;
    }

    public int getUserValueTextWidth() {
        return this.userValueTextWidth;
    }

    public void setValueFormat(SASFormat fmt) {
        this.valueFormat = fmt;
    }

    public SASFormat getValueFormat() {
        return this.valueFormat;
    }

    public void setMissingClassOn(boolean b) {
        this.includeMissingClass = b;
    }

    public boolean isMissingClassOn() {
        return this.includeMissingClass;
    }

    public void setClassDisplay(int disp) {
        this.classDisplay = disp;
    }

    public int getClassDisplay() {
        return this.classDisplay;
    }

    public void setClassOrder(int order) {
        this.classOrder = order;
    }

    public int getClassOrder() {
        return this.classOrder;
    }

    public void setClusterWidth(double w) {
        this.clusterWidth = w;
    }

    public double getClusterWidth() {
        return this.clusterWidth;
    }

    public void setPad(int top, int left, int bottom, int right) {
        if (top >= 0) {
            this.pad.top = top;
        }
        if (left >= 0) {
            this.pad.left = left;
        }
        if (bottom >= 0) {
            this.pad.bottom = bottom;
        }
        if (right >= 0) {
            this.pad.right = right;
        }
    }

    public Insets getPad() {
        return this.pad;
    }

    public void setHeaderHAlign(int align) {
        this.headerHAlign = align;
    }

    public int getHeaderHAlign() {
        return this.headerHAlign;
    }

    public void setLabelHAlign(int align) {
        this.labelHAlign = align;
    }

    public int getLabelHAlign() {
        return this.labelHAlign;
    }

    public void setValueHAlign(int align) {
        this.valueHAlign = align;
    }

    public int getValueHAlign() {
        return this.valueHAlign;
    }

    public void setHeaderJustify(int just) {
        this.headerJustify = just;
    }

    public int getHeaderJustify() {
        return this.headerJustify;
    }

    public void setLabelJustify(int just) {
        this.labelJustify = just;
    }

    public int getLabelJustify() {
        return this.labelJustify;
    }

    public void setValueJustify(int just) {
        this.valueJustify = just;
    }

    public int getValueJustify() {
        return this.valueJustify;
    }

    public void setShowMissing(boolean show) {
        this.showMissing = show;
    }

    public boolean isShowMissing() {
        return this.showMissing;
    }

    public void setClassGutter(int gutter) {
        this.classGutter = gutter;
    }

    public int getClassGutter() {
        return this.classGutter;
    }

    public void setLabel(String lab) {
        this.labelString = lab;
    }

    public String getLabel() {
        return this.labelString;
    }

    public AxisTable() {
        this.gap = (int)Math.round(4.0 * StatGraph.getGapScaleFactor());
        this.pad.top = 0;
        this.pad.left = this.gap;
        this.pad.bottom = 0;
        this.pad.right = this.gap;
    }

    public void setShowHeader(boolean b) {
        this.showHeader = b;
    }

    public void setShowLabel(boolean b) {
        this.showLabel = b;
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public int getAxis() {
        return this.axis;
    }

    public void setAxis(int axis) {
        this.axis = axis;
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.updateNumberOfClassPerCategory();
    }

    protected void connectVars() {
        byte dim;
        boolean unionPages;
        CRD crd = this.model;
        this.numericVar = false;
        if (this.vp == null) {
            this.vp = new VariableProcessor();
        } else {
            this.vp.removeAllVariables();
        }
        switch (this.axis) {
            default: {
                this.discreteVar = this.discreteX;
                unionPages = this.xUnionAllPages;
                dim = 1;
                break;
            }
            case 3: 
            case 4: {
                this.discreteVar = this.discreteY;
                unionPages = this.yUnionAllPages;
                dim = 2;
            }
        }
        NumericVariable varRaw = null;
        if (crd.isAvailable(114)) {
            this.numericVar = crd.getColumnClass(114) == Double.class;
            this.var = !this.discreteVar ? this.connectRaw((short)114) : this.connectCategory((short)114, StatGraph.includeMissingDiscrete);
            if (this.discreteVar && this.numericVar) {
                varRaw = (NumericVariable)this.connectRaw((short)114);
                this.numericVar = false;
            }
            if (!this.numericVar) {
                this.discreteVar = true;
            }
        } else {
            this.var = null;
        }
        this.varMapper = null;
        this.numericColumn = false;
        if (crd.isAvailable(115)) {
            boolean bl = this.numericColumn = crd.getColumnClass(115) == Double.class;
            if (this.numericColumn || this.valueFormat != null) {
                this.rawColumnVar = this.column = this.connectRaw((short)115);
                if (this.valueFormat != null) {
                    if (this.numericColumn && !this.valueFormat.isCharacterFormat() || !this.numericColumn && this.valueFormat.isCharacterFormat()) {
                        this.column.setFormat(new GTKFormat((Format)this.valueFormat));
                    }
                } else {
                    SASFormat fmt = this.getFormat(115);
                    if (fmt != null && fmt.getFormatDescription().isDecimalWidthSupported()) {
                        int w = fmt.getFormatDescription().getMaxWidth();
                        int d = fmt.getDecimalWidth();
                        fmt = SASFormat.getInstance((String)(fmt.getBaseFormatName() + Integer.toString(w).trim() + "." + Integer.toString(d).trim()));
                        fmt.setInsertBlanks(false);
                        this.column.setFormat(new GTKFormat((Format)fmt));
                    }
                }
            } else {
                this.column = this.connectCategory((short)115, true);
                this.rawColumnVar = this.connectRaw((short)115);
            }
        } else {
            this.column = null;
            this.rawColumnVar = null;
        }
        StringVectorVariable unsortedGroupVar = null;
        if (crd.isAvailable(3)) {
            this.groupVar = this.connectCategory((short)3, this.includeMissingGroup);
            unsortedGroupVar = (StringVectorVariable)this.connectCategory((short)3, this.includeMissingGroup);
            this.groupRange = Overlay.makeDiscreteRange((StringVariable)unsortedGroupVar, unsortedGroupVar.getUniqueValueCount());
        } else {
            this.groupVar = null;
        }
        if (crd.isAvailable(116)) {
            this.textGroupVar = this.connectCategory((short)116, this.includeMissingGroup);
            this.groupVar = null;
        } else {
            this.textGroupVar = null;
        }
        if (crd.isAvailable(117) && crd.getColumnClass(117) == Double.class) {
            this.indentWeightVar = (NumericVariable)this.connectRaw((short)117);
            this.maxIndentWeight = (int)this.indentWeightVar.getMax();
        } else {
            this.indentWeightVar = null;
            this.maxIndentWeight = 0;
        }
        if (crd.isAvailable(1)) {
            this.numericClass = crd.getColumnClass(1) == Double.class;
            this.classVar = this.connectCategory((short)1, this.includeMissingClass);
            this.rawClassVar = this.connectRaw((short)1);
            this.rawClassVar.setFormattedValueMissingValueExceptionsEnabled(false);
        } else {
            this.classVar = null;
        }
        this.vp.addGroupVariable(this.var);
        if (this.classVar != null) {
            this.vp.addVariable(this.classVar, 0);
            this.vp.addGroupVariable(this.rawClassVar);
            if (this.classOrder == 1) {
                this.rawClassVar.setUniqueValueSort(1);
            } else if (this.classOrder == 2) {
                this.rawClassVar.setUniqueValueSort(2);
            }
            this.rawClassVar.setSortByFormattedValues(!this.numericClass);
            if (!this.includeMissingClass) {
                this.vp.setWhereExpression("^(" + this.rawClassVar.getName() + " IS MISSING)");
                this.whereRoles = new int[]{1};
            }
        }
        int columnStat = this.numericColumn ? (this.stat == -1 ? 6 : this.stat) : 12;
        this.vp.addVariable(this.column, columnStat);
        if (this.rawColumnVar != null && !this.numericColumn) {
            this.vp.addVariable(this.rawColumnVar, columnStat);
        }
        if (this.groupVar != null) {
            this.vp.addVariable(this.groupVar, 12);
        }
        if (this.textGroupVar != null) {
            this.vp.addVariable(this.textGroupVar, 12);
        }
        if (this.indentWeightVar != null) {
            this.vp.addVariable((Variable)this.indentWeightVar, 12);
        }
        this.addCRDWhereClause(this.vp);
        DataRange oldRange = this.varRange;
        this.varRange = this.computeRange(this.var, varRaw, this.numericVar, this.discreteVar, (short)114, !unionPages, this.varRange, dim);
        this.fireRangeEvent(dim, oldRange, this.varRange);
        if (this.column.formattedValue instanceof PipedFormat) {
            ((PipedFormat)this.column.formattedValue).setMissingValueExceptionsEnabled(false);
        }
        if (this.classGutter < 0) {
            this.classGutter = this.axis == 3 || this.axis == 4 ? this.gap * 2 : 0;
        }
        this.clustering = this.classVar != null && this.classDisplay == 1 && !this.numericVar;
    }

    private DataRange computeRange(Variable var, NumericVariable rawVar, boolean numericVar, boolean discrete, short role, boolean subset, DataRange oldRange, byte dim) {
        DataRange newRange = null;
        if (var != null) {
            int num;
            int n = num = numericVar ? var.getValueCount() : var.getUniqueValueCount();
            if (num > 0) {
                if (numericVar || rawVar != null) {
                    if (discrete) {
                        var.init();
                        newRange = this.makeOrdinalRange((StringVariable)var, num, rawVar, role, subset);
                    } else {
                        newRange = this.makeContinuousRange((NumericVariable)var, role, subset);
                    }
                } else {
                    newRange = Overlay.makeDiscreteRange((StringVariable)var, num);
                }
                newRange.setLabel(var.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat(newRange, role);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        return newRange;
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        DataRange xRange = null;
        DataRange yRange = null;
        switch (this.axis) {
            case 1: 
            case 2: {
                xRange = this.varRange;
                yRange = null;
                break;
            }
            case 3: 
            case 4: {
                xRange = null;
                yRange = this.varRange;
            }
        }
        switch (dimension) {
            case 1: {
                return xRange;
            }
            case 2: {
                return yRange;
            }
            case 17: {
                return this.groupRange;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.channel = channel;
        this.root = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.root.draw();
    }

    @Override
    public void drawNoneClipped(Graphics g) {
        if (this.root2 == null) {
            return;
        }
        Channel channel = this.root2.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.root2.draw(channel, false);
    }

    @Override
    protected boolean connectNetwork() {
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        if (this.root != null) {
            this.root.removeAllElements();
        }
        if (this.root2 != null) {
            this.root2.removeAllElements();
        }
        switch (this.axis) {
            case 1: 
            case 2: {
                this.connectVarMapper(this.xEncoder);
                break;
            }
            case 3: 
            case 4: {
                this.connectVarMapper(this.yEncoder);
            }
        }
        if (this.classVar != null) {
            this.connectClassValues();
            if (this.root2 == null) {
                this.root2 = new NetworkRoot(this.root.getChannel());
            }
            for (int i = 0; i < this.numClasses; ++i) {
                this.root.addElement((Element)this.classValues[i]);
                if (this.displayGridLabel || !this.showLabel || this.clustering && i != 0) continue;
                this.root2.addElement((Element)this.classLabels[i]);
            }
        } else {
            this.connectValues();
            if (this.values != null) {
                this.root.addElement((Element)this.values);
            }
            if (!this.displayGridLabel && this.label != null && this.showLabel) {
                this.root2 = new NetworkRoot(this.root.getChannel());
                this.root2.addElement((Element)this.label);
            }
        }
        if (this.showHeader && this.fittedHeaderLabel != null) {
            this.header = new RasterLabel();
            this.header.color.setValue(this.headerLabelAttrs.getColor());
            this.header.setFont(this.headerLabelAttrs.getFont());
            this.header.string.setValue(this.fittedHeaderLabel);
            int prefSize = this.getPreferredValueSize();
            double headerWidth = AxisTable.getTextWidth(StatGraph.getFontMetrics(this.headerLabelAttrs.getFont()), this.fittedHeaderLabel);
            switch (this.axis) {
                case 1: 
                case 2: {
                    if (this.headerHAlign == ALIGN_H_LEFT || this.headerHAlign == ALIGN_H_AUTO) {
                        this.header.coordX.setValue(this.getXPosition(headerWidth, this.headerJustify, this.xEncoder.getLowerLimit() + (double)(this.gap / 2), ALIGN_H_LEFT));
                    } else if (this.headerHAlign == ALIGN_H_CENTER) {
                        this.header.coordX.setValue(this.getXPosition(headerWidth, this.headerJustify, (this.xEncoder.getLowerLimit() + this.xEncoder.getUpperLimit()) / 2.0, ALIGN_H_CENTER));
                    } else {
                        this.header.coordX.setValue(this.getXPosition(headerWidth, this.headerJustify, this.xEncoder.getUpperLimit() - (double)(this.gap / 2), ALIGN_H_RIGHT));
                    }
                    if (this.isInnerMarginOverlay() || Double.isNaN(this.offsetPosition)) {
                        if (this.overlayJustification == 2) {
                            this.header.coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.pad.bottom + (double)this.overlayBase + (double)prefSize + (double)(this.gap / 2));
                        } else {
                            this.header.coordY.setValue(this.yEncoder.getUpperLimit() - (double)this.pad.top - (double)this.overlayBase - (double)this.getPreferredHeaderLabelHeight() + (double)(this.gap / 2));
                        }
                    } else {
                        this.header.coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.pad.bottom + this.offsetPosition * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) + (double)prefSize + (double)(this.gap / 2));
                    }
                    this.header.horizontalJustification.setValue(this.getGTKJustification(this.headerJustify));
                    this.header.verticalJustification.setValue(3);
                    this.root.addElement((Element)this.header);
                    break;
                }
                case 3: 
                case 4: {
                    if (this.isInnerMarginOverlay() || Double.isNaN(this.offsetPosition)) {
                        if (this.overlayJustification == 4) {
                            this.header.coordX.setValue(this.getXPosition(headerWidth, this.headerJustify, this.xEncoder.getUpperLimit() - (double)this.overlayBase - (double)(prefSize / 2), prefSize, this.headerHAlign));
                        } else {
                            this.header.coordX.setValue(this.getXPosition(headerWidth, this.headerJustify, this.xEncoder.getLowerLimit() + (double)this.overlayBase + (double)(prefSize / 2), prefSize, this.headerHAlign));
                        }
                    } else {
                        this.header.coordX.setValue(this.getXPosition(headerWidth, this.headerJustify, this.xEncoder.getLowerLimit() + this.offsetPosition * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()), prefSize, this.headerHAlign));
                    }
                    this.header.horizontalJustification.setValue(this.getGTKJustification(this.headerJustify));
                    this.header.verticalJustification.setValue(3);
                    if (this.getLabelPositionInUse() == 1 || !this.showLabel) {
                        if (this.displayGridLabel) {
                            this.header.coordY.setValue(this.yEncoder.getUpperLimit() + (double)this.gap + (double)this.gridLabelTopOffset);
                        } else {
                            this.header.coordY.setValue(this.yEncoder.getUpperLimit() + (double)this.gap);
                        }
                    } else {
                        FontMetrics lfm = StatGraph.getFontMetrics(this.labelAttrs.getFont());
                        int h = lfm.getHeight() * this.numLabelTextLines + 2 * this.gap;
                        if (this.displayGridLabel) {
                            this.header.coordY.setValue(this.yEncoder.getUpperLimit() + (double)h + (double)this.gridLabelTopOffset);
                        } else {
                            this.header.coordY.setValue(this.yEncoder.getUpperLimit() + (double)h);
                        }
                    }
                    if (this.displayGridLabel && this.gridLabelEntryT != null) {
                        this.header.transform.translateX.setValue(-this.xEncoder.getLowerLimit());
                        this.header.transform.translateY.setValue(-this.yEncoder.getUpperLimit() - (double)this.gridLabelTopOffset);
                        this.gridLabelEntryT.addTitle(new RasterLabel[]{this.header}, this.getID());
                    }
                    if (this.root2 == null) {
                        this.root2 = new NetworkRoot(this.root.getChannel());
                    }
                    if (this.displayGridLabel) break;
                    this.root2.addElement((Element)this.header);
                }
            }
        }
        if (this.showGridLines) {
            this.connectGridLines();
            this.root.addElement((Element)this.gridLines);
        }
        this.needConnect = false;
        return true;
    }

    private void connectGridLines() {
    }

    private void connectClassValues() {
        int i;
        double oneValueSize;
        double stride;
        int maxGroups;
        if (this.column == null || this.column.getValueCount() == 0 && !this.displayGridLabel || this.varMapper == null) {
            return;
        }
        HashMap cm = this.groupVar != null && this.groupColorEncoder != null ? this.groupColorEncoder.getColorList() : null;
        DiscreteAttrMapper cgDAM = null;
        DiscreteAttributeMap cgAttrMap = null;
        if (this.hasAttrVar("GROUP")) {
            cgDAM = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
            cgDAM.setTextTransparency(this.dataTransparency);
            cgAttrMap = cgDAM.getAttrMap();
        }
        DiscreteAttrMapper tgDAM = null;
        DiscreteAttributeMap tgAttrMap = null;
        if (this.hasAttrVar("TEXTGROUP")) {
            tgDAM = (DiscreteAttrMapper)this.getAttrVarMapper("TEXTGROUP");
            tgDAM.setTextTransparency(this.dataTransparency);
            tgAttrMap = tgDAM.getAttrMap();
        }
        Color[] labelColor = null;
        Hashtable<String, Integer> classIndexMap = new Hashtable<String, Integer>();
        if (this.uniformPlotSize && !this.clustering) {
            String cv2;
            int i2;
            Variable classVar_global = this.connectCategory((short)1, this.includeMissingClass);
            Variable rawClassVar_global = this.connectRaw((short)1);
            rawClassVar_global.setSortByFormattedValues(!this.numericClass);
            if (!this.includeMissingClass || this.classOrder == 1 || this.classOrder == 2) {
                VariableProcessor vp = new VariableProcessor();
                vp.addVariable(classVar_global);
                vp.addVariable(rawClassVar_global);
                if (this.classOrder == 1) {
                    vp.setSort(rawClassVar_global, 1);
                } else if (this.classOrder == 2) {
                    vp.setSort(rawClassVar_global, 2);
                }
                if (!this.includeMissingClass) {
                    vp.setWhereExpression("^(" + rawClassVar_global.getName() + " IS MISSING)");
                }
            }
            this.numClasses = classVar_global.getUniqueValueCount();
            for (i2 = 0; i2 < this.numClasses; ++i2) {
                try {
                    cv2 = classVar_global.formattedUniqueValue.getValue(i2);
                    classIndexMap.put(cv2, i2);
                    continue;
                }
                catch (MissingValueException cv2) {
                    // empty catch block
                }
            }
            if (this.groupVar != null && this.groupVar.getLabel() == this.classVar.getLabel() && !this.labelAttrsOverride) {
                labelColor = new Color[this.numClasses];
                for (i2 = 0; i2 < this.numClasses; ++i2) {
                    try {
                        TextAttrs ta;
                        cv2 = classVar_global.formattedUniqueValue.getValue(i2);
                        Color c = this.valueAttrs.getAltColor();
                        if (cm != null) {
                            c = (Color)cm.get(cv2);
                        }
                        if (cgAttrMap != null && cgAttrMap.get(cv2) != null && (ta = cgAttrMap.get(cv2).getTextAttrs()) != null && ta.getColor() != null) {
                            c = ta.getColor();
                        }
                        labelColor[i2] = c;
                        continue;
                    }
                    catch (MissingValueException e) {
                        labelColor[i2] = this.labelAttrs.getColor();
                    }
                }
            }
        } else {
            this.numClasses = this.classVar.getUniqueValueCount();
            if (!this.clustering) {
                this.createClassIndexMap(classIndexMap);
            }
        }
        this.classValues = new RasterLabel[this.numClasses];
        this.classLabels = new RasterLabel[this.numClasses];
        StringVector[] vals = new StringVector[this.numClasses];
        ColorVector[] gvc = new ColorVector[this.numClasses];
        NumericVector[] tgFontStyle = new NumericVector[this.numClasses];
        StringVector[] tgFontName = new StringVector[this.numClasses];
        NumericVector[] xnv = new NumericVector[this.numClasses];
        NumericVector[] ynv = new NumericVector[this.numClasses];
        for (int i3 = 0; i3 < this.numClasses; ++i3) {
            xnv[i3] = new NumericVector();
            ynv[i3] = new NumericVector();
            vals[i3] = new StringVector();
            if (this.groupVar != null || tgAttrMap != null) {
                gvc[i3] = new ColorVector();
            }
            if (tgAttrMap == null) continue;
            tgFontStyle[i3] = new NumericVector();
            tgFontName[i3] = new StringVector();
        }
        Font valueFont = this.valueAttrs.getFont();
        int width = (int)(this.xEncoder.getOutputMax() - this.xEncoder.getOutputMin());
        boolean splitAlways = this.dataLabelFitPolicy == DATALABEL_FIT_SPLITALWAYS;
        FontMetrics vfm = StatGraph.getFontMetrics(this.valueAttrs.getFont());
        int textAscent = this.getTextBaseLine();
        Font vf = null;
        vf = this.valueAttrsSizeOverride || this.scaledValueFontSize == 0 || this.scaledValueFontSize == valueFont.getSize() ? valueFont : new Font(valueFont.getFamily(), valueFont.getStyle(), this.scaledValueFontSize);
        double maxIndentPixels = this.maxIndentWeight * this.indentPixels;
        int centeringOffset = 0;
        if ((double)this.maxLabelTextWidth > (double)this.maxValueTextWidth + maxIndentPixels) {
            centeringOffset = (this.maxLabelTextWidth - (this.maxValueTextWidth + (int)maxIndentPixels)) / 2;
        }
        if (!Double.isNaN(this.offsetPosition) && !this.isInnerMarginOverlay()) {
            centeringOffset = 0;
        }
        if (this.clustering) {
            maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
            stride = ((StringToNumericMapper)this.varMapper).getStrideValue();
            oneValueSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
        } else {
            maxGroups = 1;
            stride = 0.0;
            oneValueSize = 0.0;
        }
        this.rawClassVar.getUniqueValueCount();
        IntegerPipe classCategory = this.numericClass ? ((NumericVariable)this.rawClassVar).category : ((StringVariable)this.rawClassVar).category;
        int classIndex = 0;
        for (i = 0; i < this.column.getValueCount(); ++i) {
            String str = "";
            String cv = "";
            String grp = "";
            String textGrp = null;
            double value = Double.NaN;
            double mappedValue = Double.NaN;
            String sval = "";
            try {
                TextAttrs ta;
                int classOffset;
                boolean validValue;
                str = this.column.formattedValue.getValue(i).trim();
                cv = this.classVar.formattedValue.getValue(i);
                if (this.numericColumn && str.equals(".")) {
                    str = StatGraph.missingOption;
                }
                if (this.rawColumnVar.isMissing(i) && !this.showMissing) {
                    str = "";
                }
                if (!classIndexMap.containsKey(cv)) {
                    classIndex = classCategory.getValue(i);
                    classIndexMap.put(cv, classIndex);
                }
                if (this.discreteVar) {
                    sval = ((StringVariable)this.var).value.getValue(i);
                } else {
                    value = ((NumericVariable)this.var).value.getValue(i);
                }
                if (this.groupVar != null) {
                    grp = this.groupVar.formattedValue.getValue(i);
                }
                if (this.textGroupVar != null) {
                    textGrp = this.textGroupVar.formattedValue.getValue(i);
                }
                boolean bl = this.discreteVar ? sval.length() > 0 || this.missingCategoryOn : (validValue = !Double.isNaN(value));
                if (!validValue || str.length() <= 0) continue;
                int ci = classIndexMap.get(cv);
                mappedValue = this.varMapper.getValue(i);
                if (this.clustering) {
                    if (this.var instanceof NumericVariable) {
                        ((NumericVariable)this.var).value.getValue(i);
                    }
                    int category = this.var instanceof StringVariable ? ((StringVariable)this.var).category.getValue(i) : ((NumericVariable)this.var).category.getValue(i);
                    mappedValue -= (double)((int)(((double)this.classPerCategory[category] / 2.0 - 0.5) * oneValueSize));
                    mappedValue += oneValueSize * (double)this.classCategoryLists[category].indexOf(ci);
                }
                if (this.clustering) {
                    classOffset = 0;
                } else {
                    int ci_adj = this.classOrder == 3 ? this.numClasses - 1 - ci : ci;
                    classOffset = this.overlayJustification == 1 || this.overlayJustification == 3 || this.overlayJustification == 0 && (this.axis == 3 || this.axis == 4) ? ci_adj * (this.oneClassValueSize + this.classGutter) : (this.numClasses - ci_adj - 1) * (this.oneClassValueSize + this.classGutter);
                }
                int indent = 0;
                double position = 0.0;
                if (this.indentWeightVar != null && !this.isDataOnHorizontalSide()) {
                    double iw = this.indentWeightVar.value.getValue(i);
                    int n = indent = Double.isNaN(iw) ? 0 : (int)(iw * (double)this.indentPixels);
                }
                if (this.axis == 3 || this.axis == 4) {
                    if (this.isInnerMarginOverlay() || Double.isNaN(this.offsetPosition)) {
                        position = this.overlayJustification == 4 ? (this.numericColumn ? (double)indent + this.xEncoder.getUpperLimit() - (double)this.overlayBase - (double)classOffset - (double)centeringOffset - maxIndentPixels : (double)indent + this.xEncoder.getUpperLimit() - (double)this.overlayBase - (double)this.oneClassValueSize - (double)classOffset + (double)centeringOffset) : (this.numericColumn ? (double)indent + this.xEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.oneClassValueSize + (double)classOffset - (double)centeringOffset - maxIndentPixels : (double)indent + this.xEncoder.getLowerLimit() + (double)this.overlayBase + (double)classOffset + (double)centeringOffset);
                        position += this.numericColumn ? -((double)this.maxValueTextWidth + maxIndentPixels) / 2.0 : ((double)this.maxValueTextWidth + maxIndentPixels) / 2.0;
                    } else {
                        position = this.xEncoder.getLowerLimit() + this.offsetPosition * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) + (double)classOffset;
                    }
                }
                double textWidth = AxisTable.getTextWidth(StatGraph.getFontMetrics(vf), this.valueText != null ? this.valueText.getValue(i) : str);
                xnv[ci].addValue(this.getXPosition(textWidth, this.valueJustify, mappedValue, ALIGN_H_CENTER));
                ynv[ci].addValue(this.getXPosition((double)this.maxValueTextWidth + maxIndentPixels, this.valueJustify, position, this.oneClassValueSize, this.valueHAlign));
                Color c = this.valueAttrs.getAltColor();
                if (cm != null) {
                    c = (Color)cm.get(grp);
                }
                String fontName = this.valueAttrs.getFont().getFamily();
                int style = this.valueAttrs.getFont().getStyle();
                String textGroup = null;
                if (this.textGroupVar != null) {
                    textGroup = this.textGroupVar.formattedValue.getValue(i);
                }
                if (tgAttrMap != null) {
                    if (tgAttrMap.get(textGrp) != null && (ta = tgAttrMap.get(textGroup).getTextAttrs()) != null) {
                        if (ta.getFont() != null) {
                            fontName = ta.getFont().getFamily();
                            style = ta.getFont().getStyle();
                        }
                        if (ta.getColor() != null) {
                            c = ta.getColor();
                        }
                    }
                } else if (cgAttrMap != null && cgAttrMap.get(grp) != null && (ta = cgAttrMap.get(grp).getTextAttrs()) != null && ta.getColor() != null) {
                    c = this.applyDataTransparency(ta.getColor());
                }
                if (c != null && gvc != null && gvc[ci] != null) {
                    gvc[ci].addValue(c);
                }
                if (tgAttrMap != null) {
                    tgFontName[ci].addValue(fontName);
                    tgFontStyle[ci].addValue((double)style);
                }
                if (this.valueText != null) {
                    vals[ci].addValue(this.valueText.getValue(i));
                    continue;
                }
                vals[ci].addValue(str);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        block18: for (int j = 0; j < this.numClasses; ++j) {
            int classOffset;
            String labStr = this.showLabel ? (this.clustering ? this.columnLabel : this.classVals.get(j)) : "";
            int i4 = j;
            if (!(this.uniformPlotSize || this.clustering || this.classOrder != 0 && this.classOrder != 3)) {
                try {
                    i4 = classIndexMap.get(this.classVar.formattedUniqueValue.getValue(j));
                }
                catch (MissingValueException grp) {
                    // empty catch block
                }
            }
            double labelWidth = this.showLabel ? (double)AxisTable.getTextWidth(StatGraph.getFontMetrics(this.labelAttrs.getFont()), labStr) : 0.0;
            this.classLabels[i4] = new RasterLabel();
            this.classLabels[i4].string.setValue(this.showLabel ? labStr : "");
            this.classLabels[i4].setFont(this.labelAttrs.getFont());
            if (this.groupVar != null && this.groupVar.getLabel() == this.classVar.getLabel() && !this.clustering && !this.labelAttrsOverride) {
                if (this.uniformPlotSize) {
                    this.classLabels[i4].color.setValue(labelColor[i4]);
                } else {
                    try {
                        this.classLabels[i4].color.setValue(gvc[i4].getFirstValue());
                    }
                    catch (MissingValueException mve) {
                        this.classLabels[i4].color.setValue(this.labelAttrs.getColor());
                    }
                }
            } else {
                this.classLabels[i4].color.setValue(this.labelAttrs.getColor());
            }
            this.classValues[i4] = new RasterLabel();
            this.classValues[i4].string.connectFrom((StringPipe)vals[i4]);
            if (tgAttrMap != null && !this.valueAttrsOverride) {
                this.classValues[i4].fontName.connectFrom((StringPipe)tgFontName[i4]);
                this.classValues[i4].fontStyle.connectFrom((NumericPipe)tgFontStyle[i4]);
                this.classValues[i4].fontSize.setValue(vf.getSize());
            } else {
                this.classValues[i4].setFont(vf);
            }
            if (this.valueAttrsOverride || this.valueAttrsColorOverride || cm == null && tgAttrMap == null) {
                this.classValues[i4].color.setValue(this.valueAttrs.getColor());
            } else {
                this.classValues[i4].color.connectFrom((ColorPipe)gvc[i4]);
            }
            this.classValues[i4].verticalJustification.setValue(1);
            if (this.clustering) {
                classOffset = 0;
            } else {
                int i_adj = this.classOrder == 3 ? this.numClasses - 1 - i4 : i4;
                classOffset = this.overlayJustification == 1 || this.overlayJustification == 3 || this.overlayJustification == 0 && (this.axis == 3 || this.axis == 4) ? i_adj * (this.oneClassValueSize + this.classGutter) : (this.numClasses - i_adj - 1) * (this.oneClassValueSize + this.classGutter);
            }
            switch (this.axis) {
                case 1: 
                case 2: {
                    this.classValues[i4].horizontalJustification.setValue(this.getGTKJustification(this.valueJustify));
                    this.classValues[i4].coordX.connectFrom((NumericPipe)xnv[i4]);
                    if (this.isInnerMarginOverlay() || Double.isNaN(this.offsetPosition)) {
                        if (this.overlayJustification == 1) {
                            this.classValues[i4].coordY.setValue(this.yEncoder.getUpperLimit() - (double)this.pad.top - (double)this.overlayBase - (double)this.getPreferredHeaderLabelHeight() - (double)(this.oneClassValueSize / 2) - (double)classOffset);
                            this.classLabels[i4].coordY.setValue(this.yEncoder.getUpperLimit() - (double)this.pad.top - (double)this.overlayBase - (double)this.getPreferredHeaderLabelHeight() - (double)(this.oneClassValueSize / 2) - (double)classOffset);
                        } else {
                            this.classValues[i4].coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.pad.bottom + (double)this.overlayBase + (double)(this.oneClassValueSize / 2) + (double)classOffset);
                            this.classLabels[i4].coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.pad.bottom + (double)this.overlayBase + (double)(this.oneClassValueSize / 2) + (double)classOffset);
                        }
                    } else {
                        this.classValues[i4].coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.pad.bottom + this.offsetPosition * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) + (double)classOffset);
                        this.classLabels[i4].coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.pad.bottom + this.offsetPosition * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) + (double)classOffset);
                    }
                    this.classLabels[i4].verticalJustification.setValue(1);
                    if (this.getLabelPositionInUse() == 1) {
                        if (this.labelJustify == ALIGN_H_AUTO) {
                            this.classLabels[i4].horizontalJustification.setValue(2);
                        } else {
                            this.classLabels[i4].horizontalJustification.setValue(this.getGTKJustification(this.labelJustify));
                        }
                        this.classLabels[i4].coordX.setValue(this.getXPosition(labelWidth, this.labelJustify, this.xEncoder.getLowerLimit() - this.alignmentOffsetY, ALIGN_H_RIGHT));
                        continue block18;
                    }
                    if (this.labelJustify == ALIGN_H_AUTO) {
                        this.classLabels[i4].horizontalJustification.setValue(0);
                    } else {
                        this.classLabels[i4].horizontalJustification.setValue(this.getGTKJustification(this.labelJustify));
                    }
                    this.classLabels[i4].coordX.setValue(this.getXPosition(labelWidth, this.labelJustify, this.xEncoder.getUpperLimit() + this.alignmentOffsetY2, ALIGN_H_LEFT));
                    continue block18;
                }
                case 3: 
                case 4: {
                    this.classValues[i4].coordY.connectFrom((NumericPipe)xnv[i4]);
                    this.classValues[i4].coordX.connectFrom((NumericPipe)ynv[i4]);
                    if (this.isInnerMarginOverlay() || Double.isNaN(this.offsetPosition)) {
                        if (this.overlayJustification == 4) {
                            this.classLabels[i4].coordX.setValue(this.getXPosition(labelWidth, this.labelJustify, this.xEncoder.getUpperLimit() - (double)this.overlayBase - (double)(this.oneClassValueSize / 2) - (double)classOffset, this.oneClassValueSize, this.labelHAlign));
                        } else {
                            this.classLabels[i4].coordX.setValue(this.getXPosition(labelWidth, this.labelJustify, this.xEncoder.getLowerLimit() + (double)this.overlayBase + (double)(this.oneClassValueSize / 2) + (double)classOffset, this.oneClassValueSize, this.labelHAlign));
                        }
                    } else {
                        this.classLabels[i4].coordX.setValue(this.getXPosition(labelWidth, this.labelJustify, this.xEncoder.getLowerLimit() + this.offsetPosition * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) + (double)classOffset, this.oneClassValueSize, this.labelHAlign));
                    }
                    this.classValues[i4].horizontalJustification.setValue(this.getGTKJustification(this.valueJustify));
                    this.classLabels[i4].horizontalJustification.setValue(this.getGTKJustification(this.labelJustify));
                    if (this.getLabelPositionInUse() == 1) {
                        this.classLabels[i4].verticalJustification.setValue(0);
                        this.classLabels[i4].coordY.setValue(this.yEncoder.getLowerLimit() - this.alignmentOffsetX);
                        continue block18;
                    }
                    this.classLabels[i4].verticalJustification.setValue(3);
                    if (this.displayGridLabel) {
                        this.classLabels[i4].coordY.setValue(this.yEncoder.getUpperLimit() + this.alignmentOffsetX2 + (double)this.gridLabelTopOffset);
                        continue block18;
                    }
                    this.classLabels[i4].coordY.setValue(this.yEncoder.getUpperLimit() + this.alignmentOffsetX2);
                }
            }
        }
        if (this.displayGridLabel) {
            if (this.axis == 1 || this.axis == 2) {
                if (this.getLabelPositionInUse() == 1) {
                    if (this.gridLabelEntryL != null) {
                        for (i = 0; i < this.classLabels.length; ++i) {
                            this.classLabels[i].transform.translateX.setValue((double)this.gridLabelEntryL.getWidth() - this.xEncoder.getLowerLimit());
                            if (this.overlayJustification == 1) {
                                this.classLabels[i].transform.translateY.setValue((double)this.gridLabelEntryL.getHeight() - this.yEncoder.getUpperLimit());
                                continue;
                            }
                            this.classLabels[i].transform.translateY.setValue(-this.yEncoder.getLowerLimit());
                        }
                        if (this.clustering) {
                            this.gridLabelEntryL.addLabel(new RasterLabel[]{this.classLabels[0]}, this.getID());
                        } else {
                            this.gridLabelEntryL.addLabel(this.classLabels, this.getID());
                        }
                    }
                } else if (this.gridLabelEntryR != null) {
                    for (i = 0; i < this.classLabels.length; ++i) {
                        this.classLabels[i].transform.translateX.setValue(-this.xEncoder.getUpperLimit());
                        if (this.overlayJustification == 1) {
                            this.classLabels[i].transform.translateY.setValue((double)this.gridLabelEntryR.getHeight() - this.yEncoder.getUpperLimit());
                            continue;
                        }
                        this.classLabels[i].transform.translateY.setValue(-this.yEncoder.getLowerLimit());
                    }
                    if (this.clustering) {
                        this.gridLabelEntryR.addLabel(new RasterLabel[]{this.classLabels[0]}, this.getID());
                    } else {
                        this.gridLabelEntryR.addLabel(this.classLabels, this.getID());
                    }
                }
            } else if (this.getLabelPositionInUse() == 1) {
                if (this.gridLabelEntryB != null) {
                    for (i = 0; i < this.classLabels.length; ++i) {
                        if (this.overlayJustification == 3) {
                            this.classLabels[i].transform.translateX.setValue(-this.xEncoder.getLowerLimit());
                        } else {
                            this.classLabels[i].transform.translateX.setValue((double)this.gridLabelEntryB.getWidth() - this.xEncoder.getUpperLimit());
                        }
                        this.classLabels[i].transform.translateY.setValue((double)this.gridLabelEntryB.getHeight() - this.yEncoder.getLowerLimit());
                    }
                    if (this.clustering) {
                        this.gridLabelEntryB.addLabel(new RasterLabel[]{this.classLabels[0]}, this.getID());
                    } else {
                        this.gridLabelEntryB.addLabel(this.classLabels, this.getID());
                    }
                }
            } else if (this.gridLabelEntryT != null) {
                for (i = 0; i < this.classLabels.length; ++i) {
                    if (this.overlayJustification == 3) {
                        this.classLabels[i].transform.translateX.setValue(-this.xEncoder.getLowerLimit());
                    } else {
                        this.classLabels[i].transform.translateX.setValue((double)this.gridLabelEntryT.getWidth() - this.xEncoder.getUpperLimit());
                    }
                    this.classLabels[i].transform.translateY.setValue(-this.yEncoder.getUpperLimit() - (double)this.gridLabelTopOffset);
                }
                if (this.clustering) {
                    this.gridLabelEntryT.addLabel(new RasterLabel[]{this.classLabels[0]}, this.getID());
                } else {
                    this.gridLabelEntryT.addLabel(this.classLabels, this.getID());
                }
            }
        }
    }

    private void createClassIndexMap(Hashtable<String, Integer> classIndexMap) {
        Variable classVar = this.connectCategory((short)1, this.includeMissingClass);
        Variable rawClassVar = this.connectRaw((short)1);
        VariableProcessor vp = new VariableProcessor();
        vp.addVariable(classVar);
        vp.addVariable(rawClassVar);
        if (this.classOrder == 1) {
            vp.setSort(rawClassVar, 1);
        } else if (this.classOrder == 2) {
            vp.setSort(rawClassVar, 2);
        }
        if (!this.includeMissingClass) {
            vp.setWhereExpression("^(" + rawClassVar.getName() + " IS MISSING)");
        }
        this.addCRDWhereClause(vp);
        int n = classVar.getUniqueValueCount();
        for (int i = 0; i < n; ++i) {
            try {
                String cv = classVar.formattedUniqueValue.getValue(i);
                classIndexMap.put(cv, i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    private double getXPosition(double textWidth, int just, double centerX, double width, int align) {
        double x;
        centerX = this.isInnerMarginOverlay() && this.overlayJustification == 4 ? (centerX -= (double)this.pad.right) : (centerX += (double)this.pad.left);
        if (align == ALIGN_H_AUTO) {
            align = just;
        }
        if (align == ALIGN_H_LEFT || align == ALIGN_H_AUTO && !this.numericColumn) {
            x = centerX - width * 0.5;
            if (just == ALIGN_H_RIGHT || just == ALIGN_H_AUTO && this.numericColumn) {
                x += textWidth;
            } else if (just == ALIGN_H_CENTER) {
                x += textWidth * 0.5;
            }
        } else if (align == ALIGN_H_RIGHT || align == ALIGN_H_AUTO && this.numericColumn) {
            x = centerX + width * 0.5;
            if (just == ALIGN_H_LEFT || just == ALIGN_H_AUTO && !this.numericColumn) {
                x -= textWidth;
            } else if (just == ALIGN_H_CENTER) {
                x -= textWidth * 0.5;
            }
        } else {
            x = centerX;
            if (just == ALIGN_H_LEFT || just == ALIGN_H_AUTO && !this.numericColumn) {
                x -= textWidth * 0.5;
            } else if (just == ALIGN_H_RIGHT || just == ALIGN_H_AUTO && this.numericColumn) {
                x += textWidth * 0.5;
            }
        }
        return x;
    }

    private double getXPosition(double textWidth, int just, double pos, int align) {
        if (this.axis == 3 || this.axis == 4) {
            return pos;
        }
        double x = pos;
        if (align == ALIGN_H_CENTER) {
            if (just == ALIGN_H_LEFT) {
                x -= textWidth * 0.5;
            } else if (just == ALIGN_H_RIGHT) {
                x += textWidth * 0.5;
            }
        } else if (align == ALIGN_H_LEFT) {
            if (just == ALIGN_H_RIGHT) {
                x += textWidth;
            } else if (just == ALIGN_H_CENTER) {
                x += textWidth * 0.5;
            }
        } else if (align == ALIGN_H_RIGHT) {
            if (just == ALIGN_H_LEFT) {
                x -= textWidth;
            } else if (just == ALIGN_H_CENTER) {
                x -= textWidth * 0.5;
            }
        }
        return x;
    }

    public int getGTKJustification(int just) {
        if (just == ALIGN_H_LEFT) {
            return 0;
        }
        if (just == ALIGN_H_CENTER) {
            return 1;
        }
        if (just == ALIGN_H_RIGHT) {
            return 2;
        }
        if (just == ALIGN_H_AUTO) {
            if (this.axis == 3 || this.axis == 4) {
                if (this.numericColumn) {
                    return 2;
                }
                return 0;
            }
            return 1;
        }
        return 1;
    }

    private void connectValues() {
        if (this.column == null || this.column.getValueCount() == 0 && !this.displayGridLabel || this.varMapper == null) {
            return;
        }
        this.label = new RasterLabel();
        this.label.setFont(this.labelAttrs.getFont());
        this.label.color.setValue(this.labelAttrs.getColor());
        this.values = new RasterLabel();
        StringVector vals = new StringVector();
        NumericVector positions = new NumericVector();
        NumericVector xPositions = new NumericVector();
        Font valueFont = this.valueAttrs.getFont();
        DiscreteAttrMapper cgDAM = null;
        DiscreteAttributeMap cgAttrMap = null;
        if (this.hasAttrVar("GROUP")) {
            cgDAM = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
            cgDAM.setTextTransparency(this.dataTransparency);
            cgAttrMap = cgDAM.getAttrMap();
        }
        DiscreteAttrMapper tgDAM = null;
        DiscreteAttributeMap tgAttrMap = null;
        if (this.hasAttrVar("TEXTGROUP")) {
            tgDAM = (DiscreteAttrMapper)this.getAttrVarMapper("TEXTGROUP");
            tgDAM.setTextTransparency(this.dataTransparency);
            tgAttrMap = tgDAM.getAttrMap();
        }
        StringVector fontName = new StringVector();
        NumericVector fontStyle = new NumericVector();
        HashMap cm = this.groupVar != null && this.groupColorEncoder != null ? this.groupColorEncoder.getColorList() : null;
        ColorVector gvc = cm != null || tgDAM != null ? new ColorVector() : null;
        int vaStyle = this.valueAttrs.getFont().getStyle();
        double maxIndentPixels = this.maxIndentWeight * this.indentPixels;
        int centeringOffset = 0;
        if ((double)this.maxLabelTextWidth > (double)this.maxValueTextWidth + maxIndentPixels) {
            centeringOffset = (this.maxLabelTextWidth - (this.maxValueTextWidth + (int)maxIndentPixels)) / 2;
        }
        if (!Double.isNaN(this.offsetPosition) && !this.isInnerMarginOverlay()) {
            centeringOffset = 0;
        }
        int valueSize = this.getPreferredValueSize();
        int textAscent = this.getTextBaseLine();
        int textBaseLine = this.numLabelTextLines == 1 && this.numValueTextLines == 1 ? valueSize - textAscent : valueSize / 2;
        Font vf = null;
        vf = this.valueAttrsSizeOverride || this.scaledValueFontSize == 0 || this.scaledValueFontSize == valueFont.getSize() ? valueFont : new Font(valueFont.getFamily(), valueFont.getStyle(), this.scaledValueFontSize);
        for (int i = 0; i < this.var.getValueCount(); ++i) {
            boolean validValue;
            double value = Double.NaN;
            String sval = "";
            String text = "";
            double mappedValue = Double.NaN;
            double xpos = 0.0;
            Color c = this.valueAttrs.getAltColor();
            String fn = this.valueAttrs.getFont().getFamily();
            int fs = this.valueAttrs.getFont().getStyle();
            int indent = 0;
            try {
                if (this.discreteVar) {
                    sval = ((StringVariable)this.var).value.getValue(i);
                } else {
                    value = ((NumericVariable)this.var).value.getValue(i);
                }
                mappedValue = this.varMapper.getValue(i);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            try {
                text = this.valueText != null && i < this.var.getValueCount() ? this.valueText.getValue(i) : this.column.formattedValue.getValue(i).trim();
            }
            catch (MissingValueException e) {
                text = this.numericColumn ? "." : "";
            }
            if (this.numericColumn && text.equals(".")) {
                text = StatGraph.missingOption;
            }
            if (this.rawColumnVar.isMissing(i) && !this.showMissing) {
                text = "";
            }
            try {
                double iw;
                if (this.indentWeightVar != null && !this.isDataOnHorizontalSide() && !Double.isNaN(iw = this.indentWeightVar.value.getValue(i))) {
                    indent = (int)(iw * (double)this.indentPixels);
                }
            }
            catch (MissingValueException iw) {
                // empty catch block
            }
            try {
                TextAttrs ta;
                xpos = 0.0;
                if (this.axis == 3 || this.axis == 4) {
                    if (this.isInnerMarginOverlay() || Double.isNaN(this.offsetPosition)) {
                        xpos = this.overlayJustification == 4 ? (this.numericColumn ? (double)indent + this.xEncoder.getUpperLimit() - (double)this.overlayBase - (double)centeringOffset - maxIndentPixels : (double)indent + this.xEncoder.getUpperLimit() - (double)this.overlayBase - (double)valueSize + (double)centeringOffset) : (this.numericColumn ? (double)indent + this.xEncoder.getLowerLimit() + (double)this.overlayBase + (double)valueSize - (double)centeringOffset - maxIndentPixels : (double)indent + this.xEncoder.getLowerLimit() + (double)this.overlayBase + (double)centeringOffset);
                        xpos += this.numericColumn ? -((double)this.maxValueTextWidth + maxIndentPixels) / 2.0 : ((double)this.maxValueTextWidth + maxIndentPixels) / 2.0;
                    } else {
                        xpos = this.xEncoder.getLowerLimit() + this.offsetPosition * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit());
                    }
                }
                c = this.valueAttrs.getAltColor();
                String textGroup = null;
                if (this.textGroupVar != null) {
                    textGroup = this.textGroupVar.formattedValue.getValue(i);
                }
                fn = this.valueAttrs.getFont().getFamily();
                fs = this.valueAttrs.getFont().getStyle();
                String grp = null;
                if (this.groupVar != null && cm != null) {
                    grp = this.groupVar.formattedValue.getValue(i);
                    c = (Color)cm.get(grp);
                }
                if (tgAttrMap != null) {
                    if (tgAttrMap.get(textGroup) != null && (ta = tgAttrMap.get(textGroup).getTextAttrs()) != null) {
                        if (ta.getFont() != null) {
                            boolean bold;
                            fn = ta.getFont().getFamily();
                            fs = ta.getFont().getStyle();
                            boolean bl = this.valueAttrsWeightOverride ? (vaStyle & 1) > 0 : (bold = (fs & 1) > 0);
                            boolean italic = this.valueAttrsStyleOverride ? (vaStyle & 2) > 0 : (fs & 2) > 0;
                            fs = 0 | (bold ? 1 : 0) | (italic ? 2 : 0);
                        }
                        if (ta.getColor() != null) {
                            c = ta.getColor();
                        }
                    }
                } else if (cgAttrMap != null && cgAttrMap.get(grp) != null && (ta = cgAttrMap.get(grp).getTextAttrs()) != null && ta.getColor() != null) {
                    c = ta.getColor();
                }
            }
            catch (MissingValueException textGroup) {
                // empty catch block
            }
            boolean bl = this.discreteVar ? (StatGraph.includeMissingDiscrete ? true : sval.length() > 0) : (validValue = !Double.isNaN(value));
            if (!validValue || text.length() <= 0) continue;
            double textWidth = AxisTable.getTextWidth(StatGraph.getFontMetrics(vf), text);
            vals.addValue(text);
            positions.addValue(this.getXPosition(textWidth, this.valueJustify, mappedValue, ALIGN_H_CENTER));
            xPositions.addValue(this.getXPosition((double)this.maxValueTextWidth + maxIndentPixels, this.valueJustify, xpos, valueSize, this.valueHAlign));
            if (gvc != null && c != null) {
                gvc.addValue(c);
            }
            fontName.addValue(fn);
            fontStyle.addValue((double)fs);
        }
        this.values.string.connectFrom((StringPipe)vals);
        if (tgAttrMap != null && !this.valueAttrsOverride) {
            if (this.valueAttrsFontFamilyOverride) {
                this.values.fontName.setValue(valueFont.getName());
            } else {
                this.values.fontName.connectFrom((StringPipe)fontName);
            }
            this.values.fontStyle.connectFrom((NumericPipe)fontStyle);
            this.values.fontSize.setValue(vf.getSize());
        } else {
            this.values.setFont(vf);
        }
        if (gvc != null && !this.valueAttrsColorOverride) {
            this.values.color.connectFrom((ColorPipe)gvc);
        } else {
            this.values.color.setValue(this.valueAttrs.getColor());
        }
        this.label.string.setValue(this.columnLabel);
        this.values.verticalJustification.setValue(1);
        double labelWidth = AxisTable.getTextWidth(StatGraph.getFontMetrics(this.labelAttrs.getFont()), this.columnLabel);
        switch (this.axis) {
            case 1: 
            case 2: {
                this.values.horizontalJustification.setValue(this.getGTKJustification(this.valueJustify));
                this.values.coordX.connectFrom((NumericPipe)positions);
                if (this.getLabelPositionInUse() == 1) {
                    if (this.labelJustify == ALIGN_H_AUTO) {
                        this.label.horizontalJustification.setValue(2);
                    } else {
                        this.label.horizontalJustification.setValue(this.getGTKJustification(this.labelJustify));
                    }
                    this.label.coordX.setValue(this.getXPosition(labelWidth, this.labelJustify, this.xEncoder.getLowerLimit() - this.alignmentOffsetY, ALIGN_H_RIGHT));
                } else {
                    if (this.labelJustify == ALIGN_H_AUTO) {
                        this.label.horizontalJustification.setValue(0);
                    } else {
                        this.label.horizontalJustification.setValue(this.getGTKJustification(this.labelJustify));
                    }
                    this.label.coordX.setValue(this.getXPosition(labelWidth, this.labelJustify, this.xEncoder.getUpperLimit() + this.alignmentOffsetY2, ALIGN_H_LEFT));
                }
                this.label.verticalJustification.setValue(1);
                if (this.isInnerMarginOverlay() || Double.isNaN(this.offsetPosition)) {
                    if (this.overlayJustification == 1) {
                        int headerHeight = this.getPreferredHeaderLabelHeight();
                        this.values.coordY.setValue(this.yEncoder.getUpperLimit() - (double)this.pad.top - (double)this.overlayBase - (double)(valueSize / 2) - (double)headerHeight);
                        this.label.coordY.setValue(this.yEncoder.getUpperLimit() - (double)this.pad.top - (double)this.overlayBase - (double)(valueSize / 2) - (double)headerHeight);
                        break;
                    }
                    this.values.coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.pad.bottom + (double)this.overlayBase + (double)(valueSize / 2));
                    this.label.coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.pad.bottom + (double)this.overlayBase + (double)(valueSize / 2));
                    break;
                }
                this.values.coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.pad.bottom + this.offsetPosition * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()));
                this.label.coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.pad.bottom + this.offsetPosition * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()));
                break;
            }
            case 3: 
            case 4: {
                this.values.coordY.connectFrom((NumericPipe)positions);
                this.values.coordX.connectFrom((NumericPipe)xPositions);
                if (this.isInnerMarginOverlay() || Double.isNaN(this.offsetPosition)) {
                    if (this.overlayJustification == 4) {
                        this.label.coordX.setValue(this.getXPosition(labelWidth, this.labelJustify, this.xEncoder.getUpperLimit() - (double)this.overlayBase - (double)(valueSize / 2), valueSize, this.labelHAlign));
                    } else {
                        this.label.coordX.setValue(this.getXPosition(labelWidth, this.labelJustify, this.xEncoder.getLowerLimit() + (double)this.overlayBase + (double)(valueSize / 2), valueSize, this.labelHAlign));
                    }
                } else {
                    this.label.coordX.setValue(this.getXPosition(labelWidth, this.labelJustify, this.xEncoder.getLowerLimit() + this.offsetPosition * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()), valueSize, this.labelHAlign));
                }
                this.values.horizontalJustification.setValue(this.getGTKJustification(this.valueJustify));
                this.label.horizontalJustification.setValue(this.getGTKJustification(this.labelJustify));
                if (this.getLabelPositionInUse() == 1) {
                    this.label.verticalJustification.setValue(0);
                    this.label.coordY.setValue(this.yEncoder.getLowerLimit() - this.alignmentOffsetX);
                    break;
                }
                this.label.verticalJustification.setValue(3);
                if (this.displayGridLabel) {
                    this.label.coordY.setValue(this.yEncoder.getUpperLimit() + this.alignmentOffsetX2 + (double)this.gridLabelTopOffset);
                    break;
                }
                this.label.coordY.setValue(this.yEncoder.getUpperLimit() + this.alignmentOffsetX2);
            }
        }
        if (this.displayGridLabel) {
            if (this.axis == 1 || this.axis == 2) {
                if (this.getLabelPositionInUse() == 1) {
                    if (this.gridLabelEntryL != null) {
                        this.label.transform.translateX.setValue((double)this.gridLabelEntryL.getWidth() - this.xEncoder.getLowerLimit());
                        if (this.overlayJustification == 1) {
                            this.label.transform.translateY.setValue((double)this.gridLabelEntryL.getHeight() - this.yEncoder.getUpperLimit());
                        } else {
                            this.label.transform.translateY.setValue(-this.yEncoder.getLowerLimit());
                        }
                        this.gridLabelEntryL.addLabel(new RasterLabel[]{this.label}, this.getID());
                    }
                } else if (this.gridLabelEntryR != null) {
                    this.label.transform.translateX.setValue(-this.xEncoder.getUpperLimit());
                    if (this.overlayJustification == 1) {
                        this.label.transform.translateY.setValue((double)this.gridLabelEntryR.getHeight() - this.yEncoder.getUpperLimit());
                    } else {
                        this.label.transform.translateY.setValue(-this.yEncoder.getLowerLimit());
                    }
                    this.gridLabelEntryR.addLabel(new RasterLabel[]{this.label}, this.getID());
                }
            } else if (this.getLabelPositionInUse() == 1) {
                if (this.gridLabelEntryB != null) {
                    if (this.overlayJustification == 3) {
                        this.label.transform.translateX.setValue(-this.xEncoder.getLowerLimit());
                    } else {
                        this.label.transform.translateX.setValue((double)this.gridLabelEntryB.getWidth() - this.xEncoder.getUpperLimit());
                    }
                    this.label.transform.translateY.setValue((double)this.gridLabelEntryB.getHeight() - this.yEncoder.getLowerLimit());
                    this.gridLabelEntryB.addLabel(new RasterLabel[]{this.label}, this.getID());
                }
            } else if (this.gridLabelEntryT != null) {
                if (this.overlayJustification == 3) {
                    this.label.transform.translateX.setValue(-this.xEncoder.getLowerLimit());
                } else {
                    this.label.transform.translateX.setValue((double)this.gridLabelEntryT.getWidth() - this.xEncoder.getUpperLimit());
                }
                this.label.transform.translateY.setValue(-this.yEncoder.getUpperLimit() - (double)this.gridLabelTopOffset);
                this.gridLabelEntryT.addLabel(new RasterLabel[]{this.label}, this.getID());
            }
        }
    }

    private boolean connectVarMapper(PositionEncoder encoder) {
        NumericMap map = (NumericMap)encoder.getValueMap();
        if (map == null) {
            return false;
        }
        if (map instanceof StringToNumericMap) {
            if (this.varMapper == null || !(this.varMapper instanceof StringToNumericMapper)) {
                this.varMapper = new StringToNumericMapper();
            }
            StringToNumericMapper stnmapper = (StringToNumericMapper)this.varMapper;
            stnmapper.input.disconnect();
            stnmapper.input.connectFrom(this.var.formattedValue);
            stnmapper.setMap((StringToNumericMap)map);
            stnmapper.init(new AInitAction(null));
        } else if (map instanceof StringToNumberMap) {
            if (this.varMapper == null || !(this.varMapper instanceof StringToNumberMapper)) {
                this.varMapper = new StringToNumberMapper();
            }
            StringToNumberMapper stnmapper = (StringToNumberMapper)this.varMapper;
            stnmapper.input.disconnect();
            stnmapper.input.connectFrom(this.var.formattedValue);
            stnmapper.setMap((StringToNumberMap)map);
            stnmapper.init(new AInitAction(null));
        } else if (map instanceof ContinuousRangeToNumericMap && this.var instanceof NumericVariable) {
            if (this.varMapper == null || !(this.varMapper instanceof ContinuousRangeToNumericMapper)) {
                this.varMapper = new ContinuousRangeToNumericMapper();
            }
            ContinuousRangeToNumericMapper crtnMapper = (ContinuousRangeToNumericMapper)this.varMapper;
            crtnMapper.input.disconnect();
            crtnMapper.input.connectFrom(((NumericVariable)this.var).value);
            if (encoder instanceof BrokenPositionEncoder) {
                crtnMapper.setMap((ContinuousRangeToNumericMap)((BrokenPositionEncoder)encoder).getBrokenValueMap());
            } else {
                crtnMapper.setMap((ContinuousRangeToNumericMap)map);
            }
            crtnMapper.init(new AInitAction(null));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 17) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.groupColorEncoder)) {
                return;
            }
            this.groupColorEncoder = (ColorEncoder)encoder;
        }
        this.needConnect = true;
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        this.getPreferredValueSize();
        double dist = 0.0;
        double extraSpace = 0.0;
        if (this.clustering) {
            double stride;
            int n;
            ValueMap vm;
            if (this.isDataOnHorizontalSide()) {
                vm = this.xEncoder.getValueMap();
                n = ((StringToNumericMap)vm).getUniqueValueCount();
                stride = (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) / (double)n;
            } else {
                vm = this.yEncoder.getValueMap();
                n = ((StringToNumericMap)vm).getUniqueValueCount();
                stride = (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) / (double)n;
            }
            if (n == 1) {
                stride *= 0.25;
            }
            int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
            double oneValueSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
            dist = ((double)maxGroups / 2.0 - 0.5) * oneValueSize;
            extraSpace = stride * 0.5 - dist;
        }
        block1 : switch (dimension) {
            case 1: {
                switch (this.axis) {
                    case 1: 
                    case 2: {
                        if (this.valueText != null) {
                            return (Math.max(extraSpace, (double)this.maxValueTextWidth * 0.5) + dist) * 2.0 + (double)this.gap;
                        }
                        FontMetrics vfm = StatGraph.getFontMetrics(this.valueAttrs.getFont());
                        int textWidth = 0;
                        for (int i = 0; i < this.column.getValueCount(); ++i) {
                            String str = "";
                            try {
                                str = this.column.formattedValue.getValue(i);
                            }
                            catch (MissingValueException missingValueException) {
                                // empty catch block
                            }
                            if (this.numericColumn && str.equals(".")) {
                                str = StatGraph.missingOption;
                            }
                            if (this.rawColumnVar.isMissing(i) && !this.showMissing) {
                                str = "";
                            }
                            textWidth = Math.max(textWidth, vfm.stringWidth(str));
                        }
                        return (Math.max(extraSpace, (double)textWidth * 0.5) + dist) * 2.0 + (double)this.gap;
                    }
                }
                break;
            }
            case 2: {
                switch (this.axis) {
                    case 1: 
                    case 2: {
                        break block1;
                    }
                    case 3: 
                    case 4: {
                        FontMetrics vfm = StatGraph.getFontMetrics(this.valueAttrs.getFont());
                        return (Math.max(extraSpace, (double)vfm.getHeight() * 0.5) + dist) * 2.0 + (double)this.gap;
                    }
                }
            }
        }
        return super.getPreferredOffset(dimension);
    }

    @Override
    public Insets getGridLabelMargin() {
        if (this.displayGridLabel) {
            return this.getLabelMargin();
        }
        return super.getGridLabelMargin();
    }

    @Override
    public Insets getPreferredOuterMargin() {
        if (this.displayGridLabel) {
            return new Insets(0, 0, 0, 0);
        }
        return this.getLabelMargin();
    }

    private Insets getLabelMargin() {
        if (this.column == null) {
            return super.getPreferredOuterMargin();
        }
        FontMetrics lfm = StatGraph.getFontMetrics(this.labelAttrs.getFont());
        int w = 0;
        int h = 0;
        if (this.showLabel) {
            if (this.classVar != null && !this.clustering) {
                if (this.classVals != null && this.classVals.size() > 0) {
                    for (int i = 0; i < this.classVals.size(); ++i) {
                        String lab = this.classVals.get(i);
                        w = Math.max(w, AxisTable.getTextWidth(lfm, lab));
                    }
                } else {
                    int n = this.classVar.getUniqueValueCount();
                    for (int i = 0; i < n; ++i) {
                        try {
                            String v = ((StringVariable)this.classVar).uniqueValue.getValue(i);
                            w = Math.max(w, lfm.stringWidth(v));
                            continue;
                        }
                        catch (MissingValueException missingValueException) {
                            // empty catch block
                        }
                    }
                }
            } else if (this.columnLabel != null) {
                w = AxisTable.getTextWidth(lfm, this.columnLabel);
            } else {
                String colLabel = this.labelString == null ? this.column.getLabel() : this.labelString;
                w = lfm.stringWidth(colLabel);
            }
            h = lfm.getHeight() * this.numLabelTextLines;
        }
        Insets prefOM = (Insets)super.getPreferredOuterMargin().clone();
        int top = 0;
        switch (this.axis) {
            default: {
                if (this.getLabelPositionInUse() == 1) {
                    prefOM.left = w == 0 ? 0 : w + (int)this.alignmentOffsetY + this.gap;
                    break;
                }
                prefOM.right = w == 0 ? 0 : w + (int)this.alignmentOffsetY2 + this.gap;
                break;
            }
            case 3: 
            case 4: {
                if (this.getLabelPositionInUse() == 1) {
                    prefOM.bottom = h == 0 ? 0 : h + (int)this.alignmentOffsetX + this.gap;
                } else {
                    int n = top = h == 0 ? 0 : h + (int)this.alignmentOffsetX2 + this.gap;
                }
                if (this.showHeader) {
                    top += this.getPreferredHeaderLabelHeight();
                }
                prefOM.top = top;
            }
        }
        return prefOM;
    }

    @Override
    public boolean isOneDimensional() {
        return true;
    }

    @Override
    public boolean isDataOnHorizontalSide() {
        return this.axis == 1 || this.axis == 2;
    }

    @Override
    public int getOverlayMargin() {
        return this.getPreferredSizeOnDataLessSide();
    }

    @Override
    public int getPreferredSizeOnDataLessSide() {
        if (this.var == null || this.var.getValueCount() == 0 && !this.uniformPlotSize || this.column == null || this.column.getValueCount() == 0 && !this.uniformPlotSize) {
            return 0;
        }
        return this.getPreferredSize();
    }

    private int getPreferredSize() {
        int size = this.getPreferredValueSize();
        size = this.isDataOnHorizontalSide() ? (size += this.pad.top + this.pad.bottom) : (size += this.pad.left + this.pad.right);
        if (this.axis == 1 || this.axis == 2) {
            size += this.getPreferredHeaderLabelHeight();
        }
        return size;
    }

    private int getPreferredHeaderLabelHeight() {
        if ((this.showHeader || this.uniformPlotSize) && this.fittedHeaderLabel != null) {
            FontMetrics fm = StatGraph.getFontMetrics(this.headerLabelAttrs.getFont());
            int g = this.isDataOnHorizontalSide() ? this.gap / 2 : this.gap;
            return this.numHeaderTextLines * fm.getHeight() + g;
        }
        return 0;
    }

    private FontMetrics getValueFontMetrics(Variable textGroupVar, FontMetrics vfmFromStyle, int obs) {
        TextAttrs ta;
        DiscreteAttrMapper tgDAM = null;
        DiscreteAttributeMap tgAttrMap = null;
        if (this.hasAttrVar("TEXTGROUP")) {
            tgDAM = (DiscreteAttrMapper)this.getAttrVarMapper("TEXTGROUP");
            tgDAM.setTextTransparency(this.dataTransparency);
            tgAttrMap = tgDAM.getAttrMap();
        }
        String textGroup = null;
        if (textGroupVar != null) {
            try {
                textGroup = textGroupVar.formattedValue.getValue(obs);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if (tgAttrMap == null || textGroup == null) {
            return vfmFromStyle;
        }
        FontMetrics vfm = vfmFromStyle;
        if (tgAttrMap.get(textGroup) != null && (ta = tgAttrMap.get(textGroup).getTextAttrs()) != null && ta.getFont() != null) {
            boolean bold;
            String fn = ta.getFont().getFamily();
            int fs = ta.getFont().getStyle();
            int vaStyle = this.valueAttrs.getFont().getStyle();
            boolean bl = this.valueAttrsWeightOverride ? (vaStyle & 1) > 0 : (bold = (fs & 1) > 0);
            boolean italic = this.valueAttrsStyleOverride ? (vaStyle & 2) > 0 : (fs & 2) > 0;
            fs = 0 | (bold ? 1 : 0) | (italic ? 2 : 0);
            vfm = StatGraph.getFontMetrics(fn, fs, this.valueAttrs.getFont().getSize());
        }
        return vfm;
    }

    private int getPreferredValueSize() {
        StringBuffer sb;
        int j;
        int i;
        Font valueFont = this.valueAttrs.getFont();
        Font labelFont = this.labelAttrs.getFont();
        FontMetrics vfm = StatGraph.getFontMetrics(valueFont);
        FontMetrics lfm = StatGraph.getFontMetrics(labelFont);
        FontMetrics hfm = StatGraph.getFontMetrics(this.headerLabelAttrs.getFont());
        boolean splitAlways = this.dataLabelFitPolicy == DATALABEL_FIT_SPLITALWAYS;
        Variable var = this.var;
        Variable classVar = this.classVar;
        Variable rawClassVar = this.rawClassVar;
        Variable column = this.column;
        Variable rawColumnVar = this.rawColumnVar;
        Variable textGroupVar = this.textGroupVar;
        if (this.uniformPlotSize) {
            var = !this.discreteVar ? this.connectRaw((short)114) : this.connectCategory((short)114, StatGraph.includeMissingDiscrete);
            if (this.numericColumn || this.valueFormat != null) {
                rawColumnVar = column = this.connectRaw((short)115);
                if (this.valueFormat != null) {
                    if (this.numericColumn && !this.valueFormat.isCharacterFormat() || !this.numericColumn && this.valueFormat.isCharacterFormat()) {
                        column.setFormat(new GTKFormat((Format)this.valueFormat));
                    }
                } else {
                    SASFormat fmt = this.getFormat(115);
                    if (fmt != null && fmt.getFormatDescription().isDecimalWidthSupported()) {
                        int w = fmt.getFormatDescription().getMaxWidth();
                        int d = fmt.getDecimalWidth();
                        fmt = SASFormat.getInstance((String)(fmt.getBaseFormatName() + Integer.toString(w).trim() + "." + Integer.toString(d).trim()));
                        fmt.setInsertBlanks(false);
                        column.setFormat(new GTKFormat((Format)fmt));
                    }
                }
            } else {
                column = this.connectCategory((short)115, true);
                rawColumnVar = this.connectRaw((short)115);
            }
            if (textGroupVar != null) {
                textGroupVar = this.connectCategory((short)116, this.includeMissingGroup);
            }
            if (classVar != null) {
                classVar = this.connectCategory((short)1, this.includeMissingClass);
                rawClassVar = this.connectRaw((short)1);
                if (this.classOrder == 1) {
                    rawClassVar.setUniqueValueSort(1);
                } else if (this.classOrder == 2) {
                    rawClassVar.setUniqueValueSort(2);
                }
                rawClassVar.setSortByFormattedValues(!this.numericClass);
                if (!this.includeMissingClass) {
                    VariableProcessor vp = new VariableProcessor();
                    vp.addVariable(column);
                    vp.addVariable(rawColumnVar);
                    vp.addVariable(classVar);
                    vp.addVariable(rawClassVar);
                    if (textGroupVar != null) {
                        vp.addVariable(textGroupVar);
                    }
                    vp.setWhereExpression("^(" + rawClassVar.getName() + " IS MISSING)");
                }
            }
        }
        int textWidth = 0;
        if (this.showLabel || this.labelToGridLabel) {
            if (classVar != null && !this.clustering) {
                for (int cv = 0; cv < classVar.getUniqueValueCount(); ++cv) {
                    try {
                        String lab = classVar.formattedUniqueValue.getValue(cv);
                        String[] sl = AxisTable.splitLabel(lab, true, 2.147483647E9, this.dataLabelSplitCharDrop, this.dataLabelSplitChar, lfm);
                        if (sl.length >= 2 || !sl[0].equals(lab)) {
                            for (int i2 = 0; i2 < sl.length; ++i2) {
                                textWidth = Math.max(lfm.stringWidth(sl[i2]), textWidth);
                            }
                            continue;
                        }
                        textWidth = Math.max(lfm.stringWidth(lab), textWidth);
                        continue;
                    }
                    catch (MissingValueException lab) {
                        // empty catch block
                    }
                }
            } else {
                String colLabel = this.labelString == null ? column.getLabel() : this.labelString;
                String[] sl = AxisTable.splitLabel(colLabel, true, 2.147483647E9, this.dataLabelSplitCharDrop, this.dataLabelSplitChar, lfm);
                if (sl.length >= 2 || !sl[0].equals(colLabel)) {
                    for (int i3 = 0; i3 < sl.length; ++i3) {
                        textWidth = Math.max(lfm.stringWidth(sl[i3]), textWidth);
                    }
                } else {
                    textWidth = lfm.stringWidth(colLabel);
                    this.columnLabel = colLabel;
                    this.numLabelTextLines = 1;
                }
            }
        }
        this.maxLabelTextWidth = textWidth;
        int numTextLines = 1;
        double stride = Double.MAX_VALUE;
        if (!this.numericVar) {
            switch (this.axis) {
                default: {
                    if (this.xEncoder != null) {
                        stride = ((StringToNumericMap)this.xEncoder.getValueMap()).getStrideValue();
                        if (this.clustering) {
                            int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                            stride = Math.round(stride * this.clusterWidth / (double)maxGroups);
                        }
                    }
                    if (this.valueText == null) break;
                    this.valueText.removeAllValues();
                }
                case 3: 
                case 4: 
            }
        }
        this.scaledValueFontSize = valueFont.getSize();
        this.maxValueTextWidth = 0;
        boolean splitTextRequired = false;
        FontMetrics vfmFromStyle = vfm;
        if (this.userValueTextWidth > 0) {
            this.maxValueTextWidth = this.userValueTextWidth;
        } else if (this.uniformPlotSize && this.numericColumn && !this.isDataOnHorizontalSide() && this.model.allWhereExpressions != null) {
            if (this.maxValueTextWidthN != -1) {
                this.maxValueTextWidth = this.maxValueTextWidthN;
            } else {
                for (i = 0; i < this.model.allWhereExpressions.length; ++i) {
                    if (this.model.allWhereExpressions[i] == null) continue;
                    VariableProcessor vp = new VariableProcessor();
                    vp.addGroupVariable(var);
                    if (classVar != null) {
                        vp.addVariable(classVar, 0);
                        vp.addGroupVariable(rawClassVar);
                        if (!this.includeMissingClass) {
                            vp.setWhereExpression("^(" + rawClassVar.getName() + " IS MISSING)");
                            this.whereRoles = new int[]{1};
                        }
                    }
                    int columnStat = this.numericColumn ? (this.stat == -1 ? 6 : this.stat) : 12;
                    vp.addVariable(column, columnStat);
                    if (textGroupVar != null) {
                        vp.addVariable(textGroupVar, 0);
                    }
                    for (int j2 = 0; j2 < this.model.whereVars.length; ++j2) {
                        StringVectorVariable sv;
                        if (this.model.whereVars[j2] == null) continue;
                        Object object = sv = this.model.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                        if (this.model.whereVarsOnSeparateModel) {
                            DataModel dm = this.model.getSrcModel();
                            int wcol = dm.getColumn(this.model.whereVars[j2].getName());
                            sv.setName(this.model.whereVars[j2].getName());
                            sv.connectFrom(dm.getColumnAsClassColumn(wcol, this.model.whereIncludeMissingClass));
                        } else {
                            sv.connectFrom(this.model.whereVars[j2]);
                        }
                        vp.addVariable((Variable)sv);
                    }
                    String curWhere = vp.getWhereExpression();
                    if (curWhere != null) {
                        vp.setWhereExpression("(" + curWhere + ") & (" + this.model.allWhereExpressions[i] + ")");
                    } else {
                        vp.setWhereExpression(this.model.allWhereExpressions[i]);
                    }
                    if (!vp.isWhereExpressionValid()) {
                        StatGraph.printDebug("Invalid where cluase: " + vp.getWhereExpression());
                    }
                    for (j = 0; j < column.getValueCount(); ++j) {
                        if (textGroupVar != null) {
                            vfm = this.getValueFontMetrics(textGroupVar, vfmFromStyle, j);
                        }
                        String str = "";
                        try {
                            str = column.formattedValue.getValue(j).trim();
                        }
                        catch (MissingValueException missingValueException) {
                            // empty catch block
                        }
                        if (this.numericColumn && str.equals(".")) {
                            str = StatGraph.missingOption;
                        }
                        if (rawColumnVar.isMissing(j) && !this.showMissing) {
                            str = "";
                        }
                        this.maxValueTextWidth = Math.max(this.maxValueTextWidth, vfm.stringWidth(str));
                    }
                }
                this.maxValueTextWidthN = this.maxValueTextWidth;
            }
        } else {
            for (i = 0; i < column.getValueCount(); ++i) {
                if (textGroupVar != null) {
                    vfm = this.getValueFontMetrics(textGroupVar, vfmFromStyle, i);
                }
                String str = "";
                try {
                    str = column.formattedValue.getValue(i).trim();
                }
                catch (MissingValueException columnStat) {
                    // empty catch block
                }
                if (this.numericColumn && str.equals(".")) {
                    str = StatGraph.missingOption;
                }
                if (rawColumnVar.isMissing(i) && !this.showMissing) {
                    str = "";
                }
                if (!(this.uniformPlotSize || this.numericColumn || this.numericVar || this.dataLabelFitPolicy != DATALABEL_FIT_AUTO && this.dataLabelFitPolicy != DATALABEL_FIT_SPLIT && !splitAlways || !this.isDataOnHorizontalSide())) {
                    if (this.valueText == null) {
                        this.valueText = new StringVector();
                    }
                    String[] labs = null;
                    if ((double)vfm.stringWidth(str) > stride) {
                        labs = AxisTable.splitLabel(str, splitAlways, stride, this.dataLabelSplitCharDrop, this.dataLabelSplitChar, vfm);
                    }
                    if (!(labs == null || labs.length < 2 && labs[0].equals(str))) {
                        numTextLines = Math.max(numTextLines, labs.length);
                        sb = new StringBuffer();
                        for (j = 0; j < labs.length; ++j) {
                            if (j > 0) {
                                sb.append('\n');
                            }
                            sb.append(labs[j]);
                            this.maxValueTextWidth = Math.max(this.maxValueTextWidth, vfm.stringWidth(labs[j]));
                        }
                        this.valueText.addValue(sb.toString());
                        splitTextRequired = true;
                        continue;
                    }
                    this.valueText.addValue(str);
                    this.maxValueTextWidth = Math.max(this.maxValueTextWidth, vfm.stringWidth(str));
                    continue;
                }
                if (this.isDataOnHorizontalSide()) continue;
                this.maxValueTextWidth = Math.max(this.maxValueTextWidth, vfm.stringWidth(str));
            }
        }
        if (!splitTextRequired) {
            this.valueText = null;
        }
        if (!this.isDataOnHorizontalSide()) {
            textWidth = Math.max(textWidth, this.maxValueTextWidth + this.maxIndentWeight * this.indentPixels);
        }
        if (!this.isDataOnHorizontalSide() && this.headerLabel != null) {
            String[] labs;
            double splitWidth = textWidth;
            if (classVar != null && !this.clustering) {
                splitWidth = textWidth * classVar.getUniqueValueCount() + this.classGutter * (classVar.getUniqueValueCount() - 1);
            }
            if ((labs = AxisTable.splitLabel(this.headerLabel, false, splitWidth, this.dataLabelSplitCharDrop, this.dataLabelSplitChar, hfm)).length >= 2 || !labs[0].equals(this.headerLabel)) {
                this.numHeaderTextLines = labs.length;
                sb = new StringBuffer();
                for (j = 0; j < labs.length; ++j) {
                    if (j > 0) {
                        sb.append('\n');
                    }
                    sb.append(labs[j]);
                }
                this.fittedHeaderLabel = sb.toString();
                this.headerSplit = true;
            } else {
                this.fittedHeaderLabel = this.headerLabel;
            }
        }
        this.numLabelTextLines = 1;
        if (this.showLabel || this.labelToGridLabel) {
            if (classVar != null && !this.clustering) {
                this.classVals = new Vector();
                for (int cv = 0; cv < rawClassVar.getUniqueValueCount(); ++cv) {
                    String lab;
                    try {
                        lab = rawClassVar.formattedUniqueValue.getValue(cv);
                        lab = lab.trim();
                        if (this.numericClass) {
                            if (lab == null || lab.equals(".")) {
                                lab = StatGraph.missingOption;
                            }
                        } else if (lab == null || lab.length() == 0) {
                            lab = StatGraph.missingCharacter;
                        }
                    }
                    catch (MissingValueException e) {
                        lab = this.numericClass ? StatGraph.missingOption : StatGraph.missingCharacter;
                    }
                    String[] sl = AxisTable.splitLabel(lab, false, this.isDataOnHorizontalSide() ? this.labelMaxWidth : (double)textWidth, this.dataLabelSplitCharDrop, this.dataLabelSplitChar, lfm);
                    if (sl.length >= 2 || !sl[0].equals(lab)) {
                        String classVal = "";
                        for (int i4 = 0; i4 < sl.length; ++i4) {
                            if (i4 > 0) {
                                classVal = classVal + "\n";
                            }
                            classVal = classVal + sl[i4];
                        }
                        this.classVals.add(classVal);
                        this.numLabelTextLines = Math.max(this.numLabelTextLines, sl.length);
                        continue;
                    }
                    this.classVals.add(lab);
                }
            } else {
                String colLabel = this.labelString == null ? column.getLabel() : this.labelString;
                String[] sl = AxisTable.splitLabel(colLabel, false, this.isDataOnHorizontalSide() ? this.labelMaxWidth : (double)textWidth, this.dataLabelSplitCharDrop, this.dataLabelSplitChar, lfm);
                this.columnLabel = "";
                for (int i5 = 0; i5 < sl.length; ++i5) {
                    if (i5 > 0) {
                        this.columnLabel = this.columnLabel + "\n";
                    }
                    this.columnLabel = this.columnLabel + sl[i5];
                }
                this.numLabelTextLines = sl.length;
            }
        }
        int prefSize = 0;
        if (this.isDataOnHorizontalSide()) {
            int prefLabelSize = this.showLabel || this.labelToGridLabel ? this.numLabelTextLines * lfm.getHeight() : 0;
            int prefValueSize = numTextLines * vfm.getHeight();
            prefSize = Math.max(prefValueSize, prefLabelSize) + (numTextLines + 1) * this.vGap;
        } else {
            prefSize = textWidth;
        }
        if (classVar != null) {
            this.oneClassValueSize = prefSize;
            if (!this.clustering) {
                prefSize = prefSize * classVar.getUniqueValueCount() + this.classGutter * (classVar.getUniqueValueCount() - 1);
            }
        }
        this.numValueTextLines = numTextLines;
        return prefSize;
    }

    private int getTextBaseLine() {
        FontMetrics vfm = StatGraph.getFontMetrics(this.valueAttrs.getFont());
        FontMetrics lfm = StatGraph.getFontMetrics(this.labelAttrs.getFont());
        return Math.max(vfm.getAscent(), this.showLabel || this.labelToGridLabel ? lfm.getAscent() : 0);
    }

    public TextAttrs getValueAttrs() {
        return this.valueAttrs;
    }

    public void setValueAttrs(TextAttrs valueAttrs) {
        this.valueAttrs = valueAttrs;
        this.valueAttrs.setColor(this.applyDataTransparency((ColorAttr)this.valueAttrs));
    }

    public TextAttrs getLabelAttrs() {
        return this.labelAttrs;
    }

    public void setLabelAttrs(TextAttrs labelAttrs) {
        this.labelAttrs = labelAttrs;
        this.labelAttrs.setColor(this.applyDataTransparency((ColorAttr)this.labelAttrs));
    }

    public LineAttrs getGridAttrs() {
        return this.gridAttrs;
    }

    public void setGridAttrs(LineAttrs gridAttrs) {
        this.gridAttrs = gridAttrs;
    }

    public double getOffsetPosition() {
        return this.offsetPosition;
    }

    public void setOffsetPosition(double position) {
        if (Double.isNaN(position) || position < 0.0 || position > 1.0) {
            return;
        }
        this.offsetPosition = position;
    }

    public TextAttrs getHeaderLabelAttrs() {
        return this.headerLabelAttrs;
    }

    public void setHeaderLabelAttrs(TextAttrs headerLabelAttrs) {
        this.headerLabelAttrs = headerLabelAttrs;
        headerLabelAttrs.setColor(this.applyDataTransparency((ColorAttr)this.headerLabelAttrs));
    }

    public String getHeaderLabel() {
        return this.headerLabel;
    }

    public void setHeaderLabel(String headerLabel) {
        this.headerLabel = headerLabel;
        this.fittedHeaderLabel = headerLabel;
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(int labelPosition) {
        this.labelPosition = labelPosition;
    }

    public void setValueAttrsOverride(boolean valueAttrsOverride) {
        this.valueAttrsOverride = valueAttrsOverride;
    }

    public void setValueAttrsColorOverride(boolean valueAttrsColorOverride) {
        this.valueAttrsColorOverride = valueAttrsColorOverride;
    }

    public void setValueAttrsWeightOverride(boolean valueAttrsWeightOverride) {
        this.valueAttrsWeightOverride = valueAttrsWeightOverride;
    }

    public void setValueAttrsStyleOverride(boolean valueAttrsStyleOverride) {
        this.valueAttrsStyleOverride = valueAttrsStyleOverride;
    }

    public void setValueAttrsFontFamilyOverride(boolean valueAttrsFontFamilyOverride) {
        this.valueAttrsFontFamilyOverride = valueAttrsFontFamilyOverride;
    }

    public void setValueAttrsSizeOverride(boolean valueAttrsSizeOverride) {
        this.valueAttrsSizeOverride = valueAttrsSizeOverride;
    }

    public int getIndentPixels() {
        return this.indentPixels;
    }

    public void setIndentPixels(int indentPixels) {
        this.indentPixels = indentPixels;
    }

    public void setStat(int stat) {
        this.stat = stat;
    }

    public void setDisplayMode(String mode) {
        if (mode.length() == 0) {
            return;
        }
        if (mode.equalsIgnoreCase("all")) {
            this.showLabel = true;
        } else if (mode.equalsIgnoreCase("standard")) {
            this.showLabel = true;
        } else {
            this.showLabel = false;
            StringTokenizer st = new StringTokenizer(mode);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!"Label".equalsIgnoreCase(token)) continue;
                this.showLabel = true;
            }
        }
    }

    public void setAlignmentOffset(double offset, String axis) {
        if (offset <= 0.0) {
            return;
        }
        if (axis.equalsIgnoreCase("X")) {
            this.alignmentOffsetX = offset;
        } else if (axis.equalsIgnoreCase("X2")) {
            this.alignmentOffsetX2 = offset;
        } else if (axis.equalsIgnoreCase("Y")) {
            this.alignmentOffsetY = offset;
        } else if (axis.equalsIgnoreCase("Y2")) {
            this.alignmentOffsetY2 = offset;
        }
    }

    @Override
    public boolean hasLegend(int attrType) {
        if (this.groupVar == null && this.textGroupVar == null) {
            return false;
        }
        return super.hasLegend(attrType);
    }

    @Override
    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        return 12;
    }

    @Override
    protected void applyTextTransparency(LegendItem[] items) {
        if (!this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(items[i].getSymbolAttrs().getColor()));
            items[i].setSymbolAttrs((ColorAttr)fa);
        }
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        String attrVarName;
        String string = attrVarName = this.textGroupVar != null ? "TEXTGROUP" : "GROUP";
        if (this.isLegendEntryFromAttrMap(attrVarName)) {
            return this.getLegendItemsWithAttrMap(attrVarName, this.fixDefaultAttrType(attrType));
        }
        return super.getLegendItems(attrType);
    }

    @Override
    public LegendItem[] getLegendItemsWithAttrMap(DiscreteAttrMapper attrMapper, int attrType) {
        if (attrMapper == null || attrMapper.getAttrMap().getAllSize() <= 0) {
            return null;
        }
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        String[] values = this.getGroupValues();
        String[] attrMapValues = attrMapper.getAttrMap().getAllValues();
        int[] attrMapValueIndices = AxisTable.getAttrMapValueIndexInGroup(attrMapValues, values);
        Color[] fcolor = this.getFillColors();
        if (this.isMargeAttrMapRequired(12)) {
            fcolor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, fcolor, 13, this.valueAttrs.getColor(), this.dataTransparency, this.useDataTransparency);
        }
        Color[] lcolor = this.getLineColors();
        int[] pattern = this.getLinePatterns();
        int[] width = this.getLineWidths();
        Image legendSkin = this.loadLegendSkinImage();
        Image[] legendPixelBender = this.loadLegendPixelBenderImages();
        int n = attrMapValues.length;
        LegendItem[] entries = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            FillAttrs attr = new FillAttrs();
            attr.setColor(fcolor[i % fcolor.length]);
            LineAttrs attr2 = null;
            if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                attr2 = new LineAttrs();
                attr2.setColor(lcolor[i % lcolor.length]);
                attr2.setLinePattern(pattern[i % pattern.length]);
                attr2.setWidth(width[i % width.length]);
            }
            entries[i] = this.skinType == 0 ? new LegendItem((ColorAttr)attr, (ColorAttr)attr2, attrMapValues[i], null) : new LegendItem((ColorAttr)attr, (ColorAttr)attr2, attrMapValues[i], null, legendSkin, this.skinType, legendPixelBender);
        }
        return entries;
    }

    @Override
    protected boolean isMargeAttrMapRequired(int type) {
        switch (type) {
            case 12: {
                return (this.groupVar != null || this.textGroupVar != null) && !this.valueAttrsColorOverride;
            }
            case 3: 
            case 4: 
            case 11: {
                return false;
            }
        }
        return false;
    }

    @Override
    protected FillAttrs getAttrMapDefaultFillAttrs() {
        FillAttrs fs = new FillAttrs();
        fs.setColor(this.valueAttrs.getAltColor());
        fs.setTransparency(this.dataTransparency);
        return fs;
    }

    @Override
    public String[] getGroupValues() {
        String[] values = new String[]{};
        int sort = this.groupOrder == 1 ? 1 : (this.groupOrder == 2 ? 2 : 0);
        if (this.textGroupVar != null) {
            values = this.getUniqueValues((short)116, sort);
        } else if (this.groupVar != null) {
            values = this.getUniqueValues((short)3, sort);
        }
        return values;
    }

    @Override
    public Color[] getFillColors() {
        if (this.groupVar == null && this.textGroupVar == null) {
            return new Color[0];
        }
        if (this.valueAttrsColorOverride) {
            return new Color[]{this.applyDataTransparency(this.valueAttrs.getColor())};
        }
        String[] values = this.getGroupValues();
        Color[] colors = new Color[values.length];
        if (this.textGroupVar != null) {
            DiscreteAttrMapper tgDAM = null;
            DiscreteAttributeMap tgAttrMap = null;
            if (this.hasAttrVar("TEXTGROUP")) {
                tgDAM = (DiscreteAttrMapper)this.getAttrVarMapper("TEXTGROUP");
                tgDAM.setTextTransparency(this.dataTransparency);
                tgAttrMap = tgDAM.getAttrMap();
            }
            for (int i = 0; i < values.length; ++i) {
                TextAttrs ta;
                colors[i] = this.valueAttrs.getAltColor();
                if (tgAttrMap == null || tgAttrMap.get(values[i]) == null || (ta = tgAttrMap.get(values[i]).getTextAttrs()) == null || ta.getColor() == null) continue;
                colors[i] = this.applyDataTransparency(ta.getColor());
            }
        } else {
            DiscreteAttrMapper cgDAM = null;
            DiscreteAttributeMap cgAttrMap = null;
            if (this.hasAttrVar("GROUP")) {
                cgDAM = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                cgDAM.setTextTransparency(this.dataTransparency);
                cgAttrMap = cgDAM.getAttrMap();
            }
            HashMap cm = this.groupColorEncoder.getColorList();
            for (int i = 0; i < values.length; ++i) {
                TextAttrs ta;
                colors[i] = this.valueAttrs.getAltColor();
                if (cm != null) {
                    colors[i] = (Color)cm.get(values[i]);
                }
                if (cgAttrMap == null || cgAttrMap.get(values[i]) == null || (ta = cgAttrMap.get(values[i]).getTextAttrs()) == null || ta.getColor() == null) continue;
                colors[i] = this.applyDataTransparency(ta.getColor());
            }
        }
        return colors;
    }

    public int getLabelPositionInUse() {
        if (this.axis == 1 || this.axis == 2) {
            if (this.xEncoder != null && this.xEncoder.isReversed()) {
                if (this.labelPosition == 1) {
                    return 2;
                }
                return 1;
            }
        } else if (this.yEncoder != null && this.yEncoder.isReversed()) {
            if (this.labelPosition == 1) {
                return 2;
            }
            return 1;
        }
        return this.labelPosition;
    }

    private void updateNumberOfClassPerCategory() {
        int numCats;
        NumericVariable catvar;
        if (!this.clustering) {
            return;
        }
        if (this.var instanceof NumericVariable) {
            catvar = new NumericVariable();
            catvar.connectFrom((NumericVariable)this.var);
            catvar.setFormat(((NumericVariable)this.var).getFormat());
        } else {
            catvar = new StringVariable();
            ((StringVariable)catvar).connectFrom((StringVariable)this.var);
            ((StringVariable)catvar).setFormat(((StringVariable)this.var).getFormat());
        }
        StringVariable gvar = new StringVariable();
        gvar.connectFrom((StringVariable)this.classVar);
        VariableProcessor vp = new VariableProcessor();
        this.addVarToVP(vp, (Variable)catvar);
        vp.addVariable((Variable)gvar, 0);
        vp.addGroupVariable((Variable)catvar);
        vp.addGroupVariable((Variable)gvar);
        if (this.model.getSrcModel().maxGroupsPerCategory == null) {
            this.model.getSrcModel().maxGroupsPerCategory = new HashMap();
        }
        short role = 114;
        this.overlayID = this.model.getColumnName(role) + "." + this.model.getColumnName((short)1);
        if (this.includeMissingClass) {
            this.overlayID = this.overlayID + ".MissingClass";
        }
        int maxGroups = -1;
        if (this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID) != null) {
            maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
        }
        if ((numCats = catvar.getUniqueValueCount()) == 0) {
            return;
        }
        this.classPerCategory = new int[numCats];
        int gCount = 1;
        int gIdx = 0;
        String catV = null;
        for (int i = 0; i < catvar.getValueCount(); ++i) {
            try {
                String xv;
                String string = xv = catvar instanceof StringVariable ? ((StringVariable)catvar).value.getValue(i) : catvar.formattedValue.getValue(i);
                if (catV == null && i == 0) {
                    catV = xv;
                    continue;
                }
                if (xv.equals(catV)) {
                    ++gCount;
                    continue;
                }
                this.classPerCategory[gIdx] = gCount;
                if (gCount > maxGroups) {
                    maxGroups = gCount;
                }
                ++gIdx;
                gCount = 1;
                catV = xv;
                continue;
            }
            catch (MissingValueException e) {
                if (catV == null) continue;
                this.classPerCategory[gIdx] = gCount;
                if (gCount > maxGroups) {
                    maxGroups = gCount;
                }
                ++gIdx;
                gCount = 1;
                catV = null;
            }
        }
        this.classPerCategory[gIdx] = gCount;
        if (gCount > maxGroups) {
            maxGroups = gCount;
        }
        this.model.getSrcModel().maxGroupsPerCategory.put(this.overlayID, new Integer(maxGroups));
        this.classCategoryLists = this.getClassCategoryLists();
    }

    private ArrayList[] getClassCategoryLists() {
        ArrayList[] list;
        block9: {
            int i;
            int nCat;
            block8: {
                nCat = this.var.getUniqueValueCount();
                list = new ArrayList[nCat];
                for (int i2 = 0; i2 < nCat; ++i2) {
                    list[i2] = new ArrayList();
                }
                this.rawClassVar.getUniqueValueCount();
                IntegerPipe classCategory = this.numericClass ? ((NumericVariable)this.rawClassVar).category : ((StringVariable)this.rawClassVar).category;
                IntegerPipe category = this.var instanceof StringVariable ? ((StringVariable)this.var).category : ((NumericVariable)this.var).category;
                int n = this.var.getValueCount();
                for (i = 0; i < n; ++i) {
                    try {
                        Integer IG;
                        int cat;
                        if (this.var instanceof NumericVariable) {
                            ((NumericVariable)this.var).value.getValue(i);
                        }
                        if (list[cat = category.getValue(i)].contains(IG = new Integer(classCategory.getValue(i)))) continue;
                        list[cat].add(IG);
                        continue;
                    }
                    catch (MissingValueException cat) {
                        // empty catch block
                    }
                }
                if (this.classOrder != 1 && this.classOrder != 2) break block8;
                for (i = 0; i < nCat; ++i) {
                    Collections.sort(list[i]);
                }
                break block9;
            }
            if (this.classOrder != 3) break block9;
            for (i = 0; i < nCat; ++i) {
                ArrayList ll = new ArrayList();
                for (int j = list[i].size() - 1; j >= 0; --j) {
                    ll.add(list[i].get(j));
                }
                list[i] = ll;
            }
        }
        return list;
    }

    @Override
    public boolean isComputedOverlay() {
        return true;
    }
}

