/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.ler;

import com.sas.graphics.applets.statgraph.sgchart.ler.QSortAlgorithm;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.ArrayList;

public class LargestEmptyRectangle {
    private ArrayList obstacles = new ArrayList();
    private ArrayList points = new ArrayList();
    private int[] xp;
    private int[] yp;
    private Rectangle bounds = null;
    private Rectangle maxRect = null;
    private int maxDistance = -1;
    private boolean outsideOnly = false;

    public boolean isPopulated() {
        return this.points.size() > 0;
    }

    public void addPoint(int x, int y) {
        this.points.add(new Point(x, y));
    }

    public void setBounds(Rectangle b) {
        this.bounds = b;
    }

    public void addObstacles(Shape shape) {
        this.obstacles.add(shape);
    }

    public boolean isOutsideOnly() {
        return this.outsideOnly;
    }

    public void setOutsideOnly(boolean b) {
        this.outsideOnly = b;
    }

    public Rectangle getLERectangle(Rectangle bbox) {
        this.maxRect = new Rectangle();
        this.maxDistance = -1;
        this.xp = new int[this.points.size()];
        this.yp = new int[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            Point p = (Point)this.points.get(i);
            this.xp[i] = p.x;
            this.yp[i] = p.y;
        }
        if (!this.outsideOnly) {
            QSortAlgorithm.sort(this.xp, this.yp);
            this.find_ler_I(bbox);
        }
        QSortAlgorithm.sort(this.yp, this.xp);
        if (!this.outsideOnly) {
            this.find_ler_II(bbox);
        }
        this.find_ler_III(bbox);
        this.find_ler_IV(bbox);
        return this.maxRect;
    }

    private boolean isObstaclesTouched(int x, int y, int w, int h) {
        for (int i = 0; i < this.obstacles.size(); ++i) {
            Shape s = (Shape)this.obstacles.get(i);
            if (!s.intersects(x, y, w, h)) continue;
            return true;
        }
        return false;
    }

    private Rectangle getLargestEnclosedRectangle(int x, int y, int w, int h) {
        Rectangle maxRect = new Rectangle();
        int ix = x;
        int iy = y;
        int iw = w;
        int ih = h;
        for (int i = 0; i < this.obstacles.size(); ++i) {
            Shape s = (Shape)this.obstacles.get(i);
            if (!s.intersects(ix, iy, iw, ih) || !(s instanceof Line2D) || (maxRect = LargestEmptyRectangle.computeMaxInsideLER((Line2D)s, ix, iy, iw, ih)).isEmpty()) continue;
            ix = maxRect.x;
            iy = maxRect.y;
            iw = maxRect.width;
            ih = maxRect.height;
        }
        return maxRect;
    }

    static Rectangle computeMaxInsideLER(Line2D line, int x, int y, int w, int h) {
        double x1 = line.getX1();
        double y1 = line.getY1();
        double x2 = line.getX2();
        double y2 = line.getY2();
        if (x1 > x2) {
            double t = x2;
            x2 = x1;
            x1 = t;
            t = y2;
            y2 = y1;
            y1 = t;
        }
        if (x1 == x2) {
            if (x1 - (double)x > (double)(w / 2)) {
                return new Rectangle(x, y, (int)(x1 - (double)x), h);
            }
            return new Rectangle((int)x1, y, (int)((double)(x + w) - x1), h);
        }
        double slope = (y2 - y1) / (x2 - x1);
        if (line.intersectsLine(x, y, x, y + h)) {
            int yL = (int)(y1 + slope * ((double)x - x1));
            yL = Math.max(yL, y);
            yL = Math.min(yL, y + h);
            if (line.intersectsLine(x, y, x + w, y)) {
                int xT = (int)(((double)y - y1) / slope + x1);
                xT = Math.max(xT, x);
                int a1 = (y + h - yL) * w;
                int a2 = (x + w - (xT = Math.min(xT, x + w))) * h;
                if (a1 > a2) {
                    return new Rectangle(x, yL, w, y + h - yL);
                }
                return new Rectangle(xT, y, x + w - xT, h);
            }
            if (line.intersectsLine(x + w, y, x + w, y + h)) {
                int yR = (int)(y1 + slope * ((double)(x + w) - x1));
                yR = Math.max(yR, y);
                if ((yR = Math.min(yR, y + h)) < yL) {
                    if (yR - y > y + h - yL) {
                        return new Rectangle(x, y, w, yR - y);
                    }
                    return new Rectangle(x, yL, w, y + h - yL);
                }
                if (yL - y > y + h - yR) {
                    return new Rectangle(x, y, w, yL - y);
                }
                return new Rectangle(x, yR, w, y + h - yR);
            }
            int xB = (int)(((double)(y + h) - y1) / slope + x1);
            xB = Math.max(xB, x);
            int a1 = (yL - y) * w;
            int a2 = (x + w - (xB = Math.min(xB, x + w))) * h;
            if (a1 > a2) {
                return new Rectangle(x, y, w, yL - y);
            }
            return new Rectangle(xB, y, x + w - xB, h);
        }
        if (line.intersectsLine(x, y, x + w, y)) {
            int xT = (int)(((double)y - y1) / slope + x1);
            xT = Math.max(xT, x);
            xT = Math.min(xT, x + w);
            if (line.intersectsLine(x + w, y, x + w, y + h)) {
                int yR = (int)(y1 + slope * ((double)(x + w) - x1));
                yR = Math.max(yR, y);
                int a1 = (xT - x) * h;
                int a2 = (y + h - (yR = Math.min(yR, y + h))) * w;
                if (a1 > a2) {
                    return new Rectangle(x, y, xT - x, h);
                }
                return new Rectangle(x, yR, w, y + h - yR);
            }
            if (line.intersectsLine(x, y + h, x + w, y + h)) {
                int xB = (int)(((double)(y + h) - y1) / slope + x1);
                xB = Math.max(xB, x);
                if ((xB = Math.min(xB, x + w)) > xT) {
                    if (xT - x > x + w - xB) {
                        return new Rectangle(x, y, xT - x, h);
                    }
                    return new Rectangle(xB, y, x + w - xB, h);
                }
                if (xB - x > x + w - xT) {
                    return new Rectangle(x, y, xB - x, h);
                }
                return new Rectangle(xT, y, x + w - xT, h);
            }
        } else {
            int yR = (int)(y1 + slope * ((double)(x + w) - x1));
            yR = Math.max(yR, y);
            yR = Math.min(yR, y + h);
            if (line.intersectsLine(x, y + h, x + w, y + h)) {
                int xB = (int)(((double)(y + h) - y1) / slope + x1);
                int a1 = (xB - x) * h;
                int a2 = (yR - y) * w;
                if (a1 > a2) {
                    return new Rectangle(x, y, xB - x, h);
                }
                return new Rectangle(x, y, w, yR - y);
            }
        }
        return new Rectangle();
    }

    private void find_ler_I(Rectangle bbox) {
        Rectangle currRect = null;
        int maxSize = this.maxRect.width * this.maxRect.height;
        int L = 0;
        int R = 0;
        int xprev = this.bounds.x;
        for (int i = 0; i < this.xp.length; ++i) {
            int size = (this.xp[i] - xprev) * this.bounds.height;
            if (size > maxSize) {
                Rectangle r;
                if (!this.isObstaclesTouched(xprev, 0, this.xp[i] - xprev, this.bounds.height - 1)) {
                    L = xprev;
                    R = this.xp[i];
                    r = this.getMaxIntersection(new Rectangle(L, 0, R - L, this.bounds.height - 1), bbox);
                    if (r.width * r.height > maxSize) {
                        maxSize = r.width * r.height;
                        currRect = r;
                    }
                } else {
                    r = this.getLargestEnclosedRectangle(xprev, 0, this.xp[i] - xprev, this.bounds.height - 1);
                    if (r.width * r.height > maxSize) {
                        maxSize = r.width * r.height;
                        currRect = r;
                    }
                }
            }
            xprev = this.xp[i];
        }
        int lastHStripSize = (this.bounds.width - 1 - this.xp[this.xp.length - 1]) * this.bounds.height;
        if (lastHStripSize > maxSize) {
            if (!this.isObstaclesTouched(this.xp[this.xp.length - 1], 0, this.bounds.width - this.xp[this.xp.length - 1] - 1, this.bounds.height - 1)) {
                L = this.xp[this.xp.length - 1];
                R = this.bounds.width - 1;
                Rectangle r = this.getMaxIntersection(new Rectangle(L, 0, R - L, this.bounds.height - 1), bbox);
                if (r.width * r.height > maxSize) {
                    maxSize = r.width * r.height;
                    currRect = r;
                }
            } else {
                Rectangle r = this.getLargestEnclosedRectangle(this.xp[this.xp.length - 1], 0, this.bounds.width - this.xp[this.xp.length - 1] - 1, this.bounds.height - 1);
                if (r.width * r.height > maxSize) {
                    maxSize = r.width * r.height;
                    currRect = r;
                }
            }
        }
        if (currRect == null) {
            currRect = new Rectangle(L, 0, R - L, this.bounds.height - 1);
        }
        this.updateMaxRect(currRect, bbox);
    }

    private void find_ler_II(Rectangle bbox) {
        Rectangle currRect = null;
        int maxSize = this.maxRect.width * this.maxRect.height;
        int L = 0;
        int R = 0;
        int T = 0;
        int B = 0;
        for (int i = this.yp.length - 1; i >= 0; --i) {
            int tl = 0;
            int tr = this.bounds.width - 1;
            for (int j = i - 1; j >= 0; --j) {
                if (this.xp[j] <= tl || this.xp[j] >= tr) continue;
                int size = (tr - tl) * (this.yp[i] - this.yp[j]);
                if (size > maxSize) {
                    Rectangle r;
                    if (!this.isObstaclesTouched(tl, this.yp[j], tr - tl, this.yp[i] - this.yp[j])) {
                        L = tl;
                        R = tr;
                        T = this.yp[j];
                        B = this.yp[i];
                        r = this.getMaxIntersection(new Rectangle(L, T, R - L, B - T), bbox);
                        if (r.width * r.height > maxSize) {
                            maxSize = r.width * r.height;
                            currRect = r;
                        }
                    } else {
                        r = this.getLargestEnclosedRectangle(tl, this.yp[j], tr - tl, this.yp[i] - this.yp[j]);
                        if (r.width * r.height > maxSize) {
                            maxSize = r.width * r.height;
                            currRect = r;
                        }
                    }
                }
                if (this.xp[j] > this.xp[i]) {
                    tr = this.xp[j];
                    continue;
                }
                tl = this.xp[j];
            }
        }
        if (currRect == null) {
            currRect = new Rectangle(L, T, R - L, B - T);
        }
        this.updateMaxRect(currRect, bbox);
    }

    private void find_ler_III(Rectangle bbox) {
        Rectangle currRect = null;
        int maxSize = this.maxRect.width * this.maxRect.height;
        int L = 0;
        int R = 0;
        int T = 0;
        int B = 0;
        for (int i = this.yp.length - 1; i >= 0; --i) {
            Rectangle r;
            int tL = 0;
            int tR = this.bounds.width - 1;
            for (int j = i - 1; j >= 0; --j) {
                if (this.yp[j] == this.yp[i]) continue;
                if (this.xp[j] >= this.xp[i] && this.xp[j] < tR) {
                    tR = this.xp[j];
                }
                if (this.xp[j] > this.xp[i] || this.xp[j] <= tL) continue;
                tL = this.xp[j];
            }
            int size = (tR - tL) * this.yp[i];
            if (size <= maxSize) continue;
            if (!this.isObstaclesTouched(tL, 0, tR - tL, this.yp[i])) {
                L = tL;
                R = tR;
                T = 0;
                B = this.yp[i];
                r = this.getMaxIntersection(new Rectangle(L, T, R - L, B - T), bbox);
                if (r.width * r.height <= maxSize) continue;
                maxSize = r.width * r.height;
                currRect = r;
                continue;
            }
            r = this.getLargestEnclosedRectangle(tL, 0, tR - tL, this.yp[i]);
            if (r.width * r.height <= maxSize) continue;
            maxSize = r.width * r.height;
            currRect = r;
        }
        if (currRect == null) {
            currRect = new Rectangle(L, T, R - L, B - T);
        }
        this.updateMaxRect(currRect, bbox);
    }

    private void find_ler_IV(Rectangle bbox) {
        Rectangle currRect = null;
        int maxSize = this.maxRect.width * this.maxRect.height;
        int L = 0;
        int R = 0;
        int T = 0;
        int B = 0;
        for (int i = 0; i < this.yp.length; ++i) {
            Rectangle r;
            int tL = 0;
            int tR = this.bounds.width - 1;
            for (int j = i + 1; j < this.yp.length; ++j) {
                if (this.yp[j] == this.yp[i]) continue;
                if (this.xp[j] >= this.xp[i] && this.xp[j] < tR) {
                    tR = this.xp[j];
                }
                if (this.xp[j] > this.xp[i] || this.xp[j] <= tL) continue;
                tL = this.xp[j];
            }
            int size = (tR - tL) * (this.bounds.height - this.yp[i]);
            if (size <= maxSize) continue;
            if (!this.isObstaclesTouched(tL, this.yp[i], tR - tL, this.bounds.height - this.yp[i])) {
                L = tL;
                R = tR;
                T = this.yp[i];
                B = this.bounds.height - 1;
                r = this.getMaxIntersection(new Rectangle(L, T, R - L, B - T), bbox);
                if (r.width * r.height <= maxSize) continue;
                maxSize = r.width * r.height;
                currRect = r;
                continue;
            }
            r = this.getLargestEnclosedRectangle(tL, this.yp[i], tR - tL, this.bounds.height - this.yp[i]);
            if (r.width * r.height <= maxSize) continue;
            maxSize = r.width * r.height;
            currRect = r;
        }
        if (currRect == null) {
            currRect = new Rectangle(L, T, R - L, B - T);
        }
        this.updateMaxRect(currRect, bbox);
    }

    private void updateMaxRect(Rectangle currRect, Rectangle bbox) {
        Rectangle rect = this.getMaxIntersection(currRect, bbox);
        int dist = this.getDistance(rect, bbox);
        if (dist >= 0) {
            if (dist == this.maxDistance && rect.width * rect.height > this.maxRect.width * this.maxRect.height) {
                this.maxRect = rect;
                this.maxDistance = dist;
            } else if ((double)(rect.width * rect.height) >= 1.5 * (double)this.maxRect.width * (double)this.maxRect.height) {
                this.maxRect = rect;
                this.maxDistance = dist;
            } else if (dist > this.maxDistance) {
                this.maxRect = rect;
                this.maxDistance = dist;
            }
        } else if (rect.width * rect.height > this.maxRect.width * this.maxRect.height) {
            this.maxRect = rect;
            this.maxDistance = dist;
        }
    }

    private Rectangle getMaxIntersection(Rectangle rect, Rectangle bbox) {
        if (rect.width >= bbox.width && rect.height >= bbox.height) {
            return rect;
        }
        int w = Math.min(rect.width, bbox.width);
        int h = Math.min(rect.height, bbox.height);
        int x = rect.x + rect.width / 2 - w / 2;
        int y = rect.y + rect.height / 2 - h / 2;
        return new Rectangle(x, y, w, h);
    }

    private int getDistance(Rectangle rect, Rectangle bbox) {
        if (rect.width >= bbox.width && rect.height >= bbox.height) {
            return Math.min(rect.width - bbox.width, rect.height - bbox.height);
        }
        return -1;
    }
}

