/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.legend;

import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridPanel;
import com.sas.graphics.applets.statgraph.sgchart.grid.OuterPadBorder;
import com.sas.graphics.applets.statgraph.sgchart.legend.VLegend;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.TickMarkStyle;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class LegendComponent
extends AbstractSGComponent {
    protected Channel channel = new Channel((Component)this, 2);
    protected VLegend legend;
    private int _labelCount = 0;
    private int _labelCountHint = 6;
    private boolean antiAliased = true;
    private Dimension userPrefSize = null;

    public void setAntiAliased(boolean b) {
        this.antiAliased = b;
    }

    public int getLabelCount() {
        return this._labelCount;
    }

    public void setLabelCount(int labelCount) {
        this._labelCount = labelCount;
        this.legend.setNTicks(labelCount);
    }

    public int getLabelCountHint() {
        return this._labelCountHint;
    }

    public void setLabelCountHint(int labelCountHint) {
        this._labelCountHint = labelCountHint;
        this.legend.setNTicks(this._labelCountHint);
    }

    public TextStyle getValueStyle() {
        return this.legend.getValueStyle();
    }

    public TextStyle getTitleStyle() {
        return this.legend.getTitleStyle();
    }

    public TickMarkStyle getTickStyle() {
        return this.legend.getTickStyle();
    }

    public void setValueFormat(SASFormat format) {
        this.legend.setValueFormat(format);
    }

    public void setTitle(String title) {
        this.legend.setTitle(title);
    }

    public LegendComponent() {
        this.channel.glDisable(3);
        this.channel.glDisable(4);
        this.channel.glDisable(1);
        this.channel.glViewport(0, 0, 1, 1);
        this.channel.glOrtho(0.0, 1.0, 0.0, 1.0, -10.0, 10.0);
        this.legend = new VLegend();
        this.legend.setChannel(this.channel);
        this.setOpaque(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isVisible() || g == null) {
            return;
        }
        if (this.antiAliased) {
            this.channel.glEnable(13);
            this.channel.glEnable(14);
        } else {
            this.channel.glDisable(13);
            this.channel.glDisable(14);
        }
        this.channel.setSingleBufferGraphics(g);
        Insets in = this.getInsets();
        this.channel.glPushMatrix();
        this.channel.glTranslate((double)in.left, (double)in.bottom, 0.0);
        if (this.isComponentOpaque()) {
            this.channel.setBackgroundColor(this.getBackground());
            this.channel.clearBGC();
        }
        this.legend.draw(g);
        this.channel.glPopMatrix();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (w == 0 && h == 0) {
            return;
        }
        if (x == this.getX() && y == this.getY() && w == this.getWidth() && h == this.getHeight()) {
            return;
        }
        super.setBounds(x, y, w, h);
        this.resize();
        this.repaint();
    }

    public void resize() {
        this.channel.gluLookAt(0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0);
        Insets in = this.getInsets();
        int w = this.getWidth() - in.left - in.right;
        int h = this.getHeight() - in.top - in.bottom;
        Insets pad = new Insets(0, 0, 0, 0);
        if (this.isComponentOpaque()) {
            Border border = this.getBorder();
            while (border instanceof CompoundBorder) {
                Border outer = ((CompoundBorder)border).getOutsideBorder();
                if (outer == null) continue;
                border = outer;
            }
            if (border instanceof OuterPadBorder) {
                pad = border.getBorderInsets(this);
            }
        }
        this.channel.glViewport(pad.left, pad.top, this.getWidth() - pad.left - pad.right, this.getHeight() - pad.top - pad.bottom);
        this.channel.glOrtho((double)pad.left, (double)(this.getWidth() - pad.right), (double)pad.bottom, (double)(this.getHeight() - pad.top), -10.0, 10.0);
        this.legend.setBounds(0, 0, w, h);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.userPrefSize != null) {
            return this.userPrefSize;
        }
        Dimension d1 = new Dimension();
        Container parent = this.getParent();
        if (parent == null) {
            return d1;
        }
        this.legend.draw(null);
        Dimension d2 = this.legend.getPreferredSize();
        if (this.legend.isHorizontal()) {
            if (parent instanceof BaseOverlayContainer) {
                d1.width = ((BaseOverlayContainer)parent).getPreferredDataAreaSize((boolean)false).width - 10;
                if (d1.width < 0) {
                    d1.width = 0;
                }
            } else {
                d1.width = parent instanceof GridPanel ? d2.width : parent.getWidth() - parent.getInsets().left - parent.getInsets().right;
            }
            d1.height = Math.max(d1.height, d2.height);
        } else {
            if (parent instanceof BaseOverlayContainer) {
                d1.height = ((BaseOverlayContainer)parent).getPreferredDataAreaSize((boolean)false).height - 10;
                if (d1.height < 0) {
                    d1.height = 0;
                }
            } else {
                d1.height = parent instanceof GridPanel ? d2.height : parent.getHeight() - parent.getInsets().top - parent.getInsets().bottom;
            }
            d1.width = Math.max(d1.width, d2.width);
        }
        Insets in = this.getInsets();
        d1.width += in.left + in.right;
        d1.height += in.top + in.bottom;
        return d1;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.channel != null) {
            this.channel.setBackgroundColor(color);
            this.channel.clearBGC();
            this.repaint();
        }
    }

    public VLegend getLegend() {
        return this.legend;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setHorizontal(boolean isHorizontal) {
        super.setHorizontal(isHorizontal);
        this.legend.setHorizontal(isHorizontal);
    }

    @Override
    public boolean isHorizontal() {
        return this.legend.isHorizontal();
    }

    public int getDisplayMissing() {
        return this.legend.getDisplayMissing();
    }

    public void setDisplayMissing(int displayMissing) {
        this.legend.setDisplayMissing(displayMissing);
    }

    public void setExactScale(boolean extract) {
        this.legend.setExactScale(extract);
    }

    public boolean isExtractScale() {
        return this.legend.isExtractScale();
    }

    public void setScientificScale(boolean type) {
        this.legend.setScientificScale(type);
    }

    public boolean isScientificScale() {
        return this.legend.isScientificScale();
    }

    @Override
    public void setPreferredSize(Dimension ps) {
        this.userPrefSize = ps;
        super.setPreferredSize(ps);
    }

    public boolean isInteger() {
        return this.legend.isInteger();
    }

    public void setInteger(boolean b) {
        this.legend.setInteger(b);
    }
}

