/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.labeling;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.labeling.Graph;
import com.sas.graphics.applets.statgraph.sgchart.labeling.LabelPlacementInterface;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.text.SASFormat;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Random;

public class SALabeling
implements LabelPlacementInterface {
    private double[] x;
    private double[] y;
    private double[] w;
    private double[] h;
    private static final int penalLen = 12;
    private static final int secondaryIterations = 50;
    private int mainIterations = 100;
    private Rectangle clipBounds;
    private int M;
    private double[][] obstacleover;
    private double[][] outbound;
    private double[] penalty;
    public double[][] outxy;
    private ArrayList<Double> xa = new ArrayList();
    private ArrayList<Double> ya = new ArrayList();
    private ArrayList<String> la = new ArrayList();
    private ArrayList<FontMetrics> fm = new ArrayList();
    public String[] labels;
    private ArrayList<Integer> markerSize = new ArrayList();
    private ArrayList<Integer> shuffle = new ArrayList();
    private ArrayList<Integer> shuffleTemp = new ArrayList();
    private ArrayList<Shape> obstacleList = new ArrayList();
    private HashMap<String, String> weightMap;
    private boolean verbose = false;
    private Random random = null;
    private int seed = 1234567;
    private double yOutputRange = 0.0;
    private ArrayList<double[]> customPenalty = new ArrayList();
    public static final String LABEL_WEIGHT = "LABEL";
    public static final String MARKER_WEIGHT = "MARKER";
    public static final String PRIORITY_WEIGHT = "PRIORITY";
    public static final String OBSTACLE_WEIGHT = "OBSTACLE";
    public static final String OUTOFBOUND_WEIGHT = "OUTOFBOUND";
    public static final String SPACE_WEIGHT = "SPACE";
    public static final String DISTANCE_WEIGHT = "DISTANCE";

    public SALabeling(Rectangle bounds, double yRange) {
        this(bounds, yRange, false);
    }

    public SALabeling(Rectangle bounds, double yRange, boolean verbose) {
        this.clipBounds = bounds;
        this.yOutputRange = yRange;
        this.verbose = verbose;
        this.random = new Random();
    }

    public static HashMap<String, String> createDefaultWeightMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(LABEL_WEIGHT, "1.0");
        map.put(MARKER_WEIGHT, "1.0");
        map.put(OBSTACLE_WEIGHT, "1.0");
        map.put(PRIORITY_WEIGHT, "1.0");
        map.put(OUTOFBOUND_WEIGHT, "1.0");
        map.put(SPACE_WEIGHT, "1.0");
        map.put(DISTANCE_WEIGHT, "1.0");
        return map;
    }

    public static double getWeight(HashMap<String, String> map, String key) {
        if (map == null || !map.containsKey(key)) {
            return 0.0;
        }
        return Double.parseDouble(map.get(key));
    }

    public void setWeightMap(HashMap<String, String> map) {
        if (map == null) {
            map = SALabeling.createDefaultWeightMap();
        }
        this.weightMap = map;
    }

    public int getMainIterations() {
        return this.mainIterations;
    }

    public void setMainIterations(int mainIterations) {
        this.mainIterations = mainIterations;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public void addValue(double xpos, double ypos) {
        this.xa.add(xpos);
        this.ya.add(ypos);
    }

    public void addLabel(String label, int markerSize) {
        this.la.add(label);
        this.markerSize.add(markerSize);
    }

    public void addFontMetrics(FontMetrics fm) {
        this.fm.add(fm);
    }

    private void createDefaultPriorities() {
        this.penalty = new double[12];
        this.penalty[0] = 0.0;
        this.penalty[1] = 0.25;
        this.penalty[2] = 0.75;
        this.penalty[3] = 0.75;
        this.penalty[4] = 0.25;
        this.penalty[5] = 0.75;
        this.penalty[6] = 0.75;
        this.penalty[7] = 0.75;
        this.penalty[8] = 0.5;
        this.penalty[9] = 0.5;
        this.penalty[10] = 0.75;
        this.penalty[11] = 0.75;
    }

    public double[] getCustomPenalty(int[] can) {
        if (can == null) {
            return this.penalty;
        }
        double[] pen = new double[12];
        for (int i = 0; i < 12; ++i) {
            pen[i] = 1.0;
        }
        double inc = can.length > 1 ? 0.75 / (double)(can.length - 1) : 0.0;
        for (int i = 0; i < can.length; ++i) {
            pen[can[i]] = (double)i * inc;
        }
        return pen;
    }

    public void addCustomPenalty(double[] penalty) {
        this.customPenalty.add(penalty);
    }

    @Override
    public void addObstacle(Shape obstacle) {
        this.obstacleList.add(obstacle);
    }

    public double SALabelingMain() {
        this.M = this.la.size();
        this.x = new double[this.M];
        this.y = new double[this.M];
        this.labels = new String[this.M];
        for (int i = 0; i < this.x.length; ++i) {
            this.x[i] = this.xa.get(i);
            this.y[i] = this.ya.get(i);
            this.labels[i] = this.la.get(i);
        }
        if (this.seed != 0) {
            this.random.setSeed(this.seed);
        }
        this.createDefaultPriorities();
        this.shuffle.clear();
        this.computeTextSize();
        this.outBound();
        this.obstacleIntersect();
        return this.mainIter();
    }

    private void computeTextSize() {
        this.w = new double[this.M];
        this.h = new double[this.M];
        for (int i = 0; i < this.M; ++i) {
            this.w[i] = Overlay.getTextWidth(this.fm.get(i), this.labels[i]);
            this.h[i] = Overlay.getTextHeight(this.fm.get(i), this.labels[i]);
        }
    }

    private void outBound() {
        this.outbound = new double[this.M][12];
        Rectangle2D.Double bb = new Rectangle2D.Double();
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < 12; ++j) {
                if (this.labels[i] == null || this.labels[i].length() == 0) continue;
                this.calcBBox(i, j, bb);
                bb.y = this.yOutputRange - bb.y;
                if (this.clipBounds.contains(bb)) continue;
                this.outbound[i][j] = this.w[i] * this.h[i] * 2.0;
            }
        }
    }

    private double mainIter() {
        int[] bestgene = new int[this.M];
        int[] newgene = new int[this.M];
        int[] gene = this.firstGene();
        int i = 0;
        double[] score = this.objective(gene, 0.0, i);
        for (int m = 0; m < this.M; ++m) {
            bestgene[m] = gene[m];
        }
        double[] bestscore = score;
        int iter1 = this.mainIterations;
        int iter2 = 50;
        double T = 2.5;
        for (i = 0; i < iter1; ++i) {
            int k = 1;
            for (int j = 0; j < iter2; ++j) {
                int m;
                for (m = 0; m < this.M; ++m) {
                    newgene[m] = gene[m];
                }
                double randx = this.random.nextDouble() * (double)this.shuffle.size();
                int ind = (int)Math.floor(randx);
                randx = this.random.nextDouble() * 12.0;
                int value = (int)Math.floor(randx);
                if (this.shuffle.size() != 0) {
                    newgene[this.shuffle.get((int)ind).intValue()] = value;
                }
                this.shuffle.clear();
                this.shuffleTemp.clear();
                double[] newscore = this.objective(newgene, bestscore[0], i);
                for (int n = 0; n < this.shuffle.size(); ++n) {
                    this.shuffleTemp.add((int)this.shuffle.get(n));
                }
                this.addNear(this.shuffleTemp);
                double exp1 = this.random.nextDouble();
                double exp2 = (score[0] - newscore[0]) / T;
                if (newscore[0] <= score[0] || exp1 < Math.exp(exp2)) {
                    ++k;
                    score = newscore;
                    for (m = 0; m < this.M; ++m) {
                        gene[m] = newgene[m];
                    }
                }
                if (score[0] <= bestscore[0]) {
                    bestscore = score;
                    for (m = 0; m < this.M; ++m) {
                        bestgene[m] = gene[m];
                    }
                }
                if (k == iter2 || bestscore[0] <= 0.05) break;
            }
            if (bestscore[0] <= 0.5) {
                if (!this.verbose) break;
                System.out.println("Kick-out iteration=" + i);
                break;
            }
            T = 0.9 * T;
        }
        this.outxy = this.calcCoord(bestgene);
        if (this.verbose) {
            SASFormat fmt = DataModel.defaultFormat;
            String bs = fmt.format((Object)new Double(bestscore[0])).trim();
            String ls = fmt.format((Object)new Double(bestscore[1])).trim();
            String ms = fmt.format((Object)new Double(bestscore[2])).trim();
            String os = fmt.format((Object)new Double(bestscore[3])).trim();
            String ps = fmt.format((Object)new Double(bestscore[4])).trim();
            String oi = fmt.format((Object)new Double(bestscore[5])).trim();
            String sp = fmt.format((Object)new Double(bestscore[6])).trim();
            String ds = fmt.format((Object)new Double(bestscore[7])).trim();
            System.out.println("Best Score=" + bs + " ===> L:" + ls + "  M:" + ms + "  OOB:" + os + "  P:" + ps + "  O:" + oi + "  S:" + sp + "  D:" + ds + "  Iter:" + (int)bestscore[8]);
        }
        return bestscore[0];
    }

    private int[] firstGene() {
        int[] gene = new int[this.M];
        for (int m = 0; m < this.M; ++m) {
            gene[m] = 0;
        }
        return gene;
    }

    private double[] objective(int[] gene, double bestscore, int iter) {
        double[] sum = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double sumLabel = 0.0;
        double sumMarker = 0.0;
        double sumOOB = 0.0;
        double sumPriority = 0.0;
        double sumObstacle = 0.0;
        double sumSpace = 0.0;
        double sumDist = 0.0;
        double wLabel = SALabeling.getWeight(this.weightMap, LABEL_WEIGHT);
        double wMarker = SALabeling.getWeight(this.weightMap, MARKER_WEIGHT);
        double wOOB = SALabeling.getWeight(this.weightMap, OUTOFBOUND_WEIGHT);
        double wPriority = SALabeling.getWeight(this.weightMap, PRIORITY_WEIGHT);
        double wObstacle = SALabeling.getWeight(this.weightMap, OBSTACLE_WEIGHT);
        double wSpace = SALabeling.getWeight(this.weightMap, SPACE_WEIGHT);
        double wDist = SALabeling.getWeight(this.weightMap, DISTANCE_WEIGHT);
        sumLabel = this.rectIntersect(gene);
        sumMarker = this.markIntersect(gene);
        for (int i = 0; i < this.M; ++i) {
            int gind = gene[i];
            sumOOB += this.outbound[i][gind];
            sumObstacle += this.obstacleover[i][gind];
            double score = this.customPenalty.get(i) == null ? this.penalty[gind] : this.customPenalty.get(i)[gind];
            sumPriority += score;
            if (this.labels[i].length() <= 0 || this.outbound[i][gind] == 0.0 && this.obstacleover[i][gind] == 0.0) continue;
            int n = this.outbound[i][gind] != 0.0 ? this.M / 2 : 1;
            this.addToShuffle(i, n);
        }
        sum[1] = sumLabel;
        sum[2] = 5.0 * sumMarker;
        sum[3] = sumOOB;
        sum[4] = sumPriority;
        sum[5] = 1.5 * sumObstacle;
        sum[6] = sumSpace;
        sum[7] = sumDist;
        sum[0] = wLabel * sum[1] + wMarker * sum[2] + wOOB * sum[3] + wPriority * sum[4] + wObstacle * sum[5] + wSpace * sum[6] + wDist * sum[7];
        sum[8] = iter;
        if (sum[0] < bestscore && this.verbose) {
            SASFormat fmt = DataModel.defaultFormat;
            System.out.print("Iter=" + iter + "  ");
            System.out.print("Total=" + fmt.format((Object)new Double(sum[0])).trim() + "  ");
            System.out.print("L=" + fmt.format((Object)new Double(sum[1])).trim() + "  ");
            System.out.print("M=" + fmt.format((Object)new Double(sum[2])).trim() + "  ");
            System.out.print("OOB=" + fmt.format((Object)new Double(sum[3])).trim() + "  ");
            System.out.print("P=" + fmt.format((Object)new Double(sum[4])).trim() + "  ");
            System.out.print("O=" + fmt.format((Object)new Double(sum[5])).trim() + "  ");
            System.out.print("S=" + fmt.format((Object)new Double(sum[6])).trim() + "  ");
            System.out.println("D=" + fmt.format((Object)new Double(sum[7])).trim());
        }
        return sum;
    }

    private double rectIntersect(int[] gene) {
        double area = 0.0;
        Rectangle2D.Double boxi = new Rectangle2D.Double();
        Rectangle2D.Double boxj = new Rectangle2D.Double();
        for (int i = 0; i < this.M; ++i) {
            if (this.labels[i].length() == 0) continue;
            this.calcBBox(i, gene[i], boxi);
            for (int j = i; j < this.M; ++j) {
                if (i == j || this.labels[j].length() == 0) continue;
                this.calcBBox(j, gene[j], boxj);
                if (!boxi.intersects(boxj)) continue;
                this.addToShuffle(i);
                this.addToShuffle(j);
                area += this.areaOfIntersection(boxi, boxj);
            }
        }
        return area;
    }

    private double markIntersect(int[] gene) {
        double area = 0.0;
        Rectangle2D.Double boxi = new Rectangle2D.Double();
        Rectangle2D.Double boxj = new Rectangle2D.Double();
        for (int i = 0; i < this.M; ++i) {
            if (this.labels[i].length() == 0) continue;
            this.calcBBox(i, gene[i], boxi);
            for (int j = 0; j < this.M; ++j) {
                if (i == j || this.markerSize.get(j) == 0) continue;
                this.calcBBox(j, -1, boxj);
                if (!boxi.intersects(boxj) || this.x[i] == this.x[j] && this.y[i] == this.y[j]) continue;
                this.addToShuffle(i);
                area += this.areaOfIntersection(boxi, boxj);
            }
        }
        return area;
    }

    private void obstacleIntersect() {
        this.obstacleover = new double[this.M][12];
        if (this.obstacleList.size() == 0) {
            return;
        }
        Rectangle2D.Double bb = new Rectangle2D.Double();
        for (int i = 0; i < this.M; ++i) {
            if (this.labels[i] == null || this.labels[i].length() == 0) continue;
            for (int j = 0; j < 12; ++j) {
                double nx = this.x[i];
                double ny = this.y[i];
                double nw = this.w[i];
                double nh = this.h[i];
                double hOffset = 0.25 * this.h[i];
                double hms = Math.max((double)(this.markerSize.get(i) / 2), 0.5);
                SALabeling.calcBBox(j, nx, ny, nw, nh, hms, bb, hOffset);
                bb.width *= 1.1;
                bb.height *= 1.1;
                bb.y = this.yOutputRange - bb.y;
                int count = 0;
                for (int k = 0; k < this.obstacleList.size(); ++k) {
                    Shape obstacle = this.obstacleList.get(k);
                    if (!obstacle.intersects(bb)) continue;
                    ++count;
                }
                this.obstacleover[i][j] = (double)count * this.w[i];
            }
        }
    }

    double areaOfIntersection(Rectangle2D.Double r1, Rectangle2D.Double r2) {
        double left = Math.max(r1.x, r2.x);
        double right = Math.min(r1.x + r1.width, r2.x + r2.width);
        double top = Math.max(r1.y, r2.y);
        double bottom = Math.min(r1.y + r1.height, r2.y + r2.height);
        if (left < right && top < bottom) {
            return (right - left) * (bottom - top);
        }
        return 0.0;
    }

    private void addNear(ArrayList<Integer> shuffle2) {
        for (int i = 0; i < shuffle2.size(); ++i) {
            for (int j = 0; j < this.M; ++j) {
                if (shuffle2.get(i) == j || !(Math.abs(this.x[shuffle2.get(i)] - this.x[j]) <= 2.25 * this.w[shuffle2.get(i)]) || !(Math.abs(this.y[shuffle2.get(i)] - this.y[j]) <= 2.5 * this.h[shuffle2.get(i)])) continue;
                this.addToShuffle(j);
            }
        }
    }

    private void addToShuffle(int idx) {
        this.addToShuffle(idx, 1);
    }

    private void addToShuffle(int idx, int n) {
        for (int i = 0; i < n; ++i) {
            this.shuffle.add(idx);
        }
    }

    public void calcBBox(int ind, int position, Rectangle2D.Double bbox) {
        double nx = this.x[ind];
        double ny = this.y[ind];
        double nw = this.w[ind];
        double nh = this.h[ind];
        double hms = Math.max((double)(this.markerSize.get(ind) / 2), 0.5);
        double hOffset = 0.25 * this.h[ind];
        SALabeling.calcBBox(position, nx, ny, nw, nh, hms, bbox, hOffset);
    }

    public static void calcBBox(int position, double nx, double ny, double nw, double nh, double hms, Rectangle2D.Double bbox, double hOffset) {
        switch (position) {
            case -1: {
                bbox.x = nx - hms;
                bbox.y = ny + hms;
                bbox.width = 2.25 * hms;
                bbox.height = 2.25 * hms;
                break;
            }
            case 0: {
                bbox.x = nx + hms;
                bbox.y = ny + nh + hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 4: {
                bbox.x = nx - nw - hms;
                bbox.y = ny + nh + hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 3: {
                bbox.x = nx + hms;
                bbox.y = ny - hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 7: {
                bbox.x = nx - nw - hms;
                bbox.y = ny - hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 2: {
                bbox.x = nx + hms + hOffset;
                bbox.y = ny + nh / 2.0;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 1: {
                bbox.x = nx - nw / 2.0;
                bbox.y = ny + nh + hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 6: {
                bbox.x = nx - nw - hms - hOffset;
                bbox.y = ny + nh / 2.0;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 5: {
                bbox.x = nx - nw / 2.0;
                bbox.y = ny - hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 8: {
                bbox.x = nx - nw / 4.0;
                bbox.y = ny + nh + hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 9: {
                bbox.x = nx - 3.0 * nw / 4.0;
                bbox.y = ny + nh + hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 10: {
                bbox.x = nx - nw / 4.0;
                bbox.y = ny - hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 11: {
                bbox.x = nx - 3.0 * nw / 4.0;
                bbox.y = ny - hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            default: {
                System.err.println("Unrecognized label position: value out-of-bounds!");
            }
        }
    }

    public static void calcBBox2(int position, double nx, double ny, double nw, double nh, double hms, Rectangle2D.Double bbox, double hOffset) {
        switch (position) {
            case 0: {
                bbox.x = nx + hms;
                bbox.y = ny - nh - hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 4: {
                bbox.x = nx - nw - hms;
                bbox.y = ny - nh - hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 3: {
                bbox.x = nx + hms;
                bbox.y = ny + hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 7: {
                bbox.x = nx - nw - hms;
                bbox.y = ny + hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 2: {
                bbox.x = nx + hms + hOffset;
                bbox.y = ny - nh / 2.0;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 1: {
                bbox.x = nx - nw / 2.0;
                bbox.y = ny - nh - hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 6: {
                bbox.x = nx - nw - hms - hOffset;
                bbox.y = ny - nh / 2.0;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 5: {
                bbox.x = nx - nw / 2.0;
                bbox.y = ny + hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 8: {
                bbox.x = nx - nw / 4.0;
                bbox.y = ny - nh - hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 9: {
                bbox.x = nx - 3.0 * nw / 4.0;
                bbox.y = ny - nh - hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 10: {
                bbox.x = nx - nw / 4.0;
                bbox.y = ny + hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            case 11: {
                bbox.x = nx - 3.0 * nw / 4.0;
                bbox.y = ny + hms;
                bbox.width = nw;
                bbox.height = nh;
                break;
            }
            default: {
                System.err.println("Unrecognized label position: value out-of-bounds!");
            }
        }
    }

    private double[][] calcCoord(int[] bestgene) {
        double[][] outxy = new double[this.M][2];
        block14: for (int i = 0; i < this.M; ++i) {
            switch (bestgene[i]) {
                case 0: {
                    outxy[i][0] = this.x[i] + (this.w[i] + (double)this.markerSize.get(i).intValue()) / 2.0;
                    outxy[i][1] = this.y[i] + this.h[i] / 2.0;
                    continue block14;
                }
                case 1: {
                    outxy[i][0] = this.x[i];
                    outxy[i][1] = this.y[i] + ((double)this.markerSize.get(i).intValue() + this.h[i]) / 2.0;
                    continue block14;
                }
                case 2: {
                    outxy[i][0] = this.x[i] + (this.w[i] + (double)this.markerSize.get(i).intValue()) / 2.0 + 0.25 * this.h[i];
                    outxy[i][1] = this.y[i];
                    continue block14;
                }
                case 3: {
                    outxy[i][0] = this.x[i] + (this.w[i] + (double)this.markerSize.get(i).intValue()) / 2.0;
                    outxy[i][1] = this.y[i] - this.h[i] / 2.0;
                    continue block14;
                }
                case 4: {
                    outxy[i][0] = this.x[i] - (this.w[i] + (double)this.markerSize.get(i).intValue()) / 2.0;
                    outxy[i][1] = this.y[i] + this.h[i] / 2.0;
                    continue block14;
                }
                case 5: {
                    outxy[i][0] = this.x[i];
                    outxy[i][1] = this.y[i] - ((double)this.markerSize.get(i).intValue() + this.h[i]) / 2.0;
                    continue block14;
                }
                case 6: {
                    outxy[i][0] = this.x[i] - (this.w[i] + (double)this.markerSize.get(i).intValue()) / 2.0 - 0.25 * this.h[i];
                    outxy[i][1] = this.y[i];
                    continue block14;
                }
                case 7: {
                    outxy[i][0] = this.x[i] - (this.w[i] + (double)this.markerSize.get(i).intValue()) / 2.0;
                    outxy[i][1] = this.y[i] - this.h[i] / 2.0;
                    continue block14;
                }
                case 8: {
                    outxy[i][0] = this.x[i] + (this.w[i] + (double)this.markerSize.get(i).intValue()) / 4.0;
                    outxy[i][1] = this.y[i] + this.h[i] / 2.0 + (double)(this.markerSize.get(i) / 4);
                    continue block14;
                }
                case 9: {
                    outxy[i][0] = this.x[i] - (this.w[i] + (double)this.markerSize.get(i).intValue()) / 4.0;
                    outxy[i][1] = this.y[i] + this.h[i] / 2.0 + (double)(this.markerSize.get(i) / 4);
                    continue block14;
                }
                case 10: {
                    outxy[i][0] = this.x[i] + (this.w[i] + (double)this.markerSize.get(i).intValue()) / 4.0;
                    outxy[i][1] = this.y[i] - this.h[i] / 2.0 - (double)(this.markerSize.get(i) / 4);
                    continue block14;
                }
                case 11: {
                    outxy[i][0] = this.x[i] - (this.w[i] + (double)this.markerSize.get(i).intValue()) / 4.0;
                    outxy[i][1] = this.y[i] - this.h[i] / 2.0 - (double)(this.markerSize.get(i) / 4);
                    continue block14;
                }
                default: {
                    outxy[i][0] = this.y[i];
                    outxy[i][1] = this.x[i];
                    System.err.println("Unrecognized label position: value out-of-bounds!");
                }
            }
        }
        return outxy;
    }

    public void reduceFonts() {
        for (int i = 0; i < this.fm.size(); ++i) {
            Font f = this.fm.get(i).getFont();
            if (f.getSize() <= Graph.MIN_FONTSIZE) continue;
            f = new Font(f.getFamily(), f.getStyle(), f.getSize() - 1);
            FontMetrics fmi = StatGraph.getFontMetrics(f);
            this.fm.set(i, fmi);
        }
    }

    public static int[] getPreferredCandidates(double xStart, double yStart, double xEnd, double yEnd, double width, double height) {
        if (xStart == xEnd) {
            if (yStart < yEnd) {
                return new int[]{5, 10, 11, 3, 7};
            }
            return new int[]{1, 8, 9, 0, 4};
        }
        double dx = xEnd - xStart;
        double dy = yEnd - yStart;
        double r = Math.sqrt(dx * dx + dy * dy);
        if (r == 0.0) {
            return null;
        }
        double angle = SALabeling.computeAngle(dx, dy);
        ArrayList<Point2D.Double> can = new ArrayList<Point2D.Double>();
        Rectangle2D.Double bbx = new Rectangle2D.Double();
        for (int i = 0; i < 12; ++i) {
            SALabeling.calcBBox2(i, xEnd, yEnd, width, height, 3.0, bbx, 1.0);
            double xc = bbx.getCenterX();
            double yc = bbx.getCenterY();
            dx = xc - xStart;
            dy = yc - yStart;
            double d = Math.sqrt(dx * dx + dy * dy);
            if (!(d > r)) continue;
            double angle2 = SALabeling.computeAngle(dx, dy);
            can.add(new Point2D.Double(i, Math.abs(angle2 - angle)));
        }
        Comparator<Point2D> comparator = new Comparator<Point2D>(){

            @Override
            public int compare(Point2D pi, Point2D pj) {
                return (int)(pi.getY() - pj.getY());
            }
        };
        Collections.sort(can, comparator);
        int[] candidates = new int[can.size()];
        for (int i = 0; i < can.size(); ++i) {
            candidates[i] = (int)((Point2D)can.get(i)).getX();
        }
        return candidates;
    }

    private static double computeAngle(double dx, double dy) {
        double rad = 0.0;
        if (dx == 0.0) {
            rad = dy > 0.0 ? 1.5707963267948966 : 2.356194490192345;
        } else if (dy == 0.0) {
            rad = dx > 0.0 ? 0.0 : Math.PI;
        } else {
            rad = Math.atan(dy / dx);
            if (dx < 0.0 && dy > 0.0) {
                rad += Math.PI;
            } else if (dx < 0.0 && dy < 0.0) {
                rad += Math.PI;
            } else if (dx > 0.0 && dy < 0.0) {
                rad += Math.PI * 2;
            }
        }
        return rad * 180.0 / Math.PI;
    }
}

