/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.labeling;

import com.sas.graphics.applets.statgraph.sgchart.labeling.CurveNode;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public final class CurveGraph {
    public static final int INSIDE = 0;
    public static final int OUTSIDE = 1;
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int START = 2;
    public static final int END = 3;
    public static final int XAXIS = 0;
    public static final int X2AXIS = 1;
    public static final int YAXIS = 2;
    public static final int Y2AXIS = 3;
    public static final int padding = 3;
    private boolean xRotated = false;
    private boolean x2Rotated = false;
    public static double rotationAngle = 90.0;
    private ArrayList nodes;
    private Rectangle clipBounds;
    private Rectangle dataBounds;
    private Polygon px;
    private Polygon px2;
    private Polygon py;
    private Polygon py2;
    private Polygon cpx;
    private Polygon cpx2;
    private Polygon cpy;
    private Polygon cpy2;
    private Insets innerMargin = new Insets(0, 0, 0, 0);
    private ArrayList xNodes;
    private ArrayList x2Nodes;
    private ArrayList yNodes;
    private ArrayList y2Nodes;
    private int leftMaxLength;
    private int rightMaxLength;
    private int topMaxLength;
    private int bottomMaxLength;
    public static final int ANY_SIDE = 0;
    public static final int LEFT_OR_RIGHT_SIDE = 1;
    public static final int TOP_OR_BOTTOM_SIDE = 2;
    private int forceSide = 0;

    public CurveGraph(Rectangle bounds, Rectangle dataArea, Insets margin, boolean xRotated, boolean x2Rotated) {
        this.clipBounds = bounds;
        this.dataBounds = dataArea;
        if (margin != null) {
            this.innerMargin = margin;
        }
        this.xRotated = xRotated;
        this.x2Rotated = x2Rotated;
        this.nodes = new ArrayList();
        this.px = new Polygon();
        this.px2 = new Polygon();
        this.py = new Polygon();
        this.py2 = new Polygon();
        CurveGraph.getPartitions(this.dataBounds, this.px, this.px2, this.py, this.py2);
        this.cpx = new Polygon();
        this.cpx2 = new Polygon();
        this.cpy = new Polygon();
        this.cpy2 = new Polygon();
        CurveGraph.getPartitions(this.clipBounds, this.cpx, this.cpx2, this.cpy, this.cpy2);
        this.xNodes = new ArrayList();
        this.x2Nodes = new ArrayList();
        this.yNodes = new ArrayList();
        this.y2Nodes = new ArrayList();
    }

    public CurveNode addNode(int id, String label, int x, int y, Color color, int location, int position, FontMetrics fm, boolean extended, int closestAxis) {
        CurveNode n = new CurveNode(id, label, x, y, color, fm);
        n.location = location;
        n.position = position;
        int axis = closestAxis >= 0 ? closestAxis : this.closestAxis(x, y, extended);
        switch (axis) {
            case 0: {
                this.xNodes.add(n);
                n.rotated = this.xRotated;
                this.bottomMaxLength = Math.max(this.bottomMaxLength, n.getWidth());
                break;
            }
            case 1: {
                this.x2Nodes.add(n);
                n.rotated = this.x2Rotated;
                this.topMaxLength = Math.max(this.topMaxLength, n.getWidth());
                break;
            }
            case 2: {
                this.yNodes.add(n);
                this.leftMaxLength = Math.max(this.leftMaxLength, n.getWidth());
                break;
            }
            case 3: {
                this.y2Nodes.add(n);
                this.rightMaxLength = Math.max(this.rightMaxLength, n.getWidth());
                break;
            }
            default: {
                n.text = "";
            }
        }
        this.nodes.add(n);
        return n;
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public CurveNode getNode(int index) {
        return (CurveNode)this.nodes.get(index);
    }

    public void layoutLabels() {
        CurveNode n;
        int i;
        this.arrangeLabels(this.xNodes, 0);
        this.arrangeLabels(this.x2Nodes, 1);
        this.arrangeLabels(this.yNodes, 2);
        this.arrangeLabels(this.y2Nodes, 2);
        for (i = 0; i < this.xNodes.size(); ++i) {
            n = (CurveNode)this.xNodes.get(i);
            this.setFixedOutputs(n, 0);
        }
        for (i = 0; i < this.x2Nodes.size(); ++i) {
            n = (CurveNode)this.x2Nodes.get(i);
            this.setFixedOutputs(n, 1);
        }
        for (i = 0; i < this.yNodes.size(); ++i) {
            n = (CurveNode)this.yNodes.get(i);
            this.setFixedOutputs(n, 2);
        }
        for (i = 0; i < this.y2Nodes.size(); ++i) {
            n = (CurveNode)this.y2Nodes.get(i);
            this.setFixedOutputs(n, 3);
        }
    }

    private void arrangeLabels(ArrayList sn, int axis) {
        int d;
        CurveNode curr;
        int i;
        if (sn.size() == 0) {
            return;
        }
        Comparator cm = axis == 0 || axis == 1 ? new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((CurveNode)o1).x - ((CurveNode)o2).x;
            }
        } : new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((CurveNode)o1).y - ((CurveNode)o2).y;
            }
        };
        Collections.sort(sn, cm);
        if (sn.size() < 3) {
            CurveNode prev = (CurveNode)sn.get(0);
            if (sn.size() == 1) {
                prev.clip(this.clipBounds, axis);
            } else {
                for (int i2 = 0; i2 < 2; ++i2) {
                    CurveNode curr2 = (CurveNode)sn.get(i2);
                    if (prev != curr2) {
                        int d2 = prev.getUpper(axis) - curr2.getLower(axis);
                        if (d2 > 0) {
                            curr2.shift(d2, this.clipBounds, axis);
                        } else {
                            curr2.clip(this.clipBounds, axis);
                        }
                    } else {
                        curr2.clip(this.clipBounds, axis);
                    }
                    prev = curr2;
                }
            }
            return;
        }
        int startpoint = this.findStartIndex(sn, axis);
        CurveNode prev = (CurveNode)sn.get(startpoint);
        for (i = startpoint - 1; i >= 0; --i) {
            curr = (CurveNode)sn.get(i);
            if (curr.text == null || curr.text.trim().length() == 0) continue;
            d = prev.getLower(axis) - curr.getUpper(axis);
            if (d < 0) {
                curr.shift(d, this.clipBounds, axis);
            } else {
                curr.clip(this.clipBounds, axis);
            }
            prev = curr;
        }
        prev = (CurveNode)sn.get(startpoint);
        for (i = startpoint + 1; i < sn.size(); ++i) {
            curr = (CurveNode)sn.get(i);
            if (curr.text == null || curr.text.trim().length() == 0) continue;
            d = prev.getUpper(axis) - curr.getLower(axis);
            if (d > 0) {
                curr.shift(d, this.clipBounds, axis);
            } else {
                curr.clip(this.clipBounds, axis);
            }
            prev = curr;
        }
    }

    private int findStartIndex(ArrayList sn, int axis) {
        int midpoint;
        int idx = midpoint = (sn.size() - 1) / 2;
        CurveNode n = (CurveNode)sn.get(midpoint);
        switch (axis) {
            case 2: 
            case 3: {
                int y = n.out_y;
                int yt = this.clipBounds.y + this.clipBounds.height;
                int yb = this.clipBounds.y;
                if (this.clipBounds.height > sn.size() * n.getHeight()) {
                    if ((double)(yt - y) < ((double)(sn.size() - 1 - midpoint) + 0.5) * (double)n.getHeight()) {
                        idx = sn.size() - 1;
                        break;
                    }
                    if ((double)(y - yb) < ((double)midpoint + 0.5) * (double)n.getHeight()) {
                        idx = 0;
                        break;
                    }
                    idx = midpoint;
                    break;
                }
                idx = midpoint;
                break;
            }
            case 0: 
            case 1: {
                CurveNode cn;
                int i;
                int x = n.out_x;
                int xr = this.clipBounds.x + this.clipBounds.width;
                int xl = this.clipBounds.x;
                if (this.xRotated || this.x2Rotated) {
                    if (this.clipBounds.width > sn.size() * n.getHeight()) {
                        if ((double)(xr - x) < ((double)(sn.size() - 1 - midpoint) + 0.5) * (double)n.getHeight()) {
                            idx = sn.size() - 1;
                            break;
                        }
                        if ((double)(x - xl) < ((double)midpoint + 0.5) * (double)n.getHeight()) {
                            idx = 0;
                            break;
                        }
                        idx = midpoint;
                        break;
                    }
                    idx = midpoint;
                    break;
                }
                int twr = 0;
                int twl = 0;
                for (i = midpoint + 1; i < sn.size(); ++i) {
                    cn = (CurveNode)sn.get(i);
                    twr += cn.getWidth();
                }
                for (i = midpoint - 1; i >= 0; --i) {
                    cn = (CurveNode)sn.get(i);
                    twl += cn.getWidth();
                }
                idx = xr - x < twr + n.getWidth() / 2 ? sn.size() - 1 : (x - xl < twl + n.getWidth() / 2 ? 0 : midpoint);
            }
        }
        return idx;
    }

    public static void getPartitions(Rectangle bounds, Polygon p1, Polygon p2, Polygon p3, Polygon p4) {
        int nudge = 1;
        p1.addPoint(bounds.x - nudge, bounds.y - nudge);
        p1.addPoint(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        p1.addPoint(bounds.x + bounds.width + nudge, bounds.y - nudge);
        p2.addPoint(bounds.x - nudge, bounds.y + bounds.height + nudge);
        p2.addPoint(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        p2.addPoint(bounds.x + bounds.width + nudge, bounds.y + bounds.height + nudge);
        p3.addPoint(bounds.x - nudge, bounds.y - nudge);
        p3.addPoint(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        p3.addPoint(bounds.x - nudge, bounds.y + bounds.height + nudge);
        p4.addPoint(bounds.x + bounds.width + nudge, bounds.y - nudge);
        p4.addPoint(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        p4.addPoint(bounds.x + bounds.width + nudge, bounds.y + bounds.height + nudge);
    }

    public int closestAxis(int x, int y, boolean extended) {
        Rectangle b = extended ? this.clipBounds : this.dataBounds;
        switch (this.forceSide) {
            default: {
                if (extended) {
                    return CurveGraph.closestAxis(x, y, this.cpx, this.cpx2, this.cpy, this.cpy2);
                }
                return CurveGraph.closestAxis(x, y, this.px, this.px2, this.py, this.py2);
            }
            case 1: {
                if (x < b.x + b.width / 2) {
                    return 2;
                }
                return 3;
            }
            case 2: 
        }
        if (y < b.y + b.height / 2) {
            return 0;
        }
        return 1;
    }

    public static int closestAxis(int x, int y, Polygon xa, Polygon x2a, Polygon ya, Polygon y2a) {
        if (y2a.contains(x, y)) {
            return 3;
        }
        if (x2a.contains(x, y)) {
            return 1;
        }
        if (ya.contains(x, y)) {
            return 2;
        }
        if (xa.contains(x, y)) {
            return 0;
        }
        return -1;
    }

    private void setFixedOutputs(CurveNode n, int axis) {
        block0 : switch (axis) {
            case 3: {
                switch (n.location) {
                    case 1: {
                        switch (n.position) {
                            case 0: 
                            case 1: {
                                n.out_x = this.clipBounds.x + this.clipBounds.width + 3;
                                n.out_halign = 0;
                            }
                        }
                        break;
                    }
                    case 0: {
                        switch (n.position) {
                            case 0: 
                            case 1: {
                                n.out_x = this.clipBounds.x + this.clipBounds.width - this.rightMaxLength - 3 - this.innerMargin.right;
                                n.out_halign = 0;
                            }
                        }
                    }
                }
                break;
            }
            case 2: {
                switch (n.location) {
                    case 1: {
                        switch (n.position) {
                            case 0: 
                            case 1: {
                                n.out_x = this.clipBounds.x - 3;
                                n.out_halign = 2;
                            }
                        }
                        break;
                    }
                    case 0: {
                        switch (n.position) {
                            case 0: 
                            case 1: {
                                n.out_x = this.clipBounds.x + 3 + this.leftMaxLength + this.innerMargin.left;
                                n.out_halign = 2;
                            }
                        }
                    }
                }
                break;
            }
            case 0: {
                block26 : switch (n.location) {
                    case 1: {
                        switch (n.position) {
                            case 0: 
                            case 1: {
                                n.out_y = this.clipBounds.y - 3;
                                n.out_halign = this.xRotated && rotationAngle == 45.0 ? 2 : 1;
                                n.out_valign = 0;
                            }
                        }
                        break;
                    }
                    case 0: {
                        switch (n.position) {
                            case 0: 
                            case 1: {
                                n.out_y = this.clipBounds.y + 3 + this.innerMargin.bottom;
                                if (this.xRotated) {
                                    n.out_y = this.clipBounds.y + 3 + (int)((double)this.bottomMaxLength * Math.sin(Math.toRadians(rotationAngle))) + this.innerMargin.bottom;
                                    if (rotationAngle == 45.0) {
                                        n.out_valign = 3;
                                        n.out_halign = 2;
                                        break block26;
                                    }
                                    n.out_valign = 0;
                                    n.out_halign = 1;
                                    break block26;
                                }
                                n.out_y = this.clipBounds.y + 3 + this.innerMargin.bottom;
                                n.out_valign = 3;
                                n.out_halign = 1;
                            }
                        }
                    }
                }
                break;
            }
            case 1: {
                switch (n.location) {
                    case 1: {
                        switch (n.position) {
                            case 0: 
                            case 1: {
                                n.out_y = this.clipBounds.y + this.clipBounds.height + 3;
                                n.out_halign = this.x2Rotated && rotationAngle == 45.0 ? 0 : 1;
                                n.out_valign = 3;
                            }
                        }
                        break block0;
                    }
                    case 0: {
                        switch (n.position) {
                            case 0: 
                            case 1: {
                                if (this.x2Rotated) {
                                    n.out_y = this.clipBounds.y + this.clipBounds.height - 3 - (int)((double)this.topMaxLength * Math.sin(Math.toRadians(rotationAngle))) - this.innerMargin.top;
                                    if (rotationAngle == 45.0) {
                                        n.out_valign = 1;
                                        n.out_halign = 0;
                                        break block0;
                                    }
                                    n.out_valign = 3;
                                    n.out_halign = 1;
                                    break block0;
                                }
                                n.out_y = this.clipBounds.y + this.clipBounds.height - 3 - this.innerMargin.top;
                                n.out_valign = 0;
                                n.out_halign = 1;
                            }
                        }
                    }
                }
            }
        }
    }
}

