/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.gtk.gl;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;

public class VisibilityVariable
extends NumericVariable {
    public static final int ALL = 0;
    public static final int NONE = 1;
    public static final int PART = 2;
    private Connection connection = new Connection();

    public VisibilityVariable() {
        this.connectFrom();
        this.setName(((Object)((Object)this)).toString());
    }

    protected void connectFrom() {
        this.setRawValuePipe(this.connection, this.connection.getValueCount());
        super.connectFrom();
    }

    public int getValueCount() {
        return this.connection.getValueCount();
    }

    public void setValueCount(int valueCount) {
        this.connection.setValueCount(valueCount);
    }

    public int[] getHidenIndices() {
        return this.connection.getHidenIndices();
    }

    public void hideIndices(int[] indices) {
        this.connection.hideIndices(indices);
    }

    public void setVisibleAll(boolean visible) {
        if (visible) {
            this.connection.setState(0);
        } else {
            this.connection.setState(1);
        }
    }

    private static class Connection
    implements NumericPipe {
        private int state = 0;
        private int[] hidenIndices = null;
        private int valueCount = -1;

        private Connection() {
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public double getValue(int index) throws MissingValueException {
            if (this.state == 0) {
                return 1.0;
            }
            if (this.state == 1) {
                return 0.0;
            }
            if (this.hidenIndices != null) {
                for (int i = 0; i < this.hidenIndices.length; ++i) {
                    if (this.hidenIndices[i] != index) continue;
                    return 0.0;
                }
            }
            return 1.0;
        }

        public Formatter getFormatter() {
            return null;
        }

        public void init(AInitAction initAction) {
            initAction.setValueCount(this.getValueCount());
        }

        public void reset(AResetAction resetAction) {
        }

        public int getValueCount() {
            return this.valueCount;
        }

        public void setValueCount(int valueCount) {
            this.valueCount = valueCount;
        }

        public int[] getHidenIndices() {
            return this.hidenIndices;
        }

        public void hideIndices(int[] indices) {
            this.state = 2;
            this.hidenIndices = indices;
        }
    }
}

