/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.gtk.gl;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.ObstaclesInterface;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.labeling.Graph;
import com.sas.graphics.applets.statgraph.sgchart.labeling.Node;
import com.sas.graphics.applets.statgraph.sgchart.labeling.SALabeling;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.HashMap;

public final class PointLabelLayoutManager {
    ArrayList layouts = new ArrayList();
    Graph cg;
    Rectangle clipBounds;
    int yOutputRange;
    protected int maxHLabelShift = 30;
    protected int maxVLabelShift = 30;
    protected int hLabelShiftDelta = 5;
    protected int vLabelShiftDelta = 5;
    public boolean layoutReady = false;
    private boolean userCandidates = false;
    private boolean labelVerbose = false;
    private boolean saLabeling = false;
    private boolean labelDisplaceable = true;
    private HashMap saWeightMap = null;
    private int saMaxIterations = 100;
    private int saSeed = 1234567;
    private SALabeling saObj;
    private boolean diagonalOffset = false;
    static final int MAX_ITERATIONS = 10;
    public boolean fixedFont = false;
    private static final Ellipse2D arrowHeadEllipse = new Ellipse2D.Double(-6.0, -6.0, 12.0, 12.0);

    public void setFixedFont(boolean b) {
        this.fixedFont = b;
    }

    public boolean isFixedFont() {
        return this.fixedFont;
    }

    public PointLabelLayoutManager(Rectangle bounds, int range) {
        this(bounds, range, false);
    }

    public PointLabelLayoutManager(Rectangle bounds, int range, boolean user) {
        this.clipBounds = bounds;
        this.yOutputRange = range;
        this.userCandidates = user;
    }

    public void updateClipBounds(Rectangle bounds, int range) {
        this.clipBounds = bounds;
        this.yOutputRange = range;
    }

    public void addLayout(PointLabelLayout layout) {
        if (this.layouts.contains((Object)layout)) {
            return;
        }
        this.layouts.add(layout);
        layout.setLayoutManager(this);
    }

    public void init(PointLabelLayout layout, AInitAction initAction) {
        if (!this.layoutReady) {
            return;
        }
        int vc = 0;
        boolean beenInitialized = true;
        for (int i = 0; i < this.layouts.size(); ++i) {
            PointLabelLayout l = (PointLabelLayout)((Object)this.layouts.get(i));
            initAction.pushValueCount();
            l.x.init(initAction);
            l.y.init(initAction);
            l.label.init(initAction);
            l.visibility.init(initAction);
            vc = initAction.getValueCount();
            l.setValueCount(vc);
            initAction.popValueCount();
            beenInitialized &= initAction.beenInitialized((PropertyContainer)l);
        }
        if (beenInitialized) {
            return;
        }
        if (this.saLabeling) {
            this.initSAObj();
        } else {
            this.initGraph();
        }
    }

    private double scoreLabel2Label(Graph sg) {
        double subscores = 0.0;
        double suminter = 0.0;
        double sumprior = 0.0;
        for (int i = 0; i < sg.getNumNodes(); ++i) {
            for (int j = i; j < sg.getNumNodes(); ++j) {
                Rectangle intR;
                if (sg.getNode((int)i).text == null || sg.getNode((int)i).text.equals("") || sg.getNode((int)j).text == null || sg.getNode((int)j).text.equals("")) continue;
                if (sg.getNode(i).getNumCandidates() == 1 && sg.getNode(j).getNumCandidates() == 1) {
                    intR = sg.getNode(i).getCandidate(0).getBBox().intersection(sg.getNode(j).getCandidate(0).getBBox());
                    if (i == j || intR.width <= 1 || intR.height <= 1) continue;
                    suminter += intR.getWidth() * intR.getHeight();
                    continue;
                }
                if (sg.getNode((int)i).lastRemovedCandidate != null && sg.getNode(j).getNumCandidates() == 1) {
                    intR = sg.getNode((int)i).lastRemovedCandidate.getBBox().intersection(sg.getNode(j).getCandidate(0).getBBox());
                    if (i == j || intR.width <= 1 || intR.height <= 1) continue;
                    suminter += intR.getWidth() * intR.getHeight();
                    continue;
                }
                if (sg.getNode(i).getNumCandidates() == 1 && sg.getNode((int)j).lastRemovedCandidate != null) {
                    intR = sg.getNode(i).getCandidate(0).getBBox().intersection(sg.getNode((int)j).lastRemovedCandidate.getBBox());
                    if (i == j || intR.width <= 1 || intR.height <= 1) continue;
                    suminter += intR.getWidth() * intR.getHeight();
                    continue;
                }
                if (sg.getNode((int)i).lastRemovedCandidate == null || sg.getNode((int)j).lastRemovedCandidate == null) continue;
                intR = sg.getNode((int)i).lastRemovedCandidate.getBBox().intersection(sg.getNode((int)j).lastRemovedCandidate.getBBox());
                if (i == j || intR.width <= 1 || intR.height <= 1) continue;
                suminter += intR.getWidth() * intR.getHeight();
            }
        }
        subscores = suminter / (StatGraph.dataDPIScaleFactor * StatGraph.dataDPIScaleFactor);
        return subscores;
    }

    private double scoreMarker2Label(Graph sg) {
        double subscores = 0.0;
        double suminter = 0.0;
        for (int i = 0; i < sg.getNumNodes(); ++i) {
            for (int j = 0; j < sg.getNumNodes(); ++j) {
                Rectangle intR;
                if (sg.getNode((int)i).text == null || sg.getNode((int)i).text.equals("")) continue;
                if (sg.getNode(i).getNumCandidates() == 1) {
                    intR = sg.getNode(i).getCandidate(0).getBBox().intersection(sg.getNode(j).getMarkerRect());
                    if (i == j || intR.width <= 1 || intR.height <= 1) continue;
                    suminter += intR.getWidth() * intR.getHeight();
                    continue;
                }
                if (sg.getNode((int)i).lastRemovedCandidate == null) continue;
                intR = sg.getNode((int)i).lastRemovedCandidate.getBBox().intersection(sg.getNode(j).getMarkerRect());
                if (i == j || intR.width <= 1 || intR.height <= 1) continue;
                suminter += intR.getWidth() * intR.getHeight();
            }
        }
        subscores = suminter / (StatGraph.dataDPIScaleFactor * StatGraph.dataDPIScaleFactor);
        return subscores;
    }

    public void initGraph() {
        int i;
        int iter;
        this.cg = new Graph(this.clipBounds, this.userCandidates);
        for (int i2 = 0; i2 < this.layouts.size(); ++i2) {
            PointLabelLayout l = (PointLabelLayout)((Object)this.layouts.get(i2));
            l.addObstacles(this.cg, this.yOutputRange);
        }
        if (this.labelDisplaceable) {
            this.cg.setHMaxShift(this.maxHLabelShift);
            this.cg.setVMaxShift(this.maxVLabelShift);
            this.cg.setVDistanceWeight(1.0);
            this.cg.setShiftDeltaX(this.hLabelShiftDelta);
            this.cg.setShiftDeltaY(this.vLabelShiftDelta);
        } else {
            this.cg.setHMaxShift(0);
            this.cg.setVMaxShift(0);
            this.cg.setVDistanceWeight(1.0);
            this.cg.setShiftDeltaX(0);
            this.cg.setShiftDeltaY(0);
        }
        int minFont = this.labelDisplaceable || this.fixedFont ? -1 : Graph.MIN_FONTSIZE;
        boolean preciseBBox = !this.labelDisplaceable;
        int offset = 0;
        for (int i3 = 0; i3 < this.layouts.size(); ++i3) {
            PointLabelLayout l = (PointLabelLayout)((Object)this.layouts.get(i3));
            if (!l.isLabelConnected()) continue;
            for (int j = 0; j < l.getValueCount(); ++j) {
                double xpos = -1.7976931348623157E308;
                double ypos = -1.7976931348623157E308;
                int[] candidates = new int[]{-1};
                try {
                    xpos = l.x.getValue(j);
                    ypos = (double)this.yOutputRange - l.y.getValue(j);
                    candidates = this.getCandidateList(l.candidate.getValue(j));
                    if (l.isVisible(j)) {
                        String str = this.labelDisplaceable ? " " + l.label.getValue(j).trim() + " " : l.label.getValue(j).trim();
                        this.cg.addNode(j, str, (int)xpos, (int)ypos, l.getFontMetrics(), l.getMarkerSize(), candidates, preciseBBox, this.diagonalOffset);
                        continue;
                    }
                    this.cg.addNode(j, "", (int)xpos, (int)ypos, l.getFontMetrics(), l.getMarkerSize(), candidates, preciseBBox, this.diagonalOffset);
                    continue;
                }
                catch (MissingValueException e) {
                    if (xpos == -1.7976931348623157E308 || ypos == -1.7976931348623157E308) {
                        this.cg.addNode(j, null, -1, -1, null, 0, candidates, preciseBBox, this.diagonalOffset);
                        continue;
                    }
                    this.cg.addNode(j, " ", (int)xpos, (int)ypos, l.getFontMetrics(), l.getMarkerSize(), candidates, preciseBBox, this.diagonalOffset);
                }
            }
            l.setIndexOffset(offset);
            offset += l.getValueCount();
        }
        int fontDec = 0;
        int n = iter = minFont > 0 ? 10 : 1;
        if (iter > 1 && this.getMaxFontSize() <= minFont) {
            iter = 1;
        }
        double previousScore = 0.0;
        for (i = 0; i < iter; ++i) {
            this.cg.buildConflictGraph();
            this.cg.placeLabels();
            double labelScore = this.scoreLabel2Label(this.cg);
            double markerScore = this.scoreMarker2Label(this.cg);
            double totalShift = this.cg.getTotalShiftedDistance();
            double totalScore = labelScore + markerScore + totalShift;
            if (this.labelVerbose) {
                if (this.cg.getTotalShiftedDistance() == 0) {
                    System.out.println("Scores ===> Label:" + labelScore + "  Marker:" + markerScore);
                } else {
                    System.out.println("Scores ===> Label:" + labelScore + "  Marker:" + markerScore + "  Total displacement:" + totalShift);
                }
            }
            if (this.diagonalOffset || totalScore < (double)Graph.MIN_ACCEPTABLE_SCORE && totalShift < 50.0 || totalScore == previousScore || i + 1 == iter) break;
            previousScore = totalScore;
            ++fontDec;
            this.cg.reduceFonts();
        }
        if (fontDec > 0) {
            for (i = 0; i < this.layouts.size(); ++i) {
                int oldSize;
                ObstaclesInterface oi;
                RasterLabel rl;
                PointLabelLayout l = (PointLabelLayout)((Object)this.layouts.get(i));
                if (!l.isLabelConnected() || (rl = (oi = l.getObstaclesSource()).getRasterDataLabel()) == null || (oldSize = rl.fontSize.getValue()) <= Graph.MIN_FONTSIZE) continue;
                int newSize = Math.max(Graph.MIN_FONTSIZE, oldSize - fontDec);
                rl.fontSize.setValue(newSize);
            }
        }
    }

    private int getMaxFontSize() {
        int maxFontSize = Graph.MIN_FONTSIZE;
        for (int i = 0; i < this.layouts.size(); ++i) {
            PointLabelLayout l = (PointLabelLayout)((Object)this.layouts.get(i));
            if (l.getFontMetrics() == null) continue;
            maxFontSize = Math.max(maxFontSize, l.getFontMetrics().getFont().getSize());
        }
        return maxFontSize;
    }

    public void initSAObj() {
        int i;
        int iter;
        PointLabelLayout l;
        int i2;
        int offset = 0;
        this.saObj = new SALabeling(this.clipBounds, this.yOutputRange, this.labelVerbose);
        if (this.saWeightMap != null) {
            this.saObj.setWeightMap(this.saWeightMap);
        }
        this.saObj.setMainIterations(this.saMaxIterations);
        this.saObj.setSeed(this.saSeed);
        for (i2 = 0; i2 < this.layouts.size(); ++i2) {
            l = (PointLabelLayout)((Object)this.layouts.get(i2));
            l.addObstacles(this.saObj, this.yOutputRange);
            l.setPreferredCadidates(this.yOutputRange);
        }
        for (i2 = 0; i2 < this.layouts.size(); ++i2) {
            l = (PointLabelLayout)((Object)this.layouts.get(i2));
            if (!l.isLabelConnected()) continue;
            for (int j = 0; j < l.getValueCount(); ++j) {
                double xpos = -1.7976931348623157E308;
                double ypos = -1.7976931348623157E308;
                try {
                    xpos = l.x.getValue(j);
                    ypos = l.y.getValue(j);
                    this.saObj.addValue(new Double(xpos), new Double(ypos));
                }
                catch (MissingValueException e) {
                    if (xpos == -1.7976931348623157E308 || ypos == -1.7976931348623157E308) {
                        this.saObj.addValue(new Double(this.clipBounds.getCenterX()), new Double(this.clipBounds.getCenterY()));
                    }
                    this.saObj.addValue(new Double(xpos), new Double(ypos));
                }
                try {
                    if (l.isVisible(j)) {
                        String str = l.label.getValue(j).trim();
                        if (xpos == -1.7976931348623157E308 || ypos == -1.7976931348623157E308) {
                            this.saObj.addLabel("", l.getMarkerSize());
                        } else {
                            this.saObj.addLabel(str, l.getMarkerSize());
                        }
                    } else {
                        this.saObj.addLabel("", l.getMarkerSize());
                    }
                    this.saObj.addFontMetrics(l.getFontMetrics());
                }
                catch (MissingValueException e) {
                    this.saObj.addLabel("", l.getMarkerSize());
                    this.saObj.addFontMetrics(l.getFontMetrics());
                }
                int[] can = l.preferredCandidates.size() > 0 ? l.preferredCandidates.get(j) : null;
                this.saObj.addCustomPenalty(this.saObj.getCustomPenalty(can));
            }
            l.setIndexOffset(offset);
            offset += l.getValueCount();
        }
        int minFont = Graph.MIN_FONTSIZE;
        int fontDec = 0;
        int n = iter = minFont > 0 ? 10 : 1;
        if (iter > 1 && this.getMaxFontSize() <= minFont) {
            iter = 1;
        }
        double previousScore = 0.0;
        for (i = 0; i < iter; ++i) {
            double totalScore;
            if (this.labelVerbose) {
                System.out.println("*** Shrink font: iteration " + (i + 1) + " ***");
            }
            if ((totalScore = this.saObj.SALabelingMain()) < (double)Graph.MIN_ACCEPTABLE_SCORE || totalScore == previousScore || i + 1 == iter) break;
            previousScore = totalScore;
            ++fontDec;
            this.saObj.reduceFonts();
        }
        if (fontDec > 0) {
            for (i = 0; i < this.layouts.size(); ++i) {
                ObstaclesInterface oi;
                RasterLabel rl;
                PointLabelLayout l2 = (PointLabelLayout)((Object)this.layouts.get(i));
                if (!l2.isLabelConnected() || (rl = (oi = l2.getObstaclesSource()).getRasterDataLabel()) == null) continue;
                int oldSize = rl.fontSize.getValue();
                if (this.labelVerbose) {
                    System.out.println("*** Shrink font: oldFont = " + oldSize + " ***");
                }
                if (oldSize <= Graph.MIN_FONTSIZE) continue;
                int newSize = Math.max(Graph.MIN_FONTSIZE, oldSize - fontDec);
                if (this.labelVerbose) {
                    System.out.println("*** Shrink font: newFont = " + newSize + " ***");
                }
                rl.fontSize.setValue(newSize);
            }
        } else {
            this.saObj.SALabelingMain();
        }
    }

    private int[] getCandidateList(double[] candidate) {
        int[] list = new int[candidate.length];
        for (int i = 0; i < candidate.length; ++i) {
            list[i] = (int)candidate[i];
        }
        return list;
    }

    public int getAlignValue(int i, PointLabelLayout layout, boolean v) {
        int align;
        Node n;
        if (!layout.isVisible(i)) {
            return -1;
        }
        if (this.saLabeling || !this.labelDisplaceable) {
            return 1;
        }
        try {
            n = this.cg.getNode(i + layout.getIndexOffset());
        }
        catch (Exception e) {
            return -1;
        }
        if (n.text == null || n.text.trim().length() == 0) {
            return -1;
        }
        switch (n.getLabelPosition()) {
            case 0: {
                if (!v) {
                    align = 0;
                    break;
                }
                align = 3;
                break;
            }
            case 1: {
                if (!v) {
                    align = 2;
                    break;
                }
                align = 3;
                break;
            }
            case 2: {
                if (!v) {
                    align = 0;
                    break;
                }
                align = 0;
                break;
            }
            case 3: {
                if (!v) {
                    align = 2;
                    break;
                }
                align = 0;
                break;
            }
            case 4: {
                if (!v) {
                    align = 0;
                    break;
                }
                align = 1;
                break;
            }
            case 5: {
                if (!v) {
                    align = 1;
                    break;
                }
                align = 3;
                break;
            }
            case 6: {
                if (!v) {
                    align = 2;
                    break;
                }
                align = 1;
                break;
            }
            case 7: {
                if (!v) {
                    align = 1;
                    break;
                }
                align = 0;
                break;
            }
            default: {
                align = -1;
            }
        }
        return align;
    }

    public String getLabelValue(int i, PointLabelLayout layout) {
        Node n;
        if (!layout.isVisible(i)) {
            return null;
        }
        if (this.saLabeling) {
            return this.saObj.labels[i + layout.getIndexOffset()];
        }
        try {
            n = this.cg.getNode(i + layout.getIndexOffset());
        }
        catch (Exception e) {
            return null;
        }
        if (n.text == null || n.text.trim().length() == 0) {
            return null;
        }
        return n.text;
    }

    public double getPositionValue(int i, PointLabelLayout layout, boolean v) {
        double value;
        Node n;
        if (!layout.isVisible(i)) {
            return Double.NaN;
        }
        if (this.saLabeling) {
            if (v) {
                return this.saObj.outxy[i + layout.getIndexOffset()][1];
            }
            return this.saObj.outxy[i + layout.getIndexOffset()][0];
        }
        if (!this.labelDisplaceable) {
            try {
                n = this.cg.getNode(i + layout.getIndexOffset());
                if (n.getNumCandidates() == 1) {
                    return v ? (double)this.yOutputRange - n.getCandidate(0).getBBox().getCenterY() : n.getCandidate(0).getBBox().getCenterX();
                }
                if (n.lastRemovedCandidate != null) {
                    return v ? (double)this.yOutputRange - n.lastRemovedCandidate.getBBox().getCenterY() : n.lastRemovedCandidate.getBBox().getCenterX();
                }
            }
            catch (Exception e) {
                return Double.NaN;
            }
        }
        try {
            n = this.cg.getNode(i + layout.getIndexOffset());
            value = v ? layout.y.getValue(i) - (double)n.dy : layout.x.getValue(i) + (double)n.dx;
            int hms = layout.getMarkerSize() / 2;
            value += (double)this.offsetByHalfMarkerSize(n.getLabelPosition(), v, hms);
        }
        catch (Exception e) {
            return Double.NaN;
        }
        if (n.text == null || n.text.trim().length() == 0) {
            return Double.NaN;
        }
        return value;
    }

    private int offsetByHalfMarkerSize(int labelPosition, boolean vertical, int hms) {
        int offset = 0;
        switch (labelPosition) {
            default: {
                break;
            }
            case 0: {
                if (vertical) break;
                offset = hms;
                break;
            }
            case 1: {
                if (vertical) break;
                offset = -hms;
                break;
            }
            case 2: {
                if (vertical) break;
                offset = hms;
                break;
            }
            case 3: {
                if (vertical) break;
                offset = -hms;
                break;
            }
            case 4: {
                if (vertical) break;
                offset = hms;
                break;
            }
            case 5: {
                if (!vertical) break;
                offset = hms;
                break;
            }
            case 6: {
                if (vertical) break;
                offset = -hms;
                break;
            }
            case 7: {
                if (!vertical) break;
                offset = -hms;
            }
        }
        return offset;
    }

    private static Shape createArrowHeadBBox(double x1, double y1, double x2, double y2) {
        AffineTransform at;
        double d = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        if (d == 0.0) {
            at = AffineTransform.getTranslateInstance(x2, y2);
        } else {
            double x = x2 - 4.0 * (x2 - x1) / d;
            double y = y2 - 4.0 * (y2 - y1) / d;
            at = AffineTransform.getTranslateInstance(x, y);
        }
        return at.createTransformedShape(arrowHeadEllipse);
    }

    public int getHLabelShiftDelta() {
        return this.hLabelShiftDelta;
    }

    public void setHLabelShiftDelta(int labelShiftDeltaX) {
        this.hLabelShiftDelta = labelShiftDeltaX;
    }

    public int getVLabelShiftDelta() {
        return this.vLabelShiftDelta;
    }

    public void setVLabelShiftDelta(int labelShiftDeltaY) {
        this.vLabelShiftDelta = labelShiftDeltaY;
    }

    public int getMaxHLabelShift() {
        return this.maxHLabelShift;
    }

    public void setMaxHLabelShift(int maxHLabelShift) {
        this.maxHLabelShift = maxHLabelShift;
    }

    public int getMaxVLabelShift() {
        return this.maxVLabelShift;
    }

    public void setMaxVLabelShift(int maxVLabelShift) {
        this.maxVLabelShift = maxVLabelShift;
    }

    public boolean isSALabeling() {
        return this.saLabeling;
    }

    public void setSALabeling(boolean saLabeling) {
        this.saLabeling = saLabeling;
    }

    public boolean isLabelDisplaceable() {
        return this.labelDisplaceable;
    }

    public void setLabelDisplaceable(boolean labelDisplaceable) {
        this.labelDisplaceable = labelDisplaceable;
    }

    public HashMap getSAWeightMap() {
        return this.saWeightMap;
    }

    public void setSAWeightMap(HashMap saWeightMap) {
        this.saWeightMap = saWeightMap;
    }

    public boolean isLabelVerbose() {
        return this.labelVerbose;
    }

    public void setLabelVerbose(boolean labelVerbose) {
        this.labelVerbose = labelVerbose;
    }

    public int getSAMaxIterations() {
        return this.saMaxIterations;
    }

    public void setSAMaxIterations(int saMaxIterations) {
        this.saMaxIterations = saMaxIterations;
    }

    public int getSASeed() {
        return this.saSeed;
    }

    public void setSASeed(int saSeed) {
        this.saSeed = saSeed;
    }

    public void setDiagonalOffset(boolean b) {
        this.diagonalOffset = b;
    }

    public boolean hasDiagonalOffset() {
        return this.diagonalOffset;
    }
}

