/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.gtk.gl;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.gtk.JitteredContinuousRangeToNumericMapper;
import com.sas.graphics.applets.statgraph.sgchart.gtk.JitteredStringToNumericMapper;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVector;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.HashMap;

public final class OutlierLabelLayout
extends PropertyContainer {
    public final StringProperty labelIn = new StringProperty((PropertyContainer)this, true);
    public final NumericProperty referenceValue = new NumericProperty((PropertyContainer)this, true);
    private NumericVector xPos = new NumericVector();
    private NumericVector yPos = new NumericVector();
    private StringVector outLab = new StringVector();
    private IntegerVector justify = new IntegerVector();
    public final NumericPipe x = this.xPos;
    public final NumericPipe y = this.yPos;
    public final StringPipe label = this.outLab;
    public final IntegerPipe justification = this.justify;
    private double xLowerLimit;
    private double xUpperLimit;
    private double yLowerLimit;
    private double yUpperLimit;
    private FontMetrics fm;
    private NumericMapper xMapper;
    private ContinuousRangeToNumericMapper yMapper;
    private boolean vertical = true;
    private boolean rotateLabels = false;
    private boolean jitter = false;
    private int outlierSize = 10;
    private boolean initialized = false;
    private int valueCount;
    private int nBox;
    private int[] look_up;
    private ArrayList[] sortedOutliers;
    private HashMap[] outliersMap;
    private HashMap[] labelWidthMap;
    private HashMap[] labelHeightMap;
    private double[] refVals;
    private double[] minJitter;
    private double[] maxJitter;

    public OutlierLabelLayout(double xLowerLimit, double xUpperLimit, double yLowerLimit, double yUpperLimit) {
        this.xLowerLimit = xLowerLimit;
        this.xUpperLimit = xUpperLimit;
        this.yLowerLimit = yLowerLimit;
        this.yUpperLimit = yUpperLimit;
    }

    public void init(AInitAction initAction) {
        int i;
        if (initAction.beenInitialized((PropertyContainer)this)) {
            return;
        }
        initAction.pushValueCount();
        this.labelIn.init(initAction);
        if (this.xMapper instanceof StringToNumericMapper) {
            ((StringToNumericMapper)this.xMapper).input.init(initAction);
        } else {
            ((ContinuousRangeToNumericMapper)this.xMapper).input.init(initAction);
        }
        this.yMapper.input.init(initAction);
        this.valueCount = initAction.getValueCount();
        initAction.popValueCount();
        ArrayList<Object> uniqueX = new ArrayList<Object>();
        this.look_up = new int[this.valueCount];
        for (i = 0; i < this.valueCount; ++i) {
            try {
                Object obj = this.xMapper instanceof StringToNumericMapper ? ((StringToNumericMapper)this.xMapper).input.getValue(i) : new Double(((ContinuousRangeToNumericMapper)this.xMapper).input.getValue(i));
                int idx = uniqueX.indexOf(obj);
                if (idx < 0) {
                    idx = uniqueX.size();
                    uniqueX.add(obj);
                }
                this.look_up[i] = idx;
                continue;
            }
            catch (MissingValueException obj) {
                // empty catch block
            }
        }
        this.nBox = uniqueX.size();
        this.sortedOutliers = new ArrayList[this.nBox];
        this.outliersMap = new HashMap[this.nBox];
        if (this.jitter) {
            this.minJitter = new double[this.nBox];
            this.maxJitter = new double[this.nBox];
        }
        for (i = 0; i < this.nBox; ++i) {
            this.sortedOutliers[i] = new ArrayList();
            this.outliersMap[i] = new HashMap();
        }
        if (!this.vertical && !this.rotateLabels) {
            this.labelWidthMap = new HashMap[this.nBox];
            for (i = 0; i < this.nBox; ++i) {
                this.labelWidthMap[i] = new HashMap();
            }
        }
        this.labelHeightMap = new HashMap[this.nBox];
        for (i = 0; i < this.nBox; ++i) {
            this.labelHeightMap[i] = new HashMap();
        }
        this.refVals = new double[this.nBox];
        for (i = 0; i < this.valueCount; ++i) {
            try {
                double j;
                double y = this.yMapper.input.getValue(i);
                int xIdx = this.look_up[i];
                this.refVals[xIdx] = this.referenceValue.getValue(i);
                if (this.labelIn.getValue(i).trim().length() > 0) {
                    this.binarySearch(this.sortedOutliers[xIdx], y);
                    Double obj = new Double(y);
                    int n = 1;
                    if (this.outliersMap[xIdx].containsKey(obj)) {
                        n = (Integer)this.outliersMap[xIdx].get(obj);
                        ++n;
                    }
                    this.outliersMap[xIdx].put(obj, new Integer(n));
                    String str = this.labelIn.getValue(i).trim();
                    int h = Overlay.getTextHeight(this.fm, str);
                    ArrayList al = this.labelHeightMap[xIdx].containsKey(obj) ? (ArrayList)this.labelHeightMap[xIdx].get(obj) : new ArrayList();
                    al.add(new Integer(h));
                    this.labelHeightMap[xIdx].put(obj, al);
                    if (!this.vertical && !this.rotateLabels) {
                        int w = Overlay.getTextWidth(this.fm, str);
                        if (str.length() > 0) {
                            w += this.fm.stringWidth(" ");
                        }
                        al = this.labelWidthMap[xIdx].containsKey(obj) ? (ArrayList)this.labelWidthMap[xIdx].get(obj) : new ArrayList();
                        al.add(new Integer(w));
                        this.labelWidthMap[xIdx].put(obj, al);
                    }
                }
                if (!this.jitter) continue;
                double d = j = this.xMapper instanceof JitteredStringToNumericMapper ? ((JitteredStringToNumericMapper)this.xMapper).jitter.getValue(i) : ((JitteredContinuousRangeToNumericMapper)this.xMapper).jitter.getValue(i);
                if (j < this.minJitter[xIdx]) {
                    this.minJitter[xIdx] = j;
                }
                if (!(j > this.maxJitter[xIdx])) continue;
                this.maxJitter[xIdx] = j;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.doLayout();
        this.initialized = true;
    }

    public void doLayout() {
        int i;
        this.xMapper.init(new AInitAction());
        this.yMapper.init(new AInitAction());
        double[][] mapped_y = new double[this.nBox][];
        int[][] labelPos = new int[this.nBox][];
        int[] divider = new int[this.nBox];
        for (int j = 0; j < this.nBox; ++j) {
            double w;
            int m;
            double h;
            double dist;
            double half1stLabel;
            ArrayList al;
            double y;
            Object obj;
            int i2;
            int size = this.sortedOutliers[j].size();
            mapped_y[j] = new double[size];
            labelPos[j] = new int[size];
            divider[j] = size;
            double[] prev_pos = new double[]{Double.NaN, Double.NaN};
            for (i2 = 0; i2 < size; ++i2) {
                obj = this.sortedOutliers[j].get(i2);
                y = ((Number)obj).doubleValue();
                if (y <= this.refVals[j]) continue;
                if (divider[j] > i2) {
                    divider[j] = i2;
                }
                mapped_y[j][i2] = this.yMapper.getValue(y);
                if (!(mapped_y[j][i2] > this.yLowerLimit) || !(mapped_y[j][i2] < this.yUpperLimit)) continue;
                labelPos[j][i2] = i2 % 2;
                if (this.vertical || this.rotateLabels) {
                    al = (ArrayList)this.labelHeightMap[j].get(obj);
                    half1stLabel = (double)((Integer)al.get(0)).intValue() * 0.5;
                    if (!Double.isNaN(prev_pos[i2 % 2]) && mapped_y[j][i2] - prev_pos[i2 % 2] < half1stLabel) {
                        double dist2 = mapped_y[j][i2] - prev_pos[(i2 + 1) % 2];
                        dist = mapped_y[j][i2] - prev_pos[i2 % 2];
                        if (dist2 > dist) {
                            labelPos[j][i2] = (i2 + 1) % 2;
                            if (dist2 < half1stLabel) {
                                mapped_y[j][i2] = prev_pos[(i2 + 1) % 2] + half1stLabel;
                            }
                        } else {
                            mapped_y[j][i2] = prev_pos[i2 % 2] + half1stLabel;
                        }
                    }
                    h = half1stLabel;
                    for (m = 1; m < al.size(); ++m) {
                        h += (double)((Integer)al.get(m)).intValue();
                    }
                    prev_pos[labelPos[j][i2]] = mapped_y[j][i2] + h;
                    continue;
                }
                al = (ArrayList)this.labelWidthMap[j].get(obj);
                half1stLabel = (double)((Integer)al.get(0)).intValue() * 0.5;
                if (!Double.isNaN(prev_pos[i2 % 2]) && mapped_y[j][i2] - prev_pos[i2 % 2] < half1stLabel) {
                    double dist2 = mapped_y[j][i2] - prev_pos[(i2 + 1) % 2];
                    dist = mapped_y[j][i2] - prev_pos[i2 % 2];
                    if (dist2 > dist) {
                        labelPos[j][i2] = (i2 + 1) % 2;
                        if (dist2 < half1stLabel) {
                            mapped_y[j][i2] = prev_pos[(i2 + 1) % 2] + half1stLabel;
                        }
                    } else {
                        mapped_y[j][i2] = prev_pos[i2 % 2] + half1stLabel;
                    }
                }
                w = half1stLabel;
                for (m = 1; m < al.size(); ++m) {
                    w += (double)((Integer)al.get(m)).intValue();
                }
                prev_pos[labelPos[j][i2]] = mapped_y[j][i2] + w;
            }
            if (divider[j] <= 0) continue;
            prev_pos[1] = Double.NaN;
            prev_pos[0] = Double.NaN;
            for (i2 = divider[j] - 1; i2 >= 0; --i2) {
                obj = this.sortedOutliers[j].get(i2);
                y = ((Number)obj).doubleValue();
                mapped_y[j][i2] = this.yMapper.getValue(y);
                if (!(mapped_y[j][i2] > this.yLowerLimit) || !(mapped_y[j][i2] < this.yUpperLimit)) continue;
                labelPos[j][i2] = i2 % 2;
                if (this.vertical || this.rotateLabels) {
                    al = (ArrayList)this.labelHeightMap[j].get(obj);
                    half1stLabel = (double)((Integer)al.get(0)).intValue() * 0.5;
                    if (!Double.isNaN(prev_pos[i2 % 2]) && prev_pos[i2 % 2] - mapped_y[j][i2] < half1stLabel) {
                        double dist2 = prev_pos[(i2 + 1) % 2] - mapped_y[j][i2];
                        dist = prev_pos[i2 % 2] - mapped_y[j][i2];
                        if (dist2 > dist) {
                            labelPos[j][i2] = (i2 + 1) % 2;
                            if (dist2 < half1stLabel) {
                                mapped_y[j][i2] = prev_pos[(i2 + 1) % 2] - half1stLabel;
                            }
                        } else {
                            mapped_y[j][i2] = prev_pos[i2 % 2] - half1stLabel;
                        }
                    }
                    h = half1stLabel;
                    for (m = 1; m < al.size(); ++m) {
                        h += (double)((Integer)al.get(m)).intValue();
                    }
                    prev_pos[labelPos[j][i2]] = mapped_y[j][i2] - h;
                    continue;
                }
                al = (ArrayList)this.labelWidthMap[j].get(obj);
                half1stLabel = (double)((Integer)al.get(0)).intValue() * 0.5;
                if (!Double.isNaN(prev_pos[i2 % 2]) && prev_pos[i2 % 2] - mapped_y[j][i2] < half1stLabel) {
                    double dist2 = prev_pos[(i2 + 1) % 2] - mapped_y[j][i2];
                    dist = prev_pos[i2 % 2] - mapped_y[j][i2];
                    if (dist2 > dist) {
                        labelPos[j][i2] = (i2 + 1) % 2;
                        if (dist2 < half1stLabel) {
                            mapped_y[j][i2] = prev_pos[(i2 + 1) % 2] - half1stLabel;
                        }
                    } else {
                        mapped_y[j][i2] = prev_pos[i2 % 2] - half1stLabel;
                    }
                }
                w = half1stLabel;
                for (m = 1; m < al.size(); ++m) {
                    w += (double)((Integer)al.get(m)).intValue();
                }
                prev_pos[labelPos[j][i2]] = mapped_y[j][i2] - w;
            }
        }
        HashMap[] backup = new HashMap[this.nBox];
        for (int i3 = 0; i3 < this.nBox; ++i3) {
            backup[i3] = new HashMap();
        }
        int count = 0;
        for (i = 0; i < this.valueCount; ++i) {
            try {
                double x_pos;
                boolean even;
                block73: {
                    if (this.labelIn.getValue(i).trim().length() <= 0) continue;
                    double y = this.yMapper.input.getValue(i);
                    Double obj = new Double(y);
                    int xIdx = this.look_up[i];
                    int yIdx = this.sortedOutliers[xIdx].indexOf(obj);
                    int n = ((Number)this.outliersMap[xIdx].get(obj)).intValue();
                    double y_pos = Double.NaN;
                    if (this.yMapper.getValue(i) > this.yLowerLimit && this.yMapper.getValue(i) < this.yUpperLimit) {
                        int m;
                        y_pos = mapped_y[xIdx][yIdx];
                        if (this.vertical || this.rotateLabels) {
                            ArrayList al = (ArrayList)this.labelHeightMap[xIdx].get(obj);
                            double offset = 0.0;
                            int numSkippedLabels = al.size() - n;
                            if (numSkippedLabels > 0) {
                                offset += (double)((Integer)al.get(0)).intValue() * 0.5;
                                for (m = 1; m < numSkippedLabels; ++m) {
                                    offset += (double)((Integer)al.get(m)).intValue();
                                }
                                offset += (double)((Integer)al.get(numSkippedLabels)).intValue() * 0.5;
                            }
                            if (yIdx >= divider[xIdx]) {
                                y_pos += offset;
                                y_pos = Math.min(y_pos, this.yUpperLimit - 0.5 * (double)((Integer)al.get(numSkippedLabels)).intValue());
                            } else {
                                y_pos -= offset;
                                y_pos = Math.max(y_pos, this.yLowerLimit + 0.5 * (double)((Integer)al.get(numSkippedLabels)).intValue());
                            }
                        } else {
                            ArrayList al = (ArrayList)this.labelWidthMap[xIdx].get(obj);
                            double offset = 0.0;
                            int numSkippedLabels = al.size() - n;
                            if (numSkippedLabels > 0) {
                                offset += (double)((Integer)al.get(0)).intValue() * 0.5;
                                for (m = 1; m < numSkippedLabels; ++m) {
                                    offset += (double)((Integer)al.get(m)).intValue();
                                }
                                offset += (double)((Integer)al.get(numSkippedLabels)).intValue() * 0.5;
                            }
                            if (yIdx >= divider[xIdx]) {
                                y_pos += offset;
                                y_pos = Math.min(y_pos, this.yUpperLimit - 0.5 * (double)((Integer)al.get(numSkippedLabels)).intValue());
                            } else {
                                y_pos -= offset;
                                y_pos = Math.max(y_pos, this.yLowerLimit + 0.5 * (double)((Integer)al.get(numSkippedLabels)).intValue());
                            }
                        }
                    }
                    if (!this.initialized) {
                        this.yPos.addValue(y_pos);
                    } else {
                        this.yPos.setValueAt(y_pos, count);
                    }
                    if (--n > 0) {
                        if (!backup[xIdx].containsKey(obj)) {
                            backup[xIdx].put(obj, this.outliersMap[xIdx].get(obj));
                        }
                        this.outliersMap[xIdx].put(obj, new Integer(n));
                    }
                    even = divider[xIdx] % 2 == 0 ? labelPos[xIdx][yIdx] == 0 : labelPos[xIdx][yIdx] != 0;
                    x_pos = Double.NaN;
                    if (this.xMapper instanceof StringToNumericMapper) {
                        try {
                            if (this.jitter) {
                                x_pos = even ? ((JitteredStringToNumericMapper)this.xMapper).getValue(i, this.maxJitter[xIdx]) : ((JitteredStringToNumericMapper)this.xMapper).getValue(i, this.minJitter[xIdx]);
                                break block73;
                            }
                            x_pos = ((StringToNumericMapper)this.xMapper).getValue(i);
                        }
                        catch (MissingValueException numSkippedLabels) {}
                    } else {
                        try {
                            if (this.xMapper.getValue(i) > this.xLowerLimit && this.xMapper.getValue(i) < this.xUpperLimit) {
                                x_pos = this.jitter ? (even ? ((JitteredContinuousRangeToNumericMapper)this.xMapper).getValue(i, this.maxJitter[xIdx]) : ((JitteredContinuousRangeToNumericMapper)this.xMapper).getValue(i, this.minJitter[xIdx])) : ((ContinuousRangeToNumericMapper)this.xMapper).getValue(i);
                            }
                        }
                        catch (MissingValueException numSkippedLabels) {
                            // empty catch block
                        }
                    }
                }
                if (!Double.isNaN(x_pos)) {
                    x_pos = even ? (x_pos += (double)this.outlierSize * 0.5 + (double)((int)Math.round(4.0 * StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor))) : (x_pos -= (double)this.outlierSize * 0.5 + (double)((int)Math.round(4.0 * StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor)));
                }
                if (!this.initialized) {
                    this.xPos.addValue(x_pos);
                } else {
                    this.xPos.setValueAt(x_pos, count);
                }
                String str = this.labelIn.getValue(i);
                if (!this.initialized) {
                    this.outLab.addValue(str);
                } else {
                    this.outLab.setValueAt(str, count);
                }
                if (even) {
                    if (this.vertical) {
                        if (!this.initialized) {
                            this.justify.addValue(0);
                        } else {
                            this.justify.setValueAt(0, count);
                        }
                    } else if (!this.initialized) {
                        this.justify.addValue(3);
                    } else {
                        this.justify.setValueAt(3, count);
                    }
                } else if (this.vertical) {
                    if (!this.initialized) {
                        this.justify.addValue(2);
                    } else {
                        this.justify.setValueAt(2, count);
                    }
                } else if (!this.initialized) {
                    this.justify.addValue(0);
                } else {
                    this.justify.setValueAt(0, count);
                }
                ++count;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        for (i = 0; i < this.nBox; ++i) {
            this.outliersMap[i].putAll(backup[i]);
        }
    }

    public void setXMapper(NumericMapper aMapper) {
        this.xMapper = aMapper;
    }

    public void setYMapper(ContinuousRangeToNumericMapper aMapper) {
        this.yMapper = aMapper;
    }

    public void setFontMetrics(FontMetrics fontMetrics) {
        this.fm = fontMetrics;
    }

    public void setVertical(boolean b) {
        this.vertical = b;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setJitter(boolean b) {
        this.jitter = b;
    }

    public boolean isJitter() {
        return this.jitter;
    }

    public void setOutlierSize(int s) {
        this.outlierSize = s;
    }

    public int getOutlierSize() {
        return this.outlierSize;
    }

    public int getLabelCount() {
        return this.outLab.getValueCount();
    }

    private void binarySearch(ArrayList values, double v) {
        Double obj = new Double(v);
        int size = values.size();
        if (size == 0) {
            values.add(obj);
        } else {
            double mid_v;
            int left = 0;
            int right = size - 1;
            do {
                int i;
                if (v < (mid_v = ((Number)values.get(i = (left + right) / 2)).doubleValue())) {
                    right = i - 1;
                    continue;
                }
                left = i + 1;
            } while (v != mid_v && left <= right);
            if (v != mid_v) {
                int index = Math.max(left, right);
                values.add(index, obj);
            }
        }
    }
}

