/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.gtk.gl;

import com.sas.graphics.applets.statgraph.sgchart.gtk.AEllipse;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;

public class Ellipse
extends AEllipse {
    public Ellipse() {
        super((ATransform)new Transform());
    }

    public static void drawEllipse(Channel channel, double xRadius, double yRadius, double angle, Color color, Color edgeColor, float lineWidth, int stipplePattern, int stippleFactor, boolean edgeOn, boolean fillOn, int precision) {
        double ry;
        double rx;
        double y;
        double x;
        double theta;
        int i;
        int numOfPoints = precision;
        channel.glPushAttrib(0);
        if (fillOn) {
            channel.glColor(color);
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            for (i = 0; i < numOfPoints; ++i) {
                theta = Math.PI * 2 * (double)i / (double)(numOfPoints - 1);
                x = xRadius * Math.cos(theta);
                y = yRadius * Math.sin(theta);
                if (angle != 0.0) {
                    rx = Math.cos(angle) * x - Math.sin(angle) * y;
                    ry = Math.sin(angle) * x + Math.cos(angle) * y;
                    x = rx;
                    y = ry;
                }
                channel.glVertex(x, y, 0.0);
            }
            channel.glEnd();
        }
        if (edgeOn) {
            channel.glColor(edgeColor);
            channel.glLineWidth(lineWidth);
            if (stippleFactor > 0) {
                channel.glEnable(6);
                channel.glLineStipple(stippleFactor, (int)((short)stipplePattern));
            }
            channel.glBegin(1);
            channel.glNormal(0.0, 0.0, 1.0);
            for (i = 0; i < numOfPoints; ++i) {
                theta = Math.PI * 2 * (double)i / (double)(numOfPoints - 1);
                x = xRadius * Math.cos(theta);
                y = yRadius * Math.sin(theta);
                if (angle != 0.0) {
                    rx = Math.cos(angle) * x - Math.sin(angle) * y;
                    ry = Math.sin(angle) * x + Math.cos(angle) * y;
                    x = rx;
                    y = ry;
                }
                channel.glVertex(x, y, 0.0);
            }
            channel.glEnd();
            if (stippleFactor > 0) {
                channel.glDisable(6);
            }
        }
        channel.glPopAttrib();
    }

    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        int index = ba.getValueIndex();
        Ellipse.drawEllipse(ba.getChannel(), this.xRadius.getValue(index), this.yRadius.getValue(index), this.angle.getValue(index), this.color.getValue(index), this.edgeColor.getValue(index), (float)this.lineWidth.getValue(index), this.getStipplePattern(), this.getStippleFactor(), this.edgeOn.getValue(index), this.fillOn.getValue(index), this.precision.getValue(index));
    }
}

