/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.gtk.gl;

import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.CurveLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.labeling.CurveGraph;
import com.sas.graphics.applets.statgraph.sgchart.labeling.CurveNode;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.PropertyContainer;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;

public final class CurveLabelLayoutManager {
    ArrayList layouts = new ArrayList();
    CurveGraph cg;
    Rectangle clipBounds;
    Rectangle dataBounds;
    public boolean xRotated = false;
    public boolean x2Rotated = false;
    Insets innerMargin;

    public CurveLabelLayoutManager(Rectangle bounds, Rectangle dataArea) {
        this.clipBounds = bounds;
        this.dataBounds = dataArea;
    }

    public CurveGraph getCurveGraph() {
        return this.cg;
    }

    public void addLayout(CurveLabelLayout layout) {
        this.layouts.add(layout);
        layout.setLayoutManager(this);
    }

    public void init(CurveLabelLayout layout, AInitAction initAction) {
        int vc = 0;
        boolean beenInitialized = true;
        for (int i = 0; i < this.layouts.size(); ++i) {
            CurveLabelLayout l = (CurveLabelLayout)((Object)this.layouts.get(i));
            initAction.pushValueCount();
            l.x.init(initAction);
            l.y.init(initAction);
            l.label.init(initAction);
            vc = initAction.getValueCount();
            l.setValueCount(vc);
            initAction.popValueCount();
            beenInitialized &= initAction.beenInitialized((PropertyContainer)l);
        }
        if (beenInitialized) {
            return;
        }
        this.cg = new CurveGraph(this.clipBounds, this.dataBounds, this.innerMargin, this.xRotated, this.x2Rotated);
        int offset = 0;
        for (int i = 0; i < this.layouts.size(); ++i) {
            CurveLabelLayout l = (CurveLabelLayout)((Object)this.layouts.get(i));
            for (int j = 0; j < l.getValueCount(); ++j) {
                double xpos = -1.7976931348623157E308;
                double ypos = -1.7976931348623157E308;
                Color c = Color.black;
                int axis = 3;
                try {
                    xpos = l.x.getValue(j);
                    ypos = l.y.getValue(j);
                    String str = " " + l.label.getValue(j).trim() + " ";
                    c = l.color.getValue(j);
                    axis = l.closestAxis.getValue(j);
                    this.cg.addNode(j, str, (int)xpos, (int)ypos, c, l.getLocation(), l.getPosition(), l.getFontMetrics(), l.isExtended(), axis);
                    continue;
                }
                catch (MissingValueException e) {
                    if (xpos == -1.7976931348623157E308 || ypos == -1.7976931348623157E308) {
                        this.cg.addNode(j, null, -1, -1, null, l.getLocation(), l.getPosition(), null, l.isExtended(), axis);
                        continue;
                    }
                    this.cg.addNode(j, " ", (int)xpos, (int)ypos, c, l.getLocation(), l.getPosition(), l.getFontMetrics(), l.isExtended(), axis);
                }
            }
            l.setIndexOffset(offset);
            offset += l.getValueCount();
        }
        this.cg.layoutLabels();
    }

    public int getAlignValue(int i, CurveLabelLayout layout, boolean v) {
        CurveNode n;
        try {
            n = this.cg.getNode(i + layout.getIndexOffset());
        }
        catch (Exception e) {
            return -1;
        }
        if (n.text == null || n.text.trim().length() == 0) {
            return -1;
        }
        int align = v ? n.out_valign : n.out_halign;
        return align;
    }

    public String getLabelValue(int i, CurveLabelLayout layout) {
        CurveNode n;
        try {
            n = this.cg.getNode(i + layout.getIndexOffset());
        }
        catch (Exception e) {
            return null;
        }
        if (n.text == null || n.text.trim().length() == 0) {
            return null;
        }
        return n.text;
    }

    public double getPositionValue(int i, CurveLabelLayout layout, boolean v) {
        double value;
        CurveNode n;
        try {
            n = this.cg.getNode(i + layout.getIndexOffset());
            value = v ? (double)n.out_y : (double)n.out_x;
        }
        catch (Exception e) {
            return Double.NaN;
        }
        if (n.text == null || n.text.trim().length() == 0) {
            return Double.NaN;
        }
        return value;
    }

    public Color getColorValue(int i, CurveLabelLayout layout) {
        Color value;
        CurveNode n;
        try {
            n = this.cg.getNode(i + layout.getIndexOffset());
            value = n.out_color;
        }
        catch (Exception e) {
            return Color.black;
        }
        if (n.text == null || n.text.trim().length() == 0) {
            return Color.black;
        }
        return value;
    }

    public double getAngleValue(int i, CurveLabelLayout layout) {
        double value;
        CurveNode n;
        try {
            n = this.cg.getNode(i + layout.getIndexOffset());
            value = n.rotated ? CurveGraph.rotationAngle : 0.0;
        }
        catch (Exception e) {
            return 0.0;
        }
        if (n.text == null || n.text.trim().length() == 0) {
            return 0.0;
        }
        return value;
    }

    public void updateLabelBounds(Rectangle bounds, Rectangle dataArea) {
        this.clipBounds = bounds;
        this.dataBounds = dataArea;
    }

    public void setInnerMargin(Insets margin) {
        this.innerMargin = margin;
    }
}

