/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.gtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.PropertyContainer;

public abstract class AEllipse
extends Element {
    public final NumericProperty xRadius = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty yRadius = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty angle = new NumericProperty((PropertyContainer)this, true);
    public final ColorProperty color = new ColorProperty((PropertyContainer)this, true);
    public final ColorProperty edgeColor = new ColorProperty((PropertyContainer)this, true);
    public final BooleanProperty edgeOn = new BooleanProperty((PropertyContainer)this, true);
    public final BooleanProperty fillOn = new BooleanProperty((PropertyContainer)this, true);
    public final IntegerProperty precision = new IntegerProperty((PropertyContainer)this, true);
    public final NumericProperty lineWidth = new NumericProperty((PropertyContainer)this, true);
    protected int stipplePattern;
    protected int stippleFactor;

    public AEllipse(ATransform transform) {
        super(transform);
        this.precision.setValue(16);
        this.xRadius.setValue(1.0);
        this.yRadius.setValue(1.0);
        this.angle.setValue(0.0);
        this.edgeOn.setValue(true);
        this.fillOn.setValue(false);
    }

    public void setStipple(int pattern, int factor) {
        this.stipplePattern = pattern;
        this.stippleFactor = factor;
    }

    public int getStipplePattern() {
        return this.stipplePattern;
    }

    public int getStippleFactor() {
        return this.stippleFactor;
    }

    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        Vec3d size = bBoxAction.pt1;
        Vec3d center = bBoxAction.pt2;
        double xrad = this.xRadius.getValue(index);
        double yrad = this.yRadius.getValue(index);
        size.set(xrad * 2.0, yrad * 2.0, 0.0);
        center.set(0.0, 0.0, 0.0);
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(center, size);
    }
}

